/*
 * Decompiled with CFR 0.152.
 */
package v;

import java.io.InputStream;
import java.math.BigInteger;
import java.security.CodeSigner;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Verify {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verify(String apkPath) throws Exception {
        JarFile apk = new JarFile(apkPath, true);
        byte[] buffer = new byte[16384];
        InputStream input = null;
        boolean allEntriesUnsigned = true;
        Enumeration<JarEntry> entries = apk.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            try {
                input = apk.getInputStream(entry);
                while (input.read(buffer) != -1) {
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
            CodeSigner[] codeSigners = entry.getCodeSigners();
            if (codeSigners == null) continue;
            allEntriesUnsigned = false;
            for (CodeSigner signer : codeSigners) {
                for (Certificate certificate : signer.getSignerCertPath().getCertificates()) {
                    byte[] md5 = MessageDigest.getInstance("md5").digest(certificate.getEncoded());
                    String hex = String.format("%x", new BigInteger(1, md5));
                    if (hex.contentEquals("e89b158e4bcf988ebd09eb83f5378e87")) continue;
                    apk.close();
                    throw new Exception("Invalid cert.");
                }
            }
        }
        if (allEntriesUnsigned) {
            apk.close();
            throw new Exception("No cert. APK is not signed.");
        }
        apk.close();
    }

    public static void main(String[] args) throws Exception {
        Verify.verify(args[0]);
    }
}

