/*
 * Decompiled with CFR 0.152.
 */
package unsign;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import unsign.Utils;

public class MoveManifest {
    private static final byte[] BUFFER = new byte[0x100000];

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        while ((n = inputStream.read(BUFFER)) != -1) {
            outputStream.write(BUFFER, 0, n);
        }
    }

    public static void moveManifest(String string, String string2) {
        ZipInputStream zipInputStream = null;
        ZipOutputStream zipOutputStream = null;
        File file = null;
        File file2 = null;
        File file3 = null;
        try {
            file3 = new File(string2);
            String string3 = file3.getName();
            if (!file3.isFile()) {
                throw new RuntimeException("manifest file does not exist: " + file3.getAbsolutePath());
            }
            file = new File(string);
            file2 = new File(file.getParentFile(), new Date().getTime() + ".tmp");
            if (!file.renameTo(file2)) {
                try {
                    Utils.transferFile(file, file2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new RuntimeException("Unable to rename " + file);
                }
            }
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            zipInputStream = new ZipInputStream(new FileInputStream(file2));
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string4 = zipEntry.getName();
                if (string4.indexOf(string3) >= 0) continue;
                zipOutputStream.putNextEntry(new ZipEntry(string4));
                if (!zipEntry.isDirectory()) {
                    MoveManifest.copyStream(zipInputStream, zipOutputStream);
                }
                zipOutputStream.closeEntry();
            }
            zipOutputStream.putNextEntry(new ZipEntry(string3));
            MoveManifest.copyStream(new FileInputStream(file3), zipOutputStream);
            zipOutputStream.closeEntry();
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                throw new RuntimeException("Unable to move new manifest " + file3.getAbsolutePath() + " into zip " + file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                Utils.close(zipInputStream);
                Utils.close(zipOutputStream);
                throw throwable;
            }
        }
        Utils.close(zipInputStream);
        Utils.close(zipOutputStream);
        Utils.delete(file2);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.err.println("usage: java -jar move_manifest.jar apk-file manifest-file");
            System.exit(1);
        }
        MoveManifest.moveManifest(stringArray[0], stringArray[1]);
    }
}

