# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
# pylint: skip-file

from azure.core.configuration import Configuration, ConnectionConfiguration
from azure.core.pipeline import policies

from .version import VERSION


class AzureFileStorageConfiguration(Configuration):
    """Configuration for AzureFileStorage
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param version: Specifies the version of the operation to use for this
     request.
    :type version: str
    :param url: The URL of the service account, share, directory or file that
     is the target of the desired operation.
    :type url: str
    """

    def __init__(self, version, url, **kwargs):

        if version is None:
            raise ValueError("Parameter 'version' must not be None.")
        if url is None:
            raise ValueError("Parameter 'url' must not be None.")

        super(AzureFileStorageConfiguration, self).__init__(**kwargs)
        self._configure(**kwargs)

        self.user_agent_policy.add_user_agent('azurefilestorage/{}'.format(VERSION))
        self.generate_client_request_id = True
        self.accept_language = None

        self.version = version
        self.url = url

    def _configure(self, **kwargs):
        self.connection = ConnectionConfiguration(**kwargs)
        self.user_agent_policy = policies.UserAgentPolicy(**kwargs)
        self.headers_policy = policies.HeadersPolicy(**kwargs)
        self.proxy_policy = policies.ProxyPolicy(**kwargs)
        self.logging_policy = policies.NetworkTraceLoggingPolicy(**kwargs)
        self.retry_policy = policies.RetryPolicy(**kwargs)
        self.custom_hook_policy = policies.CustomHookPolicy(**kwargs)
        self.redirect_policy = policies.RedirectPolicy(**kwargs)
