# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .virtual_machine_image_resource import VirtualMachineImageResource


class VirtualMachineImage(VirtualMachineImageResource):
    """
    Describes a Virtual Machine Image.

    :param id: Resource Id
    :type id: str
    :param name: Gets or sets the name of the resource.
    :type name: str
    :param location: Gets or sets the location of the resource.
    :type location: str
    :param tags: Gets or sets the tags attached to the resource.
    :type tags: dict
    :param plan:
    :type plan: :class:`PurchasePlan <azure.mgmt.compute.models.PurchasePlan>`
    :param os_disk_image:
    :type os_disk_image: :class:`OSDiskImage
     <azure.mgmt.compute.models.OSDiskImage>`
    :param data_disk_images:
    :type data_disk_images: list of :class:`DataDiskImage
     <azure.mgmt.compute.models.DataDiskImage>`
    """ 

    _validation = {
        'name': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'properties.plan', 'type': 'PurchasePlan'},
        'os_disk_image': {'key': 'properties.osDiskImage', 'type': 'OSDiskImage'},
        'data_disk_images': {'key': 'properties.dataDiskImages', 'type': '[DataDiskImage]'},
    }

    def __init__(self, name, location, id=None, tags=None, plan=None, os_disk_image=None, data_disk_images=None, **kwargs):
        super(VirtualMachineImage, self).__init__(id=id, name=name, location=location, tags=tags, **kwargs)
        self.plan = plan
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images
