# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AdditionalUnattendContent(Model):
    """
    Gets or sets additional XML formatted information that can be included in
    the Unattend.xml file, which is used by Windows Setup. Contents are
    defined by setting name, component name, and the pass in which the
    content is a applied.

    :param pass_name: Gets or sets the pass name. Currently, the only
     allowable value is oobeSystem. Possible values include: 'oobeSystem'
    :type pass_name: str
    :param component_name: Gets or sets the component name. Currently, the
     only allowable value is Microsoft-Windows-Shell-Setup. Possible values
     include: 'Microsoft-Windows-Shell-Setup'
    :type component_name: str
    :param setting_name: Gets or sets setting name (e.g. FirstLogonCommands,
     AutoLogon ). Possible values include: 'AutoLogon', 'FirstLogonCommands'
    :type setting_name: str
    :param content: Gets or sets XML formatted content that is added to the
     unattend.xml file in the specified pass and component.The XML must be
     less than 4 KB and must include the root element for the setting or
     feature that is being inserted.
    :type content: str
    """ 

    _attribute_map = {
        'pass_name': {'key': 'passName', 'type': 'PassNames'},
        'component_name': {'key': 'componentName', 'type': 'ComponentNames'},
        'setting_name': {'key': 'settingName', 'type': 'SettingNames'},
        'content': {'key': 'content', 'type': 'str'},
    }

    def __init__(self, pass_name=None, component_name=None, setting_name=None, content=None, **kwargs):
        self.pass_name = pass_name
        self.component_name = component_name
        self.setting_name = setting_name
        self.content = content
