# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ManagedClusterIdentity(Model):
    """Identity for the managed cluster.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: The principal id of the system assigned identity which
     is used by master components.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity which is
     used by master components.
    :vartype tenant_id: str
    :param type: The type of identity used for the managed cluster. Type
     'SystemAssigned' will use an implicitly created identity in master
     components and an auto-created user assigned identity in MC_ resource
     group in agent nodes. Type 'None' will not use MSI for the managed
     cluster, service principal will be used instead. Possible values include:
     'SystemAssigned', 'None'
    :type type: str or
     ~azure.mgmt.containerservice.v2019_04_01.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ResourceIdentityType'},
    }

    def __init__(self, **kwargs):
        super(ManagedClusterIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
