# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OrchestratorProfile(Model):
    """Contains information about orchestrator.

    All required parameters must be populated in order to send to Azure.

    :param orchestrator_type: Orchestrator type.
    :type orchestrator_type: str
    :param orchestrator_version: Required. Orchestrator version (major, minor,
     patch).
    :type orchestrator_version: str
    :param is_preview: Whether Kubernetes version is currently in preview.
    :type is_preview: bool
    """

    _validation = {
        'orchestrator_version': {'required': True},
    }

    _attribute_map = {
        'orchestrator_type': {'key': 'orchestratorType', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(self, *, orchestrator_version: str, orchestrator_type: str=None, is_preview: bool=None, **kwargs) -> None:
        super(OrchestratorProfile, self).__init__(**kwargs)
        self.orchestrator_type = orchestrator_type
        self.orchestrator_version = orchestrator_version
        self.is_preview = is_preview
