# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import AttestationManagementClientConfiguration
from .operations import Operations
from .operations import AttestationProvidersOperations
from .operations import PrivateEndpointConnectionsOperations
from . import models


class AttestationManagementClient(SDKClient):
    """Various APIs for managing resources in attestation service. This primarily encompasses per-provider management.

    :ivar config: Configuration for client.
    :vartype config: AttestationManagementClientConfiguration

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.attestation.operations.Operations
    :ivar attestation_providers: AttestationProviders operations
    :vartype attestation_providers: azure.mgmt.attestation.operations.AttestationProvidersOperations
    :ivar private_endpoint_connections: PrivateEndpointConnections operations
    :vartype private_endpoint_connections: azure.mgmt.attestation.operations.PrivateEndpointConnectionsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = AttestationManagementClientConfiguration(credentials, subscription_id, base_url)
        super(AttestationManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2020-10-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self.config, self._serialize, self._deserialize)
        self.attestation_providers = AttestationProvidersOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
