# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AttestationCertificateManagementBody(msrest.serialization.Model):
    """The body of the JWT used for the PolicyCertificates APIs.

    :param policy_certificate: RFC 7517 Json Web Key describing the certificate.
    :type policy_certificate: ~azure.security.attestation._generated.models.JSONWebKey
    """

    _attribute_map = {
        'policy_certificate': {'key': 'policyCertificate', 'type': 'JSONWebKey'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttestationCertificateManagementBody, self).__init__(**kwargs)
        self.policy_certificate = kwargs.get('policy_certificate', None)


class AttestationResponse(msrest.serialization.Model):
    """The result of an attestation operation.

    :param token: An RFC 7519 JSON Web Token, the body of which is an AttestationResult object.
    :type token: str
    """

    _validation = {
        'token': {'pattern': r'[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*'},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttestationResponse, self).__init__(**kwargs)
        self.token = kwargs.get('token', None)


class AttestationResult(msrest.serialization.Model):
    """A Microsoft Azure Attestation response token body - the body of a response token issued by MAA.

    :param jti: Unique Identifier for the token.
    :type jti: str
    :param iss: The Principal who issued the token.
    :type iss: str
    :param iat: The time at which the token was issued, in the number of seconds since
     1970-01-0T00:00:00Z UTC.
    :type iat: float
    :param exp: The expiration time after which the token is no longer valid, in the number of
     seconds since 1970-01-0T00:00:00Z UTC.
    :type exp: float
    :param nbf: The not before time before which the token cannot be considered valid, in the
     number of seconds since 1970-01-0T00:00:00Z UTC.
    :type nbf: float
    :param cnf: An RFC 7800 Proof of Possession Key.
    :type cnf: object
    :param nonce: The Nonce input to the attestation request, if provided.
    :type nonce: str
    :param version: The Schema version of this structure. Current Value: 1.0.
    :type version: str
    :param runtime_claims: Runtime Claims.
    :type runtime_claims: object
    :param inittime_claims: Inittime Claims.
    :type inittime_claims: object
    :param policy_claims: Policy Generated Claims.
    :type policy_claims: object
    :param verifier_type: The Attestation type being attested.
    :type verifier_type: str
    :param policy_signer: The certificate used to sign the policy object, if specified.
    :type policy_signer: ~azure.security.attestation._generated.models.JSONWebKey
    :param policy_hash: The SHA256 hash of the BASE64URL encoded policy text used for attestation.
    :type policy_hash: bytes
    :param is_debuggable: True if the enclave is debuggable, false otherwise.
    :type is_debuggable: bool
    :param product_id: The SGX Product ID for the enclave.
    :type product_id: float
    :param mr_enclave: The HEX encoded SGX MRENCLAVE value for the enclave.
    :type mr_enclave: str
    :param mr_signer: The HEX encoded SGX MRSIGNER value for the enclave.
    :type mr_signer: str
    :param svn: The SGX SVN value for the enclave.
    :type svn: float
    :param enclave_held_data: A copy of the RuntimeData specified as an input to the attest call.
    :type enclave_held_data: bytes
    :param sgx_collateral: The SGX SVN value for the enclave.
    :type sgx_collateral: object
    :param deprecated_version: DEPRECATED: Private Preview version of x-ms-ver claim.
    :type deprecated_version: str
    :param deprecated_is_debuggable: DEPRECATED: Private Preview version of x-ms-sgx-is-debuggable
     claim.
    :type deprecated_is_debuggable: bool
    :param deprecated_sgx_collateral: DEPRECATED: Private Preview version of x-ms-sgx-collateral
     claim.
    :type deprecated_sgx_collateral: object
    :param deprecated_enclave_held_data: DEPRECATED: Private Preview version of x-ms-sgx-ehd claim.
    :type deprecated_enclave_held_data: bytes
    :param deprecated_enclave_held_data2: DEPRECATED: Private Preview version of x-ms-sgx-ehd
     claim.
    :type deprecated_enclave_held_data2: bytes
    :param deprecated_product_id: DEPRECATED: Private Preview version of x-ms-sgx-product-id.
    :type deprecated_product_id: float
    :param deprecated_mr_enclave: DEPRECATED: Private Preview version of x-ms-sgx-mrenclave.
    :type deprecated_mr_enclave: str
    :param deprecated_mr_signer: DEPRECATED: Private Preview version of x-ms-sgx-mrsigner.
    :type deprecated_mr_signer: str
    :param deprecated_svn: DEPRECATED: Private Preview version of x-ms-sgx-svn.
    :type deprecated_svn: float
    :param deprecated_tee: DEPRECATED: Private Preview version of x-ms-tee.
    :type deprecated_tee: str
    :param deprecated_policy_signer: DEPRECATED: Private Preview version of x-ms-policy-signer.
    :type deprecated_policy_signer: ~azure.security.attestation._generated.models.JSONWebKey
    :param deprecated_policy_hash: DEPRECATED: Private Preview version of x-ms-policy-hash.
    :type deprecated_policy_hash: bytes
    :param deprecated_rp_data: DEPRECATED: Private Preview version of nonce.
    :type deprecated_rp_data: str
    """

    _attribute_map = {
        'jti': {'key': 'jti', 'type': 'str'},
        'iss': {'key': 'iss', 'type': 'str'},
        'iat': {'key': 'iat', 'type': 'float'},
        'exp': {'key': 'exp', 'type': 'float'},
        'nbf': {'key': 'nbf', 'type': 'float'},
        'cnf': {'key': 'cnf', 'type': 'object'},
        'nonce': {'key': 'nonce', 'type': 'str'},
        'version': {'key': 'x-ms-ver', 'type': 'str'},
        'runtime_claims': {'key': 'x-ms-runtime', 'type': 'object'},
        'inittime_claims': {'key': 'x-ms-inittime', 'type': 'object'},
        'policy_claims': {'key': 'x-ms-policy', 'type': 'object'},
        'verifier_type': {'key': 'x-ms-attestation-type', 'type': 'str'},
        'policy_signer': {'key': 'x-ms-policy-signer', 'type': 'JSONWebKey'},
        'policy_hash': {'key': 'x-ms-policy-hash', 'type': 'base64'},
        'is_debuggable': {'key': 'x-ms-sgx-is-debuggable', 'type': 'bool'},
        'product_id': {'key': 'x-ms-sgx-product-id', 'type': 'float'},
        'mr_enclave': {'key': 'x-ms-sgx-mrenclave', 'type': 'str'},
        'mr_signer': {'key': 'x-ms-sgx-mrsigner', 'type': 'str'},
        'svn': {'key': 'x-ms-sgx-svn', 'type': 'float'},
        'enclave_held_data': {'key': 'x-ms-sgx-ehd', 'type': 'base64'},
        'sgx_collateral': {'key': 'x-ms-sgx-collateral', 'type': 'object'},
        'deprecated_version': {'key': 'ver', 'type': 'str'},
        'deprecated_is_debuggable': {'key': 'is-debuggable', 'type': 'bool'},
        'deprecated_sgx_collateral': {'key': 'maa-attestationcollateral', 'type': 'object'},
        'deprecated_enclave_held_data': {'key': 'aas-ehd', 'type': 'base64'},
        'deprecated_enclave_held_data2': {'key': 'maa-ehd', 'type': 'base64'},
        'deprecated_product_id': {'key': 'product-id', 'type': 'float'},
        'deprecated_mr_enclave': {'key': 'sgx-mrenclave', 'type': 'str'},
        'deprecated_mr_signer': {'key': 'sgx-mrsigner', 'type': 'str'},
        'deprecated_svn': {'key': 'svn', 'type': 'float'},
        'deprecated_tee': {'key': 'tee', 'type': 'str'},
        'deprecated_policy_signer': {'key': 'policy_signer', 'type': 'JSONWebKey'},
        'deprecated_policy_hash': {'key': 'policy_hash', 'type': 'base64'},
        'deprecated_rp_data': {'key': 'rp_data', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttestationResult, self).__init__(**kwargs)
        self.jti = kwargs.get('jti', None)
        self.iss = kwargs.get('iss', None)
        self.iat = kwargs.get('iat', None)
        self.exp = kwargs.get('exp', None)
        self.nbf = kwargs.get('nbf', None)
        self.cnf = kwargs.get('cnf', None)
        self.nonce = kwargs.get('nonce', None)
        self.version = kwargs.get('version', None)
        self.runtime_claims = kwargs.get('runtime_claims', None)
        self.inittime_claims = kwargs.get('inittime_claims', None)
        self.policy_claims = kwargs.get('policy_claims', None)
        self.verifier_type = kwargs.get('verifier_type', None)
        self.policy_signer = kwargs.get('policy_signer', None)
        self.policy_hash = kwargs.get('policy_hash', None)
        self.is_debuggable = kwargs.get('is_debuggable', None)
        self.product_id = kwargs.get('product_id', None)
        self.mr_enclave = kwargs.get('mr_enclave', None)
        self.mr_signer = kwargs.get('mr_signer', None)
        self.svn = kwargs.get('svn', None)
        self.enclave_held_data = kwargs.get('enclave_held_data', None)
        self.sgx_collateral = kwargs.get('sgx_collateral', None)
        self.deprecated_version = kwargs.get('deprecated_version', None)
        self.deprecated_is_debuggable = kwargs.get('deprecated_is_debuggable', None)
        self.deprecated_sgx_collateral = kwargs.get('deprecated_sgx_collateral', None)
        self.deprecated_enclave_held_data = kwargs.get('deprecated_enclave_held_data', None)
        self.deprecated_enclave_held_data2 = kwargs.get('deprecated_enclave_held_data2', None)
        self.deprecated_product_id = kwargs.get('deprecated_product_id', None)
        self.deprecated_mr_enclave = kwargs.get('deprecated_mr_enclave', None)
        self.deprecated_mr_signer = kwargs.get('deprecated_mr_signer', None)
        self.deprecated_svn = kwargs.get('deprecated_svn', None)
        self.deprecated_tee = kwargs.get('deprecated_tee', None)
        self.deprecated_policy_signer = kwargs.get('deprecated_policy_signer', None)
        self.deprecated_policy_hash = kwargs.get('deprecated_policy_hash', None)
        self.deprecated_rp_data = kwargs.get('deprecated_rp_data', None)


class AttestOpenEnclaveRequest(msrest.serialization.Model):
    """Attestation request for Intel SGX enclaves.

    :param report: OpenEnclave report from the enclave to be attested.
    :type report: bytes
    :param runtime_data: Runtime data provided by the enclave at the time of report generation. The
     MAA will verify that the first 32 bytes of the report_data field of the quote contains the
     SHA256 hash of the decoded "data" field of the runtime data.
    :type runtime_data: ~azure.security.attestation._generated.models.RuntimeData
    :param init_time_data: Base64Url encoded "InitTime data". The MAA will verify that the init
     data was known to the enclave. Note that InitTimeData is invalid for CoffeeLake processors.
    :type init_time_data: ~azure.security.attestation._generated.models.InitTimeData
    :param draft_policy_for_attestation: Attest against the provided draft policy. Note that the
     resulting token cannot be validated.
    :type draft_policy_for_attestation: str
    """

    _attribute_map = {
        'report': {'key': 'report', 'type': 'base64'},
        'runtime_data': {'key': 'runtimeData', 'type': 'RuntimeData'},
        'init_time_data': {'key': 'initTimeData', 'type': 'InitTimeData'},
        'draft_policy_for_attestation': {'key': 'draftPolicyForAttestation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttestOpenEnclaveRequest, self).__init__(**kwargs)
        self.report = kwargs.get('report', None)
        self.runtime_data = kwargs.get('runtime_data', None)
        self.init_time_data = kwargs.get('init_time_data', None)
        self.draft_policy_for_attestation = kwargs.get('draft_policy_for_attestation', None)


class AttestSgxEnclaveRequest(msrest.serialization.Model):
    """Attestation request for Intel SGX enclaves.

    :param quote: Quote of the enclave to be attested.
    :type quote: bytes
    :param runtime_data: Runtime data provided by the enclave at the time of quote generation. The
     MAA will verify that the first 32 bytes of the report_data field of the quote contains the
     SHA256 hash of the decoded "data" field of the runtime data.
    :type runtime_data: ~azure.security.attestation._generated.models.RuntimeData
    :param init_time_data: Initialization data provided when the enclave is created. MAA will
     verify that the init data was known to the enclave. Note that InitTimeData is invalid for
     CoffeeLake processors.
    :type init_time_data: ~azure.security.attestation._generated.models.InitTimeData
    :param draft_policy_for_attestation: Attest against the provided draft policy. Note that the
     resulting token cannot be validated.
    :type draft_policy_for_attestation: str
    """

    _attribute_map = {
        'quote': {'key': 'quote', 'type': 'base64'},
        'runtime_data': {'key': 'runtimeData', 'type': 'RuntimeData'},
        'init_time_data': {'key': 'initTimeData', 'type': 'InitTimeData'},
        'draft_policy_for_attestation': {'key': 'draftPolicyForAttestation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttestSgxEnclaveRequest, self).__init__(**kwargs)
        self.quote = kwargs.get('quote', None)
        self.runtime_data = kwargs.get('runtime_data', None)
        self.init_time_data = kwargs.get('init_time_data', None)
        self.draft_policy_for_attestation = kwargs.get('draft_policy_for_attestation', None)


class CloudError(msrest.serialization.Model):
    """An error response from Attestation.

    :param error: An error response from Attestation.
    :type error: ~azure.security.attestation._generated.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CloudErrorBody(msrest.serialization.Model):
    """An error response from Attestation.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for displaying in a
     user interface.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class InitTimeData(msrest.serialization.Model):
    """Defines the "initialization time data" used to provision the attestation target for use by the MAA.

    :param data: UTF-8 encoded Initialization Data passed into the trusted environment when it is
     created.
    :type data: bytes
    :param data_type: The type of data contained within the "data" field. Possible values include:
     "Binary", "JSON".
    :type data_type: str or ~azure.security.attestation._generated.models.DataType
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'base64'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InitTimeData, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.data_type = kwargs.get('data_type', None)


class JSONWebKey(msrest.serialization.Model):
    """JSONWebKey.

    All required parameters must be populated in order to send to Azure.

    :param alg: The "alg" (algorithm) parameter identifies the algorithm intended for
     use with the key.  The values used should either be registered in the
     IANA "JSON Web Signature and Encryption Algorithms" registry
     established by [JWA] or be a value that contains a Collision-
     Resistant Name.
    :type alg: str
    :param crv: The "crv" (curve) parameter identifies the curve type.
    :type crv: str
    :param d: RSA private exponent or ECC private key.
    :type d: str
    :param dp: RSA Private Key Parameter.
    :type dp: str
    :param dq: RSA Private Key Parameter.
    :type dq: str
    :param e: RSA public exponent, in Base64.
    :type e: str
    :param k: Symmetric key.
    :type k: str
    :param kid: The "kid" (key ID) parameter is used to match a specific key.  This
     is used, for instance, to choose among a set of keys within a JWK Set
     during key rollover.  The structure of the "kid" value is
     unspecified.  When "kid" values are used within a JWK Set, different
     keys within the JWK Set SHOULD use distinct "kid" values.  (One
     example in which different keys might use the same "kid" value is if
     they have different "kty" (key type) values but are considered to be
     equivalent alternatives by the application using them.)  The "kid"
     value is a case-sensitive string.
    :type kid: str
    :param kty: Required. The "kty" (key type) parameter identifies the cryptographic algorithm
     family used with the key, such as "RSA" or "EC". "kty" values should
     either be registered in the IANA "JSON Web Key Types" registry
     established by [JWA] or be a value that contains a Collision-
     Resistant Name.  The "kty" value is a case-sensitive string.
    :type kty: str
    :param n: RSA modulus, in Base64.
    :type n: str
    :param p: RSA secret prime.
    :type p: str
    :param q: RSA secret prime, with p < q.
    :type q: str
    :param qi: RSA Private Key Parameter.
    :type qi: str
    :param use: Use ("public key use") identifies the intended use of
     the public key. The "use" parameter is employed to indicate whether
     a public key is used for encrypting data or verifying the signature
     on data. Values are commonly "sig" (signature) or "enc" (encryption).
    :type use: str
    :param x: X coordinate for the Elliptic Curve point.
    :type x: str
    :param x5_c: The "x5c" (X.509 certificate chain) parameter contains a chain of one
     or more PKIX certificates [RFC5280].  The certificate chain is
     represented as a JSON array of certificate value strings.  Each
     string in the array is a base64-encoded (Section 4 of [RFC4648] --
     not base64url-encoded) DER [ITU.X690.1994] PKIX certificate value.
     The PKIX certificate containing the key value MUST be the first
     certificate.
    :type x5_c: list[str]
    :param y: Y coordinate for the Elliptic Curve point.
    :type y: str
    """

    _validation = {
        'kty': {'required': True},
    }

    _attribute_map = {
        'alg': {'key': 'alg', 'type': 'str'},
        'crv': {'key': 'crv', 'type': 'str'},
        'd': {'key': 'd', 'type': 'str'},
        'dp': {'key': 'dp', 'type': 'str'},
        'dq': {'key': 'dq', 'type': 'str'},
        'e': {'key': 'e', 'type': 'str'},
        'k': {'key': 'k', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
        'kty': {'key': 'kty', 'type': 'str'},
        'n': {'key': 'n', 'type': 'str'},
        'p': {'key': 'p', 'type': 'str'},
        'q': {'key': 'q', 'type': 'str'},
        'qi': {'key': 'qi', 'type': 'str'},
        'use': {'key': 'use', 'type': 'str'},
        'x': {'key': 'x', 'type': 'str'},
        'x5_c': {'key': 'x5c', 'type': '[str]'},
        'y': {'key': 'y', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JSONWebKey, self).__init__(**kwargs)
        self.alg = kwargs.get('alg', None)
        self.crv = kwargs.get('crv', None)
        self.d = kwargs.get('d', None)
        self.dp = kwargs.get('dp', None)
        self.dq = kwargs.get('dq', None)
        self.e = kwargs.get('e', None)
        self.k = kwargs.get('k', None)
        self.kid = kwargs.get('kid', None)
        self.kty = kwargs['kty']
        self.n = kwargs.get('n', None)
        self.p = kwargs.get('p', None)
        self.q = kwargs.get('q', None)
        self.qi = kwargs.get('qi', None)
        self.use = kwargs.get('use', None)
        self.x = kwargs.get('x', None)
        self.x5_c = kwargs.get('x5_c', None)
        self.y = kwargs.get('y', None)


class JSONWebKeySet(msrest.serialization.Model):
    """JSONWebKeySet.

    :param keys: The value of the "keys" parameter is an array of JWK values.  By
     default, the order of the JWK values within the array does not imply
     an order of preference among them, although applications of JWK Sets
     can choose to assign a meaning to the order for their purposes, if
     desired.
    :type keys: list[~azure.security.attestation._generated.models.JSONWebKey]
    """

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[JSONWebKey]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JSONWebKeySet, self).__init__(**kwargs)
        self.keys = kwargs.get('keys', None)


class PolicyCertificatesModificationResult(msrest.serialization.Model):
    """The result of a policy certificate modification.

    :param certificate_thumbprint: Hex encoded SHA1 Hash of the binary representation certificate
     which was added or removed.
    :type certificate_thumbprint: str
    :param certificate_resolution: The result of the operation. Possible values include:
     "IsPresent", "IsAbsent".
    :type certificate_resolution: str or
     ~azure.security.attestation._generated.models.CertificateModification
    """

    _attribute_map = {
        'certificate_thumbprint': {'key': 'x-ms-certificate-thumbprint', 'type': 'str'},
        'certificate_resolution': {'key': 'x-ms-policycertificates-result', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyCertificatesModificationResult, self).__init__(**kwargs)
        self.certificate_thumbprint = kwargs.get('certificate_thumbprint', None)
        self.certificate_resolution = kwargs.get('certificate_resolution', None)


class PolicyCertificatesModifyResponse(msrest.serialization.Model):
    """The response to an attestation policy management API.

    :param token: An RFC7519 JSON Web Token structure whose body is a
     PolicyCertificatesModificationResult object.
    :type token: str
    """

    _validation = {
        'token': {'pattern': r'[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*'},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyCertificatesModifyResponse, self).__init__(**kwargs)
        self.token = kwargs.get('token', None)


class PolicyCertificatesResponse(msrest.serialization.Model):
    """The response to an attestation policy management API.

    :param token: An RFC7519 JSON Web Token structure containing a PolicyCertificatesResults object
     which contains the certificates used to validate policy changes.
    :type token: str
    """

    _validation = {
        'token': {'pattern': r'[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*'},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyCertificatesResponse, self).__init__(**kwargs)
        self.token = kwargs.get('token', None)


class PolicyCertificatesResult(msrest.serialization.Model):
    """The result of a call to retrieve policy certificates.

    :param policy_certificates: SHA256 Hash of the binary representation certificate which was
     added or removed.
    :type policy_certificates: ~azure.security.attestation._generated.models.JSONWebKeySet
    """

    _attribute_map = {
        'policy_certificates': {'key': 'x-ms-policy-certificates', 'type': 'JSONWebKeySet'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyCertificatesResult, self).__init__(**kwargs)
        self.policy_certificates = kwargs.get('policy_certificates', None)


class PolicyResponse(msrest.serialization.Model):
    """The response to an attestation policy operation.

    :param token: An RFC7519 JSON Web Token structure whose body is an PolicyResult object.
    :type token: str
    """

    _validation = {
        'token': {'pattern': r'[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*'},
    }

    _attribute_map = {
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyResponse, self).__init__(**kwargs)
        self.token = kwargs.get('token', None)


class PolicyResult(msrest.serialization.Model):
    """The result of a policy certificate modification.

    :param policy_resolution: The result of the operation. Possible values include: "Updated",
     "Removed".
    :type policy_resolution: str or
     ~azure.security.attestation._generated.models.PolicyModification
    :param policy_token_hash: The SHA256 hash of the policy object modified.
    :type policy_token_hash: bytes
    :param policy_signer: The certificate used to sign the policy object, if specified.
    :type policy_signer: ~azure.security.attestation._generated.models.JSONWebKey
    :param policy: A JSON Web Token containing a StoredAttestationPolicy object with the
     attestation policy.
    :type policy: str
    """

    _validation = {
        'policy': {'pattern': r'[A-Za-z0-9_-]+\.[A-Za-z0-9_-]*\.[A-Za-z0-9_-]*'},
    }

    _attribute_map = {
        'policy_resolution': {'key': 'x-ms-policy-result', 'type': 'str'},
        'policy_token_hash': {'key': 'x-ms-policy-token-hash', 'type': 'base64'},
        'policy_signer': {'key': 'x-ms-policy-signer', 'type': 'JSONWebKey'},
        'policy': {'key': 'x-ms-policy', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyResult, self).__init__(**kwargs)
        self.policy_resolution = kwargs.get('policy_resolution', None)
        self.policy_token_hash = kwargs.get('policy_token_hash', None)
        self.policy_signer = kwargs.get('policy_signer', None)
        self.policy = kwargs.get('policy', None)


class RuntimeData(msrest.serialization.Model):
    """Defines the "run time data" provided by the attestation target for use by the MAA.

    :param data: UTF-8 encoded Runtime Data generated by the trusted environment.
    :type data: bytes
    :param data_type: The type of data contained within the "data" field. Possible values include:
     "Binary", "JSON".
    :type data_type: str or ~azure.security.attestation._generated.models.DataType
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'base64'},
        'data_type': {'key': 'dataType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuntimeData, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
        self.data_type = kwargs.get('data_type', None)


class StoredAttestationPolicy(msrest.serialization.Model):
    """StoredAttestationPolicy.

    :param attestation_policy: Policy text to set as a sequence of UTF-8 encoded octets.
    :type attestation_policy: bytes
    """

    _attribute_map = {
        'attestation_policy': {'key': 'AttestationPolicy', 'type': 'base64'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StoredAttestationPolicy, self).__init__(**kwargs)
        self.attestation_policy = kwargs.get('attestation_policy', None)


class TpmAttestationRequest(msrest.serialization.Model):
    """Attestation request for Trusted Platform Module (TPM) attestation.

    :param data: Protocol data containing artifacts for attestation.
    :type data: bytes
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'base64'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TpmAttestationRequest, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)


class TpmAttestationResponse(msrest.serialization.Model):
    """Attestation response for Trusted Platform Module (TPM) attestation.

    :param data: Protocol data containing attestation service response.
    :type data: bytes
    """

    _attribute_map = {
        'data': {'key': 'data', 'type': 'base64'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TpmAttestationResponse, self).__init__(**kwargs)
        self.data = kwargs.get('data', None)
