# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class VirtualNetworkGatewayConnection(Resource):
    """
    A common class for general resource information

    :param str id: Resource Id
    :param str name: Resource name
    :param str type: Resource type
    :param str location: Resource location
    :param dict tags: Resource tags
    :param str authorization_key: The authorizationKey.
    :param VirtualNetworkGateway virtual_network_gateway1:
    :param VirtualNetworkGateway virtual_network_gateway2:
    :param LocalNetworkGateway local_network_gateway2:
    :param str connection_type: Gateway connection type
     -Ipsec/Dedicated/VpnClient/Vnet2Vnet. Possible values include: 'IPsec',
     'Vnet2Vnet', 'ExpressRoute', 'VPNClient'
    :param int routing_weight: The Routing weight.
    :param str shared_key: The Ipsec share key.
    :param str connection_status: Virtual network Gateway connection status.
     Possible values include: 'Unknown', 'Connecting', 'Connected',
     'NotConnected'
    :param long egress_bytes_transferred: The Egress Bytes Transferred in
     this connection
    :param long ingress_bytes_transferred: The Ingress Bytes Transferred in
     this connection
    :param SubResource peer: The reference to peerings resource.
    :param str resource_guid: Gets or sets resource guid property of the
     VirtualNetworkGatewayConnection resource
    :param str provisioning_state: Gets or sets Provisioning state of the
     VirtualNetworkGatewayConnection resource Updating/Deleting/Failed
    :param str etag: Gets a unique read-only string that changes whenever the
     resource is updated
    """ 

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'authorization_key': {'key': 'properties.authorizationKey', 'type': 'str'},
        'virtual_network_gateway1': {'key': 'properties.virtualNetworkGateway1', 'type': 'VirtualNetworkGateway'},
        'virtual_network_gateway2': {'key': 'properties.virtualNetworkGateway2', 'type': 'VirtualNetworkGateway'},
        'local_network_gateway2': {'key': 'properties.localNetworkGateway2', 'type': 'LocalNetworkGateway'},
        'connection_type': {'key': 'properties.connectionType', 'type': 'VirtualNetworkGatewayConnectionType'},
        'routing_weight': {'key': 'properties.routingWeight', 'type': 'int'},
        'shared_key': {'key': 'properties.sharedKey', 'type': 'str'},
        'connection_status': {'key': 'properties.connectionStatus', 'type': 'VirtualNetworkGatewayConnectionStatus'},
        'egress_bytes_transferred': {'key': 'properties.egressBytesTransferred', 'type': 'long'},
        'ingress_bytes_transferred': {'key': 'properties.ingressBytesTransferred', 'type': 'long'},
        'peer': {'key': 'properties.peer', 'type': 'SubResource'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, id=None, name=None, type=None, location=None, tags=None, authorization_key=None, virtual_network_gateway1=None, virtual_network_gateway2=None, local_network_gateway2=None, connection_type=None, routing_weight=None, shared_key=None, connection_status=None, egress_bytes_transferred=None, ingress_bytes_transferred=None, peer=None, resource_guid=None, provisioning_state=None, etag=None, **kwargs):
        super(VirtualNetworkGatewayConnection, self).__init__(id=id, name=name, type=type, location=location, tags=tags, **kwargs)
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = connection_status
        self.egress_bytes_transferred = egress_bytes_transferred
        self.ingress_bytes_transferred = ingress_bytes_transferred
        self.peer = peer
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state
        self.etag = etag
