# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class BackendAddressPool(SubResource):
    """
    Pool of backend IP addresseses

    :param str id: Resource Id
    :param list backend_ip_configurations: Gets collection of references to
     IPs defined in NICs
    :param list load_balancing_rules: Gets Load Balancing rules that use this
     Backend Address Pool
    :param SubResource outbound_nat_rule: Gets outbound rules that use this
     Backend Address Pool
    :param str provisioning_state: Provisioning state of the PublicIP
     resource Updating/Deleting/Failed
    :param str name: Gets name of the resource that is unique within a
     resource group. This name can be used to access the resource
    :param str etag: A unique read-only string that changes whenever the
     resource is updated
    """ 

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'backend_ip_configurations': {'key': 'properties.backendIPConfigurations', 'type': '[NetworkInterfaceIPConfiguration]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[SubResource]'},
        'outbound_nat_rule': {'key': 'properties.outboundNatRule', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, id=None, backend_ip_configurations=None, load_balancing_rules=None, outbound_nat_rule=None, provisioning_state=None, name=None, etag=None, **kwargs):
        super(BackendAddressPool, self).__init__(id=id, **kwargs)
        self.backend_ip_configurations = backend_ip_configurations
        self.load_balancing_rules = load_balancing_rules
        self.outbound_nat_rule = outbound_nat_rule
        self.provisioning_state = provisioning_state
        self.name = name
        self.etag = etag
