# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServiceResourcePropertiesBase(Model):
    """The common service resource properties.

    :param placement_constraints: The placement constraints as a string.
     Placement constraints are boolean expressions on node properties and allow
     for restricting a service to particular nodes based on the service
     requirements. For example, to place a service on nodes where NodeType is
     blue specify the following: "NodeColor == blue)".
    :type placement_constraints: str
    :param correlation_scheme: A list that describes the correlation of the
     service with other services.
    :type correlation_scheme:
     list[~azure.mgmt.servicefabric.models.ServiceCorrelationDescription]
    :param service_load_metrics: The service load metrics is given as an array
     of ServiceLoadMetricDescription objects.
    :type service_load_metrics:
     list[~azure.mgmt.servicefabric.models.ServiceLoadMetricDescription]
    :param service_placement_policies: A list that describes the correlation
     of the service with other services.
    :type service_placement_policies:
     list[~azure.mgmt.servicefabric.models.ServicePlacementPolicyDescription]
    :param default_move_cost: Specifies the move cost for the service.
     Possible values include: 'Zero', 'Low', 'Medium', 'High'
    :type default_move_cost: str or ~azure.mgmt.servicefabric.models.MoveCost
    """

    _attribute_map = {
        'placement_constraints': {'key': 'placementConstraints', 'type': 'str'},
        'correlation_scheme': {'key': 'correlationScheme', 'type': '[ServiceCorrelationDescription]'},
        'service_load_metrics': {'key': 'serviceLoadMetrics', 'type': '[ServiceLoadMetricDescription]'},
        'service_placement_policies': {'key': 'servicePlacementPolicies', 'type': '[ServicePlacementPolicyDescription]'},
        'default_move_cost': {'key': 'defaultMoveCost', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceResourcePropertiesBase, self).__init__(**kwargs)
        self.placement_constraints = kwargs.get('placement_constraints', None)
        self.correlation_scheme = kwargs.get('correlation_scheme', None)
        self.service_load_metrics = kwargs.get('service_load_metrics', None)
        self.service_placement_policies = kwargs.get('service_placement_policies', None)
        self.default_move_cost = kwargs.get('default_move_cost', None)
