# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationDeltaHealthPolicy(Model):
    """Defines a delta health policy used to evaluate the health of an application
    or one of its child entities when upgrading the cluster.
    .

    :param default_service_type_delta_health_policy: The delta health policy
     used by default to evaluate the health of a service type when upgrading
     the cluster.
    :type default_service_type_delta_health_policy:
     ~azure.mgmt.servicefabric.models.ServiceTypeDeltaHealthPolicy
    :param service_type_delta_health_policies: The map with service type delta
     health policy per service type name. The map is empty by default.
    :type service_type_delta_health_policies: dict[str,
     ~azure.mgmt.servicefabric.models.ServiceTypeDeltaHealthPolicy]
    """

    _attribute_map = {
        'default_service_type_delta_health_policy': {'key': 'defaultServiceTypeDeltaHealthPolicy', 'type': 'ServiceTypeDeltaHealthPolicy'},
        'service_type_delta_health_policies': {'key': 'serviceTypeDeltaHealthPolicies', 'type': '{ServiceTypeDeltaHealthPolicy}'},
    }

    def __init__(self, **kwargs):
        super(ApplicationDeltaHealthPolicy, self).__init__(**kwargs)
        self.default_service_type_delta_health_policy = kwargs.get('default_service_type_delta_health_policy', None)
        self.service_type_delta_health_policies = kwargs.get('service_type_delta_health_policies', None)
