# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ActivateApplicationPackageParameters(Model):
    """Parameters for an activating an application package.

    All required parameters must be populated in order to send to Azure.

    :param format: Required. The format of the application package binary
     file.
    :type format: str
    """

    _validation = {
        'format': {'required': True},
    }

    _attribute_map = {
        'format': {'key': 'format', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ActivateApplicationPackageParameters, self).__init__(**kwargs)
        self.format = kwargs.get('format', None)


class ProxyResource(Model):
    """A definition of an Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class Application(ProxyResource):
    """Contains information about an application in a Batch account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param display_name: The display name for the application.
    :type display_name: str
    :param allow_updates: A value indicating whether packages within the
     application may be overwritten using the same version string.
    :type allow_updates: bool
    :param default_version: The package to use if a client requests the
     application but does not specify a version. This property can only be set
     to the name of an existing package.
    :type default_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'allow_updates': {'key': 'properties.allowUpdates', 'type': 'bool'},
        'default_version': {'key': 'properties.defaultVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Application, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.allow_updates = kwargs.get('allow_updates', None)
        self.default_version = kwargs.get('default_version', None)


class ApplicationPackage(ProxyResource):
    """An application package which represents a particular version of an
    application.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar state: The current state of the application package. Possible values
     include: 'Pending', 'Active'
    :vartype state: str or ~azure.mgmt.batch.models.PackageState
    :ivar format: The format of the application package, if the package is
     active.
    :vartype format: str
    :ivar storage_url: The URL for the application package in Azure Storage.
    :vartype storage_url: str
    :ivar storage_url_expiry: The UTC time at which the Azure Storage URL will
     expire.
    :vartype storage_url_expiry: datetime
    :ivar last_activation_time: The time at which the package was last
     activated, if the package is active.
    :vartype last_activation_time: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'state': {'readonly': True},
        'format': {'readonly': True},
        'storage_url': {'readonly': True},
        'storage_url_expiry': {'readonly': True},
        'last_activation_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'state': {'key': 'properties.state', 'type': 'PackageState'},
        'format': {'key': 'properties.format', 'type': 'str'},
        'storage_url': {'key': 'properties.storageUrl', 'type': 'str'},
        'storage_url_expiry': {'key': 'properties.storageUrlExpiry', 'type': 'iso-8601'},
        'last_activation_time': {'key': 'properties.lastActivationTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(ApplicationPackage, self).__init__(**kwargs)
        self.state = None
        self.format = None
        self.storage_url = None
        self.storage_url_expiry = None
        self.last_activation_time = None


class ApplicationPackageReference(Model):
    """Link to an application package inside the batch account.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param version: If this is omitted, and no default version is specified
     for this application, the request fails with the error code
     InvalidApplicationPackageReferences. If you are calling the REST API
     directly, the HTTP status code is 409.
    :type version: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationPackageReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.version = kwargs.get('version', None)


class AutoScaleRun(Model):
    """The results and errors from an execution of a pool autoscale formula.

    All required parameters must be populated in order to send to Azure.

    :param evaluation_time: Required.
    :type evaluation_time: datetime
    :param results: Each variable value is returned in the form
     $variable=value, and variables are separated by semicolons.
    :type results: str
    :param error: Details of the error encountered evaluating the autoscale
     formula on the pool, if the evaluation was unsuccessful.
    :type error: ~azure.mgmt.batch.models.AutoScaleRunError
    """

    _validation = {
        'evaluation_time': {'required': True},
    }

    _attribute_map = {
        'evaluation_time': {'key': 'evaluationTime', 'type': 'iso-8601'},
        'results': {'key': 'results', 'type': 'str'},
        'error': {'key': 'error', 'type': 'AutoScaleRunError'},
    }

    def __init__(self, **kwargs):
        super(AutoScaleRun, self).__init__(**kwargs)
        self.evaluation_time = kwargs.get('evaluation_time', None)
        self.results = kwargs.get('results', None)
        self.error = kwargs.get('error', None)


class AutoScaleRunError(Model):
    """An error that occurred when autoscaling a pool.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. An identifier for the error. Codes are invariant
     and are intended to be consumed programmatically.
    :type code: str
    :param message: Required. A message describing the error, intended to be
     suitable for display in a user interface.
    :type message: str
    :param details:
    :type details: list[~azure.mgmt.batch.models.AutoScaleRunError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[AutoScaleRunError]'},
    }

    def __init__(self, **kwargs):
        super(AutoScaleRunError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class AutoScaleSettings(Model):
    """AutoScale settings for the pool.

    All required parameters must be populated in order to send to Azure.

    :param formula: Required.
    :type formula: str
    :param evaluation_interval: If omitted, the default value is 15 minutes
     (PT15M).
    :type evaluation_interval: timedelta
    """

    _validation = {
        'formula': {'required': True},
    }

    _attribute_map = {
        'formula': {'key': 'formula', 'type': 'str'},
        'evaluation_interval': {'key': 'evaluationInterval', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(AutoScaleSettings, self).__init__(**kwargs)
        self.formula = kwargs.get('formula', None)
        self.evaluation_interval = kwargs.get('evaluation_interval', None)


class AutoStorageBaseProperties(Model):
    """The properties related to the auto-storage account.

    All required parameters must be populated in order to send to Azure.

    :param storage_account_id: Required. The resource ID of the storage
     account to be used for auto-storage account.
    :type storage_account_id: str
    """

    _validation = {
        'storage_account_id': {'required': True},
    }

    _attribute_map = {
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AutoStorageBaseProperties, self).__init__(**kwargs)
        self.storage_account_id = kwargs.get('storage_account_id', None)


class AutoStorageProperties(AutoStorageBaseProperties):
    """Contains information about the auto-storage account associated with a Batch
    account.

    All required parameters must be populated in order to send to Azure.

    :param storage_account_id: Required. The resource ID of the storage
     account to be used for auto-storage account.
    :type storage_account_id: str
    :param last_key_sync: Required. The UTC time at which storage keys were
     last synchronized with the Batch account.
    :type last_key_sync: datetime
    """

    _validation = {
        'storage_account_id': {'required': True},
        'last_key_sync': {'required': True},
    }

    _attribute_map = {
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'last_key_sync': {'key': 'lastKeySync', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(AutoStorageProperties, self).__init__(**kwargs)
        self.last_key_sync = kwargs.get('last_key_sync', None)


class AutoUserSpecification(Model):
    """Specifies the parameters for the auto user that runs a task on the Batch
    service.

    :param scope: The default value is Pool. If the pool is running Windows a
     value of Task should be specified if stricter isolation between tasks is
     required. For example, if the task mutates the registry in a way which
     could impact other tasks, or if certificates have been specified on the
     pool which should not be accessible by normal tasks but should be
     accessible by start tasks. Possible values include: 'Task', 'Pool'
    :type scope: str or ~azure.mgmt.batch.models.AutoUserScope
    :param elevation_level: The elevation level of the auto user. The default
     value is nonAdmin. Possible values include: 'NonAdmin', 'Admin'
    :type elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'AutoUserScope'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'ElevationLevel'},
    }

    def __init__(self, **kwargs):
        super(AutoUserSpecification, self).__init__(**kwargs)
        self.scope = kwargs.get('scope', None)
        self.elevation_level = kwargs.get('elevation_level', None)


class AzureBlobFileSystemConfiguration(Model):
    """Information used to connect to an Azure Storage Container using Blobfuse.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required.
    :type account_name: str
    :param container_name: Required.
    :type container_name: str
    :param account_key: This property is mutually exclusive with sasKey and
     one must be specified.
    :type account_key: str
    :param sas_key: This property is mutually exclusive with accountKey and
     one must be specified.
    :type sas_key: str
    :param blobfuse_options: These are 'net use' options in Windows and
     'mount' options in Linux.
    :type blobfuse_options: str
    :param relative_mount_path: Required. All file systems are mounted
     relative to the Batch mounts directory, accessible via the
     AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :type relative_mount_path: str
    """

    _validation = {
        'account_name': {'required': True},
        'container_name': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'sas_key': {'key': 'sasKey', 'type': 'str'},
        'blobfuse_options': {'key': 'blobfuseOptions', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureBlobFileSystemConfiguration, self).__init__(**kwargs)
        self.account_name = kwargs.get('account_name', None)
        self.container_name = kwargs.get('container_name', None)
        self.account_key = kwargs.get('account_key', None)
        self.sas_key = kwargs.get('sas_key', None)
        self.blobfuse_options = kwargs.get('blobfuse_options', None)
        self.relative_mount_path = kwargs.get('relative_mount_path', None)


class AzureFileShareConfiguration(Model):
    """Information used to connect to an Azure Fileshare.

    All required parameters must be populated in order to send to Azure.

    :param account_name: Required.
    :type account_name: str
    :param azure_file_url: Required. This is of the form
     'https://{account}.file.core.windows.net/'.
    :type azure_file_url: str
    :param account_key: Required.
    :type account_key: str
    :param relative_mount_path: Required. All file systems are mounted
     relative to the Batch mounts directory, accessible via the
     AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :type relative_mount_path: str
    :param mount_options: These are 'net use' options in Windows and 'mount'
     options in Linux.
    :type mount_options: str
    """

    _validation = {
        'account_name': {'required': True},
        'azure_file_url': {'required': True},
        'account_key': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'azure_file_url': {'key': 'azureFileUrl', 'type': 'str'},
        'account_key': {'key': 'accountKey', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureFileShareConfiguration, self).__init__(**kwargs)
        self.account_name = kwargs.get('account_name', None)
        self.azure_file_url = kwargs.get('azure_file_url', None)
        self.account_key = kwargs.get('account_key', None)
        self.relative_mount_path = kwargs.get('relative_mount_path', None)
        self.mount_options = kwargs.get('mount_options', None)


class Resource(Model):
    """A definition of an Azure resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None


class BatchAccount(Resource):
    """Contains information about an Azure Batch account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The location of the resource.
    :vartype location: str
    :ivar tags: The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar account_endpoint: The account endpoint used to interact with the
     Batch service.
    :vartype account_endpoint: str
    :ivar provisioning_state: The provisioned state of the resource. Possible
     values include: 'Invalid', 'Creating', 'Deleting', 'Succeeded', 'Failed',
     'Cancelled'
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.ProvisioningState
    :ivar pool_allocation_mode: The allocation mode to use for creating pools
     in the Batch account. Possible values include: 'BatchService',
     'UserSubscription'
    :vartype pool_allocation_mode: str or
     ~azure.mgmt.batch.models.PoolAllocationMode
    :ivar key_vault_reference: A reference to the Azure key vault associated
     with the Batch account.
    :vartype key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
    :ivar public_network_access: The network interface type for accessing
     Azure Batch service and Batch account operations. If not specified, the
     default value is 'enabled'. Possible values include: 'Enabled',
     'Disabled'. Default value: "Enabled" .
    :vartype public_network_access: str or
     ~azure.mgmt.batch.models.PublicNetworkAccessType
    :ivar private_endpoint_connections: List of private endpoint connections
     associated with the Batch account
    :vartype private_endpoint_connections:
     list[~azure.mgmt.batch.models.PrivateEndpointConnection]
    :ivar auto_storage: The properties and status of any auto-storage account
     associated with the Batch account.
    :vartype auto_storage: ~azure.mgmt.batch.models.AutoStorageProperties
    :ivar encryption: The encryption configuration for the Batch account.
    :vartype encryption: ~azure.mgmt.batch.models.EncryptionProperties
    :ivar dedicated_core_quota: The dedicated core quota for the Batch
     account. For accounts with PoolAllocationMode set to UserSubscription,
     quota is managed on the subscription so this value is not returned.
    :vartype dedicated_core_quota: int
    :ivar low_priority_core_quota: The low-priority core quota for the Batch
     account. For accounts with PoolAllocationMode set to UserSubscription,
     quota is managed on the subscription so this value is not returned.
    :vartype low_priority_core_quota: int
    :ivar dedicated_core_quota_per_vm_family: A list of the dedicated core
     quota per Virtual Machine family for the Batch account. For accounts with
     PoolAllocationMode set to UserSubscription, quota is managed on the
     subscription so this value is not returned.
    :vartype dedicated_core_quota_per_vm_family:
     list[~azure.mgmt.batch.models.VirtualMachineFamilyCoreQuota]
    :ivar dedicated_core_quota_per_vm_family_enforced: A value indicating
     whether the core quota for the Batch Account is enforced per Virtual
     Machine family or not. Batch is transitioning its core quota system for
     dedicated cores to be enforced per Virtual Machine family. During this
     transitional phase, the dedicated core quota per Virtual Machine family
     may not yet be enforced. If this flag is false, dedicated core quota is
     enforced via the old dedicatedCoreQuota property on the account and does
     not consider Virtual Machine family. If this flag is true, dedicated core
     quota is enforced via the dedicatedCoreQuotaPerVMFamily property on the
     account, and the old dedicatedCoreQuota does not apply.
    :vartype dedicated_core_quota_per_vm_family_enforced: bool
    :ivar pool_quota: The pool quota for the Batch account.
    :vartype pool_quota: int
    :ivar active_job_and_job_schedule_quota: The active job and job schedule
     quota for the Batch account.
    :vartype active_job_and_job_schedule_quota: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
        'account_endpoint': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'pool_allocation_mode': {'readonly': True},
        'key_vault_reference': {'readonly': True},
        'public_network_access': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'auto_storage': {'readonly': True},
        'encryption': {'readonly': True},
        'dedicated_core_quota': {'readonly': True},
        'low_priority_core_quota': {'readonly': True},
        'dedicated_core_quota_per_vm_family': {'readonly': True},
        'dedicated_core_quota_per_vm_family_enforced': {'readonly': True},
        'pool_quota': {'readonly': True},
        'active_job_and_job_schedule_quota': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'account_endpoint': {'key': 'properties.accountEndpoint', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningState'},
        'pool_allocation_mode': {'key': 'properties.poolAllocationMode', 'type': 'PoolAllocationMode'},
        'key_vault_reference': {'key': 'properties.keyVaultReference', 'type': 'KeyVaultReference'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'PublicNetworkAccessType'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageProperties'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperties'},
        'dedicated_core_quota': {'key': 'properties.dedicatedCoreQuota', 'type': 'int'},
        'low_priority_core_quota': {'key': 'properties.lowPriorityCoreQuota', 'type': 'int'},
        'dedicated_core_quota_per_vm_family': {'key': 'properties.dedicatedCoreQuotaPerVMFamily', 'type': '[VirtualMachineFamilyCoreQuota]'},
        'dedicated_core_quota_per_vm_family_enforced': {'key': 'properties.dedicatedCoreQuotaPerVMFamilyEnforced', 'type': 'bool'},
        'pool_quota': {'key': 'properties.poolQuota', 'type': 'int'},
        'active_job_and_job_schedule_quota': {'key': 'properties.activeJobAndJobScheduleQuota', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(BatchAccount, self).__init__(**kwargs)
        self.account_endpoint = None
        self.provisioning_state = None
        self.pool_allocation_mode = None
        self.key_vault_reference = None
        self.public_network_access = None
        self.private_endpoint_connections = None
        self.auto_storage = None
        self.encryption = None
        self.dedicated_core_quota = None
        self.low_priority_core_quota = None
        self.dedicated_core_quota_per_vm_family = None
        self.dedicated_core_quota_per_vm_family_enforced = None
        self.pool_quota = None
        self.active_job_and_job_schedule_quota = None


class BatchAccountCreateParameters(Model):
    """Parameters supplied to the Create operation.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The region in which to create the account.
    :type location: str
    :param tags: The user-specified tags associated with the account.
    :type tags: dict[str, str]
    :param auto_storage: The properties related to the auto-storage account.
    :type auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
    :param pool_allocation_mode: The allocation mode to use for creating pools
     in the Batch account. The pool allocation mode also affects how clients
     may authenticate to the Batch Service API. If the mode is BatchService,
     clients may authenticate using access keys or Azure Active Directory. If
     the mode is UserSubscription, clients must use Azure Active Directory. The
     default is BatchService. Possible values include: 'BatchService',
     'UserSubscription'
    :type pool_allocation_mode: str or
     ~azure.mgmt.batch.models.PoolAllocationMode
    :param key_vault_reference: A reference to the Azure key vault associated
     with the Batch account.
    :type key_vault_reference: ~azure.mgmt.batch.models.KeyVaultReference
    :param public_network_access: The network access type for accessing Azure
     Batch account. If not specified, the default value is 'enabled'. Possible
     values include: 'Enabled', 'Disabled'. Default value: "Enabled" .
    :type public_network_access: str or
     ~azure.mgmt.batch.models.PublicNetworkAccessType
    :param encryption: The encryption configuration for the Batch account.
    :type encryption: ~azure.mgmt.batch.models.EncryptionProperties
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageBaseProperties'},
        'pool_allocation_mode': {'key': 'properties.poolAllocationMode', 'type': 'PoolAllocationMode'},
        'key_vault_reference': {'key': 'properties.keyVaultReference', 'type': 'KeyVaultReference'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'PublicNetworkAccessType'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperties'},
    }

    def __init__(self, **kwargs):
        super(BatchAccountCreateParameters, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)
        self.auto_storage = kwargs.get('auto_storage', None)
        self.pool_allocation_mode = kwargs.get('pool_allocation_mode', None)
        self.key_vault_reference = kwargs.get('key_vault_reference', None)
        self.public_network_access = kwargs.get('public_network_access', "Enabled")
        self.encryption = kwargs.get('encryption', None)


class BatchAccountKeys(Model):
    """A set of Azure Batch account keys.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar account_name: The Batch account name.
    :vartype account_name: str
    :ivar primary: The primary key associated with the account.
    :vartype primary: str
    :ivar secondary: The secondary key associated with the account.
    :vartype secondary: str
    """

    _validation = {
        'account_name': {'readonly': True},
        'primary': {'readonly': True},
        'secondary': {'readonly': True},
    }

    _attribute_map = {
        'account_name': {'key': 'accountName', 'type': 'str'},
        'primary': {'key': 'primary', 'type': 'str'},
        'secondary': {'key': 'secondary', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BatchAccountKeys, self).__init__(**kwargs)
        self.account_name = None
        self.primary = None
        self.secondary = None


class BatchAccountRegenerateKeyParameters(Model):
    """Parameters supplied to the RegenerateKey operation.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The type of account key to regenerate. Possible
     values include: 'Primary', 'Secondary'
    :type key_name: str or ~azure.mgmt.batch.models.AccountKeyType
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'AccountKeyType'},
    }

    def __init__(self, **kwargs):
        super(BatchAccountRegenerateKeyParameters, self).__init__(**kwargs)
        self.key_name = kwargs.get('key_name', None)


class BatchAccountUpdateParameters(Model):
    """Parameters for updating an Azure Batch account.

    :param tags: The user-specified tags associated with the account.
    :type tags: dict[str, str]
    :param auto_storage: The properties related to the auto-storage account.
    :type auto_storage: ~azure.mgmt.batch.models.AutoStorageBaseProperties
    :param encryption: The encryption configuration for the Batch account.
    :type encryption: ~azure.mgmt.batch.models.EncryptionProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'auto_storage': {'key': 'properties.autoStorage', 'type': 'AutoStorageBaseProperties'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperties'},
    }

    def __init__(self, **kwargs):
        super(BatchAccountUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.auto_storage = kwargs.get('auto_storage', None)
        self.encryption = kwargs.get('encryption', None)


class BatchLocationQuota(Model):
    """Quotas associated with a Batch region for a particular subscription.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar account_quota: The number of Batch accounts that may be created
     under the subscription in the specified region.
    :vartype account_quota: int
    """

    _validation = {
        'account_quota': {'readonly': True},
    }

    _attribute_map = {
        'account_quota': {'key': 'accountQuota', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(BatchLocationQuota, self).__init__(**kwargs)
        self.account_quota = None


class Certificate(ProxyResource):
    """Contains information about a certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param thumbprint_algorithm: This must match the first portion of the
     certificate name. Currently required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: This must match the thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If
     omitted, the default is Pfx. Possible values include: 'Pfx', 'Cer'
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    :ivar provisioning_state: Possible values include: 'Succeeded',
     'Deleting', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar provisioning_state_transition_time:
    :vartype provisioning_state_transition_time: datetime
    :ivar previous_provisioning_state: The previous provisioned state of the
     resource. Possible values include: 'Succeeded', 'Deleting', 'Failed'
    :vartype previous_provisioning_state: str or
     ~azure.mgmt.batch.models.CertificateProvisioningState
    :ivar previous_provisioning_state_transition_time:
    :vartype previous_provisioning_state_transition_time: datetime
    :ivar public_data: The public key of the certificate.
    :vartype public_data: str
    :ivar delete_certificate_error: The error which occurred while deleting
     the certificate. This is only returned when the certificate
     provisioningState is 'Failed'.
    :vartype delete_certificate_error:
     ~azure.mgmt.batch.models.DeleteCertificateError
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'provisioning_state_transition_time': {'readonly': True},
        'previous_provisioning_state': {'readonly': True},
        'previous_provisioning_state_transition_time': {'readonly': True},
        'public_data': {'readonly': True},
        'delete_certificate_error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'properties.thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'CertificateFormat'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'CertificateProvisioningState'},
        'provisioning_state_transition_time': {'key': 'properties.provisioningStateTransitionTime', 'type': 'iso-8601'},
        'previous_provisioning_state': {'key': 'properties.previousProvisioningState', 'type': 'CertificateProvisioningState'},
        'previous_provisioning_state_transition_time': {'key': 'properties.previousProvisioningStateTransitionTime', 'type': 'iso-8601'},
        'public_data': {'key': 'properties.publicData', 'type': 'str'},
        'delete_certificate_error': {'key': 'properties.deleteCertificateError', 'type': 'DeleteCertificateError'},
    }

    def __init__(self, **kwargs):
        super(Certificate, self).__init__(**kwargs)
        self.thumbprint_algorithm = kwargs.get('thumbprint_algorithm', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.format = kwargs.get('format', None)
        self.provisioning_state = None
        self.provisioning_state_transition_time = None
        self.previous_provisioning_state = None
        self.previous_provisioning_state_transition_time = None
        self.public_data = None
        self.delete_certificate_error = None


class CertificateBaseProperties(Model):
    """CertificateBaseProperties.

    :param thumbprint_algorithm: This must match the first portion of the
     certificate name. Currently required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: This must match the thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If
     omitted, the default is Pfx. Possible values include: 'Pfx', 'Cer'
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    """

    _attribute_map = {
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'format': {'key': 'format', 'type': 'CertificateFormat'},
    }

    def __init__(self, **kwargs):
        super(CertificateBaseProperties, self).__init__(**kwargs)
        self.thumbprint_algorithm = kwargs.get('thumbprint_algorithm', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.format = kwargs.get('format', None)


class CertificateCreateOrUpdateParameters(ProxyResource):
    """Contains information about a certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param thumbprint_algorithm: This must match the first portion of the
     certificate name. Currently required to be 'SHA1'.
    :type thumbprint_algorithm: str
    :param thumbprint: This must match the thumbprint from the name.
    :type thumbprint: str
    :param format: The format of the certificate - either Pfx or Cer. If
     omitted, the default is Pfx. Possible values include: 'Pfx', 'Cer'
    :type format: str or ~azure.mgmt.batch.models.CertificateFormat
    :param data: Required. The maximum size is 10KB.
    :type data: str
    :param password: This must not be specified if the certificate format is
     Cer.
    :type password: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'properties.thumbprintAlgorithm', 'type': 'str'},
        'thumbprint': {'key': 'properties.thumbprint', 'type': 'str'},
        'format': {'key': 'properties.format', 'type': 'CertificateFormat'},
        'data': {'key': 'properties.data', 'type': 'str'},
        'password': {'key': 'properties.password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CertificateCreateOrUpdateParameters, self).__init__(**kwargs)
        self.thumbprint_algorithm = kwargs.get('thumbprint_algorithm', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.format = kwargs.get('format', None)
        self.data = kwargs.get('data', None)
        self.password = kwargs.get('password', None)


class CertificateReference(Model):
    """A reference to a certificate to be installed on compute nodes in a pool.
    This must exist inside the same account as the pool.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param store_location: The default value is currentUser. This property is
     applicable only for pools configured with Windows nodes (that is, created
     with cloudServiceConfiguration, or with virtualMachineConfiguration using
     a Windows image reference). For Linux compute nodes, the certificates are
     stored in a directory inside the task working directory and an environment
     variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for
     this location. For certificates with visibility of 'remoteUser', a 'certs'
     directory is created in the user's home directory (e.g.,
     /home/{user-name}/certs) and certificates are placed in that directory.
     Possible values include: 'CurrentUser', 'LocalMachine'
    :type store_location: str or
     ~azure.mgmt.batch.models.CertificateStoreLocation
    :param store_name: This property is applicable only for pools configured
     with Windows nodes (that is, created with cloudServiceConfiguration, or
     with virtualMachineConfiguration using a Windows image reference). Common
     store names include: My, Root, CA, Trust, Disallowed, TrustedPeople,
     TrustedPublisher, AuthRoot, AddressBook, but any custom store name can
     also be used. The default value is My.
    :type store_name: str
    :param visibility:
    :type visibility: list[str or
     ~azure.mgmt.batch.models.CertificateVisibility]
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'store_location': {'key': 'storeLocation', 'type': 'CertificateStoreLocation'},
        'store_name': {'key': 'storeName', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': '[CertificateVisibility]'},
    }

    def __init__(self, **kwargs):
        super(CertificateReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.store_location = kwargs.get('store_location', None)
        self.store_name = kwargs.get('store_name', None)
        self.visibility = kwargs.get('visibility', None)


class CheckNameAvailabilityParameters(Model):
    """Parameters for a check name availability request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name to check for availability
    :type name: str
    :ivar type: Required. The resource type. Default value:
     "Microsoft.Batch/batchAccounts" .
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Batch/batchAccounts"

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CheckNameAvailabilityResult(Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name
     is available for you to use. If true, the name is available. If false, the
     name has already been taken or invalid and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a Batch account name could not be used.
     The Reason element is only returned if NameAvailable is false. Possible
     values include: 'Invalid', 'AlreadyExists'
    :vartype reason: str or ~azure.mgmt.batch.models.NameAvailabilityReason
    :ivar message: Gets an error message explaining the Reason value in more
     detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'NameAvailabilityReason'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CIFSMountConfiguration(Model):
    """Information used to connect to a CIFS file system.

    All required parameters must be populated in order to send to Azure.

    :param username: Required.
    :type username: str
    :param source: Required.
    :type source: str
    :param relative_mount_path: Required. All file systems are mounted
     relative to the Batch mounts directory, accessible via the
     AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :type relative_mount_path: str
    :param mount_options: These are 'net use' options in Windows and 'mount'
     options in Linux.
    :type mount_options: str
    :param password: Required.
    :type password: str
    """

    _validation = {
        'username': {'required': True},
        'source': {'required': True},
        'relative_mount_path': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CIFSMountConfiguration, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.source = kwargs.get('source', None)
        self.relative_mount_path = kwargs.get('relative_mount_path', None)
        self.mount_options = kwargs.get('mount_options', None)
        self.password = kwargs.get('password', None)


class CloudError(Model):
    """An error response from the Batch service.

    :param error:
    :type error: ~azure.mgmt.batch.models.CloudErrorBody
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'CloudErrorBody'},
    }

    def __init__(self, **kwargs):
        super(CloudError, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class CloudErrorException(HttpOperationError):
    """Server responsed with exception of type: 'CloudError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(CloudErrorException, self).__init__(deserialize, response, 'CloudError', *args)


class CloudErrorBody(Model):
    """An error response from the Batch service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.batch.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(self, **kwargs):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class CloudServiceConfiguration(Model):
    """The configuration for nodes in a pool based on the Azure Cloud Services
    platform.

    All required parameters must be populated in order to send to Azure.

    :param os_family: Required. Possible values are: 2 - OS Family 2,
     equivalent to Windows Server 2008 R2 SP1. 3 - OS Family 3, equivalent to
     Windows Server 2012. 4 - OS Family 4, equivalent to Windows Server 2012
     R2. 5 - OS Family 5, equivalent to Windows Server 2016. 6 - OS Family 6,
     equivalent to Windows Server 2019. For more information, see Azure Guest
     OS Releases
     (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
    :type os_family: str
    :param os_version: The default value is * which specifies the latest
     operating system version for the specified OS family.
    :type os_version: str
    """

    _validation = {
        'os_family': {'required': True},
    }

    _attribute_map = {
        'os_family': {'key': 'osFamily', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CloudServiceConfiguration, self).__init__(**kwargs)
        self.os_family = kwargs.get('os_family', None)
        self.os_version = kwargs.get('os_version', None)


class ContainerConfiguration(Model):
    """The configuration for container-enabled pools.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required.  Default value: "DockerCompatible" .
    :vartype type: str
    :param container_image_names: This is the full image reference, as would
     be specified to "docker pull". An image will be sourced from the default
     Docker registry unless the image is fully qualified with an alternative
     registry.
    :type container_image_names: list[str]
    :param container_registries: If any images must be downloaded from a
     private registry which requires credentials, then those credentials must
     be provided here.
    :type container_registries:
     list[~azure.mgmt.batch.models.ContainerRegistry]
    """

    _validation = {
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'container_image_names': {'key': 'containerImageNames', 'type': '[str]'},
        'container_registries': {'key': 'containerRegistries', 'type': '[ContainerRegistry]'},
    }

    type = "DockerCompatible"

    def __init__(self, **kwargs):
        super(ContainerConfiguration, self).__init__(**kwargs)
        self.container_image_names = kwargs.get('container_image_names', None)
        self.container_registries = kwargs.get('container_registries', None)


class ContainerRegistry(Model):
    """A private container registry.

    All required parameters must be populated in order to send to Azure.

    :param registry_server: If omitted, the default is "docker.io".
    :type registry_server: str
    :param username: Required.
    :type username: str
    :param password: Required.
    :type password: str
    """

    _validation = {
        'username': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'registry_server': {'key': 'registryServer', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerRegistry, self).__init__(**kwargs)
        self.registry_server = kwargs.get('registry_server', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)


class DataDisk(Model):
    """Settings which will be used by the data disks associated to Compute Nodes
    in the Pool. When using attached data disks, you need to mount and format
    the disks from within a VM to use them.

    All required parameters must be populated in order to send to Azure.

    :param lun: Required. The logical unit number. The lun is used to uniquely
     identify each data disk. If attaching multiple disks, each should have a
     distinct lun.
    :type lun: int
    :param caching: The type of caching to be enabled for the data disks.
     Values are:
     none - The caching mode for the disk is not enabled.
     readOnly - The caching mode for the disk is read only.
     readWrite - The caching mode for the disk is read and write.
     The default value for caching is none. For information about the caching
     options see:
     https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     Possible values include: 'None', 'ReadOnly', 'ReadWrite'
    :type caching: str or ~azure.mgmt.batch.models.CachingType
    :param disk_size_gb: Required. The initial disk size in GB when creating
     new data disk.
    :type disk_size_gb: int
    :param storage_account_type: The storage account type to be used for the
     data disk. If omitted, the default is "Standard_LRS". Values are:
     Standard_LRS - The data disk should use standard locally redundant
     storage.
     Premium_LRS - The data disk should use premium locally redundant storage.
     Possible values include: 'Standard_LRS', 'Premium_LRS'
    :type storage_account_type: str or
     ~azure.mgmt.batch.models.StorageAccountType
    """

    _validation = {
        'lun': {'required': True},
        'disk_size_gb': {'required': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'caching': {'key': 'caching', 'type': 'CachingType'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'StorageAccountType'},
    }

    def __init__(self, **kwargs):
        super(DataDisk, self).__init__(**kwargs)
        self.lun = kwargs.get('lun', None)
        self.caching = kwargs.get('caching', None)
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.storage_account_type = kwargs.get('storage_account_type', None)


class DeleteCertificateError(Model):
    """An error response from the Batch service.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. An identifier for the error. Codes are invariant
     and are intended to be consumed programmatically.
    :type code: str
    :param message: Required. A message describing the error, intended to be
     suitable for display in a user interface.
    :type message: str
    :param target: The target of the particular error. For example, the name
     of the property in error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.batch.models.DeleteCertificateError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[DeleteCertificateError]'},
    }

    def __init__(self, **kwargs):
        super(DeleteCertificateError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class DeploymentConfiguration(Model):
    """Deployment configuration properties.

    :param cloud_service_configuration: The cloud service configuration for
     the pool. This property and virtualMachineConfiguration are mutually
     exclusive and one of the properties must be specified. This property
     cannot be specified if the Batch account was created with its
     poolAllocationMode property set to 'UserSubscription'.
    :type cloud_service_configuration:
     ~azure.mgmt.batch.models.CloudServiceConfiguration
    :param virtual_machine_configuration: The virtual machine configuration
     for the pool. This property and cloudServiceConfiguration are mutually
     exclusive and one of the properties must be specified.
    :type virtual_machine_configuration:
     ~azure.mgmt.batch.models.VirtualMachineConfiguration
    """

    _attribute_map = {
        'cloud_service_configuration': {'key': 'cloudServiceConfiguration', 'type': 'CloudServiceConfiguration'},
        'virtual_machine_configuration': {'key': 'virtualMachineConfiguration', 'type': 'VirtualMachineConfiguration'},
    }

    def __init__(self, **kwargs):
        super(DeploymentConfiguration, self).__init__(**kwargs)
        self.cloud_service_configuration = kwargs.get('cloud_service_configuration', None)
        self.virtual_machine_configuration = kwargs.get('virtual_machine_configuration', None)


class DiskEncryptionConfiguration(Model):
    """The disk encryption configuration applied on compute nodes in the pool.
    Disk encryption configuration is not supported on Linux pool created with
    Virtual Machine Image or Shared Image Gallery Image.

    :param targets: On Linux pool, only "TemporaryDisk" is supported; on
     Windows pool, "OsDisk" and "TemporaryDisk" must be specified.
    :type targets: list[str or ~azure.mgmt.batch.models.DiskEncryptionTarget]
    """

    _attribute_map = {
        'targets': {'key': 'targets', 'type': '[DiskEncryptionTarget]'},
    }

    def __init__(self, **kwargs):
        super(DiskEncryptionConfiguration, self).__init__(**kwargs)
        self.targets = kwargs.get('targets', None)


class EncryptionProperties(Model):
    """EncryptionProperties.

    :param key_source: Type of the key source. Possible values include:
     'Microsoft.Batch', 'Microsoft.KeyVault'
    :type key_source: str or ~azure.mgmt.batch.models.KeySource
    :param key_vault_properties: Additional details when using
     Microsoft.KeyVault
    :type key_vault_properties: ~azure.mgmt.batch.models.KeyVaultProperties
    """

    _attribute_map = {
        'key_source': {'key': 'keySource', 'type': 'KeySource'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
    }

    def __init__(self, **kwargs):
        super(EncryptionProperties, self).__init__(**kwargs)
        self.key_source = kwargs.get('key_source', None)
        self.key_vault_properties = kwargs.get('key_vault_properties', None)


class EnvironmentSetting(Model):
    """An environment variable to be set on a task process.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param value:
    :type value: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EnvironmentSetting, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class FixedScaleSettings(Model):
    """Fixed scale settings for the pool.

    :param resize_timeout: The default value is 15 minutes. Timeout values use
     ISO 8601 format. For example, use PT10M for 10 minutes. The minimum value
     is 5 minutes. If you specify a value less than 5 minutes, the Batch
     service rejects the request with an error; if you are calling the REST API
     directly, the HTTP status code is 400 (Bad Request).
    :type resize_timeout: timedelta
    :param target_dedicated_nodes: The desired number of dedicated compute
     nodes in the pool. At least one of targetDedicatedNodes,
     targetLowPriorityNodes must be set.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: The desired number of low-priority
     compute nodes in the pool. At least one of targetDedicatedNodes,
     targetLowPriorityNodes must be set.
    :type target_low_priority_nodes: int
    :param node_deallocation_option: Determines what to do with a node and its
     running task(s) if the pool size is decreasing. If omitted, the default
     value is Requeue. Possible values include: 'Requeue', 'Terminate',
     'TaskCompletion', 'RetainedData'
    :type node_deallocation_option: str or
     ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    """

    _attribute_map = {
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'ComputeNodeDeallocationOption'},
    }

    def __init__(self, **kwargs):
        super(FixedScaleSettings, self).__init__(**kwargs)
        self.resize_timeout = kwargs.get('resize_timeout', None)
        self.target_dedicated_nodes = kwargs.get('target_dedicated_nodes', None)
        self.target_low_priority_nodes = kwargs.get('target_low_priority_nodes', None)
        self.node_deallocation_option = kwargs.get('node_deallocation_option', None)


class ImageReference(Model):
    """A reference to an Azure Virtual Machines Marketplace image or the Azure
    Image resource of a custom Virtual Machine. To get the list of all
    imageReferences verified by Azure Batch, see the 'List supported node agent
    SKUs' operation.

    :param publisher: For example, Canonical or MicrosoftWindowsServer.
    :type publisher: str
    :param offer: For example, UbuntuServer or WindowsServer.
    :type offer: str
    :param sku: For example, 18.04-LTS or 2019-Datacenter.
    :type sku: str
    :param version: A value of 'latest' can be specified to select the latest
     version of an image. If omitted, the default is 'latest'.
    :type version: str
    :param id: This property is mutually exclusive with other properties. The
     Shared Image Gallery image must have replicas in the same region as the
     Azure Batch account. For information about the firewall settings for the
     Batch node agent to communicate with the Batch service see
     https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
    :type id: str
    """

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImageReference, self).__init__(**kwargs)
        self.publisher = kwargs.get('publisher', None)
        self.offer = kwargs.get('offer', None)
        self.sku = kwargs.get('sku', None)
        self.version = kwargs.get('version', None)
        self.id = kwargs.get('id', None)


class InboundNatPool(Model):
    """A inbound NAT pool that can be used to address specific ports on compute
    nodes in a Batch pool externally.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name must be unique within a Batch pool, can
     contain letters, numbers, underscores, periods, and hyphens. Names must
     start with a letter or number, must end with a letter, number, or
     underscore, and cannot exceed 77 characters.  If any invalid values are
     provided the request fails with HTTP status code 400.
    :type name: str
    :param protocol: Required. Possible values include: 'TCP', 'UDP'
    :type protocol: str or ~azure.mgmt.batch.models.InboundEndpointProtocol
    :param backend_port: Required. The port number on the compute node. This
     must be unique within a Batch pool. Acceptable values are between 1 and
     65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any
     reserved values are provided the request fails with HTTP status code 400.
    :type backend_port: int
    :param frontend_port_range_start: Required. The first port number in the
     range of external ports that will be used to provide inbound access to the
     backendPort on individual compute nodes. Acceptable values range between 1
     and 65534 except ports from 50000 to 55000 which are reserved. All ranges
     within a pool must be distinct and cannot overlap. If any reserved or
     overlapping values are provided the request fails with HTTP status code
     400.
    :type frontend_port_range_start: int
    :param frontend_port_range_end: Required. The last port number in the
     range of external ports that will be used to provide inbound access to the
     backendPort on individual compute nodes. Acceptable values range between 1
     and 65534 except ports from 50000 to 55000 which are reserved by the Batch
     service. All ranges within a pool must be distinct and cannot overlap. If
     any reserved or overlapping values are provided the request fails with
     HTTP status code 400.
    :type frontend_port_range_end: int
    :param network_security_group_rules: The maximum number of rules that can
     be specified across all the endpoints on a Batch pool is 25. If no network
     security group rules are specified, a default rule will be created to
     allow inbound access to the specified backendPort. If the maximum number
     of network security group rules is exceeded the request fails with HTTP
     status code 400.
    :type network_security_group_rules:
     list[~azure.mgmt.batch.models.NetworkSecurityGroupRule]
    """

    _validation = {
        'name': {'required': True},
        'protocol': {'required': True},
        'backend_port': {'required': True},
        'frontend_port_range_start': {'required': True},
        'frontend_port_range_end': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'InboundEndpointProtocol'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
        'frontend_port_range_start': {'key': 'frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'frontendPortRangeEnd', 'type': 'int'},
        'network_security_group_rules': {'key': 'networkSecurityGroupRules', 'type': '[NetworkSecurityGroupRule]'},
    }

    def __init__(self, **kwargs):
        super(InboundNatPool, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.protocol = kwargs.get('protocol', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.frontend_port_range_start = kwargs.get('frontend_port_range_start', None)
        self.frontend_port_range_end = kwargs.get('frontend_port_range_end', None)
        self.network_security_group_rules = kwargs.get('network_security_group_rules', None)


class KeyVaultProperties(Model):
    """KeyVaultProperties.

    :param key_identifier: Full path to the versioned secret. Example
     https://mykeyvault.vault.azure.net/keys/testkey/6e34a81fef704045975661e297a4c053
    :type key_identifier: str
    """

    _attribute_map = {
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_identifier = kwargs.get('key_identifier', None)


class KeyVaultReference(Model):
    """Identifies the Azure key vault associated with a Batch account.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The resource ID of the Azure key vault associated
     with the Batch account.
    :type id: str
    :param url: Required. The URL of the Azure key vault associated with the
     Batch account.
    :type url: str
    """

    _validation = {
        'id': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(KeyVaultReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.url = kwargs.get('url', None)


class LinuxUserConfiguration(Model):
    """Properties used to create a user account on a Linux node.

    :param uid: The user ID of the user account. The uid and gid properties
     must be specified together or not at all. If not specified the underlying
     operating system picks the uid.
    :type uid: int
    :param gid: The group ID for the user account. The uid and gid properties
     must be specified together or not at all. If not specified the underlying
     operating system picks the gid.
    :type gid: int
    :param ssh_private_key: The private key must not be password protected.
     The private key is used to automatically configure asymmetric-key based
     authentication for SSH between nodes in a Linux pool when the pool's
     enableInterNodeCommunication property is true (it is ignored if
     enableInterNodeCommunication is false). It does this by placing the key
     pair into the user's .ssh directory. If not specified, password-less SSH
     is not configured between nodes (no modification of the user's .ssh
     directory is done).
    :type ssh_private_key: str
    """

    _attribute_map = {
        'uid': {'key': 'uid', 'type': 'int'},
        'gid': {'key': 'gid', 'type': 'int'},
        'ssh_private_key': {'key': 'sshPrivateKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LinuxUserConfiguration, self).__init__(**kwargs)
        self.uid = kwargs.get('uid', None)
        self.gid = kwargs.get('gid', None)
        self.ssh_private_key = kwargs.get('ssh_private_key', None)


class MetadataItem(Model):
    """A name-value pair associated with a Batch service resource.

    The Batch service does not assign any meaning to this metadata; it is
    solely for the use of user code.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param value: Required.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MetadataItem, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class MountConfiguration(Model):
    """The file system to mount on each node.

    :param azure_blob_file_system_configuration: The Azure Storage Container
     to mount using blob FUSE on each node. This property is mutually exclusive
     with all other properties.
    :type azure_blob_file_system_configuration:
     ~azure.mgmt.batch.models.AzureBlobFileSystemConfiguration
    :param nfs_mount_configuration: The NFS file system to mount on each node.
     This property is mutually exclusive with all other properties.
    :type nfs_mount_configuration:
     ~azure.mgmt.batch.models.NFSMountConfiguration
    :param cifs_mount_configuration: The CIFS/SMB file system to mount on each
     node. This property is mutually exclusive with all other properties.
    :type cifs_mount_configuration:
     ~azure.mgmt.batch.models.CIFSMountConfiguration
    :param azure_file_share_configuration: The Azure File Share to mount on
     each node. This property is mutually exclusive with all other properties.
    :type azure_file_share_configuration:
     ~azure.mgmt.batch.models.AzureFileShareConfiguration
    """

    _attribute_map = {
        'azure_blob_file_system_configuration': {'key': 'azureBlobFileSystemConfiguration', 'type': 'AzureBlobFileSystemConfiguration'},
        'nfs_mount_configuration': {'key': 'nfsMountConfiguration', 'type': 'NFSMountConfiguration'},
        'cifs_mount_configuration': {'key': 'cifsMountConfiguration', 'type': 'CIFSMountConfiguration'},
        'azure_file_share_configuration': {'key': 'azureFileShareConfiguration', 'type': 'AzureFileShareConfiguration'},
    }

    def __init__(self, **kwargs):
        super(MountConfiguration, self).__init__(**kwargs)
        self.azure_blob_file_system_configuration = kwargs.get('azure_blob_file_system_configuration', None)
        self.nfs_mount_configuration = kwargs.get('nfs_mount_configuration', None)
        self.cifs_mount_configuration = kwargs.get('cifs_mount_configuration', None)
        self.azure_file_share_configuration = kwargs.get('azure_file_share_configuration', None)


class NetworkConfiguration(Model):
    """The network configuration for a pool.

    :param subnet_id: The virtual network must be in the same region and
     subscription as the Azure Batch account. The specified subnet should have
     enough free IP addresses to accommodate the number of nodes in the pool.
     If the subnet doesn't have enough free IP addresses, the pool will
     partially allocate compute nodes and a resize error will occur. The
     'MicrosoftAzureBatch' service principal must have the 'Classic Virtual
     Machine Contributor' Role-Based Access Control (RBAC) role for the
     specified VNet. The specified subnet must allow communication from the
     Azure Batch service to be able to schedule tasks on the compute nodes.
     This can be verified by checking if the specified VNet has any associated
     Network Security Groups (NSG). If communication to the compute nodes in
     the specified subnet is denied by an NSG, then the Batch service will set
     the state of the compute nodes to unusable. If the specified VNet has any
     associated Network Security Groups (NSG), then a few reserved system ports
     must be enabled for inbound communication. For pools created with a
     virtual machine configuration, enable ports 29876 and 29877, as well as
     port 22 for Linux and port 3389 for Windows. For pools created with a
     cloud service configuration, enable ports 10100, 20100, and 30100. Also
     enable outbound connections to Azure Storage on port 443. For
     cloudServiceConfiguration pools, only 'classic' VNETs are supported. For
     more details see:
     https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
    :type subnet_id: str
    :param endpoint_configuration: The configuration for endpoints on compute
     nodes in the Batch pool. Pool endpoint configuration is only supported on
     pools with the virtualMachineConfiguration property.
    :type endpoint_configuration:
     ~azure.mgmt.batch.models.PoolEndpointConfiguration
    :param public_ip_address_configuration: The Public IPAddress configuration
     for Compute Nodes in the Batch Pool. This property is only supported on
     Pools with the virtualMachineConfiguration property.
    :type public_ip_address_configuration:
     ~azure.mgmt.batch.models.PublicIPAddressConfiguration
    """

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'endpoint_configuration': {'key': 'endpointConfiguration', 'type': 'PoolEndpointConfiguration'},
        'public_ip_address_configuration': {'key': 'publicIPAddressConfiguration', 'type': 'PublicIPAddressConfiguration'},
    }

    def __init__(self, **kwargs):
        super(NetworkConfiguration, self).__init__(**kwargs)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.endpoint_configuration = kwargs.get('endpoint_configuration', None)
        self.public_ip_address_configuration = kwargs.get('public_ip_address_configuration', None)


class NetworkSecurityGroupRule(Model):
    """A network security group rule to apply to an inbound endpoint.

    All required parameters must be populated in order to send to Azure.

    :param priority: Required. The priority for this rule. Priorities within a
     pool must be unique and are evaluated in order of priority. The lower the
     number the higher the priority. For example, rules could be specified with
     order numbers of 150, 250, and 350. The rule with the order number of 150
     takes precedence over the rule that has an order of 250. Allowed
     priorities are 150 to 4096. If any reserved or duplicate values are
     provided the request fails with HTTP status code 400.
    :type priority: int
    :param access: Required. Possible values include: 'Allow', 'Deny'
    :type access: str or
     ~azure.mgmt.batch.models.NetworkSecurityGroupRuleAccess
    :param source_address_prefix: Required. Valid values are a single IP
     address (i.e. 10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag,
     or * (for all addresses).  If any other values are provided the request
     fails with HTTP status code 400.
    :type source_address_prefix: str
    :param source_port_ranges: Valid values are '*' (for all ports 0 - 65535)
     or arrays of ports or port ranges (i.e. 100-200). The ports should in the
     range of 0 to 65535 and the port ranges or ports can't overlap. If any
     other values are provided the request fails with HTTP status code 400.
     Default value will be *.
    :type source_port_ranges: list[str]
    """

    _validation = {
        'priority': {'required': True},
        'access': {'required': True},
        'source_address_prefix': {'required': True},
    }

    _attribute_map = {
        'priority': {'key': 'priority', 'type': 'int'},
        'access': {'key': 'access', 'type': 'NetworkSecurityGroupRuleAccess'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
        'source_port_ranges': {'key': 'sourcePortRanges', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(NetworkSecurityGroupRule, self).__init__(**kwargs)
        self.priority = kwargs.get('priority', None)
        self.access = kwargs.get('access', None)
        self.source_address_prefix = kwargs.get('source_address_prefix', None)
        self.source_port_ranges = kwargs.get('source_port_ranges', None)


class NFSMountConfiguration(Model):
    """Information used to connect to an NFS file system.

    All required parameters must be populated in order to send to Azure.

    :param source: Required.
    :type source: str
    :param relative_mount_path: Required. All file systems are mounted
     relative to the Batch mounts directory, accessible via the
     AZ_BATCH_NODE_MOUNTS_DIR environment variable.
    :type relative_mount_path: str
    :param mount_options: These are 'net use' options in Windows and 'mount'
     options in Linux.
    :type mount_options: str
    """

    _validation = {
        'source': {'required': True},
        'relative_mount_path': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'str'},
        'relative_mount_path': {'key': 'relativeMountPath', 'type': 'str'},
        'mount_options': {'key': 'mountOptions', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NFSMountConfiguration, self).__init__(**kwargs)
        self.source = kwargs.get('source', None)
        self.relative_mount_path = kwargs.get('relative_mount_path', None)
        self.mount_options = kwargs.get('mount_options', None)


class Operation(Model):
    """A REST API operation.

    :param name: This is of the format {provider}/{resource}/{operation}
    :type name: str
    :param display:
    :type display: ~azure.mgmt.batch.models.OperationDisplay
    :param origin:
    :type origin: str
    :param properties:
    :type properties: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class OperationDisplay(Model):
    """The object that describes the operation.

    :param provider:
    :type provider: str
    :param operation: For example: read, write, delete, or listKeys/action
    :type operation: str
    :param resource:
    :type resource: str
    :param description:
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.operation = kwargs.get('operation', None)
        self.resource = kwargs.get('resource', None)
        self.description = kwargs.get('description', None)


class Pool(ProxyResource):
    """Contains information about a pool.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :param display_name: The display name need not be unique and can contain
     any Unicode characters up to a maximum length of 1024.
    :type display_name: str
    :ivar last_modified: This is the last time at which the pool level data,
     such as the targetDedicatedNodes or autoScaleSettings, changed. It does
     not factor in node-level changes such as a compute node changing state.
    :vartype last_modified: datetime
    :ivar creation_time:
    :vartype creation_time: datetime
    :ivar provisioning_state: Possible values include: 'Succeeded', 'Deleting'
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.PoolProvisioningState
    :ivar provisioning_state_transition_time:
    :vartype provisioning_state_transition_time: datetime
    :ivar allocation_state: Possible values include: 'Steady', 'Resizing',
     'Stopping'
    :vartype allocation_state: str or ~azure.mgmt.batch.models.AllocationState
    :ivar allocation_state_transition_time:
    :vartype allocation_state_transition_time: datetime
    :param vm_size: For information about available sizes of virtual machines
     for Cloud Services pools (pools created with cloudServiceConfiguration),
     see Sizes for Cloud Services
     (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/).
     Batch supports all Cloud Services VM sizes except ExtraSmall. For
     information about available VM sizes for pools using images from the
     Virtual Machines Marketplace (pools created with
     virtualMachineConfiguration) see Sizes for Virtual Machines (Linux)
     (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/)
     or Sizes for Virtual Machines (Windows)
     (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/).
     Batch supports all Azure VM sizes except STANDARD_A0 and those with
     premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
    :type vm_size: str
    :param deployment_configuration: This property describes how the pool
     nodes will be deployed - using Cloud Services or Virtual Machines. Using
     CloudServiceConfiguration specifies that the nodes should be creating
     using Azure Cloud Services (PaaS), while VirtualMachineConfiguration uses
     Azure Virtual Machines (IaaS).
    :type deployment_configuration:
     ~azure.mgmt.batch.models.DeploymentConfiguration
    :ivar current_dedicated_nodes: The number of compute nodes currently in
     the pool.
    :vartype current_dedicated_nodes: int
    :ivar current_low_priority_nodes: The number of low priority compute nodes
     currently in the pool.
    :vartype current_low_priority_nodes: int
    :param scale_settings: Settings which configure the number of nodes in the
     pool.
    :type scale_settings: ~azure.mgmt.batch.models.ScaleSettings
    :ivar auto_scale_run: The results and errors from the last execution of
     the autoscale formula. This property is set only if the pool automatically
     scales, i.e. autoScaleSettings are used.
    :vartype auto_scale_run: ~azure.mgmt.batch.models.AutoScaleRun
    :param inter_node_communication: This imposes restrictions on which nodes
     can be assigned to the pool. Enabling this value can reduce the chance of
     the requested number of nodes to be allocated in the pool. If not
     specified, this value defaults to 'Disabled'. Possible values include:
     'Enabled', 'Disabled'
    :type inter_node_communication: str or
     ~azure.mgmt.batch.models.InterNodeCommunicationState
    :param network_configuration: The network configuration for the pool.
    :type network_configuration: ~azure.mgmt.batch.models.NetworkConfiguration
    :param max_tasks_per_node: The maximum number of tasks that can run
     concurrently on a single compute node in the pool. The default value is 1.
     The maximum value is the smaller of 4 times the number of cores of the
     vmSize of the pool or 256.
    :type max_tasks_per_node: int
    :param task_scheduling_policy: How tasks are distributed across compute
     nodes in a pool. If not specified, the default is spread.
    :type task_scheduling_policy:
     ~azure.mgmt.batch.models.TaskSchedulingPolicy
    :param user_accounts:
    :type user_accounts: list[~azure.mgmt.batch.models.UserAccount]
    :param metadata: The Batch service does not assign any meaning to
     metadata; it is solely for the use of user code.
    :type metadata: list[~azure.mgmt.batch.models.MetadataItem]
    :param start_task: A task specified to run on each compute node as it
     joins the pool. In an PATCH (update) operation, this property can be set
     to an empty object to remove the start task from the pool.
    :type start_task: ~azure.mgmt.batch.models.StartTask
    :param certificates: For Windows compute nodes, the Batch service installs
     the certificates to the specified certificate store and location. For
     Linux compute nodes, the certificates are stored in a directory inside the
     task working directory and an environment variable
     AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this
     location. For certificates with visibility of 'remoteUser', a 'certs'
     directory is created in the user's home directory (e.g.,
     /home/{user-name}/certs) and certificates are placed in that directory.
    :type certificates: list[~azure.mgmt.batch.models.CertificateReference]
    :param application_packages: Changes to application package references
     affect all new compute nodes joining the pool, but do not affect compute
     nodes that are already in the pool until they are rebooted or reimaged.
     There is a maximum of 10 application package references on any given pool.
    :type application_packages:
     list[~azure.mgmt.batch.models.ApplicationPackageReference]
    :param application_licenses: The list of application licenses must be a
     subset of available Batch service application licenses. If a license is
     requested which is not supported, pool creation will fail.
    :type application_licenses: list[str]
    :ivar resize_operation_status: Contains details about the current or last
     completed resize operation.
    :vartype resize_operation_status:
     ~azure.mgmt.batch.models.ResizeOperationStatus
    :param mount_configuration: This supports Azure Files, NFS, CIFS/SMB, and
     Blobfuse.
    :type mount_configuration:
     list[~azure.mgmt.batch.models.MountConfiguration]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'last_modified': {'readonly': True},
        'creation_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'provisioning_state_transition_time': {'readonly': True},
        'allocation_state': {'readonly': True},
        'allocation_state_transition_time': {'readonly': True},
        'current_dedicated_nodes': {'readonly': True},
        'current_low_priority_nodes': {'readonly': True},
        'auto_scale_run': {'readonly': True},
        'resize_operation_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'last_modified': {'key': 'properties.lastModified', 'type': 'iso-8601'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'PoolProvisioningState'},
        'provisioning_state_transition_time': {'key': 'properties.provisioningStateTransitionTime', 'type': 'iso-8601'},
        'allocation_state': {'key': 'properties.allocationState', 'type': 'AllocationState'},
        'allocation_state_transition_time': {'key': 'properties.allocationStateTransitionTime', 'type': 'iso-8601'},
        'vm_size': {'key': 'properties.vmSize', 'type': 'str'},
        'deployment_configuration': {'key': 'properties.deploymentConfiguration', 'type': 'DeploymentConfiguration'},
        'current_dedicated_nodes': {'key': 'properties.currentDedicatedNodes', 'type': 'int'},
        'current_low_priority_nodes': {'key': 'properties.currentLowPriorityNodes', 'type': 'int'},
        'scale_settings': {'key': 'properties.scaleSettings', 'type': 'ScaleSettings'},
        'auto_scale_run': {'key': 'properties.autoScaleRun', 'type': 'AutoScaleRun'},
        'inter_node_communication': {'key': 'properties.interNodeCommunication', 'type': 'InterNodeCommunicationState'},
        'network_configuration': {'key': 'properties.networkConfiguration', 'type': 'NetworkConfiguration'},
        'max_tasks_per_node': {'key': 'properties.maxTasksPerNode', 'type': 'int'},
        'task_scheduling_policy': {'key': 'properties.taskSchedulingPolicy', 'type': 'TaskSchedulingPolicy'},
        'user_accounts': {'key': 'properties.userAccounts', 'type': '[UserAccount]'},
        'metadata': {'key': 'properties.metadata', 'type': '[MetadataItem]'},
        'start_task': {'key': 'properties.startTask', 'type': 'StartTask'},
        'certificates': {'key': 'properties.certificates', 'type': '[CertificateReference]'},
        'application_packages': {'key': 'properties.applicationPackages', 'type': '[ApplicationPackageReference]'},
        'application_licenses': {'key': 'properties.applicationLicenses', 'type': '[str]'},
        'resize_operation_status': {'key': 'properties.resizeOperationStatus', 'type': 'ResizeOperationStatus'},
        'mount_configuration': {'key': 'properties.mountConfiguration', 'type': '[MountConfiguration]'},
    }

    def __init__(self, **kwargs):
        super(Pool, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.last_modified = None
        self.creation_time = None
        self.provisioning_state = None
        self.provisioning_state_transition_time = None
        self.allocation_state = None
        self.allocation_state_transition_time = None
        self.vm_size = kwargs.get('vm_size', None)
        self.deployment_configuration = kwargs.get('deployment_configuration', None)
        self.current_dedicated_nodes = None
        self.current_low_priority_nodes = None
        self.scale_settings = kwargs.get('scale_settings', None)
        self.auto_scale_run = None
        self.inter_node_communication = kwargs.get('inter_node_communication', None)
        self.network_configuration = kwargs.get('network_configuration', None)
        self.max_tasks_per_node = kwargs.get('max_tasks_per_node', None)
        self.task_scheduling_policy = kwargs.get('task_scheduling_policy', None)
        self.user_accounts = kwargs.get('user_accounts', None)
        self.metadata = kwargs.get('metadata', None)
        self.start_task = kwargs.get('start_task', None)
        self.certificates = kwargs.get('certificates', None)
        self.application_packages = kwargs.get('application_packages', None)
        self.application_licenses = kwargs.get('application_licenses', None)
        self.resize_operation_status = None
        self.mount_configuration = kwargs.get('mount_configuration', None)


class PoolEndpointConfiguration(Model):
    """The endpoint configuration for a pool.

    All required parameters must be populated in order to send to Azure.

    :param inbound_nat_pools: Required. The maximum number of inbound NAT
     pools per Batch pool is 5. If the maximum number of inbound NAT pools is
     exceeded the request fails with HTTP status code 400.
    :type inbound_nat_pools: list[~azure.mgmt.batch.models.InboundNatPool]
    """

    _validation = {
        'inbound_nat_pools': {'required': True},
    }

    _attribute_map = {
        'inbound_nat_pools': {'key': 'inboundNatPools', 'type': '[InboundNatPool]'},
    }

    def __init__(self, **kwargs):
        super(PoolEndpointConfiguration, self).__init__(**kwargs)
        self.inbound_nat_pools = kwargs.get('inbound_nat_pools', None)


class PrivateEndpoint(Model):
    """The private endpoint of the private endpoint connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id:
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(ProxyResource):
    """Contains information about a private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar provisioning_state: Possible values include: 'Succeeded',
     'Updating', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.batch.models.PrivateEndpointConnectionProvisioningState
    :param private_endpoint: The ARM resource identifier of the private
     endpoint.
    :type private_endpoint: ~azure.mgmt.batch.models.PrivateEndpoint
    :param private_link_service_connection_state: The private link service
     connection state of the private endpoint connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.batch.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'PrivateEndpointConnectionProvisioningState'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)


class PrivateLinkResource(ProxyResource):
    """Contains information about a private link resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: The ETag of the resource, used for concurrency statements.
    :vartype etag: str
    :ivar group_id: The group id is used to establish the private link
     connection.
    :vartype group_id: str
    :ivar required_members:
    :vartype required_members: list[str]
    :ivar required_zone_names:
    :vartype required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
        'required_zone_names': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkServiceConnectionState(Model):
    """The private link service connection state of the private endpoint
    connection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status for the private endpoint connection of
     Batch account. Possible values include: 'Approved', 'Pending', 'Rejected',
     'Disconnected'
    :type status: str or
     ~azure.mgmt.batch.models.PrivateLinkServiceConnectionStatus
    :param description:
    :type description: str
    :ivar action_required:
    :vartype action_required: str
    """

    _validation = {
        'status': {'required': True},
        'action_required': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'PrivateLinkServiceConnectionStatus'},
        'description': {'key': 'description', 'type': 'str'},
        'action_required': {'key': 'actionRequired', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.action_required = None


class PublicIPAddressConfiguration(Model):
    """The public IP Address configuration of the networking configuration of a
    Pool.

    :param provision: The provisioning type for Public IP Addresses for the
     pool. The default value is BatchManaged. Possible values include:
     'BatchManaged', 'UserManaged', 'NoPublicIPAddresses'
    :type provision: str or ~azure.mgmt.batch.models.IPAddressProvisioningType
    :param ip_address_ids: The number of IPs specified here limits the maximum
     size of the Pool - 50 dedicated nodes or 20 low-priority nodes can be
     allocated for each public IP. For example, a pool needing 150 dedicated
     VMs would need at least 3 public IPs specified. Each element of this
     collection is of the form:
     /subscriptions/{subscription}/resourceGroups/{group}/providers/Microsoft.Network/publicIPAddresses/{ip}.
    :type ip_address_ids: list[str]
    """

    _attribute_map = {
        'provision': {'key': 'provision', 'type': 'IPAddressProvisioningType'},
        'ip_address_ids': {'key': 'ipAddressIds', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(PublicIPAddressConfiguration, self).__init__(**kwargs)
        self.provision = kwargs.get('provision', None)
        self.ip_address_ids = kwargs.get('ip_address_ids', None)


class ResizeError(Model):
    """An error that occurred when resizing a pool.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. An identifier for the error. Codes are invariant
     and are intended to be consumed programmatically.
    :type code: str
    :param message: Required. A message describing the error, intended to be
     suitable for display in a user interface.
    :type message: str
    :param details:
    :type details: list[~azure.mgmt.batch.models.ResizeError]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ResizeError]'},
    }

    def __init__(self, **kwargs):
        super(ResizeError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class ResizeOperationStatus(Model):
    """Details about the current or last completed resize operation.

    Describes either the current operation (if the pool AllocationState is
    Resizing) or the previously completed operation (if the AllocationState is
    Steady).

    :param target_dedicated_nodes: The desired number of dedicated compute
     nodes in the pool.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: The desired number of low-priority
     compute nodes in the pool.
    :type target_low_priority_nodes: int
    :param resize_timeout: The default value is 15 minutes. The minimum value
     is 5 minutes. If you specify a value less than 5 minutes, the Batch
     service returns an error; if you are calling the REST API directly, the
     HTTP status code is 400 (Bad Request).
    :type resize_timeout: timedelta
    :param node_deallocation_option: Determines what to do with a node and its
     running task(s) if the pool size is decreasing. The default value is
     requeue. Possible values include: 'Requeue', 'Terminate',
     'TaskCompletion', 'RetainedData'
    :type node_deallocation_option: str or
     ~azure.mgmt.batch.models.ComputeNodeDeallocationOption
    :param start_time:
    :type start_time: datetime
    :param errors: This property is set only if an error occurred during the
     last pool resize, and only when the pool allocationState is Steady.
    :type errors: list[~azure.mgmt.batch.models.ResizeError]
    """

    _attribute_map = {
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'ComputeNodeDeallocationOption'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[ResizeError]'},
    }

    def __init__(self, **kwargs):
        super(ResizeOperationStatus, self).__init__(**kwargs)
        self.target_dedicated_nodes = kwargs.get('target_dedicated_nodes', None)
        self.target_low_priority_nodes = kwargs.get('target_low_priority_nodes', None)
        self.resize_timeout = kwargs.get('resize_timeout', None)
        self.node_deallocation_option = kwargs.get('node_deallocation_option', None)
        self.start_time = kwargs.get('start_time', None)
        self.errors = kwargs.get('errors', None)


class ResourceFile(Model):
    """A single file or multiple files to be downloaded to a compute node.

    :param auto_storage_container_name: The autoStorageContainerName,
     storageContainerUrl and httpUrl properties are mutually exclusive and one
     of them must be specified.
    :type auto_storage_container_name: str
    :param storage_container_url: The autoStorageContainerName,
     storageContainerUrl and httpUrl properties are mutually exclusive and one
     of them must be specified. This URL must be readable and listable using
     anonymous access; that is, the Batch service does not present any
     credentials when downloading the blob. There are two ways to get such a
     URL for a blob in Azure storage: include a Shared Access Signature (SAS)
     granting read and list permissions on the blob, or set the ACL for the
     blob or its container to allow public access.
    :type storage_container_url: str
    :param http_url: The autoStorageContainerName, storageContainerUrl and
     httpUrl properties are mutually exclusive and one of them must be
     specified. If the URL is Azure Blob Storage, it must be readable using
     anonymous access; that is, the Batch service does not present any
     credentials when downloading the blob. There are two ways to get such a
     URL for a blob in Azure storage: include a Shared Access Signature (SAS)
     granting read permissions on the blob, or set the ACL for the blob or its
     container to allow public access.
    :type http_url: str
    :param blob_prefix: The property is valid only when
     autoStorageContainerName or storageContainerUrl is used. This prefix can
     be a partial filename or a subdirectory. If a prefix is not specified, all
     the files in the container will be downloaded.
    :type blob_prefix: str
    :param file_path: If the httpUrl property is specified, the filePath is
     required and describes the path which the file will be downloaded to,
     including the filename. Otherwise, if the autoStorageContainerName or
     storageContainerUrl property is specified, filePath is optional and is the
     directory to download the files to. In the case where filePath is used as
     a directory, any directory structure already associated with the input
     data will be retained in full and appended to the specified filePath
     directory. The specified relative path cannot break out of the task's
     working directory (for example by using '..').
    :type file_path: str
    :param file_mode: This property applies only to files being downloaded to
     Linux compute nodes. It will be ignored if it is specified for a
     resourceFile which will be downloaded to a Windows node. If this property
     is not specified for a Linux node, then a default value of 0770 is applied
     to the file.
    :type file_mode: str
    """

    _attribute_map = {
        'auto_storage_container_name': {'key': 'autoStorageContainerName', 'type': 'str'},
        'storage_container_url': {'key': 'storageContainerUrl', 'type': 'str'},
        'http_url': {'key': 'httpUrl', 'type': 'str'},
        'blob_prefix': {'key': 'blobPrefix', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
        'file_mode': {'key': 'fileMode', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceFile, self).__init__(**kwargs)
        self.auto_storage_container_name = kwargs.get('auto_storage_container_name', None)
        self.storage_container_url = kwargs.get('storage_container_url', None)
        self.http_url = kwargs.get('http_url', None)
        self.blob_prefix = kwargs.get('blob_prefix', None)
        self.file_path = kwargs.get('file_path', None)
        self.file_mode = kwargs.get('file_mode', None)


class ScaleSettings(Model):
    """Scale settings for the pool.

    Defines the desired size of the pool. This can either be 'fixedScale' where
    the requested targetDedicatedNodes is specified, or 'autoScale' which
    defines a formula which is periodically reevaluated. If this property is
    not specified, the pool will have a fixed scale with 0
    targetDedicatedNodes.

    :param fixed_scale: Fixed scale settings for the pool. This property and
     autoScale are mutually exclusive and one of the properties must be
     specified.
    :type fixed_scale: ~azure.mgmt.batch.models.FixedScaleSettings
    :param auto_scale: AutoScale settings for the pool. This property and
     fixedScale are mutually exclusive and one of the properties must be
     specified.
    :type auto_scale: ~azure.mgmt.batch.models.AutoScaleSettings
    """

    _attribute_map = {
        'fixed_scale': {'key': 'fixedScale', 'type': 'FixedScaleSettings'},
        'auto_scale': {'key': 'autoScale', 'type': 'AutoScaleSettings'},
    }

    def __init__(self, **kwargs):
        super(ScaleSettings, self).__init__(**kwargs)
        self.fixed_scale = kwargs.get('fixed_scale', None)
        self.auto_scale = kwargs.get('auto_scale', None)


class StartTask(Model):
    """A task which is run when a compute node joins a pool in the Azure Batch
    service, or when the compute node is rebooted or reimaged.

    In some cases the start task may be re-run even though the node was not
    rebooted. Due to this, start tasks should be idempotent and exit gracefully
    if the setup they're performing has already been done. Special care should
    be taken to avoid start tasks which create breakaway process or
    install/launch services from the start task working directory, as this will
    block Batch from being able to re-run the start task.

    :param command_line: The command line does not run under a shell, and
     therefore cannot take advantage of shell features such as environment
     variable expansion. If you want to take advantage of such features, you
     should invoke the shell in the command line, for example using "cmd /c
     MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. Required if any
     other properties of the startTask are specified.
    :type command_line: str
    :param resource_files:
    :type resource_files: list[~azure.mgmt.batch.models.ResourceFile]
    :param environment_settings:
    :type environment_settings:
     list[~azure.mgmt.batch.models.EnvironmentSetting]
    :param user_identity: The user identity under which the start task runs.
     If omitted, the task runs as a non-administrative user unique to the task.
    :type user_identity: ~azure.mgmt.batch.models.UserIdentity
    :param max_task_retry_count: The maximum number of times the task may be
     retried. The Batch service retries a task if its exit code is nonzero.
     Note that this value specifically controls the number of retries. The
     Batch service will try the task once, and may then retry up to this limit.
     For example, if the maximum retry count is 3, Batch tries the task up to 4
     times (one initial try and 3 retries). If the maximum retry count is 0,
     the Batch service does not retry the task. If the maximum retry count is
     -1, the Batch service retries the task without limit.
    :type max_task_retry_count: int
    :param wait_for_success: Whether the Batch service should wait for the
     start task to complete successfully (that is, to exit with exit code 0)
     before scheduling any tasks on the compute node. If true and the start
     task fails on a compute node, the Batch service retries the start task up
     to its maximum retry count (maxTaskRetryCount). If the task has still not
     completed successfully after all retries, then the Batch service marks the
     compute node unusable, and will not schedule tasks to it. This condition
     can be detected via the node state and scheduling error detail. If false,
     the Batch service will not wait for the start task to complete. In this
     case, other tasks can start executing on the compute node while the start
     task is still running; and even if the start task fails, new tasks will
     continue to be scheduled on the node. The default is true.
    :type wait_for_success: bool
    :param container_settings: The settings for the container under which the
     start task runs. When this is specified, all directories recursively below
     the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the
     node) are mapped into the container, all task environment variables are
     mapped into the container, and the task command line is executed in the
     container.
    :type container_settings: ~azure.mgmt.batch.models.TaskContainerSettings
    """

    _attribute_map = {
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'resource_files': {'key': 'resourceFiles', 'type': '[ResourceFile]'},
        'environment_settings': {'key': 'environmentSettings', 'type': '[EnvironmentSetting]'},
        'user_identity': {'key': 'userIdentity', 'type': 'UserIdentity'},
        'max_task_retry_count': {'key': 'maxTaskRetryCount', 'type': 'int'},
        'wait_for_success': {'key': 'waitForSuccess', 'type': 'bool'},
        'container_settings': {'key': 'containerSettings', 'type': 'TaskContainerSettings'},
    }

    def __init__(self, **kwargs):
        super(StartTask, self).__init__(**kwargs)
        self.command_line = kwargs.get('command_line', None)
        self.resource_files = kwargs.get('resource_files', None)
        self.environment_settings = kwargs.get('environment_settings', None)
        self.user_identity = kwargs.get('user_identity', None)
        self.max_task_retry_count = kwargs.get('max_task_retry_count', None)
        self.wait_for_success = kwargs.get('wait_for_success', None)
        self.container_settings = kwargs.get('container_settings', None)


class TaskContainerSettings(Model):
    """The container settings for a task.

    All required parameters must be populated in order to send to Azure.

    :param container_run_options: These additional options are supplied as
     arguments to the "docker create" command, in addition to those controlled
     by the Batch Service.
    :type container_run_options: str
    :param image_name: Required. This is the full image reference, as would be
     specified to "docker pull". If no tag is provided as part of the image
     name, the tag ":latest" is used as a default.
    :type image_name: str
    :param registry: The private registry which contains the container image.
     This setting can be omitted if was already provided at pool creation.
    :type registry: ~azure.mgmt.batch.models.ContainerRegistry
    :param working_directory: Possible values include: 'TaskWorkingDirectory',
     'ContainerImageDefault'
    :type working_directory: str or
     ~azure.mgmt.batch.models.ContainerWorkingDirectory
    """

    _validation = {
        'image_name': {'required': True},
    }

    _attribute_map = {
        'container_run_options': {'key': 'containerRunOptions', 'type': 'str'},
        'image_name': {'key': 'imageName', 'type': 'str'},
        'registry': {'key': 'registry', 'type': 'ContainerRegistry'},
        'working_directory': {'key': 'workingDirectory', 'type': 'ContainerWorkingDirectory'},
    }

    def __init__(self, **kwargs):
        super(TaskContainerSettings, self).__init__(**kwargs)
        self.container_run_options = kwargs.get('container_run_options', None)
        self.image_name = kwargs.get('image_name', None)
        self.registry = kwargs.get('registry', None)
        self.working_directory = kwargs.get('working_directory', None)


class TaskSchedulingPolicy(Model):
    """Specifies how tasks should be distributed across compute nodes.

    All required parameters must be populated in order to send to Azure.

    :param node_fill_type: Required. Possible values include: 'Spread', 'Pack'
    :type node_fill_type: str or ~azure.mgmt.batch.models.ComputeNodeFillType
    """

    _validation = {
        'node_fill_type': {'required': True},
    }

    _attribute_map = {
        'node_fill_type': {'key': 'nodeFillType', 'type': 'ComputeNodeFillType'},
    }

    def __init__(self, **kwargs):
        super(TaskSchedulingPolicy, self).__init__(**kwargs)
        self.node_fill_type = kwargs.get('node_fill_type', None)


class UserAccount(Model):
    """Properties used to create a user on an Azure Batch node.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param password: Required.
    :type password: str
    :param elevation_level: The elevation level of the user account. nonAdmin
     - The auto user is a standard user without elevated access. admin - The
     auto user is a user with elevated access and operates with full
     Administrator permissions. The default value is nonAdmin. Possible values
     include: 'NonAdmin', 'Admin'
    :type elevation_level: str or ~azure.mgmt.batch.models.ElevationLevel
    :param linux_user_configuration: The Linux-specific user configuration for
     the user account. This property is ignored if specified on a Windows pool.
     If not specified, the user is created with the default options.
    :type linux_user_configuration:
     ~azure.mgmt.batch.models.LinuxUserConfiguration
    :param windows_user_configuration: The Windows-specific user configuration
     for the user account. This property can only be specified if the user is
     on a Windows pool. If not specified and on a Windows pool, the user is
     created with the default options.
    :type windows_user_configuration:
     ~azure.mgmt.batch.models.WindowsUserConfiguration
    """

    _validation = {
        'name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'ElevationLevel'},
        'linux_user_configuration': {'key': 'linuxUserConfiguration', 'type': 'LinuxUserConfiguration'},
        'windows_user_configuration': {'key': 'windowsUserConfiguration', 'type': 'WindowsUserConfiguration'},
    }

    def __init__(self, **kwargs):
        super(UserAccount, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.password = kwargs.get('password', None)
        self.elevation_level = kwargs.get('elevation_level', None)
        self.linux_user_configuration = kwargs.get('linux_user_configuration', None)
        self.windows_user_configuration = kwargs.get('windows_user_configuration', None)


class UserIdentity(Model):
    """The definition of the user identity under which the task is run.

    Specify either the userName or autoUser property, but not both.

    :param user_name: The userName and autoUser properties are mutually
     exclusive; you must specify one but not both.
    :type user_name: str
    :param auto_user: The auto user under which the task is run. The userName
     and autoUser properties are mutually exclusive; you must specify one but
     not both.
    :type auto_user: ~azure.mgmt.batch.models.AutoUserSpecification
    """

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'auto_user': {'key': 'autoUser', 'type': 'AutoUserSpecification'},
    }

    def __init__(self, **kwargs):
        super(UserIdentity, self).__init__(**kwargs)
        self.user_name = kwargs.get('user_name', None)
        self.auto_user = kwargs.get('auto_user', None)


class VirtualMachineConfiguration(Model):
    """The configuration for compute nodes in a pool based on the Azure Virtual
    Machines infrastructure.

    All required parameters must be populated in order to send to Azure.

    :param image_reference: Required. A reference to the Azure Virtual
     Machines Marketplace Image or the custom Virtual Machine Image to use.
    :type image_reference: ~azure.mgmt.batch.models.ImageReference
    :param node_agent_sku_id: Required. The Batch node agent is a program that
     runs on each node in the pool, and provides the command-and-control
     interface between the node and the Batch service. There are different
     implementations of the node agent, known as SKUs, for different operating
     systems. You must specify a node agent SKU which matches the selected
     image reference. To get the list of supported node agent SKUs along with
     their list of verified image references, see the 'List supported node
     agent SKUs' operation.
    :type node_agent_sku_id: str
    :param windows_configuration: Windows operating system settings on the
     virtual machine. This property must not be specified if the imageReference
     specifies a Linux OS image.
    :type windows_configuration: ~azure.mgmt.batch.models.WindowsConfiguration
    :param data_disks: This property must be specified if the compute nodes in
     the pool need to have empty data disks attached to them.
    :type data_disks: list[~azure.mgmt.batch.models.DataDisk]
    :param license_type: This only applies to images that contain the Windows
     operating system, and should only be used when you hold valid on-premises
     licenses for the nodes which will be deployed. If omitted, no on-premises
     licensing discount is applied. Values are:
     Windows_Server - The on-premises license is for Windows Server.
     Windows_Client - The on-premises license is for Windows Client.
    :type license_type: str
    :param container_configuration: The container configuration for the pool.
     If specified, setup is performed on each node in the pool to allow tasks
     to run in containers. All regular tasks and job manager tasks run on this
     pool must specify the containerSettings property, and all other tasks may
     specify it.
    :type container_configuration:
     ~azure.mgmt.batch.models.ContainerConfiguration
    :param disk_encryption_configuration: The disk encryption configuration
     for the pool. If specified, encryption is performed on each node in the
     pool during node provisioning.
    :type disk_encryption_configuration:
     ~azure.mgmt.batch.models.DiskEncryptionConfiguration
    """

    _validation = {
        'image_reference': {'required': True},
        'node_agent_sku_id': {'required': True},
    }

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'node_agent_sku_id': {'key': 'nodeAgentSkuId', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'data_disks': {'key': 'dataDisks', 'type': '[DataDisk]'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'container_configuration': {'key': 'containerConfiguration', 'type': 'ContainerConfiguration'},
        'disk_encryption_configuration': {'key': 'diskEncryptionConfiguration', 'type': 'DiskEncryptionConfiguration'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineConfiguration, self).__init__(**kwargs)
        self.image_reference = kwargs.get('image_reference', None)
        self.node_agent_sku_id = kwargs.get('node_agent_sku_id', None)
        self.windows_configuration = kwargs.get('windows_configuration', None)
        self.data_disks = kwargs.get('data_disks', None)
        self.license_type = kwargs.get('license_type', None)
        self.container_configuration = kwargs.get('container_configuration', None)
        self.disk_encryption_configuration = kwargs.get('disk_encryption_configuration', None)


class VirtualMachineFamilyCoreQuota(Model):
    """A VM Family and its associated core quota for the Batch account.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The Virtual Machine family name.
    :vartype name: str
    :ivar core_quota: The core quota for the VM family for the Batch account.
    :vartype core_quota: int
    """

    _validation = {
        'name': {'readonly': True},
        'core_quota': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'core_quota': {'key': 'coreQuota', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineFamilyCoreQuota, self).__init__(**kwargs)
        self.name = None
        self.core_quota = None


class WindowsConfiguration(Model):
    """Windows operating system settings to apply to the virtual machine.

    :param enable_automatic_updates: Whether automatic updates are enabled on
     the virtual machine. If omitted, the default value is true.
    :type enable_automatic_updates: bool
    """

    _attribute_map = {
        'enable_automatic_updates': {'key': 'enableAutomaticUpdates', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(WindowsConfiguration, self).__init__(**kwargs)
        self.enable_automatic_updates = kwargs.get('enable_automatic_updates', None)


class WindowsUserConfiguration(Model):
    """Properties used to create a user account on a Windows node.

    :param login_mode: Specifies login mode for the user. The default value
     for VirtualMachineConfiguration pools is interactive mode and for
     CloudServiceConfiguration pools is batch mode. Possible values include:
     'Batch', 'Interactive'
    :type login_mode: str or ~azure.mgmt.batch.models.LoginMode
    """

    _attribute_map = {
        'login_mode': {'key': 'loginMode', 'type': 'LoginMode'},
    }

    def __init__(self, **kwargs):
        super(WindowsUserConfiguration, self).__init__(**kwargs)
        self.login_mode = kwargs.get('login_mode', None)
