# -*- coding: utf-8 -*-
#编码相关的函数
import uuid,datetime,base64
import hashlib
import traceback
import random

def get_uuid():
    return str(uuid.uuid1())

def generate_imei():
    device_type_list = [u'86783002', u'86748902', u'99000760', u'86724602', u'86162603', u'86602902', u'A0000055', u'86639402', u'86861202', u'86801702', u'86940202', u'86856802', u'86764902', u'86746902', u'86603202', u'86095402', u'A0000059', u'86075003', u'86026703', u'35714304', u'86746302', u'86558902', u'35322305', u'35340506', u'35809405', u'86105403', u'86397002', u'35578205', u'86327802', u'35291106', u'86885602', u'86418602', u'86685702', u'35538306', u'86104203', u'86669702', u'99000291', u'35748503', u'86702202', u'A0000049', u'A0000048', u'86872102', u'86436702', u'86858602', u'35602206', u'35500907', u'86114103', u'35818005', u'86558702', u'86954502', u'35477906', u'35990105', u'35944105', u'86439411', u'86172603', u'86923102', u'86824002', u'86880702', u'86153303', u'86073703', u'86967102', u'86460102', u'86016203', u'86697802', u'86268802', u'86815702', u'86593102', u'86745102', u'35774705', u'86426402', u'86027003', u'86711002', u'35418306', u'86627202', u'86732302', u'86381101', u'35586805', u'86585402', u'86724702', u'35478206', u'86048503', u'86802402', u'35552107', u'86200703', u'86941002', u'86767702', u'86696302', u'86373802', u'86897802', u'86844902', u'86107803', u'35273706', u'86581302', u'99000581', u'86815302', u'35376507', u'86640102', u'35752305', u'A1000032', u'86896602', u'35579505', u'86669602', u'35709206', u'86095403', u'86787802', u'86694702', u'86306102', u'35858405', u'86007603', u'86455902', u'86889702', u'35709506', u'86647902', u'35713805', u'86699302', u'86552802', u'86806402', u'35876606', u'35210506', u'35823905', u'86098303', u'86993802', u'86879002', u'86823802', u'86812902', u'86766402', u'86516602', u'86296602', u'86558602', u'86542402', u'86556702', u'86801302', u'86519902', u'86664102', u'86760202', u'35392506', u'86705002', u'86275102', u'86048602', u'99000830', u'35988106', u'35584806', u'35848903', u'35841404', u'86625900', u'86992202', u'86022702', u'86174903', u'99000628', u'99000537', u'86085803', u'86727502', u'99000559', u'86636102', u'35917105', u'86564802', u'86965402', u'86738902', u'86278402', u'86523302', u'99000554', u'86778002', u'86856002', u'86633302', u'86852402', u'A000004F', u'86489502', u'35472807', u'35995006', u'86079803', u'A1000042', u'35220306', u'86799302', u'86629902', u'86706802', u'86669302', u'86751502', u'86896802', u'86808802', u'35750705', u'00000000', u'86113802', u'86708002', u'86644502', u'35569806', u'a000004f', u'86808902', u'86785502', u'86696002', u'86901102', u'86161503', u'86633002', u'86767602', u'86135303', u'86998902', u'86108403', u'35422406', u'86762002', u'A1000056', u'86829902', u'86557702', u'99000525', u'99000645', u'86815202', u'86450202', u'86663402', u'86524202', u'86694602', u'86825602', u'86893002', u'86469002', u'86567402', u'35774505', u'86885402', u'86598202', u'86041003', u'86168103', u'35521806', u'35810806', u'86656802', u'86929602', u'86026803', u'86333002', u'35311606', u'86768902', u'35220406', u'86915702', u'86886002', u'86787502', u'35513306', u'35978605', u'35620505', u'86662002', u'99000579', u'86073603', u'86760002', u'35881406', u'35920902', u'86735802', u'86071603', u'35170207', u'86633202', u'86737602', u'35538606', u'86483602', u'86802902', u'86516802', u'86946402', u'86908502', u'86909502', u'86873402', u'86956002', u'35506606', u'86781201', u'86604202', u'86983202', u'86884202', u'86520602', u'86541001', u'86632902', u'86725502', u'35262506', u'86967702', u'86897902', u'86519802', u'86693802', u'35323207', u'86957302', u'81234567', u'86779302', u'86650002', u'99000774', u'35675106', u'35838001', u'86516402', u'A1000049', u'86840602', u'86024103', u'86701802', u'86766202', u'86933402', u'86623202', u'86454502', u'86764102', u'86136503', u'86096503', u'35416906', u'86762802', u'99000848', u'86606802', u'35809604', u'86756702', u'86581402', u'86151903', u'35316606', u'35554605', u'35787305', u'86958002', u'86145103', u'86875602', u'86963702', u'86972202', u'86791002', u'35257507', u'86307702', u'86462002', u'99000806', u'86706402', u'86079903', u'86782202', u'35460207']
    device_type = random.choice(device_type_list)
    no = random.randint(111111,888888)
    digits14 = '{device_type}{no}'.format(device_type=device_type,no=no)
    digit15=0
    for num in range(14):
        if num%2==0:
            digit15=digit15+int(digits14[num])
        else:
            digit15=digit15+(int(digits14[num])*2)%10+(int(digits14[num])*2)/10
    digit15=int(digit15)%10
    if digit15==0:
        digits14=digits14+str(digit15)
    else:
        digits14=digits14+str(10-digit15)
    return digits14


def get_hash_code(value,sign='7788521'):
    '''返回加入了干扰码的md5'''
    return hashlib.new('md5',value+sign).hexdigest()

def md5(value):
    return hashlib.new('md5',value).hexdigest()


def base64_url_encode(value):
    '''base64基于url安全的加密函数'''
    value=value.encode(encoding="utf-8")
    return base64.urlsafe_b64encode(value)


def base64_url_decode(value):
    '''base64基于url安全的解密函数'''
    try:
        value = str(value)
        result= base64.urlsafe_b64decode(value)
        result = unicode(result,'utf-8')
        return result
    except:
        print(traceback.format_exc())
        return None


def to_unicode(s,encoding=None):
    '''转换成unicode'''
    if isinstance(s, unicode):
        return s
    else:
        if encoding:
            return unicode(s,encoding)
        else:
            return unicode(s)



if __name__=='__main__':
    print(md5('1'))
    print(generate_imei())