/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import java.util.regex.Pattern;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class RegexpValidator
implements Validator<String> {
    Pattern pattern;

    public RegexpValidator(String regexp) {
        this.pattern = Pattern.compile(regexp);
    }

    @Override
    public String validate(String parameterValue, ModelValidatorContext context, boolean isVariableHidden) throws ValidationException {
        if (!this.pattern.matcher(parameterValue).matches()) {
            throw new ValidationException("Expected value should match regular expression " + this.pattern.pattern() + " , received " + parameterValue);
        }
        return parameterValue;
    }
}

