# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin
from msrest import Deserializer, Serializer

from ._configuration import ContainerRegistryManagementClientConfiguration

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential
    from azure.core.credentials_async import AsyncTokenCredential

class _SDKClient(object):
    def __init__(self, *args, **kwargs):
        """This is a fake class to support current implemetation of MultiApiClientMixin."
        Will be removed in final version of multiapi azure-core based client
        """
        pass

class ContainerRegistryManagementClient(MultiApiClientMixin, _SDKClient):
    """ContainerRegistryManagementClient.

    This ready contains multiple API versions, to help you deal with all of the Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, it uses the latest API version available on public Azure.
    For production, you should stick to a particular api-version and/or profile.
    The profile sets a mapping between an operation group and its API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The Microsoft Azure subscription ID.
    :type subscription_id: str
    :param api_version: API version to use if no profile is provided, or if missing in profile.
    :type api_version: str
    :param base_url: Service URL
    :type base_url: str
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    DEFAULT_API_VERSION = '2021-09-01'
    _PROFILE_TAG = "azure.mgmt.containerregistry.ContainerRegistryManagementClient"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
            'agent_pools': '2019-06-01-preview',
            'build_steps': '2018-02-01-preview',
            'build_tasks': '2018-02-01-preview',
            'builds': '2018-02-01-preview',
            'connected_registries': '2021-08-01-preview',
            'export_pipelines': '2021-08-01-preview',
            'import_pipelines': '2021-08-01-preview',
            'pipeline_runs': '2021-08-01-preview',
            'runs': '2019-04-01',
            'scope_maps': '2021-08-01-preview',
            'task_runs': '2019-06-01-preview',
            'tasks': '2019-04-01',
            'tokens': '2021-08-01-preview',
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        api_version: Optional[str] = None,
        base_url: str = "https://management.azure.com",
        profile: KnownProfiles = KnownProfiles.default,
        **kwargs  # type: Any
    ) -> None:
        self._config = ContainerRegistryManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)
        super(ContainerRegistryManagementClient, self).__init__(
            api_version=api_version,
            profile=profile
        )

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2017-03-01: :mod:`v2017_03_01.models<azure.mgmt.containerregistry.v2017_03_01.models>`
           * 2017-10-01: :mod:`v2017_10_01.models<azure.mgmt.containerregistry.v2017_10_01.models>`
           * 2018-02-01-preview: :mod:`v2018_02_01_preview.models<azure.mgmt.containerregistry.v2018_02_01_preview.models>`
           * 2018-09-01: :mod:`v2018_09_01.models<azure.mgmt.containerregistry.v2018_09_01.models>`
           * 2019-04-01: :mod:`v2019_04_01.models<azure.mgmt.containerregistry.v2019_04_01.models>`
           * 2019-05-01: :mod:`v2019_05_01.models<azure.mgmt.containerregistry.v2019_05_01.models>`
           * 2019-05-01-preview: :mod:`v2019_05_01_preview.models<azure.mgmt.containerregistry.v2019_05_01_preview.models>`
           * 2019-06-01-preview: :mod:`v2019_06_01_preview.models<azure.mgmt.containerregistry.v2019_06_01_preview.models>`
           * 2019-12-01-preview: :mod:`v2019_12_01_preview.models<azure.mgmt.containerregistry.v2019_12_01_preview.models>`
           * 2020-11-01-preview: :mod:`v2020_11_01_preview.models<azure.mgmt.containerregistry.v2020_11_01_preview.models>`
           * 2021-06-01-preview: :mod:`v2021_06_01_preview.models<azure.mgmt.containerregistry.v2021_06_01_preview.models>`
           * 2021-08-01-preview: :mod:`v2021_08_01_preview.models<azure.mgmt.containerregistry.v2021_08_01_preview.models>`
           * 2021-09-01: :mod:`v2021_09_01.models<azure.mgmt.containerregistry.v2021_09_01.models>`
        """
        if api_version == '2017-03-01':
            from ..v2017_03_01 import models
            return models
        elif api_version == '2017-10-01':
            from ..v2017_10_01 import models
            return models
        elif api_version == '2018-02-01-preview':
            from ..v2018_02_01_preview import models
            return models
        elif api_version == '2018-09-01':
            from ..v2018_09_01 import models
            return models
        elif api_version == '2019-04-01':
            from ..v2019_04_01 import models
            return models
        elif api_version == '2019-05-01':
            from ..v2019_05_01 import models
            return models
        elif api_version == '2019-05-01-preview':
            from ..v2019_05_01_preview import models
            return models
        elif api_version == '2019-06-01-preview':
            from ..v2019_06_01_preview import models
            return models
        elif api_version == '2019-12-01-preview':
            from ..v2019_12_01_preview import models
            return models
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview import models
            return models
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview import models
            return models
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview import models
            return models
        elif api_version == '2021-09-01':
            from ..v2021_09_01 import models
            return models
        raise ValueError("API version {} is not available".format(api_version))

    @property
    def agent_pools(self):
        """Instance depends on the API version:

           * 2019-06-01-preview: :class:`AgentPoolsOperations<azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.AgentPoolsOperations>`
        """
        api_version = self._get_api_version('agent_pools')
        if api_version == '2019-06-01-preview':
            from ..v2019_06_01_preview.aio.operations import AgentPoolsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'agent_pools'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def build_steps(self):
        """Instance depends on the API version:

           * 2018-02-01-preview: :class:`BuildStepsOperations<azure.mgmt.containerregistry.v2018_02_01_preview.aio.operations.BuildStepsOperations>`
        """
        api_version = self._get_api_version('build_steps')
        if api_version == '2018-02-01-preview':
            from ..v2018_02_01_preview.aio.operations import BuildStepsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'build_steps'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def build_tasks(self):
        """Instance depends on the API version:

           * 2018-02-01-preview: :class:`BuildTasksOperations<azure.mgmt.containerregistry.v2018_02_01_preview.aio.operations.BuildTasksOperations>`
        """
        api_version = self._get_api_version('build_tasks')
        if api_version == '2018-02-01-preview':
            from ..v2018_02_01_preview.aio.operations import BuildTasksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'build_tasks'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def builds(self):
        """Instance depends on the API version:

           * 2018-02-01-preview: :class:`BuildsOperations<azure.mgmt.containerregistry.v2018_02_01_preview.aio.operations.BuildsOperations>`
        """
        api_version = self._get_api_version('builds')
        if api_version == '2018-02-01-preview':
            from ..v2018_02_01_preview.aio.operations import BuildsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'builds'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def connected_registries(self):
        """Instance depends on the API version:

           * 2020-11-01-preview: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.ConnectedRegistriesOperations>`
           * 2021-06-01-preview: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.ConnectedRegistriesOperations>`
           * 2021-08-01-preview: :class:`ConnectedRegistriesOperations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.ConnectedRegistriesOperations>`
        """
        api_version = self._get_api_version('connected_registries')
        if api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import ConnectedRegistriesOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import ConnectedRegistriesOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import ConnectedRegistriesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'connected_registries'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def export_pipelines(self):
        """Instance depends on the API version:

           * 2019-12-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2019_12_01_preview.aio.operations.ExportPipelinesOperations>`
           * 2020-11-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.ExportPipelinesOperations>`
           * 2021-06-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.ExportPipelinesOperations>`
           * 2021-08-01-preview: :class:`ExportPipelinesOperations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.ExportPipelinesOperations>`
        """
        api_version = self._get_api_version('export_pipelines')
        if api_version == '2019-12-01-preview':
            from ..v2019_12_01_preview.aio.operations import ExportPipelinesOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import ExportPipelinesOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import ExportPipelinesOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import ExportPipelinesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'export_pipelines'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def import_pipelines(self):
        """Instance depends on the API version:

           * 2019-12-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2019_12_01_preview.aio.operations.ImportPipelinesOperations>`
           * 2020-11-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.ImportPipelinesOperations>`
           * 2021-06-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.ImportPipelinesOperations>`
           * 2021-08-01-preview: :class:`ImportPipelinesOperations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.ImportPipelinesOperations>`
        """
        api_version = self._get_api_version('import_pipelines')
        if api_version == '2019-12-01-preview':
            from ..v2019_12_01_preview.aio.operations import ImportPipelinesOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import ImportPipelinesOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import ImportPipelinesOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import ImportPipelinesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'import_pipelines'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def operations(self):
        """Instance depends on the API version:

           * 2017-03-01: :class:`Operations<azure.mgmt.containerregistry.v2017_03_01.aio.operations.Operations>`
           * 2017-10-01: :class:`Operations<azure.mgmt.containerregistry.v2017_10_01.aio.operations.Operations>`
           * 2019-05-01: :class:`Operations<azure.mgmt.containerregistry.v2019_05_01.aio.operations.Operations>`
           * 2019-12-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2019_12_01_preview.aio.operations.Operations>`
           * 2020-11-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.Operations>`
           * 2021-06-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.Operations>`
           * 2021-08-01-preview: :class:`Operations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.Operations>`
           * 2021-09-01: :class:`Operations<azure.mgmt.containerregistry.v2021_09_01.aio.operations.Operations>`
        """
        api_version = self._get_api_version('operations')
        if api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations import Operations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations import Operations as OperationClass
        elif api_version == '2019-05-01':
            from ..v2019_05_01.aio.operations import Operations as OperationClass
        elif api_version == '2019-12-01-preview':
            from ..v2019_12_01_preview.aio.operations import Operations as OperationClass
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import Operations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import Operations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import Operations as OperationClass
        elif api_version == '2021-09-01':
            from ..v2021_09_01.aio.operations import Operations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'operations'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def pipeline_runs(self):
        """Instance depends on the API version:

           * 2019-12-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2019_12_01_preview.aio.operations.PipelineRunsOperations>`
           * 2020-11-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.PipelineRunsOperations>`
           * 2021-06-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.PipelineRunsOperations>`
           * 2021-08-01-preview: :class:`PipelineRunsOperations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.PipelineRunsOperations>`
        """
        api_version = self._get_api_version('pipeline_runs')
        if api_version == '2019-12-01-preview':
            from ..v2019_12_01_preview.aio.operations import PipelineRunsOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import PipelineRunsOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import PipelineRunsOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import PipelineRunsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'pipeline_runs'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def private_endpoint_connections(self):
        """Instance depends on the API version:

           * 2019-12-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2019_12_01_preview.aio.operations.PrivateEndpointConnectionsOperations>`
           * 2020-11-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.PrivateEndpointConnectionsOperations>`
           * 2021-06-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.PrivateEndpointConnectionsOperations>`
           * 2021-08-01-preview: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.PrivateEndpointConnectionsOperations>`
           * 2021-09-01: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.containerregistry.v2021_09_01.aio.operations.PrivateEndpointConnectionsOperations>`
        """
        api_version = self._get_api_version('private_endpoint_connections')
        if api_version == '2019-12-01-preview':
            from ..v2019_12_01_preview.aio.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2021-09-01':
            from ..v2021_09_01.aio.operations import PrivateEndpointConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'private_endpoint_connections'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def registries(self):
        """Instance depends on the API version:

           * 2017-03-01: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2017_03_01.aio.operations.RegistriesOperations>`
           * 2017-10-01: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2017_10_01.aio.operations.RegistriesOperations>`
           * 2018-02-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2018_02_01_preview.aio.operations.RegistriesOperations>`
           * 2018-09-01: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2018_09_01.aio.operations.RegistriesOperations>`
           * 2019-04-01: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2019_04_01.aio.operations.RegistriesOperations>`
           * 2019-05-01: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2019_05_01.aio.operations.RegistriesOperations>`
           * 2019-05-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2019_05_01_preview.aio.operations.RegistriesOperations>`
           * 2019-06-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.RegistriesOperations>`
           * 2019-12-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2019_12_01_preview.aio.operations.RegistriesOperations>`
           * 2020-11-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.RegistriesOperations>`
           * 2021-06-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.RegistriesOperations>`
           * 2021-08-01-preview: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.RegistriesOperations>`
           * 2021-09-01: :class:`RegistriesOperations<azure.mgmt.containerregistry.v2021_09_01.aio.operations.RegistriesOperations>`
        """
        api_version = self._get_api_version('registries')
        if api_version == '2017-03-01':
            from ..v2017_03_01.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2018-02-01-preview':
            from ..v2018_02_01_preview.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2018-09-01':
            from ..v2018_09_01.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2019-05-01':
            from ..v2019_05_01.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2019-05-01-preview':
            from ..v2019_05_01_preview.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2019-06-01-preview':
            from ..v2019_06_01_preview.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2019-12-01-preview':
            from ..v2019_12_01_preview.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import RegistriesOperations as OperationClass
        elif api_version == '2021-09-01':
            from ..v2021_09_01.aio.operations import RegistriesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'registries'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def replications(self):
        """Instance depends on the API version:

           * 2017-10-01: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2017_10_01.aio.operations.ReplicationsOperations>`
           * 2019-05-01: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2019_05_01.aio.operations.ReplicationsOperations>`
           * 2019-12-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2019_12_01_preview.aio.operations.ReplicationsOperations>`
           * 2020-11-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.ReplicationsOperations>`
           * 2021-06-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.ReplicationsOperations>`
           * 2021-08-01-preview: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.ReplicationsOperations>`
           * 2021-09-01: :class:`ReplicationsOperations<azure.mgmt.containerregistry.v2021_09_01.aio.operations.ReplicationsOperations>`
        """
        api_version = self._get_api_version('replications')
        if api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations import ReplicationsOperations as OperationClass
        elif api_version == '2019-05-01':
            from ..v2019_05_01.aio.operations import ReplicationsOperations as OperationClass
        elif api_version == '2019-12-01-preview':
            from ..v2019_12_01_preview.aio.operations import ReplicationsOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import ReplicationsOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import ReplicationsOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import ReplicationsOperations as OperationClass
        elif api_version == '2021-09-01':
            from ..v2021_09_01.aio.operations import ReplicationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'replications'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def runs(self):
        """Instance depends on the API version:

           * 2018-09-01: :class:`RunsOperations<azure.mgmt.containerregistry.v2018_09_01.aio.operations.RunsOperations>`
           * 2019-04-01: :class:`RunsOperations<azure.mgmt.containerregistry.v2019_04_01.aio.operations.RunsOperations>`
           * 2019-06-01-preview: :class:`RunsOperations<azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.RunsOperations>`
        """
        api_version = self._get_api_version('runs')
        if api_version == '2018-09-01':
            from ..v2018_09_01.aio.operations import RunsOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations import RunsOperations as OperationClass
        elif api_version == '2019-06-01-preview':
            from ..v2019_06_01_preview.aio.operations import RunsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'runs'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def scope_maps(self):
        """Instance depends on the API version:

           * 2019-05-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2019_05_01_preview.aio.operations.ScopeMapsOperations>`
           * 2020-11-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.ScopeMapsOperations>`
           * 2021-06-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.ScopeMapsOperations>`
           * 2021-08-01-preview: :class:`ScopeMapsOperations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.ScopeMapsOperations>`
        """
        api_version = self._get_api_version('scope_maps')
        if api_version == '2019-05-01-preview':
            from ..v2019_05_01_preview.aio.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import ScopeMapsOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import ScopeMapsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'scope_maps'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def task_runs(self):
        """Instance depends on the API version:

           * 2019-06-01-preview: :class:`TaskRunsOperations<azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.TaskRunsOperations>`
        """
        api_version = self._get_api_version('task_runs')
        if api_version == '2019-06-01-preview':
            from ..v2019_06_01_preview.aio.operations import TaskRunsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'task_runs'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def tasks(self):
        """Instance depends on the API version:

           * 2018-09-01: :class:`TasksOperations<azure.mgmt.containerregistry.v2018_09_01.aio.operations.TasksOperations>`
           * 2019-04-01: :class:`TasksOperations<azure.mgmt.containerregistry.v2019_04_01.aio.operations.TasksOperations>`
           * 2019-06-01-preview: :class:`TasksOperations<azure.mgmt.containerregistry.v2019_06_01_preview.aio.operations.TasksOperations>`
        """
        api_version = self._get_api_version('tasks')
        if api_version == '2018-09-01':
            from ..v2018_09_01.aio.operations import TasksOperations as OperationClass
        elif api_version == '2019-04-01':
            from ..v2019_04_01.aio.operations import TasksOperations as OperationClass
        elif api_version == '2019-06-01-preview':
            from ..v2019_06_01_preview.aio.operations import TasksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'tasks'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def tokens(self):
        """Instance depends on the API version:

           * 2019-05-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2019_05_01_preview.aio.operations.TokensOperations>`
           * 2020-11-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.TokensOperations>`
           * 2021-06-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.TokensOperations>`
           * 2021-08-01-preview: :class:`TokensOperations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.TokensOperations>`
        """
        api_version = self._get_api_version('tokens')
        if api_version == '2019-05-01-preview':
            from ..v2019_05_01_preview.aio.operations import TokensOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import TokensOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import TokensOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import TokensOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'tokens'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    @property
    def webhooks(self):
        """Instance depends on the API version:

           * 2017-10-01: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2017_10_01.aio.operations.WebhooksOperations>`
           * 2019-05-01: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2019_05_01.aio.operations.WebhooksOperations>`
           * 2019-12-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2019_12_01_preview.aio.operations.WebhooksOperations>`
           * 2020-11-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2020_11_01_preview.aio.operations.WebhooksOperations>`
           * 2021-06-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2021_06_01_preview.aio.operations.WebhooksOperations>`
           * 2021-08-01-preview: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2021_08_01_preview.aio.operations.WebhooksOperations>`
           * 2021-09-01: :class:`WebhooksOperations<azure.mgmt.containerregistry.v2021_09_01.aio.operations.WebhooksOperations>`
        """
        api_version = self._get_api_version('webhooks')
        if api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations import WebhooksOperations as OperationClass
        elif api_version == '2019-05-01':
            from ..v2019_05_01.aio.operations import WebhooksOperations as OperationClass
        elif api_version == '2019-12-01-preview':
            from ..v2019_12_01_preview.aio.operations import WebhooksOperations as OperationClass
        elif api_version == '2020-11-01-preview':
            from ..v2020_11_01_preview.aio.operations import WebhooksOperations as OperationClass
        elif api_version == '2021-06-01-preview':
            from ..v2021_06_01_preview.aio.operations import WebhooksOperations as OperationClass
        elif api_version == '2021-08-01-preview':
            from ..v2021_08_01_preview.aio.operations import WebhooksOperations as OperationClass
        elif api_version == '2021-09-01':
            from ..v2021_09_01.aio.operations import WebhooksOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'webhooks'".format(api_version))
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)))

    async def close(self):
        await self._client.close()
    async def __aenter__(self):
        await self._client.__aenter__()
        return self
    async def __aexit__(self, *exc_details):
        await self._client.__aexit__(*exc_details)
