
/* #########################################################################
 * [2015-10-13 11:58:18.518000] THIS FILE IS AUTOGENERATED - DO NOT EDIT!
 * ######################################################################### */
#ifndef ___BASE_NODE_RPC__COMMAND_PROCESSOR___
#define ___BASE_NODE_RPC__COMMAND_PROCESSOR___

#include "CArrayDefs.h"
#include "Commands.h"



namespace base_node_rpc {

template <typename Obj>
class CommandProcessor {
  /* # `CommandProcessor` #
   *
   * Each call to this functor processes a single command.
   *
   * All arguments are passed by reference, such that they may be used to form
   * a response.  If the integer return value of the call is zero, the call is
   * assumed to have no response required.  Otherwise, the arguments contain
   * must contain response values. */
protected:
  Obj &obj_;
public:
  CommandProcessor(Obj &obj) : obj_(obj) {}

  UInt8Array process_command(UInt8Array request_arr, UInt8Array buffer) {
    /* ## Call operator ##
     *
     * Arguments:
     *
     *  - `request_arr`: Serialized command request structure array,
     *  - `buffer`: Buffer array (available for writing output). */

    UInt8Array result;

    // Interpret first byte of request as command code.
    switch (request_arr.data[0]) {

        case CMD_BASE_NODE_SOFTWARE_VERSION:
          {
            /* Cast buffer as request. */
    
    
            BaseNodeSoftwareVersionResponse response;

            response.result =
            obj_.base_node_software_version();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_PACKAGE_NAME:
          {
            /* Cast buffer as request. */
    
    
            PackageNameResponse response;

            response.result =
            obj_.package_name();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_DISPLAY_NAME:
          {
            /* Cast buffer as request. */
    
    
            DisplayNameResponse response;

            response.result =
            obj_.display_name();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_MANUFACTURER:
          {
            /* Cast buffer as request. */
    
    
            ManufacturerResponse response;

            response.result =
            obj_.manufacturer();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_SOFTWARE_VERSION:
          {
            /* Cast buffer as request. */
    
    
            SoftwareVersionResponse response;

            response.result =
            obj_.software_version();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_URL:
          {
            /* Cast buffer as request. */
    
    
            UrlResponse response;

            response.result =
            obj_.url();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_MICROSECONDS:
          {
            /* Cast buffer as request. */
    
    
            MicrosecondsResponse response;

            response.result =
            obj_.microseconds();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MicrosecondsResponse &output = *(reinterpret_cast
                                                 <MicrosecondsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_MILLISECONDS:
          {
            /* Cast buffer as request. */
    
    
            MillisecondsResponse response;

            response.result =
            obj_.milliseconds();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MillisecondsResponse &output = *(reinterpret_cast
                                                 <MillisecondsResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DELAY_US:
          {
            /* Cast buffer as request. */
    
            DelayUsRequest &request = *(reinterpret_cast
                                          <DelayUsRequest *>
                                          (&request_arr.data[1]));
    
    
            obj_.delay_us(request.us);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DELAY_MS:
          {
            /* Cast buffer as request. */
    
            DelayMsRequest &request = *(reinterpret_cast
                                          <DelayMsRequest *>
                                          (&request_arr.data[1]));
    
    
            obj_.delay_ms(request.ms);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_RAM_FREE:
          {
            /* Cast buffer as request. */
    
    
            RamFreeResponse response;

            response.result =
            obj_.ram_free();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            RamFreeResponse &output = *(reinterpret_cast
                                                 <RamFreeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_PIN_MODE:
          {
            /* Cast buffer as request. */
    
            PinModeRequest &request = *(reinterpret_cast
                                          <PinModeRequest *>
                                          (&request_arr.data[1]));
    
    
            obj_.pin_mode(request.pin, request.mode);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_DIGITAL_READ:
          {
            /* Cast buffer as request. */
    
            DigitalReadRequest &request = *(reinterpret_cast
                                          <DigitalReadRequest *>
                                          (&request_arr.data[1]));
    
    
            DigitalReadResponse response;

            response.result =
            obj_.digital_read(request.pin);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            DigitalReadResponse &output = *(reinterpret_cast
                                                 <DigitalReadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_DIGITAL_WRITE:
          {
            /* Cast buffer as request. */
    
            DigitalWriteRequest &request = *(reinterpret_cast
                                          <DigitalWriteRequest *>
                                          (&request_arr.data[1]));
    
    
            obj_.digital_write(request.pin, request.value);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ANALOG_READ:
          {
            /* Cast buffer as request. */
    
            AnalogReadRequest &request = *(reinterpret_cast
                                          <AnalogReadRequest *>
                                          (&request_arr.data[1]));
    
    
            AnalogReadResponse response;

            response.result =
            obj_.analog_read(request.pin);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            AnalogReadResponse &output = *(reinterpret_cast
                                                 <AnalogReadResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ANALOG_WRITE:
          {
            /* Cast buffer as request. */
    
            AnalogWriteRequest &request = *(reinterpret_cast
                                          <AnalogWriteRequest *>
                                          (&request_arr.data[1]));
    
    
            obj_.analog_write(request.pin, request.value);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_ARRAY_LENGTH:
          {
            /* Cast buffer as request. */
    
            ArrayLengthRequest &request = *(reinterpret_cast
                                          <ArrayLengthRequest *>
                                          (&request_arr.data[1]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.array.data = (uint8_t *)((uint8_t *)&request + (uint16_t)request.array.data);
            ArrayLengthResponse response;

            response.result =
            obj_.array_length(request.array);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            ArrayLengthResponse &output = *(reinterpret_cast
                                                 <ArrayLengthResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_ECHO_ARRAY:
          {
            /* Cast buffer as request. */
    
            EchoArrayRequest &request = *(reinterpret_cast
                                          <EchoArrayRequest *>
                                          (&request_arr.data[1]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.array.data = (uint32_t *)((uint8_t *)&request + (uint16_t)request.array.data);
            EchoArrayResponse response;

            response.result =
            obj_.echo_array(request.array);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_STR_ECHO:
          {
            /* Cast buffer as request. */
    
            StrEchoRequest &request = *(reinterpret_cast
                                          <StrEchoRequest *>
                                          (&request_arr.data[1]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.msg.data = (uint8_t *)((uint8_t *)&request + (uint16_t)request.msg.data);
            StrEchoResponse response;

            response.result =
            obj_.str_echo(request.msg);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_MAX_SERIAL_PAYLOAD_SIZE:
          {
            /* Cast buffer as request. */
    
    
            MaxSerialPayloadSizeResponse response;

            response.result =
            obj_.max_serial_payload_size();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MaxSerialPayloadSizeResponse &output = *(reinterpret_cast
                                                 <MaxSerialPayloadSizeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_UPDATE_EEPROM_BLOCK:
          {
            /* Cast buffer as request. */
    
            UpdateEepromBlockRequest &request = *(reinterpret_cast
                                          <UpdateEepromBlockRequest *>
                                          (&request_arr.data[1]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (uint16_t)request.data.data);
            obj_.update_eeprom_block(request.address, request.data);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_READ_EEPROM_BLOCK:
          {
            /* Cast buffer as request. */
    
            ReadEepromBlockRequest &request = *(reinterpret_cast
                                          <ReadEepromBlockRequest *>
                                          (&request_arr.data[1]));
    
    
            ReadEepromBlockResponse response;

            response.result =
            obj_.read_eeprom_block(request.address, request.n);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_EEPROM_E2END:
          {
            /* Cast buffer as request. */
    
    
            EepromE2endResponse response;

            response.result =
            obj_.eeprom_e2end();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            EepromE2endResponse &output = *(reinterpret_cast
                                                 <EepromE2endResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_SET_I2C_ADDRESS:
          {
            /* Cast buffer as request. */
    
            SetI2cAddressRequest &request = *(reinterpret_cast
                                          <SetI2cAddressRequest *>
                                          (&request_arr.data[1]));
    
    
            obj_.set_i2c_address(request.address);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_I2C_ADDRESS:
          {
            /* Cast buffer as request. */
    
    
            I2cAddressResponse response;

            response.result =
            obj_.i2c_address();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cAddressResponse &output = *(reinterpret_cast
                                                 <I2cAddressResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_BUFFER_SIZE:
          {
            /* Cast buffer as request. */
    
    
            I2cBufferSizeResponse response;

            response.result =
            obj_.i2c_buffer_size();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cBufferSizeResponse &output = *(reinterpret_cast
                                                 <I2cBufferSizeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_SCAN:
          {
            /* Cast buffer as request. */
    
    
            I2cScanResponse response;

            response.result =
            obj_.i2c_scan();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_I2C_AVAILABLE:
          {
            /* Cast buffer as request. */
    
    
            I2cAvailableResponse response;

            response.result =
            obj_.i2c_available();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cAvailableResponse &output = *(reinterpret_cast
                                                 <I2cAvailableResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_READ_BYTE:
          {
            /* Cast buffer as request. */
    
    
            I2cReadByteResponse response;

            response.result =
            obj_.i2c_read_byte();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cReadByteResponse &output = *(reinterpret_cast
                                                 <I2cReadByteResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_REQUEST_FROM:
          {
            /* Cast buffer as request. */
    
            I2cRequestFromRequest &request = *(reinterpret_cast
                                          <I2cRequestFromRequest *>
                                          (&request_arr.data[1]));
    
    
            I2cRequestFromResponse response;

            response.result =
            obj_.i2c_request_from(request.address, request.n_bytes_to_read);
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            I2cRequestFromResponse &output = *(reinterpret_cast
                                                 <I2cRequestFromResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_READ:
          {
            /* Cast buffer as request. */
    
            I2cReadRequest &request = *(reinterpret_cast
                                          <I2cReadRequest *>
                                          (&request_arr.data[1]));
    
    
            I2cReadResponse response;

            response.result =
            obj_.i2c_read(request.address, request.n_bytes_to_read);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_I2C_WRITE:
          {
            /* Cast buffer as request. */
    
            I2cWriteRequest &request = *(reinterpret_cast
                                          <I2cWriteRequest *>
                                          (&request_arr.data[1]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (uint16_t)request.data.data);
            obj_.i2c_write(request.address, request.data);
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_I2C_ENABLE_BROADCAST:
          {
            /* Cast buffer as request. */
    
    
            obj_.i2c_enable_broadcast();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_I2C_DISABLE_BROADCAST:
          {
            /* Cast buffer as request. */
    
    
            obj_.i2c_disable_broadcast();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_MAX_I2C_PAYLOAD_SIZE:
          {
            /* Cast buffer as request. */
    
    
            MaxI2cPayloadSizeResponse response;

            response.result =
            obj_.max_i2c_payload_size();
    
            /* Copy result to output buffer. */
            /* Cast start of buffer as reference of result type and assign result. */
            MaxI2cPayloadSizeResponse &output = *(reinterpret_cast
                                                 <MaxI2cPayloadSizeResponse *>
                                                 (&buffer.data[0]));
            output = response;
            result.data = buffer.data;
            result.length = sizeof(output);
          }
          break;

        case CMD_I2C_REQUEST:
          {
            /* Cast buffer as request. */
    
            I2cRequestRequest &request = *(reinterpret_cast
                                          <I2cRequestRequest *>
                                          (&request_arr.data[1]));
    
    
            /* Add relative array data offsets to start payload structure. */
    
            request.data.data = (uint8_t *)((uint8_t *)&request + (uint16_t)request.data.data);
            I2cRequestResponse response;

            response.result =
            obj_.i2c_request(request.address, request.data);
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_I2C_PACKET_RESET:
          {
            /* Cast buffer as request. */
    
    
            obj_.i2c_packet_reset();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

        case CMD_GET_BUFFER:
          {
            /* Cast buffer as request. */
    
    
            GetBufferResponse response;

            response.result =
            obj_.get_buffer();
    
            /* Copy result to output buffer. */
            /* Result type is an array, so need to do `memcpy` for array data. */
            uint16_t length = (response.result.length *
                               sizeof(response.result.data[0]));

            result.data = (uint8_t *)response.result.data;
            result.length = length;
          }
          break;

        case CMD_BEGIN:
          {
            /* Cast buffer as request. */
    
    
            obj_.begin();
    
        result.data = buffer.data;
        result.length = 0;
          }
          break;

      default:
        result.length = 0xFFFF;
        result.data = NULL;
    }
    return result;
  }
};

}  // namespace base_node_rpc



#endif  // ifndef ___BASE_NODE_RPC___
