# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._service_bus_management_client_enums import *


class AuthorizationRule(msrest.serialization.Model):
    """Authorization rule of an entity.

    :param type:
    :type type: str
    :param claim_type:
    :type claim_type: str
    :param claim_value:
    :type claim_value: str
    :param rights: Access rights of the entity. Values are 'Send', 'Listen', or 'Manage'.
    :type rights: list[str]
    :param created_time: The date and time when the authorization rule was created.
    :type created_time: ~datetime.datetime
    :param modified_time: The date and time when the authorization rule was modified.
    :type modified_time: ~datetime.datetime
    :param key_name: The authorization rule key name.
    :type key_name: str
    :param primary_key: The primary key of the authorization rule.
    :type primary_key: str
    :param secondary_key: The primary key of the authorization rule.
    :type secondary_key: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'i', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'claim_type': {'key': 'ClaimType', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'claim_value': {'key': 'ClaimValue', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'rights': {'key': 'Rights', 'type': '[str]', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'AccessRights', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'created_time': {'key': 'CreatedTime', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'modified_time': {'key': 'ModifiedTime', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'key_name': {'key': 'KeyName', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'primary_key': {'key': 'PrimaryKey', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'secondary_key': {'key': 'SecondaryKey', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'AuthorizationRule', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        claim_type: Optional[str] = None,
        claim_value: Optional[str] = None,
        rights: Optional[List[str]] = None,
        created_time: Optional[datetime.datetime] = None,
        modified_time: Optional[datetime.datetime] = None,
        key_name: Optional[str] = None,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        **kwargs
    ):
        super(AuthorizationRule, self).__init__(**kwargs)
        self.type = type
        self.claim_type = claim_type
        self.claim_value = claim_value
        self.rights = rights
        self.created_time = created_time
        self.modified_time = modified_time
        self.key_name = key_name
        self.primary_key = primary_key
        self.secondary_key = secondary_key


class RuleFilter(msrest.serialization.Model):
    """RuleFilter.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CorrelationFilter, FalseFilter, SqlFilter, TrueFilter.

    :param type: Constant filled by server.
    :type type: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
    }

    _subtype_map = {
        'type': {'CorrelationFilter': 'CorrelationFilter', 'FalseFilter': 'FalseFilter', 'SqlFilter': 'SqlFilter', 'TrueFilter': 'TrueFilter'}
    }
    _xml_map = {
        'name': 'Filter', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleFilter, self).__init__(**kwargs)
        self.type: Optional[str] = None


class CorrelationFilter(RuleFilter):
    """CorrelationFilter.

    :param type: Constant filled by server.
    :type type: str
    :param correlation_id:
    :type correlation_id: str
    :param message_id:
    :type message_id: str
    :param to:
    :type to: str
    :param reply_to:
    :type reply_to: str
    :param label:
    :type label: str
    :param session_id:
    :type session_id: str
    :param reply_to_session_id:
    :type reply_to_session_id: str
    :param content_type:
    :type content_type: str
    :param properties:
    :type properties: list[~azure.servicebus.management._generated.models.KeyValue]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'correlation_id': {'key': 'CorrelationId', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_id': {'key': 'MessageId', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'to': {'key': 'To', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'reply_to': {'key': 'ReplyTo', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'label': {'key': 'Label', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'session_id': {'key': 'SessionId', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'reply_to_session_id': {'key': 'ReplyToSessionId', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'content_type': {'key': 'ContentType', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'properties': {'key': 'Properties', 'type': '[KeyValue]', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'KeyValueOfstringanyType', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }

    def __init__(
        self,
        *,
        correlation_id: Optional[str] = None,
        message_id: Optional[str] = None,
        to: Optional[str] = None,
        reply_to: Optional[str] = None,
        label: Optional[str] = None,
        session_id: Optional[str] = None,
        reply_to_session_id: Optional[str] = None,
        content_type: Optional[str] = None,
        properties: Optional[List["KeyValue"]] = None,
        **kwargs
    ):
        super(CorrelationFilter, self).__init__(**kwargs)
        self.type: str = 'CorrelationFilter'
        self.correlation_id = correlation_id
        self.message_id = message_id
        self.to = to
        self.reply_to = reply_to
        self.label = label
        self.session_id = session_id
        self.reply_to_session_id = reply_to_session_id
        self.content_type = content_type
        self.properties = properties


class CreateQueueBody(msrest.serialization.Model):
    """The request body for creating a queue.

    :param content: QueueDescription for the new queue.
    :type content: ~azure.servicebus.management._generated.models.CreateQueueBodyContent
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'CreateQueueBodyContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        content: Optional["CreateQueueBodyContent"] = None,
        **kwargs
    ):
        super(CreateQueueBody, self).__init__(**kwargs)
        self.content = content


class CreateQueueBodyContent(msrest.serialization.Model):
    """QueueDescription for the new queue.

    :param type: MIME type of content.
    :type type: str
    :param queue_description: Properties of the new queue.
    :type queue_description: ~azure.servicebus.management._generated.models.QueueDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'queue_description': {'key': 'QueueDescription', 'type': 'QueueDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        type: Optional[str] = "application/xml",
        queue_description: Optional["QueueDescription"] = None,
        **kwargs
    ):
        super(CreateQueueBodyContent, self).__init__(**kwargs)
        self.type = type
        self.queue_description = queue_description


class CreateRuleBody(msrest.serialization.Model):
    """The request body for creating a topic.

    :param content: RuleDescription for the new Rule.
    :type content: ~azure.servicebus.management._generated.models.CreateRuleBodyContent
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'CreateRuleBodyContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        content: Optional["CreateRuleBodyContent"] = None,
        **kwargs
    ):
        super(CreateRuleBody, self).__init__(**kwargs)
        self.content = content


class CreateRuleBodyContent(msrest.serialization.Model):
    """RuleDescription for the new Rule.

    :param type: MIME type of content.
    :type type: str
    :param rule_description: Rule information to create.
    :type rule_description: ~azure.servicebus.management._generated.models.RuleDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'rule_description': {'key': 'RuleDescription', 'type': 'RuleDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        type: Optional[str] = "application/xml",
        rule_description: Optional["RuleDescription"] = None,
        **kwargs
    ):
        super(CreateRuleBodyContent, self).__init__(**kwargs)
        self.type = type
        self.rule_description = rule_description


class CreateSubscriptionBody(msrest.serialization.Model):
    """The request body for creating a topic.

    :param content: TopicDescription for the new topic.
    :type content: ~azure.servicebus.management._generated.models.CreateSubscriptionBodyContent
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'CreateSubscriptionBodyContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        content: Optional["CreateSubscriptionBodyContent"] = None,
        **kwargs
    ):
        super(CreateSubscriptionBody, self).__init__(**kwargs)
        self.content = content


class CreateSubscriptionBodyContent(msrest.serialization.Model):
    """TopicDescription for the new topic.

    :param type: MIME type of content.
    :type type: str
    :param subscription_description: Topic information to create.
    :type subscription_description:
     ~azure.servicebus.management._generated.models.SubscriptionDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'subscription_description': {'key': 'SubscriptionDescription', 'type': 'SubscriptionDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        type: Optional[str] = "application/xml",
        subscription_description: Optional["SubscriptionDescription"] = None,
        **kwargs
    ):
        super(CreateSubscriptionBodyContent, self).__init__(**kwargs)
        self.type = type
        self.subscription_description = subscription_description


class CreateTopicBody(msrest.serialization.Model):
    """The request body for creating a topic.

    :param content: TopicDescription for the new topic.
    :type content: ~azure.servicebus.management._generated.models.CreateTopicBodyContent
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'CreateTopicBodyContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        content: Optional["CreateTopicBodyContent"] = None,
        **kwargs
    ):
        super(CreateTopicBody, self).__init__(**kwargs)
        self.content = content


class CreateTopicBodyContent(msrest.serialization.Model):
    """TopicDescription for the new topic.

    :param type: MIME type of content.
    :type type: str
    :param topic_description: Topic information to create.
    :type topic_description: ~azure.servicebus.management._generated.models.TopicDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'topic_description': {'key': 'TopicDescription', 'type': 'TopicDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        type: Optional[str] = "application/xml",
        topic_description: Optional["TopicDescription"] = None,
        **kwargs
    ):
        super(CreateTopicBodyContent, self).__init__(**kwargs)
        self.type = type
        self.topic_description = topic_description


class RuleAction(msrest.serialization.Model):
    """RuleAction.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EmptyRuleAction, SqlRuleAction.

    :param type: Constant filled by server.
    :type type: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
    }

    _subtype_map = {
        'type': {'EmptyRuleAction': 'EmptyRuleAction', 'SqlRuleAction': 'SqlRuleAction'}
    }
    _xml_map = {
        'name': 'Action', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleAction, self).__init__(**kwargs)
        self.type: Optional[str] = None


class EmptyRuleAction(RuleAction):
    """EmptyRuleAction.

    :param type: Constant filled by server.
    :type type: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmptyRuleAction, self).__init__(**kwargs)
        self.type: str = 'EmptyRuleAction'


class FalseFilter(RuleFilter):
    """FalseFilter.

    :param type: Constant filled by server.
    :type type: str
    :param sql_expression:
    :type sql_expression: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'sql_expression': {'key': 'SqlExpression', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }

    def __init__(
        self,
        *,
        sql_expression: Optional[str] = "1 != 1",
        **kwargs
    ):
        super(FalseFilter, self).__init__(**kwargs)
        self.type: str = 'FalseFilter'
        self.sql_expression = sql_expression


class KeyValue(msrest.serialization.Model):
    """KeyValue.

    :param key:
    :type key: str
    :param value:
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'Key', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'value': {'key': 'Value', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'KeyValueOfstringanyType', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        super(KeyValue, self).__init__(**kwargs)
        self.key = key
        self.value = value


class MessageCountDetails(msrest.serialization.Model):
    """Details about the message counts in entity.

    :param active_message_count: Number of active messages in the queue, topic, or subscription.
    :type active_message_count: int
    :param dead_letter_message_count: Number of messages that are dead lettered.
    :type dead_letter_message_count: int
    :param scheduled_message_count: Number of scheduled messages.
    :type scheduled_message_count: int
    :param transfer_dead_letter_message_count: Number of messages transferred into dead letters.
    :type transfer_dead_letter_message_count: int
    :param transfer_message_count: Number of messages transferred to another queue, topic, or
     subscription.
    :type transfer_message_count: int
    """

    _attribute_map = {
        'active_message_count': {'key': 'ActiveMessageCount', 'type': 'int', 'xml': {'prefix': 'd2p1', 'ns': 'http://schemas.microsoft.com/netservices/2011/06/servicebus'}},
        'dead_letter_message_count': {'key': 'DeadLetterMessageCount', 'type': 'int', 'xml': {'prefix': 'd2p1', 'ns': 'http://schemas.microsoft.com/netservices/2011/06/servicebus'}},
        'scheduled_message_count': {'key': 'ScheduledMessageCount', 'type': 'int', 'xml': {'prefix': 'd2p1', 'ns': 'http://schemas.microsoft.com/netservices/2011/06/servicebus'}},
        'transfer_dead_letter_message_count': {'key': 'TransferDeadLetterMessageCount', 'type': 'int', 'xml': {'prefix': 'd2p1', 'ns': 'http://schemas.microsoft.com/netservices/2011/06/servicebus'}},
        'transfer_message_count': {'key': 'TransferMessageCount', 'type': 'int', 'xml': {'prefix': 'd2p1', 'ns': 'http://schemas.microsoft.com/netservices/2011/06/servicebus'}},
    }
    _xml_map = {
        'name': 'CountDetails', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        *,
        active_message_count: Optional[int] = None,
        dead_letter_message_count: Optional[int] = None,
        scheduled_message_count: Optional[int] = None,
        transfer_dead_letter_message_count: Optional[int] = None,
        transfer_message_count: Optional[int] = None,
        **kwargs
    ):
        super(MessageCountDetails, self).__init__(**kwargs)
        self.active_message_count = active_message_count
        self.dead_letter_message_count = dead_letter_message_count
        self.scheduled_message_count = scheduled_message_count
        self.transfer_dead_letter_message_count = transfer_dead_letter_message_count
        self.transfer_message_count = transfer_message_count


class NamespaceProperties(msrest.serialization.Model):
    """The metadata related to a Service Bus namespace.

    :param alias: Alias for the geo-disaster recovery Service Bus namespace.
    :type alias: str
    :param created_time: The exact time the namespace was created.
    :type created_time: ~datetime.datetime
    :param messaging_sku: The SKU for the messaging entity. Possible values include: "Basic",
     "Standard", "Premium".
    :type messaging_sku: str or ~azure.servicebus.management._generated.models.MessagingSku
    :param messaging_units: The number of messaging units allocated to the namespace.
    :type messaging_units: int
    :param modified_time: The exact time the namespace was last modified.
    :type modified_time: ~datetime.datetime
    :param name: Name of the namespace.
    :type name: str
    :param namespace_type: The type of entities the namespace can contain. Possible values include:
     "Messaging", "NotificationHub", "Mixed", "EventHub", "Relay".
    :type namespace_type: str or ~azure.servicebus.management._generated.models.NamespaceType
    """

    _attribute_map = {
        'alias': {'key': 'Alias', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'created_time': {'key': 'CreatedTime', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'messaging_sku': {'key': 'MessagingSku', 'type': 'str', 'xml': {'name': 'MessagingSKU', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'messaging_units': {'key': 'MessagingUnits', 'type': 'int', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'modified_time': {'key': 'ModifiedTime', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'name': {'key': 'Name', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'namespace_type': {'key': 'NamespaceType', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'NamespaceInfo', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        *,
        alias: Optional[str] = None,
        created_time: Optional[datetime.datetime] = None,
        messaging_sku: Optional[Union[str, "MessagingSku"]] = None,
        messaging_units: Optional[int] = None,
        modified_time: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        namespace_type: Optional[Union[str, "NamespaceType"]] = None,
        **kwargs
    ):
        super(NamespaceProperties, self).__init__(**kwargs)
        self.alias = alias
        self.created_time = created_time
        self.messaging_sku = messaging_sku
        self.messaging_units = messaging_units
        self.modified_time = modified_time
        self.name = name
        self.namespace_type = namespace_type


class NamespacePropertiesEntry(msrest.serialization.Model):
    """Represents an entry in the feed when querying namespace info.

    :param id: The URL of the GET request.
    :type id: str
    :param title: The name of the namespace.
    :type title: object
    :param updated: The timestamp for when this namespace was last updated.
    :type updated: ~datetime.datetime
    :param author: The author that created this resource.
    :type author: ~azure.servicebus.management._generated.models.ResponseAuthor
    :param link: The URL for the HTTP request.
    :type link: ~azure.servicebus.management._generated.models.ResponseLink
    :param content: Information about the namespace.
    :type content: ~azure.servicebus.management._generated.models.NamespacePropertiesEntryContent
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'author': {'key': 'author', 'type': 'ResponseAuthor'},
        'link': {'key': 'link', 'type': 'ResponseLink'},
        'content': {'key': 'content', 'type': 'NamespacePropertiesEntryContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        title: Optional[object] = None,
        updated: Optional[datetime.datetime] = None,
        author: Optional["ResponseAuthor"] = None,
        link: Optional["ResponseLink"] = None,
        content: Optional["NamespacePropertiesEntryContent"] = None,
        **kwargs
    ):
        super(NamespacePropertiesEntry, self).__init__(**kwargs)
        self.id = id
        self.title = title
        self.updated = updated
        self.author = author
        self.link = link
        self.content = content


class NamespacePropertiesEntryContent(msrest.serialization.Model):
    """Information about the namespace.

    :param type: Type of content in namespace info response.
    :type type: str
    :param namespace_properties: The metadata related to a Service Bus namespace.
    :type namespace_properties: ~azure.servicebus.management._generated.models.NamespaceProperties
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'namespace_properties': {'key': 'NamespaceProperties', 'type': 'NamespaceProperties'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        namespace_properties: Optional["NamespaceProperties"] = None,
        **kwargs
    ):
        super(NamespacePropertiesEntryContent, self).__init__(**kwargs)
        self.type = type
        self.namespace_properties = namespace_properties


class QueueDescription(msrest.serialization.Model):
    """Description of a Service Bus queue resource.

    :param lock_duration: ISO 8601 timespan duration of a peek-lock; that is, the amount of time
     that the message is locked for other receivers. The maximum value for LockDuration is 5
     minutes; the default value is 1 minute.
    :type lock_duration: ~datetime.timedelta
    :param max_size_in_megabytes: The maximum size of the queue in megabytes, which is the size of
     memory allocated for the queue.
    :type max_size_in_megabytes: int
    :param requires_duplicate_detection: A value indicating if this queue requires duplicate
     detection.
    :type requires_duplicate_detection: bool
    :param requires_session: A value that indicates whether the queue supports the concept of
     sessions.
    :type requires_session: bool
    :param default_message_time_to_live: ISO 8601 default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: ~datetime.timedelta
    :param dead_lettering_on_message_expiration: A value that indicates whether this queue has dead
     letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param duplicate_detection_history_time_window: ISO 8601 timeSpan structure that defines the
     duration of the duplicate detection history. The default value is 10 minutes.
    :type duplicate_detection_history_time_window: ~datetime.timedelta
    :param max_delivery_count: The maximum delivery count. A message is automatically deadlettered
     after this number of deliveries. Default value is 10.
    :type max_delivery_count: int
    :param enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :type enable_batched_operations: bool
    :param size_in_bytes: The size of the queue, in bytes.
    :type size_in_bytes: int
    :param message_count: The number of messages in the queue.
    :type message_count: int
    :param is_anonymous_accessible: A value indicating if the resource can be accessed without
     authorization.
    :type is_anonymous_accessible: bool
    :param authorization_rules: Authorization rules for resource.
    :type authorization_rules:
     list[~azure.servicebus.management._generated.models.AuthorizationRule]
    :param status: Status of a Service Bus resource. Possible values include: "Active", "Creating",
     "Deleting", "Disabled", "ReceiveDisabled", "Renaming", "Restoring", "SendDisabled", "Unknown".
    :type status: str or ~azure.servicebus.management._generated.models.EntityStatus
    :param forward_to: The name of the recipient entity to which all the messages sent to the queue
     are forwarded to.
    :type forward_to: str
    :param user_metadata: Custom metdata that user can associate with the description. Max length
     is 1024 chars.
    :type user_metadata: str
    :param created_at: The exact time the queue was created.
    :type created_at: ~datetime.datetime
    :param updated_at: The exact time a message was updated in the queue.
    :type updated_at: ~datetime.datetime
    :param accessed_at: Last time a message was sent, or the last time there was a receive request
     to this queue.
    :type accessed_at: ~datetime.datetime
    :param support_ordering: A value that indicates whether the queue supports ordering.
    :type support_ordering: bool
    :param message_count_details: Details about the message counts in entity.
    :type message_count_details: ~azure.servicebus.management._generated.models.MessageCountDetails
    :param auto_delete_on_idle: ISO 8601 timeSpan idle interval after which the queue is
     automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: ~datetime.timedelta
    :param enable_partitioning: A value that indicates whether the queue is to be partitioned
     across multiple message brokers.
    :type enable_partitioning: bool
    :param entity_availability_status: Availability status of the entity. Possible values include:
     "Available", "Limited", "Renaming", "Restoring", "Unknown".
    :type entity_availability_status: str or
     ~azure.servicebus.management._generated.models.EntityAvailabilityStatus
    :param enable_express: A value that indicates whether Express Entities are enabled. An express
     queue holds a message in memory temporarily before writing it to persistent storage.
    :type enable_express: bool
    :param forward_dead_lettered_messages_to: The name of the recipient entity to which all the
     dead-lettered messages of this subscription are forwarded to.
    :type forward_dead_lettered_messages_to: str
    """

    _attribute_map = {
        'lock_duration': {'key': 'LockDuration', 'type': 'duration', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'max_size_in_megabytes': {'key': 'MaxSizeInMegabytes', 'type': 'int', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_duplicate_detection': {'key': 'RequiresDuplicateDetection', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_session': {'key': 'RequiresSession', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'default_message_time_to_live': {'key': 'DefaultMessageTimeToLive', 'type': 'duration', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'dead_lettering_on_message_expiration': {'key': 'DeadLetteringOnMessageExpiration', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'duplicate_detection_history_time_window': {'key': 'DuplicateDetectionHistoryTimeWindow', 'type': 'duration', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'max_delivery_count': {'key': 'MaxDeliveryCount', 'type': 'int', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_batched_operations': {'key': 'EnableBatchedOperations', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'size_in_bytes': {'key': 'SizeInBytes', 'type': 'int', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_count': {'key': 'MessageCount', 'type': 'int', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'is_anonymous_accessible': {'key': 'IsAnonymousAccessible', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'authorization_rules': {'key': 'AuthorizationRules', 'type': '[AuthorizationRule]', 'xml': {'name': 'AuthorizationRules', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'AuthorizationRule', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'status': {'key': 'Status', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'forward_to': {'key': 'ForwardTo', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'user_metadata': {'key': 'UserMetadata', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'created_at': {'key': 'CreatedAt', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'updated_at': {'key': 'UpdatedAt', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'accessed_at': {'key': 'AccessedAt', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'support_ordering': {'key': 'SupportOrdering', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_count_details': {'key': 'MessageCountDetails', 'type': 'MessageCountDetails'},
        'auto_delete_on_idle': {'key': 'AutoDeleteOnIdle', 'type': 'duration', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_partitioning': {'key': 'EnablePartitioning', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'entity_availability_status': {'key': 'EntityAvailabilityStatus', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_express': {'key': 'EnableExpress', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'forward_dead_lettered_messages_to': {'key': 'ForwardDeadLetteredMessagesTo', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'QueueDescription', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        *,
        lock_duration: Optional[datetime.timedelta] = None,
        max_size_in_megabytes: Optional[int] = None,
        requires_duplicate_detection: Optional[bool] = None,
        requires_session: Optional[bool] = None,
        default_message_time_to_live: Optional[datetime.timedelta] = None,
        dead_lettering_on_message_expiration: Optional[bool] = None,
        duplicate_detection_history_time_window: Optional[datetime.timedelta] = None,
        max_delivery_count: Optional[int] = None,
        enable_batched_operations: Optional[bool] = None,
        size_in_bytes: Optional[int] = None,
        message_count: Optional[int] = None,
        is_anonymous_accessible: Optional[bool] = None,
        authorization_rules: Optional[List["AuthorizationRule"]] = None,
        status: Optional[Union[str, "EntityStatus"]] = None,
        forward_to: Optional[str] = None,
        user_metadata: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        updated_at: Optional[datetime.datetime] = None,
        accessed_at: Optional[datetime.datetime] = None,
        support_ordering: Optional[bool] = None,
        message_count_details: Optional["MessageCountDetails"] = None,
        auto_delete_on_idle: Optional[datetime.timedelta] = None,
        enable_partitioning: Optional[bool] = None,
        entity_availability_status: Optional[Union[str, "EntityAvailabilityStatus"]] = None,
        enable_express: Optional[bool] = None,
        forward_dead_lettered_messages_to: Optional[str] = None,
        **kwargs
    ):
        super(QueueDescription, self).__init__(**kwargs)
        self.lock_duration = lock_duration
        self.max_size_in_megabytes = max_size_in_megabytes
        self.requires_duplicate_detection = requires_duplicate_detection
        self.requires_session = requires_session
        self.default_message_time_to_live = default_message_time_to_live
        self.dead_lettering_on_message_expiration = dead_lettering_on_message_expiration
        self.duplicate_detection_history_time_window = duplicate_detection_history_time_window
        self.max_delivery_count = max_delivery_count
        self.enable_batched_operations = enable_batched_operations
        self.size_in_bytes = size_in_bytes
        self.message_count = message_count
        self.is_anonymous_accessible = is_anonymous_accessible
        self.authorization_rules = authorization_rules
        self.status = status
        self.forward_to = forward_to
        self.user_metadata = user_metadata
        self.created_at = created_at
        self.updated_at = updated_at
        self.accessed_at = accessed_at
        self.support_ordering = support_ordering
        self.message_count_details = message_count_details
        self.auto_delete_on_idle = auto_delete_on_idle
        self.enable_partitioning = enable_partitioning
        self.entity_availability_status = entity_availability_status
        self.enable_express = enable_express
        self.forward_dead_lettered_messages_to = forward_dead_lettered_messages_to


class QueueDescriptionEntry(msrest.serialization.Model):
    """Represents an entry in the feed when querying queues.

    :param base: Base URL for the query.
    :type base: str
    :param id: The URL of the GET request.
    :type id: str
    :param title: The name of the queue.
    :type title: object
    :param published: The timestamp for when this queue was published.
    :type published: ~datetime.datetime
    :param updated: The timestamp for when this queue was last updated.
    :type updated: ~datetime.datetime
    :param author: The author that created this resource.
    :type author: ~azure.servicebus.management._generated.models.ResponseAuthor
    :param link: The URL for the HTTP request.
    :type link: ~azure.servicebus.management._generated.models.ResponseLink
    :param content: The QueueDescription.
    :type content: ~azure.servicebus.management._generated.models.QueueDescriptionEntryContent
    """

    _attribute_map = {
        'base': {'key': 'base', 'type': 'str', 'xml': {'name': 'base', 'attr': True, 'prefix': 'xml'}},
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'published': {'key': 'published', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'author': {'key': 'author', 'type': 'ResponseAuthor'},
        'link': {'key': 'link', 'type': 'ResponseLink'},
        'content': {'key': 'content', 'type': 'QueueDescriptionEntryContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        base: Optional[str] = None,
        id: Optional[str] = None,
        title: Optional[object] = None,
        published: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        author: Optional["ResponseAuthor"] = None,
        link: Optional["ResponseLink"] = None,
        content: Optional["QueueDescriptionEntryContent"] = None,
        **kwargs
    ):
        super(QueueDescriptionEntry, self).__init__(**kwargs)
        self.base = base
        self.id = id
        self.title = title
        self.published = published
        self.updated = updated
        self.author = author
        self.link = link
        self.content = content


class QueueDescriptionEntryContent(msrest.serialization.Model):
    """The QueueDescription.

    :param type: Type of content in queue response.
    :type type: str
    :param queue_description: Description of a Service Bus queue resource.
    :type queue_description: ~azure.servicebus.management._generated.models.QueueDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'queue_description': {'key': 'QueueDescription', 'type': 'QueueDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        queue_description: Optional["QueueDescription"] = None,
        **kwargs
    ):
        super(QueueDescriptionEntryContent, self).__init__(**kwargs)
        self.type = type
        self.queue_description = queue_description


class QueueDescriptionFeed(msrest.serialization.Model):
    """Response from listing Service Bus queues.

    :param id: URL of the list queues query.
    :type id: str
    :param title: The entity type for the feed.
    :type title: object
    :param updated: Datetime of the query.
    :type updated: ~datetime.datetime
    :param link: Links to paginated response.
    :type link: list[~azure.servicebus.management._generated.models.ResponseLink]
    :param entry: Queue entries.
    :type entry: list[~azure.servicebus.management._generated.models.QueueDescriptionEntry]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': '[ResponseLink]'},
        'entry': {'key': 'entry', 'type': '[QueueDescriptionEntry]'},
    }
    _xml_map = {
        'name': 'feed', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        title: Optional[object] = None,
        updated: Optional[datetime.datetime] = None,
        link: Optional[List["ResponseLink"]] = None,
        entry: Optional[List["QueueDescriptionEntry"]] = None,
        **kwargs
    ):
        super(QueueDescriptionFeed, self).__init__(**kwargs)
        self.id = id
        self.title = title
        self.updated = updated
        self.link = link
        self.entry = entry


class ResponseAuthor(msrest.serialization.Model):
    """The author that created this resource.

    :param name: The Service Bus namespace.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ResponseAuthor, self).__init__(**kwargs)
        self.name = name


class ResponseLink(msrest.serialization.Model):
    """The URL for the HTTP request.

    :param href: The URL of the GET request.
    :type href: str
    :param rel: What the link href is relative to.
    :type rel: str
    """

    _attribute_map = {
        'href': {'key': 'href', 'type': 'str', 'xml': {'attr': True}},
        'rel': {'key': 'rel', 'type': 'str', 'xml': {'attr': True}},
    }
    _xml_map = {
        'name': 'link', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        href: Optional[str] = None,
        rel: Optional[str] = None,
        **kwargs
    ):
        super(ResponseLink, self).__init__(**kwargs)
        self.href = href
        self.rel = rel


class RuleDescription(msrest.serialization.Model):
    """RuleDescription.

    :param filter:
    :type filter: ~azure.servicebus.management._generated.models.RuleFilter
    :param action:
    :type action: ~azure.servicebus.management._generated.models.RuleAction
    :param created_at: The exact time the rule was created.
    :type created_at: ~datetime.datetime
    :param name:
    :type name: str
    """

    _attribute_map = {
        'filter': {'key': 'Filter', 'type': 'RuleFilter'},
        'action': {'key': 'Action', 'type': 'RuleAction'},
        'created_at': {'key': 'CreatedAt', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'name': {'key': 'Name', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        *,
        filter: Optional["RuleFilter"] = None,
        action: Optional["RuleAction"] = None,
        created_at: Optional[datetime.datetime] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(RuleDescription, self).__init__(**kwargs)
        self.filter = filter
        self.action = action
        self.created_at = created_at
        self.name = name


class RuleDescriptionEntry(msrest.serialization.Model):
    """Represents an entry in the feed when querying rules.

    :param id: The URL of the GET request.
    :type id: str
    :param title: The name of the rule.
    :type title: object
    :param published: The timestamp for when this rule was published.
    :type published: ~datetime.datetime
    :param updated: The timestamp for when this rule was last updated.
    :type updated: ~datetime.datetime
    :param link: The URL for the HTTP request.
    :type link: ~azure.servicebus.management._generated.models.ResponseLink
    :param content: The RuleDescription.
    :type content: ~azure.servicebus.management._generated.models.RuleDescriptionEntryContent
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'published': {'key': 'published', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': 'ResponseLink'},
        'content': {'key': 'content', 'type': 'RuleDescriptionEntryContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        title: Optional[object] = None,
        published: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        link: Optional["ResponseLink"] = None,
        content: Optional["RuleDescriptionEntryContent"] = None,
        **kwargs
    ):
        super(RuleDescriptionEntry, self).__init__(**kwargs)
        self.id = id
        self.title = title
        self.published = published
        self.updated = updated
        self.link = link
        self.content = content


class RuleDescriptionEntryContent(msrest.serialization.Model):
    """The RuleDescription.

    :param type: Type of content in queue response.
    :type type: str
    :param rule_description:
    :type rule_description: ~azure.servicebus.management._generated.models.RuleDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'rule_description': {'key': 'RuleDescription', 'type': 'RuleDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        rule_description: Optional["RuleDescription"] = None,
        **kwargs
    ):
        super(RuleDescriptionEntryContent, self).__init__(**kwargs)
        self.type = type
        self.rule_description = rule_description


class RuleDescriptionFeed(msrest.serialization.Model):
    """Response from listing Service Bus rules.

    :param id: URL of the list rules query.
    :type id: str
    :param title: The entity type for the feed.
    :type title: object
    :param updated: Datetime of the query.
    :type updated: ~datetime.datetime
    :param link: Links to paginated response.
    :type link: list[~azure.servicebus.management._generated.models.ResponseLink]
    :param entry: Rules entries.
    :type entry: list[~azure.servicebus.management._generated.models.RuleDescriptionEntry]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': '[ResponseLink]'},
        'entry': {'key': 'entry', 'type': '[RuleDescriptionEntry]'},
    }
    _xml_map = {
        'name': 'feed', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        title: Optional[object] = None,
        updated: Optional[datetime.datetime] = None,
        link: Optional[List["ResponseLink"]] = None,
        entry: Optional[List["RuleDescriptionEntry"]] = None,
        **kwargs
    ):
        super(RuleDescriptionFeed, self).__init__(**kwargs)
        self.id = id
        self.title = title
        self.updated = updated
        self.link = link
        self.entry = entry


class ServiceBusManagementError(msrest.serialization.Model):
    """The error response from Service Bus.

    :param code: The service error code.
    :type code: int
    :param detail: The service error message.
    :type detail: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'int'},
        'detail': {'key': 'Detail', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[int] = None,
        detail: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBusManagementError, self).__init__(**kwargs)
        self.code = code
        self.detail = detail


class SqlFilter(RuleFilter):
    """SqlFilter.

    :param type: Constant filled by server.
    :type type: str
    :param sql_expression:
    :type sql_expression: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'sql_expression': {'key': 'SqlExpression', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }

    def __init__(
        self,
        *,
        sql_expression: Optional[str] = None,
        **kwargs
    ):
        super(SqlFilter, self).__init__(**kwargs)
        self.type: str = 'SqlFilter'
        self.sql_expression = sql_expression


class SqlRuleAction(RuleAction):
    """SqlRuleAction.

    :param type: Constant filled by server.
    :type type: str
    :param sql_expression:
    :type sql_expression: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'sql_expression': {'key': 'SqlExpression', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }

    def __init__(
        self,
        *,
        sql_expression: Optional[str] = None,
        **kwargs
    ):
        super(SqlRuleAction, self).__init__(**kwargs)
        self.type: str = 'SqlRuleAction'
        self.sql_expression = sql_expression


class SubscriptionDescription(msrest.serialization.Model):
    """Description of a Service Bus subscription resource.

    :param lock_duration: ISO 8601 timespan duration of a peek-lock; that is, the amount of time
     that the message is locked for other receivers. The maximum value for LockDuration is 5
     minutes; the default value is 1 minute.
    :type lock_duration: ~datetime.timedelta
    :param requires_session: A value that indicates whether the queue supports the concept of
     sessions.
    :type requires_session: bool
    :param default_message_time_to_live: ISO 8601 default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: ~datetime.timedelta
    :param dead_lettering_on_message_expiration: A value that indicates whether this subscription
     has dead letter support when a message expires.
    :type dead_lettering_on_message_expiration: bool
    :param dead_lettering_on_filter_evaluation_exceptions: A value that indicates whether this
     subscription has dead letter support when a message expires.
    :type dead_lettering_on_filter_evaluation_exceptions: bool
    :param message_count: The number of messages in the subscription.
    :type message_count: int
    :param max_delivery_count: The maximum delivery count. A message is automatically deadlettered
     after this number of deliveries. Default value is 10.
    :type max_delivery_count: int
    :param enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :type enable_batched_operations: bool
    :param status: Status of a Service Bus resource. Possible values include: "Active", "Creating",
     "Deleting", "Disabled", "ReceiveDisabled", "Renaming", "Restoring", "SendDisabled", "Unknown".
    :type status: str or ~azure.servicebus.management._generated.models.EntityStatus
    :param forward_to: The name of the recipient entity to which all the messages sent to the
     subscription are forwarded to.
    :type forward_to: str
    :param created_at: The exact time the subscription was created.
    :type created_at: ~datetime.datetime
    :param updated_at: The exact time a message was updated in the subscription.
    :type updated_at: ~datetime.datetime
    :param accessed_at: Last time a message was sent, or the last time there was a receive request
     to this subscription.
    :type accessed_at: ~datetime.datetime
    :param message_count_details: Details about the message counts in entity.
    :type message_count_details: ~azure.servicebus.management._generated.models.MessageCountDetails
    :param user_metadata: Metadata associated with the subscription. Maximum number of characters
     is 1024.
    :type user_metadata: str
    :param forward_dead_lettered_messages_to: The name of the recipient entity to which all the
     messages sent to the subscription are forwarded to.
    :type forward_dead_lettered_messages_to: str
    :param auto_delete_on_idle: ISO 8601 timeSpan idle interval after which the subscription is
     automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: ~datetime.timedelta
    :param entity_availability_status: Availability status of the entity. Possible values include:
     "Available", "Limited", "Renaming", "Restoring", "Unknown".
    :type entity_availability_status: str or
     ~azure.servicebus.management._generated.models.EntityAvailabilityStatus
    """

    _attribute_map = {
        'lock_duration': {'key': 'LockDuration', 'type': 'duration', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_session': {'key': 'RequiresSession', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'default_message_time_to_live': {'key': 'DefaultMessageTimeToLive', 'type': 'duration', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'dead_lettering_on_message_expiration': {'key': 'DeadLetteringOnMessageExpiration', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'dead_lettering_on_filter_evaluation_exceptions': {'key': 'DeadLetteringOnFilterEvaluationExceptions', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_count': {'key': 'MessageCount', 'type': 'int', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'max_delivery_count': {'key': 'MaxDeliveryCount', 'type': 'int', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_batched_operations': {'key': 'EnableBatchedOperations', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'status': {'key': 'Status', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'forward_to': {'key': 'ForwardTo', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'created_at': {'key': 'CreatedAt', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'updated_at': {'key': 'UpdatedAt', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'accessed_at': {'key': 'AccessedAt', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_count_details': {'key': 'MessageCountDetails', 'type': 'MessageCountDetails'},
        'user_metadata': {'key': 'UserMetadata', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'forward_dead_lettered_messages_to': {'key': 'ForwardDeadLetteredMessagesTo', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'auto_delete_on_idle': {'key': 'AutoDeleteOnIdle', 'type': 'duration', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'entity_availability_status': {'key': 'EntityAvailabilityStatus', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'SubscriptionDescription', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        *,
        lock_duration: Optional[datetime.timedelta] = None,
        requires_session: Optional[bool] = None,
        default_message_time_to_live: Optional[datetime.timedelta] = None,
        dead_lettering_on_message_expiration: Optional[bool] = None,
        dead_lettering_on_filter_evaluation_exceptions: Optional[bool] = None,
        message_count: Optional[int] = None,
        max_delivery_count: Optional[int] = None,
        enable_batched_operations: Optional[bool] = None,
        status: Optional[Union[str, "EntityStatus"]] = None,
        forward_to: Optional[str] = None,
        created_at: Optional[datetime.datetime] = None,
        updated_at: Optional[datetime.datetime] = None,
        accessed_at: Optional[datetime.datetime] = None,
        message_count_details: Optional["MessageCountDetails"] = None,
        user_metadata: Optional[str] = None,
        forward_dead_lettered_messages_to: Optional[str] = None,
        auto_delete_on_idle: Optional[datetime.timedelta] = None,
        entity_availability_status: Optional[Union[str, "EntityAvailabilityStatus"]] = None,
        **kwargs
    ):
        super(SubscriptionDescription, self).__init__(**kwargs)
        self.lock_duration = lock_duration
        self.requires_session = requires_session
        self.default_message_time_to_live = default_message_time_to_live
        self.dead_lettering_on_message_expiration = dead_lettering_on_message_expiration
        self.dead_lettering_on_filter_evaluation_exceptions = dead_lettering_on_filter_evaluation_exceptions
        self.message_count = message_count
        self.max_delivery_count = max_delivery_count
        self.enable_batched_operations = enable_batched_operations
        self.status = status
        self.forward_to = forward_to
        self.created_at = created_at
        self.updated_at = updated_at
        self.accessed_at = accessed_at
        self.message_count_details = message_count_details
        self.user_metadata = user_metadata
        self.forward_dead_lettered_messages_to = forward_dead_lettered_messages_to
        self.auto_delete_on_idle = auto_delete_on_idle
        self.entity_availability_status = entity_availability_status


class SubscriptionDescriptionEntry(msrest.serialization.Model):
    """Represents an entry in the feed when querying subscriptions.

    :param id: The URL of the GET request.
    :type id: str
    :param title: The name of the subscription.
    :type title: object
    :param published: The timestamp for when this subscription was published.
    :type published: ~datetime.datetime
    :param updated: The timestamp for when this subscription was last updated.
    :type updated: ~datetime.datetime
    :param link: The URL for the HTTP request.
    :type link: ~azure.servicebus.management._generated.models.ResponseLink
    :param content: The SubscriptionDescription.
    :type content:
     ~azure.servicebus.management._generated.models.SubscriptionDescriptionEntryContent
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'published': {'key': 'published', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': 'ResponseLink'},
        'content': {'key': 'content', 'type': 'SubscriptionDescriptionEntryContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        title: Optional[object] = None,
        published: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        link: Optional["ResponseLink"] = None,
        content: Optional["SubscriptionDescriptionEntryContent"] = None,
        **kwargs
    ):
        super(SubscriptionDescriptionEntry, self).__init__(**kwargs)
        self.id = id
        self.title = title
        self.published = published
        self.updated = updated
        self.link = link
        self.content = content


class SubscriptionDescriptionEntryContent(msrest.serialization.Model):
    """The SubscriptionDescription.

    :param type: Type of content in queue response.
    :type type: str
    :param subscription_description: Description of a Service Bus subscription resource.
    :type subscription_description:
     ~azure.servicebus.management._generated.models.SubscriptionDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'subscription_description': {'key': 'SubscriptionDescription', 'type': 'SubscriptionDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        subscription_description: Optional["SubscriptionDescription"] = None,
        **kwargs
    ):
        super(SubscriptionDescriptionEntryContent, self).__init__(**kwargs)
        self.type = type
        self.subscription_description = subscription_description


class SubscriptionDescriptionFeed(msrest.serialization.Model):
    """Response from listing Service Bus subscriptions.

    :param id: URL of the list subscriptions query.
    :type id: str
    :param title: The entity type for the feed.
    :type title: object
    :param updated: Datetime of the query.
    :type updated: ~datetime.datetime
    :param link: Links to paginated response.
    :type link: list[~azure.servicebus.management._generated.models.ResponseLink]
    :param entry: Subscription entries.
    :type entry: list[~azure.servicebus.management._generated.models.SubscriptionDescriptionEntry]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': '[ResponseLink]'},
        'entry': {'key': 'entry', 'type': '[SubscriptionDescriptionEntry]'},
    }
    _xml_map = {
        'name': 'feed', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        title: Optional[object] = None,
        updated: Optional[datetime.datetime] = None,
        link: Optional[List["ResponseLink"]] = None,
        entry: Optional[List["SubscriptionDescriptionEntry"]] = None,
        **kwargs
    ):
        super(SubscriptionDescriptionFeed, self).__init__(**kwargs)
        self.id = id
        self.title = title
        self.updated = updated
        self.link = link
        self.entry = entry


class TopicDescription(msrest.serialization.Model):
    """Description of a Service Bus topic resource.

    :param default_message_time_to_live: ISO 8601 default message timespan to live value. This is
     the duration after which the message expires, starting from when the message is sent to Service
     Bus. This is the default value used when TimeToLive is not set on a message itself.
    :type default_message_time_to_live: ~datetime.timedelta
    :param max_size_in_megabytes: The maximum size of the topic in megabytes, which is the size of
     memory allocated for the topic.
    :type max_size_in_megabytes: long
    :param requires_duplicate_detection: A value indicating if this topic requires duplicate
     detection.
    :type requires_duplicate_detection: bool
    :param duplicate_detection_history_time_window: ISO 8601 timeSpan structure that defines the
     duration of the duplicate detection history. The default value is 10 minutes.
    :type duplicate_detection_history_time_window: ~datetime.timedelta
    :param enable_batched_operations: Value that indicates whether server-side batched operations
     are enabled.
    :type enable_batched_operations: bool
    :param size_in_bytes: The size of the topic, in bytes.
    :type size_in_bytes: int
    :param filtering_messages_before_publishing: Filter messages before publishing.
    :type filtering_messages_before_publishing: bool
    :param is_anonymous_accessible: A value indicating if the resource can be accessed without
     authorization.
    :type is_anonymous_accessible: bool
    :param authorization_rules: Authorization rules for resource.
    :type authorization_rules:
     list[~azure.servicebus.management._generated.models.AuthorizationRule]
    :param status: Status of a Service Bus resource. Possible values include: "Active", "Creating",
     "Deleting", "Disabled", "ReceiveDisabled", "Renaming", "Restoring", "SendDisabled", "Unknown".
    :type status: str or ~azure.servicebus.management._generated.models.EntityStatus
    :param created_at: The exact time the topic was created.
    :type created_at: ~datetime.datetime
    :param updated_at: The exact time a message was updated in the topic.
    :type updated_at: ~datetime.datetime
    :param accessed_at: Last time a message was sent, or the last time there was a receive request
     to this topic.
    :type accessed_at: ~datetime.datetime
    :param support_ordering: A value that indicates whether the topic supports ordering.
    :type support_ordering: bool
    :param message_count_details: Details about the message counts in entity.
    :type message_count_details: ~azure.servicebus.management._generated.models.MessageCountDetails
    :param subscription_count: The number of subscriptions in the topic.
    :type subscription_count: int
    :param auto_delete_on_idle: ISO 8601 timeSpan idle interval after which the topic is
     automatically deleted. The minimum duration is 5 minutes.
    :type auto_delete_on_idle: ~datetime.timedelta
    :param enable_partitioning: A value that indicates whether the topic is to be partitioned
     across multiple message brokers.
    :type enable_partitioning: bool
    :param entity_availability_status: Availability status of the entity. Possible values include:
     "Available", "Limited", "Renaming", "Restoring", "Unknown".
    :type entity_availability_status: str or
     ~azure.servicebus.management._generated.models.EntityAvailabilityStatus
    :param enable_subscription_partitioning: A value that indicates whether the topic's
     subscription is to be partitioned.
    :type enable_subscription_partitioning: bool
    :param enable_express: A value that indicates whether Express Entities are enabled. An express
     queue holds a message in memory temporarily before writing it to persistent storage.
    :type enable_express: bool
    :param user_metadata: Metadata associated with the topic.
    :type user_metadata: str
    """

    _attribute_map = {
        'default_message_time_to_live': {'key': 'DefaultMessageTimeToLive', 'type': 'duration', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'max_size_in_megabytes': {'key': 'MaxSizeInMegabytes', 'type': 'long', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'requires_duplicate_detection': {'key': 'RequiresDuplicateDetection', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'duplicate_detection_history_time_window': {'key': 'DuplicateDetectionHistoryTimeWindow', 'type': 'duration', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_batched_operations': {'key': 'EnableBatchedOperations', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'size_in_bytes': {'key': 'SizeInBytes', 'type': 'int', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'filtering_messages_before_publishing': {'key': 'FilteringMessagesBeforePublishing', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'is_anonymous_accessible': {'key': 'IsAnonymousAccessible', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'authorization_rules': {'key': 'AuthorizationRules', 'type': '[AuthorizationRule]', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect', 'wrapped': True, 'itemsName': 'AuthorizationRule', 'itemsNs': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'status': {'key': 'Status', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'created_at': {'key': 'CreatedAt', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'updated_at': {'key': 'UpdatedAt', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'accessed_at': {'key': 'AccessedAt', 'type': 'iso-8601', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'support_ordering': {'key': 'SupportOrdering', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'message_count_details': {'key': 'MessageCountDetails', 'type': 'MessageCountDetails'},
        'subscription_count': {'key': 'SubscriptionCount', 'type': 'int', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'auto_delete_on_idle': {'key': 'AutoDeleteOnIdle', 'type': 'duration', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_partitioning': {'key': 'EnablePartitioning', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'entity_availability_status': {'key': 'EntityAvailabilityStatus', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_subscription_partitioning': {'key': 'EnableSubscriptionPartitioning', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'enable_express': {'key': 'EnableExpress', 'type': 'bool', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
        'user_metadata': {'key': 'UserMetadata', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }
    _xml_map = {
        'name': 'TopicDescription', 'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'
    }

    def __init__(
        self,
        *,
        default_message_time_to_live: Optional[datetime.timedelta] = None,
        max_size_in_megabytes: Optional[int] = None,
        requires_duplicate_detection: Optional[bool] = None,
        duplicate_detection_history_time_window: Optional[datetime.timedelta] = None,
        enable_batched_operations: Optional[bool] = None,
        size_in_bytes: Optional[int] = None,
        filtering_messages_before_publishing: Optional[bool] = None,
        is_anonymous_accessible: Optional[bool] = None,
        authorization_rules: Optional[List["AuthorizationRule"]] = None,
        status: Optional[Union[str, "EntityStatus"]] = None,
        created_at: Optional[datetime.datetime] = None,
        updated_at: Optional[datetime.datetime] = None,
        accessed_at: Optional[datetime.datetime] = None,
        support_ordering: Optional[bool] = None,
        message_count_details: Optional["MessageCountDetails"] = None,
        subscription_count: Optional[int] = None,
        auto_delete_on_idle: Optional[datetime.timedelta] = None,
        enable_partitioning: Optional[bool] = None,
        entity_availability_status: Optional[Union[str, "EntityAvailabilityStatus"]] = None,
        enable_subscription_partitioning: Optional[bool] = None,
        enable_express: Optional[bool] = None,
        user_metadata: Optional[str] = None,
        **kwargs
    ):
        super(TopicDescription, self).__init__(**kwargs)
        self.default_message_time_to_live = default_message_time_to_live
        self.max_size_in_megabytes = max_size_in_megabytes
        self.requires_duplicate_detection = requires_duplicate_detection
        self.duplicate_detection_history_time_window = duplicate_detection_history_time_window
        self.enable_batched_operations = enable_batched_operations
        self.size_in_bytes = size_in_bytes
        self.filtering_messages_before_publishing = filtering_messages_before_publishing
        self.is_anonymous_accessible = is_anonymous_accessible
        self.authorization_rules = authorization_rules
        self.status = status
        self.created_at = created_at
        self.updated_at = updated_at
        self.accessed_at = accessed_at
        self.support_ordering = support_ordering
        self.message_count_details = message_count_details
        self.subscription_count = subscription_count
        self.auto_delete_on_idle = auto_delete_on_idle
        self.enable_partitioning = enable_partitioning
        self.entity_availability_status = entity_availability_status
        self.enable_subscription_partitioning = enable_subscription_partitioning
        self.enable_express = enable_express
        self.user_metadata = user_metadata


class TopicDescriptionEntry(msrest.serialization.Model):
    """Represents an entry in the feed when querying topics.

    :param base: Base URL for the query.
    :type base: str
    :param id: The URL of the GET request.
    :type id: str
    :param title: The name of the topic.
    :type title: object
    :param published: The timestamp for when this topic was published.
    :type published: ~datetime.datetime
    :param updated: The timestamp for when this topic was last updated.
    :type updated: ~datetime.datetime
    :param author: The author that created this resource.
    :type author: ~azure.servicebus.management._generated.models.ResponseAuthor
    :param link: The URL for the HTTP request.
    :type link: ~azure.servicebus.management._generated.models.ResponseLink
    :param content: The TopicDescription.
    :type content: ~azure.servicebus.management._generated.models.TopicDescriptionEntryContent
    """

    _attribute_map = {
        'base': {'key': 'base', 'type': 'str', 'xml': {'name': 'base', 'attr': True, 'prefix': 'xml'}},
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'published': {'key': 'published', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'author': {'key': 'author', 'type': 'ResponseAuthor'},
        'link': {'key': 'link', 'type': 'ResponseLink'},
        'content': {'key': 'content', 'type': 'TopicDescriptionEntryContent'},
    }
    _xml_map = {
        'name': 'entry', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        base: Optional[str] = None,
        id: Optional[str] = None,
        title: Optional[object] = None,
        published: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        author: Optional["ResponseAuthor"] = None,
        link: Optional["ResponseLink"] = None,
        content: Optional["TopicDescriptionEntryContent"] = None,
        **kwargs
    ):
        super(TopicDescriptionEntry, self).__init__(**kwargs)
        self.base = base
        self.id = id
        self.title = title
        self.published = published
        self.updated = updated
        self.author = author
        self.link = link
        self.content = content


class TopicDescriptionEntryContent(msrest.serialization.Model):
    """The TopicDescription.

    :param type: Type of content in queue response.
    :type type: str
    :param topic_description: Description of a Service Bus topic resource.
    :type topic_description: ~azure.servicebus.management._generated.models.TopicDescription
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True}},
        'topic_description': {'key': 'TopicDescription', 'type': 'TopicDescription'},
    }
    _xml_map = {
        'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        topic_description: Optional["TopicDescription"] = None,
        **kwargs
    ):
        super(TopicDescriptionEntryContent, self).__init__(**kwargs)
        self.type = type
        self.topic_description = topic_description


class TopicDescriptionFeed(msrest.serialization.Model):
    """Response from listing Service Bus topics.

    :param id: URL of the list topics query.
    :type id: str
    :param title: The entity type for the feed.
    :type title: object
    :param updated: Datetime of the query.
    :type updated: ~datetime.datetime
    :param link: Links to paginated response.
    :type link: list[~azure.servicebus.management._generated.models.ResponseLink]
    :param entry: Topic entries.
    :type entry: list[~azure.servicebus.management._generated.models.TopicDescriptionEntry]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'title': {'key': 'title', 'type': 'object'},
        'updated': {'key': 'updated', 'type': 'iso-8601', 'xml': {'ns': 'http://www.w3.org/2005/Atom'}},
        'link': {'key': 'link', 'type': '[ResponseLink]'},
        'entry': {'key': 'entry', 'type': '[TopicDescriptionEntry]'},
    }
    _xml_map = {
        'name': 'feed', 'ns': 'http://www.w3.org/2005/Atom'
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        title: Optional[object] = None,
        updated: Optional[datetime.datetime] = None,
        link: Optional[List["ResponseLink"]] = None,
        entry: Optional[List["TopicDescriptionEntry"]] = None,
        **kwargs
    ):
        super(TopicDescriptionFeed, self).__init__(**kwargs)
        self.id = id
        self.title = title
        self.updated = updated
        self.link = link
        self.entry = entry


class TrueFilter(RuleFilter):
    """TrueFilter.

    :param type: Constant filled by server.
    :type type: str
    :param sql_expression:
    :type sql_expression: str
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str', 'xml': {'attr': True, 'prefix': 'xsi', 'ns': 'http://www.w3.org/2001/XMLSchema-instance'}},
        'sql_expression': {'key': 'SqlExpression', 'type': 'str', 'xml': {'ns': 'http://schemas.microsoft.com/netservices/2010/10/servicebus/connect'}},
    }

    def __init__(
        self,
        *,
        sql_expression: Optional[str] = "1 = 1",
        **kwargs
    ):
        super(TrueFilter, self).__init__(**kwargs)
        self.type: str = 'TrueFilter'
        self.sql_expression = sql_expression
