# -*- coding:utf-8 -*-
"""
XtdFile类单元测试
"""

import unittest

from vaspy.matstudio import ArcFile, XtdFile
from tests import path


class XtdTest(unittest.TestCase):

    def setUp(self):
        self.maxDiff = True

    def test_construction_query(self):
        " Test XtdFile object construction and query functions. "
        filename = path + "/00-04.xtd"
        arcname = path + "/00-04.arc"
        xtd = XtdFile(filename, arcname)

        self.assertTrue(isinstance(xtd.arcfile, ArcFile))

        # Check if no arcfile.
        xtd = XtdFile(filename)
        self.assertTrue(xtd.arcfile is None)

    def test_coords_iterator(self):
        " Make sure we can get correct direct coordinates. "
        filename = path + "/00-04.xtd"
        arcname = path + "/00-04.arc"
        xtd = XtdFile(filename, arcname)

        ref_coords = [[0.05100029522154211, 0.39850231693493543, 0.11064568869218162],
                      [0.05100029522154211, 0.39850231693493543, 0.33250176930623526],
                      [0.05100029522154211, 0.14850086526108972, 0.0],
                      [0.05100029522154211, 0.14850086526108972, 0.22168693759127747],
                      [0.05100029522154211, 0.14850086526108972, 0.4409576855929274],
                      [0.30100174689538783, 0.14850086526108972, 0.11064568869218162],
                      [0.30100174689538783, 0.14850086526108972, 0.33250176930623526],
                      [0.30100174689538783, 0.39850231693493543, 0.0],
                      [0.30100174689538783, 0.39850231693493543, 0.22168693759127747],
                      [0.30100174689538783, 0.39850231693493543, 0.4409576855929274],
                      [0.5510031985692336, 0.39850231693493543, 0.11064568869218162],
                      [0.5510031985692336, 0.39850231693493543, 0.33250176930623526],
                      [0.5510031985692336, 0.14850086526108972, 0.0],
                      [0.5510031985692336, 0.14850086526108972, 0.22168693759127747],
                      [0.5510031985692336, 0.14850086526108972, 0.4409576855929274],
                      [0.801004650369027, 0.14850086526108972, 0.11064568869218162],
                      [0.801004650369027, 0.14850086526108972, 0.33250176930623526],
                      [0.801004650369027, 0.39850231693493543, 0.0],
                      [0.801004650369027, 0.39850231693493543, 0.22168693759127747],
                      [0.801004650369027, 0.39850231693493543, 0.4409576855929274],
                      [0.05100029522154211, 0.8985052204085746, 0.11064568869218162],
                      [0.05100029522154211, 0.8985052204085746, 0.33250176930623526],
                      [0.05100029522154211, 0.6485037686087811, 0.0],
                      [0.05100029522154211, 0.6485037686087811, 0.22168693759127747],
                      [0.05100029522154211, 0.6485037686087811, 0.4409576855929274],
                      [0.30100174689538783, 0.6485037686087811, 0.11064568869218162],
                      [0.30100174689538783, 0.6485037686087811, 0.33250176930623526],
                      [0.30100174689538783, 0.8985052204085746, 0.0],
                      [0.30100174689538783, 0.8985052204085746, 0.22168693759127747],
                      [0.30100174689538783, 0.8985052204085746, 0.4409576855929274],
                      [0.5510031985692336, 0.8985052204085746, 0.11064568869218162],
                      [0.5510031985692336, 0.8985052204085746, 0.33250176930623526],
                      [0.5510031985692336, 0.6485037686087811, 0.0],
                      [0.5510031985692336, 0.6485037686087811, 0.22168693759127747],
                      [0.5510031985692336, 0.6485037686087811, 0.4409576855929274],
                      [0.801004650369027, 0.6485037686087811, 0.11064568869218162],
                      [0.801004650369027, 0.6485037686087811, 0.33250176930623526],
                      [0.801004650369027, 0.8985052204085746, 0.0],
                      [0.801004650369027, 0.8985052204085746, 0.22168693759127747],
                      [0.801004650369027, 0.8985052204085746, 0.4409576855929274],
                      [0.43073120809088394, 0.526894851885438, 0.5129361059766553]]
        for ret_coords in xtd.coords_iterator:
            ret_coords = ret_coords.tolist()
            break

        self.assertListEqual(ref_coords, ret_coords)

