# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .open_shift_managed_cluster_base_identity_provider import OpenShiftManagedClusterBaseIdentityProvider


class OpenShiftManagedClusterAADIdentityProvider(OpenShiftManagedClusterBaseIdentityProvider):
    """Defines the Identity provider for MS AAD.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param client_id: The clientId password associated with the provider.
    :type client_id: str
    :param secret: The secret password associated with the provider.
    :type secret: str
    :param tenant_id: The tenantId associated with the provider.
    :type tenant_id: str
    :param customer_admin_group_id: The groupId to be granted cluster admin
     role.
    :type customer_admin_group_id: str
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'customer_admin_group_id': {'key': 'customerAdminGroupId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OpenShiftManagedClusterAADIdentityProvider, self).__init__(**kwargs)
        self.client_id = kwargs.get('client_id', None)
        self.secret = kwargs.get('secret', None)
        self.tenant_id = kwargs.get('tenant_id', None)
        self.customer_admin_group_id = kwargs.get('customer_admin_group_id', None)
        self.kind = 'AADIdentityProvider'
