# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .http_authentication import HttpAuthentication


class ClientCertAuthentication(HttpAuthentication):
    """ClientCertAuthentication

    :param type: Gets or sets the http authentication type. Possible values
     include: 'NotSpecified', 'ClientCertificate', 'ActiveDirectoryOAuth',
     'Basic'
    :type type: str
    :param password: Gets or sets the password.
    :type password: str
    :param pfx: Gets or sets the pfx.
    :type pfx: str
    :param certificate_thumbprint: Gets or sets the certificate thumbprint.
    :type certificate_thumbprint: str
    :param certificate_expiration_date: Gets or sets the certificate
     expiration date.
    :type certificate_expiration_date: datetime
    :param certificate_subject_name: Gets or sets the certificate subject
     name.
    :type certificate_subject_name: str
    """ 

    _attribute_map = {
        'type': {'key': 'type', 'type': 'HttpAuthenticationType'},
        'password': {'key': 'password', 'type': 'str'},
        'pfx': {'key': 'pfx', 'type': 'str'},
        'certificate_thumbprint': {'key': 'certificateThumbprint', 'type': 'str'},
        'certificate_expiration_date': {'key': 'certificateExpirationDate', 'type': 'iso-8601'},
        'certificate_subject_name': {'key': 'certificateSubjectName', 'type': 'str'},
    }

    def __init__(self, type=None, password=None, pfx=None, certificate_thumbprint=None, certificate_expiration_date=None, certificate_subject_name=None, **kwargs):
        super(ClientCertAuthentication, self).__init__(type=type, **kwargs)
        self.password = password
        self.pfx = pfx
        self.certificate_thumbprint = certificate_thumbprint
        self.certificate_expiration_date = certificate_expiration_date
        self.certificate_subject_name = certificate_subject_name
