# algorithm.py
# KMB 09/07/07

import numpy as num
from scipy.linalg.basic import eps
import time
import wx
from wx import xrc

import motmot.wxvalidatedtext as wxvt # part of Motmot

from version import DEBUG
import annfiles as annot
import ellipsesk as ell
from movies import NoMoreFramesException
import settings
import hindsight
#import sys

from params import params

import pkg_resources # part of setuptools
SETTINGS_RSRC_FILE = pkg_resources.resource_filename( __name__, "track_settings.xrc" )

# MtraxApp.Track #################################################
class MtraxAlgorithm (settings.AppWithSettings):
    """Cannot be used alone -- this class only exists
    to keep algorithm code together in one file."""
    def Track( self ):
        """Run the m-tracker."""

        ## initialization ##

        # maximum number of frames we will look back to fix errors
        self.maxlookback = max(params.lostdetection_length,
                               params.spuriousdetection_length,
                               params.mergeddetection_length,
                               params.splitdetection_length)

        # initialize annotation file
        self.ann_file = annot.AnnotationFile( self.ann_filename, params.version, True )
        self.ann_file.WriteAnnHeader( params.start_frame, self.bg_imgs )

        # write the current tracks to file
        for ff in range(len(self.ann_data)-self.maxlookback):
            self.ann_file.write_ellipses(self.ann_data[ff])
        self.lastframewritten = max(-1,len(self.ann_data)-self.maxlookback-1)
        
        wx.Yield()

        # if we haven't done any tracking yet
        if (self.ann_data is None) or (len(self.ann_data) == 0):
            self.ann_data = []
            params.nids = 0

        # initialize hindsight data structures
        self.hindsight = hindsight.Hindsight(self.ann_data,self.bg_imgs)
        self.hindsight.initialize_milestones()

        self.break_flag = False

        #print 'In Track, just before main loop: self.start_frame = %d, params.start_frame = %d, len(ann_data) = %d'%(self.start_frame,params.start_frame,len(self.ann_data))

        for self.start_frame in range(self.start_frame,self.n_frames):

            if self.break_flag:
                break

            last_time = time.time()

            # perform background subtraction
            (self.dfore,self.isfore) = self.bg_imgs.sub_bg( self.start_frame )

            #print 'time to perform background subtraction: '+str(time.time() - last_time)

            # process gui events
            if params.interactive:
                wx.Yield()
            if self.break_flag:
                break

            # find observations
            self.ellipses = ell.find_ellipses( self.dfore, self.isfore )

            #if params.DOBREAK:
            #    print 'Exiting at frame %d'%self.start_frame
            #    sys.exit(1)

            # process gui events
            if params.interactive:
                wx.Yield()
            if self.break_flag:
                break

            # match target identities to observations
            if len( self.ann_data ) > 1:
                flies = ell.find_flies( self.ann_data[-2],
                                        self.ann_data[-1],
                                        self.ellipses )                    
            elif len( self.ann_data ) == 1:
                flies = ell.find_flies( self.ann_data[0],
                                        self.ann_data[0],
                                        self.ellipses )
            else:
                flies = ell.TargetList()
                for i,obs in enumerate(self.ellipses):
                    if obs.isEmpty():
                        print 'empty observation'
                    else:
                        obs.identity = params.nids
                        flies.append(obs)
                        params.nids+=1

            # save to ann_data
            self.ann_data.append( flies )

            # fix any errors using hindsight
            self.hindsight.fixerrors()
            #print 'time to fix errors: '+str(time.time() - last_time)

            # write to file
            if (self.ann_data is not None) and \
                   (len(self.ann_data) > self.maxlookback+self.lastframewritten): 
                self.lastframewritten = self.lastframewritten + 1
                self.ann_file.write_ellipses(self.ann_data[self.lastframewritten])
            #print 'In Track, after writing: self.start_frame = %d, params.start_frame = %d, len(ann_data) = %d'%(self.start_frame,params.start_frame,len(self.ann_data))

            # draw?
            if params.request_refresh or (params.do_refresh and ((self.start_frame % params.framesbetweenrefresh) == 0)):
                if params.interactive:
                    if self.start_frame:
                        self.ShowCurrentFrame()
                else:
                    print "Frame %d / %d"%(self.start_frame,self.n_frames)    
                params.request_refresh = False

            # process gui events
            if params.interactive:
                wx.Yield()
            if self.break_flag:
                break

        self.Finish()

    def Finish(self):

        # write the rest of the frames to file
        for ff in range(self.lastframewritten+1,len(self.ann_data)):
            self.ann_file.write_ellipses(self.ann_data[ff])
        self.lastframewritten = len(self.ann_data)-1
        # close the file
        self.ann_file.file.close()

    # enddef: Track()

    def StopThreads( self ):

        wx.Yield()

        # stop algorithm
        self.break_flag = True

    def InitTrackingState(self):

	# initialize tracking state
        self.tracking = True
        self.ann_data = []
        params.nids = 0
        params.start_frame = 0
        self.start_frame = 0

    def DoAllPreprocessing(self):

        # estimate the background
        print "Estimating background model"
        self.bg_imgs.est_bg()

        # detect arena if it has not been set yet
        if params.do_set_circular_arena:
            setarena.doall(self.bg_imgs.center)

        self.bg_imgs.UpdateIsNotArena()

        # estimate the shape
        print "Estimating shape model"
        ell.est_shape(self.bg_imgs)

    def DoAll(self):

	self.DoAllPreprocessing()
	
        # begin tracking
        if params.interactive:
            self.UpdateToolBar('started')
        print "Tracking..."
        self.Track()

        # choose orientations
        self.choose_orientations = chooseorientations.ChooseOrientations(self.frame,self.ann_data,interactive=False)
        self.choose_orientations.ChooseOrientations()

        # save to a .mat file
        (basename,ext) = os.path.splitext(self.filename)
        savename = basename + '.mat'
        self.ann_file.WriteMAT( savename, self.ann_data )
