# Generated by https://quicktype.io
#
# To change quicktype's target language, run command:
#
#   "Set quicktype target language"

from typing import List
import sqlite3
import logging
import time


class Asset:
    url: str

    def __init__(self, url: str) -> None:
        self.url = url


class Stock:
    ecom: bool
    retail: bool

    def __init__(self, ecom: bool, retail: bool) -> None:
        self.ecom = ecom
        self.retail = retail


class Product:
    sku: str
    title: str
    product_code: str
    assets: List[Asset]
    more_colors: bool
    size: str
    avg_color: str
    department_code: str
    family_code: str
    division_code: str
    price: int
    url: str
    slug: str
    has_stock: bool
    has_stock_retail: bool
    has_stock_or_has_stock_retail: bool
    stock: Stock
    personalize: bool
    lastmodify: float
    _hash: str

    def __init__(self, sku: str, title: str, product_code: str, assets: List[Asset], more_colors: bool, size: str, avg_color: str, department_code: str, family_code: str, division_code: str, price: int, url: str, slug: str, has_stock: bool, has_stock_retail: bool, has_stock_or_has_stock_retail: bool, stock: Stock, personalize: bool) -> None:
        self.sku = sku
        self.title = title
        self.product_code = product_code
        self.assets = assets
        self.more_colors = more_colors
        self.size = size
        self.avg_color = avg_color
        self.department_code = department_code
        self.family_code = family_code
        self.division_code = division_code
        self.price = price
        self.url = url
        self.slug = slug
        self.has_stock = has_stock
        self.has_stock_retail = has_stock_retail
        self.has_stock_or_has_stock_retail = has_stock_or_has_stock_retail
        self.stock = stock
        self.personalize = personalize
        self.lastmodify = time.time()
        self.hash = ""

    def save(self, db_connect: sqlite3.Connection):
        cur = db_connect.cursor()
        sql = "insert into products(sku, title, product_code, avg_color, department_code,assets, family_code, division_code, price, url, slug, has_stock, has_stock_retail, has_stock_or_has_stock_retail,stock, personalize) values(?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?,?, ?)"
        logging.info(sql)
        db_connect.execute(sql, (self.sku, self.title, self.product_code if self.product_code is not None else 'NULL', self.avg_color,
                                 self.department_code, 'Null', self.family_code, 'Null', 'Null', 'Null', False, False, False, False, False, 'Null'))

        db_connect.commit()


class Category:
    tid: int
    name: str
    pimCode: str
    path: str

    def __init__(self, tid=None, name=None, pimCode=None, path=None):
        self.tid = tid
        self.name = name
        self.pimCode = pimCode
        self.path = path
