# -*- coding: utf-8 -*-
import os, cherrypy
from glams.website.database.database import Database
from glams.website.info.info import Info
from glams.website.home.home import Home
from glams.website.experimentlog.experimentlog import Experimentlog
from glams.website.admin.admin import Admin

webpage="""<!DOCTYPE HTML>
<html>
<head>
    <title>GLAMS</title>
    <link href="/support/css/almanacstyle.css" rel="stylesheet" type="text/css" />
    <link href="/support/css/homepage.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="/support/javascript/jquery.js"></script>
    <script type="text/javascript" src="/support/javascript/jquery-ui.js"></script>
    <link rel="stylesheet" type="text/css" href="/support/css/searchform.css" />

    <script type="text/javascript">
    $(document).ready(function () {
        var t;
        $('#menu').hover(
            function(){
                clearTimeout(t);
                $('.menu_body').show("fade", {}, 700);
            },function(){
            t=setTimeout("$('.menu_body').hide('fade', {}, 700);",3000);
        });
        $('#menu').click(function(){
            $('.menu_body').show("fade", {}, 700);
        });
    });
    </script>
</head>


<body>
<div class=wrapper>
    <div id='menu'>
        <h2 class="menu_head">GLAMS<p style='color:grey;padding-left: 30px;'>Gandhi Lab Animal Management System</p></h2>
        <ul class="menu_body"> 
            <li><a href="/database/">Database</a></li>
            <li><a href="/info/">Information</a></li>
            <li><a href="/home/login/">Log in</a></li>
        </ul>
    </div>
</div>  


</body>
</html>"""
 
class Root:
    database=Database()
    info=Info()
    experimentlog=Experimentlog()
    home=Home()
    admin=Admin()
    webpage= webpage
    @cherrypy.expose
    def index(self):
        return Root.webpage

rootDirectory=os.getcwd()
config={
        'global':{
            'server.thread_pool':15
        },
        '/': {
                'tools.staticdir.root' : rootDirectory,
                'tools.encode.encoding':'utf-8',
                'tools.encode.on' :True,
                'tools.decode.on' : True,
            },
        '/support':{
                'tools.staticdir.on': True,
                'tools.staticdir.dir' : 'support',
            },
    }
cherrypy.config.update({
        'server.socket_host': '0.0.0.0',
        'server.socket_port': 80}) #To bind on port 80, you must have root priveliges.  To run it in the wild, bind to port 80.  For testing, do port 8080 .

cherrypy.quickstart(Root(), config=config)
