# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class VirtualMachineExtensionImage(SubResource):
    """
    Describes a Virtual Machine Extension Image.

    :param str id: Resource Id
    :param str operating_system: Gets or sets the operating system this
     extension supports.
    :param str compute_role: Gets or sets the type of role (IaaS or PaaS)
     this extension supports.
    :param str handler_schema: Gets or sets the schema defined by publisher,
     where extension consumers should provide settings in a matching schema.
    :param bool vm_scale_set_enabled: Gets or sets whether the extension can
     be used on xRP VMScaleSets.By default existing extensions are usable on
     scalesets, but there might be cases where a publisher wants to
     explicitly indicate the extension is only enabled for CRP VMs but not
     VMSS.
    :param bool supports_multiple_extensions: Gets or sets whether the
     handler can support multiple extensions.
    :param str name: Gets or sets the name of the resource.
    :param str location: Gets or sets the location of the resource.
    :param dict tags: Gets or sets the tags attached to the resource.
    """ 

    _validation = {
        'operating_system': {'required': True},
        'compute_role': {'required': True},
        'handler_schema': {'required': True},
        'name': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'operating_system': {'key': 'properties.operatingSystem', 'type': 'str'},
        'compute_role': {'key': 'properties.computeRole', 'type': 'str'},
        'handler_schema': {'key': 'properties.handlerSchema', 'type': 'str'},
        'vm_scale_set_enabled': {'key': 'properties.vmScaleSetEnabled', 'type': 'bool'},
        'supports_multiple_extensions': {'key': 'properties.supportsMultipleExtensions', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, operating_system, compute_role, handler_schema, name, location, id=None, vm_scale_set_enabled=None, supports_multiple_extensions=None, tags=None, **kwargs):
        super(VirtualMachineExtensionImage, self).__init__(id=id, **kwargs)
        self.operating_system = operating_system
        self.compute_role = compute_role
        self.handler_schema = handler_schema
        self.vm_scale_set_enabled = vm_scale_set_enabled
        self.supports_multiple_extensions = supports_multiple_extensions
        self.name = name
        self.location = location
        self.tags = tags
