# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ComputeLongRunningOperationResult(Model):
    """
    The Compute service response for long-running operations.

    :param str operation_id: Gets the operation identifier.
    :param str status: Gets the operation status. Possible values include:
     'InProgress', 'Failed', 'Succeeded', 'Preempted'
    :param datetime start_time: Gets the operation start time
    :param datetime end_time: Gets the operation end time
    :param ComputeLongRunningOperationProperties properties:
    :param ApiError error: Gets the operation error, if any occurred.
    """ 

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'ComputeOperationStatus'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'properties': {'key': 'properties', 'type': 'ComputeLongRunningOperationProperties'},
        'error': {'key': 'error', 'type': 'ApiError'},
    }

    def __init__(self, operation_id=None, status=None, start_time=None, end_time=None, properties=None, error=None, **kwargs):
        self.operation_id = operation_id
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.properties = properties
        self.error = error
