# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._azure_digital_twins_management_client_enums import *


class CheckNameRequest(msrest.serialization.Model):
    """The result returned from a database check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Resource name.
    :type name: str
    :ivar type: Required. The type of resource, for instance
     Microsoft.DigitalTwins/digitalTwinsInstances. Default value:
     "Microsoft.DigitalTwins/digitalTwinsInstances".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.DigitalTwins/digitalTwinsInstances"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(CheckNameRequest, self).__init__(**kwargs)
        self.name = name


class CheckNameResult(msrest.serialization.Model):
    """The result returned from a check name availability request.

    :param name_available: Specifies a Boolean value that indicates if the name is available.
    :type name_available: bool
    :param message: Message indicating an unavailable name due to a conflict, or a description of
     the naming rules that are violated.
    :type message: str
    :param reason: Message providing the reason why the given name is invalid. Possible values
     include: "Invalid", "AlreadyExists".
    :type reason: str or ~azure.mgmt.digitaltwins.models.Reason
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'message': {'key': 'message', 'type': 'str'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        message: Optional[str] = None,
        reason: Optional[Union[str, "Reason"]] = None,
        **kwargs
    ):
        super(CheckNameResult, self).__init__(**kwargs)
        self.name_available = name_available
        self.message = message
        self.reason = reason


class ConnectionProperties(msrest.serialization.Model):
    """The properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state. Possible values include: "Pending",
     "Approved", "Rejected", "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.models.ConnectionPropertiesProvisioningState
    :param private_endpoint: The private endpoint property of a private endpoint connection.
    :type private_endpoint: ~azure.mgmt.digitaltwins.models.PrivateEndpoint
    :param group_ids: The list of group ids for the private endpoint connection.
    :type group_ids: list[str]
    :param private_link_service_connection_state: The current state of a private endpoint
     connection.
    :type private_link_service_connection_state: ~azure.mgmt.digitaltwins.models.ConnectionState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpoint'},
        'group_ids': {'key': 'groupIds', 'type': '[str]'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'ConnectionState'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        group_ids: Optional[List[str]] = None,
        private_link_service_connection_state: Optional["ConnectionState"] = None,
        **kwargs
    ):
        super(ConnectionProperties, self).__init__(**kwargs)
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.group_ids = group_ids
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateEndpoint(msrest.serialization.Model):
    """The private endpoint property of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class ConnectionPropertiesPrivateEndpoint(PrivateEndpoint):
    """ConnectionPropertiesPrivateEndpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConnectionPropertiesPrivateEndpoint, self).__init__(**kwargs)


class ConnectionState(msrest.serialization.Model):
    """The current state of a private endpoint connection.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status of a private endpoint connection. Possible values include:
     "Pending", "Approved", "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.digitaltwins.models.PrivateLinkServiceConnectionStatus
    :param description: Required. The description for the current state of a private endpoint
     connection.
    :type description: str
    :param actions_required: Actions required for a private endpoint connection.
    :type actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "PrivateLinkServiceConnectionStatus"],
        description: str,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ConnectionPropertiesPrivateLinkServiceConnectionState(ConnectionState):
    """ConnectionPropertiesPrivateLinkServiceConnectionState.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status of a private endpoint connection. Possible values include:
     "Pending", "Approved", "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.digitaltwins.models.PrivateLinkServiceConnectionStatus
    :param description: Required. The description for the current state of a private endpoint
     connection.
    :type description: str
    :param actions_required: Actions required for a private endpoint connection.
    :type actions_required: str
    """

    _validation = {
        'status': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "PrivateLinkServiceConnectionStatus"],
        description: str,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionPropertiesPrivateLinkServiceConnectionState, self).__init__(status=status, description=description, actions_required=actions_required, **kwargs)


class DigitalTwinsResource(msrest.serialization.Model):
    """The common properties of a DigitalTwinsInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param identity: The managed identity for the DigitalTwinsInstance.
    :type identity: ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?!-)[A-Za-z0-9-]{3,63}(?<!-)$'},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'DigitalTwinsIdentity'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["DigitalTwinsIdentity"] = None,
        **kwargs
    ):
        super(DigitalTwinsResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.identity = identity


class DigitalTwinsDescription(DigitalTwinsResource):
    """The description of the DigitalTwins service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param location: Required. The resource location.
    :type location: str
    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param identity: The managed identity for the DigitalTwinsInstance.
    :type identity: ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentity
    :ivar created_time: Time when DigitalTwinsInstance was created.
    :vartype created_time: ~datetime.datetime
    :ivar last_updated_time: Time when DigitalTwinsInstance was updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state. Possible values include: "Provisioning",
     "Deleting", "Updating", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending",
     "Restoring", "Moving".
    :vartype provisioning_state: str or ~azure.mgmt.digitaltwins.models.ProvisioningState
    :ivar host_name: Api endpoint to work with DigitalTwinsInstance.
    :vartype host_name: str
    :param private_endpoint_connections:
    :type private_endpoint_connections:
     list[~azure.mgmt.digitaltwins.models.PrivateEndpointConnection]
    :param public_network_access: Public network access for the DigitalTwinsInstance. Possible
     values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.digitaltwins.models.PublicNetworkAccess
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?!-)[A-Za-z0-9-]{3,63}(?<!-)$'},
        'type': {'readonly': True},
        'location': {'required': True},
        'created_time': {'readonly': True},
        'last_updated_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'host_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'DigitalTwinsIdentity'},
        'created_time': {'key': 'properties.createdTime', 'type': 'iso-8601'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["DigitalTwinsIdentity"] = None,
        private_endpoint_connections: Optional[List["PrivateEndpointConnection"]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(DigitalTwinsDescription, self).__init__(location=location, tags=tags, identity=identity, **kwargs)
        self.created_time = None
        self.last_updated_time = None
        self.provisioning_state = None
        self.host_name = None
        self.private_endpoint_connections = private_endpoint_connections
        self.public_network_access = public_network_access


class DigitalTwinsDescriptionListResult(msrest.serialization.Model):
    """A list of DigitalTwins description objects with a next link.

    :param next_link: The link used to get the next page of DigitalTwins description objects.
    :type next_link: str
    :param value: A list of DigitalTwins description objects.
    :type value: list[~azure.mgmt.digitaltwins.models.DigitalTwinsDescription]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DigitalTwinsDescription]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["DigitalTwinsDescription"]] = None,
        **kwargs
    ):
        super(DigitalTwinsDescriptionListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ExternalResource(msrest.serialization.Model):
    """Definition of a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: Extension resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExternalResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class DigitalTwinsEndpointResource(ExternalResource):
    """DigitalTwinsInstance endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: Extension resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param properties: Required. DigitalTwinsInstance endpoint resource properties.
    :type properties: ~azure.mgmt.digitaltwins.models.DigitalTwinsEndpointResourceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DigitalTwinsEndpointResourceProperties'},
    }

    def __init__(
        self,
        *,
        properties: "DigitalTwinsEndpointResourceProperties",
        **kwargs
    ):
        super(DigitalTwinsEndpointResource, self).__init__(**kwargs)
        self.properties = properties


class DigitalTwinsEndpointResourceListResult(msrest.serialization.Model):
    """A list of DigitalTwinsInstance Endpoints with a next link.

    :param next_link: The link used to get the next page of DigitalTwinsInstance Endpoints.
    :type next_link: str
    :param value: A list of DigitalTwinsInstance Endpoints.
    :type value: list[~azure.mgmt.digitaltwins.models.DigitalTwinsEndpointResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[DigitalTwinsEndpointResource]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["DigitalTwinsEndpointResource"]] = None,
        **kwargs
    ):
        super(DigitalTwinsEndpointResourceListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DigitalTwinsEndpointResourceProperties(msrest.serialization.Model):
    """Properties related to Digital Twins Endpoint.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: EventGrid, EventHub, ServiceBus.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. The type of Digital Twins endpoint.Constant filled by server.
     Possible values include: "EventHub", "EventGrid", "ServiceBus".
    :type endpoint_type: str or ~azure.mgmt.digitaltwins.models.EndpointType
    :ivar provisioning_state: The provisioning state. Possible values include: "Provisioning",
     "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     "Moving", "Disabled".
    :vartype provisioning_state: str or ~azure.mgmt.digitaltwins.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :param authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Possible values include: "KeyBased", "IdentityBased".
    :type authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
    :param dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :type dead_letter_secret: str
    :param dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :type dead_letter_uri: str
    """

    _validation = {
        'endpoint_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'dead_letter_secret': {'key': 'deadLetterSecret', 'type': 'str'},
        'dead_letter_uri': {'key': 'deadLetterUri', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'EventGrid': 'EventGrid', 'EventHub': 'EventHub', 'ServiceBus': 'ServiceBus'}
    }

    def __init__(
        self,
        *,
        authentication_type: Optional[Union[str, "AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        **kwargs
    ):
        super(DigitalTwinsEndpointResourceProperties, self).__init__(**kwargs)
        self.endpoint_type = None  # type: Optional[str]
        self.provisioning_state = None
        self.created_time = None
        self.authentication_type = authentication_type
        self.dead_letter_secret = dead_letter_secret
        self.dead_letter_uri = dead_letter_uri


class DigitalTwinsIdentity(msrest.serialization.Model):
    """The managed identity for the DigitalTwinsInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: The type of Managed Identity used by the DigitalTwinsInstance. Only SystemAssigned
     is supported. Possible values include: "None", "SystemAssigned".
    :type type: str or ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentityType
    :ivar principal_id: The object id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-identity-principal-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the Managed Identity Resource. This will be sent to the RP
     from ARM via the x-ms-client-tenant-id header in the PUT request if the resource has a
     systemAssigned(implicit) identity.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "DigitalTwinsIdentityType"]] = None,
        **kwargs
    ):
        super(DigitalTwinsIdentity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None


class DigitalTwinsPatchDescription(msrest.serialization.Model):
    """The description of the DigitalTwins service.

    :param tags: A set of tags. Instance patch properties.
    :type tags: dict[str, str]
    :param identity: The managed identity for the DigitalTwinsInstance.
    :type identity: ~azure.mgmt.digitaltwins.models.DigitalTwinsIdentity
    :param properties: Properties for the DigitalTwinsInstance.
    :type properties: ~azure.mgmt.digitaltwins.models.DigitalTwinsPatchProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'DigitalTwinsIdentity'},
        'properties': {'key': 'properties', 'type': 'DigitalTwinsPatchProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["DigitalTwinsIdentity"] = None,
        properties: Optional["DigitalTwinsPatchProperties"] = None,
        **kwargs
    ):
        super(DigitalTwinsPatchDescription, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.properties = properties


class DigitalTwinsPatchProperties(msrest.serialization.Model):
    """The properties of a DigitalTwinsInstance.

    :param public_network_access: Public network access for the DigitalTwinsInstance. Possible
     values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.digitaltwins.models.PublicNetworkAccess
    """

    _attribute_map = {
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(DigitalTwinsPatchProperties, self).__init__(**kwargs)
        self.public_network_access = public_network_access


class ErrorDefinition(msrest.serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: Internal error details.
    :vartype details: list[~azure.mgmt.digitaltwins.models.ErrorDefinition]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDefinition, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    :param error: Error description.
    :type error: ~azure.mgmt.digitaltwins.models.ErrorDefinition
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDefinition'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDefinition"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class EventGrid(DigitalTwinsEndpointResourceProperties):
    """Properties related to EventGrid.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. The type of Digital Twins endpoint.Constant filled by server.
     Possible values include: "EventHub", "EventGrid", "ServiceBus".
    :type endpoint_type: str or ~azure.mgmt.digitaltwins.models.EndpointType
    :ivar provisioning_state: The provisioning state. Possible values include: "Provisioning",
     "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     "Moving", "Disabled".
    :vartype provisioning_state: str or ~azure.mgmt.digitaltwins.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :param authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Possible values include: "KeyBased", "IdentityBased".
    :type authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
    :param dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :type dead_letter_secret: str
    :param dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :type dead_letter_uri: str
    :param topic_endpoint: Required. EventGrid Topic Endpoint.
    :type topic_endpoint: str
    :param access_key1: Required. EventGrid secondary accesskey. Will be obfuscated during read.
    :type access_key1: str
    :param access_key2: EventGrid secondary accesskey. Will be obfuscated during read.
    :type access_key2: str
    """

    _validation = {
        'endpoint_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
        'topic_endpoint': {'required': True},
        'access_key1': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'dead_letter_secret': {'key': 'deadLetterSecret', 'type': 'str'},
        'dead_letter_uri': {'key': 'deadLetterUri', 'type': 'str'},
        'topic_endpoint': {'key': 'TopicEndpoint', 'type': 'str'},
        'access_key1': {'key': 'accessKey1', 'type': 'str'},
        'access_key2': {'key': 'accessKey2', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        topic_endpoint: str,
        access_key1: str,
        authentication_type: Optional[Union[str, "AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        access_key2: Optional[str] = None,
        **kwargs
    ):
        super(EventGrid, self).__init__(authentication_type=authentication_type, dead_letter_secret=dead_letter_secret, dead_letter_uri=dead_letter_uri, **kwargs)
        self.endpoint_type = 'EventGrid'  # type: str
        self.topic_endpoint = topic_endpoint
        self.access_key1 = access_key1
        self.access_key2 = access_key2


class EventHub(DigitalTwinsEndpointResourceProperties):
    """Properties related to EventHub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. The type of Digital Twins endpoint.Constant filled by server.
     Possible values include: "EventHub", "EventGrid", "ServiceBus".
    :type endpoint_type: str or ~azure.mgmt.digitaltwins.models.EndpointType
    :ivar provisioning_state: The provisioning state. Possible values include: "Provisioning",
     "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     "Moving", "Disabled".
    :vartype provisioning_state: str or ~azure.mgmt.digitaltwins.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :param authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Possible values include: "KeyBased", "IdentityBased".
    :type authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
    :param dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :type dead_letter_secret: str
    :param dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :type dead_letter_uri: str
    :param connection_string_primary_key: PrimaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :type connection_string_primary_key: str
    :param connection_string_secondary_key: SecondaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :type connection_string_secondary_key: str
    :param endpoint_uri: The URL of the EventHub namespace for identity-based authentication. It
     must include the protocol sb://.
    :type endpoint_uri: str
    :param entity_path: The EventHub name in the EventHub namespace for identity-based
     authentication.
    :type entity_path: str
    """

    _validation = {
        'endpoint_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'dead_letter_secret': {'key': 'deadLetterSecret', 'type': 'str'},
        'dead_letter_uri': {'key': 'deadLetterUri', 'type': 'str'},
        'connection_string_primary_key': {'key': 'connectionStringPrimaryKey', 'type': 'str'},
        'connection_string_secondary_key': {'key': 'connectionStringSecondaryKey', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'entity_path': {'key': 'entityPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authentication_type: Optional[Union[str, "AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        connection_string_primary_key: Optional[str] = None,
        connection_string_secondary_key: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        entity_path: Optional[str] = None,
        **kwargs
    ):
        super(EventHub, self).__init__(authentication_type=authentication_type, dead_letter_secret=dead_letter_secret, dead_letter_uri=dead_letter_uri, **kwargs)
        self.endpoint_type = 'EventHub'  # type: str
        self.connection_string_primary_key = connection_string_primary_key
        self.connection_string_secondary_key = connection_string_secondary_key
        self.endpoint_uri = endpoint_uri
        self.entity_path = entity_path


class GroupIdInformation(msrest.serialization.Model):
    """The group information for creating a private endpoint on Digital Twin.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. The properties for a group information object.
    :type properties: ~azure.mgmt.digitaltwins.models.GroupIdInformationProperties
    :param id: The resource identifier.
    :type id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'properties': {'required': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'GroupIdInformationProperties'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        properties: "GroupIdInformationProperties",
        id: Optional[str] = None,
        **kwargs
    ):
        super(GroupIdInformation, self).__init__(**kwargs)
        self.properties = properties
        self.id = id
        self.name = None
        self.type = None


class GroupIdInformationProperties(msrest.serialization.Model):
    """The properties for a group information object.

    :param group_id: The group id.
    :type group_id: str
    :param required_members: The required members for a specific group id.
    :type required_members: list[str]
    :param required_zone_names: The required DNS zones for a specific group id.
    :type required_zone_names: list[str]
    """

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(GroupIdInformationProperties, self).__init__(**kwargs)
        self.group_id = group_id
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class GroupIdInformationPropertiesAutoGenerated(GroupIdInformationProperties):
    """GroupIdInformationPropertiesAutoGenerated.

    :param group_id: The group id.
    :type group_id: str
    :param required_members: The required members for a specific group id.
    :type required_members: list[str]
    :param required_zone_names: The required DNS zones for a specific group id.
    :type required_zone_names: list[str]
    """

    _attribute_map = {
        'group_id': {'key': 'groupId', 'type': 'str'},
        'required_members': {'key': 'requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        group_id: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(GroupIdInformationPropertiesAutoGenerated, self).__init__(group_id=group_id, required_members=required_members, required_zone_names=required_zone_names, **kwargs)


class GroupIdInformationResponse(msrest.serialization.Model):
    """The available private link resources for a Digital Twin.

    :param value: The list of available private link resources for a Digital Twin.
    :type value: list[~azure.mgmt.digitaltwins.models.GroupIdInformation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GroupIdInformation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["GroupIdInformation"]] = None,
        **kwargs
    ):
        super(GroupIdInformationResponse, self).__init__(**kwargs)
        self.value = value


class Operation(msrest.serialization.Model):
    """DigitalTwins service REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{read | write | action | delete}.
    :vartype name: str
    :param display: Operation properties display.
    :type display: ~azure.mgmt.digitaltwins.models.OperationDisplay
    :ivar origin: The intended executor of the operation.
    :vartype origin: str
    :ivar is_data_action: If the operation is a data action (for data plane rbac).
    :vartype is_data_action: bool
    """

    _validation = {
        'name': {'readonly': True},
        'origin': {'readonly': True},
        'is_data_action': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = display
        self.origin = None
        self.is_data_action = None


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft DigitalTwins.
    :vartype provider: str
    :ivar resource: Resource Type: DigitalTwinsInstances.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Friendly description for the operation,.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of DigitalTwins service operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param next_link: The link used to get the next page of DigitalTwins description objects.
    :type next_link: str
    :ivar value: A list of DigitalTwins operations supported by the Microsoft.DigitalTwins resource
     provider.
    :vartype value: list[~azure.mgmt.digitaltwins.models.Operation]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = None


class PrivateEndpointConnection(msrest.serialization.Model):
    """The private endpoint connection of a Digital Twin.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :param properties: Required. The properties of a private endpoint connection.
    :type properties: ~azure.mgmt.digitaltwins.models.ConnectionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ConnectionProperties'},
    }

    def __init__(
        self,
        *,
        properties: "ConnectionProperties",
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class PrivateEndpointConnectionProperties(ConnectionProperties):
    """PrivateEndpointConnectionProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state. Possible values include: "Pending",
     "Approved", "Rejected", "Disconnected".
    :vartype provisioning_state: str or
     ~azure.mgmt.digitaltwins.models.ConnectionPropertiesProvisioningState
    :param private_endpoint: The private endpoint property of a private endpoint connection.
    :type private_endpoint: ~azure.mgmt.digitaltwins.models.PrivateEndpoint
    :param group_ids: The list of group ids for the private endpoint connection.
    :type group_ids: list[str]
    :param private_link_service_connection_state: The current state of a private endpoint
     connection.
    :type private_link_service_connection_state: ~azure.mgmt.digitaltwins.models.ConnectionState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'private_endpoint': {'key': 'privateEndpoint', 'type': 'PrivateEndpoint'},
        'group_ids': {'key': 'groupIds', 'type': '[str]'},
        'private_link_service_connection_state': {'key': 'privateLinkServiceConnectionState', 'type': 'ConnectionState'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        group_ids: Optional[List[str]] = None,
        private_link_service_connection_state: Optional["ConnectionState"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionProperties, self).__init__(private_endpoint=private_endpoint, group_ids=group_ids, private_link_service_connection_state=private_link_service_connection_state, **kwargs)


class PrivateEndpointConnectionsResponse(msrest.serialization.Model):
    """The available private link connections for a Digital Twin.

    :param value: The list of available private link connections for a Digital Twin.
    :type value: list[~azure.mgmt.digitaltwins.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionsResponse, self).__init__(**kwargs)
        self.value = value


class ServiceBus(DigitalTwinsEndpointResourceProperties):
    """Properties related to ServiceBus.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. The type of Digital Twins endpoint.Constant filled by server.
     Possible values include: "EventHub", "EventGrid", "ServiceBus".
    :type endpoint_type: str or ~azure.mgmt.digitaltwins.models.EndpointType
    :ivar provisioning_state: The provisioning state. Possible values include: "Provisioning",
     "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", "Warning", "Suspending", "Restoring",
     "Moving", "Disabled".
    :vartype provisioning_state: str or ~azure.mgmt.digitaltwins.models.EndpointProvisioningState
    :ivar created_time: Time when the Endpoint was added to DigitalTwinsInstance.
    :vartype created_time: ~datetime.datetime
    :param authentication_type: Specifies the authentication type being used for connecting to the
     endpoint. Possible values include: "KeyBased", "IdentityBased".
    :type authentication_type: str or ~azure.mgmt.digitaltwins.models.AuthenticationType
    :param dead_letter_secret: Dead letter storage secret for key-based authentication. Will be
     obfuscated during read.
    :type dead_letter_secret: str
    :param dead_letter_uri: Dead letter storage URL for identity-based authentication.
    :type dead_letter_uri: str
    :param primary_connection_string: PrimaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :type primary_connection_string: str
    :param secondary_connection_string: SecondaryConnectionString of the endpoint for key-based
     authentication. Will be obfuscated during read.
    :type secondary_connection_string: str
    :param endpoint_uri: The URL of the ServiceBus namespace for identity-based authentication. It
     must include the protocol sb://.
    :type endpoint_uri: str
    :param entity_path: The ServiceBus Topic name for identity-based authentication.
    :type entity_path: str
    """

    _validation = {
        'endpoint_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_time': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'authentication_type': {'key': 'authenticationType', 'type': 'str'},
        'dead_letter_secret': {'key': 'deadLetterSecret', 'type': 'str'},
        'dead_letter_uri': {'key': 'deadLetterUri', 'type': 'str'},
        'primary_connection_string': {'key': 'primaryConnectionString', 'type': 'str'},
        'secondary_connection_string': {'key': 'secondaryConnectionString', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
        'entity_path': {'key': 'entityPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        authentication_type: Optional[Union[str, "AuthenticationType"]] = None,
        dead_letter_secret: Optional[str] = None,
        dead_letter_uri: Optional[str] = None,
        primary_connection_string: Optional[str] = None,
        secondary_connection_string: Optional[str] = None,
        endpoint_uri: Optional[str] = None,
        entity_path: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBus, self).__init__(authentication_type=authentication_type, dead_letter_secret=dead_letter_secret, dead_letter_uri=dead_letter_uri, **kwargs)
        self.endpoint_type = 'ServiceBus'  # type: str
        self.primary_connection_string = primary_connection_string
        self.secondary_connection_string = secondary_connection_string
        self.endpoint_uri = endpoint_uri
        self.entity_path = entity_path
