# -*- coding: utf-8 -*-
from 臺灣言語工具.解析整理.拆文分析器 import 拆文分析器
from 臺灣言語工具.基本物件.句 import 句
from 臺灣言語工具.基本物件.章 import 章
from 臺灣言語工具.解析整理.字物件篩仔 import 字物件篩仔
from 臺灣言語工具.基本物件.組 import 組
from 臺灣言語工具.基本物件.詞 import 詞


class 斷詞斷字翻譯:

    def __init__(self, 斷詞用戶端, 斷字用戶端):
        self.斷詞用戶端 = 斷詞用戶端
        self.斷字用戶端 = 斷字用戶端

    def 翻譯(self, 物件):
        return self.翻譯分析(物件)[0]

    def 翻譯分析(self, 物件):
        if isinstance(物件, 章):
            return self._翻譯章物件(物件)
        return self._翻譯句物件(物件)

    def _翻譯章物件(self, 來源章物件):
        '''直接選翻上好的，免逐句生幾仔句'''
        結果章物件 = 拆文分析器.建立章物件('')
        來源新結構章物件 = 拆文分析器.建立章物件('')
        總分 = 0
        for 來源句物件 in 來源章物件.內底句:
            結果句物件, 來源新結構句物件, 分數 = self._翻譯句物件(來源句物件)
            結果章物件.內底句.append(結果句物件)
            來源新結構章物件.內底句.append(來源新結構句物件)
            總分 += 分數
        return 結果章物件, 來源新結構章物件, 總分

    def _翻譯句物件(self, 句物件):
        斷詞結果句物件, 斷詞來源新結構句物件, 斷詞分數 = self.斷詞用戶端.翻譯分析(句物件)
        結果句物件, 來源新結構句物件, 斷字分數 = \
            self._整理斷詞翻譯的結果(斷詞結果句物件, 斷詞來源新結構句物件)
        return 結果句物件, 來源新結構句物件, 斷詞分數 + 斷字分數

    def _整理斷詞翻譯的結果(self, 斷詞結果句物件, 斷詞來源新結構句物件):
        結果句物件 = 句()
        來源新結構句物件 = 句()
        斷字全部分數 = 0
        未知詞組物件陣列 = []
        for 斷詞結果集物件, 斷詞來源集物件 in zip(斷詞結果句物件.內底集, 斷詞來源新結構句物件.內底集):
            if self._是未知詞無(斷詞結果集物件.內底組[0]):
                未知詞組物件陣列.append(斷詞結果集物件.內底組[0])
            else:
                if len(未知詞組物件陣列) > 0:
                    部份斷字結果句物件, 部份斷字來源新結構句物件, 部份斷字分數 = \
                        self._斷字翻譯做伙的未知詞組物件(未知詞組物件陣列)
                    結果句物件.內底集.extend(部份斷字結果句物件.內底集)
                    來源新結構句物件.內底集.extend(部份斷字來源新結構句物件.內底集)
                    斷字全部分數 += 部份斷字分數
                    未知詞組物件陣列.clear()

                結果句物件.內底集.append(斷詞結果集物件)
                來源新結構句物件.內底集.append(斷詞來源集物件)

        if len(未知詞組物件陣列) > 0:
            部份斷字結果句物件, 部份斷字來源新結構句物件, 部份斷字分數 = \
                self._斷字翻譯做伙的未知詞組物件(未知詞組物件陣列)
            結果句物件.內底集.extend(部份斷字結果句物件.內底集)
            來源新結構句物件.內底集.extend(部份斷字來源新結構句物件.內底集)
            斷字全部分數 += 部份斷字分數

        return 結果句物件, 來源新結構句物件, 斷字全部分數

    def _是未知詞無(self, 組物件):
        if 組物件.屬性['未知詞']:
            return True

    def _斷字翻譯做伙的未知詞組物件(self, 未知詞組物件陣列):
        字陣列 = []
        for 未知詞組物件 in 未知詞組物件陣列:
            字陣列.extend(
                字物件篩仔.篩出字物件(未知詞組物件)
            )
        組物件 = 組()
        for 字物件 in 字陣列:
            詞物件 = 詞()
            詞物件.內底字 = [字物件]
            組物件.內底詞.append(詞物件)
        結果句物件, 來源新結構句物件, 分數 = self.斷字用戶端.翻譯分析(組物件)
        self._斷字結果句物件集內底攏當做一詞(結果句物件)
        self._斷字結果句物件集內底攏當做一詞(來源新結構句物件)

        self._合未知的詞(未知詞組物件陣列, 來源新結構句物件, 結果句物件)
        return 結果句物件, 來源新結構句物件, 分數

    def _合未知的詞(self, 未知詞組物件陣列, 來源新結構句物件, 結果句物件):
        集陣列指標 = 來源新結構句物件.內底集.__iter__()
        組陣列字數 = 0
        來源新結構字數 = 0
        來源新結構全部集陣列 = []
        for 組物件 in 未知詞組物件陣列:
            組陣列字數 += len(字物件篩仔.篩出字物件(組物件))
            來源新結構部份集陣列 = []
            是未知詞 = False
            while 來源新結構字數 < 組陣列字數:
                來源新結構字數集物件 = 集陣列指標.__next__()
                來源新結構部份集陣列.append(來源新結構字數集物件)
                來源新結構字數 += len(字物件篩仔.篩出字物件(來源新結構字數集物件))
                if self._是未知詞無(來源新結構字數集物件.內底組[0].翻譯目標組物件):
                    是未知詞 = True
            if 是未知詞:
                self._集陣列內底的字攏下佇頭一个集物件的詞物件(來源新結構部份集陣列)
                來源新結構全部集陣列.append(來源新結構部份集陣列[0])
                for 來源新結構部份集物件 in 來源新結構部份集陣列:
                    來源新結構部份集物件.內底組[0].翻譯目標組物件.屬性['未知詞組'] =\
                        來源新結構部份集陣列
            else:
                來源新結構全部集陣列.extend(來源新結構部份集陣列)
        來源新結構句物件.內底集 = 來源新結構全部集陣列

        結果全部集陣列 = []
        結果部份集陣列 = []
        for 結果集物件 in 結果句物件.內底集:
            if '未知詞組' in 結果集物件.內底組[0].屬性 and (
                    len(結果部份集陣列) == 0 or
                    結果集物件.內底組[0].屬性['未知詞組'] == 結果部份集陣列[-1].內底組[0].屬性['未知詞組']
            ):
                結果部份集陣列.append(結果集物件)
            elif '未知詞組' in 結果集物件.內底組[0].屬性:
                self._集陣列內底的字攏下佇頭一个集物件的詞物件(結果部份集陣列)
                結果全部集陣列.append(結果部份集陣列[0])
                結果部份集陣列 = [結果集物件]
            elif len(結果部份集陣列) != 0:
                self._集陣列內底的字攏下佇頭一个集物件的詞物件(結果部份集陣列)
                結果全部集陣列.append(結果部份集陣列[0])
                結果全部集陣列.append(結果集物件)
            else:
                結果全部集陣列.append(結果集物件)

        if len(結果部份集陣列) != 0:
            self._集陣列內底的字攏下佇頭一个集物件的詞物件(結果部份集陣列)
            結果全部集陣列.append(結果部份集陣列[0])

        結果句物件.內底集 = 結果全部集陣列

        return

    def _集陣列內底的字攏下佇頭一个集物件的詞物件(self, 集陣列):
        暫時句物件 = 句()
        暫時句物件.內底集 = 集陣列
        暫時詞物件 = 詞()
        暫時詞物件.內底字 = 字物件篩仔.篩出字物件(暫時句物件)
        頭前集物件 = 集陣列[0]
        頭前集物件.內底組[0].內底詞 = [暫時詞物件]

    def _斷字結果句物件集內底攏當做一詞(self, 句物件):
        for 集物件 in 句物件.內底集:
            詞物件 = 詞()
            詞物件.內底字 = 字物件篩仔.篩出字物件(集物件)
            集物件.內底組[0].內底詞 = [詞物件]
        return
