#!/usr/bin/env python3
"""
A toolkit to help metallurgical process engineers to rapidly do day-to-day
calculations.

auxi is a toolkit to help metallurgical process engineers with their day-to-day
tasks. Many of the calculations that we do require things like molar masses,
conversion of one compound to another using stoichiometry, heat transfer
calculations, mass balances, energy balances, etc. It is usually quite time
consuming to get started with these calculations in a tool like Excel. auxi
aims to save you time by making many of these calculations available from
within python.

We hope that auxi will help you spend less time focusing on searching for
formulas and data, and setting up calculations, and more on thinking about the
problems that you need to solve with these calculations. Enjoy!

If you need more information about how to use auxi, please refer the
documentation at https://auxi.readthedocs.org/en/latest/.
"""


__version__ = '0.3.2'
__license__ = 'LGPL v3'
__copyright__ = 'Copyright 2016, Ex Mente Technologies (Pty) Ltd'
__author__ = 'Christoff Kok, Johan Zietsman'
__credits__ = ['Christoff Kok', 'Johan Zietsman']
__maintainer__ = 'Christoff Kok'
__email__ = 'christoff.kok@ex-mente.co.za'
__status__ = 'Planning'


#COMMON ISSUES
#TODO: Make sure that you update version numbers to include release candidate
#      numbers when releasing.
#TODO: Make sure that you stick to the 80 character column limit.
#TODO: Use standard docstring layout. Triple quotation marks on own lines.
#TODO: Use proper grammar and spelling in all comments and documentation.
#TODO: Add the following as first line to all code files and test:
#      #!/usr/bin/env python3
#TODO: Add authorship information according to:
#      http://stackoverflow.com/questions/1523427/what-is-the-common-header-format-of-python-files
#TODO: Remove '# -*- coding: utf-8 -*-' from top of code files.
#TODO: When running code file, run corresponding unit tests.
#TODO: Use three regions of imports: builtin, third party and own.
#TODO: Explictly state the purpose of each unit test in a docstring.
