(function() {
  require(["common/base", "mapper/categorical_mapper", "range/range1d", "range/factor_range"], function(base, CategoricalMapper, Range1d, FactorRange) {
    test('categorical_mapper_factor_range1d', function() {
      var mapper;
      mapper = new CategoricalMapper.Model({
        source_range: new FactorRange.Model({
          'factors': ['foo', 'bar', 'baz']
        }),
        target_range: new Range1d.Model({
          'start': 20,
          'end': 80
        })
      });
      equal(mapper.map_to_target('foo'), 30);
      equal(mapper.map_to_target('bar'), 50);
      equal(mapper.map_to_target('baz'), 70);
      deepEqual(mapper.v_map_to_target(['foo', 'bar', 'baz']), [30, 50, 70]);
      equal(mapper.map_from_target(21), 'foo');
      equal(mapper.map_from_target(30), 'foo');
      equal(mapper.map_from_target(39), 'foo');
      equal(mapper.map_from_target(41), 'bar');
      equal(mapper.map_from_target(50), 'bar');
      equal(mapper.map_from_target(59), 'bar');
      equal(mapper.map_from_target(61), 'baz');
      equal(mapper.map_from_target(70), 'baz');
      equal(mapper.map_from_target(79), 'baz');
      return deepEqual(mapper.v_map_from_target([21, 30, 39, 41, 50, 59, 61, 70, 79]), ['foo', 'foo', 'foo', 'bar', 'bar', 'bar', 'baz', 'baz', 'baz']);
    });
    test('categorical_mapper_factor_range1d_update_source', function() {
      var mapper;
      mapper = new CategoricalMapper.Model({
        source_range: new FactorRange.Model({
          'factors': ['foo', 'bar', 'baz']
        }),
        target_range: new Range1d.Model({
          'start': 20,
          'end': 80
        })
      });
      mapper.get('source_range').set('factors', ['a', 'b', 'c', 'd']);
      equal(mapper.map_to_target('a'), 27.5);
      equal(mapper.map_to_target('b'), 42.5);
      equal(mapper.map_to_target('c'), 57.5);
      equal(mapper.map_to_target('d'), 72.5);
      deepEqual(mapper.v_map_to_target(['a', 'b', 'c', 'd']), [27.5, 42.5, 57.5, 72.5]);
      equal(mapper.map_from_target(25), 'a');
      equal(mapper.map_from_target(27.5), 'a');
      equal(mapper.map_from_target(30), 'a');
      equal(mapper.map_from_target(40), 'b');
      equal(mapper.map_from_target(42.5), 'b');
      equal(mapper.map_from_target(45), 'b');
      equal(mapper.map_from_target(55), 'c');
      equal(mapper.map_from_target(57.5), 'c');
      equal(mapper.map_from_target(60), 'c');
      equal(mapper.map_from_target(70), 'd');
      equal(mapper.map_from_target(72.5), 'd');
      equal(mapper.map_from_target(75), 'd');
      return deepEqual(mapper.v_map_from_target([25, 27.5, 30, 40, 42.5, 45, 55, 57.5, 60, 70, 72.5, 75]), ['a', 'a', 'a', 'b', 'b', 'b', 'c', 'c', 'c', 'd', 'd', 'd']);
    });
    return test('categorical_mapper_percentage_coordinates', function() {
      var mapper;
      mapper = new CategoricalMapper.Model({
        source_range: new FactorRange.Model({
          'factors': ['foo', 'bar', 'baz']
        }),
        target_range: new Range1d.Model({
          'start': 20,
          'end': 80
        })
      });
      equal(mapper.map_to_target('foo:0.1'), 22);
      equal(mapper.map_to_target('foo:0.5'), 30);
      equal(mapper.map_to_target('foo:0.9'), 38);
      equal(mapper.map_to_target('bar:0.2'), 44);
      equal(mapper.map_to_target('bar:0.4'), 48);
      equal(mapper.map_to_target('bar:0.6'), 52);
      equal(mapper.map_to_target('bar:0.8'), 56);
      equal(mapper.map_to_target('baz:0.3'), 66);
      equal(mapper.map_to_target('baz:0.7'), 74);
      deepEqual(mapper.v_map_to_target(['foo:0.1', 'foo:0.5', 'foo:0.9']), [22, 30, 38]);
      deepEqual(mapper.v_map_to_target(['bar:0.2', 'bar:0.4', 'bar:0.6', 'bar:0.8']), [44, 48, 52, 56]);
      return deepEqual(mapper.v_map_to_target(['baz:0.3', 'baz:0.7']), [66, 74]);
    });
  });

}).call(this);

/*
//@ sourceMappingURL=categorical_mapper_test.js.map
*/