/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scripting;

import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.core.properties.PASharedProperties;
import org.ow2.proactive.http.CommonHttpResourceDownloader;
import org.ow2.proactive.scripting.InvalidScriptException;
import org.ow2.proactive.scripting.ScriptException;
import org.ow2.proactive.scripting.ScriptResult;
import org.ow2.proactive.utils.BoundedStringWriter;
import org.ow2.proactive.utils.FileUtils;

@PublicAPI
public abstract class Script<E>
implements Serializable {
    public static final int DEFAULT_OUTPUT_MAX_SIZE = 0x100000;
    public static final Logger logger = Logger.getLogger(Script.class);
    public static final String ARGUMENTS_NAME = "args";
    public static final String MD5 = "MD5";
    protected String scriptEngineLookupName;
    protected String script;
    protected URL url;
    protected String id;
    protected Serializable[] parameters;
    private String scriptName;
    private static Boolean lazyFetch = null;
    private static final long serialVersionUID = 120L;

    public Script() {
    }

    public Script(String script, String engineName, Serializable[] parameters) throws InvalidScriptException {
        this.scriptEngineLookupName = engineName;
        this.script = script;
        this.id = script;
        this.parameters = parameters;
        this.scriptName = this.getDefaultScriptName();
    }

    protected abstract String getDefaultScriptName();

    public Script(String script, String engineName, Serializable[] parameters, String scriptName) throws InvalidScriptException {
        this.scriptEngineLookupName = engineName;
        this.script = script;
        this.id = script;
        this.parameters = parameters;
        this.scriptName = scriptName;
    }

    public Script(String script, String engineName) throws InvalidScriptException {
        this(script, engineName, (Serializable[])null);
    }

    public Script(String script, String engineName, String scriptName) throws InvalidScriptException {
        this(script, engineName, null, scriptName);
    }

    public Script(File file, Serializable[] parameters) throws InvalidScriptException {
        this.scriptEngineLookupName = FileUtils.getExtension(file.getPath());
        try {
            this.script = Script.readFile(file);
        }
        catch (IOException e) {
            throw new InvalidScriptException("Unable to read script : " + file.getAbsolutePath(), e);
        }
        this.id = file.getPath();
        this.parameters = parameters;
        this.scriptName = file.getName();
    }

    public Script(File file) throws InvalidScriptException {
        this(file, null);
    }

    public Script(URL url, Serializable[] parameters, boolean fetchImmediately) throws InvalidScriptException {
        this(url, null, parameters, fetchImmediately);
    }

    public Script(URL url, String engineName, Serializable[] parameters, boolean fetchImmediately) throws InvalidScriptException {
        this.url = url;
        this.id = url.toExternalForm();
        this.scriptEngineLookupName = engineName;
        this.parameters = parameters;
        this.scriptName = url.getPath();
        if (fetchImmediately) {
            try {
                this.fetchUrlIfNeeded();
            }
            catch (IOException e) {
                throw new InvalidScriptException(e);
            }
        }
    }

    public Script(URL url, boolean fetchImmediately) throws InvalidScriptException {
        this(url, (String)null, fetchImmediately);
    }

    public Script(URL url, String engineName, boolean fetchImmediately) throws InvalidScriptException {
        this(url, engineName, null, fetchImmediately);
    }

    public Script(Script<?> script2) throws InvalidScriptException {
        this(script2.getScript(), script2.scriptEngineLookupName, script2.getParameters(), script2.getScriptName());
        this.url = script2.url;
        this.id = script2.id;
    }

    public Script(Script<?> script2, String scriptName) throws InvalidScriptException {
        this(script2.script, script2.scriptEngineLookupName, script2.parameters, scriptName);
        this.url = script2.url;
        this.id = script2.id;
    }

    protected static boolean isLazyFetch() {
        if (lazyFetch == null) {
            try {
                lazyFetch = PASharedProperties.LAZY_FETCH_SCRIPT.getValueAsBoolean();
            }
            catch (Exception e) {
                logger.warn((Object)("Incorrect value of " + PASharedProperties.LAZY_FETCH_SCRIPT.getKey() + ", default value will be used."), (Throwable)e);
                lazyFetch = true;
            }
        }
        return lazyFetch;
    }

    public String getScript() {
        return this.script;
    }

    public String fetchScript() {
        if (this.script == null && this.url != null) {
            ScriptContentAndEngineName fetchedInformation = null;
            try {
                fetchedInformation = this.getScriptContentAndEngineName();
                return fetchedInformation.getScriptContent();
            }
            catch (Exception e) {
                logger.trace((Object)("Could not fetch script at " + this.url), (Throwable)e);
                return null;
            }
        }
        return this.script;
    }

    public String fetchScriptWithExceptionHandling() throws IOException {
        if (this.script == null && this.url != null) {
            ScriptContentAndEngineName fetchedInformation = null;
            fetchedInformation = this.getScriptContentAndEngineName();
            return fetchedInformation.getScriptContent();
        }
        return this.script;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public URL getScriptUrl() {
        return this.url;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public Serializable[] getParameters() {
        return this.parameters;
    }

    public ScriptResult<E> execute() {
        return this.execute(null, System.out, System.err);
    }

    public ScriptResult<E> execute(Map<String, Object> aBindings, PrintStream outputSink, PrintStream errorSink) {
        try {
            this.fetchUrlIfNeeded();
        }
        catch (Throwable t) {
            logger.error((Object)"Script could not be fetched", t);
            String stack = Throwables.getStackTraceAsString((Throwable)t);
            if (t.getMessage() != null) {
                stack = t.getMessage() + System.lineSeparator() + stack;
            }
            return new ScriptResult(new Exception(stack));
        }
        ScriptEngine engine = this.createScriptEngine();
        if (engine == null) {
            return new ScriptResult(new Exception("No Script Engine Found for name or extension " + this.scriptEngineLookupName));
        }
        BoundedStringWriter outputBoundedWriter = new BoundedStringWriter(outputSink, 0x100000);
        BoundedStringWriter errorBoundedWriter = new BoundedStringWriter(errorSink, 0x100000);
        StringBuilder outputBuffer = new StringBuilder();
        outputBoundedWriter.setContentBuffer(outputBuffer);
        errorBoundedWriter.setContentBuffer(outputBuffer);
        engine.getContext().setWriter(new PrintWriter((Writer)outputBoundedWriter, true));
        engine.getContext().setErrorWriter(new PrintWriter((Writer)errorBoundedWriter, true));
        Reader closedInput = new Reader(){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                throw new IOException("closed");
            }

            @Override
            public void close() throws IOException {
            }
        };
        engine.getContext().setReader(closedInput);
        engine.getContext().setAttribute("javax.script.filename", this.scriptName, 100);
        try {
            Bindings bindings = engine.getBindings(100);
            if (aBindings != null) {
                for (Map.Entry<String, Object> e : aBindings.entrySet()) {
                    bindings.put(e.getKey(), e.getValue());
                }
            }
            this.prepareBindings(bindings);
            Object evalResult = engine.eval(this.getReader());
            ScriptResult<E> result = this.getResult(evalResult, bindings);
            this.captureOutput(engine, outputBuffer, result);
            return result;
        }
        catch (javax.script.ScriptException e) {
            String stack = Throwables.getStackTraceAsString((Throwable)e);
            if (e.getMessage() != null) {
                stack = e.getMessage() + System.lineSeparator() + stack;
            }
            ScriptResult result = new ScriptResult(new ScriptException(stack));
            this.captureOutput(engine, outputBuffer, result);
            return result;
        }
        catch (Throwable t) {
            String stack = Throwables.getStackTraceAsString((Throwable)t);
            if (t.getMessage() != null) {
                stack = t.getMessage() + System.lineSeparator() + stack;
            }
            ScriptResult result = new ScriptResult(new ScriptException(stack));
            this.captureOutput(engine, outputBuffer, result);
            return result;
        }
    }

    private void captureOutput(ScriptEngine engine, StringBuilder outputBuffer, ScriptResult<E> result) {
        try {
            engine.getContext().getErrorWriter().flush();
            engine.getContext().getWriter().flush();
        }
        catch (IOException e) {
            logger.warn((Object)"Could not flush the end of the script execution output");
        }
        result.setOutput(outputBuffer.toString());
    }

    protected void fetchUrlIfNeeded() throws IOException {
        if (this.script == null && this.url != null) {
            ScriptContentAndEngineName fetchedInformation = this.getScriptContentAndEngineName();
            this.script = fetchedInformation.getScriptContent();
            this.scriptEngineLookupName = fetchedInformation.getEngineName();
            if (this.scriptEngineLookupName == null) {
                throw new IllegalStateException("Could not determine script engine for script " + this.url);
            }
        }
    }

    private ScriptContentAndEngineName getScriptContentAndEngineName() throws IOException {
        ScriptContentAndEngineName fetchedInformation = this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https") ? this.fetchScriptUsingHttpDownloader(this.url) : this.fetchScriptUsingOpenStream(this.url);
        return fetchedInformation;
    }

    private ScriptContentAndEngineName fetchScriptUsingHttpDownloader(URL url) throws IOException {
        CommonHttpResourceDownloader.UrlContent content = CommonHttpResourceDownloader.getInstance().getResourceContent(null, url.toExternalForm(), true);
        String scriptContent = content.getContent();
        String engineName = this.scriptEngineLookupName;
        if (content.getFileName() != null && this.scriptEngineLookupName == null) {
            engineName = FileUtils.getExtension(content.getFileName());
        }
        return new ScriptContentAndEngineName(scriptContent, engineName);
    }

    private ScriptContentAndEngineName fetchScriptUsingOpenStream(URL url) throws IOException {
        String scriptContent = null;
        String engineName = this.scriptEngineLookupName;
        try (BufferedReader buf = new BufferedReader(new InputStreamReader(url.openStream()));){
            String tmp;
            StringBuilder builder = new StringBuilder();
            while ((tmp = buf.readLine()) != null) {
                builder.append(tmp).append("\n");
            }
            scriptContent = builder.toString();
        }
        if (this.scriptEngineLookupName == null) {
            engineName = FileUtils.getExtension(FileUtils.getFileNameWithExtension(url));
        }
        return new ScriptContentAndEngineName(scriptContent, engineName);
    }

    public String getId() {
        return this.id;
    }

    protected Reader getReader() {
        return new StringReader(this.script);
    }

    protected ScriptEngine createScriptEngine() {
        boolean findByName = true;
        Map<ScriptEngine, Integer> scriptEngineCandidates = this.findScriptEngineCandidates(true);
        if (scriptEngineCandidates.isEmpty()) {
            scriptEngineCandidates = this.findScriptEngineCandidates(false);
        }
        return this.findBestScriptEngine(scriptEngineCandidates);
    }

    private Map<ScriptEngine, Integer> findScriptEngineCandidates(boolean findByName) {
        HashMap<ScriptEngine, Integer> matchPositionPerScriptEngineCandidate = new HashMap<ScriptEngine, Integer>();
        for (ScriptEngineFactory factory : new ScriptEngineManager().getEngineFactories()) {
            int matchPosition = 0;
            List<String> lookupCriteria = findByName ? factory.getNames() : factory.getExtensions();
            for (String criteria : lookupCriteria) {
                if (criteria.equalsIgnoreCase(this.scriptEngineLookupName)) {
                    matchPositionPerScriptEngineCandidate.put(factory.getScriptEngine(), matchPosition);
                }
                ++matchPosition;
            }
        }
        return matchPositionPerScriptEngineCandidate;
    }

    private ScriptEngine findBestScriptEngine(Map<ScriptEngine, Integer> scriptEngineCandidates) {
        int minimumMatchingIndex = Integer.MAX_VALUE;
        ScriptEngine bestScriptEngine = null;
        for (Map.Entry<ScriptEngine, Integer> candidate : scriptEngineCandidates.entrySet()) {
            if (candidate.getValue() >= minimumMatchingIndex) continue;
            minimumMatchingIndex = candidate.getValue();
            bestScriptEngine = candidate.getKey();
        }
        return bestScriptEngine;
    }

    protected abstract void prepareSpecialBindings(Bindings var1);

    protected abstract ScriptResult<E> getResult(Object var1, Bindings var2);

    protected final void prepareBindings(Bindings bindings) {
        if (this.parameters != null) {
            bindings.put(ARGUMENTS_NAME, (Object)this.parameters);
        }
        this.prepareSpecialBindings(bindings);
    }

    public static String readFile(File file) throws IOException {
        try (BufferedReader buf = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String tmp;
            StringBuilder builder = new StringBuilder();
            while ((tmp = buf.readLine()) != null) {
                builder.append(tmp).append("\n");
            }
            String string = builder.toString();
            return string;
        }
    }

    public String getEngineName() {
        return this.scriptEngineLookupName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Script)) {
            return false;
        }
        Script other = (Script)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public static String digest(String script) {
        try {
            return new String(MessageDigest.getInstance(MD5).digest(script.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)"No algorithm found, digest will use the script content", (Throwable)e);
            return script;
        }
    }

    public String toString() {
        return this.getScriptName();
    }

    public String display() {
        String nl = System.lineSeparator();
        return " { " + nl + "Script '" + this.getScriptName() + '\'' + nl + "\tscriptEngineLookupName = '" + this.scriptEngineLookupName + '\'' + nl + "\tscript = " + nl + this.script + nl + "\tid = " + nl + this.id + nl + "\tparameters = " + Arrays.toString(this.parameters) + nl + '}';
    }

    public void overrideDefaultScriptName(String defaultScriptName) {
        if (this.getScriptName().equals(this.getDefaultScriptName())) {
            this.scriptName = defaultScriptName;
        }
    }

    private static class ScriptContentAndEngineName {
        private final String scriptContent;
        private final String engineName;

        public ScriptContentAndEngineName(String scriptContent, String engineName) {
            this.scriptContent = scriptContent;
            this.engineName = engineName;
        }

        public String getScriptContent() {
            return this.scriptContent;
        }

        public String getEngineName() {
            return this.engineName;
        }
    }
}

