/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import java.util.Set;
import org.apache.log4j.Logger;
import org.ow2.proactive.scheduler.common.exception.NotConnectedException;
import org.ow2.proactive.scheduler.common.exception.PermissionException;
import org.ow2.proactive.scheduler.common.exception.SchedulerException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class CredentialValidator
implements Validator<String> {
    private static final Logger logger = Logger.getLogger(CredentialValidator.class);

    @Override
    public String validate(String parameterValue, ModelValidatorContext context) throws ValidationException {
        if (context == null || context.getScheduler() == null) {
            logger.debug((Object)String.format("Can't check the validity of the variable value, because missing the access to the scheduler third-party credentials", parameterValue));
            return parameterValue;
        }
        try {
            Set<String> credentialKeys = context.getScheduler().thirdPartyCredentialsKeySet();
            if (!credentialKeys.contains(parameterValue)) {
                throw new ValidationException(String.format("Could not find the key named [%s] in the third-party credentials. Please add it into the scheduler third-party credentials or change the variable value to a valid key.", parameterValue));
            }
        }
        catch (NotConnectedException | PermissionException e) {
            throw new ValidationException("Could not read third party-credentials from the scheduler, make sure you are connected and you have permission rights to read third-party credentials.", e);
        }
        catch (SchedulerException e) {
            logger.error((Object)e);
        }
        return parameterValue;
    }
}

