/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class CatalogObjectValidator
implements Validator<String> {
    public static final String CATALOG_OBJECT_MODEL_REGEXP = "^[^/]+/[^/]+(/[^/][0-9]{12})?$";

    @Override
    public String validate(String parameterValue, ModelValidatorContext context) throws ValidationException {
        Pattern pattern = Pattern.compile(CATALOG_OBJECT_MODEL_REGEXP);
        Matcher matcher = pattern.matcher(parameterValue);
        if (!parameterValue.matches(CATALOG_OBJECT_MODEL_REGEXP) || !matcher.find()) {
            throw new ValidationException("Expected value should match regular expression " + pattern.pattern() + " , received " + parameterValue);
        }
        return parameterValue;
    }
}

