// stasm_landmarks.h: define the Stasm landmarks for the 77 point model
//
// Copyright (C) 2005-2013, Stephen Milborrow

#ifndef STASM_STASM_LANDMARKS_H
#define STASM_STASM_LANDMARKS_H

// All landmark names begin with L_ followed by L, C, or R,
// for left, center, or right.
// Note that left and right are with respect to the viewer, not the subject.

enum stasm_LANDMARKS_77 // stasm77 landmarks
{
    L_LTemple,          // 00
    L_LJaw01,           // 01
    L_LJawNoseline,     // 02 nose line on left jaw
    L_LJawMouthline,    // 03 mouth line on left jaw
    L_LJaw04,           // 04
    L_LJaw05,           // 05
    L_CTipOfChin,       // 06
    L_RJaw07,           // 07
    L_RJaw08,           // 08
    L_RJawMouthline,    // 09
    L_RJawNoseline,     // 10
    L_RJaw11,           // 11
    L_RTemple,          // 12
    L_RForehead,        // 13
    L_CForehead,        // 14
    L_LForehead,        // 15
    L_LEyebrowTopInner, // 16
    L_LEyebrowTopOuter, // 17
    L_LEyebrowOuter,    // 18
    L_LEyebrowBotOuter, // 19
    L_LEyebrowBotInner, // 20
    L_LEyebrowInner,    // 21
    L_REyebrowInner,    // 22
    L_REyebrowTopInner, // 23
    L_REyebrowTopOuter, // 24
    L_REyebrowOuter,    // 25
    L_REyebrowBotOuter, // 26
    L_REyebrowBotInner, // 27
    L_REyelid,          // 28
    L_LEyelid,          // 29
    L_LEyeInner,        // 30
    L_LEye31,           // 31
    L_LEyeTop,          // 32
    L_LEye33,           // 33
    L_LEyeOuter,        // 34
    L_LEye35,           // 35
    L_LEyeBot,          // 36
    L_LEye37,           // 37
    L_LPupil,           // 38
    L_RPupil,           // 39
    L_REyeInner,        // 40
    L_REye41,           // 41
    L_REyeTop,          // 42
    L_REye43,           // 43
    L_REyeOuter,        // 44
    L_REye45,           // 45
    L_REyeBot,          // 46
    L_REye47,           // 47
    L_RNoseMid,         // 48
    L_CNoseMid,         // 49
    L_LNoseMid,         // 50
    L_LNostrilTop,      // 51
    L_CNoseTip,         // 52
    L_RNostrilTop,      // 53
    L_RNoseSide,        // 54
    L_RNostrilBot,      // 55
    L_CNoseBase,        // 56
    L_LNostrilBot,      // 57
    L_LNoseSide,        // 58
    L_LMouthCorner,     // 59
    L_LMouth60,         // 60
    L_LMouthCupid,      // 61
    L_CTopOfTopLip,     // 62
    L_RMouthCupid,      // 63
    L_RMouth64,         // 64
    L_RMouthCorner,     // 65
    L_RMouth66,         // 66
    L_CBotOfTopLip,     // 67
    L_LMouth68,         // 68
    L_LMouth69,         // 69
    L_CTopOfBotLip,     // 70
    L_RMouth71,         // 71
    L_RMouth72,         // 72
    L_RMouth73,         // 73
    L_CBotOfBotLip,     // 74
    L_LMouth75,         // 75
    L_LMouth76          // 76
};

#endif // STASM_STASM_LANDMARKS_H
