# -*- coding: utf-8 -*-
from 臺灣言語工具.語音合成.決策樹仔問題.公家決策樹仔 import 公家決策樹仔
from 臺灣言語工具.語音合成.生決策樹仔問題 import 生決策樹仔問題
import itertools
import os
from 臺灣言語工具.音標系統.Pangcah.原住民族語言書寫系統秀姑巒阿美語 import 書寫系統國際音標對應表


class 秀姑巒阿美語決策樹仔(公家決策樹仔):
    聲韻符號 = ('', '-', '+', '/調:')
    調符號 = ('/調:', '<', '>', '/詞:')
    詞符號 = ('/詞:', '!', '@', '/句:')
    句符號 = ('/句:', '^', '_', '')

    @classmethod
    def 生(cls, 輸出目的=open(os.devnull, 'w')):
        問題 = set()
        問題 |= cls.孤聲韻()
        print(len(問題), file=輸出目的)
        問題 |= cls.組合()
        print(len(問題), file=輸出目的)
        問題 |= cls.詞句長度(10, 20)
        print(len(問題), file=輸出目的)
        問題 |= cls.孤雙數音節()
        print(len(問題), file=輸出目的)

        生決策樹仔問題.檢查(問題)
        return 問題

    @classmethod
    def 孤聲韻(cls):
        聲韻 = []
        for 實際音 in itertools.chain(
                ['sil', 'sp'],
                書寫系統國際音標對應表.values(),
        ):
            聲韻.append(('{0}'.format(實際音), [實際音]))
        return 生決策樹仔問題.問題集(聲韻, cls.聲韻符號, '孤條')

    @classmethod
    def 組合(cls):
        仝元音題目 = [
            ('a音', ['a', 'aː', ]),
            ('i音', ['i', 'iː', ]),
            ('u音', ['u', 'uː', ]),
            ('o音', ['o', 'oː', ]),
            ('ə音', ['ə', 'əː', ]),
        ]
        長短元音題目 = [
            ('短音', ['a', 'i', 'u', 'o', 'ə', ]),
            ('長音', ['aː', 'iː', 'uː', 'oː', 'əː', ]),
        ]
        滑音題目 = [
            ('ji音', ['j', 'i', 'iː', ]),
            ('wu音', ['w', 'u', 'uː', ]),
        ]
        發音方法 = [
            ('鼻音', ['m', 'n', 'ŋ', ]),
            ('塞音', ['p', 't', 'k', 'ʡ', 'ʔ', ]),
            # ('塞擦音',['ts']),
            ('擦音', ['f', 'ɬ', 's', 'z', 'x', 'ħ', ]),
            ('閃顫音', ['ɾ', 'r', ]),
        ]
        發音所在 = [
            ('唇輔音', ['p', 'm', 'f']),
            ('舌尖輔音', ['t', 'n', 'ɬ', 'ɾ', 'r', 'ts', 's', 'z', ]),
            ('舌根輔音', ['k', 'ŋ', 'x', ]),
            ('咽喉音', ['ʡ', ]),
            ('喉輔音', ['ħ', 'ʔ', ]),
        ]
        return (
            生決策樹仔問題.問題集(仝元音題目, cls.聲韻符號, '孤條') |
            生決策樹仔問題.問題集(長短元音題目, cls.聲韻符號, '孤條') |
            生決策樹仔問題.問題集(滑音題目, cls.聲韻符號, '孤條') |
            生決策樹仔問題.問題集(發音方法, cls.聲韻符號, '孤條') |
            生決策樹仔問題.問題集(發音所在, cls.聲韻符號, '孤條')
        )
