#!/usr/bin/env bash

export CLI_SSH_PASS=$1
export CLUSTER_IP=$2
export SIMPLYBLOCK_DOCKER_IMAGE=$3

export GRAYLOG_ROOT_PASSWORD_SHA2=$4
export GRAYLOG_PASSWORD_SECRET="is6SP2EdWg0NdmVGv6CEp5hRHNL7BKVMFem4t9pouMqDQnHwXMSomas1qcbKSt5yISr8eBHv4Y7Dbswhyz84Ut0TW6kqsiPs"

export CLUSTER_SECRET=$5
export CLUSTER_ID=$6
export LOG_DELETION_INTERVAL=$7
export RETENTION_PERIOD=$8
export DIR="$(dirname "$(realpath "$0")")"

if [ -s "/etc/foundationdb/fdb.cluster" ]
then
   FDB_CLUSTER_FILE_CONTENTS=$(tail /etc/foundationdb/fdb.cluster -n 1)
   export FDB_CLUSTER_FILE_CONTENTS=$FDB_CLUSTER_FILE_CONTENTS
fi

if [[ "$RETENTION_PERIOD" == *d ]]; then
   export MAX_NUMBER_OF_INDICES=${RETENTION_PERIOD%d}
elif [[ "$RETENTION_PERIOD" == *h || "$RETENTION_PERIOD" == *m ]]; then
   export MAX_NUMBER_OF_INDICES=1
else
    echo "Invalid RETENTION_PERIOD format. Please use a value ending in 'd', 'h', or 'm'."
    exit 1
fi


docker network create monitoring-net -d overlay --attachable

docker stack deploy --compose-file="$DIR"/docker-compose-swarm-monitoring.yml monitoring

# wait for the services to become online
bash "$DIR"/stack_deploy_wait.sh monitoring

docker stack deploy --compose-file="$DIR"/docker-compose-swarm.yml app

# wait for the services to become online
bash "$DIR"/stack_deploy_wait.sh app
