# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AzureReachabilityReport(Model):
    """Azure reachability report details.

    :param aggregation_level: The aggregation level of Azure reachability
     report. Can be Country, State or City.
    :type aggregation_level: str
    :param provider_location:
    :type provider_location: :class:`AzureReachabilityReportLocation
     <azure.mgmt.network.v2017_09_01.models.AzureReachabilityReportLocation>`
    :param reachability_report: List of Azure reachability report items.
    :type reachability_report: list of :class:`AzureReachabilityReportItem
     <azure.mgmt.network.v2017_09_01.models.AzureReachabilityReportItem>`
    """

    _validation = {
        'aggregation_level': {'required': True},
        'provider_location': {'required': True},
        'reachability_report': {'required': True},
    }

    _attribute_map = {
        'aggregation_level': {'key': 'aggregationLevel', 'type': 'str'},
        'provider_location': {'key': 'providerLocation', 'type': 'AzureReachabilityReportLocation'},
        'reachability_report': {'key': 'reachabilityReport', 'type': '[AzureReachabilityReportItem]'},
    }

    def __init__(self, aggregation_level, provider_location, reachability_report):
        self.aggregation_level = aggregation_level
        self.provider_location = provider_location
        self.reachability_report = reachability_report
