# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from azure.core import HttpResponseError


class Action(Model):
    """The action that will be executed.

    :param action_type: The type of the action. Possible values include:
     'EmailContacts', 'AutoRenew'
    :type action_type: str or ~azure.keyvault.v2016_10_01.models.ActionType
    """

    _attribute_map = {
        'action_type': {'key': 'action_type', 'type': 'ActionType'},
    }

    def __init__(self, *, action_type=None, **kwargs) -> None:
        super(Action, self).__init__(**kwargs)
        self.action_type = action_type


class AdministratorDetails(Model):
    """Details of the organization administrator of the certificate issuer.

    :param first_name: First name.
    :type first_name: str
    :param last_name: Last name.
    :type last_name: str
    :param email_address: Email address.
    :type email_address: str
    :param phone: Phone number.
    :type phone: str
    """

    _attribute_map = {
        'first_name': {'key': 'first_name', 'type': 'str'},
        'last_name': {'key': 'last_name', 'type': 'str'},
        'email_address': {'key': 'email', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
    }

    def __init__(self, *, first_name: str=None, last_name: str=None, email_address: str=None, phone: str=None, **kwargs) -> None:
        super(AdministratorDetails, self).__init__(**kwargs)
        self.first_name = first_name
        self.last_name = last_name
        self.email_address = email_address
        self.phone = phone


class Attributes(Model):
    """The object attributes managed by the KeyVault service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param enabled: Determines whether the object is enabled.
    :type enabled: bool
    :param not_before: Not before date in UTC.
    :type not_before: datetime
    :param expires: Expiry date in UTC.
    :type expires: datetime
    :ivar created: Creation time in UTC.
    :vartype created: datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: datetime
    """

    _validation = {
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'not_before': {'key': 'nbf', 'type': 'unix-time'},
        'expires': {'key': 'exp', 'type': 'unix-time'},
        'created': {'key': 'created', 'type': 'unix-time'},
        'updated': {'key': 'updated', 'type': 'unix-time'},
    }

    def __init__(self, *, enabled: bool=None, not_before=None, expires=None, **kwargs) -> None:
        super(Attributes, self).__init__(**kwargs)
        self.enabled = enabled
        self.not_before = not_before
        self.expires = expires
        self.created = None
        self.updated = None


class BackupKeyResult(Model):
    """The backup key result, containing the backup blob.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The backup blob containing the backed up key.
    :vartype value: bytes
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'base64'},
    }

    def __init__(self, **kwargs) -> None:
        super(BackupKeyResult, self).__init__(**kwargs)
        self.value = None


class BackupSecretResult(Model):
    """The backup secret result, containing the backup blob.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The backup blob containing the backed up secret.
    :vartype value: bytes
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'base64'},
    }

    def __init__(self, **kwargs) -> None:
        super(BackupSecretResult, self).__init__(**kwargs)
        self.value = None


class CertificateAttributes(Attributes):
    """The certificate management attributes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param enabled: Determines whether the object is enabled.
    :type enabled: bool
    :param not_before: Not before date in UTC.
    :type not_before: datetime
    :param expires: Expiry date in UTC.
    :type expires: datetime
    :ivar created: Creation time in UTC.
    :vartype created: datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: datetime
    :ivar recovery_level: Reflects the deletion recovery level currently in
     effect for certificates in the current vault. If it contains 'Purgeable',
     the certificate can be permanently deleted by a privileged user;
     otherwise, only the system can purge the certificate, at the end of the
     retention interval. Possible values include: 'Purgeable',
     'Recoverable+Purgeable', 'Recoverable',
     'Recoverable+ProtectedSubscription'
    :vartype recovery_level: str or
     ~azure.keyvault.v2016_10_01.models.DeletionRecoveryLevel
    """

    _validation = {
        'created': {'readonly': True},
        'updated': {'readonly': True},
        'recovery_level': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'not_before': {'key': 'nbf', 'type': 'unix-time'},
        'expires': {'key': 'exp', 'type': 'unix-time'},
        'created': {'key': 'created', 'type': 'unix-time'},
        'updated': {'key': 'updated', 'type': 'unix-time'},
        'recovery_level': {'key': 'recoveryLevel', 'type': 'str'},
    }

    def __init__(self, *, enabled: bool=None, not_before=None, expires=None, **kwargs) -> None:
        super(CertificateAttributes, self).__init__(enabled=enabled, not_before=not_before, expires=expires, **kwargs)
        self.recovery_level = None


class CertificateBundle(Model):
    """A certificate bundle consists of a certificate (X509) plus its attributes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar kid: The key id.
    :vartype kid: str
    :ivar sid: The secret id.
    :vartype sid: str
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar policy: The management policy.
    :vartype policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
    :param cer: CER contents of x509 certificate.
    :type cer: bytearray
    :param content_type: The content type of the secret.
    :type content_type: str
    :param attributes: The certificate attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :param tags: Application specific metadata in the form of key-value pairs
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'kid': {'readonly': True},
        'sid': {'readonly': True},
        'x509_thumbprint': {'readonly': True},
        'policy': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
        'sid': {'key': 'sid', 'type': 'str'},
        'x509_thumbprint': {'key': 'x5t', 'type': 'base64'},
        'policy': {'key': 'policy', 'type': 'CertificatePolicy'},
        'cer': {'key': 'cer', 'type': 'bytearray'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'CertificateAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, cer: bytearray=None, content_type: str=None, attributes=None, tags=None, **kwargs) -> None:
        super(CertificateBundle, self).__init__(**kwargs)
        self.id = None
        self.kid = None
        self.sid = None
        self.x509_thumbprint = None
        self.policy = None
        self.cer = cer
        self.content_type = content_type
        self.attributes = attributes
        self.tags = tags


class CertificateCreateParameters(Model):
    """The certificate create parameters.

    :param certificate_policy: The management policy for the certificate.
    :type certificate_policy:
     ~azure.keyvault.v2016_10_01.models.CertificatePolicy
    :param certificate_attributes: The attributes of the certificate
     (optional).
    :type certificate_attributes:
     ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'certificate_policy': {'key': 'policy', 'type': 'CertificatePolicy'},
        'certificate_attributes': {'key': 'attributes', 'type': 'CertificateAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, certificate_policy=None, certificate_attributes=None, tags=None, **kwargs) -> None:
        super(CertificateCreateParameters, self).__init__(**kwargs)
        self.certificate_policy = certificate_policy
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class CertificateImportParameters(Model):
    """The certificate import parameters.

    All required parameters must be populated in order to send to Azure.

    :param base64_encoded_certificate: Required. Base64 encoded representation
     of the certificate object to import. This certificate needs to contain the
     private key.
    :type base64_encoded_certificate: str
    :param password: If the private key in base64EncodedCertificate is
     encrypted, the password used for encryption.
    :type password: str
    :param certificate_policy: The management policy for the certificate.
    :type certificate_policy:
     ~azure.keyvault.v2016_10_01.models.CertificatePolicy
    :param certificate_attributes: The attributes of the certificate
     (optional).
    :type certificate_attributes:
     ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _validation = {
        'base64_encoded_certificate': {'required': True},
    }

    _attribute_map = {
        'base64_encoded_certificate': {'key': 'value', 'type': 'str'},
        'password': {'key': 'pwd', 'type': 'str'},
        'certificate_policy': {'key': 'policy', 'type': 'CertificatePolicy'},
        'certificate_attributes': {'key': 'attributes', 'type': 'CertificateAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, base64_encoded_certificate: str, password: str=None, certificate_policy=None, certificate_attributes=None, tags=None, **kwargs) -> None:
        super(CertificateImportParameters, self).__init__(**kwargs)
        self.base64_encoded_certificate = base64_encoded_certificate
        self.password = password
        self.certificate_policy = certificate_policy
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class CertificateIssuerItem(Model):
    """The certificate issuer item containing certificate issuer metadata.

    :param id: Certificate Identifier.
    :type id: str
    :param provider: The issuer provider.
    :type provider: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, provider: str=None, **kwargs) -> None:
        super(CertificateIssuerItem, self).__init__(**kwargs)
        self.id = id
        self.provider = provider


class CertificateIssuerSetParameters(Model):
    """The certificate issuer set parameters.

    All required parameters must be populated in order to send to Azure.

    :param provider: Required. The issuer provider.
    :type provider: str
    :param credentials: The credentials to be used for the issuer.
    :type credentials: ~azure.keyvault.v2016_10_01.models.IssuerCredentials
    :param organization_details: Details of the organization as provided to
     the issuer.
    :type organization_details:
     ~azure.keyvault.v2016_10_01.models.OrganizationDetails
    :param attributes: Attributes of the issuer object.
    :type attributes: ~azure.keyvault.v2016_10_01.models.IssuerAttributes
    """

    _validation = {
        'provider': {'required': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'IssuerCredentials'},
        'organization_details': {'key': 'org_details', 'type': 'OrganizationDetails'},
        'attributes': {'key': 'attributes', 'type': 'IssuerAttributes'},
    }

    def __init__(self, *, provider: str, credentials=None, organization_details=None, attributes=None, **kwargs) -> None:
        super(CertificateIssuerSetParameters, self).__init__(**kwargs)
        self.provider = provider
        self.credentials = credentials
        self.organization_details = organization_details
        self.attributes = attributes


class CertificateIssuerUpdateParameters(Model):
    """The certificate issuer update parameters.

    :param provider: The issuer provider.
    :type provider: str
    :param credentials: The credentials to be used for the issuer.
    :type credentials: ~azure.keyvault.v2016_10_01.models.IssuerCredentials
    :param organization_details: Details of the organization as provided to
     the issuer.
    :type organization_details:
     ~azure.keyvault.v2016_10_01.models.OrganizationDetails
    :param attributes: Attributes of the issuer object.
    :type attributes: ~azure.keyvault.v2016_10_01.models.IssuerAttributes
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'IssuerCredentials'},
        'organization_details': {'key': 'org_details', 'type': 'OrganizationDetails'},
        'attributes': {'key': 'attributes', 'type': 'IssuerAttributes'},
    }

    def __init__(self, *, provider: str=None, credentials=None, organization_details=None, attributes=None, **kwargs) -> None:
        super(CertificateIssuerUpdateParameters, self).__init__(**kwargs)
        self.provider = provider
        self.credentials = credentials
        self.organization_details = organization_details
        self.attributes = attributes


class CertificateItem(Model):
    """The certificate item containing certificate metadata.

    :param id: Certificate identifier.
    :type id: str
    :param attributes: The certificate management attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param x509_thumbprint: Thumbprint of the certificate.
    :type x509_thumbprint: bytes
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'CertificateAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'x509_thumbprint': {'key': 'x5t', 'type': 'base64'},
    }

    def __init__(self, *, id: str=None, attributes=None, tags=None, x509_thumbprint: bytes=None, **kwargs) -> None:
        super(CertificateItem, self).__init__(**kwargs)
        self.id = id
        self.attributes = attributes
        self.tags = tags
        self.x509_thumbprint = x509_thumbprint


class CertificateMergeParameters(Model):
    """The certificate merge parameters.

    All required parameters must be populated in order to send to Azure.

    :param x509_certificates: Required. The certificate or the certificate
     chain to merge.
    :type x509_certificates: list[bytearray]
    :param certificate_attributes: The attributes of the certificate
     (optional).
    :type certificate_attributes:
     ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _validation = {
        'x509_certificates': {'required': True},
    }

    _attribute_map = {
        'x509_certificates': {'key': 'x5c', 'type': '[bytearray]'},
        'certificate_attributes': {'key': 'attributes', 'type': 'CertificateAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, x509_certificates, certificate_attributes=None, tags=None, **kwargs) -> None:
        super(CertificateMergeParameters, self).__init__(**kwargs)
        self.x509_certificates = x509_certificates
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class CertificateOperation(Model):
    """A certificate operation is returned in case of asynchronous requests.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :param issuer_parameters: Parameters for the issuer of the X509 component
     of a certificate.
    :type issuer_parameters:
     ~azure.keyvault.v2016_10_01.models.IssuerParameters
    :param csr: The certificate signing request (CSR) that is being used in
     the certificate operation.
    :type csr: bytearray
    :param cancellation_requested: Indicates if cancellation was requested on
     the certificate operation.
    :type cancellation_requested: bool
    :param status: Status of the certificate operation.
    :type status: str
    :param status_details: The status details of the certificate operation.
    :type status_details: str
    :param error: Error encountered, if any, during the certificate operation.
    :type error: ~azure.keyvault.v2016_10_01.models.Error
    :param target: Location which contains the result of the certificate
     operation.
    :type target: str
    :param request_id: Identifier for the certificate operation.
    :type request_id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'issuer_parameters': {'key': 'issuer', 'type': 'IssuerParameters'},
        'csr': {'key': 'csr', 'type': 'bytearray'},
        'cancellation_requested': {'key': 'cancellation_requested', 'type': 'bool'},
        'status': {'key': 'status', 'type': 'str'},
        'status_details': {'key': 'status_details', 'type': 'str'},
        'error': {'key': 'error', 'type': 'Error'},
        'target': {'key': 'target', 'type': 'str'},
        'request_id': {'key': 'request_id', 'type': 'str'},
    }

    def __init__(self, *, issuer_parameters=None, csr: bytearray=None, cancellation_requested: bool=None, status: str=None, status_details: str=None, error=None, target: str=None, request_id: str=None, **kwargs) -> None:
        super(CertificateOperation, self).__init__(**kwargs)
        self.id = None
        self.issuer_parameters = issuer_parameters
        self.csr = csr
        self.cancellation_requested = cancellation_requested
        self.status = status
        self.status_details = status_details
        self.error = error
        self.target = target
        self.request_id = request_id


class CertificateOperationUpdateParameter(Model):
    """The certificate operation update parameters.

    All required parameters must be populated in order to send to Azure.

    :param cancellation_requested: Required. Indicates if cancellation was
     requested on the certificate operation.
    :type cancellation_requested: bool
    """

    _validation = {
        'cancellation_requested': {'required': True},
    }

    _attribute_map = {
        'cancellation_requested': {'key': 'cancellation_requested', 'type': 'bool'},
    }

    def __init__(self, *, cancellation_requested: bool, **kwargs) -> None:
        super(CertificateOperationUpdateParameter, self).__init__(**kwargs)
        self.cancellation_requested = cancellation_requested


class CertificatePolicy(Model):
    """Management policy for a certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :param key_properties: Properties of the key backing a certificate.
    :type key_properties: ~azure.keyvault.v2016_10_01.models.KeyProperties
    :param secret_properties: Properties of the secret backing a certificate.
    :type secret_properties:
     ~azure.keyvault.v2016_10_01.models.SecretProperties
    :param x509_certificate_properties: Properties of the X509 component of a
     certificate.
    :type x509_certificate_properties:
     ~azure.keyvault.v2016_10_01.models.X509CertificateProperties
    :param lifetime_actions: Actions that will be performed by Key Vault over
     the lifetime of a certificate.
    :type lifetime_actions:
     list[~azure.keyvault.v2016_10_01.models.LifetimeAction]
    :param issuer_parameters: Parameters for the issuer of the X509 component
     of a certificate.
    :type issuer_parameters:
     ~azure.keyvault.v2016_10_01.models.IssuerParameters
    :param attributes: The certificate attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'key_properties': {'key': 'key_props', 'type': 'KeyProperties'},
        'secret_properties': {'key': 'secret_props', 'type': 'SecretProperties'},
        'x509_certificate_properties': {'key': 'x509_props', 'type': 'X509CertificateProperties'},
        'lifetime_actions': {'key': 'lifetime_actions', 'type': '[LifetimeAction]'},
        'issuer_parameters': {'key': 'issuer', 'type': 'IssuerParameters'},
        'attributes': {'key': 'attributes', 'type': 'CertificateAttributes'},
    }

    def __init__(self, *, key_properties=None, secret_properties=None, x509_certificate_properties=None, lifetime_actions=None, issuer_parameters=None, attributes=None, **kwargs) -> None:
        super(CertificatePolicy, self).__init__(**kwargs)
        self.id = None
        self.key_properties = key_properties
        self.secret_properties = secret_properties
        self.x509_certificate_properties = x509_certificate_properties
        self.lifetime_actions = lifetime_actions
        self.issuer_parameters = issuer_parameters
        self.attributes = attributes


class CertificateUpdateParameters(Model):
    """The certificate update parameters.

    :param certificate_policy: The management policy for the certificate.
    :type certificate_policy:
     ~azure.keyvault.v2016_10_01.models.CertificatePolicy
    :param certificate_attributes: The attributes of the certificate
     (optional).
    :type certificate_attributes:
     ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'certificate_policy': {'key': 'policy', 'type': 'CertificatePolicy'},
        'certificate_attributes': {'key': 'attributes', 'type': 'CertificateAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, certificate_policy=None, certificate_attributes=None, tags=None, **kwargs) -> None:
        super(CertificateUpdateParameters, self).__init__(**kwargs)
        self.certificate_policy = certificate_policy
        self.certificate_attributes = certificate_attributes
        self.tags = tags


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class Contact(Model):
    """The contact information for the vault certificates.

    :param email_address: Email address.
    :type email_address: str
    :param name: Name.
    :type name: str
    :param phone: Phone number.
    :type phone: str
    """

    _attribute_map = {
        'email_address': {'key': 'email', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
    }

    def __init__(self, *, email_address: str=None, name: str=None, phone: str=None, **kwargs) -> None:
        super(Contact, self).__init__(**kwargs)
        self.email_address = email_address
        self.name = name
        self.phone = phone


class Contacts(Model):
    """The contacts for the vault certificates.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Identifier for the contacts collection.
    :vartype id: str
    :param contact_list: The contact list for the vault certificates.
    :type contact_list: list[~azure.keyvault.v2016_10_01.models.Contact]
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'contact_list': {'key': 'contacts', 'type': '[Contact]'},
    }

    def __init__(self, *, contact_list=None, **kwargs) -> None:
        super(Contacts, self).__init__(**kwargs)
        self.id = None
        self.contact_list = contact_list


class DeletedCertificateBundle(CertificateBundle):
    """A Deleted Certificate consisting of its previous id, attributes and its
    tags, as well as information on when it will be purged.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The certificate id.
    :vartype id: str
    :ivar kid: The key id.
    :vartype kid: str
    :ivar sid: The secret id.
    :vartype sid: str
    :ivar x509_thumbprint: Thumbprint of the certificate.
    :vartype x509_thumbprint: bytes
    :ivar policy: The management policy.
    :vartype policy: ~azure.keyvault.v2016_10_01.models.CertificatePolicy
    :param cer: CER contents of x509 certificate.
    :type cer: bytearray
    :param content_type: The content type of the secret.
    :type content_type: str
    :param attributes: The certificate attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :param tags: Application specific metadata in the form of key-value pairs
    :type tags: dict[str, str]
    :param recovery_id: The url of the recovery object, used to identify and
     recover the deleted certificate.
    :type recovery_id: str
    :ivar scheduled_purge_date: The time when the certificate is scheduled to
     be purged, in UTC
    :vartype scheduled_purge_date: datetime
    :ivar deleted_date: The time when the certificate was deleted, in UTC
    :vartype deleted_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'kid': {'readonly': True},
        'sid': {'readonly': True},
        'x509_thumbprint': {'readonly': True},
        'policy': {'readonly': True},
        'scheduled_purge_date': {'readonly': True},
        'deleted_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'kid': {'key': 'kid', 'type': 'str'},
        'sid': {'key': 'sid', 'type': 'str'},
        'x509_thumbprint': {'key': 'x5t', 'type': 'base64'},
        'policy': {'key': 'policy', 'type': 'CertificatePolicy'},
        'cer': {'key': 'cer', 'type': 'bytearray'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'CertificateAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'recovery_id': {'key': 'recoveryId', 'type': 'str'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'unix-time'},
        'deleted_date': {'key': 'deletedDate', 'type': 'unix-time'},
    }

    def __init__(self, *, cer: bytearray=None, content_type: str=None, attributes=None, tags=None, recovery_id: str=None, **kwargs) -> None:
        super(DeletedCertificateBundle, self).__init__(cer=cer, content_type=content_type, attributes=attributes, tags=tags, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class DeletedCertificateItem(CertificateItem):
    """The deleted certificate item containing metadata about the deleted
    certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Certificate identifier.
    :type id: str
    :param attributes: The certificate management attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.CertificateAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param x509_thumbprint: Thumbprint of the certificate.
    :type x509_thumbprint: bytes
    :param recovery_id: The url of the recovery object, used to identify and
     recover the deleted certificate.
    :type recovery_id: str
    :ivar scheduled_purge_date: The time when the certificate is scheduled to
     be purged, in UTC
    :vartype scheduled_purge_date: datetime
    :ivar deleted_date: The time when the certificate was deleted, in UTC
    :vartype deleted_date: datetime
    """

    _validation = {
        'scheduled_purge_date': {'readonly': True},
        'deleted_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'CertificateAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'x509_thumbprint': {'key': 'x5t', 'type': 'base64'},
        'recovery_id': {'key': 'recoveryId', 'type': 'str'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'unix-time'},
        'deleted_date': {'key': 'deletedDate', 'type': 'unix-time'},
    }

    def __init__(self, *, id: str=None, attributes=None, tags=None, x509_thumbprint: bytes=None, recovery_id: str=None, **kwargs) -> None:
        super(DeletedCertificateItem, self).__init__(id=id, attributes=attributes, tags=tags, x509_thumbprint=x509_thumbprint, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class KeyBundle(Model):
    """A KeyBundle consisting of a WebKey plus its attributes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param key: The Json web key.
    :type key: ~azure.keyvault.v2016_10_01.models.JsonWebKey
    :param attributes: The key management attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this
     is a key backing a certificate, then managed will be true.
    :vartype managed: bool
    """

    _validation = {
        'managed': {'readonly': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'JsonWebKey'},
        'attributes': {'key': 'attributes', 'type': 'KeyAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'managed': {'key': 'managed', 'type': 'bool'},
    }

    def __init__(self, *, key=None, attributes=None, tags=None, **kwargs) -> None:
        super(KeyBundle, self).__init__(**kwargs)
        self.key = key
        self.attributes = attributes
        self.tags = tags
        self.managed = None


class DeletedKeyBundle(KeyBundle):
    """A DeletedKeyBundle consisting of a WebKey plus its Attributes and deletion
    info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param key: The Json web key.
    :type key: ~azure.keyvault.v2016_10_01.models.JsonWebKey
    :param attributes: The key management attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this
     is a key backing a certificate, then managed will be true.
    :vartype managed: bool
    :param recovery_id: The url of the recovery object, used to identify and
     recover the deleted key.
    :type recovery_id: str
    :ivar scheduled_purge_date: The time when the key is scheduled to be
     purged, in UTC
    :vartype scheduled_purge_date: datetime
    :ivar deleted_date: The time when the key was deleted, in UTC
    :vartype deleted_date: datetime
    """

    _validation = {
        'managed': {'readonly': True},
        'scheduled_purge_date': {'readonly': True},
        'deleted_date': {'readonly': True},
    }

    _attribute_map = {
        'key': {'key': 'key', 'type': 'JsonWebKey'},
        'attributes': {'key': 'attributes', 'type': 'KeyAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'managed': {'key': 'managed', 'type': 'bool'},
        'recovery_id': {'key': 'recoveryId', 'type': 'str'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'unix-time'},
        'deleted_date': {'key': 'deletedDate', 'type': 'unix-time'},
    }

    def __init__(self, *, key=None, attributes=None, tags=None, recovery_id: str=None, **kwargs) -> None:
        super(DeletedKeyBundle, self).__init__(key=key, attributes=attributes, tags=tags, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class KeyItem(Model):
    """The key item containing key metadata.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param kid: Key identifier.
    :type kid: str
    :param attributes: The key management attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this
     is a key backing a certificate, then managed will be true.
    :vartype managed: bool
    """

    _validation = {
        'managed': {'readonly': True},
    }

    _attribute_map = {
        'kid': {'key': 'kid', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'KeyAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'managed': {'key': 'managed', 'type': 'bool'},
    }

    def __init__(self, *, kid: str=None, attributes=None, tags=None, **kwargs) -> None:
        super(KeyItem, self).__init__(**kwargs)
        self.kid = kid
        self.attributes = attributes
        self.tags = tags
        self.managed = None


class DeletedKeyItem(KeyItem):
    """The deleted key item containing the deleted key metadata and information
    about deletion.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param kid: Key identifier.
    :type kid: str
    :param attributes: The key management attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :ivar managed: True if the key's lifetime is managed by key vault. If this
     is a key backing a certificate, then managed will be true.
    :vartype managed: bool
    :param recovery_id: The url of the recovery object, used to identify and
     recover the deleted key.
    :type recovery_id: str
    :ivar scheduled_purge_date: The time when the key is scheduled to be
     purged, in UTC
    :vartype scheduled_purge_date: datetime
    :ivar deleted_date: The time when the key was deleted, in UTC
    :vartype deleted_date: datetime
    """

    _validation = {
        'managed': {'readonly': True},
        'scheduled_purge_date': {'readonly': True},
        'deleted_date': {'readonly': True},
    }

    _attribute_map = {
        'kid': {'key': 'kid', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'KeyAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'managed': {'key': 'managed', 'type': 'bool'},
        'recovery_id': {'key': 'recoveryId', 'type': 'str'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'unix-time'},
        'deleted_date': {'key': 'deletedDate', 'type': 'unix-time'},
    }

    def __init__(self, *, kid: str=None, attributes=None, tags=None, recovery_id: str=None, **kwargs) -> None:
        super(DeletedKeyItem, self).__init__(kid=kid, attributes=attributes, tags=tags, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class SecretBundle(Model):
    """A secret consisting of a value, id and its attributes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: The secret value.
    :type value: str
    :param id: The secret id.
    :type id: str
    :param content_type: The content type of the secret.
    :type content_type: str
    :param attributes: The secret management attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :ivar kid: If this is a secret backing a KV certificate, then this field
     specifies the corresponding key backing the KV certificate.
    :vartype kid: str
    :ivar managed: True if the secret's lifetime is managed by key vault. If
     this is a secret backing a certificate, then managed will be true.
    :vartype managed: bool
    """

    _validation = {
        'kid': {'readonly': True},
        'managed': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'SecretAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kid': {'key': 'kid', 'type': 'str'},
        'managed': {'key': 'managed', 'type': 'bool'},
    }

    def __init__(self, *, value: str=None, id: str=None, content_type: str=None, attributes=None, tags=None, **kwargs) -> None:
        super(SecretBundle, self).__init__(**kwargs)
        self.value = value
        self.id = id
        self.content_type = content_type
        self.attributes = attributes
        self.tags = tags
        self.kid = None
        self.managed = None


class DeletedSecretBundle(SecretBundle):
    """A Deleted Secret consisting of its previous id, attributes and its tags, as
    well as information on when it will be purged.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param value: The secret value.
    :type value: str
    :param id: The secret id.
    :type id: str
    :param content_type: The content type of the secret.
    :type content_type: str
    :param attributes: The secret management attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :ivar kid: If this is a secret backing a KV certificate, then this field
     specifies the corresponding key backing the KV certificate.
    :vartype kid: str
    :ivar managed: True if the secret's lifetime is managed by key vault. If
     this is a secret backing a certificate, then managed will be true.
    :vartype managed: bool
    :param recovery_id: The url of the recovery object, used to identify and
     recover the deleted secret.
    :type recovery_id: str
    :ivar scheduled_purge_date: The time when the secret is scheduled to be
     purged, in UTC
    :vartype scheduled_purge_date: datetime
    :ivar deleted_date: The time when the secret was deleted, in UTC
    :vartype deleted_date: datetime
    """

    _validation = {
        'kid': {'readonly': True},
        'managed': {'readonly': True},
        'scheduled_purge_date': {'readonly': True},
        'deleted_date': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'SecretAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kid': {'key': 'kid', 'type': 'str'},
        'managed': {'key': 'managed', 'type': 'bool'},
        'recovery_id': {'key': 'recoveryId', 'type': 'str'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'unix-time'},
        'deleted_date': {'key': 'deletedDate', 'type': 'unix-time'},
    }

    def __init__(self, *, value: str=None, id: str=None, content_type: str=None, attributes=None, tags=None, recovery_id: str=None, **kwargs) -> None:
        super(DeletedSecretBundle, self).__init__(value=value, id=id, content_type=content_type, attributes=attributes, tags=tags, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class SecretItem(Model):
    """The secret item containing secret metadata.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Secret identifier.
    :type id: str
    :param attributes: The secret management attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param content_type: Type of the secret value such as a password.
    :type content_type: str
    :ivar managed: True if the secret's lifetime is managed by key vault. If
     this is a key backing a certificate, then managed will be true.
    :vartype managed: bool
    """

    _validation = {
        'managed': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'SecretAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'managed': {'key': 'managed', 'type': 'bool'},
    }

    def __init__(self, *, id: str=None, attributes=None, tags=None, content_type: str=None, **kwargs) -> None:
        super(SecretItem, self).__init__(**kwargs)
        self.id = id
        self.attributes = attributes
        self.tags = tags
        self.content_type = content_type
        self.managed = None


class DeletedSecretItem(SecretItem):
    """The deleted secret item containing metadata about the deleted secret.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Secret identifier.
    :type id: str
    :param attributes: The secret management attributes.
    :type attributes: ~azure.keyvault.v2016_10_01.models.SecretAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param content_type: Type of the secret value such as a password.
    :type content_type: str
    :ivar managed: True if the secret's lifetime is managed by key vault. If
     this is a key backing a certificate, then managed will be true.
    :vartype managed: bool
    :param recovery_id: The url of the recovery object, used to identify and
     recover the deleted secret.
    :type recovery_id: str
    :ivar scheduled_purge_date: The time when the secret is scheduled to be
     purged, in UTC
    :vartype scheduled_purge_date: datetime
    :ivar deleted_date: The time when the secret was deleted, in UTC
    :vartype deleted_date: datetime
    """

    _validation = {
        'managed': {'readonly': True},
        'scheduled_purge_date': {'readonly': True},
        'deleted_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'SecretAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'managed': {'key': 'managed', 'type': 'bool'},
        'recovery_id': {'key': 'recoveryId', 'type': 'str'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'unix-time'},
        'deleted_date': {'key': 'deletedDate', 'type': 'unix-time'},
    }

    def __init__(self, *, id: str=None, attributes=None, tags=None, content_type: str=None, recovery_id: str=None, **kwargs) -> None:
        super(DeletedSecretItem, self).__init__(id=id, attributes=attributes, tags=tags, content_type=content_type, **kwargs)
        self.recovery_id = recovery_id
        self.scheduled_purge_date = None
        self.deleted_date = None


class Error(Model):
    """The key vault server error.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error:
    :vartype inner_error: ~azure.keyvault.v2016_10_01.models.Error
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'inner_error': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'inner_error': {'key': 'innererror', 'type': 'Error'},
    }

    def __init__(self, **kwargs) -> None:
        super(Error, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.inner_error = None


class IssuerAttributes(Model):
    """The attributes of an issuer managed by the Key Vault service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param enabled: Determines whether the issuer is enabled.
    :type enabled: bool
    :ivar created: Creation time in UTC.
    :vartype created: datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: datetime
    """

    _validation = {
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'unix-time'},
        'updated': {'key': 'updated', 'type': 'unix-time'},
    }

    def __init__(self, *, enabled: bool=None, **kwargs) -> None:
        super(IssuerAttributes, self).__init__(**kwargs)
        self.enabled = enabled
        self.created = None
        self.updated = None


class IssuerBundle(Model):
    """The issuer for Key Vault certificate.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Identifier for the issuer object.
    :vartype id: str
    :param provider: The issuer provider.
    :type provider: str
    :param credentials: The credentials to be used for the issuer.
    :type credentials: ~azure.keyvault.v2016_10_01.models.IssuerCredentials
    :param organization_details: Details of the organization as provided to
     the issuer.
    :type organization_details:
     ~azure.keyvault.v2016_10_01.models.OrganizationDetails
    :param attributes: Attributes of the issuer object.
    :type attributes: ~azure.keyvault.v2016_10_01.models.IssuerAttributes
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'IssuerCredentials'},
        'organization_details': {'key': 'org_details', 'type': 'OrganizationDetails'},
        'attributes': {'key': 'attributes', 'type': 'IssuerAttributes'},
    }

    def __init__(self, *, provider: str=None, credentials=None, organization_details=None, attributes=None, **kwargs) -> None:
        super(IssuerBundle, self).__init__(**kwargs)
        self.id = None
        self.provider = provider
        self.credentials = credentials
        self.organization_details = organization_details
        self.attributes = attributes


class IssuerCredentials(Model):
    """The credentials to be used for the certificate issuer.

    :param account_id: The user name/account name/account id.
    :type account_id: str
    :param password: The password/secret/account key.
    :type password: str
    """

    _attribute_map = {
        'account_id': {'key': 'account_id', 'type': 'str'},
        'password': {'key': 'pwd', 'type': 'str'},
    }

    def __init__(self, *, account_id: str=None, password: str=None, **kwargs) -> None:
        super(IssuerCredentials, self).__init__(**kwargs)
        self.account_id = account_id
        self.password = password


class IssuerParameters(Model):
    """Parameters for the issuer of the X509 component of a certificate.

    :param name: Name of the referenced issuer object or reserved names; for
     example, 'Self' or 'Unknown'.
    :type name: str
    :param certificate_type: Type of certificate to be requested from the
     issuer provider.
    :type certificate_type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'certificate_type': {'key': 'cty', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, certificate_type: str=None, **kwargs) -> None:
        super(IssuerParameters, self).__init__(**kwargs)
        self.name = name
        self.certificate_type = certificate_type


class JsonWebKey(Model):
    """As of http://tools.ietf.org/html/draft-ietf-jose-json-web-key-18.

    :param kid: Key identifier.
    :type kid: str
    :param kty: JsonWebKey key type (kty). Possible values include: 'EC',
     'EC-HSM', 'RSA', 'RSA-HSM', 'oct'
    :type kty: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyType
    :param key_ops:
    :type key_ops: list[str]
    :param n: RSA modulus.
    :type n: bytes
    :param e: RSA public exponent.
    :type e: bytes
    :param d: RSA private exponent, or the D component of an EC private key.
    :type d: bytes
    :param dp: RSA private key parameter.
    :type dp: bytes
    :param dq: RSA private key parameter.
    :type dq: bytes
    :param qi: RSA private key parameter.
    :type qi: bytes
    :param p: RSA secret prime.
    :type p: bytes
    :param q: RSA secret prime, with p < q.
    :type q: bytes
    :param k: Symmetric key.
    :type k: bytes
    :param t: HSM Token, used with 'Bring Your Own Key'.
    :type t: bytes
    :param crv: Elliptic curve name. For valid values, see
     JsonWebKeyCurveName. Possible values include: 'P-256', 'P-384', 'P-521',
     'SECP256K1'
    :type crv: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyCurveName
    :param x: X component of an EC public key.
    :type x: bytes
    :param y: Y component of an EC public key.
    :type y: bytes
    """

    _attribute_map = {
        'kid': {'key': 'kid', 'type': 'str'},
        'kty': {'key': 'kty', 'type': 'str'},
        'key_ops': {'key': 'key_ops', 'type': '[str]'},
        'n': {'key': 'n', 'type': 'base64'},
        'e': {'key': 'e', 'type': 'base64'},
        'd': {'key': 'd', 'type': 'base64'},
        'dp': {'key': 'dp', 'type': 'base64'},
        'dq': {'key': 'dq', 'type': 'base64'},
        'qi': {'key': 'qi', 'type': 'base64'},
        'p': {'key': 'p', 'type': 'base64'},
        'q': {'key': 'q', 'type': 'base64'},
        'k': {'key': 'k', 'type': 'base64'},
        't': {'key': 'key_hsm', 'type': 'base64'},
        'crv': {'key': 'crv', 'type': 'str'},
        'x': {'key': 'x', 'type': 'base64'},
        'y': {'key': 'y', 'type': 'base64'},
    }

    def __init__(self, *, kid: str=None, kty=None, key_ops=None, n: bytes=None, e: bytes=None, d: bytes=None, dp: bytes=None, dq: bytes=None, qi: bytes=None, p: bytes=None, q: bytes=None, k: bytes=None, t: bytes=None, crv=None, x: bytes=None, y: bytes=None, **kwargs) -> None:
        super(JsonWebKey, self).__init__(**kwargs)
        self.kid = kid
        self.kty = kty
        self.key_ops = key_ops
        self.n = n
        self.e = e
        self.d = d
        self.dp = dp
        self.dq = dq
        self.qi = qi
        self.p = p
        self.q = q
        self.k = k
        self.t = t
        self.crv = crv
        self.x = x
        self.y = y


class KeyAttributes(Attributes):
    """The attributes of a key managed by the key vault service.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param enabled: Determines whether the object is enabled.
    :type enabled: bool
    :param not_before: Not before date in UTC.
    :type not_before: datetime
    :param expires: Expiry date in UTC.
    :type expires: datetime
    :ivar created: Creation time in UTC.
    :vartype created: datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: datetime
    :ivar recovery_level: Reflects the deletion recovery level currently in
     effect for keys in the current vault. If it contains 'Purgeable' the key
     can be permanently deleted by a privileged user; otherwise, only the
     system can purge the key, at the end of the retention interval. Possible
     values include: 'Purgeable', 'Recoverable+Purgeable', 'Recoverable',
     'Recoverable+ProtectedSubscription'
    :vartype recovery_level: str or
     ~azure.keyvault.v2016_10_01.models.DeletionRecoveryLevel
    """

    _validation = {
        'created': {'readonly': True},
        'updated': {'readonly': True},
        'recovery_level': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'not_before': {'key': 'nbf', 'type': 'unix-time'},
        'expires': {'key': 'exp', 'type': 'unix-time'},
        'created': {'key': 'created', 'type': 'unix-time'},
        'updated': {'key': 'updated', 'type': 'unix-time'},
        'recovery_level': {'key': 'recoveryLevel', 'type': 'str'},
    }

    def __init__(self, *, enabled: bool=None, not_before=None, expires=None, **kwargs) -> None:
        super(KeyAttributes, self).__init__(enabled=enabled, not_before=not_before, expires=expires, **kwargs)
        self.recovery_level = None


class KeyCreateParameters(Model):
    """The key create parameters.

    All required parameters must be populated in order to send to Azure.

    :param kty: Required. The type of key to create. For valid values, see
     JsonWebKeyType. Possible values include: 'EC', 'EC-HSM', 'RSA', 'RSA-HSM',
     'oct'
    :type kty: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyType
    :param key_size: The key size in bits. For example: 2048, 3072, or 4096
     for RSA.
    :type key_size: int
    :param key_ops:
    :type key_ops: list[str or
     ~azure.keyvault.v2016_10_01.models.JsonWebKeyOperation]
    :param key_attributes:
    :type key_attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param curve: Elliptic curve name. For valid values, see
     JsonWebKeyCurveName. Possible values include: 'P-256', 'P-384', 'P-521',
     'SECP256K1'
    :type curve: str or ~azure.keyvault.v2016_10_01.models.JsonWebKeyCurveName
    """

    _validation = {
        'kty': {'required': True, 'min_length': 1},
    }

    _attribute_map = {
        'kty': {'key': 'kty', 'type': 'str'},
        'key_size': {'key': 'key_size', 'type': 'int'},
        'key_ops': {'key': 'key_ops', 'type': '[str]'},
        'key_attributes': {'key': 'attributes', 'type': 'KeyAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'curve': {'key': 'crv', 'type': 'str'},
    }

    def __init__(self, *, kty, key_size: int=None, key_ops=None, key_attributes=None, tags=None, curve=None, **kwargs) -> None:
        super(KeyCreateParameters, self).__init__(**kwargs)
        self.kty = kty
        self.key_size = key_size
        self.key_ops = key_ops
        self.key_attributes = key_attributes
        self.tags = tags
        self.curve = curve


class KeyImportParameters(Model):
    """The key import parameters.

    All required parameters must be populated in order to send to Azure.

    :param hsm: Whether to import as a hardware key (HSM) or software key.
    :type hsm: bool
    :param key: Required. The Json web key
    :type key: ~azure.keyvault.v2016_10_01.models.JsonWebKey
    :param key_attributes: The key management attributes.
    :type key_attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _validation = {
        'key': {'required': True},
    }

    _attribute_map = {
        'hsm': {'key': 'Hsm', 'type': 'bool'},
        'key': {'key': 'key', 'type': 'JsonWebKey'},
        'key_attributes': {'key': 'attributes', 'type': 'KeyAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, key, hsm: bool=None, key_attributes=None, tags=None, **kwargs) -> None:
        super(KeyImportParameters, self).__init__(**kwargs)
        self.hsm = hsm
        self.key = key
        self.key_attributes = key_attributes
        self.tags = tags


class KeyOperationResult(Model):
    """The key operation result.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar kid: Key identifier
    :vartype kid: str
    :ivar result:
    :vartype result: bytes
    """

    _validation = {
        'kid': {'readonly': True},
        'result': {'readonly': True},
    }

    _attribute_map = {
        'kid': {'key': 'kid', 'type': 'str'},
        'result': {'key': 'value', 'type': 'base64'},
    }

    def __init__(self, **kwargs) -> None:
        super(KeyOperationResult, self).__init__(**kwargs)
        self.kid = None
        self.result = None


class KeyOperationsParameters(Model):
    """The key operations parameters.

    All required parameters must be populated in order to send to Azure.

    :param algorithm: Required. algorithm identifier. Possible values include:
     'RSA-OAEP', 'RSA-OAEP-256', 'RSA1_5'
    :type algorithm: str or
     ~azure.keyvault.v2016_10_01.models.JsonWebKeyEncryptionAlgorithm
    :param value: Required.
    :type value: bytes
    """

    _validation = {
        'algorithm': {'required': True, 'min_length': 1},
        'value': {'required': True},
    }

    _attribute_map = {
        'algorithm': {'key': 'alg', 'type': 'str'},
        'value': {'key': 'value', 'type': 'base64'},
    }

    def __init__(self, *, algorithm, value: bytes, **kwargs) -> None:
        super(KeyOperationsParameters, self).__init__(**kwargs)
        self.algorithm = algorithm
        self.value = value


class KeyProperties(Model):
    """Properties of the key pair backing a certificate.

    :param exportable: Indicates if the private key can be exported.
    :type exportable: bool
    :param key_type: The key type.
    :type key_type: str
    :param key_size: The key size in bits. For example: 2048, 3072, or 4096
     for RSA.
    :type key_size: int
    :param reuse_key: Indicates if the same key pair will be used on
     certificate renewal.
    :type reuse_key: bool
    """

    _attribute_map = {
        'exportable': {'key': 'exportable', 'type': 'bool'},
        'key_type': {'key': 'kty', 'type': 'str'},
        'key_size': {'key': 'key_size', 'type': 'int'},
        'reuse_key': {'key': 'reuse_key', 'type': 'bool'},
    }

    def __init__(self, *, exportable: bool=None, key_type: str=None, key_size: int=None, reuse_key: bool=None, **kwargs) -> None:
        super(KeyProperties, self).__init__(**kwargs)
        self.exportable = exportable
        self.key_type = key_type
        self.key_size = key_size
        self.reuse_key = reuse_key


class KeyRestoreParameters(Model):
    """The key restore parameters.

    All required parameters must be populated in order to send to Azure.

    :param key_bundle_backup: Required. The backup blob associated with a key
     bundle.
    :type key_bundle_backup: bytes
    """

    _validation = {
        'key_bundle_backup': {'required': True},
    }

    _attribute_map = {
        'key_bundle_backup': {'key': 'value', 'type': 'base64'},
    }

    def __init__(self, *, key_bundle_backup: bytes, **kwargs) -> None:
        super(KeyRestoreParameters, self).__init__(**kwargs)
        self.key_bundle_backup = key_bundle_backup


class KeySignParameters(Model):
    """The key operations parameters.

    All required parameters must be populated in order to send to Azure.

    :param algorithm: Required. The signing/verification algorithm identifier.
     For more information on possible algorithm types, see
     JsonWebKeySignatureAlgorithm. Possible values include: 'PS256', 'PS384',
     'PS512', 'RS256', 'RS384', 'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512',
     'ECDSA256'
    :type algorithm: str or
     ~azure.keyvault.v2016_10_01.models.JsonWebKeySignatureAlgorithm
    :param value: Required.
    :type value: bytes
    """

    _validation = {
        'algorithm': {'required': True, 'min_length': 1},
        'value': {'required': True},
    }

    _attribute_map = {
        'algorithm': {'key': 'alg', 'type': 'str'},
        'value': {'key': 'value', 'type': 'base64'},
    }

    def __init__(self, *, algorithm, value: bytes, **kwargs) -> None:
        super(KeySignParameters, self).__init__(**kwargs)
        self.algorithm = algorithm
        self.value = value


class KeyUpdateParameters(Model):
    """The key update parameters.

    :param key_ops: Json web key operations. For more information on possible
     key operations, see JsonWebKeyOperation.
    :type key_ops: list[str or
     ~azure.keyvault.v2016_10_01.models.JsonWebKeyOperation]
    :param key_attributes:
    :type key_attributes: ~azure.keyvault.v2016_10_01.models.KeyAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'key_ops': {'key': 'key_ops', 'type': '[str]'},
        'key_attributes': {'key': 'attributes', 'type': 'KeyAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, key_ops=None, key_attributes=None, tags=None, **kwargs) -> None:
        super(KeyUpdateParameters, self).__init__(**kwargs)
        self.key_ops = key_ops
        self.key_attributes = key_attributes
        self.tags = tags


class KeyVaultError(Model):
    """The key vault error exception.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar error:
    :vartype error: ~azure.keyvault.v2016_10_01.models.Error
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(self, **kwargs) -> None:
        super(KeyVaultError, self).__init__(**kwargs)
        self.error = None


class KeyVaultErrorException(HttpResponseError):
    """Server responsed with exception of type: 'KeyVaultError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, response, deserialize, *args):

      model_name = 'KeyVaultError'
      self.error = deserialize(model_name, response)
      if self.error is None:
          self.error = deserialize.dependencies[model_name]()
      super(KeyVaultErrorException, self).__init__(response=response)


class KeyVerifyParameters(Model):
    """The key verify parameters.

    All required parameters must be populated in order to send to Azure.

    :param algorithm: Required. The signing/verification algorithm. For more
     information on possible algorithm types, see JsonWebKeySignatureAlgorithm.
     Possible values include: 'PS256', 'PS384', 'PS512', 'RS256', 'RS384',
     'RS512', 'RSNULL', 'ES256', 'ES384', 'ES512', 'ECDSA256'
    :type algorithm: str or
     ~azure.keyvault.v2016_10_01.models.JsonWebKeySignatureAlgorithm
    :param digest: Required. The digest used for signing.
    :type digest: bytes
    :param signature: Required. The signature to be verified.
    :type signature: bytes
    """

    _validation = {
        'algorithm': {'required': True, 'min_length': 1},
        'digest': {'required': True},
        'signature': {'required': True},
    }

    _attribute_map = {
        'algorithm': {'key': 'alg', 'type': 'str'},
        'digest': {'key': 'digest', 'type': 'base64'},
        'signature': {'key': 'value', 'type': 'base64'},
    }

    def __init__(self, *, algorithm, digest: bytes, signature: bytes, **kwargs) -> None:
        super(KeyVerifyParameters, self).__init__(**kwargs)
        self.algorithm = algorithm
        self.digest = digest
        self.signature = signature


class KeyVerifyResult(Model):
    """The key verify result.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: True if the signature is verified, otherwise false.
    :vartype value: bool
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'bool'},
    }

    def __init__(self, **kwargs) -> None:
        super(KeyVerifyResult, self).__init__(**kwargs)
        self.value = None


class LifetimeAction(Model):
    """Action and its trigger that will be performed by Key Vault over the
    lifetime of a certificate.

    :param trigger: The condition that will execute the action.
    :type trigger: ~azure.keyvault.v2016_10_01.models.Trigger
    :param action: The action that will be executed.
    :type action: ~azure.keyvault.v2016_10_01.models.Action
    """

    _attribute_map = {
        'trigger': {'key': 'trigger', 'type': 'Trigger'},
        'action': {'key': 'action', 'type': 'Action'},
    }

    def __init__(self, *, trigger=None, action=None, **kwargs) -> None:
        super(LifetimeAction, self).__init__(**kwargs)
        self.trigger = trigger
        self.action = action


class OrganizationDetails(Model):
    """Details of the organization of the certificate issuer.

    :param id: Id of the organization.
    :type id: str
    :param admin_details: Details of the organization administrator.
    :type admin_details:
     list[~azure.keyvault.v2016_10_01.models.AdministratorDetails]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'admin_details': {'key': 'admin_details', 'type': '[AdministratorDetails]'},
    }

    def __init__(self, *, id: str=None, admin_details=None, **kwargs) -> None:
        super(OrganizationDetails, self).__init__(**kwargs)
        self.id = id
        self.admin_details = admin_details


class PendingCertificateSigningRequestResult(Model):
    """The pending certificate signing request result.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The pending certificate signing request as Base64 encoded
     string.
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(PendingCertificateSigningRequestResult, self).__init__(**kwargs)
        self.value = None


class SasDefinitionAttributes(Model):
    """The SAS definition management attributes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param enabled: the enabled state of the object.
    :type enabled: bool
    :ivar created: Creation time in UTC.
    :vartype created: datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: datetime
    """

    _validation = {
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'unix-time'},
        'updated': {'key': 'updated', 'type': 'unix-time'},
    }

    def __init__(self, *, enabled: bool=None, **kwargs) -> None:
        super(SasDefinitionAttributes, self).__init__(**kwargs)
        self.enabled = enabled
        self.created = None
        self.updated = None


class SasDefinitionBundle(Model):
    """A SAS definition bundle consists of key vault SAS definition details plus
    its attributes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The SAS definition id.
    :vartype id: str
    :ivar secret_id: Storage account SAS definition secret id.
    :vartype secret_id: str
    :ivar parameters: The SAS definition metadata in the form of key-value
     pairs.
    :vartype parameters: dict[str, str]
    :ivar attributes: The SAS definition attributes.
    :vartype attributes:
     ~azure.keyvault.v2016_10_01.models.SasDefinitionAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'secret_id': {'readonly': True},
        'parameters': {'readonly': True},
        'attributes': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'secret_id': {'key': 'sid', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'attributes': {'key': 'attributes', 'type': 'SasDefinitionAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs) -> None:
        super(SasDefinitionBundle, self).__init__(**kwargs)
        self.id = None
        self.secret_id = None
        self.parameters = None
        self.attributes = None
        self.tags = None


class SasDefinitionCreateParameters(Model):
    """The SAS definition create parameters.

    All required parameters must be populated in order to send to Azure.

    :param parameters: Required. Sas definition creation metadata in the form
     of key-value pairs.
    :type parameters: dict[str, str]
    :param sas_definition_attributes: The attributes of the SAS definition.
    :type sas_definition_attributes:
     ~azure.keyvault.v2016_10_01.models.SasDefinitionAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _validation = {
        'parameters': {'required': True},
    }

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'sas_definition_attributes': {'key': 'attributes', 'type': 'SasDefinitionAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, parameters, sas_definition_attributes=None, tags=None, **kwargs) -> None:
        super(SasDefinitionCreateParameters, self).__init__(**kwargs)
        self.parameters = parameters
        self.sas_definition_attributes = sas_definition_attributes
        self.tags = tags


class SasDefinitionItem(Model):
    """The SAS definition item containing storage SAS definition metadata.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The storage SAS identifier.
    :vartype id: str
    :ivar secret_id: The storage account SAS definition secret id.
    :vartype secret_id: str
    :ivar attributes: The SAS definition management attributes.
    :vartype attributes:
     ~azure.keyvault.v2016_10_01.models.SasDefinitionAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'secret_id': {'readonly': True},
        'attributes': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'secret_id': {'key': 'sid', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'SasDefinitionAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs) -> None:
        super(SasDefinitionItem, self).__init__(**kwargs)
        self.id = None
        self.secret_id = None
        self.attributes = None
        self.tags = None


class SasDefinitionUpdateParameters(Model):
    """The SAS definition update parameters.

    :param parameters: Sas definition update metadata in the form of key-value
     pairs.
    :type parameters: dict[str, str]
    :param sas_definition_attributes: The attributes of the SAS definition.
    :type sas_definition_attributes:
     ~azure.keyvault.v2016_10_01.models.SasDefinitionAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'sas_definition_attributes': {'key': 'attributes', 'type': 'SasDefinitionAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, parameters=None, sas_definition_attributes=None, tags=None, **kwargs) -> None:
        super(SasDefinitionUpdateParameters, self).__init__(**kwargs)
        self.parameters = parameters
        self.sas_definition_attributes = sas_definition_attributes
        self.tags = tags


class SecretAttributes(Attributes):
    """The secret management attributes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param enabled: Determines whether the object is enabled.
    :type enabled: bool
    :param not_before: Not before date in UTC.
    :type not_before: datetime
    :param expires: Expiry date in UTC.
    :type expires: datetime
    :ivar created: Creation time in UTC.
    :vartype created: datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: datetime
    :ivar recovery_level: Reflects the deletion recovery level currently in
     effect for secrets in the current vault. If it contains 'Purgeable', the
     secret can be permanently deleted by a privileged user; otherwise, only
     the system can purge the secret, at the end of the retention interval.
     Possible values include: 'Purgeable', 'Recoverable+Purgeable',
     'Recoverable', 'Recoverable+ProtectedSubscription'
    :vartype recovery_level: str or
     ~azure.keyvault.v2016_10_01.models.DeletionRecoveryLevel
    """

    _validation = {
        'created': {'readonly': True},
        'updated': {'readonly': True},
        'recovery_level': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'not_before': {'key': 'nbf', 'type': 'unix-time'},
        'expires': {'key': 'exp', 'type': 'unix-time'},
        'created': {'key': 'created', 'type': 'unix-time'},
        'updated': {'key': 'updated', 'type': 'unix-time'},
        'recovery_level': {'key': 'recoveryLevel', 'type': 'str'},
    }

    def __init__(self, *, enabled: bool=None, not_before=None, expires=None, **kwargs) -> None:
        super(SecretAttributes, self).__init__(enabled=enabled, not_before=not_before, expires=expires, **kwargs)
        self.recovery_level = None


class SecretProperties(Model):
    """Properties of the key backing a certificate.

    :param content_type: The media type (MIME type).
    :type content_type: str
    """

    _attribute_map = {
        'content_type': {'key': 'contentType', 'type': 'str'},
    }

    def __init__(self, *, content_type: str=None, **kwargs) -> None:
        super(SecretProperties, self).__init__(**kwargs)
        self.content_type = content_type


class SecretRestoreParameters(Model):
    """The secret restore parameters.

    All required parameters must be populated in order to send to Azure.

    :param secret_bundle_backup: Required. The backup blob associated with a
     secret bundle.
    :type secret_bundle_backup: bytes
    """

    _validation = {
        'secret_bundle_backup': {'required': True},
    }

    _attribute_map = {
        'secret_bundle_backup': {'key': 'value', 'type': 'base64'},
    }

    def __init__(self, *, secret_bundle_backup: bytes, **kwargs) -> None:
        super(SecretRestoreParameters, self).__init__(**kwargs)
        self.secret_bundle_backup = secret_bundle_backup


class SecretSetParameters(Model):
    """The secret set parameters.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The value of the secret.
    :type value: str
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    :param content_type: Type of the secret value such as a password.
    :type content_type: str
    :param secret_attributes: The secret management attributes.
    :type secret_attributes:
     ~azure.keyvault.v2016_10_01.models.SecretAttributes
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'secret_attributes': {'key': 'attributes', 'type': 'SecretAttributes'},
    }

    def __init__(self, *, value: str, tags=None, content_type: str=None, secret_attributes=None, **kwargs) -> None:
        super(SecretSetParameters, self).__init__(**kwargs)
        self.value = value
        self.tags = tags
        self.content_type = content_type
        self.secret_attributes = secret_attributes


class SecretUpdateParameters(Model):
    """The secret update parameters.

    :param content_type: Type of the secret value such as a password.
    :type content_type: str
    :param secret_attributes: The secret management attributes.
    :type secret_attributes:
     ~azure.keyvault.v2016_10_01.models.SecretAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'content_type': {'key': 'contentType', 'type': 'str'},
        'secret_attributes': {'key': 'attributes', 'type': 'SecretAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, content_type: str=None, secret_attributes=None, tags=None, **kwargs) -> None:
        super(SecretUpdateParameters, self).__init__(**kwargs)
        self.content_type = content_type
        self.secret_attributes = secret_attributes
        self.tags = tags


class StorageAccountAttributes(Model):
    """The storage account management attributes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param enabled: the enabled state of the object.
    :type enabled: bool
    :ivar created: Creation time in UTC.
    :vartype created: datetime
    :ivar updated: Last updated time in UTC.
    :vartype updated: datetime
    """

    _validation = {
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'unix-time'},
        'updated': {'key': 'updated', 'type': 'unix-time'},
    }

    def __init__(self, *, enabled: bool=None, **kwargs) -> None:
        super(StorageAccountAttributes, self).__init__(**kwargs)
        self.enabled = enabled
        self.created = None
        self.updated = None


class StorageAccountCreateParameters(Model):
    """The storage account create parameters.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. Storage account resource id.
    :type resource_id: str
    :param active_key_name: Required. Current active storage account key name.
    :type active_key_name: str
    :param auto_regenerate_key: Required. whether keyvault should manage the
     storage account for the user.
    :type auto_regenerate_key: bool
    :param regeneration_period: The key regeneration time duration specified
     in ISO-8601 format.
    :type regeneration_period: str
    :param storage_account_attributes: The attributes of the storage account.
    :type storage_account_attributes:
     ~azure.keyvault.v2016_10_01.models.StorageAccountAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _validation = {
        'resource_id': {'required': True},
        'active_key_name': {'required': True},
        'auto_regenerate_key': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'active_key_name': {'key': 'activeKeyName', 'type': 'str'},
        'auto_regenerate_key': {'key': 'autoRegenerateKey', 'type': 'bool'},
        'regeneration_period': {'key': 'regenerationPeriod', 'type': 'str'},
        'storage_account_attributes': {'key': 'attributes', 'type': 'StorageAccountAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, resource_id: str, active_key_name: str, auto_regenerate_key: bool, regeneration_period: str=None, storage_account_attributes=None, tags=None, **kwargs) -> None:
        super(StorageAccountCreateParameters, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.active_key_name = active_key_name
        self.auto_regenerate_key = auto_regenerate_key
        self.regeneration_period = regeneration_period
        self.storage_account_attributes = storage_account_attributes
        self.tags = tags


class StorageAccountItem(Model):
    """The storage account item containing storage account metadata.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Storage identifier.
    :vartype id: str
    :ivar resource_id: Storage account resource Id.
    :vartype resource_id: str
    :ivar attributes: The storage account management attributes.
    :vartype attributes:
     ~azure.keyvault.v2016_10_01.models.StorageAccountAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'resource_id': {'readonly': True},
        'attributes': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'StorageAccountAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs) -> None:
        super(StorageAccountItem, self).__init__(**kwargs)
        self.id = None
        self.resource_id = None
        self.attributes = None
        self.tags = None


class StorageAccountRegenerteKeyParameters(Model):
    """The storage account key regenerate parameters.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. The storage account key name.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, *, key_name: str, **kwargs) -> None:
        super(StorageAccountRegenerteKeyParameters, self).__init__(**kwargs)
        self.key_name = key_name


class StorageAccountUpdateParameters(Model):
    """The storage account update parameters.

    :param active_key_name: The current active storage account key name.
    :type active_key_name: str
    :param auto_regenerate_key: whether keyvault should manage the storage
     account for the user.
    :type auto_regenerate_key: bool
    :param regeneration_period: The key regeneration time duration specified
     in ISO-8601 format.
    :type regeneration_period: str
    :param storage_account_attributes: The attributes of the storage account.
    :type storage_account_attributes:
     ~azure.keyvault.v2016_10_01.models.StorageAccountAttributes
    :param tags: Application specific metadata in the form of key-value pairs.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'active_key_name': {'key': 'activeKeyName', 'type': 'str'},
        'auto_regenerate_key': {'key': 'autoRegenerateKey', 'type': 'bool'},
        'regeneration_period': {'key': 'regenerationPeriod', 'type': 'str'},
        'storage_account_attributes': {'key': 'attributes', 'type': 'StorageAccountAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, active_key_name: str=None, auto_regenerate_key: bool=None, regeneration_period: str=None, storage_account_attributes=None, tags=None, **kwargs) -> None:
        super(StorageAccountUpdateParameters, self).__init__(**kwargs)
        self.active_key_name = active_key_name
        self.auto_regenerate_key = auto_regenerate_key
        self.regeneration_period = regeneration_period
        self.storage_account_attributes = storage_account_attributes
        self.tags = tags


class StorageBundle(Model):
    """A Storage account bundle consists of key vault storage account details plus
    its attributes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The storage account id.
    :vartype id: str
    :ivar resource_id: The storage account resource id.
    :vartype resource_id: str
    :ivar active_key_name: The current active storage account key name.
    :vartype active_key_name: str
    :ivar auto_regenerate_key: whether keyvault should manage the storage
     account for the user.
    :vartype auto_regenerate_key: bool
    :ivar regeneration_period: The key regeneration time duration specified in
     ISO-8601 format.
    :vartype regeneration_period: str
    :ivar attributes: The storage account attributes.
    :vartype attributes:
     ~azure.keyvault.v2016_10_01.models.StorageAccountAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'resource_id': {'readonly': True},
        'active_key_name': {'readonly': True},
        'auto_regenerate_key': {'readonly': True},
        'regeneration_period': {'readonly': True},
        'attributes': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'active_key_name': {'key': 'activeKeyName', 'type': 'str'},
        'auto_regenerate_key': {'key': 'autoRegenerateKey', 'type': 'bool'},
        'regeneration_period': {'key': 'regenerationPeriod', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'StorageAccountAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs) -> None:
        super(StorageBundle, self).__init__(**kwargs)
        self.id = None
        self.resource_id = None
        self.active_key_name = None
        self.auto_regenerate_key = None
        self.regeneration_period = None
        self.attributes = None
        self.tags = None


class SubjectAlternativeNames(Model):
    """The subject alternate names of a X509 object.

    :param emails: Email addresses.
    :type emails: list[str]
    :param dns_names: Domain names.
    :type dns_names: list[str]
    :param upns: User principal names.
    :type upns: list[str]
    """

    _attribute_map = {
        'emails': {'key': 'emails', 'type': '[str]'},
        'dns_names': {'key': 'dns_names', 'type': '[str]'},
        'upns': {'key': 'upns', 'type': '[str]'},
    }

    def __init__(self, *, emails=None, dns_names=None, upns=None, **kwargs) -> None:
        super(SubjectAlternativeNames, self).__init__(**kwargs)
        self.emails = emails
        self.dns_names = dns_names
        self.upns = upns


class Trigger(Model):
    """A condition to be satisfied for an action to be executed.

    :param lifetime_percentage: Percentage of lifetime at which to trigger.
     Value should be between 1 and 99.
    :type lifetime_percentage: int
    :param days_before_expiry: Days before expiry to attempt renewal. Value
     should be between 1 and validity_in_months multiplied by 27. If
     validity_in_months is 36, then value should be between 1 and 972 (36 *
     27).
    :type days_before_expiry: int
    """

    _validation = {
        'lifetime_percentage': {'maximum': 99, 'minimum': 1},
    }

    _attribute_map = {
        'lifetime_percentage': {'key': 'lifetime_percentage', 'type': 'int'},
        'days_before_expiry': {'key': 'days_before_expiry', 'type': 'int'},
    }

    def __init__(self, *, lifetime_percentage: int=None, days_before_expiry: int=None, **kwargs) -> None:
        super(Trigger, self).__init__(**kwargs)
        self.lifetime_percentage = lifetime_percentage
        self.days_before_expiry = days_before_expiry


class X509CertificateProperties(Model):
    """Properties of the X509 component of a certificate.

    :param subject: The subject name. Should be a valid X509 distinguished
     Name.
    :type subject: str
    :param ekus: The enhanced key usage.
    :type ekus: list[str]
    :param subject_alternative_names: The subject alternative names.
    :type subject_alternative_names:
     ~azure.keyvault.v2016_10_01.models.SubjectAlternativeNames
    :param key_usage: List of key usages.
    :type key_usage: list[str or
     ~azure.keyvault.v2016_10_01.models.KeyUsageType]
    :param validity_in_months: The duration that the certificate is valid in
     months.
    :type validity_in_months: int
    """

    _validation = {
        'validity_in_months': {'minimum': 0},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'ekus': {'key': 'ekus', 'type': '[str]'},
        'subject_alternative_names': {'key': 'sans', 'type': 'SubjectAlternativeNames'},
        'key_usage': {'key': 'key_usage', 'type': '[str]'},
        'validity_in_months': {'key': 'validity_months', 'type': 'int'},
    }

    def __init__(self, *, subject: str=None, ekus=None, subject_alternative_names=None, key_usage=None, validity_in_months: int=None, **kwargs) -> None:
        super(X509CertificateProperties, self).__init__(**kwargs)
        self.subject = subject
        self.ekus = ekus
        self.subject_alternative_names = subject_alternative_names
        self.key_usage = key_usage
        self.validity_in_months = validity_in_months
