# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class GroupCreateParameters(Model):
    """Request parameters for create a new group.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param display_name: Group display name
    :type display_name: str
    :ivar mail_enabled: Specifies whether the group is mail-enabled. Must be
     false. This is because only pure security groups can be created using
     the Graph API. Default value: False .
    :vartype mail_enabled: bool
    :param mail_nickname: Mail nick name
    :type mail_nickname: str
    :ivar security_enabled: Specifies whether the group is a security group.
     Must be true. This is because only pure security groups can be created
     using the Graph API. Default value: False .
    :vartype security_enabled: bool
    """ 

    _validation = {
        'display_name': {'required': True},
        'mail_enabled': {'required': True, 'constant': True},
        'mail_nickname': {'required': True},
        'security_enabled': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'mail_enabled': {'key': 'mailEnabled', 'type': 'bool'},
        'mail_nickname': {'key': 'mailNickname', 'type': 'str'},
        'security_enabled': {'key': 'securityEnabled', 'type': 'bool'},
    }

    mail_enabled = False

    security_enabled = False

    def __init__(self, display_name, mail_nickname):
        self.display_name = display_name
        self.mail_nickname = mail_nickname
