# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationUpdateParameters(Model):
    """Request parameters for updating an existing application.

    :param display_name: Application display name
    :type display_name: str
    :param homepage: Application homepage
    :type homepage: str
    :param identifier_uris: Application Uris
    :type identifier_uris: list of str
    :param reply_urls: Application reply Urls
    :type reply_urls: list of str
    :param key_credentials: Gets or sets the list of KeyCredential objects
    :type key_credentials: list of :class:`KeyCredential
     <azure.graphrbac.models.KeyCredential>`
    :param password_credentials: Gets or sets the list of PasswordCredential
     objects
    :type password_credentials: list of :class:`PasswordCredential
     <azure.graphrbac.models.PasswordCredential>`
    """ 

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'homepage': {'key': 'homepage', 'type': 'str'},
        'identifier_uris': {'key': 'identifierUris', 'type': '[str]'},
        'reply_urls': {'key': 'replyUrls', 'type': '[str]'},
        'key_credentials': {'key': 'keyCredentials', 'type': '[KeyCredential]'},
        'password_credentials': {'key': 'passwordCredentials', 'type': '[PasswordCredential]'},
    }

    def __init__(self, display_name=None, homepage=None, identifier_uris=None, reply_urls=None, key_credentials=None, password_credentials=None):
        self.display_name = display_name
        self.homepage = homepage
        self.identifier_uris = identifier_uris
        self.reply_urls = reply_urls
        self.key_credentials = key_credentials
        self.password_credentials = password_credentials
