# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource import Resource


class LoadBalancer(Resource):
    """
    LoadBalancer resource

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource Id
    :type id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :param frontend_ip_configurations: Gets or sets frontend IP addresses of
     the load balancer
    :type frontend_ip_configurations: list of :class:`FrontendIPConfiguration
     <azure.mgmt.network.models.FrontendIPConfiguration>`
    :param backend_address_pools: Gets or sets Pools of backend IP addresseses
    :type backend_address_pools: list of :class:`BackendAddressPool
     <azure.mgmt.network.models.BackendAddressPool>`
    :param load_balancing_rules: Gets or sets loadbalancing rules
    :type load_balancing_rules: list of :class:`LoadBalancingRule
     <azure.mgmt.network.models.LoadBalancingRule>`
    :param probes: Gets or sets list of Load balancer probes
    :type probes: list of :class:`Probe <azure.mgmt.network.models.Probe>`
    :param inbound_nat_rules: Gets or sets list of inbound rules
    :type inbound_nat_rules: list of :class:`InboundNatRule
     <azure.mgmt.network.models.InboundNatRule>`
    :param inbound_nat_pools: Gets or sets inbound NAT pools
    :type inbound_nat_pools: list of :class:`InboundNatPool
     <azure.mgmt.network.models.InboundNatPool>`
    :param outbound_nat_rules: Gets or sets outbound NAT rules
    :type outbound_nat_rules: list of :class:`OutboundNatRule
     <azure.mgmt.network.models.OutboundNatRule>`
    :param resource_guid: Gets or sets resource guid property of the Load
     balancer resource
    :type resource_guid: str
    :param provisioning_state: Gets or sets Provisioning state of the
     PublicIP resource Updating/Deleting/Failed
    :type provisioning_state: str
    :param etag: Gets a unique read-only string that changes whenever the
     resource is updated
    :type etag: str
    """ 

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'frontend_ip_configurations': {'key': 'properties.frontendIPConfigurations', 'type': '[FrontendIPConfiguration]'},
        'backend_address_pools': {'key': 'properties.backendAddressPools', 'type': '[BackendAddressPool]'},
        'load_balancing_rules': {'key': 'properties.loadBalancingRules', 'type': '[LoadBalancingRule]'},
        'probes': {'key': 'properties.probes', 'type': '[Probe]'},
        'inbound_nat_rules': {'key': 'properties.inboundNatRules', 'type': '[InboundNatRule]'},
        'inbound_nat_pools': {'key': 'properties.inboundNatPools', 'type': '[InboundNatPool]'},
        'outbound_nat_rules': {'key': 'properties.outboundNatRules', 'type': '[OutboundNatRule]'},
        'resource_guid': {'key': 'properties.resourceGuid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, id=None, location=None, tags=None, frontend_ip_configurations=None, backend_address_pools=None, load_balancing_rules=None, probes=None, inbound_nat_rules=None, inbound_nat_pools=None, outbound_nat_rules=None, resource_guid=None, provisioning_state=None, etag=None):
        super(LoadBalancer, self).__init__(id=id, location=location, tags=tags)
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pools = backend_address_pools
        self.load_balancing_rules = load_balancing_rules
        self.probes = probes
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_nat_rules = outbound_nat_rules
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state
        self.etag = etag
