# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Serializer, Deserializer
from msrestazure import AzureConfiguration
from ..version import VERSION


class ComputeManagementClientConfiguration(AzureConfiguration):
    """Configuration for ComputeManagementClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials which uniquely identify
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        if subscription_id is None:
            raise ValueError("Parameter 'subscription_id' must not be None.")
        if not isinstance(subscription_id, str):
            raise TypeError("Parameter 'subscription_id' must be str.")
        if not base_url:
            base_url = 'https://management.azure.com'

        super(ComputeManagementClientConfiguration, self).__init__(base_url)

        self.add_user_agent('computemanagementclient/{}'.format(VERSION))
        self.add_user_agent('Azure-SDK-For-Python')

        self.credentials = credentials
        self.subscription_id = subscription_id


class ComputeManagementClient(object):
    """Composite Swagger for Compute Client

    :ivar config: Configuration for client.
    :vartype config: ComputeManagementClientConfiguration

    :ivar availability_sets: AvailabilitySets operations
    :vartype availability_sets: .operations.AvailabilitySetsOperations
    :ivar virtual_machine_extension_images: VirtualMachineExtensionImages operations
    :vartype virtual_machine_extension_images: .operations.VirtualMachineExtensionImagesOperations
    :ivar virtual_machine_extensions: VirtualMachineExtensions operations
    :vartype virtual_machine_extensions: .operations.VirtualMachineExtensionsOperations
    :ivar virtual_machine_images: VirtualMachineImages operations
    :vartype virtual_machine_images: .operations.VirtualMachineImagesOperations
    :ivar usage: Usage operations
    :vartype usage: .operations.UsageOperations
    :ivar virtual_machine_sizes: VirtualMachineSizes operations
    :vartype virtual_machine_sizes: .operations.VirtualMachineSizesOperations
    :ivar images: Images operations
    :vartype images: .operations.ImagesOperations
    :ivar virtual_machines: VirtualMachines operations
    :vartype virtual_machines: .operations.VirtualMachinesOperations
    :ivar virtual_machine_scale_sets: VirtualMachineScaleSets operations
    :vartype virtual_machine_scale_sets: .operations.VirtualMachineScaleSetsOperations
    :ivar virtual_machine_scale_set_vms: VirtualMachineScaleSetVMs operations
    :vartype virtual_machine_scale_set_vms: .operations.VirtualMachineScaleSetVMsOperations
    :ivar disks: Disks operations
    :vartype disks: .operations.DisksOperations
    :ivar snapshots: Snapshots operations
    :vartype snapshots: .operations.SnapshotsOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: Subscription credentials which uniquely identify
     Microsoft Azure subscription. The subscription ID forms part of the URI
     for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, api_version='2016-04-30-preview', base_url=None):

        self.config = ComputeManagementClientConfiguration(credentials, subscription_id, base_url)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in self.models(api_version).__dict__.items() if isinstance(v, type)}
        self.api_version = api_version
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

    @classmethod
    def models(cls, api_version='2016-04-30-preview'):
        if api_version =='2016-04-30-preview':
            from .v2016_04_30_preview import models
            return models
        elif api_version =='2015-06-15':
            from .v2015_06_15 import models
            return models
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))

    @property
    def availability_sets(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import AvailabilitySetsOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import AvailabilitySetsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

        self.availability_sets = AvailabilitySetsOperations(
            self._client, self.config, self._serialize, self._deserialize)

    @property
    def virtual_machine_extension_images(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineExtensionImagesOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import VirtualMachineExtensionImagesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def virtual_machine_extensions(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineExtensionsOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import VirtualMachineExtensionsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

        self.virtual_machine_extensions = VirtualMachineExtensionsOperations(
            self._client, self.config, self._serialize, self._deserialize)
    @property
    def virtual_machine_images(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineImagesOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import VirtualMachineImagesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)


    @property
    def usage(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import UsageOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import UsageOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

        self.usage = UsageOperations(
            self._client, self.config, self._serialize, self._deserialize)

    @property
    def virtual_machine_sizes(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineSizesOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import VirtualMachineSizesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def images(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import ImagesOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import ImagesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def virtual_machines(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachinesOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import VirtualMachinesOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def virtual_machine_scale_sets(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineScaleSetsOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import VirtualMachineScaleSetsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def virtual_machine_scale_set_vms(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import VirtualMachineScaleSetVMsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def disks(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import DisksOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import DisksOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)

    @property
    def snapshots(self):
        if self.api_version =='2016-04-30-preview':
            from .v2016_04_30_preview.operations import SnapshotsOperations as OperationClass
        elif self.api_version =='2015-06-15':
            from .v2015_06_15.operations import SnapshotsOperations as OperationClass
        else:
            raise NotImplementedError("APIVersion {{}} is not available".format(self.api_version))
        return OperationClass(self._client, self.config, self._serialize, self._deserialize)
