/*
 Copyright 2009-2012 Luc Saffre
 This file is part of the Lino project.
 Lino is free software; you can redistribute it and/or modify 
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.
 Lino is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 GNU General Public License for more details.
 You should have received a copy of the GNU General Public License
 along with Lino; if not, see <http://www.gnu.org/licenses/>.
*/

// lino.js --- generated Thu Jun 28 23:40:31 2012 by Lino version 1.4.4.
Ext.BLANK_IMAGE_URL = '/media/extjs/resources/images/default/s.gif';
LANGUAGE_CHOICES = [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ];
STRENGTH_CHOICES = [ [ "0", "certainly not" ], [ "1", "rather not" ], [ "2", "normally" ], [ "3", "quite much" ], [ "4", "very much" ] ];
KNOWLEDGE_CHOICES = [ [ "0", "not at all" ], [ "1", "a bit" ], [ "2", "moderate" ], [ "3", "quite well" ], [ "4", "very well" ] ];
MEDIA_URL = '/media';
ROOT_URL = '';

/* MonthPickerPlugin: thanks to keypoint @ sencha forum
   http://www.sencha.com/forum/showthread.php?74002-3.x-Ext.ux.MonthMenu&p=356860#post356860
*/
Ext.namespace('Ext.ux'); 

Ext.ux.MonthPickerPlugin = function() { 
    var picker; 
    var oldDateDefaults; 

    this.init = function(pk) { 
        picker = pk; 
        picker.onTriggerClick = picker.onTriggerClick.createSequence(onClick); 
        picker.getValue = picker.getValue.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
        picker.beforeBlur = picker.beforeBlur.createInterceptor(setDefaultMonthDay).createSequence(restoreDefaultMonthDay); 
    }; 

    function setDefaultMonthDay() { 
        oldDateDefaults = Date.defaults.d; 
        Date.defaults.d = 1; 
        return true; 
    } 

    function restoreDefaultMonthDay(ret) { 
        Date.defaults.d = oldDateDefaults; 
        return ret; 
    } 

    function onClick(e, el, opt) { 
        var p = picker.menu.picker; 
        p.activeDate = p.activeDate.getFirstDateOfMonth(); 
        if (p.value) { 
            p.value = p.value.getFirstDateOfMonth(); 
        } 

        p.showMonthPicker(); 
         
        if (!p.disabled) { 
            p.monthPicker.stopFx(); 
            p.monthPicker.show(); 

            p.mun(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mun(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
            p.onMonthClick = p.onMonthClick.createSequence(pickerClick); 
            p.onMonthDblClick = p.onMonthDblClick.createSequence(pickerDblclick); 
            p.mon(p.monthPicker, 'click', p.onMonthClick, p); 
            p.mon(p.monthPicker, 'dblclick', p.onMonthDblClick, p); 
        } 
    } 

    function pickerClick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.is('button.x-date-mp-cancel')) { 
            picker.menu.hide(); 
        } else if(el.is('button.x-date-mp-ok')) { 
            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 

    function pickerDblclick(e, t) { 
        var el = new Ext.Element(t); 
        if (el.parent() 
            && (el.parent().is('td.x-date-mp-month') 
            || el.parent().is('td.x-date-mp-year'))) { 

            var p = picker.menu.picker; 
            p.setValue(p.activeDate); 
            p.fireEvent('select', p, p.value); 
        } 
    } 
}; 

Ext.preg('monthPickerPlugin', Ext.ux.MonthPickerPlugin);  

//~ /* 
  //~ http://www.diloc.de/blog/2008/03/05/how-to-submit-ext-forms-the-right-way/
//~ */
//~ /**
 //~ * This submit action is basically the same as the normal submit action,
 //~ * only that it uses the fields getSubmitValue() to compose the values to submit,
 //~ * instead of looping over the input-tags in the form-tag of the form.
 //~ *
 //~ * To use it, just use the OOSubmit-plugin on either a FormPanel or a BasicForm,
 //~ * or explicitly call form.doAction('oosubmit');
 //~ *
 //~ * @param {Object} form
 //~ * @param {Object} options
 //~ */
//~ Ext.ux.OOSubmitAction = function(form, options){
    //~ Ext.ux.OOSubmitAction.superclass.constructor.call(this, form, options);
//~ };

//~ Ext.extend(Ext.ux.OOSubmitAction, Ext.form.Action.Submit, {
    //~ /**
    //~ * @cfg {boolean} clientValidation Determines whether a Form's fields are validated
    //~ * in a final call to {@link Ext.form.BasicForm#isValid isValid} prior to submission.
    //~ * Pass <tt>false</tt> in the Form's submit options to prevent this. If not defined, pre-submission field validation
    //~ * is performed.
    //~ */
    //~ type : 'oosubmit',

    //~ // private
    //~ /**
     //~ * This is nearly a copy of the original submit action run method
     //~ */
    //~ run : function(){
        //~ var o = this.options;
        //~ var method = this.getMethod();
        //~ var isPost = method == 'POST';

        //~ var params = this.options.params || {};
        //~ if (isPost) Ext.applyIf(params, this.form.baseParams);

        //~ //now add the form parameters
        //~ this.form.items.each(function(field)
        //~ {
            //~ if (!field.disabled)
            //~ {
                //~ //check if the form item provides a specialized getSubmitValue() and use that if available
                //~ if (typeof field.getSubmitValue == "function")
                    //~ params[field.getName()] = field.getSubmitValue();
                //~ else
                    //~ params[field.getName()] = field.getValue();
            //~ }
        //~ });

        //~ //convert params to get style if we are not post
        //~ if (!isPost) params=Ext.urlEncode(params);

        //~ if(o.clientValidation === false || this.form.isValid()){
            //~ Ext.Ajax.request(Ext.apply(this.createCallback(o), {
                //~ url:this.getUrl(!isPost),
                //~ method: method,
                //~ params:params, //add our values
                //~ isUpload: this.form.fileUpload
            //~ }));

        //~ }else if (o.clientValidation !== false){ // client validation failed
            //~ this.failureType = Ext.form.Action.CLIENT_INVALID;
            //~ this.form.afterAction(this, false);
        //~ }
    //~ },

//~ });
//~ //add our action to the registry of known actions
//~ Ext.form.Action.ACTION_TYPES['oosubmit'] = Ext.ux.OOSubmitAction;




/**
JC Watsons solution (adapted to ExtJS 3.3.1 by LS) is elegant and simple:
`A "fix" for unchecked checkbox submission  behaviour
<http://www.sencha.com/forum/showthread.php?28449>`_

Added special handling for checkbox inputs. 
ExtJS defines disabled checkboxes `readonly`, not `disabled` as for other inputs.

*/
Ext.lib.Ajax.serializeForm = function(form) {
    //~ console.log('20120203 linolib.js serializeForm',form);
    var fElements = form.elements || (document.forms[form] || Ext.getDom(form)).elements, 
        hasSubmit = false, 
        encoder = encodeURIComponent, 
        name, 
        data = '', 
        type, 
        hasValue;

    Ext.each(fElements, function(element){
        name = element.name;
        type = element.type;

        if (!element.disabled && name && !(type == 'checkbox' && element.readonly)) {
            if (/select-(one|multiple)/i.test(type)) {
                Ext.each(element.options, function(opt){
                    if (opt.selected) {
                        hasValue = opt.hasAttribute ? opt.hasAttribute('value') : opt.getAttributeNode('value').specified;
                        data += String.format("{0}={1}&", encoder(name), encoder(hasValue ? opt.value : opt.text));
                    }
                });
            } else if (!(/file|undefined|reset|button/i.test(type))) {
                //~ if (!(/radio|checkbox/i.test(type) && !element.checked) && !(type == 'submit' && hasSubmit)) {
                if (!(type == 'submit' && hasSubmit)) {
                    if (type == 'checkbox') {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&');
                        data += encoder(name) + '=' + (element.checked ? 'on' : 'off') + '&';
                    } else {
                        //~ console.log('20111001',element,'data += ',encoder(name) + '=' + encoder(element.value) + '&');
                        data += encoder(name) + '=' + encoder(element.value) + '&';
                    }
                    hasSubmit = /submit/i.test(type);
                }
            }
        //~ } else {
            //~ console.log(name,type,element.readonly);
        }
    });
    return data.substr(0, data.length - 1);
};



/*
Set a long timeout of fifteen minutes. 
See http://lino.saffre-rumma.net/blog/2012/0307.html
*/
Ext.Ajax.timeout = 15 * 60 * 1000; 


/*
My fix for the "Cannot set QuickTips dismissDelay to 0" bug,
see http://www.sencha.com/forum/showthread.php?183515 
*/
Ext.override(Ext.QuickTip,{
  showAt : function(xy){
        var t = this.activeTarget;
        //~ console.log("20120224 QuickTip.showAt",this.title,this.dismissDelay,t.dismissDelay);
        if(t){
            if(!this.rendered){
                this.render(Ext.getBody());
                this.activeTarget = t;
            }
            if(t.width){
                this.setWidth(t.width);
                this.body.setWidth(this.adjustBodyWidth(t.width - this.getFrameWidth()));
                this.measureWidth = false;
            } else{
                this.measureWidth = true;
            }
            this.setTitle(t.title || '');
            this.body.update(t.text);
            this.autoHide = t.autoHide;
            // bugfix by Luc 20120226
            if (t.dismissDelay != undefined) this.dismissDelay = t.dismissDelay;
            //~ this.dismissDelay = t.dismissDelay || this.dismissDelay;
            if(this.lastCls){
                this.el.removeClass(this.lastCls);
                delete this.lastCls;
            }
            if(t.cls){
                this.el.addClass(t.cls);
                this.lastCls = t.cls;
            }
            if(this.anchor){
                this.constrainPosition = false;
            }else if(t.align){ 
                xy = this.el.getAlignToXY(t.el, t.align);
                this.constrainPosition = false;
            }else{
                this.constrainPosition = true;
            }
        }
        Ext.QuickTip.superclass.showAt.call(this, xy);
    }
});

/*
Another hack. See /docs/blog/2012/0228
*/
Ext.Element.addMethods(
    function() {
        var VISIBILITY      = "visibility",
            DISPLAY         = "display",
            HIDDEN          = "hidden",
            NONE            = "none",
            XMASKED         = "x-masked",
            XMASKEDRELATIVE = "x-masked-relative",
            data            = Ext.Element.data;

        return {
            
            mask : function(msg, msgCls) {
                var me  = this,
                    dom = me.dom,
                    dh  = Ext.DomHelper,
                    EXTELMASKMSG = "ext-el-mask-msg",
                    el,
                    mask;
                // removed the following lines. See /docs/blog/2012/0228
                //~ if (!(/^body/i.test(dom.tagName) && me.getStyle('position') == 'static')) {
                    //~ console.log(20120228,dom.tagName,me);
                    //~ me.addClass(XMASKEDRELATIVE); 
                //~ }
                if (el = data(dom, 'maskMsg')) {
                    el.remove();
                }
                if (el = data(dom, 'mask')) {
                    el.remove();
                }

                mask = dh.append(dom, {cls : "ext-el-mask"}, true);
                data(dom, 'mask', mask);

                me.addClass(XMASKED);
                mask.setDisplayed(true);
                
                if (typeof msg == 'string') {
                    var mm = dh.append(dom, {cls : EXTELMASKMSG, cn:{tag:'div'}}, true);
                    data(dom, 'maskMsg', mm);
                    mm.dom.className = msgCls ? EXTELMASKMSG + " " + msgCls : EXTELMASKMSG;
                    mm.dom.firstChild.innerHTML = msg;
                    mm.setDisplayed(true);
                    mm.center(me);
                }
                
                
                if (Ext.isIE && !(Ext.isIE7 && Ext.isStrict) && me.getStyle('height') == 'auto') {
                    mask.setSize(undefined, me.getHeight());
                }
                
                return mask;
            }

            
        };
    }()
);



Ext.namespace('Lino');


Lino.current_window = null;
Lino.window_history = Array();

Lino.open_window = function(win,st) {
  //~ console.log("20120203 Lino.open_window()",win,st);
  var cw = Lino.current_window;
  if (cw) {
    Lino.window_history.push({
      window:cw,
      status:cw.main_item.get_status()
    });
  }
  Lino.current_window = win;
  win.main_item.set_status(st);
  win.show();
};

Lino.close_window = function(status_update) {
  var cw = Lino.current_window;
  var ww = Lino.window_history.pop();
  if (ww) {
    //~ if (status_update) Ext.apply(ww.status,status_update);
    if (status_update) status_update(ww);
    ww.window.main_item.set_status(ww.status);
    Lino.current_window = ww.window;
  } else {
    Lino.current_window = null;
  }
  if (cw) cw.hide_really();
};

Lino.close_all_windows = function() {
  if (Lino.window_history.length == 0) {
      //~ console.log("20120222 Lino.close_all_windows() : location.replace(",ROOT_URL,")");
      //~ if (ROOT_URL) 
      location.replace(ROOT_URL+"/");
  } else {
    //~ console.log("20120222 Lino.close_all_windows()",Lino.window_history);
    while (Lino.window_history.length > 0) {
      Lino.close_window();
      //~ Lino.window_history.pop().hide_really();
    }
  }
  //~ Lino.current_window = null;
  //~ Lino.close_window();
  //~ var ww = 
}

Lino.kill_current_window = function() {
  var cw = Lino.current_window;
  Lino.current_window = null;
  if (cw) cw.hide_really();
};

Lino.calling_window = function() {
    if (Lino.window_history.length) return Lino.window_history[Lino.window_history.length-1];
}

//~ Lino.WindowAction = function(mainItemClass,windowConfig,mainConfig,ppf) {
Lino.WindowAction = function(windowConfig,main_item_fn) {
    //~ if(!mainConfig) mainConfig = {};
    //~ mainConfig.is_main_window = true;
    this.windowConfig = windowConfig;
    this.main_item_fn = main_item_fn;
    //~ if (ppf) mainConfig.params_panel.fields = ppf;
    //~ this.mainConfig = mainConfig;
    //~ this.mainItemClass = mainItemClass;
};

Lino.WindowAction = Ext.extend(Lino.WindowAction,{
    window : null,
    //~ mainItemClass: null,
    get_window : function() {
      //~ if(mainConfig) Ext.apply(this.mainConfig,mainConfig);
      if (this.window == null)  {
          //~ this.windowConfig.main_item = new this.mainItemClass(this.mainConfig);
          this.windowConfig.main_item = this.main_item_fn();
          this.window = new Lino.Window(this.windowConfig);
      }
      return this.window;
    },
    run : function(status) {
      //~ console.log('20120625 window_action.run()',this)
      Lino.open_window(this.get_window(),status);
    }
  
});


Lino.PanelMixin = {
  get_containing_window : function (){
      if (this.containing_window) return this.containing_window;
      return this.containing_panel.get_containing_window();
  }
  ,set_window_title : function(title) {
    //~ this.setTitle(title);
    var cw = this.get_containing_window();

    //~ if (cw) {
    //~ if (cw && cw.closable) {
    if (cw && !cw.main_item.hide_window_title) {
      //~ console.log('20111202 set_window_title(',title,') for',this.containing_window);
      //~ if (! this.containing_window.rendered) console.log("WARNING: not rendered!");
      cw.setTitle(title);
    //~ } else {
      //~ document.title = title;
    }
    //~ else console.log('20111202 not set_window_title(',title,') for',this);
  }
  
};


Lino.status_bar = new Ext.ux.StatusBar({defaultText:'Lino version 1.4.4.'});


Lino.edit_tinymce_text = function(panel,options) {
  // `panel` is the RichTextPanel
  //~ console.log(20111220,panel);
  //~ var rec = panel.get_current_record();
  var rec = panel.containing_panel.get_current_record();
  var value = rec ? rec.data[panel.editor.name] : '';
  var saving = false;
  var todo_after_save = false;
  var discard_changes = false;
  
  
  function save() {
    //~ if (todo_after_save) {alert('tried to save again'); return; }
    if (saving) {alert('tried to save again'); return; }
    //~ var url = panel.containing_window.main_item.get_record_url(rec.id);
    var url = panel.containing_panel.get_record_url(rec.id);
    var params = Ext.apply({},panel.containing_panel.get_base_params());
    params[panel.editor.name] = editor.getValue();
    var a = { 
      params: params, 
      method: 'PUT',
      url: url,
      failure: function() {
          //~ if (editor.ed.getContainer()) 
          editor.ed.setProgressState(0);
          todo_after_save = false;
          saving = false;
          console.log('tinymce.save() failed. sorry.',arguments);
        },
      success: function() {
        saving = false;
        //~ if (editor.ed.getContainer()) 
        editor.ed.setProgressState(0);
        rec.data[panel.editor.name] = editor.getValue();
        if(todo_after_save) {
            var fn = todo_after_save;
            todo_after_save = false;
            fn();
        }
        //~ panel.containing_window.set_current_record(rec);
        panel.refresh();
      }
    };
    //~ if (editor.ed.getContainer()) 
    editor.ed.setProgressState(1); // Show progress
    saving = true;
    //~ console.log(a);
    Ext.Ajax.request(a);
  };
  function save_callback() {
      save();
      //~ save(function(){editor.ed.setDirty(false);})
      /* return true have the save button disabled.  
      That's not perfect because the PUT is asynchronous 
      and the response is not yet known.
      */
      return true;
  }
  //~ var actions = [
    //~ {text:"Save",handler:save}
  //~ ]; 
  //~ console.log(20110610,panel.editor.disabled);
  var settings = {};
  Ext.apply(settings,{
        readonly: panel.editor.disabled,
        //~ language: "de",
        plugins : "save,emotions,spellchecker,advhr,insertdatetime,preview,table,searchreplace,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "save,cancel,|,bold,italic,underline,|,justifyleft,justifycenter,justifyright,fontselect,fontsizeselect,formatselect,|,search,replace",
        theme_advanced_buttons2 : "cut,copy,paste,template,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,link,unlink,anchor,image,|,code,preview,|,forecolor,backcolor",
        theme_advanced_buttons3 : "insertdate,inserttime,|,spellchecker,advhr,,removeformat,|,sub,sup,|,charmap,emotions,|,tablecontrols",      
        theme_advanced_resizing : false,
        save_onsavecallback : save_callback,
        save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
  });
  Ext.apply(settings,options);
  var editor = new Ext.ux.TinyMCE({
      value : value,
      tinymceSettings: settings
    });
  var win = new Ext.Window({
    title: rec.title, 
    //~ bbar: actions,
    layout: 'fit',
    items: editor,
    width: 600, 
    height:500,
    minWidth: 100,
		minHeight: 100,
    modal: true,
    resizable: true,
    maximizable: true,
    //~ maximized: true,
    //~ closeAction: "close"
    closeAction: "hide"
    //~ hideMode: "offsets",
    //~ constrainHeader: true,
    //~ bodyStyle: 'padding: 10px'
  });

  //~ win.on('beforeclose',function() {
  win.on('beforehide',function() {
    if (todo_after_save) return false;
    if (discard_changes) return true;
    if (editor.isDirty()) {
        //~ var ok = false;
        //~ var allowClose = true;
        var config = {title:"Confirmation"};
        config.buttons = Ext.MessageBox.YESNOCANCEL;
        config.msg = "Save changes to text ?";
        config.modal = true;
        config.fn = function(buttonId,text,opt) {
          //~ console.log('do_when_clean',buttonId)
          if (buttonId == "yes") {
              /* we cancel this close, but save()'s onSuccess will call again.*/
              //~ allowClose = false;
              todo_after_save = function(){win.hide();}
              editor.ed.execCommand('mceSave');
              //~ editor.ed.save(function(){win.close();});
          } else if (buttonId == "no") { 
              discard_changes = true;
              win.hide()
          //~ } else if (buttonId == "cancel") { 
            //~ ok = true;
              //~ allowClose = false;
          //~ } else { 
            //~ console.log('unknwon buttonId:',buttonId);
          }
        }
        Ext.MessageBox.show(config);
        return false;
        //~ return allowClose;
    }
  });
  win.show();
}





/* 
  Originally copied from Ext JS Library 3.3.1
  Modifications by Luc Saffre : 
  - rendering of phantom records
  - fire afteredit event
  - react on dblclcik, not on single click

 */
Lino.CheckColumn = Ext.extend(Ext.grid.Column, {

    processEvent : function(name, e, grid, rowIndex, colIndex){
        //~ console.log('20110713 Lino.CheckColumn.processEvent',name)
        if (name == 'click') {
        //~ if (name == 'mousedown') {
        //~ if (name == 'dblclick') {
            return this.toggleValue(grid, rowIndex, colIndex);
        } else {
            return Ext.grid.ActionColumn.superclass.processEvent.apply(this, arguments);
        }
    },
    
    toggleValue : function (grid,rowIndex,colIndex) {
        var record = grid.store.getAt(rowIndex);
        var dataIndex = grid.colModel.getDataIndex(colIndex);
        // 20120514
        //~ if(record.data.disabled_fields && record.data.disabled_fields[dataIndex]) {
          //~ Lino.notify("This field is disabled");
          //~ return false;
        //~ }
      
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled.");
            //~ return false;
        //~ }
        var startValue = record.data[dataIndex];
        var value = !startValue;
        //~ record.set(this.dataIndex, value);
        var e = {
            grid: grid,
            record: record,
            field: dataIndex,
            originalValue: startValue,
            value: value,
            row: rowIndex,
            column: colIndex,
            cancel: false
        };
        if(grid.fireEvent("beforeedit", e) !== false && !e.cancel){
        //~ if(grid.fireEvent("validateedit", e) !== false && !e.cancel){
            record.set(dataIndex, value);
            delete e.cancel;
            grid.fireEvent("afteredit", e);
        }
        return false; // Cancel event propagation
    },

    renderer : function(v, p, record){
        if (record.phantom) return '';
        p.css += ' x-grid3-check-col-td'; 
        return String.format('<div class="x-grid3-check-col{0}">&#160;</div>', v ? '-on' : '');
    }

    // Deprecate use as a plugin. Remove in 4.0
    // init: Ext.emptyFn
});

// register ptype. Deprecate. Remove in 4.0
// Ext.preg('checkcolumn', Lino.CheckColumn);

// backwards compat. Remove in 4.0
// Ext.grid.CheckColumn = Lino.CheckColumn;

// register Column xtype
Ext.grid.Column.types.checkcolumn = Lino.CheckColumn;


/* 20110725 : 
Lino.on_tab_activate is necessary 
in contacts.Person.2.dtl 
(but don't ask me why...)
*/
Lino.on_tab_activate = function(item) {
  //~ console.log('activate',item); 
  if (item.rendered && item.doLayout) item.doLayout();
  //~ if (item.rendered) item.doLayout();
}

Lino.TimeField = Ext.extend(Ext.form.TimeField,{
  format: 'H:i',
  increment: 15
  });
Lino.DateField = Ext.extend(Ext.form.DateField,{
  format: 'd.m.Y',
  altFormats: 'd/m/Y|Y-m-d'
  });
Lino.DateTimeField = Ext.extend(Ext.ux.form.DateTime,{
  dateFormat: 'd.m.Y',
  timeFormat: 'H:i',
  //~ hiddenFormat: 'd.m.Y H:i'
  });
Lino.URLField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  vtype: 'url',
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    window.open(this.getValue(),'_blank');
  }
});
Lino.IncompleteDateField = Ext.extend(Ext.form.TextField,{
  //~ regex: /^-?\d+-[01]\d-[0123]\d$/,
  //~ regex: /^[0123]\d\.[01]\d\.-?\d+$/,
  regex: /^[0123]?\d\.[01]?\d\.-?\d+$/,
  regexText: 'Enter a date in format YYYY-MM-DD (use zeroes for unknown parts).'
  });


//~ Lino.make_dropzone = function(cmp) {
    //~ cmp.on('render', function(ct, position){
      //~ ct.el.on({
        //~ dragenter:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ return true;
        //~ }
        //~ ,dragover:function(event){
          //~ event.browserEvent.dataTransfer.dropEffect = 'move';
          //~ event.stopEvent();
          //~ return true;
        //~ }
        //~ ,drop:{
          //~ scope:this
          //~ ,fn:function(event){
            //~ event.stopEvent();
            //~ console.log(20110516);
            //~ var files = event.browserEvent.dataTransfer.files;
            //~ if(files === undefined){
              //~ return true;
            //~ }
            //~ var len = files.length;
            //~ while(--len >= 0){
              //~ console.log(files[len]);
              //~ // this.processDragAndDropFileUpload(files[len]);
            //~ }
          //~ }
        //~ }
      //~ });
    //~ });
//~ };

//~ Lino.FileUploadField = Ext.ux.form.FileUploadField;

Lino.FileUploadField = Ext.extend(Ext.ux.form.FileUploadField,{
    onRender : function(ct, position){
      Lino.FileUploadField.superclass.onRender.call(this, ct, position);
      this.el.on({
        dragenter:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          return true;
        }
        ,dragover:function(event){
          event.browserEvent.dataTransfer.dropEffect = 'move';
          event.stopEvent();
          return true;
        }
        ,drop:{
          scope:this
          ,fn:function(event){
            event.stopEvent();
            //~ console.log(20110516);
            var files = event.browserEvent.dataTransfer.files;
            if(files === undefined){
              return true;
            }
            var len = files.length;
            while(--len >= 0){
              console.log(files[len]);
              //~ this.processDragAndDropFileUpload(files[len]);
            }
          }
        }
      });
    }
});

Lino.FileField = Ext.extend(Ext.form.TriggerField,{
  triggerClass : 'x-form-search-trigger',
  editable: false,
  onTriggerClick : function() {
    //~ console.log('Lino.URLField.onTriggerClick',this.value)
    //~ document.location = this.value;
    if (this.getValue()) window.open(MEDIA_URL + '/'+this.getValue(),'_blank');
  }
});

Lino.file_field_handler = function(panel,config) {
  //~ if (instanceof Lino.DetailWrapper) {
  if (panel.action_name == 'insert') {
  //~ if (panel.get_current_record().phantom) {
      panel.has_file_upload = true;
      var f = new Lino.FileUploadField(config);
      //~ Lino.make_dropzone(f);
      return f;
      //~ return new Ext.ux.form.FileUploadField(config);
      //~ return new Lino.FileField(config);
  } else {
      //~ return new Lino.URLField(config);
      return new Lino.FileField(config);
  }
}

Lino.VBorderPanel = Ext.extend(Ext.Panel,{
    constructor : function(config) {
      config.layout = 'border';
      delete config.layoutConfig;
      Lino.VBorderPanel.superclass.constructor.call(this,config);
      for(var i=0; i < this.items.length;i++) {
        var item = this.items.get(i);
        if (this.isVertical(item) && item.collapsible) {
          item.on('collapse',this.onBodyResize,this);
          item.on('expand',this.onBodyResize,this);
        }
      }
    },
    isVertical : function(item) {
       return (item.region == 'north' || item.region == 'south' || item.region == 'center');
    },
    onBodyResize: function(w, h){
        //~ console.log('VBorderPanel.onBodyResize',this.title)
      if (this.isVisible()) { // to avoid "Uncaught TypeError: Cannot call method 'getHeight' of undefined."
        var sumflex = 0;
        var availableHeight = this.getInnerHeight();
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          //~ if (this.isVertical(item) && item.getResizeEl()) {
          if (this.isVertical(item)) {
              if (item.collapsed || item.flex == 0 || item.flex === undefined) {
                  //~ item.syncSize()
                  //~ item.doLayout()
                  //~ if (item.region == "north") console.log('region north',item.getHeight(),item.id, item);
                  //~ if (item.getHeight() == 0) console.log(20100921,'both flex and getHeight() are 0!');
                  availableHeight -= item.getHeight();
              } else {
                  sumflex += item.flex;
                  //~ console.log(item.flex);
              }
          } 
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
        var hunit = availableHeight / sumflex;
        //~ console.log('sumflex=',sumflex,'hunit=',hunit, 'availableHeight=',availableHeight);
        for(var i=0; i < this.items.length;i++) {
          var item = this.items.get(i);
          if (this.isVertical(item)) {
              if (item.flex != 0 && ! item.collapsed) {
                  item.setHeight(hunit * item.flex);
                  //~ console.log(item.region,' : height set to',item.getHeight());
              }
          }
          //~ else console.log('non-vertical item in VBoderPanel:',item)
        }
      }
      Lino.VBorderPanel.superclass.onBodyResize.call(this, w, h);
    }
});


/*
  modifications to the standard behaviour of a CellSelectionModel:
  
*/
Ext.override(Ext.grid.CellSelectionModel, {
//~ var dummy = {

    handleKeyDown : function(e){
        /* removed because F2 wouldn't pass
        if(!e.isNavKeyPress()){
            return;
        }
        */
        //~ console.log('handleKeyDown',e)
        var k = e.getKey(),
            g = this.grid,
            s = this.selection,
            sm = this,
            walk = function(row, col, step){
                return g.walkCells(
                    row,
                    col,
                    step,
                    g.isEditor && g.editing ? sm.acceptsNav : sm.isSelectable, 
                    sm
                );
            },
            cell, newCell, r, c, ae;

        switch(k){
            case e.ESC:
            case e.PAGE_UP:
            case e.PAGE_DOWN:
                break;
            default:
                // e.stopEvent(); // removed because Browser keys like Alt-Home, Ctrl-R wouldn't work
                break;
        }

        if(!s){
            cell = walk(0, 0, 1); 
            if(cell){
                this.select(cell[0], cell[1]);
            }
            return;
        }

        cell = s.cell;  
        r = cell[0];    
        c = cell[1];    
        
        switch(k){
            case e.TAB:
                if(e.shiftKey){
                    newCell = walk(r, c - 1, -1);
                }else{
                    newCell = walk(r, c + 1, 1);
                }
                break;
            case e.HOME:
                if (! (g.isEditor && g.editing)) {
                  if (!e.hasModifier()){
                      newCell = [r, 0];
                      //~ console.log('home',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var activePage = Math.ceil((t.cursor + t.pageSize) / t.pageSize);
                      if (activePage > 1) {
                          e.stopEvent();
                          t.moveFirst();
                          return;
                      }
                      newCell = [0, c];
                      break;
                  }
                }
            case e.END:
                if (! (g.isEditor && g.editing)) {
                  c = g.colModel.getColumnCount()-1;
                  if (!e.hasModifier()) {
                      newCell = [r, c];
                      //~ console.log('end',newCell);
                      break;
                  }else if(e.ctrlKey){
                      var t = g.getTopToolbar();
                      var d = t.getPageData();
                      if (d.activePage < d.pages) {
                          e.stopEvent();
                          var self = this;
                          t.on('change',function(tb,pageData) {
                              var r = g.store.getCount()-2;
                              self.select(r, c);
                              //~ console.log('change',r,c);
                          },this,{single:true});
                          t.moveLast();
                          return;
                      } else {
                          newCell = [g.store.getCount()-1, c];
                          //~ console.log('ctrl-end',newCell);
                          break;
                      }
                  }
                }
            case e.DOWN:
                newCell = walk(r + 1, c, 1);
                break;
            case e.UP:
                newCell = walk(r - 1, c, -1);
                break;
            case e.RIGHT:
                newCell = walk(r, c + 1, 1);
                break;
            case e.LEFT:
                newCell = walk(r, c - 1, -1);
                break;
            case e.F2:
                if (!e.hasModifier()) {
                    if (g.isEditor && !g.editing) {
                        g.startEditing(r, c);
                        e.stopEvent();
                        return;
                    }
                    break;
                }
            case e.INSERT:
                if (!e.hasModifier()) {
                    if (g.ls_insert_handler && !g.editing) {
                        e.stopEvent();
                        Lino.show_insert(g);
                        return;
                    }
                    break;
                }
            case e.DELETE:
                if (!e.hasModifier()) {
                    if (!g.editing) {
                        e.stopEvent();
                        Lino.delete_selected(g);
                        return;
                    }
                    break;
                }
            case e.ENTER:
                e.stopEvent();
                g.onCellDblClick(r,c);
                break;
                
        }
        

        if(newCell){
          e.stopEvent();
          r = newCell[0];
          c = newCell[1];
          this.select(r, c); 
          if(g.isEditor && g.editing){ 
            ae = g.activeEditor;
            if(ae && ae.field.triggerBlur){
                ae.field.triggerBlur();
            }
            g.startEditing(r, c);
          }
        //~ } else if (g.isEditor && !g.editing && e.charCode) {
        //~ // } else if (!e.isSpecialKey() && g.isEditor && !g.editing) {
            //~ g.set_start_value(String.fromCharCode(e.charCode));
            //~ // g.set_start_value(String.fromCharCode(k));
            //~ // g.set_start_value(e.charCode);
            //~ g.startEditing(r, c);
            //~ // e.stopEvent();
            //~ return;
        // } else {
          // console.log('20120513',e,g);
        }
        
    }


//~ };
});

 

function PseudoConsole() {
    this.log = function() {};
};
if (typeof(console) == 'undefined') console = new PseudoConsole();

Lino.notify = function(msg) {
  if (msg == undefined) msg = ''; else console.log(msg);
  //~ Ext.getCmp('konsole').update(msg);
  Lino.status_bar.setStatus({
    text: msg,
    iconCls: 'ok-icon',
    clear: true // auto-clear after a set interval
  });
  //~ Ext.getCmp('konsole').setTitle(msg.replace(/\n/g,'<br/>'));
  //~ Ext.getCmp('konsole').update(msg.replace(/\n/g,'<br/>'));
};
Lino.alert = function(msg) {
  //~ if (msg == undefined) msg = ''; else console.log(msg);
  Ext.MessageBox.alert('Notify',msg);
};


//~ Lino.show_about = function() {
  //~ new Ext.Window({
    //~ width: 400, height: 400,
    //~ title: "About",
    //~ html: '<a href="http://www.extjs.com" target="_blank">ExtJS</a> version ' + Ext.version
  //~ }).show();
//~ };

Lino.on_store_exception = function (store,type,action,options,reponse,arg) {
  console.log("on_store_exception: store=",store,
    "type=",type,
    "action=",action,
    "options=",options,
    "reponse=",reponse,
    "arg=",arg);
  if (arg) { console.log(arg.stack)};
};

//~ Lino.on_submit_success = function(form, action) {
   //~ Lino.notify(action.result.message);
   //~ this.close();
//~ };

Lino.on_submit_failure = function(form, action) {
    //~ Lino.notify();
  // action may be undefined
    switch (action.failureType) {
        case Ext.form.Action.CLIENT_INVALID:
            Ext.Msg.alert('Client-side failure', 'Form fields may not be submitted with invalid values');
            break;
        case Ext.form.Action.CONNECT_FAILURE:
            Ext.Msg.alert('Connection failure', 'Ajax communication failed');
            break;
        case Ext.form.Action.SERVER_INVALID:
            Ext.Msg.alert('Server-side failure', action.result.message);
   }
};



/*
Lino.save_wc_handler = function(ww) {
  return function(event,toolEl,panel,tc) {
    var pos = panel.getPosition();
    var size = panel.getSize();
    wc = ww.get_window_config();
    Ext.applyIf(wc,{ 
      x:pos[0],y:pos[1],height:size.height,width:size.width,
      maximized:panel.maximized});
    Lino.do_action(ww,{url:'/window_configs/'+ww.config.permalink_name,params:wc,method:'POST'});
  }
};

*/

Lino.show_in_own_window_button = function(handler) {
  return {
    qtip: "Show this panel in own window", 
    id: "up",
    handler: function(event,toolEl,panel, tc) {
      //~ console.log('20111206 report_window_button',panel,handler);
      //~ var bp = ww.get_master_params();
      //~ panel.containing_window = ww; // for HtmlBox. see blog/2010/1022
      //~ handler(panel,{base_params:bp});
      //~ handler(panel,{base_params:panel.get_master_params()});
      handler.run({base_params:panel.containing_panel.get_master_params()});
      //~ handler(panel,{master_panel:panel.containing_window.main_item});
    }
  }
}




Lino.delete_selected = function(panel) {
  //~ console.log("Lino.delete_selected",panel);
  var recs1 = panel.get_selected();
  var recs = [];
  for ( var i=0; i < recs1.length; i++ ) { if (! recs1[i].phantom) recs.push(recs1[i]); }
  if (recs.length == 0) {
    Lino.notify("Please select at least one record.");
    return;
  };
  if (recs.length == 1) {
      if (recs[0].disable_delete) {
        Lino.alert(recs[0].disable_delete);
        return;
      }
  };
  //~ console.log(recs);
  Ext.MessageBox.show({
    title: 'Confirmation',
    msg: "Delete " + String(recs.length) + " rows. Are you sure?",
    buttons: Ext.MessageBox.YESNOCANCEL,
    fn: function(btn) {
      if (btn == 'yes') {
        for ( var i=0; i < recs.length; i++ ) {
          Lino.do_action(panel,{
              method:'DELETE',
              url: ROOT_URL + '/api' + panel.ls_url + '/' + recs[i].id,
              after_success: panel.after_delete.createDelegate(panel)
          })
        }
        //~ caller.after_delete();
      }
      else Lino.notify("Dann eben nicht.");
    }
  });
};

Lino.action_handler = function (panel,on_success,on_confirm) {
  return function (response) {
    //~ console.log(20120608,panel);
    if (panel instanceof Lino.GridPanel) {
        //~ gridmode = false;
        gridmode = true;
        //~ console.log('20120608 yes');
    } else {
        gridmode = false;
        //~ console.log('20120608 no');
    }
    panel.loadMask.hide(); // 20120211
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.action_handler()','result is',result,'on_confirm is',on_confirm);
      if (on_success && result.success) on_success(result);
      if (on_confirm && result.confirm_message) {
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = result.confirm_message;
          config.fn = function(buttonId,text,opt) {
            if (buttonId == "yes") {
                on_confirm(panel,undefined,result.step);
            }
          }
          Ext.MessageBox.show(config);
          return;
      }
      if (result.message) {
          //~ if (result.alert && ! gridmode) {
          if (result.alert) { // 20120628b 
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              if (result.alert === true) result.alert = "Alert";
              Ext.MessageBox.alert(result.alert,result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      // 
      if (result.data_record && ! gridmode) {
          //~ not used
          panel.set_status({data_record:result.data_record});
      }
      else if (result.new_status && ! gridmode) {
          //~ console.log('20120607 new_status');
          panel.set_status(result.new_status);
      }
      else if (result.refresh_all) {
          var cw = panel.get_containing_window();
          //~ console.log("20120123 refresh_all");
          if (cw) {
            cw.main_item.refresh();
          }
          else console.log("20120123 cannot refresh_all",panel);
      } else {
          if (result.refresh) panel.refresh();
      }
      if (result.open_url) {
          //~ console.log(20111126,result.open_url);
          //~ if (!result.message)
              //~ Lino.notify('Open new window <a href="'+result.open_url+'" target="_blank">'+result.open_url+'</a>');
          window.open(result.open_url,'foo',"");
          //~ document.location = result.open_url;
      }
      if (result.eval_js) {
          //~ console.log(20120618,result.eval_js);
          eval(result.eval_js);
      }
    }
  }
};

Lino.do_action = function(caller,action) {
  action.success = function(response) {
    if (caller.loadMask) caller.loadMask.hide();
    //~ console.log('Lino.do_action()',action,'action success',response);
    if (action.after_success) {
        //~ console.log('Lino.do_action() calling after_success');
        action.after_success();
    }
    if (response.responseText) {
      var result = Ext.decode(response.responseText);
      //~ console.log('Lino.do_action()',action.name,'result is',result);
      if (result.message) {
          if (result.alert) {
              //~ Ext.MessageBox.alert('Alert',result.alert_msg);
              Ext.MessageBox.alert('Alert',result.message);
          } else {
              Lino.notify(result.message);
          }
      }
      
      //~ if (result.alert_msg) Ext.MessageBox.alert('Alert',result.alert_msg);
      //~ if (result.message) Lino.notify(result.message);
      if (result.notify_msg) Lino.notify(result.notify_msg);
      if (result.js_code) { 
        //~ console.log('Lino.do_action()',action,'gonna call js_code in',result);
        var jsr = result.js_code(caller);
        //~ console.log('Lino.do_action()',action,'returned from js_code in',result);
        if (action.after_js_code) {
          //~ console.log('Lino.do_action()',action,'gonna call after_js_code');
          action.after_js_code(jsr);
          //~ console.log('Lino.do_action()',action,'returned from after_js_code');
        //~ } else {
          //~ console.log('Lino.do_action()',action,' : after_js_code is false');
        }
      };
    }
  };
  Ext.applyIf(action,{
    waitMsg: 'Please wait...',
    failure: Lino.ajax_error_handler(caller)
  });
  Ext.Ajax.request(action);
};

//~ Lino.gup = function( name )
//~ {
  //~ // Thanks to http://www.netlobo.com/url_query_string_javascript.html
  //~ name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
  //~ var regexS = "[\\?&]"+name+"=([^&#]*)";
  //~ var regex = new RegExp( regexS );
  //~ var results = regex.exec( window.location.href );
  //~ if( results == null )
    //~ return "";
  //~ else
    //~ return results[1];
//~ };

//~ Lino.refresh_handler = function (ww) {
  //~ return function() { 
      //~ console.log('refresh',ww);
      //~ ww.main_item.doLayout(false,true);
      //~ ww.main_item.syncSize();
  //~ }
//~ };

//~ Lino.tools_close_handler = function (ww) {
  //~ return function() { 
      //~ ww.close();
  //~ }
//~ };
Lino.permalink_handler = function (ww) {
  return function() { 
    //~ console.log(20100923,ww.get_permalink());
    //~ document.location = ww.main_item.get_permalink();
    location.replace(ww.main_item.get_permalink());
    //~ document.location = "?permalink=" + ww.get_permalink();
    //~ document.location = "?permalink=" + ww.config.permalink_name +'()';
  }
};
//~ Lino.run_permalink = function() {
  //~ var plink = Lino.gup('permalink');
  //~ if(plink) { eval('Lino.'+plink); }
//~ }

Lino.MainPanel = {
  config_containing_window : function(wincfg) { }
  ,init_containing_window : function(win) { }
  ,do_when_clean : function(todo) { todo() }
  ,get_master_params : function() {
    var p = {}
    p['mt'] = this.content_type; 
    rec = this.get_current_record()
    if (rec) {
      if (rec.phantom) {
          p['mk'] = undefined; 
      }else{
          p['mk'] = rec.id; 
      }
    } else {
      p['mk'] = undefined;
    }
    //~ console.log('get_master_params returns',p,'using record',rec);
    return p;
  }
  ,get_permalink : function() {
    //~ var p = this.main_item.get_base_params() || {};
    var p = Ext.apply({},this.get_base_params());
    delete p.fmt;
    //~ if (p.fmt) delete p.fmt;
    Ext.apply(p,this.get_permalink_params());
     //~ p.fmt = 'html';
    //~ console.log('get_permalink',p,this.get_permalink_params());
    var url = this.get_permalink_url();
    if (Ext.urlEncode(p)) url = url + "?" + Ext.urlEncode(p);
    return url;
  }
  ,get_record_url : function(record_id) {
      var url = ROOT_URL + '/api' + this.ls_url
      //~ var url = this.containing_window.config.url_data; // ls_url;
      url += '/' + (record_id === undefined ? '-99999' : String(record_id));
      //~ if (record_id !== undefined) url += '/' + String(record_id);
      //~ url += '/' + String(record_id);
      return url;
  }
  ,get_permalink_url : function() {
      return ROOT_URL+'/api' + this.ls_url;
  }
  ,get_permalink_params : function() {
      //~ return {an:'grid'};
      var p = {};
      if (this.action_name)
          p['an'] = this.action_name;
      this.add_param_values(p)
      return p;
  }
  ,set_status : function(status) {}
  ,get_status : function() { return {}}
  ,refresh : function() {}
  ,get_base_params : function() { return {}}
  ,add_params_panel : function (tbar) {
      if (this.params_panel) {
        tbar = tbar.concat([{ scope:this, 
          text: "[parameters]", // gear
          enableToggle: true,
          pressed: ! this.params_panel.hidden,
          toggleHandler: function(btn,state) { 
            //~ if (this.params_panel.isVisible()) 
                //~ this.params_panel.hide();
            //~ else
                //~ this.params_panel.show();
            //~ console.log("20120210 add_params_panel",state,this.params_panel);
            if (state) {
              this.params_panel.show();
              this.params_panel.doLayout();
            } else this.params_panel.hide();
            this.get_containing_window().doLayout();
          }
        }]);
        var t = this;
        Ext.each(this.params_panel.fields,function(f) {
          //~ f.on('valid',function() {t.refresh()});
          if (f instanceof Ext.form.Checkbox)
              f.on('check',function() {t.refresh()});
          else if (f instanceof Ext.form.TriggerField)
              f.on('select',function() {t.refresh()});
          else
              f.on('change',function() {t.refresh()});
          });
      }
      return tbar;
  }
  ,add_param_values : function (p) {
    if (this.params_panel) {
      //~ var formdata = Lino.form2dict(this.params_panel);
      //~ console.log('20120203 add_param_values formdata', formdata);
      //~ p.pv = formdata;
      //~ return;
      //~ var formdata = Ext.lib.Ajax.serializeForm(frm);
      var fields = this.params_panel.fields;
      //~ console.log('20120116 gonna loop on', fields);
      var pv = Array(fields.length);
      for(var i=0; i < fields.length;i++) {
          var f = fields[i]
          if (f.formatDate) {
              pv[i] = f.formatDate(f.getValue()); 
          } else {
              pv[i] = f.getValue(); 
          }
      }
      p.pv = pv;
      //~ console.log("20120203 add_param_values added pv",pv,"to",p);
    }
    
  },
  set_param_values : function(pv) {
    //~ console.log('20120203 set_param_values', pv);
    if (this.params_panel) {
      if (pv) this.params_panel.form.my_loadRecord(pv);
      else this.params_panel.form.reset(); 
      
      //~ var fields = this.params_panel.fields;
      //~ console.log('20120116 gonna loop on', fields);
      //~ for(var i=0; i < fields.length;i++) {
          //~ var f = fields[i]
          //~ f.setValue(pv[i]); 
      //~ }
      //~ this.refresh();
      //~ console.log(20120113,options);
    }
    //~ var test = {test:"foo"};
    //~ this.add_param_values(test);
    //~ console.log('20120203 set_param_values test is ', test);
  }
};


Lino.ajax_error_handler = function(panel) {
  return function(response,options) {
    console.log('Ajax failure:',response,options);
    if (panel.loadMask) panel.loadMask.hide();
    if (response.responseText) {
      var lines = response.responseText.split('\n');
      if (lines.length > 10) {
          line = lines.splice(5,lines.length-10,"(...)");
      }
      Ext.MessageBox.alert(
        response.statusText,
        lines.join('<br/>')
        //~ response.responseText.replace(/\n/g,'<br/>'))
      )
    } else {
      Ext.MessageBox.alert('Action failed',
        'Lino server did not respond to Ajax request');
    }
  }
}
// Ext.Ajax.on('requestexception',Lino.ajax_error_handler)
 

Ext.QuickTips.init();

/* setting QuickTips dismissDelay to 0 */
// Apply a set of config properties to the singleton
//~ Ext.apply(Ext.QuickTips.getQuickTip(), {
//~ Ext.apply(Ext.ToolTip, {
    //~ dismissDelay: 0
    //~ autoHide: false,
    //~ closable: true,
    //~ maxWidth: 200,
    //~ minWidth: 100,
    //~ showDelay: 50      // Show 50ms after entering target
    //~ ,trackMouse: true
//~ });


//~ Ext.apply(Ext.QuickTip, {
    //~ dismissDelay: 0,
//~ });
  
Lino.quicktip_renderer = function(title,body) {
  return function(c) {
    var t = c.getEl();
    //~ t.dismissDelay = 0;
    Ext.QuickTips.register({
      target: t,
      //~ cls: 'lino-quicktip-classical',
      dismissDelay: 0,
      //~ autoHide: false,
      showDelay: 50,      // Show 50ms after entering target
      //~ title: title,
      text: body
    });
  }
};

  
Lino.help_text_editor = function() {
  //~ var bp = {
      //~ mk:this.content_type,
      //~ mt:1
    //~ };
    //~ console.log(20120202,bp);
  //~ Lino.lino.ContentTypes.detail({},{base_params:bp});
  Lino.lino.ContentTypes.detail_action.run({record_id:this.content_type});
}

// Path to the blank image should point to a valid location on your server
//~ Ext.BLANK_IMAGE_URL = MEDIA_URL + '/extjs/resources/images/default/s.gif'; 


// used as Ext.grid.Column.renderer for id columns in order to hide the special id value -99999
Lino.id_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  return value;
}

Lino.raw_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  return value;
}

Lino.text_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return "not implemented"; 
  return value;
}

//~ Lino.hide_zero_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ console.log("20120510");
  //~ if (value == 0) return ''
  //~ return value;
//~ }

//~ Lino.cell_button_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ return '<input type="button" onclick="alert(value)" value=" ? ">' ;
//~ }


//~ Lino.default_renderer = function(value, metaData, record, rowIndex, colIndex, store) {
  //~ if (record.phantom) return '';
  //~ return value;
//~ }

Lino.fk_renderer = function(fkname,handlername) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    //~ if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '.run({record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

Lino.lfk_renderer = function(panel,fkname) {
  //~ console.log('Lino.fk_renderer handler=',handler);
  var handlername = 'console.log';
  return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ console.log('Lino.fk_renderer',fkname,rowIndex,colIndex,record,metaData,store);
    if (record.phantom) return '';
    if (value) {
        var s = '<a href="javascript:' ;
        s += handlername + '({},{record_id:\'' + String(record.data[fkname]) + '\'})">';
        s += value + '</a>';
        //~ console.log('Lino.fk_renderer',value,'-->',s);
        return s
    }
    return '';
  }
};

//~ Lino.gfk_renderer = function() {
  //~ return function(value, metaData, record, rowIndex, colIndex, store) {
    //~ if (record.phantom) return '';
    //~ console.log('Lino.gfk_renderer',value,colIndex,record,metaData,store);
    //~ return value;
  //~ }
//~ };


Lino.build_buttons = function(panel,actions) {
  if (actions) {
    var buttons = Array(actions.length);
    var cmenu = Array(actions.length);
    for (var i=0; i < actions.length; i++) { 
      buttons[i] = new Ext.Toolbar.Button(actions[i]);
      cmenu[i] = actions[i]
      if (actions[i].panel_btn_handler) {
          var h = actions[i].panel_btn_handler.createCallback(panel,buttons[i]);
          if (actions[i].must_save) {
              //~ buttons[i].on('click',function() { panel.do_when_clean(h) });
              buttons[i].on('click',panel.do_when_clean.createDelegate(panel,[h]));
          } else {
              buttons[i].on('click',h);
          }
          cmenu[i].handler = actions[i].panel_btn_handler.createCallback(panel,cmenu[i]);
      }
    }
    return {bbar:buttons, cmenu:new Ext.menu.Menu(cmenu)};
  }
}

Lino.do_when_visible = function(cmp,todo) {
  //~ if (cmp.el && cmp.el.dom) 
  if (cmp.isVisible()) { 
    // 'visible' means 'rendered and not hidden'
    //~ console.log(cmp.title,'-> cmp is visible now');
    todo(); 
  //~ } else {
      //~ cmp.on('resize',todo,cmp,{single:true});
  //~ }
  //~ if (false) { // 20120213
  } else { 
    //~ console.log('Lino.do_when_visible() must defer because not isVisible()',todo,cmp);
    if (cmp.rendered) {
      //~ console.log(cmp,'-> cmp is rendered but not visible: and now?');
      //~ console.log(cmp.title,'-> cmp is rendered but not visible: try again in a moment...');
      //~ var fn = function() {Lino.do_when_visible(cmp,todo)};
      //~ fn.defer(100);
      
      Lino.do_when_visible.defer(50,this,[cmp,todo]);
      //~ Lino.do_when_visible.defer(100,this,[cmp,todo]);
      
    } else {
      //~ console.log(cmp.title,'-> after render');
      cmp.on('afterrender',todo,cmp,{single:true});
    }
  }
  
};    

/*
*/
Lino.do_on_current_record = function(panel,fn,phantom_fn) {
  var rec = panel.get_current_record();
  if (rec == undefined) {
    Lino.notify("There's no selected record.");
    return;
  }
  // 20120307 A VirtualTable with a Detail (lino.Models) has only "phantom" records.
  if (rec.phantom) {
    //~ if (!panel.editable) { console.log("20120312 not editable:",panel)}
    if (phantom_fn) {
      phantom_fn(panel);
    } else {
      Lino.notify("Action not available on phantom record.");
    }
    return;
  }
  return fn(rec);
};


Lino.call_row_action = function(panel,rec_id,actionName,step,fn) {
  var url = panel.get_record_url(rec_id);
  var p = Ext.apply({},panel.get_base_params());
  p['an'] = actionName;
  if (step) p['as'] = step;
  panel.loadMask.show(); 
  Ext.Ajax.request({
    method: 'GET',
    url: url,
    params: p,
    success: Lino.action_handler(panel,undefined,fn)
  });
};

Lino.row_action_handler = function(actionName) {
  var fn = function(panel,btn,step) {
    Lino.do_on_current_record(panel,function(rec) {
      //~ console.log(panel);
      Lino.call_row_action(panel,rec.id,actionName,step,fn);
    });
  };
  return fn;
};


Lino.run_row_action = function(rp,action,url,pk,actionName) {
  //~ var panel = action.get_window().main_item;
  var panel = Ext.getCmp(rp);
  var fn = function(panel,btn,step) {
    Lino.call_row_action(panel,pk,actionName,step,fn);
  }
  fn(panel,null,null);
}


Lino.list_action_handler = function(actionName,gridmode) {
  var fn = function(panel,btn,step) {
    //~ console.log(panel);
    var url = ROOT_URL + '/api' + panel.ls_url ;
    var p = Ext.apply({},panel.get_base_params());
    p['an'] = actionName;
    if (step) p['as'] = step;
    panel.loadMask.show(); // 20120211
    Ext.Ajax.request({
      method: 'GET',
      url: url,
      params: p,
      success: Lino.action_handler(panel,undefined,fn)
    });
  };
  return fn;
};

Lino.show_detail = function(panel,btn) {
  Lino.do_on_current_record(panel, 
    function(rec) {
      //~ panel.loadMask.show();
      panel.ls_detail_handler.run({
        record_id:rec.id,
        base_params:panel.get_base_params()
      });
      //~ panel.loadMask.hide();
      //~ panel.containing_window.window.hideMask();
      //~ panel.el.unmask();
    },
    Lino.show_insert
  );
};

Lino.show_fk_detail = function(combo,detail_action) {
    //~ console.log("Lino.show_fk_detail",combo,handler);
    pk = combo.getValue();
    if (pk) {
        detail_action.run({record_id: pk})
      } else {
        Lino.notify("Cannot show detail for empty foreign key.");
      }
};

Lino.show_insert = function(panel,btn) {
  var bp = panel.get_base_params();
  //~ console.log('20120125 Lino.show_insert',bp)
  panel.ls_insert_handler.run({record_id:-99999,base_params:bp});
};

Lino.show_insert_duplicate = function(panel,btn) {
  Lino.do_on_current_record(panel,
    function(rec) {
      var newRec = {};
      Ext.apply(newRec,rec);
      newRec.id = -99999;
      panel.ls_insert_handler.run({data_record:rec});
    });
};

//~ Lino.update_row_handler = function(action_name) {
  //~ return function(panel,btn) {
    //~ Lino.notify("Sorry, " + action_name + " is not implemented.");
  //~ }
//~ };



if (Ext.ux.grid !== undefined) {
    Lino.GridFilters = Ext.extend(Ext.ux.grid.GridFilters,{
      encode:true,
      local:false
    });
} else {
    Lino.GridFilters = function() {}; // dummy
    Ext.override(Lino.GridFilters,{
      init : function() {}
    });
};


//~ Lino.ButtonField = Ext.extend(Ext.form.TextField,{
//~ Lino.ButtonField = Ext.extend(Ext.form.Field,{
    //~ editable : false,
    //~ constructor : function(ww,config,params){
      //~ this.containing_window = ww;
      //~ if (params) Ext.apply(config,params);
      //~ Lino.ButtonField.superclass.constructor.call(this, config);
    //~ },
    //~ setButtons : function(buttons){
      //~ console.log('setButtons',buttons);
    //~ },
    //~ onRender : function(ct, position){
        //~ if(!this.el){
            //~ this.panel = new Ext.Container({items:[
              //~ {xtype:'button',text:'upload'},
              //~ {xtype:'button',text:'show'},
              //~ {xtype:'button',text:'edit'}
            //~ ]});
            //~ this.panel.ownerCt = this;
            //~ this.el = this.panel.getEl();

        //~ }
        //~ Lino.ButtonField.superclass.onRender.call(this, ct, position);
    //~ },

  
//~ });

Lino.FieldBoxMixin = {
  before_init : function(config,params) {
    if (params) Ext.apply(config,params);
    var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    if (actions) config.bbar = actions.bbar;
  },
  //~ constructor : function(ww,config,params){
    //~ this.containing_window = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  do_when_clean : function(todo) { todo() },
  //~ format_data : function(html) { return '<div class="htmlText">' + html + '</div>' },
  format_data : function(html) { return html },
  get_base_params : function() {
    // needed for insert action
    return this.base_params;
  },
  set_base_params : function(p) {
    this.base_params = Ext.apply({},p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  }
};



Lino.HtmlBoxPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);
Lino.HtmlBoxPanel = Ext.extend(Lino.HtmlBoxPanel,{
  disabled_in_insert_window : true,
  constructor : function(config,params) {
    this.before_init(config,params);
    Lino.HtmlBoxPanel.superclass.constructor.call(this, config);
  },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.constructor.call(this, ww,config,params);
  //~ },
  //~ constructor : function(ww,config,params){
    //~ this.ww = ww;
    //~ if (params) Ext.apply(config,params);
    //~ var actions = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ if (actions) config.bbar = actions.bbar;
    //~ Lino.FieldBoxMixin.superclass.constructor.call(this, config);
  //~ },
  //~ disable : function() { var tb = this.getBottomToolbar(); if(tb) tb.disable()},
  //~ enable : function() { var tb = this.getBottomToolbar(); if(tb) tb.enable()},
  onRender : function(ct, position){
    Lino.HtmlBoxPanel.superclass.onRender.call(this, ct, position);
    //~ console.log(20111125,this.containing_window);
    if (this.containing_panel) {
      this.containing_panel.on('enable',this.enable,this);
      this.containing_panel.on('disable',this.disable,this);
    }
    this.el.on({
      dragenter:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        return true;
      }
      ,dragover:function(event){
        event.browserEvent.dataTransfer.dropEffect = 'move';
        event.stopEvent();
        return true;
      }
      ,drop:{
        scope:this
        ,fn:function(event){
          event.stopEvent();
          console.log(20110516);
          var files = event.browserEvent.dataTransfer.files;
          if(files === undefined){
            return true;
          }
          var len = files.length;
          while(--len >= 0){
            console.log(files[len]);
            //~ this.processDragAndDropFileUpload(files[len]);
          }
          Lino.show_insert(this);
        }
      }
    });
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    //~ if (this.master_panel) {
      var record = this.containing_panel.get_current_record();
      //~ console.log('HtmlBox.refresh()',this.title,record,record.title);
      var box = this.items.get(0);
      var todo = function() {
        if (this.disabled) return;
        //~ this.set_base_params(this.containing_window.get_base_params());
        this.set_base_params(this.containing_panel.get_master_params());
        var el = box.getEl();
        if (el) {
          el.update(record ? this.format_data(record.data[this.name]) : '');
          //~ console.log('HtmlBox.refresh()',this.name);
        //~ } else {
          //~ console.log('HtmlBox.refresh() failed for',this.name);
        }
      };
      //~ Lino.do_when_visible(this,todo.createDelegate(this));
      Lino.do_when_visible(box,todo.createDelegate(this));
    //~ }
  }
});
//~ Ext.override(Lino.HtmlBoxPanel,Lino.FieldBoxMixin);


Lino.RichTextPanel = Ext.extend(Ext.Panel,Lino.PanelMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,Lino.FieldBoxMixin);
Lino.RichTextPanel = Ext.extend(Lino.RichTextPanel,{
    
  //~ initComponent : function(){
    //~ Lino.RichTextPanel.superclass.initComponent.call(this);
  //~ },
  constructor : function(config,params) {
    //~ console.log('Lino.RichTextPanel.initComponent',this);
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + String(rec.id) + "/" + config.name;
    //~ var url = TEMPLATES_URL + config.ls_url + "/" + config.name;
    var t = this;
    var tinymce_options = {
        theme : "advanced",
        content_css: ROOT_URL + '/media/lino/extjs/lino.css',
        language: 'en',
        //~ template_external_list_url : url,
        theme_advanced_toolbar_location : "top",
        theme_advanced_toolbar_align : "left",
        theme_advanced_statusbar_location : "bottom",
        template_popup_width : 700,
        template_popup_height : 500,
        template_replace_values : { 
            data_field : function(element){ 
                //~ console.log(20110722,fieldName,t.containing_window.get_current_record()); 
                var fieldName = element.innerHTML;
                element.innerHTML = t.containing_panel.get_current_record().data[fieldName];
            } 
        }
      };
      
    var editorConfig = {
      tinymceSettings: {
        plugins : "noneditable,template", 
        // Theme options - button# indicated the row# only
        theme_advanced_buttons1 : "bold,italic,underline,|,justifyleft,justifycenter,justifyright,|,bullist,numlist,|,outdent,indent,|,undo,redo,|,removeformat,template",
        theme_advanced_buttons2 : "",
        theme_advanced_buttons3 : "", // ,|,sub,sup,|,charmap",      
        theme_advanced_resizing : false
        //~ save_onsavecallback : save_callback,
        //~ save_enablewhendirty : true
        //~ save_oncancelcallback: on_cancel
        
    }};
    Ext.apply(editorConfig.tinymceSettings,tinymce_options);
    //~ editorConfig.name = config.action_name;
    editorConfig.name = config.name;
    delete config.name;
    //~ config.title = config.label;
    //~ delete config.label;
    this.before_init(config,params);
    
    this.editor = new Ext.ux.TinyMCE(editorConfig);
    var t = this;
    config.tools = [{
                      qtip: "Edit text in own window", 
                      id: "up",
                      handler: function(){
                        if(t.editor.isDirty()) {
                            var record = t.containing_panel.get_current_record();
                            record.data[t.editor.name] = t.editor.getValue();
                        }
                        Lino.edit_tinymce_text(t,tinymce_options)
                      }
                    }];
    
    config.items = this.editor;
    config.layout = "fit";
    Lino.RichTextPanel.superclass.constructor.call(this, config);
  },
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) {
    var record = this.containing_panel.get_current_record();
    //~ console.log('RichTextPanel.refresh()',this.title,record.title,record);
    var todo = function() {
      //~ this.set_base_params(this.containing_window.get_base_params());
      if (record) {
        var url = ROOT_URL + '/templates' + this.containing_panel.ls_url + "/" 
            + String(record.id) + "/" + this.editor.name;
        //~ console.log('RichTextPanel.refresh()',url);
        if (this.editor.ed) this.editor.ed.settings.template_external_list_url = url;
        this.set_base_params(this.containing_panel.get_master_params());
        //~ var v = record ? this.format_data(record.data[this.editor.name]) : ''
        var v = this.format_data(record.data[this.editor.name])
        this.editor.setValue(v);
      } else {
        this.editor.setValue('(no data)');
      }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
//~ Ext.override(Lino.RichTextPanel,Lino.FieldBoxMixin);


Lino.FormPanel = Ext.extend(Ext.form.FormPanel,Lino.MainPanel);
Lino.FormPanel = Ext.extend(Lino.FormPanel,Lino.PanelMixin);
Lino.FormPanel = Ext.extend(Lino.FormPanel,{
  params_panel_hidden : false,
  base_params : {},
  //~ trackResetOnLoad : true,
  //~ query_params : {},
  //~ 20110119b quick_search_text : '',
  constructor : function(config,params){
    if (params) Ext.apply(config,params);
    //~ ww.config.base_params.query = ''; // 20111018
    //~ console.log(config);
    //~ console.log('FormPanel.constructor() 1',config)
    //~ Ext.applyIf(config,{base_params:{}});
    //~ console.log('FormPanel.constructor() 2',config)
      
    config.trackResetOnLoad = true;
    
    Lino.FormPanel.superclass.constructor.call(this, config);
      
    this.set_base_param('query',''); // 20111018
      
  },
  initComponent : function(){
    
    //~ console.log("20111201 containing_window",this.containing_window,this);
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    this.bbar = actions.bbar;
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar = Lino.build_buttons(this,config.ls_bbar_actions);
    var config = this;
    
    //~ if (this.containing_window instanceof Lino.DetailWrapper) {
    
    //~ console.log('20120121 initComponent', this.action_name);
    //~ if (this.action_name == 'detail' | this.action_name == 'show') {
    //~ if (this.action_name != 'insert') {
    if (! this.hide_top_toolbar) {
      this.tbar = [];
      // 20111015    
      if (! this.hide_navigator) {
        this.record_selector = new Lino.RemoteComboFieldElement({
          store: new Lino.ComplexRemoteComboStore({
            //~ baseParams: config.containing_window.config.base_params,
            baseParams: this.get_base_params(),
            //~ value: this.containing_window.config.base_params.query,
            proxy: new Ext.data.HttpProxy({
              url: ROOT_URL + '/choices' + config.ls_url,
              method:'GET'
            })
          }),
          pageSize:25,
          listeners: { 
            scope:this, 
            select:function(combo,record,index) {
              //~ console.log('jumpto_select',arguments);
              this.goto_record_id(record.id);
            }
          },
          emptyText: "Go to record"
        })
        config.tbar = config.tbar.concat([this.record_selector]);
        
        config.tbar = config.tbar.concat([
          this.first = new Ext.Toolbar.Button({
            tooltip:"First",disabled:true,handler:this.moveFirst,scope:this,iconCls:'x-tbar-page-first'}),
          this.prev = new Ext.Toolbar.Button({
            tooltip:"Previous",disabled:true,handler:this.movePrev,scope:this,iconCls:'x-tbar-page-prev'}),
          this.next = new Ext.Toolbar.Button({
            tooltip:"Next",disabled:true,handler:this.moveNext,scope:this,iconCls:'x-tbar-page-next'}),
          this.last = new Ext.Toolbar.Button({
            tooltip:"Last",disabled:true,handler:this.moveLast,scope:this,iconCls:'x-tbar-page-last'})
        ]);
      }
      config.tbar = this.add_params_panel(config.tbar);
      
      //~ console.log(20101117,this.containing_window.refresh);
      config.tbar = config.tbar.concat([
        {
          //~ text:'Refresh',
          handler:function(){ this.do_when_clean(this.refresh.createDelegate(this)) },
          iconCls: 'x-tbar-loading',
          tooltip:"Reload current record",
          scope:this}
      ]);
          
      config.tbar = config.tbar.concat([
          '->',
          this.displayItem = new Ext.Toolbar.TextItem({})
      ]);
          
    }
    if (config.content_type) {
      config.bbar = config.bbar.concat([
        '->',
        { text: '[Help Text Editor]',
          handler: Lino.help_text_editor,
          qtip: "Edit help texts for fields on this model.",
          scope: this}
        //~ ,{ text: '[Layout Editor]',
          //~ handler: this.edit_detail_config,
          //~ qtip: "Edit Detail layout",
          //~ scope: this}
      ])
    }
    //~ this.before_row_edit = config.before_row_edit.createDelegate(this);
      
    //~ if (this.master_panel) {
        //~ this.set_base_params(this.master_panel.get_master_params());
    //~ }
      
    Lino.FormPanel.superclass.initComponent.call(this);
    
    this.on('render',function(){
      this.loadMask = new Ext.LoadMask(this.bwrap,{msg:"Please wait..."});
    },this);
    
    
    //~ var this_ = this;
    //~ this.cascade(function(cmp){
      //~ // var active_field = false;
      //~ for (i = 0; i < this_.active_fields.length; i++) {
        //~ if (cmp.name == this_.active_fields[i]) {
            //~ // active_field = true; break;
            //~ cmp.on("change",function() {this_.save()});
        //~ }
      //~ };
      //~ if (active_field) {
      // if (cmp instanceof Lino.GridPanel) {
          //~ cmp.on("change",function() {this_.save()});
      //~ }
    //~ });
    
    if (this.action_name == 'insert') {
      this.cascade(function(cmp){
        // console.log('20110613 cascade',cmp);
        if (cmp.disabled_in_insert_window) {
            //~ cmp.disable();
            cmp.hide();
        }
      });
      
    }
    
  },
  
  get_status : function(){
      var st = {
        base_params: this.get_base_params(),
        data_record : this.get_current_record()
        }
      var tp = this.items.get(0);
      if (tp instanceof Ext.TabPanel) {
        st.active_tab = tp.getActiveTab();
      }
      return st;
  },
  set_status : function(status){
    //~ console.log('20120622 FormPanel.set_status()',this,status);
    this.clear_base_params();
    if (status == undefined) status = {};
    if (status.param_values) this.set_param_values(status.param_values);
    if (status.base_params) this.set_base_params(status.base_params);
    var tp = this.items.get(0);
    if (tp instanceof Ext.TabPanel) {
      if (status.active_tab) {
        //~ console.log('20111201 active_tab',this.active_tab,this.items.get(0));
        //~ tp.activeTab = status.active_tab;
        tp.setActiveTab(status.active_tab);
        //~ this.main_item.items.get(0).activate(status.active_tab);
      } else {
        tp.setActiveTab(0);
      }
      }
    
    if (status.data_record) {
      //~ console.log('20111201 Lino.FormPanel with data_record',this.data_record.title,this.containing_window);
      //~ this.main_item.on_master_changed.defer(2000,this.main_item,[status.data_record]);
      //~ Lino.do_when_visible(this.main_item,function(){this.on_master_changed(status.data_record)});
      //~ this.main_item.on('afterrender',function(){
      //~   this.main_item.on_master_changed(status.data_record)},this,{single:true});
      /* must defer because because set_window_title() didn't work otherwise */
      this.set_current_record.createDelegate(this,[status.data_record]).defer(100);
      //~ this.set_current_record(this.data_record);
      //~ return;
    } else if (status.record_id != undefined) { 
      /* possible values include 0 and null, 0 being a valid record id, 
      null the equivalent of undefined
      */
      //~ this.main_item.goto_record_id(this.status.record_id);
      this.load_record_id(status.record_id);
    } else {
      this.set_current_record(undefined);
    }
  },
    
  get_base_params : function() {
    // needed for insert action
    return this.base_params;
  },
  set_base_params : function(p) {
    //~ this.base_params = Ext.apply({},p);
    Ext.apply(this.base_params,p);
    //~ if (p.param_values) this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.base_params = {};
  },
  set_base_param : function(k,v) {
    this.base_params[k] = v;
  },
  
  after_delete : function() {
    if (this.current_record.navinfo.next)
      this.moveNext();
    else if (this.current_record.navinfo.prev)
      this.movePrev();
    else 
      this.abandon();
  },
  moveFirst : function() {this.goto_record_id(this.current_record.navinfo.first)},
  movePrev : function() {this.goto_record_id(this.current_record.navinfo.prev)},
  moveNext : function() {this.goto_record_id(this.current_record.navinfo.next)},
  moveLast : function() {this.goto_record_id(this.current_record.navinfo.last)},
  
  
  refresh : function(unused) { 
      this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ console.log('20120121 Lino.FormPanel.refresh()',this);
    if (this.current_record) {
        this.load_record_id(this.current_record.id,after);
    } else {
        this.set_current_record(undefined,after);
    }
  },
  
  do_when_clean : function(todo) {
    var this_ = this;
    if (this.form.isDirty()) {
        if (this.auto_save) {
            this_.save(todo);
        } else {
          //~ console.log('20111217 do_when_clean() form is dirty',this.form);
          var config = {title:"Confirmation"};
          config.buttons = Ext.MessageBox.YESNOCANCEL;
          config.msg = "Save changes to current record ?";
          config.fn = function(buttonId,text,opt) {
            //~ console.log('do_when_clean',buttonId)
            if (buttonId == "yes") {
                //~ Lino.submit_detail(this_,undefined,todo);
                //~ this_.containing_window.save(todo);
                this_.save(todo);
            } else if (buttonId == "no") { 
              todo();
            }
          }
        }
        Ext.MessageBox.show(config);
    }else{
      //~ console.log('do_when_clean : now!')
      todo();
    }
  },
  
  goto_record_id : function(record_id) {
    //~ console.log('20110701 Lino.FormPanel.goto_record_id()',record_id);
    //~ var this_ = this;
    //~ this.do_when_clean(function() { this_.load_record_id(record_id) }
    this.do_when_clean(this.load_record_id.createDelegate(this,[record_id]));
  },
  
  load_record_id : function(record_id,after) {
    var this_ = this;
    //~ var p = { fmt: this.containing_window.config.action_name};
    //~ var p = Ext.apply({},this.containing_window.config.base_params);
    var p = Ext.apply({},this.get_base_params());
    //~ console.log('20110713 action_name=',this.containing_window.config.action_name,
      //~ 'base_params=',this.containing_window.config.base_params);
    if (this.action_name)
        p.an = this.action_name;
    //~ p.an = this.action_name;
    //~ p.an = this.containing_window.config.action_name;
    //~ p.fmt = 'json';
    //~ p.fmt = 'json';
    p.rp = this.getId();
    p.fmt = 'json';
    //~ 20110119b p['query'] = this.quick_search_text;
    //~ Ext.apply(p,this.query_params);
    this.add_param_values(p);
    //~ console.log('20120622 load_record_id',record_id,p);
    if (this.loadMask) this.loadMask.show();
    Ext.Ajax.request({ 
      waitMsg: 'Loading record...',
      method: 'GET',
      params: p,
      scope: this,
      url: this.get_record_url(record_id),
      success: function(response) {   
        // todo: convert to Lino.action_handler.... but result 
        if (this.loadMask) this.loadMask.hide();
        if (response.responseText) {
          var rec = Ext.decode(response.responseText);
          //~ console.log('goto_record_id success',rec);
          if (rec.navinfo && rec.navinfo.recno == 0) {
              /* 
                recno 0 means "the requested pk exists but is not contained in the requested queryset".
                This can happen e.g. after search_change on a detail.
              */
              //~ this_.goto_record_id(rec.navinfo.first);
              if (rec.navinfo.first) {
                  this.load_record_id(rec.navinfo.first);
              } else this.abandon();
                  
          } else {
              this.set_current_record(rec,after);
          }
        }
      },
      failure: Lino.ajax_error_handler(this)
    });
  },

  abandon : function () {
    Ext.MessageBox.alert('Note',
      "No more records to display. Detail window has been closed.");
    Lino.close_window();
    //~ if (this.containing_window) {
        //~ this.containing_window.hide();
    //~ }
  },
  
  set_current_record : function(record,after) {
    //~ console.log('20111201 Lino.FormPanel.set_current_record',record.title,record);
    if (this.record_selector) {
        this.record_selector.clearValue();
        // e.g. InsertWrapper FormPanel doesn't have a record_selector
    }
    this.current_record = record;
    //~ if (record) 
        //~ console.log('Lino.FormPanel.set_current_record',record.title,record);
    //~ else
        //~ console.log('Lino.FormPanel.set_current_record',record);
    //~ this.config.main_panel.form.load(record);    
    if (record) {
      this.enable();
      this.form.my_loadRecord(record.data);
      this.set_window_title(record.title);
      this.getBottomToolbar().enable();
      var da = record.data.disabled_actions;
      if (da) {
          //~ console.log('20120528 disabled_actions =',da,this.getBottomToolbar());
          this.getBottomToolbar().items.each(function(item,index,length){
              //~ console.log('20120528 ',item.itemId,'-->',da[item.itemId]);
              if (da[item.itemId]) item.disable(); else item.enable();
          });
      };
      if (record.data.disable_editing) {
          //~ console.log("20120202 disable_editing",record.title);
          this.form.items.each(function(cmp){
            if (!cmp.always_enabled) cmp.disable();
          },this);
      } else {
          this.form.items.each(function(cmp){
            //~ console.log("20120202",cmp);
            if (record.data.disabled_fields[cmp.name]) cmp.disable();
            else cmp.enable();
          },this);
        
          //~ if (record.data.disabled_fields) {
              //~ for (i = 0; i < record.data.disabled_fields.length; i++) {
                  //~ var flds = this.find('name',record.data.disabled_fields[i]);
                  //~ if (flds.length == 1) { 
                    //~ flds[0].disable(); 
                  //~ }
              //~ }
          //~ }
      };
      
      if (! this.hide_navigator && record.navinfo) {
        this.first.setDisabled(!record.navinfo.first);
        this.prev.setDisabled(!record.navinfo.prev);
        this.next.setDisabled(!record.navinfo.next);
        this.last.setDisabled(!record.navinfo.last);
        this.displayItem.setText(record.navinfo.message);
      }
    } else {
      if (this.form.rendered) 
        this.form.reset(); /* FileUploadField would fail when resetting a non-rendered form */
      //~ this.disable();
      this.getBottomToolbar().disable();
      this.form.items.each(function(cmp){
        cmp.disable();
      },this);
      this.set_window_title(this.empty_title);
      //~ this.containing_window.window.setTitle(this.empty_title);
      if (!this.hide_navigator) {
        this.first.disable();
        this.prev.disable();
        this.next.disable();
        this.last.disable();
      }
    }
    //~ console.log('20100531 Lino.DetailMixin.on_load_master_record',this.main_form);
    this.before_row_edit(record);
    if (after) after();
  },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.refresh();
  },
  
  get_selected : function() { return [ this.current_record ] },
  get_current_record : function() {  
    //~ console.log(20100714,this.current_record);
    return this.current_record 
  },
  
  get_permalink_url : function() {
      var rec = this.get_current_record();
      if (rec && ! rec.phantom && rec.id != -99998)
          return ROOT_URL + '/api' + this.ls_url + '/' + rec.id;
      return ROOT_URL + '/api' + this.ls_url;
    
  },
  get_permalink_params : function() {
    var p = {};
    //~ var p = {an:'detail'};
    if (this.action_name)
        p.an = this.action_name;
    //~ var p = {an:this.action_name};
    var main = this.items.get(0);
    if (main.activeTab) {
      var tab = main.items.indexOf(main.activeTab);
      //~ console.log('main.activeTab',tab,main.activeTab);
      if (tab) p.tab = tab;
    }
    this.add_param_values(p)
    return p;
  },
  
  /* 
  Lino.FormPanel.save() 
  */
  save : function(after) {
    //~ var panel = this;
    this.loadMask.show();
    var rec = this.get_current_record();
    if (this.has_file_upload) this.form.fileUpload = true;
    //~ console.log('FormPanel.save()',rec);
    if (rec) {
      if (rec.phantom) {
        if (this.action_name != 'insert') 
            console.log("Warning: phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: ROOT_URL + '/api' + this.ls_url,
          method: 'POST',
          params: this.get_base_params(), // 20101025
          scope: this,
          success: function(form, action) {
            this.loadMask.hide();
            Lino.notify(action.result.message);
            /***
            Close this window, but update the status of the 
            calling window.
            If the calling window is a detail on the same table,
            then it should skip to the new record. But only then.
            A successful response usually has a data_record,
            except if it is a fileupload form where some mysterious 
            decoding problems (20120209) force us to return a record_id 
            which will lead to an additional GET.
            ***/
            var url = this.ls_url;
            var ww = Lino.calling_window();
            if (ww && ww.window.main_item instanceof Lino.FormPanel 
                   && ww.window.main_item.ls_url == this.ls_url) {
                //~ console.log("20120217 case 1");
                ww.status.record_id = action.result.record_id;
                ww.status.data_record = action.result.data_record;
                Lino.close_window();
            } else if (this.ls_detail_handler) {
                //~ console.log("20120217 case 2");
                Lino.kill_current_window();
                this.ls_detail_handler.run({
                    record_id:action.result.record_id,
                    data_record: action.result.data_record,
                    base_params:this.get_base_params()
                });
            } else {
                //~ console.log("20120217 case 3");
                Lino.close_window();
            }
            //~ Lino.close_window(function(ww){
                //~ if (ww.window.main_item instanceof Lino.FormPanel 
                    //~ && ww.window.main_item.ls_url == url) {
                  //~ ww.status.record_id = action.result.record_id,
                  //~ ww.status.data_record = action.result.data_record
                //~ }
            //~ });
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action);
          },
          clientValidation: true
        })
      } else {
        if (this.action_name != 'detail') 
            console.log("Warning: non-phantom record, but action_name is",this.action_name)
        this.form.submit({
          url: ROOT_URL + '/api' + this.ls_url + '/' + rec.id,
          method: 'PUT',
          //~ headers: { 'HTTP_X_REQUESTED_WITH' : 'XMLHttpRequest'},
          scope: this,
          params: this.get_base_params(), 
          success: function(form, action) {
            //~ panel.form.setValues(rec.data);
            //~ 20110701 panel.form.my_loadRecord(rec);
            this.loadMask.hide();
            Lino.notify(action.result.message);
            this.set_current_record(action.result.data_record,after);
            //~ this.refresh_with_after(after);
            //~ if (after) after(); else panel.refresh();
          },
          failure: function(form,action) { 
            this.loadMask.hide();
            Lino.on_submit_failure(form,action)},
          clientValidation: true
        })
      }
    } else Lino.notify("Sorry, no current record.");
  }
  
  /* not used (no longer possible without .dtl files)
  , edit_detail_config : function () {
    var active_tab = {};
    var main = this.items.get(0);
    if (main.getActiveTab !== undefined) {
      var tabitem = main.getActiveTab();
      Ext.apply(active_tab,{tab : main.items.indexOf(tabitem)});
    }
    var editor = new Ext.form.TextArea();
    var close = function() { win.close(); }
    var _this = this;
    var save = function() { 
      //~ console.log(20110609,arguments); 
      var params = {desc: editor.getValue()};
      Ext.apply(params,active_tab);
      var a = { 
        params: params, 
        method: 'PUT',
        url: ROOT_URL + '/detail_config' + _this.ls_url,
        failure : Lino.ajax_error_handler(this),
        success: Lino.action_handler( _this, function(result) {
          //~ console.log('detail_config/save success',result);
          win.close();
          document.location = _this.get_permalink();
        })
      };
      //~ console.log('detail_config/save sent',a);
      _this.loadMask.show(); // 20120211
      Ext.Ajax.request(a);
    }
    var save_btn = new Ext.Button({text:'Save',handler:save,disabled:true});
    var win = new Ext.Window({title:'Detail Layout',
      items:editor, layout:'fit',
      width:500,height:500,
      bbar:[{text:'Cancel',handler:close},save_btn]});
    var a = { 
      params:active_tab, 
      method:'GET',
      url:ROOT_URL+'/detail_config'+_this.ls_url,
      success : function(response) {
        if (response.responseText) {
          var result = Ext.decode(response.responseText);
          if (result.success) {
            editor.setValue(result.desc);
            save_btn.enable();
          }
        }
      }
    };
    Ext.Ajax.request(a);
    win.show();
  }
  */
});


Lino.getRowClass = function(record, rowIndex, rowParams, store) {
  if (record.phantom) {
    //~ console.log(20101009,record);
    //~ rowParams.bodyStyle = "color:red;background-color:blue";
    return 'lino-phantom-row';
    }
  //~ console.log('20101009 not a phantom:',record);
  return '';
}

//~ FOO = 0;



Lino.GridStore = Ext.extend(Ext.data.ArrayStore,{ 
  autoLoad: false,
  load: function(options) {
    //~ foo.bar = baz; // 20120213
    if (!options) options = {};
    if (!options.params) options.params = {};
    options.params.fmt = 'json';
    options.params.rp = this.grid_panel.getId();
      
    var ps = this.grid_panel.calculatePageSize();
    
    if (!ps) {
        //~ this.gridpanel.on('render',this.load())
      //~ console.log("20120213 GridStore.load() failed to calculate pagesize");
      return false;
        //~ params.limit = 1;
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    } 
    
    options.params.limit = ps;
      
    if (this.grid_panel.hide_top_toolbar) {
        //~ console.log("20120206 GridStore.load() toolbar is hidden");
        options.params.start = 0;
    } else {
        //~ options.params.start = this.grid_panel.getTopToolbar().cursor;
        //~ if (this.grid_panel.getTopToolbar().pageSize !=  ps) {
          //~ console.log("20120206 abort load because toolbar says pagesize",
            //~ this.grid_panel.getTopToolbar().pageSize,
            //~ "while actual pagesize is",ps);
            //~ return;
        //~ }
        
        this.grid_panel.getTopToolbar().pageSize =  ps;
        if (options.params.start == undefined)
            options.params.start = this.grid_panel.getTopToolbar().cursor;
      
    }
      
    this.grid_panel.add_param_values(options.params);
    //~ console.log("20120213 GridStore.load()",options.params);
    //~ if (FOO > 0) {
        //~ foo.bar = baz;
    //~ } else FOO += 1;
    return Lino.GridStore.superclass.load.call(this,options);
  }
});

    
Lino.GridPanel = Ext.extend(Ext.grid.EditorGridPanel,Lino.MainPanel);
Lino.GridPanel = Ext.extend(Lino.GridPanel,Lino.PanelMixin);
Lino.GridPanel = Ext.extend(Lino.GridPanel,{
  //~ quick_search_text : '',
  disabled_in_insert_window : true,
  clicksToEdit:2,
  enableColLock: false,
  autoHeight: false,
  params_panel_hidden : false,
  //~ loadMask: true,
  //~ viewConfig: {
          //~ getRowClass: Lino.getRowClass,
          //~ emptyText:"No data to display."
        //~ },
  loadMask: {msg:"Please wait..."},
  
  constructor : function(config){
    config.plugins = [new Lino.GridFilters()];
    Lino.GridPanel.superclass.constructor.call(this,config);
    
    //~ if (this.containing_window) {
        //~ console.log("20111206 install refresh");
        //~ this.containing_window.on('show',this.refresh,this);
    //~ }
    
  },
  
  config_containing_window : function(wincfg) { 
      if (wincfg.tools != undefined) 
        wincfg.tools = [
          {handler:this.save_grid_config,
            qtip:"Save Grid Configuration",
            scope:this, id:"save"}
        ].concat(wincfg.tools);
      //~ wincfg.listeners = { show: ... };
  },
  init_containing_window : function(win) { 
    //~ console.log("20111206 install refresh");
    //~ win.on('show',this.refresh,this);
  },
  
  initComponent : function(){
    
    /* 
    Problem 20111206:
    When a GridPanel is the main item of the window, then it doesn't 
    have it's own header but uses the window's header bar.
    We must do this in initComponent because e.g. in beforerender 
    it's already to late: a header element has been created because 
    there was a title.
    But Lino.Window adds itself as `this.containing_window` 
    only after the GridPanel has been initialized.
    Workaround is to generate a line "params.containing_window = true;" 
    in the handler function.
    */ 
    //~ if (this.containing_window) {
    if (this.is_main_window) {
        //~ console.log(20111206, 'delete title',this.title,'from',this);
        //~ delete this.title;
        this.tools = undefined;  
        this.title = undefined;  /* simply deleting it 
          isn't enough because that would only 
          unhide the title defined in some base class. */
    } 
    //~ else console.log(20111206, 'dont delete title',this.title,'from',this);
    
    /* e.g. when slave gridwindow called from a permalink */
    //~ if (this.base_params) Ext.apply(bp,this.base_params);  
    //~ bp['fmt'] = 'json';
    
    //~ function on_proxy_load( proxy, transactionObject, callbackOptions ) {
      //~ console.log('on_proxy_load',transactionObject)
    //~ }
    var proxy = new Ext.data.HttpProxy({ 
      url: ROOT_URL + '/api' + this.ls_url, 
      method: "GET"
      //~ listeners: {load:on_proxy_load} 
    });
    //~ config.store = new Ext.data.JsonStore({ 
    //~ this.store = new Ext.data.ArrayStore({ 
    this.store = new Lino.GridStore({ 
      listeners: { exception: Lino.on_store_exception }, 
      grid_panel: this,
      proxy: proxy, 
      //~ autoLoad: this.containing_window ? true : false,
      idIndex: this.pk_index,
      remoteSort: true, 
      //~ baseParams: bp, 
      fields: this.ls_store_fields, 
      totalProperty: "count", 
      root: "rows", 
      //~ id: "id" });
      idProperty: this.ls_id_property });
      
    //~ console.log('config.pk_index',config.pk_index,config.store),
    delete this.ls_store_fields;
      
    var this_ = this;
    //~ var grid = this;
    this.store.on('load', function() {
        //~ console.log('20120531 GridStore.on(load)',this_.store.reader.arrayData);
        //~ var da = this_.store.reader.arrayData.disabled_actions;
        //~ if (da) {
            //~ this.cmenu.cascade(function(item){ 
              //~ console.log(20120531, item.itemId, da[item.itemId]);
              //~ if (da[item.itemId]) item.disable(); else item.enable();
            //~ });
        //~ };
        if (this_.containing_window)
            this_.set_window_title(this_.store.reader.arrayData.title);
            //~ this_.containing_window.setTitle(this_.store.reader.arrayData.title);
        if (this_.selModel.getSelectedCell){
            if (this_.getStore().getCount()) // there may be no data
                this_.selModel.select(0,0); 
        } else {
            this_.selModel.selectFirstRow();
            this_.getView().focusEl.focus();
        }
      }, this
    );
    if (!this.hide_top_toolbar) {  
      var tbar = [ 
        this.search_field = new Ext.form.TextField({ 
          fieldLabel: "Search", 
          listeners: { scope:this_, change:this_.search_change }
          //~ value: text
          //~ scope:this, 
          //~ enableKeyEvents: true, 
          //~ listeners: { keypress: this.search_keypress }, 
          //~ id: "seachString" 
      })];
      tbar = this.add_params_panel(tbar);
      tbar = tbar.concat([
        { scope:this, 
          text: "[csv]", 
          handler: function() { 
            var p = Ext.apply({},this.get_base_params());
            p['fmt'] = 'csv';
            //~ url += "?" + Ext.urlEncode(p);
            window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          text: "[html]", 
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ var p = Ext.apply({},this.get_base_params());
            p.fmt = "printer";
            //~ p['fmt'] = 'printer';
            this.add_param_values(p);
            //~ url += "?" + Ext.urlEncode(p);
            window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } },
        { scope:this, 
          text: "[pdf]", 
          handler: function() { 
            var p = this.get_current_grid_config();
            Ext.apply(p,this.get_base_params());
            //~ var p = Ext.apply({},this.get_base_params());
            //~ p['fmt'] = 'pdf';
            p.fmt = "pdf";
            //~ p.fmt = "odt";
            this.add_param_values(p);
            //~ url += "?" + Ext.urlEncode(p);
            window.open(ROOT_URL+'/api'+this.ls_url + "?" + Ext.urlEncode(p)) 
          } }
      ]);
    
    
      var menu = [];
      var set_gc = function(index) {
        return function() {
          //~ console.log('set_gc() 20100812');
          this.getColumnModel().setConfig(
              this.apply_grid_config(index,this.ls_grid_configs,this.ls_columns));
        }
      }
      for (var i = 0; i < this.ls_grid_configs.length;i++) {
        var gc = this.ls_grid_configs[i];
        menu.push({text:gc.label,handler:set_gc(i),scope:this})
      }
      if(menu.length > 1) {
        tbar = tbar.concat([
          { text:"View",
            menu: menu,
            tooltip:"Select another view of this report"
          }
        ]);
      }
      this.tbar = new Ext.PagingToolbar({ 
        store: this.store, 
        prependButtons: true, 
        //~ pageSize: this.page_length, 
        pageSize: 1, 
        displayInfo: true, 
        beforePageText: "Page",
        afterPageText: "of {0}",
        displayMsg: "Displaying {0} - {1} of {2}",
        firstText: "First page",
        lastText: "Last page",
        prevText: "Previous page",
        nextText: "Next page",
        items: tbar
      });
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ var ps = this.calculatePageSize();
          //~ if (ps && ps != this.getTopToolbar().pageSize) {
              //~ // console.log('20120203 resize : pageSize',this.getTopToolbar().pageSize,'->',ps);
              //~ // this.getTopToolbar().pageSize =  ps;
              //~ cmp.refresh();
              //~ // this.getTopToolbar().doRefresh();
          //~ }
        //~ }, this);
      //~ this.on('resize', function(cmp,aw,ah,rw,rh) {
          //~ cmp.getTopToolbar().pageSize = this.calculatePageSize(aw,ah,rw,rh) || 10;
          //~ cmp.refresh();
        //~ }, this, {delay:500});
    }
    
    delete this.page_length
    
    var actions = Lino.build_buttons(this,this.ls_bbar_actions);
    this.cmenu = actions.cmenu;
    
    //~ Ext.apply(config,Lino.build_buttons(this,config.ls_bbar_actions));
    //~ config.bbar, this.cmenu = Lino.build_buttons(this,config.ls_bbar_actions);
    //~ this.cmenu = new Ext.menu.Menu({items: config.bbar});
    delete this.ls_bbar_actions
    
    
      
    if (this.ls_quick_edit) {
      this.selModel = new Ext.grid.CellSelectionModel()
      this.get_selected = function() {
        //~ console.log(this.getSelectionModel().selection);
        if (this.selModel.selection)
            return [ this.selModel.selection.record ];
        return [this.store.getAt(0)];
      };
      this.get_current_record = function() { 
        if (this.getSelectionModel().selection) 
          return this.selModel.selection.record;
        return this.store.getAt(0);
      };
    } else { 
      this.selModel = new Ext.grid.RowSelectionModel() 
      this.get_selected = function() {
        var sels = this.selModel.getSelections();
        if (sels.length == 0) sels = [this.store.getAt(0)];
        return sels
        //~ var sels = this.getSelectionModel().getSelections();
        //~ return Ext.pluck(sels,'id');
      };
      this.get_current_record = function() { 
        var rec = this.selModel.getSelected();
        if (rec == undefined) rec = this.store.getAt(0);
        return rec
      };
    };
    delete this.ls_quick_edit;
    
    this.columns  = this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns);
    
    //~ var grid = this;
    //~ this.colModel = new Ext.grid.ColumnModel({
      //~ columns: this.apply_grid_config(this.gc_name,this.ls_grid_configs,this.ls_columns),
      //~ isCellEditable: function(col, row) {
        //~ var record = grid.store.getAt(row);
        //~ console.log('20120514',col,record); // dataIndex
        //~ var dataIndex = grid.colModel.getDataIndex(col);
        //~ if (dataIndex in record.data['disabled_fields']) {
            //~ Lino.notify("This field is disabled");
            //~ return false;
        //~ }
        //~ return Ext.grid.ColumnModel.prototype.isCellEditable.call(this, col, row);
      //~ }
    //~ });    
    
    
    Lino.GridPanel.superclass.initComponent.call(this);
    
    //~ if (this.containing_window) 
        //~ this.on('afterlayout', this.refresh, this);
        //~ this.on('afterrender', this.refresh,this);
    //~ else
        //~ this.on('show', this.refresh,this);
    //~ this.on('afterlayout', function() {
      //~ if (this.id == "ext-comp-1157") 
        //~ console.log("20120213 afterlayout",this); 
      //~ // this.refresh();
      //~ },this);
    //~ this.on('afterrender', this.refresh);
    //~ this.on('resize', this.refresh,this,{delay:500});
    //~ this.on('resize', function(){console.log("20120213 resize",arguments)},this);
    this.on('resize', function(){
      //~ console.log("20120213 resize",arguments)
      this.refresh();
      },this);
    this.on('viewready', function(){
      //~ console.log("20120213 resize",arguments);
      this.view_is_ready = true;
      this.refresh();
      },this);
    this.on('afteredit', this.on_afteredit);
    this.on('beforeedit', this.on_beforeedit);
    this.on('beforeedit',function(e) { this.before_row_edit(e.record)},this);
    this.on('cellcontextmenu', Lino.cell_context_menu, this);
    //~ this.on('contextmenu', Lino.grid_context_menu, this);
    
    
    //~ if (this.id == "ext-comp-1157") captureEvents(this);    
    
  },
  
  //~ onResize : function(){
      //~ console.log("20120206 GridPanel.onResize",arguments);
      //~ Lino.GridPanel.superclass.onResize.apply(this, arguments);
      //~ this.refresh();
  //~ },
  
  
  get_status : function(){
    var p = { base_params : this.get_base_params()};
    if (!this.hide_top_toolbar) {
        p.current_page = this.getTopToolbar().current;
    }
    //~ console.log("20120213 GridPanel.get_status",p);
    return p;
  },
  set_status : function(status){
    //~ console.log("20120213 GridPanel.set_status",status);
    this.clear_base_params();
    if (status == undefined) status = {};
    if (status.param_values) this.set_param_values(status.param_values);
    if (status.base_params) { 
      this.set_base_params(status.base_params);
    }
    if (!this.hide_top_toolbar) {
      //~ console.log("20120213 GridPanel.getTopToolbar().changePage",
          //~ status.current_page || 1);
      this.getTopToolbar().changePage(status.current_page || 1);
    }
    //~ this.fireEvent('resize');
    //~ this.refresh.defer(100,this); 
    //~ this.onResize.defer(100,this); 
    //~ this.refresh(); 
    //~ this.doLayout(); 
    //~ this.onResize(); 
    //~ this.store.load();
  },
  
  refresh : function(unused) { 
    this.refresh_with_after();
  },
  refresh_with_after : function(after) { 
    //~ Lino.notify('20120204 Lino.GridPanel.refresh');
    //~ Lino.notify('Lino.GridPanel.refresh '+this.store.proxy.url);
    //~ var bp = { fmt:'json' }
    if (this.containing_panel) {
        //~ Ext.apply(p,this.master_panel.get_master_params());
        //~ Ext.apply(options.params,this.containing_panel.get_master_params());
        this.set_base_params(this.containing_panel.get_master_params());
    }
    
    if (! this.view_is_ready) return;
    
    var options = {};
    if (after) {
        options.callback = function(r,options,success) {if(success) after()}
    }
    
      
    //~ if (!this.rendered) {
        //~ console.log("20120206 GridPanel.refresh() must wait until rendered",options);
        //~ this.grid_panel.on('render',this.load.createDelegate(this,options))
        //~ return;
    //~ }
    
    this.store.load(options);
  },
  
  /* pageSize depends on grid height (Trying to remove scrollbar)
  Thanks to 
  - Christophe Badoit on http://www.sencha.com/forum/showthread.php?82647
  - http://www.sencha.com/forum/archive/index.php/t-37231.html
  */
  calculatePageSize : function(second_attempt) {
    //~ if (!this.rendered) { 
    if (!this.view_is_ready) { 
      //~ console.log('Cannot calculatePageSize() : not rendered');
      return false; }
    //~ if (!this.isVisible()) { 
      //~ console.log('calculatePageSize : not visible');
      //~ return false; }
      
    //~ console.log('getFrameHeight() is',this.getFrameHeight());
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('mainBody.getHeight() is',this.getView().mainBody.getHeight());
    //~ console.log('getInnerHeight() is',this.getInnerHeight());
    //~ console.log('getHeight() is',this.getHeight());
    //~ console.log('el.getHeight() is',this.getEl().getHeight());
    //~ console.log('getGridEl().getHeight() is',this.getGridEl().getHeight());
    //~ console.log('getOuterSize().height is',this.getOuterSize().height);
    //~ console.log('getBox().height is',this.getBox().height);
    //~ console.log('getResizeEl.getHeight() is',this.getResizeEl().getHeight());
    //~ console.log('getLayoutTarget().getHeight() is',this.getLayoutTarget().getHeight());
      
    var rowHeight = this.getFrameHeight();
    //~ var rowHeight = 52; // experimental value
    var row = this.view.getRow(0);
    if (row) {
      //~ console.log('20120213 yes');
      rowHeight = Ext.get(row).getHeight();
    }
    //~ console.log('rowHeight is ',rowHeight,this,caller);
    //~ this.getView().syncScroll();
    //~ this.getView().initTemplates();
    var height = this.getView().scroller.getHeight();
    //~ console.log('getView().scroller.getHeight() is',this.getView().scroller.getHeight());
    //~ console.log('getInnerHeight() - getFrameHeight() is',
      //~ this.getInnerHeight(), '-',
      //~ this.getFrameHeight(), '=',
      //~ this.getInnerHeight() - this.getFrameHeight());
    //~ var height = this.getView().mainBody.getHeight();
    //~ var height = this.getView().mainWrap.getHeight();
    //~ var height = this.getView().resizeMarker.getHeight();
    //~ this.syncSize();
    //~ var height = this.getInnerHeight() - this.getFrameHeight();
    //~ var height = this.getHeight() - this.getFrameHeight();
    height -= Ext.getScrollBarWidth(); // leave room for a possible horizontal scrollbar... 
    //~ height -= this.getView().scrollOffset;
    var ps = Math.floor(height / rowHeight);
    //~ console.log('20120203 calculatePageSize():',height,'/',rowHeight,'->',ps);
    ps -= 1; // leave room for a possible phantom row
    //~ return (ps > 1 ? ps : false);
    if (ps > 1) return ps;
    //~ console.log('calculatePageSize() found less than 1 row:',height,'/',rowHeight,'->',ps);
    //~ foo.bar = baz; // 20120213
    return 5;
    //~ if (second_attempt) {
        //~ console.log('calculatePageSize() abandons after second attempt:',
          //~ height,'/',rowHeight,'->',ps);
      //~ return 5;
    //~ }
    //~ return this.calculatePageSize.defer(500,this,[true]);
  },
  
  onCellDblClick : function(grid, row, col){
      //~ console.log("20120307 onCellDblClick",this,grid, row, col);
      if (this.ls_detail_handler) {
          //~ Lino.notify('show detail');
          Lino.show_detail(this);
          return false;
      }else{
        //~ console.log('startEditing');
        this.startEditing(row,col);
      }
  },
  
  get_base_params : function() {
    //~ return this.containing_window.config.base_params;
    return this.store.baseParams;
  },
  set_base_params : function(p) {
    //~ console.log('GridPanel.set_base_params',p)
    for (k in p) this.store.setBaseParam(k,p[k]);
    //~ this.store.baseParams = p;
    if (p.query) 
        this.search_field.setValue(p.query);
    //~ if (p.param_values) 
        //~ this.set_param_values(p.param_values);  
  },
  clear_base_params : function() {
      this.store.baseParams = {};
  },
  set_base_param : function(k,v) {
    this.store.setBaseParam(k,v);
  },
  
  //~ get_permalink_params : function() {
    //~ var p = {};
    //~ return p;
  //~ },
  
  before_row_edit : function(record) {},
  search_change : function(field,oldValue,newValue) {
    //~ console.log('search_change',field.getValue(),oldValue,newValue)
    this.set_base_param('query',field.getValue()); 
    this.getTopToolbar().moveFirst();
    //~ this.refresh();
  },
  
  apply_grid_config : function(index,grid_configs,rpt_columns) {
    //~ var rpt_columns = this.ls_columns;
    var gc = grid_configs[index];    
    //~ console.log('apply_grid_config() 20100812',name,gc);
    this.gc_name = index;
    if (gc == undefined) {
      return rpt_columns;
      //~ config.columns = config.ls_columns;
      //~ return;
    } 
    //~ delete config.ls_filters
    
    //~ console.log(20100805,config.ls_columns);
    var columns = Array(gc.columns.length);
    for (var j = 0; j < rpt_columns.length;j++) {
      var col = rpt_columns[j];
      for (var i = 0; i < gc.columns.length; i++) {
        if (col.dataIndex == gc.ci[i]) {
          col.width = gc.cw[i];
          col.hidden = gc.ch[i];
          columns[i] = col;
          break;
        }
      }
    }
    
    //~ var columns = Array(rpt_columns.length);
    //~ for (var i = 0; i < rpt_columns.length; i++) {
      //~ columns[i] = rpt_columns[gc.columns[i]];
      //~ columns[i].width = gc.widths[i];
    //~ }
    
    //~ if (gc.hidden_cols) {
      //~ for (var i = 0; i < gc.hidden_cols.length; i++) {
        //~ var hc = gc.hidden_cols[i];
        //~ for (var j = 0; j < columns.length;j++) {
          //~ var col = columns[j];
          //~ if (col.dataIndex == hc) {
            //~ col.hidden = true;
            //~ break
          //~ }
        //~ }
      //~ }
    //~ }
    if (gc.filters) {
      //~ console.log(20100811,'config.ls_filters',config.ls_filters);
      //~ console.log(20100811,'config.ls_grid_config.filters',config.ls_grid_config.filters);
      for (var i = 0; i < gc.filters.length; i++) {
        var fv = gc.filters[i];
        for (var j = 0; j < columns.length;j++) {
          var col = columns[j];
          if (col.dataIndex == fv.field) {
            //~ console.log(20100811, f,' == ',fv);
            if (fv.type == 'string') {
              col.filter.value = fv.value;
              //~ if (fv.comparison !== undefined) f.comparison = fv.comparison;
            } else {
              //~ console.log(20100811, fv);
              col.filter.value = {};
              col.filter.value[fv.comparison] = fv.value;
            }
            break;
          }
        };
      }
    }
    
    return columns;
    //~ config.columns = cols;
    //~ delete config.ls_columns
  },
  
  get_current_grid_config : function () {
    var cm = this.getColumnModel();
    var widths = Array(cm.config.length);
    var hiddens = Array(cm.config.length);
    //~ var hiddens = Array(cm.config.length);
    var columns = Array(cm.config.length);
    //~ var columns = Array(cm.config.length);
    //~ var hidden_cols = [];
    //~ var filters = this.filters.getFilterValues();
    var p = this.filters.buildQuery(this.filters.getFilterData())
    for (var i = 0; i < cm.config.length; i++) {
      var col = cm.config[i];
      columns[i] = col.dataIndex;
      //~ hiddens[i] = col.hidden;
      widths[i] = col.width;
      hiddens[i] = col.hidden;
      //~ if (col.hidden) hidden_cols.push(col.dataIndex);
    }
    //~ p['hidden_cols'] = hidden_cols;
    p.cw = widths;
    p.ch = hiddens;
    p.ci = columns;
    //~ p['widths'] = widths;
    //~ p['hiddens'] = hiddens;
    //~ p['columns'] = columns;
    p['name'] = this.gc_name;
    //~ var gc = this.ls_grid_configs[this.gc_name];
    //~ if (gc !== undefined) 
        //~ p['label'] = gc.label
    //~ console.log('20100810 save_grid_config',p);
    return p;
  },
  
  unused_manage_grid_configs : function() {
    var data = [];
    for (k in this.ls_grid_configs) {
      var v = this.ls_grid_configs[k];
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i)
    }
    if (this.ls_grid_configs[this.gc_name] == undefined) {
      var v = this.get_current_grid_config();
      var i = [k,String(v.columns),String(v.hidden_cols),String(v.filters)];
      data.push(i);
    }
    //~ console.log(20100811, data);
    var main = new Ext.grid.GridPanel({
      store: new Ext.data.ArrayStore({
        idIndex:0,
        fields:['name','columns','hidden_cols','filters'],
        autoDestroy:true,
        data: data}),
      //~ autoHeight:true,
      selModel: new Ext.grid.RowSelectionModel(),
      listeners: { 
        rowdblclick: function(grid,rowIndex,e) {
          console.log('row doubleclicked',grid, rowIndex,e);
        },
        rowclick: function(grid,rowIndex,e) {
          console.log('row clicked',grid, rowIndex,e);
        }
      },
      columns: [ 
        {dataIndex:'name',header:'Name'}, 
        {dataIndex:'columns',header:'columns'}, 
        {dataIndex:'hidden_cols',header:'hidden columns'}, 
        {dataIndex:'filters',header:'filters'} 
      ]
    });
    var win = new Ext.Window({title:'GridConfigs Manager',layout:'fit',items:main,height:200});
    win.show();
  },
  
  unused_edit_grid_config : function(name) {
    gc = this.ls_grid_configs[name];
    var win = new Ext.Window({
      title:'Edit Grid Config',layout:'vbox', 
      //~ layoutConfig:'stretch'
      items:[
        {xtype:'text', value: gc.name},
        {xtype:'text', value: gc.columns},
        {xtype:'text', value: gc.hidden_cols},
        {xtype:'text', value: gc.filters}
      ]
    });
    win.show();
  },
  
  save_grid_config : function () {
    //~ console.log('TODO: save_grid_config',this);
    //~ p.column_widths = Ext.pluck(this.colModel.columns,'width');
    var a = { 
      params:this.get_current_grid_config(), 
      method:'PUT',
      url:ROOT_URL + '/grid_config' + this.ls_url,
      success: Lino.action_handler(this),
      scope: this,
      failure: Lino.ajax_error_handler(this)
    };
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(a);
    //~ Lino.do_action(this,a);
  },
  
  on_beforeedit : function(e) {
    //~ console.log('20120514 GridPanel.on_beforeedit()',e,e.record.data.disabled_fields);
    if(e.record.data.disable_editing) {
      e.cancel = true;
      Lino.notify("This record is disabled");
      return;
    }
    if(e.record.data.disabled_fields && e.record.data.disabled_fields[e.field]) {
      e.cancel = true;
      Lino.notify("This field is disabled");
      //~ Lino.notify(String.format("Field '{0}' is disabled",e.field));
      return;
    }
    //~ if (e.record.data.disabled_fields) {
      //~ for (i in e.record.data.disabled_fields) {
        //~ if(e.record.data.disabled_fields[i] == e.field) {
          //~ e.cancel = true;
          //~ Lino.notify(String.format('Field "{0}" is disabled for this record',e.field));
          //~ return
        //~ }
      //~ }
    //~ }
  },
  on_afteredit : function(e) {
    /*
    e.grid - The grid that fired the event
    e.record - The record being edited
    e.field - The field name being edited
    e.value - The value being set
    e.originalValue - The original value for the field, before the edit.
    e.row - The grid row index
    e.column - The grid column index
    */
    var p = {};
    //~ console.log('20101130 modified: ',e.record.modified);
    //~ console.log('20101130 value: ',e.value);
    //~ var p = e.record.getChanges();
    //~ console.log('20101130 getChanges: ',e.record.getChanges());
    //~ this.before_row_edit(e.record);
    for(k in e.record.getChanges()) {
        var v = e.record.get(k);
    //~ for(k in e.record.modified) {
        //~ console.log('20101130',k,'=',v);
        //~ var cm = e.grid.getColumnModel();
        //~ var di = cm.getDataIndex(k);
        var f = e.record.fields.get(k);
        //~ console.log('20101130 f = ',f);
        //~ var v = e.record.get(di);
        if (f.type.type == 'date') {
            p[k] = Ext.util.Format.date(v, f.dateFormat);
        }else{
            p[k] = v;
            var v = e.record.get(k+'Hidden');
            if (v !== undefined) {
              p[k+'Hidden'] = v;
            }
        }
        //~ var i = cm.findColumnIndex(k);
        //~ var r = cm.getRenderer(i);
        //~ var editor = cm.getCellEditor(i,e.row);
        //~ var col = e.grid.getColumnModel().getColumnById(k);
        //~ console.log('20101130 r = ',r(v));
        //~ var f = e.record.fields[k];
        //~ console.log('20101130 f = ',f);
        //~ console.log('20101130 editor = ',editor);
        //~ p[k] = f.getValue();
        //~ p[k] = r(v);
    }
    //~ console.log('20101130 p:',p);
    //~ var cm = e.grid.getColumnModel();
    //~ var di = cm.getDataIndex(e.column);
    //~ var f = e.record.fields.get(di);
    //~ console.log('20101130 f = ',f);
    //~ if (f.type.type == 'date') e.record.set(di,Ext.util.Format.date(e.value, f.dateFormat));
    
    
    //~ var p = e.record.data;
    
    // var p = {};
    //~ p['grid_afteredit_colname'] = e.field;
    //~ p[e.field] = e.value;
    //~ console.log('20100723 GridPanel.on_afteredit()',e);
    // add value used by ForeignKeyStoreField CHOICES_HIDDEN_SUFFIX
    // not sure whether this is still needed:
    p[e.field+'Hidden'] = e.value;
    // this one is needed so that this field can serve as choice context:
    e.record.data[e.field+'Hidden'] = e.value;
    // p[pk] = e.record.data[pk];
    // console.log("grid_afteredit:",e.field,'=',e.value);
    Ext.apply(p,this.get_base_params()); // needed for POST, ignored for PUT
    //~ Ext.apply(p,this.containing_window.config.base_params);
    p['an'] = 'grid';
    var self = this;
    var req = {
        params:p,
        waitMsg: 'Saving your data...',
        success: Lino.action_handler( this, function(result) {
          self.getStore().commitChanges(); // get rid of the red triangles
          self.getStore().reload();        // reload our datastore.
          }),
        scope: this,
        failure: Lino.ajax_error_handler(this)
    };
    if (e.record.phantom) {
      Ext.apply(req,{
        method: 'POST',
        url: ROOT_URL + '/api' + this.ls_url
      });
    } else {
      Ext.apply(req,{
        method: 'PUT',
        url: ROOT_URL + '/api' + this.ls_url + '/' + e.record.id
      });
    }
    //~ console.log('20110406 on_afteredit',req);
    this.loadMask.show(); // 20120211
    Ext.Ajax.request(req);
  },

  afterRender : function() {
    Lino.GridPanel.superclass.afterRender.call(this);
    // this.getView().mainBody.focus();
    // console.log(20100114,this.getView().getRows());
    // if (this.getView().getRows().length > 0) {
    //  this.getView().focusRow(1);
    // }
    //~ this.my_load_mask = new Ext.LoadMask(this.getEl(), {
        //~ msg:'Please wait...',
        //~ store:this.store});
      
    var tbar = this.getTopToolbar();
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    // tbar.on('change',function() {this.getSelectionModel().selectFirstRow();this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().mainBody.focus();},this);
    // tbar.on('change',function() {this.getView().focusRow(1);},this);
    this.nav = new Ext.KeyNav(this.getEl(),{
      pageUp: function() {tbar.movePrevious(); },
      pageDown: function() {tbar.moveNext(); },
      home: function() {tbar.moveFirst(); },
      end: function() {tbar.moveLast(); },
      scope: this
    });
  },
  after_delete : function() {
    console.log('Lino.GridPanel.after_delete');
    this.refresh();
  },
  add_row_listener : function(fn,scope) {
    this.getSelectionModel().addListener('rowselect',fn,scope);
  },
  postEditValue : function(value, originalValue, r, field){
    value = Lino.GridPanel.superclass.postEditValue.call(this,value,originalValue,r,field);
    //~ console.log('GridPanel.postEdit()',value, originalValue, r, field);
    return value;
  },
  
  set_start_value : function(v) {
      this.start_value = v;
  },
  preEditValue : function(r, field){
      if (this.start_value) {
        var v = this.start_value;
        delete this.start_value;
        this.activeEditor.selectOnFocus = false;
        return v;
      }
      var value = r.data[field];
      return this.autoEncode && Ext.isString(value) ? Ext.util.Format.htmlDecode(value) : value;
  },
  
  on_master_changed : function() {
    //~ if (! this.enabled) return;
    //~ cmp = this;
    //~ console.log('Lino.GridPanel.on_master_changed()',this.title);
    if (! this.rendered) return; // 20120213
    var todo = function() {
      if (this.disabled) return;
      //~ if (this.disabled) return;
      //~ if (this.enabled) {
          //~ var src = caller.config.url_data + "/" + record.id + ".jpg"
          //~ console.log(20111125, this.containing_window);
          //~ for (k in p) this.getStore().setBaseParam(k,p[k]);
          //~ console.log('Lino.GridPanel.on_master_changed()',this.title,p);
          this.refresh();
          //~ this.set_base_params(this.master_panel.get_master_params());
          //~ this.getStore().load(); 
      //~ }
    };
    Lino.do_when_visible(this,todo.createDelegate(this));
  }
});
  

//~ Lino.MainPanelMixin = {
  //~ tbar_items : function() {
      //~ return ;
  //~ }
//~ };

//~ Ext.override(Lino.GridPanel,Lino.MainPanelMixin);
//~ Ext.override(Lino.FormPanel,Lino.MainPanelMixin);

//~ Lino.grid_context_menu = function(e) {
  //~ console.log('contextmenu',arguments);
//~ }

Lino.cell_context_menu = function(grid,row,col,e) {
  //~ console.log('20120531 cellcontextmenu',grid,row,col,e,grid.store.reader.arrayData.rows[row]);
  e.stopEvent();
  //~ grid.getView().focusCell(row,col);
  grid.getSelectionModel().select(row,col);
  //~ console.log(grid.store.getAt(row));
  //~ grid.getView().focusRow(row);
  //~ return;
  if(!grid.cmenu.el){grid.cmenu.render(); }
  //~ if(e.record.data.disabled_fields) {
  
  var da = grid.store.reader.arrayData.rows[row][grid.disabled_actions_index];
  if (da) {
      this.cmenu.cascade(function(item){ 
        //~ console.log(20120531, item.itemId, da[item.itemId]);
        if (da[item.itemId]) item.disable(); else item.enable();
      });
  };
  
  var xy = e.getXY();
  xy[1] -= grid.cmenu.el.getHeight();
  grid.cmenu.showAt(xy);
}


//~ Lino.load_main_menu = function() {
  //~ Ext.Ajax.request({
    //~ waitMsg: 'Loading main menu...',
    //~ method: 'GET',
    //~ url: '/menu',
    //~ success: Lino.on_load_menu,
    //~ failure: Lino.ajax_error_handler
  //~ });
//~ };



//~ Lino.SlavePlugin = function(caller) {
  //~ this.caller = caller;
//~ };

Lino.chooser_handler = function(combo,name) {
  return function(cmp,newValue,oldValue) {
    //~ console.log('Lino.chooser_handler()',cmp,oldValue,newValue);
    combo.setContextValue(name,newValue);
  }
};



Lino.ComboBox = Ext.extend(Ext.form.ComboBox,{
  forceSelection: true,
  triggerAction: 'all',
  autoSelect: false,
  submitValue: true,
  displayField: 'text', // 'text', 
  valueField: 'value', // 'value',
  
  //~ initComponent : Ext.form.ComboBox.prototype.initComponent.createSequence(function() {
  initComponent : function(){
      this.contextParams = {};
      //~ Ext.form.ComboBox.initComponent(this);
      Lino.ComboBox.superclass.initComponent.call(this);
  },
  setValue : function(v,record_data){
      /*
      Based on feature request developed in http://extjs.net/forum/showthread.php?t=75751
      */
      /* `record_data` is used to get the text corresponding to this value */
      //~ if(this.name == 'city') 
      //~ console.log('20120203', this.name,'.setValue(', v ,') this=', this,'record_data=',record_data);
      var text = v;
      if(this.valueField){
        if(v == null || v == '') { 
            //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,'no lookup needed, value is empty');
            //~ v = undefined;
            v = '';
            //~ text = '';
        } else if (Ext.isDefined(record_data)) {
          text = record_data[this.name];
          //~ if (this.name == 'birth_country') 
            //~ console.log(this.name,'.setValue',v,'got text ',text,' from record ',record);
        } else {
          // if(this.mode == 'remote' && !Ext.isDefined(this.store.totalLength)){
          if(this.mode == 'remote' && ( this.lastQuery === null || (!Ext.isDefined(this.store.totalLength)))){
              //~ if (this.name == 'birth_country') console.log(this.name,'.setValue',v,'store not yet loaded');
              this.store.on('load', this.setValue.createDelegate(this, arguments), null, {single: true});
              if(this.store.lastOptions === null || this.lastQuery === null){
                  var params;
                  if(this.valueParam){
                      params = {};
                      params[this.valueParam] = v;
                  }else{
                      var q = this.allQuery;
                      this.lastQuery = q;
                      this.store.setBaseParam(this.queryParam, q);
                      params = this.getParams(q);
                  }
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : call load() with params ',params);
                  this.store.load({params: params});
              //~ }else{
                  //~ if (this.name == 'birth_country') 
                    //~ console.log(this.name,'.setValue',v,' : but store is loading',this.store.lastOptions);
              }
              return;
          //~ }else{
              //~ if (this.name == 'birth_country') 
                //~ console.log(this.name,'.setValue',v,' : store is loaded, lastQuery is "',this.lastQuery,'"');
          }
          var r = this.findRecord(this.valueField, v);
          if(r){
              text = r.data[this.displayField];
          }else if(this.valueNotFoundText !== undefined){
              text = this.valueNotFoundText;
          }
        }
      }
      this.lastSelectionText = text;
      //~ this.lastSelectionText = v;
      if(this.hiddenField){
          //~ this.hiddenField.originalValue = v;
          this.hiddenField.value = v;
      }
      Ext.form.ComboBox.superclass.setValue.call(this, text);
      this.value = v; // needed for grid.afteredit
  },
  
  getParams : function(q){
    // p = Ext.form.ComboBox.superclass.getParams.call(this, q);
    // causes "Ext.form.ComboBox.superclass.getParams is undefined"
    var p = {};
    //p[this.queryParam] = q;
    if(this.pageSize){
        //~ p.start = 0;
        //~ p.limit = this.pageSize;
        p['start'] = 0;
        p['limit'] = this.pageSize;
    }
    // now my code:
    if(this.contextParams) Ext.apply(p,this.contextParams);
    //~ if(this.contextParams && this.contextValues) {
      //~ for(i = 0; i <= this.contextParams.length; i++)
        //~ p[this.contextParams[i]] = this.contextValues[i];
    //~ }
    return p;
  },
  setContextValue : function(name,value) {
    //~ console.log('setContextValue',this,this.name,':',name,'=',value);
    //~ if (this.contextValues === undefined) {
        //~ this.contextValues = Array(); // this.contextParams.length);
    //~ }
    if (this.contextParams[name] != value) {
      //~ console.log('setContextValue 1',this.contextParams);
      this.contextParams[name] = value;
      this.lastQuery = null;
      //~ console.log('setContextValue 2',this.contextParams);
    }
  }
});

Lino.ChoicesFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'local'
});


Lino.SimpleRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  forceSelection: true,
  constructor: function(config){
      Lino.SimpleRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value' ], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.ComplexRemoteComboStore = Ext.extend(Ext.data.JsonStore,{
  constructor: function(config){
      Lino.ComplexRemoteComboStore.superclass.constructor.call(this, Ext.apply(config, {
          totalProperty: 'count',
          root: 'rows',
          id: 'value', // ext_requests.CHOICES_VALUE_FIELD
          fields: ['value','text'], // ext_requests.CHOICES_VALUE_FIELD, // ext_requests.CHOICES_TEXT_FIELD
          listeners: { exception: Lino.on_store_exception }
      }));
  }
});

Lino.RemoteComboFieldElement = Ext.extend(Lino.ComboBox,{
  mode: 'remote',
  //~ forceSelection:false,
  minChars: 2, // default 4 is to much
  queryDelay: 300, // default 500 is maybe slow
  queryParam: 'query', 
  //~ typeAhead: true,
  selectOnFocus: true, // select any existing text in the field immediately on focus.
  resizable: true
});

/*
Thanks to Animal for posting the basic idea:
http://www.sencha.com/forum/showthread.php?15842-2.0-SOLVED-Combobox-twintrigger-clear&p=76130&viewfull=1#post76130

*/
Lino.TwinCombo = Ext.extend(Lino.RemoteComboFieldElement,{
    trigger2Class : 'x-form-search-trigger',
    initComponent : function() {
        //~ Lino.TwinCombo.superclass.initComponent.call(this);
        Lino.ComboBox.prototype.initComponent.call(this);
        Ext.form.TwinTriggerField.prototype.initComponent.call(this);
    },
    onTrigger2Click : function() {
        //~ console.log('onTrigger2Click',this,arguments);
    }
  });
//~ Lino.TwinCombo.prototype.initComponent = Ext.form.TwinTriggerField.prototype.initComponent;
Lino.TwinCombo.prototype.getTrigger = Ext.form.TwinTriggerField.prototype.getTrigger;
Lino.TwinCombo.prototype.initTrigger = Ext.form.TwinTriggerField.prototype.initTrigger;
Lino.TwinCombo.prototype.onTrigger1Click = Ext.form.ComboBox.prototype.onTriggerClick;
//~ Lino.TwinCombo.prototype.onTrigger2Click = function() {
    //~ console.log('onTrigger2Click',arguments);
//~ };



Lino.SimpleRemoteComboFieldElement = Ext.extend(Lino.RemoteComboFieldElement,{
  displayField: 'value', 
  valueField: null,
  forceSelection: false
});




Lino.Window = Ext.extend(Ext.Window,{
  //~ layout: "fit", 
  closeAction : 'hide',
  renderTo: 'main_area', 
  constrain: true,
  maximized: true,
  draggable: false,
  width: 700,
  height: 500,
  maximizable: false,
  constructor : function (config) {
    if (config.main_item.params_panel) {
        config.layout = 'border';
        config.main_item.region = 'center';
        config.main_item.params_panel.region = 'north';
        //~ config.main_item.params_panel.hidden = config.main_item.params_panel_hidden;
        config.items = [config.main_item.params_panel, config.main_item];
    } else {
        config.layout = 'fit';
        config.items = config.main_item;
    }
    this.main_item = config.main_item; 
    
    delete config.main_item;
    //~ delete config.params_item;
    
    //~ this.main_item = config.items.get(0);
    this.main_item.containing_window = this;
    
    //~ console.log('20120110 Lino.Window.constructor() 1');
    //~ if (Lino.current_window) { // all windows except the top are closable
    if (this.main_item.hide_window_title) { 
      config.closable = false;
      config.frame = false;
      config.shadow = false;
      //~ config.border = true;
      //~ config.title = undefined;
      //~ config.tools = null;
      delete config.title;
      delete config.tools;
    } else {
      config.title = this.main_item.empty_title;
      config.closable = true;
      config.tools = [ 
        { qtip: 'permalink', handler: Lino.permalink_handler(this), id: "pin" }
      ];
    //~ { qtip: this.config.qtip, handler: Lino.save_wc_handler(this), id: "save" }, 
    //~ { qtip: 'Call doLayout() on main Container.', handler: Lino.refresh_handler(this), id: "refresh" },
    //~ if (this.main_item.params_panel) {
        //~ config.tools = config.tools.concat([ 
          //~ { qtip: 'Show/hide parameter panel', handler: this.toggle_params_panel, id: "gear", scope:this } 
        //~ ]);
    //~ }
    //~ if (config.closable !== false) {
      // if undefined, will take default behaviour
      config.tools = config.tools.concat([ 
        { qtip: 'close', handler: this.hide, id: "close", scope:this } 
      ]);
    }
    
    this.main_item.config_containing_window(config);
    
    //~ console.log('20120110 Lino.Window.constructor() 2');
    Lino.Window.superclass.constructor.call(this,config);
    
    //~ console.log('20120110 Lino.Window.constructor() 3');
    
  },
  initComponent : function() {
    this.main_item.init_containing_window(this);
    Lino.Window.superclass.initComponent.call(this);
  
  },
  //~ toggle_params_panel : function() {
      //~ if (this.main_item.params_panel.isVisible()) 
          //~ this.main_item.params_panel.hide();
      //~ else
          //~ this.main_item.params_panel.show();
      //~ this.doLayout();
  //~ },
  unused_show : function(animateTarget,callback,scope,after_show) {
      //~ console.log('20120110 Lino.Window.show()',after_show);
      if (this.caller && !this.caller.get_containing_window) 
          console.log('20120124 WARNING: no get_containing_window in caller', this.caller);
    
      Lino.Window.superclass.show.call(this,animateTarget,callback,scope);
      Lino.current_window = this;
      if (!after_show) after_show = {};
      this.main_item.after_show(after_show);
      //~ this.window.show();
      //~ this.refresh();
      //~ Lino.load_mask.hide();
      //~ console.log('20120110 Lino.Window.show() 2');
      return this;
  },
  //~ kill : function() {
    //~ Lino.Window.superclass.hide.call(this);
    //~ Lino.current_window = this;
  //~ },
  hide : function() { 
      //~ var t = this;
      this.main_item.do_when_clean(function() { 
        //~ Lino.close_window(t); });
        Lino.close_window(); });
  },
  hide_really : function() { 
    Lino.Window.superclass.hide.call(this);
  },
  unused_hide : function() { 
      //~ console.log("Gonna close");
      var this_ = this;
      var caller = this.caller;
      this.main_item.do_when_clean(function() {
        Lino.Window.superclass.hide.call(this_);
        Lino.current_window = null;
        if (caller) {
          //~ console.log('20120124 caller is', caller);
          var cw = caller.get_containing_window();
          if (cw) {
              //~ console.log("20120118 refresh caller's window", cw);
              Lino.current_window = cw;
              cw.main_item.refresh();
          //~ } else {
              //~ console.log('20120124 caller had no containing window', caller);
              //~ caller.refresh();
          }
        //~ } else {
          //~ console.log('20120124 cannot refresh: no caller');
        }
      });
  },
  onRender : function(ct, position){
    //~ console.log('20120110 Lino.Window.onRender() 1');
    Lino.Window.superclass.onRender.call(this, ct, position);
    var main_area = Ext.getCmp('main_area')
    //~ console.log('20120110 Lino.Window.onRender() 2');
  
    this.on('show', function(win) {
        //~ console.log('20120110 Lino.Window.on show 1');
        main_area.on('resize', win.onWindowResize, win);
    });
    this.on('hide', function(win) {
        main_area.un('resize', win.onWindowResize, win);
    });
    //~ console.log('20120110 Lino.Window.onRender() 3');
  }
});


Lino.unused_ParamWindow = Ext.extend(Lino.Window,{
  //~ layout: "border", 
  constructor : function (config) {
    Lino.ParamWindow.superclass.constructor.call(this,config);
    this.main_item = config.items; // `items` must be a single component
    config.layout = 'border';
    this.main_item.region = 'center';
    config.params.region = 'north';
    config.items = [config.params, config.items];
    //~ delete config.params;
  }
});




(function(){
    var ns = Ext.ns('Ext.ux.plugins');

    /**
     * @class Ext.ux.plugins.DefaultButton
     * @extends Object
     *
     * Plugin for Button that will click() the button if the user presses ENTER while
     * a component in the button's form has focus.
     *
     * @author Stephen Friedrich
     * @date 09-DEC-2009
     * @version 0.1
     *
     */
    ns.DefaultButton =  Ext.extend(Object, {
        init: function(button) {
            button.on('afterRender', setupKeyListener, button);
        }
    });

    function setupKeyListener() {
        var formPanel = this.findParentByType('form');
        new Ext.KeyMap(formPanel.el, {
            key: Ext.EventObject.ENTER,
            shift: false,
            alt: false,
            fn: function(keyCode, e){
                if(e.target.type === 'textarea' && !e.ctrlKey) {
                    return true;
                }

                this.el.select('button').item(0).dom.click();
                return false;
            },
            scope: this
        });
    }

    Ext.ComponentMgr.registerPlugin('defaultButton', ns.DefaultButton);

})(); 

Ext.override(Ext.form.BasicForm,{
    my_loadRecord : function(record_data){
    //~ loadRecord : function(record){
        /* Forward also `record` to field.setValue() 
        so that Lino.Combobox can use it. 
        Lino never uses an array record here, so we can ignore this case. 
        */
        //~ console.log('20110214e loadRecord',record.data)
        var field, id;
        for(id in record_data){
            if(!Ext.isFunction(record_data[id]) && (field = this.findField(id))){
                field.setValue(record_data[id],record_data);
                if(this.trackResetOnLoad){
                    field.originalValue = field.getValue();
                    //~ if (field.hiddenField) {
                      //~ field.hiddenField.originalValue = field.hiddenField.value;
                    //~ }
                }
            }
        }
        return this;
    }
});




function initializeFooBarDropZone(cmp) {
    //~ console.log('initializeFooBarDropZone',cmp);
    cmp.dropTarget = new Ext.dd.DropTarget(cmp.bwrap, {
      //~ ddGroup     : 'gridDDGroup',
      notifyEnter : function(ddSource, e, data) {
        console.log('notifyEnter',ddSource,e,data);
        //Add some flare to invite drop.
        cmp.body.stopFx();
        cmp.body.highlight();
      },
      notifyDrop  : function(ddSource, e, data){
        console.log('notifyDrop',ddSource,e,data);
        // Reference the record (single selection) for readability
        //~ var selectedRecord = ddSource.dragData.selections[0];


        // Load the record into the form
        //~ formPanel.getForm().my_loadRecord(selectedRecord);


        // Delete record from the grid.  not really required.
        //~ ddSource.grid.store.remove(selectedRecord);

        return(true);
      }
    })
}


Lino.show_mti_child = function(fieldname,detail_handler) {
  //~ console.log('show_mti_child',this);
  //~ console.log('show_mti_child',panel.find("main_area"));
  rec = Lino.current_window.main_item.get_current_record();
  //~ rec = panel.get_current_record();
  if (rec) {
    //~ console.log('show_mti_child',Lino.current_window,rec);
    if (rec.phantom) {
      Lino.notify('Not allowed on phantom record.');
    }else if (rec.data[fieldname]) {
      //~ console.log('show_mti_child',rec.id);
      //~ detail_handler(Lino.current_window.main_item,{},{record_id:rec.id});
      detail_handler.run({record_id:rec.id});
      //~ window.open(urlroot + '/' + rec.id);
      //~ document.location = urlroot + '/' + rec.id;
      //~ window.open(urlroot + '/' + rec.id,'_blank');
    } else {
      Lino.notify('Cannot show MTI child if checkbox is off.');
    }
  } else {
    Lino.notify('No current record.');
  }
};




/*
Mappings towards lino.modlib.cal.models.PanelCalendars
*/
//~ Ext.ensible.cal.CalendarMappings = {
    //~ CalendarId:   {name:'ID', mapping: 0, type: 'int'},
    //~ Title:        {name:'CalTitle', mapping: 1, type: 'string'},
    //~ Description:  {name:'Desc', mapping: 2, type: 'string'},
    //~ ColorId:      {name:'Color', mapping: 3, type: 'int'},
    //~ IsHidden:     {name:'Hidden', mapping: 4, type: 'boolean'},    
//~ };
Ext.ensible.cal.CalendarMappings = {
    CalendarId:   {name:'ID',       mapping: 'id', type: 'int'},
    Title:        {name:'CalTitle', mapping: 'name', type: 'string'},
    Description:  {name:'Desc',     mapping: 'description', type: 'string'},
    ColorId:      {name:'Color',    mapping: 'color', type: 'int'},
    IsHidden:     {name:'Hidden',   mapping: 'is_hidden', type: 'boolean'},    
};
Ext.ensible.cal.CalendarRecord.reconfigure();  


/*
Mappings towards lino.modlib.cal.models.PanelEvents 
*/
Ext.ensible.cal.EventMappings = {
    EventId:     {name: 'ID',        mapping: 'id', type:'int'},
    CalendarId:  {name: 'CalID',     mapping: 'calendarHidden', type: 'int'},
    Title:       {name: 'EvtTitle',  mapping: 'summary'},
    StartDate:   {name: 'StartDt',   mapping: 'start_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s" },
    EndDate:     {name: 'EndDt',     mapping: 'end_dt', 
      type: 'date', 
      dateFormat: "Y-m-d\TH:i:s"},
    RRule:       {name: 'RecurRule', mapping: 'rsetHidden'},
    Location:    {name: 'Location',  mapping: 'placeHidden'},
    Notes:       {name: 'Desc',      mapping: 'description'},
    Url:         {name: 'LinkUrl',   mapping: 'url'},
    IsAllDay:    {name: 'AllDay',    mapping: 'all_day', type: 'boolean'},
    Reminder:    {name: 'Reminder',  mapping: 'reminder'}
    
};
Ext.ensible.cal.EventRecord.reconfigure();


Lino.on_eventclick = function(cp,rec,el) {
  console.log("Lino.on_eventclick",arguments);
  Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  return false;
}
    
Lino.on_editdetails = function(cp,rec,el) {
  console.log("Lino.on_editdetails",arguments);
  if (rec.data.ID)
      Lino.cal.Events.detail_action.run({record_id:rec.data.ID});
  return false;
}

Lino.format_time = function(dt) {
    return dt.getHours() + ':' + dt.getMinutes();
}
    
Lino.on_eventdelete = function() {
  console.log("Lino.on_eventdelete",arguments);
};

Lino.on_eventadd  = function(cp,rec,el) {
  console.log("Lino.on_eventadd ",arguments);
  return false;
}
    
Lino.on_eventresize  = function(cp,rec,el) {
  console.log("Lino.on_eventresize ",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    
Lino.on_eventupdate  = function(cp,rec,el) {
  console.log("Lino.on_eventupdate",arguments);
  //~ Lino.cal.Events.insert(cp);
  //~ return false;
}
    

//~ Lino.eventStore = new Ext.ensible.cal.EventStore({ 
//~ Lino.eventStore = new Ext.data.ArrayStore({ 
Lino.eventStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,url: ROOT_URL + '/restful/cal/PanelEvents'
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: ROOT_URL + '/restful/cal/PanelEvents', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ disableCaching:true,
      })
      //~ ,reader : new Ext.data.JsonReader({
        ,fields: Ext.ensible.cal.EventRecord.prototype.fields.getRange()
        ,totalProperty: "count"
        ,root: "rows"
        ,idProperty: Ext.ensible.cal.EventMappings.EventId.mapping
        //~ ,idIndex: Ext.ensible.cal.EventMappings.EventId.mapping
      //~ })
      ,writer : new Ext.data.JsonWriter({
          writeAllFields: false
          //~ ,encode: false
          //~ ,createRecord : function(rec) {
              //~ return Lino.on_eventadd(null,rec);
          //~ }
          //~ ,destroyRecord : function(rec) {
              //~ return Lino.on_eventdelete(null,rec);
          //~ }
          //~ ,updateRecord : function(rec) {
              //~ return Lino.on_eventupdate(null,rec);
          //~ }
        
      })
      //~ ,disableCaching:true
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
    });

//~ Lino.calendarStore = new Ext.data.ArrayStore({ 
Lino.calendarStore = new Ext.data.JsonStore({ 
      listeners: { exception: Lino.on_store_exception }
      ,restful : true
      ,proxy: new Ext.data.HttpProxy({ 
          url: ROOT_URL + '/restful/cal/PanelCalendars?fmt=json', 
          disableCaching: false // no need for cache busting when loading via Ajax
          //~ restful : true
          //~ method: "GET"
      })
      //~ ,autoLoad: true
      //~ ,remoteSort: true
      //~ ,baseParams: bp
      ,totalProperty: "count"
      ,root: "rows"
      ,fields: Ext.ensible.cal.CalendarRecord.prototype.fields.getRange()
      ,idProperty: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
      //~ ,idIndex: Ext.ensible.cal.CalendarMappings.CalendarId.mapping
    });


Lino.CalendarCfg = {
    dateParamFormat: 'd.m.Y',
    dateParamStart:'sd',
    dateParamEnd:'ed'
};
Lino.CalendarPanel = Ext.extend(Ext.ensible.cal.CalendarPanel,Lino.MainPanel);
//~ Ext.override(Lino.CalendarPanel,Lino.FieldBoxMixin);
Lino.CalendarPanel = Ext.extend(Lino.CalendarPanel,{
  //~ empty_title : "$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendar"
  ,activeItem: 1 // 0: day, 1: week
  ,eventStore: Lino.eventStore
  ,ls_url: '/cal/Panel'
  //~ ,disableCaching:true
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120211 render");
      Lino.calendarStore.load();
      var view = this.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      var p = {};
      p[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      p[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      //~ console.log("20120211",p);
      Lino.eventStore.load({params:p});
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  ,monthViewCfg: Lino.CalendarCfg
  ,weekViewCfg: Lino.CalendarCfg
  ,multiDayViewCfg: Lino.CalendarCfg
  ,multiWeekViewCfg: Lino.CalendarCfg
  ,dayViewCfg: Lino.CalendarCfg
  //~ ,initComponent : function() {
    //~ // this.on('eventadd',Lino.on_eventadd);
    //~ Lino.CalendarPanel.superclass.initComponent.call(this);
  //~ }
});

/**
Lino.CalendarAppPanel = Ext.extend(Ext.Panel,Lino.MainPanel);
Lino.CalendarAppPanel = Ext.extend(CalendarAppPanel,{
  //~ empty_title : "$ui.get_actor('cal.Panel').report.label",
  empty_title : "Calendar"
  ,activeItem: 1 // 0: day, 1: week
  ,eventStore: Lino.eventStore
  ,ls_url: '/cal/Panel'
  //~ ,disableCaching:true
  ,calendarStore: Lino.calendarStore
  ,listeners: { 
    editdetails: Lino.on_editdetails
    ,eventclick: Lino.on_eventclick
    //~ ,eventadd: Lino.on_eventadd
    //~ ,eventdelete: Lino.on_eventdelete
    //~ ,eventresize: Lino.on_eventresize
    ,afterrender : function(config) {
      //~ console.log("20120211 render");
      Lino.calendarStore.load();
      var view = this.getActiveView();
      var bounds = view.getViewBounds();
      //~ var p = {sd:'05.02.2012',ed:'11.02.2012'};
      var p = {};
      p[view.dateParamStart] = bounds.start.format(view.dateParamFormat);
      p[view.dateParamEnd] = bounds.end.format(view.dateParamFormat);
      //~ console.log("20120211",p);
      Lino.eventStore.load({params:p});
      //~ Lino.CalendarPanel.superclass.constructor.call(this, config);
      //~ console.log(20120118, config,this);
    }
    }
  ,enableEditDetails: false
  ,monthViewCfg: Lino.CalendarCfg
  ,weekViewCfg: Lino.CalendarCfg
  ,multiDayViewCfg: Lino.CalendarCfg
  ,multiWeekViewCfg: Lino.CalendarCfg
  ,dayViewCfg: Lino.CalendarCfg
  
            // This is the app UI layout code.  All of the calendar views are subcomponents of
            // CalendarPanel, but the app title bar and sidebar/navigation calendar are separate
            // pieces that are composed in app-specific layout code since they could be omitted
            // or placed elsewhere within the application.
            new Ext.Viewport({
                layout: 'border',
                items: [{
                    id: 'app-header',
                    region: 'north',
                    height: 35,
                    border: false,
                    contentEl: 'app-header-content'
                },{
                    id: 'app-center',
                    title: '...', // will be updated to the current view's date range
                    region: 'center',
                    layout: 'border',
                    listeners: {
                        'afterrender': function(){
                            Ext.getCmp('app-center').header.addClass('app-center-header');
                        }
                    },
                    items: [{
                        id:'app-west',
                        region: 'west',
                        width: 176,
                        border: false,
                        items: [{
                            xtype: 'datepicker',
                            id: 'app-nav-picker',
                            cls: 'ext-cal-nav-picker',
                            listeners: {
                                'select': {
                                    fn: function(dp, dt){
                                        App.calendarPanel.setStartDate(dt);
                                    },
                                    scope: this
                                }
                            }
                        },{
                            xtype: 'extensible.calendarlist',
                            store: this.calendarStore,
                            border: false,
                            width: 175
                        }]
                    },{
                        xtype: 'extensible.calendarpanel',
                        eventStore: this.eventStore,
                        calendarStore: this.calendarStore,
                        border: false,
                        id:'app-calendar',
                        region: 'center',
                        activeItem: 3, // month view
                        
                        // Any generic view options that should be applied to all sub views:
                        viewConfig: {
                            //enableFx: false,
                            //ddIncrement: 10, //only applies to DayView and subclasses, but convenient to put it here
                            //viewStartHour: 6,
                            //viewEndHour: 18,
                            //minEventDisplayMinutes: 15
                        },
                        
                        // View options specific to a certain view (if the same options exist in viewConfig
                        // they will be overridden by the view-specific config):
                        monthViewCfg: {
                            showHeader: true,
                            showWeekLinks: true,
                            showWeekNumbers: true
                        },
                        
                        multiWeekViewCfg: {
                            //weekCount: 3
                        },
                        
                        // Some optional CalendarPanel configs to experiment with:
                        //readOnly: true,
                        //showDayView: false,
                        //showMultiDayView: true,
                        //showWeekView: false,
                        //showMultiWeekView: false,
                        //showMonthView: false,
                        //showNavBar: false,
                        //showTodayText: false,
                        //showTime: false,
                        //editModal: true,
                        //enableEditDetails: false,
                        //title: 'My Calendar', // the header of the calendar, could be a subtitle for the app
                        
                        // Once this component inits it will set a reference to itself as an application
                        // member property for easy reference in other functions within App.
                        initComponent: function() {
                            App.calendarPanel = this;
                            this.constructor.prototype.initComponent.apply(this, arguments);
                        },
                        
                        listeners: {
                            'eventclick': {
                                fn: function(vw, rec, el){
                                    this.clearMsg();
                                },
                                scope: this
                            },
                            'eventover': function(vw, rec, el){
                                //console.log('Entered evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]', view='+ vw.id +', el='+el.id);
                            },
                            'eventout': function(vw, rec, el){
                                //console.log('Leaving evt rec='+rec.data[Ext.ensible.cal.EventMappings.Title.name]+', view='+ vw.id +', el='+el.id);
                            },
                            'eventadd': {
                                fn: function(cp, rec){
                                    this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was added');
                                },
                                scope: this
                            },
                            'eventupdate': {
                                fn: function(cp, rec){
                                    this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                                },
                                scope: this
                            },
                            'eventdelete': {
                                fn: function(cp, rec){
                                    //this.eventStore.remove(rec);
                                    this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                                },
                                scope: this
                            },
                            'eventcancel': {
                                fn: function(cp, rec){
                                    // edit canceled
                                },
                                scope: this
                            },
                            'viewchange': {
                                fn: function(p, vw, dateInfo){
                                    if(this.editWin){
                                        this.editWin.hide();
                                    };
                                    if(dateInfo !== null){
                                        // will be null when switching to the event edit form so ignore
                                        Ext.getCmp('app-nav-picker').setValue(dateInfo.activeDate);
                                        this.updateTitle(dateInfo.viewStart, dateInfo.viewEnd);
                                    }
                                },
                                scope: this
                            },
                            'dayclick': {
                                fn: function(vw, dt, ad, el){
                                    this.clearMsg();
                                },
                                scope: this
                            },
                            'rangeselect': {
                                fn: function(vw, dates, onComplete){
                                    this.clearMsg();
                                },
                                scope: this
                            },
                            'eventmove': {
                                fn: function(vw, rec){
                                    rec.commit();
                                    var time = rec.data[Ext.ensible.cal.EventMappings.IsAllDay.name] ? '' : ' \\a\\t g:i a';
                                    this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was moved to '+
                                        rec.data[Ext.ensible.cal.EventMappings.StartDate.name].format('F jS'+time));
                                },
                                scope: this
                            },
                            'eventresize': {
                                fn: function(vw, rec){
                                    rec.commit();
                                    this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was updated');
                                },
                                scope: this
                            },
                            'eventdelete': {
                                fn: function(win, rec){
                                    this.eventStore.remove(rec);
                                    this.showMsg('Event '+ rec.data[Ext.ensible.cal.EventMappings.Title.name] +' was deleted');
                                },
                                scope: this
                            },
                            'initdrag': {
                                fn: function(vw){
                                    if(this.editWin && this.editWin.isVisible()){
                                        this.editWin.hide();
                                    }
                                },
                                scope: this
                            }
                        }
                    }]
                }]
            });
        },
        
        // The CalendarPanel itself supports the standard Panel title config, but that title
        // only spans the calendar views.  For a title that spans the entire width of the app
        // we added a title to the layout's outer center region that is app-specific. This code
        // updates that outer title based on the currently-selected view range anytime the view changes.
        updateTitle: function(startDt, endDt){
            var p = Ext.getCmp('app-center');
            
            if(startDt.clearTime().getTime() == endDt.clearTime().getTime()){
                p.setTitle(startDt.format('F j, Y'));
            }
            else if(startDt.getFullYear() == endDt.getFullYear()){
                if(startDt.getMonth() == endDt.getMonth()){
                    p.setTitle(startDt.format('F j') + ' - ' + endDt.format('j, Y'));
                }
                else{
                    p.setTitle(startDt.format('F j') + ' - ' + endDt.format('F j, Y'));
                }
            }
            else{
                p.setTitle(startDt.format('F j, Y') + ' - ' + endDt.format('F j, Y'));
            }
        },
        
        // This is an application-specific way to communicate CalendarPanel event messages back to the user.
        // This could be replaced with a function to do "toast" style messages, growl messages, etc. This will
        // vary based on application requirements, which is why it's not baked into the CalendarPanel.
        showMsg: function(msg){
            Ext.fly('app-msg').update(msg).removeClass('x-hidden');
        },
        
        clearMsg: function(){
            Ext.fly('app-msg').update('').addClass('x-hidden');
        }
    }



****/






/*
captureEvents utility by Aaron Conran
<http://www.sencha.com/learn/grid-faq/>

Ext.onReady(function(){
    var grid = new Ext.grid.GridPanel({
        ... 
    });
 
    captureEvents(grid);
});

*/
function captureEvents(observable) {
    Ext.util.Observable.capture(
        observable,
        function(eventName) {
            console.info(eventName);
        },
        this
    );		
}
 

Lino.main_menu = [ { "menu": { "items": [ { "menu": { "items": [ { "text": "Persons", "handler": function(){Lino.contacts.Persons.default_action.run({ "record_id": -99998 })} }, { "text": "Companies", "handler": function(){Lino.contacts.Companies.default_action.run({ "record_id": -99998 })} }, { "text": "Partners", "handler": function(){Lino.contacts.Partners.default_action.run({ "record_id": -99998 })} } ] }, "text": "Contacts" } ] }, "text": "Master" }, { "menu": { "items": [ { "text": "My Blog Entries", "handler": function(){Lino.blogs.MyEntries.default_action.run({ "record_id": -99998 })} }, { "menu": { "items": [ { "text": "My Projects", "handler": function(){Lino.tickets.MyProjects.default_action.run({ "record_id": -99998 })} }, { "text": "My Tickets", "handler": function(){Lino.tickets.MyTickets.default_action.run({ "record_id": -99998 })} }, { "text": "My Sessions", "handler": function(){Lino.tickets.MySessions.default_action.run({ "record_id": -99998 })} }, { "text": "My sessions by date", "handler": function(){Lino.tickets.MySessionsByDate.default_action.run({ "record_id": -99998 })} } ] }, "text": "Tickets" }, { "text": "My Uploads", "handler": function(){Lino.uploads.MyUploads.default_action.run({ "record_id": -99998 })} }, { "text": "My Outbox", "handler": function(){Lino.outbox.MyOutbox.default_action.run({ "record_id": -99998 })} } ] }, "text": "My menu" }, { "menu": { "items": [ { "text": "Calendar", "handler": function(){Lino.cal.Panel.default_action.run({ "record_id": -99998 })} }, { "text": "My Events", "handler": function(){Lino.cal.MyEvents.default_action.run({ "record_id": -99998 })} }, { "text": "My events to schedule", "handler": function(){Lino.cal.MyEventsToSchedule.default_action.run({ "record_id": -99998 })} }, { "text": "My events to notify", "handler": function(){Lino.cal.MyEventsToNotify.default_action.run({ "record_id": -99998 })} }, { "text": "My events to confirm", "handler": function(){Lino.cal.MyEventsToConfirm.default_action.run({ "record_id": -99998 })} }, "-", { "text": "Events", "handler": function(){Lino.cal.Events.default_action.run({ "record_id": -99998 })} }, { "text": "Events to schedule", "handler": function(){Lino.cal.EventsToSchedule.default_action.run({ "record_id": -99998 })} }, { "text": "Events to notify", "handler": function(){Lino.cal.EventsToNotify.default_action.run({ "record_id": -99998 })} }, { "text": "Events to confirm", "handler": function(){Lino.cal.EventsToConfirm.default_action.run({ "record_id": -99998 })} }, { "menu": { "items": [ { "text": "My Tasks", "handler": function(){Lino.cal.MyTasks.default_action.run({ "record_id": -99998 })} }, { "text": "To-do list", "handler": function(){Lino.cal.MyTasksToDo.default_action.run({ "record_id": -99998 })} } ] }, "text": "Tasks" } ] }, "text": "Calendar" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Users", "handler": function(){Lino.users.Users.default_action.run({ "record_id": -99998 })} }, { "text": "Text Field Templates", "handler": function(){Lino.lino.TextFieldTemplates.default_action.run({ "record_id": -99998 })} }, { "text": "content types", "handler": function(){Lino.lino.ContentTypes.default_action.run({ "record_id": -99998 })} }, { "text": "Help Texts", "handler": function(){Lino.lino.HelpTexts.default_action.run({ "record_id": -99998 })} }, { "text": "Site Parameters", "handler": function(){Lino.lino.SiteConfigs.detail_action.run({ "record_id": 1 })} } ] }, "text": "System" }, { "menu": { "items": [ { "text": "Property Groups", "handler": function(){Lino.properties.PropGroups.default_action.run({ "record_id": -99998 })} }, { "text": "Property Types", "handler": function(){Lino.properties.PropTypes.default_action.run({ "record_id": -99998 })} } ] }, "text": "Properties" }, { "menu": { "items": [ { "text": "company types", "handler": function(){Lino.contacts.CompanyTypes.default_action.run({ "record_id": -99998 })} }, { "text": "Role Types", "handler": function(){Lino.contacts.RoleTypes.default_action.run({ "record_id": -99998 })} }, { "text": "Countries", "handler": function(){Lino.countries.Countries.default_action.run({ "record_id": -99998 })} }, { "text": "Cities", "handler": function(){Lino.countries.Cities.default_action.run({ "record_id": -99998 })} }, { "text": "Languages", "handler": function(){Lino.countries.Languages.default_action.run({ "record_id": -99998 })} } ] }, "text": "Contacts" }, { "text": "Blog Entry Types", "handler": function(){Lino.blogs.EntryTypes.default_action.run({ "record_id": -99998 })} }, { "menu": { "items": [ { "text": "Project Types", "handler": function(){Lino.tickets.ProjectTypes.default_action.run({ "record_id": -99998 })} }, { "text": "Ticket States", "handler": function(){Lino.tickets.TicketStates.default_action.run({ "record_id": -99998 })} }, { "text": "Session Types", "handler": function(){Lino.tickets.SessionTypes.default_action.run({ "record_id": -99998 })} } ] }, "text": "Tickets" }, { "text": "Upload Types", "handler": function(){Lino.uploads.UploadTypes.default_action.run({ "record_id": -99998 })} }, { "menu": { "items": [ { "text": "Places", "handler": function(){Lino.cal.Places.default_action.run({ "record_id": -99998 })} }, { "text": "Priorities", "handler": function(){Lino.cal.Priorities.default_action.run({ "record_id": -99998 })} }, { "text": "Access Classes", "handler": function(){Lino.cal.AccessClasses.default_action.run({ "record_id": -99998 })} }, { "text": "Event Types", "handler": function(){Lino.cal.EventTypes.default_action.run({ "record_id": -99998 })} }, { "text": "Guest Roles", "handler": function(){Lino.cal.GuestRoles.default_action.run({ "record_id": -99998 })} }, { "text": "Calendars", "handler": function(){Lino.cal.Calendars.default_action.run({ "record_id": -99998 })} } ] }, "text": "Calendar" } ] }, "text": "Configure" }, { "menu": { "items": [ { "menu": { "items": [ { "text": "Contact Persons", "handler": function(){Lino.contacts.Roles.default_action.run({ "record_id": -99998 })} }, { "text": "Cities", "handler": function(){Lino.countries.Cities.default_action.run({ "record_id": -99998 })} } ] }, "text": "Contacts" }, { "text": "Blog Entries", "handler": function(){Lino.blogs.Entries.default_action.run({ "record_id": -99998 })} }, { "menu": { "items": [ { "text": "Projects", "handler": function(){Lino.tickets.Projects.default_action.run({ "record_id": -99998 })} }, { "text": "Tickets", "handler": function(){Lino.tickets.Tickets.default_action.run({ "record_id": -99998 })} }, { "text": "Sessions", "handler": function(){Lino.tickets.Sessions.default_action.run({ "record_id": -99998 })} } ] }, "text": "Tickets" }, { "text": "Uploads", "handler": function(){Lino.uploads.Uploads.default_action.run({ "record_id": -99998 })} }, { "menu": { "items": [ { "text": "Tasks", "handler": function(){Lino.cal.Tasks.default_action.run({ "record_id": -99998 })} }, { "text": "Guests", "handler": function(){Lino.cal.Guests.default_action.run({ "record_id": -99998 })} } ] }, "text": "Calendar" }, { "text": "Outgoing Mails", "handler": function(){Lino.outbox.Mails.default_action.run({ "record_id": -99998 })} } ] }, "text": "Explorer" }, { "menu": { "items": [ { "text": "About", "handler": function(){Lino.lino.About.default_action.run({ "record_id": -99998 })} }, { "text": "Inspector", "handler": function(){Lino.lino.Inspector.default_action.run({ "record_id": -99998 })} } ] }, "text": "Site" }, { "text": "Home", "handler": function() { location.replace('javascript:Lino.close_all_windows()'); }, "xtype": "button" } ];
Ext.namespace('Lino.users.Users')
Ext.namespace('Lino.lino.SiteConfigs')
Ext.namespace('Lino.lino.ContentTypes')
Ext.namespace('Lino.lino.HelpTexts')
Ext.namespace('Lino.lino.TextFieldTemplates')
Ext.namespace('Lino.countries.Languages')
Ext.namespace('Lino.countries.Countries')
Ext.namespace('Lino.countries.Cities')
Ext.namespace('Lino.properties.PropGroups')
Ext.namespace('Lino.properties.PropTypes')
Ext.namespace('Lino.properties.Properties')
Ext.namespace('Lino.properties.PropChoices')
Ext.namespace('Lino.contacts.CompanyTypes')
Ext.namespace('Lino.contacts.Partners')
Ext.namespace('Lino.contacts.AllPartners')
Ext.namespace('Lino.contacts.Persons')
Ext.namespace('Lino.contacts.Companies')
Ext.namespace('Lino.contacts.RoleTypes')
Ext.namespace('Lino.contacts.Roles')
Ext.namespace('Lino.blogs.EntryTypes')
Ext.namespace('Lino.blogs.Entries')
Ext.namespace('Lino.tickets.ProjectTypes')
Ext.namespace('Lino.tickets.SessionTypes')
Ext.namespace('Lino.tickets.Projects')
Ext.namespace('Lino.tickets.TicketStates')
Ext.namespace('Lino.tickets.Tickets')
Ext.namespace('Lino.tickets.Sessions')
Ext.namespace('Lino.outbox.Recipients')
Ext.namespace('Lino.outbox.Mails')
Ext.namespace('Lino.outbox.Attachments')
Ext.namespace('Lino.postings.Postings')
Ext.namespace('Lino.cal.Calendars')
Ext.namespace('Lino.cal.Places')
Ext.namespace('Lino.cal.Priorities')
Ext.namespace('Lino.cal.AccessClasses')
Ext.namespace('Lino.cal.EventTypes')
Ext.namespace('Lino.cal.Events')
Ext.namespace('Lino.cal.EventsToSchedule')
Ext.namespace('Lino.cal.EventsToNotify')
Ext.namespace('Lino.cal.Tasks')
Ext.namespace('Lino.cal.GuestRoles')
Ext.namespace('Lino.cal.Guests')
Ext.namespace('Lino.cal.PanelCalendars')
Ext.namespace('Lino.cal.PanelEvents')
Ext.namespace('Lino.uploads.UploadTypes')
Ext.namespace('Lino.uploads.Uploads')
Ext.namespace('Lino.lino.MyTextFieldTemplates')
Ext.namespace('Lino.countries.CitiesByCountry')
Ext.namespace('Lino.properties.PropsByGroup')
Ext.namespace('Lino.properties.PropsByType')
Ext.namespace('Lino.properties.ChoicesByType')
Ext.namespace('Lino.contacts.PartnersByCity')
Ext.namespace('Lino.contacts.PartnersByCountry')
Ext.namespace('Lino.contacts.RolesByCompany')
Ext.namespace('Lino.contacts.RolesByPerson')
Ext.namespace('Lino.blogs.MyEntries')
Ext.namespace('Lino.blogs.EntriesByType')
Ext.namespace('Lino.tickets.ProjectsByProject')
Ext.namespace('Lino.tickets.ProjectsByPartner')
Ext.namespace('Lino.tickets.TicketsByProject')
Ext.namespace('Lino.tickets.SessionsByTicket')
Ext.namespace('Lino.tickets.MySessions')
Ext.namespace('Lino.tickets.MySessionsByDate')
Ext.namespace('Lino.tickets.EntriesByTicket')
Ext.namespace('Lino.tickets.EntriesBySession')
Ext.namespace('Lino.tickets.MyProjects')
Ext.namespace('Lino.tickets.MyTickets')
Ext.namespace('Lino.outbox.RecipientsByMail')
Ext.namespace('Lino.outbox.MyOutbox')
Ext.namespace('Lino.outbox.MailsByUser')
Ext.namespace('Lino.outbox.MailsByProject')
Ext.namespace('Lino.outbox.SentByPartner')
Ext.namespace('Lino.outbox.AttachmentsByMail')
Ext.namespace('Lino.postings.PostingsByPartner')
Ext.namespace('Lino.postings.PostingsByProject')
Ext.namespace('Lino.cal.EventsByCalendar')
Ext.namespace('Lino.cal.EventsByType')
Ext.namespace('Lino.cal.EventsByPartner')
Ext.namespace('Lino.cal.EventsByPlace')
Ext.namespace('Lino.cal.EventsByProject')
Ext.namespace('Lino.cal.MyEvents')
Ext.namespace('Lino.cal.MyEventsToSchedule')
Ext.namespace('Lino.cal.MyEventsToNotify')
Ext.namespace('Lino.cal.EventsToConfirm')
Ext.namespace('Lino.cal.MyEventsToConfirm')
Ext.namespace('Lino.cal.MyEventsToday')
Ext.namespace('Lino.cal.MyTasks')
Ext.namespace('Lino.cal.MyTasksToDo')
Ext.namespace('Lino.cal.TasksByProject')
Ext.namespace('Lino.cal.GuestsByEvent')
Ext.namespace('Lino.cal.GuestsByRole')
Ext.namespace('Lino.cal.GuestsByPartner')
Ext.namespace('Lino.cal.RemindersByUser')
Ext.namespace('Lino.uploads.MyUploads')
Ext.namespace('Lino.uploads.UploadsByController')
Ext.namespace('Lino.lino.HelpTextsByModel')
Ext.namespace('Lino.postings.PostingsByController')
Ext.namespace('Lino.postings.MyPostings')
Ext.namespace('Lino.cal.TasksByController')
Ext.namespace('Lino.outbox.MailsByController')
Ext.namespace('Lino.outbox.AttachmentsByController')
Ext.namespace('Lino.cal.EventsByController')
Ext.namespace('Lino.blogs.EntriesByController')
Ext.namespace('Lino.lino.Models')
Ext.namespace('Lino.lino.FieldsByModel')
Ext.namespace('Lino.lino.Inspector')
Ext.namespace('Lino.lino.About')
Ext.namespace('Lino.cal.Panel')
Ext.namespace('Lino.lino.Home')

Lino.blogs.Entries.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 19,
  initComponent : function() {
    var containing_panel = this;
    var type165 = new Lino.TwinCombo({ "fieldLabel": "Blog Entry Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.blogs.EntryTypes.detail_action)}, "emptyText": "Select a Blog Entry Type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/type", "method": "GET" }) }) });
    var owner_disp166 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "Controlled by", "anchor": "100%", "name": "owner" });
    var main_1_panel167 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type165, "labelAlign": "top" }, { "flex": 54, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp166, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var subject170 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject", "anchor": "100%", "name": "subject" });
    var id171 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var created172 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "created", "name": "created", "anchor": "100%", "value": "<br>" });
    var modified173 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "modified", "name": "modified", "anchor": "100%", "value": "<br>" });
    var user174 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/user", "method": "GET" }) }) });
    var language175 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "100%", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var build_time176 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "build time", "name": "build_time", "anchor": "100%", "value": "<br>" });
    var main_3_panel177 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id171, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created172, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified173, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user174, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language175, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_time176, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var body184 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 50, "title": "Body", "name": "body", "containing_panel": this });
    var main_panel185 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": true, "items": [ main_1_panel167, { "items": subject170, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel177, body184 ], "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    this.items = main_panel185;
    this.before_row_edit = function(record) {
      body184.refresh();
    }
    Lino.blogs.Entries.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 16,
  initComponent : function() {
    var containing_panel = this;
    var last_name187 = new Ext.form.TextField({ "fieldLabel": "Last name", "name": "last_name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var first_name188 = new Ext.form.TextField({ "fieldLabel": "First name", "name": "first_name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var gender189 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "Gender", "name": "gender", "selectOnFocus": true, "anchor": "100%", "store": [ [ "M", "Male" ], [ "F", "Female" ] ], "hiddenName": "genderHidden" });
    var title190 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Title", "anchor": "100%", "name": "title" });
    var name_box_panel191 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 39, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name187, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name188, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gender189, "labelAlign": "top" }, { "flex": 19, "autoHeight": true, "layout": "form", "xtype": "panel", "items": title190, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "anchor": "100%", "labelAlign": "top" });
    var country196 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }) });
    var region197 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Region", "anchor": "100%", "name": "region" });
    var city198 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Select a City...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }) });
    var zip_code199 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10, "fieldLabel": "Zip code", "anchor": "100%", "name": "zip_code" });
    var address_box_2_panel200 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country196, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region197, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city198, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code199, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "anchor": "100%", "labelAlign": "top" });
    var addr1205 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line before street","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var street_prefix206 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var street207 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var street_no208 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "anchor": "100%" });
    var street_box209 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "anchor": "100%" });
    var address_box_4_panel210 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix206, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street207, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no208, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box209, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "100%", "labelAlign": "top" });
    var addr2215 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var address_box_panel216 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "labelWidth": 243, "title": "Address", "items": [ name_box_panel191, address_box_2_panel200, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1205, "anchor": "100%", "labelAlign": "top" }, address_box_4_panel210, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2215, "anchor": "100%", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id219 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var language220 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "100%", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var birth_date221 = new Lino.IncompleteDateField({ "listeners": { "render": Lino.quicktip_renderer("Birth date","Unkomplette Geburtsdaten sind erlaubt, z.B. \n<ul>\n<li>00.00.1980 : irgendwann in 1980</li>\n<li>00.07.1980 : im Juli 1980</li>\n<li>23.07.0000 : Geburtstag am 23. Juli, Alter unbekannt</li>\n</ul>") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Birth date</span>", "name": "birth_date", "maxLength": 10, "selectOnFocus": true, "anchor": "100%" });
    var info_box_panel222 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id219, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language220, "labelAlign": "top" }, { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": birth_date221, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "anchor": "100%", "labelAlign": "top" });
    var email226 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "100%", "name": "email" });
    var url227 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "100%", "name": "url" });
    var phone228 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Phone", "anchor": "100%", "name": "phone" });
    var gsm229 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "100%", "name": "gsm" });
    var fax230 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "100%", "name": "fax" });
    var contact_box_5_panel231 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm229, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax230, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "anchor": "100%", "labelAlign": "top" });
    var contact_box_panel234 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "labelWidth": 63, "title": "Contact", "items": [ info_box_panel222, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email226, "anchor": "100%", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url227, "anchor": "100%", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone228, "anchor": "100%", "labelAlign": "top" }, contact_box_5_panel231 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var general_1_panel238 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ address_box_panel216, contact_box_panel234 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks239 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "100% 100%", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByPerson_grid244 = new Lino.contacts.RolesByPerson.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByPerson.default_action) ], "master_panel": this });
    var bottom_box_panel245 = new Ext.Panel({ "flex": 50, "layout": "hbox", "items": [ { "items": remarks239, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByPerson_grid244 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_panel247 = new Ext.Panel({ "layout": "vbox", "title": "General", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel238, bottom_box_panel245 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var tickets_ProjectsByPartner_grid386 = new Lino.tickets.ProjectsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Projects", "tools": [ Lino.show_in_own_window_button(Lino.tickets.ProjectsByPartner.default_action) ], "master_panel": this });
    var main_panel387 = new Ext.TabPanel({ "autoScroll": true, "split": true, "hideCheckBoxLabels": true, "items": [ general_panel247, tickets_ProjectsByPartner_grid386 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel387;
    this.before_row_edit = function(record) {
      city198.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      contacts_RolesByPerson_grid244.on_master_changed();
      tickets_ProjectsByPartner_grid386.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country196.on('change',Lino.chooser_handler(city198,'country'));
      Lino.contacts.Persons.FormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Persons.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.SiteConfigs.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 4,
  initComponent : function() {
    var containing_panel = this;
    var default_build_method388 = new Lino.ChoicesFieldElement({ "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "fieldLabel": "Default build method", "name": "default_build_method", "selectOnFocus": true, "anchor": "100%", "value": "appyodt", "hiddenName": "default_build_methodHidden" });
    var main_panel389 = new Ext.Panel({ "autoScroll": true, "labelWidth": 189, "items": [ { "items": default_build_method388, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "hideCheckBoxLabels": true, "layout": "fit", "frame": false, "border": false, "labelAlign": "top" });
    this.items = main_panel389;
    this.before_row_edit = function(record) {
    }
    Lino.lino.SiteConfigs.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 30,
  initComponent : function() {
    var containing_panel = this;
    var type7 = new Lino.ChoicesFieldElement({ "fieldLabel": "Type", "allowBlank": false, "value": "local", "hiddenName": "typeHidden", "selectOnFocus": true, "anchor": "100%", "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "name": "type" });
    var name8 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var user9 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/user", "method": "GET" }) }) });
    var id10 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var main_1_panel11 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type7, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name8, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user9, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id10, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 45, "border": false, "labelAlign": "top" });
    var url_template16 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL template", "anchor": "100%", "name": "url_template" });
    var username17 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Username", "anchor": "100%", "name": "username" });
    var password18 = new Ext.form.TextField({ "fieldLabel": "Password", "name": "password", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "inputType": "password" });
    var main_2_panel19 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": url_template16, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username17, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": password18, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var description23 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 38, "title": "Description", "name": "description", "containing_panel": this });
    var readonly24 = new Ext.form.Checkbox({ "boxLabel": "read-only", "hideLabel": true, "checked": false, "name": "readonly", "selectOnFocus": true, "anchor": "100%" });
    var is_default25 = new Ext.form.Checkbox({ "boxLabel": "is default", "hideLabel": true, "checked": false, "name": "is_default", "selectOnFocus": true, "anchor": "100%" });
    var is_hidden26 = new Ext.form.Checkbox({ "boxLabel": "is hidden", "hideLabel": true, "checked": false, "name": "is_hidden", "selectOnFocus": true, "anchor": "100%" });
    var color27 = { "fieldLabel": "color", "xtype": "numberfield", "value": 1, "name": "color", "selectOnFocus": true, "anchor": "100%", "allowBlank": false };
    var start_date28 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Start date", "anchor": "100%", "name": "start_date" });
    var main_4_panel29 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": readonly24, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_default25, "labelAlign": "top" }, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_hidden26, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": color27, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date28, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var EventsByCalendar_grid151 = new Lino.cal.EventsByCalendar.GridPanel({ "flex": 38, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByCalendar.default_action) ], "master_panel": this });
    var main_panel152 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": true, "items": [ main_1_panel11, main_2_panel19, description23, main_4_panel29, EventsByCalendar_grid151 ], "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "labelAlign": "top" });
    this.items = main_panel152;
    this.before_row_edit = function(record) {
      description23.refresh();
      EventsByCalendar_grid151.on_master_changed();
    }
    Lino.cal.Calendars.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 11,
  initComponent : function() {
    var containing_panel = this;
    var id391 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var name392 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var name_de393 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "100%", "name": "name_de" });
    var name_fr394 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "100%", "name": "name_fr" });
    var main_1_panel395 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id391, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name392, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de393, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr394, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var PropsByGroup_grid406 = new Lino.properties.PropsByGroup.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByGroup.default_action) ], "master_panel": this });
    var main_panel407 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": true, "items": [ main_1_panel395, PropsByGroup_grid406 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    this.items = main_panel407;
    this.before_row_edit = function(record) {
      PropsByGroup_grid406.on_master_changed();
    }
    Lino.properties.PropGroups.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Projects.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 21,
  initComponent : function() {
    var containing_panel = this;
    var name256 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 20, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var summary257 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Summary", "anchor": "100%", "name": "summary" });
    var parent258 = new Lino.TwinCombo({ "fieldLabel": "Parent", "name": "parent", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail_action)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "parentHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/parent", "method": "GET" }) }) });
    var main_1_panel259 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name256, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary257, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": parent258, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var type263 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Project Type", "name": "type", "pageSize": 20, "emptyText": "Select a Project Type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/type", "method": "GET" }) }) });
    var user264 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/user", "method": "GET" }) }) });
    var partner265 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.AllPartners.detail_action)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/partner", "method": "GET" }) }) });
    var main_2_panel266 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type263, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user264, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner265, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var description270 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "100% 100%", "growMax": 2000, "name": "description" });
    var TicketsByProject_grid353 = new Lino.tickets.TicketsByProject.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.tickets.TicketsByProject.default_action) ], "master_panel": this });
    var ProjectsByProject_grid382 = new Lino.tickets.ProjectsByProject.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.tickets.ProjectsByProject.default_action) ], "master_panel": this });
    var main_4_panel383 = new Ext.Panel({ "flex": 41, "layout": "hbox", "items": [ TicketsByProject_grid353, ProjectsByProject_grid382 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel384 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": true, "items": [ main_1_panel259, main_2_panel266, { "items": description270, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, main_4_panel383 ], "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    this.items = main_panel384;
    this.before_row_edit = function(record) {
      TicketsByProject_grid353.on_master_changed();
      ProjectsByProject_grid382.on_master_changed();
    }
    Lino.tickets.Projects.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Models.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var app_disp408 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "app_label", "name": "app", "anchor": "100%", "value": "<br/>", "always_enabled": true });
    var name_disp409 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "name", "name": "name", "anchor": "100%", "value": "<br/>", "always_enabled": true });
    var docstring_disp410 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "docstring", "name": "docstring", "anchor": "100%", "value": "<br/>", "always_enabled": true });
    var rows_disp411 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "Rows", "name": "rows", "anchor": "100%", "value": "<br/>", "always_enabled": true });
    var main_1_panel412 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_disp408, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_disp409, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": docstring_disp410, "labelAlign": "top" }, { "flex": 8, "autoHeight": true, "layout": "form", "xtype": "panel", "items": rows_disp411, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 90, "border": false, "labelAlign": "top" });
    var lino_FieldsByModel_grid421 = new Lino.lino.FieldsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.lino.FieldsByModel.default_action) ], "master_panel": this });
    var main_panel422 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": true, "items": [ main_1_panel412, lino_FieldsByModel_grid421 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    this.items = main_panel422;
    this.before_row_edit = function(record) {
      lino_FieldsByModel_grid421.on_master_changed();
    }
    Lino.lino.Models.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.ContentTypes.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 1,
  initComponent : function() {
    var containing_panel = this;
    var id423 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var name424 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 100, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var app_label425 = new Ext.form.TextField({ "fieldLabel": "app label", "name": "app_label", "maxLength": 100, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var model426 = new Ext.form.TextField({ "fieldLabel": "python model class name", "name": "model", "maxLength": 100, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var base_classes_disp427 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "Base classes", "name": "base_classes", "anchor": "100%", "value": "<br/>", "always_enabled": true });
    var main_1_panel428 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id423, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name424, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": app_label425, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": model426, "labelAlign": "top" }, { "flex": 31, "autoHeight": true, "layout": "form", "xtype": "panel", "items": base_classes_disp427, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 216, "border": false, "labelAlign": "top" });
    var lino_HelpTextsByModel_grid440 = new Lino.lino.HelpTextsByModel.GridPanel({ "flex": 62, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.lino.HelpTextsByModel.default_action) ], "master_panel": this });
    var main_panel441 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": true, "items": [ main_1_panel428, lino_HelpTextsByModel_grid440 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    this.items = main_panel441;
    this.before_row_edit = function(record) {
      lino_HelpTextsByModel_grid440.on_master_changed();
    }
    Lino.lino.ContentTypes.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 12,
  initComponent : function() {
    var containing_panel = this;
    var id442 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var name443 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var name_de444 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "100%", "name": "name_de" });
    var name_fr445 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "100%", "name": "name_fr" });
    var choicelist446 = new Lino.ChoicesFieldElement({ "fieldLabel": "Choices List", "name": "choicelist", "selectOnFocus": true, "anchor": "100%", "store": [ [ "DoYouLike", "certainly not...very much" ], [ "Gender", "Gender" ], [ "HowWell", "not at all...very well" ], [ "UserGroups", "User Group" ], [ "UserLevels", "User Level" ], [ "UserProfiles", "User Profile" ] ], "hiddenName": "choicelistHidden" });
    var default_value447 = new Lino.RemoteComboFieldElement({ "fieldLabel": "default value", "name": "default_value", "selectOnFocus": true, "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }), "hiddenName": "default_valueHidden" });
    var main_1_panel448 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id442, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name443, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de444, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr445, "labelAlign": "top" }, { "flex": 21, "autoHeight": true, "layout": "form", "xtype": "panel", "items": choicelist446, "labelAlign": "top" }, { "flex": 10, "autoHeight": true, "layout": "form", "xtype": "panel", "items": default_value447, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "region": "north", "labelAlign": "top" });
    var ChoicesByType_grid461 = new Lino.properties.ChoicesByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "center", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.ChoicesByType.default_action) ] });
    var PropsByType_grid468 = new Lino.properties.PropsByType.GridPanel({ "flex": 5, "hide_top_toolbar": true, "containing_panel": this, "region": "south", "master_panel": this, "split": true, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.properties.PropsByType.default_action) ] });
    var main_panel469 = new Lino.VBorderPanel({ "autoScroll": true, "items": [ main_1_panel448, ChoicesByType_grid461, PropsByType_grid468 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel469;
    this.before_row_edit = function(record) {
      default_value447.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
      ChoicesByType_grid461.on_master_changed();
      PropsByType_grid468.on_master_changed();
    }
    this.onRender = function(ct, position) {
      choicelist446.on('change',Lino.chooser_handler(default_value447,'choicelist'));
      Lino.properties.PropTypes.FormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.properties.PropTypes.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 25,
  initComponent : function() {
    var containing_panel = this;
    var project279 = new Lino.TwinCombo({ "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail_action)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }) });
    var summary280 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Summary", "anchor": "100%", "name": "summary" });
    var user281 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/user", "method": "GET" }) }) });
    var created282 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "created", "name": "created", "anchor": "100%", "value": "<br>" });
    var modified283 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "modified", "name": "modified", "anchor": "100%", "value": "<br>" });
    var main_1_panel284 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project279, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary280, "labelAlign": "top" }, { "flex": 17, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user281, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created282, "labelAlign": "top" }, { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified283, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "region": "north", "labelAlign": "top" });
    var description290 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "100% 100%", "growMax": 2000, "name": "description" });
    var SessionsByTicket_grid335 = new Lino.tickets.SessionsByTicket.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.tickets.SessionsByTicket.default_action) ], "master_panel": this });
    var EntriesByTicket_grid349 = new Lino.tickets.EntriesByTicket.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.tickets.EntriesByTicket.default_action) ], "master_panel": this });
    var main_3_panel350 = new Ext.Panel({ "flex": 5, "layout": "hbox", "items": [ SessionsByTicket_grid335, EntriesByTicket_grid349 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "border": false, "region": "south", "labelAlign": "top" });
    var main_panel351 = new Lino.VBorderPanel({ "autoScroll": true, "labelWidth": 108, "items": [ main_1_panel284, { "flex": 5, "layout": "form", "xtype": "panel", "items": description290, "region": "center", "labelAlign": "top", "split": true }, main_3_panel350 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel351;
    this.before_row_edit = function(record) {
      SessionsByTicket_grid335.on_master_changed();
      EntriesByTicket_grid349.on_master_changed();
    }
    Lino.tickets.Tickets.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 6,
  initComponent : function() {
    var containing_panel = this;
    var name470 = new Ext.form.TextField({ "fieldLabel": "name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var country471 = new Lino.TwinCombo({ "fieldLabel": "Country", "allowBlank": false, "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "name": "country" });
    var main_1_panel472 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name470, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country471, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var contacts_PartnersByCity_grid548 = new Lino.contacts.PartnersByCity.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.PartnersByCity.default_action) ], "master_panel": this });
    var main_panel549 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": true, "items": [ main_1_panel472, contacts_PartnersByCity_grid548 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    this.items = main_panel549;
    this.before_row_edit = function(record) {
      contacts_PartnersByCity_grid548.on_master_changed();
    }
    Lino.countries.Cities.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 13,
  initComponent : function() {
    var containing_panel = this;
    var prefix550 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "prefix", "anchor": "100%", "name": "prefix" });
    var name551 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var type552 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Company type", "name": "type", "pageSize": 20, "emptyText": "Select a company type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }) });
    var name_box_panel553 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": prefix550, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name551, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type552, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "100%", "labelAlign": "top" });
    var country557 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }) });
    var region558 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Region", "anchor": "100%", "name": "region" });
    var city559 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Select a City...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }) });
    var zip_code560 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10, "fieldLabel": "Zip code", "anchor": "100%", "name": "zip_code" });
    var address_box_2_panel561 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country557, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region558, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city559, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code560, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "anchor": "100%", "labelAlign": "top" });
    var addr1566 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line before street","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var street_prefix567 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var street568 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var street_no569 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "anchor": "100%" });
    var street_box570 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "anchor": "100%" });
    var address_box_4_panel571 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix567, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street568, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no569, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box570, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "100%", "labelAlign": "top" });
    var addr2576 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var address_box_panel577 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "labelWidth": 243, "title": "Address", "items": [ name_box_panel553, address_box_2_panel561, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1566, "anchor": "100%", "labelAlign": "top" }, address_box_4_panel571, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2576, "anchor": "100%", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id580 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var language581 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "100%", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var vat_id582 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "VAT id", "anchor": "100%", "name": "vat_id" });
    var info_box_panel583 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 18, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id580, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language581, "labelAlign": "top" }, { "flex": 44, "autoHeight": true, "layout": "form", "xtype": "panel", "items": vat_id582, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "anchor": "100%", "labelAlign": "top" });
    var email587 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "100%", "name": "email" });
    var url588 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "100%", "name": "url" });
    var phone589 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Phone", "anchor": "100%", "name": "phone" });
    var gsm590 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "100%", "name": "gsm" });
    var fax591 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "100%", "name": "fax" });
    var contact_box_5_panel592 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm590, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax591, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "anchor": "100%", "labelAlign": "top" });
    var contact_box_panel595 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "labelWidth": 63, "title": "Contact", "items": [ info_box_panel583, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email587, "anchor": "100%", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url588, "anchor": "100%", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone589, "anchor": "100%", "labelAlign": "top" }, contact_box_5_panel592 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var general_1_panel599 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ address_box_panel577, contact_box_panel595 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks600 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "100% 100%", "growMax": 2000, "name": "remarks" });
    var contacts_RolesByCompany_grid605 = new Lino.contacts.RolesByCompany.GridPanel({ "flex": 42, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.contacts.RolesByCompany.default_action) ], "master_panel": this });
    var bottom_box_panel606 = new Ext.Panel({ "flex": 50, "layout": "hbox", "items": [ { "items": remarks600, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 57 }, contacts_RolesByCompany_grid605 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var general_panel608 = new Ext.Panel({ "layout": "vbox", "title": "General", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel599, bottom_box_panel606 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var tickets_ProjectsByPartner_grid609 = new Lino.tickets.ProjectsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Projects", "tools": [ Lino.show_in_own_window_button(Lino.tickets.ProjectsByPartner.default_action) ], "master_panel": this });
    var main_panel610 = new Ext.TabPanel({ "autoScroll": true, "split": true, "hideCheckBoxLabels": true, "items": [ general_panel608, tickets_ProjectsByPartner_grid609 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel610;
    this.before_row_edit = function(record) {
      city559.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      contacts_RolesByCompany_grid605.on_master_changed();
      tickets_ProjectsByPartner_grid609.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country557.on('change',Lino.chooser_handler(city559,'country'));
      Lino.contacts.Companies.FormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Companies.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 27,
  initComponent : function() {
    var containing_panel = this;
    var file611 = Lino.file_field_handler(this,{ "fieldLabel": "File", "name": "file", "maxLength": 100, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var user612 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }) });
    var main_1_panel613 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": file611, "labelAlign": "top" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user612, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 45, "border": false, "anchor": "100%", "labelAlign": "top" });
    var type616 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Upload Type", "name": "type", "pageSize": 20, "emptyText": "Select a Upload Type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }) });
    var description617 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Description", "anchor": "100%", "name": "description" });
    var main_2_panel618 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type616, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": description617, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "anchor": "100%", "labelAlign": "top" });
    var modified621 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "modified", "name": "modified", "anchor": "100%", "value": "<br>" });
    var created622 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "created", "name": "created", "anchor": "100%", "value": "<br>" });
    var owner_disp623 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "Controlled by", "anchor": "100%", "name": "owner" });
    var main_3_panel624 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified621, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created622, "labelAlign": "top" }, { "flex": 48, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp623, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "100%", "labelAlign": "top" });
    var main_panel628 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ main_1_panel613, main_2_panel618, main_3_panel624 ], "frame": true, "bodyBorder": false, "autoScroll": true, "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    this.items = main_panel628;
    this.before_row_edit = function(record) {
    }
    Lino.uploads.Uploads.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 15,
  initComponent : function() {
    var containing_panel = this;
    var name494 = new Ext.form.TextField({ "fieldLabel": "Name", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var country495 = new Lino.TwinCombo({ "fieldLabel": "Country", "name": "country", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Countries.detail_action)}, "emptyText": "Select a Country...", "selectOnFocus": true, "hiddenName": "countryHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }) });
    var region496 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Region", "anchor": "100%", "name": "region" });
    var city497 = new Lino.TwinCombo({ "forceSelection": false, "fieldLabel": "City", "name": "city", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.countries.Cities.detail_action)}, "emptyText": "Select a City...", "selectOnFocus": true, "hiddenName": "cityHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }) });
    var zip_code498 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10, "fieldLabel": "Zip code", "anchor": "100%", "name": "zip_code" });
    var address_box_2_panel499 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": country495, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": region496, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": city497, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": zip_code498, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "anchor": "100%", "labelAlign": "top" });
    var addr1504 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line before street","Address line before street") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line before street</span>", "name": "addr1", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var street_prefix505 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street prefix","Text to print before name of street, but to ignore for sorting.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street prefix</span>", "name": "street_prefix", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var street506 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Street","Name of street. Without house number.") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Street</span>", "name": "street", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var street_no507 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("No.","House number") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">No.</span>", "name": "street_no", "maxLength": 10, "selectOnFocus": true, "anchor": "100%" });
    var street_box508 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Box","Text to print after :attr:`steet_no` on the same line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Box</span>", "name": "street_box", "maxLength": 10, "selectOnFocus": true, "anchor": "100%" });
    var address_box_4_panel509 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_prefix505, "labelAlign": "top" }, { "flex": 38, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street506, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_no507, "labelAlign": "top" }, { "flex": 15, "autoHeight": true, "layout": "form", "xtype": "panel", "items": street_box508, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "anchor": "100%", "labelAlign": "top" });
    var addr2514 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Address line after street","Address line to print below street line") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Address line after street</span>", "name": "addr2", "maxLength": 200, "selectOnFocus": true, "anchor": "100%" });
    var address_box_panel515 = new Ext.form.FieldSet({ "flex": 66, "autoHeight": true, "labelWidth": 243, "title": "Address", "items": [ { "autoHeight": true, "layout": "form", "xtype": "panel", "items": name494, "anchor": "100%", "labelAlign": "top" }, address_box_2_panel499, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr1504, "anchor": "100%", "labelAlign": "top" }, address_box_4_panel509, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": addr2514, "anchor": "100%", "labelAlign": "top" } ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var id519 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var language520 = new Lino.ChoicesFieldElement({ "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Language</span>", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "listeners": { "render": Lino.quicktip_renderer("Language","Die Sprache, in der Dokumente ausgestellt werden sollen.") }, "selectOnFocus": true, "anchor": "100%", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var info_box_panel521 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id519, "labelAlign": "top" }, { "flex": 80, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language520, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "anchor": "100%", "labelAlign": "top" });
    var email524 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "E-Mail", "anchor": "100%", "name": "email" });
    var url525 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "URL", "anchor": "100%", "name": "url" });
    var phone526 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Phone", "anchor": "100%", "name": "phone" });
    var gsm527 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "GSM", "anchor": "100%", "name": "gsm" });
    var fax528 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Fax", "anchor": "100%", "name": "fax" });
    var contact_box_5_panel529 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": gsm527, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": fax528, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 36, "border": false, "anchor": "100%", "labelAlign": "top" });
    var contact_box_panel532 = new Ext.form.FieldSet({ "flex": 33, "autoHeight": true, "labelWidth": 63, "title": "Contact", "items": [ info_box_panel521, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": email524, "anchor": "100%", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": url525, "anchor": "100%", "labelAlign": "top" }, { "autoHeight": true, "layout": "form", "xtype": "panel", "items": phone526, "anchor": "100%", "labelAlign": "top" }, contact_box_5_panel529 ], "frame": false, "bodyBorder": true, "hideCheckBoxLabels": true, "layout": "form", "border": true, "labelAlign": "top" });
    var general_1_panel536 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ address_box_panel515, contact_box_panel532 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretchmax" }, "frame": false, "border": false, "labelAlign": "top" });
    var remarks537 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "100% 100%", "growMax": 2000, "name": "remarks" });
    var is_person538 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "is Person (<a href=\"javascript:Lino.show_mti_child('is_person',Lino.contacts.Persons.detail_action)\">show</a>)", "hideLabel": true, "anchor": "100%", "name": "is_person" });
    var is_company539 = new Ext.form.Checkbox({ "selectOnFocus": true, "boxLabel": "is Company (<a href=\"javascript:Lino.show_mti_child('is_company',Lino.contacts.Companies.detail_action)\">show</a>)", "hideLabel": true, "anchor": "100%", "name": "is_company" });
    var bottom_box_2_panel540 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_person538, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": is_company539, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var bottom_box_panel543 = new Ext.Panel({ "flex": 54, "labelWidth": 72, "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "items": [ { "items": remarks537, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 83 }, bottom_box_2_panel540 ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var general_panel545 = new Ext.Panel({ "layout": "vbox", "title": "General", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ general_1_panel536, bottom_box_panel543 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    var tickets_ProjectsByPartner_grid546 = new Lino.tickets.ProjectsByPartner.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Projects", "tools": [ Lino.show_in_own_window_button(Lino.tickets.ProjectsByPartner.default_action) ], "master_panel": this });
    var main_panel547 = new Ext.TabPanel({ "autoScroll": true, "split": true, "hideCheckBoxLabels": true, "items": [ general_panel545, tickets_ProjectsByPartner_grid546 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel547;
    this.before_row_edit = function(record) {
      city497.setContextValue('country',record ? record.data['countryHidden'] : undefined);
      tickets_ProjectsByPartner_grid546.on_master_changed();
    }
    this.onRender = function(ct, position) {
      country495.on('change',Lino.chooser_handler(city497,'country'));
      Lino.contacts.Partners.FormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.contacts.Partners.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 7,
  initComponent : function() {
    var containing_panel = this;
    var isocode629 = new Ext.form.TextField({ "fieldLabel": "isocode", "name": "isocode", "maxLength": 4, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var name630 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var name_de631 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "100%", "name": "name_de" });
    var name_fr632 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "100%", "name": "name_fr" });
    var short_code633 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 4, "fieldLabel": "short code", "anchor": "100%", "name": "short_code" });
    var main_1_panel634 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": isocode629, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name630, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de631, "labelAlign": "top" }, { "flex": 29, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr632, "labelAlign": "top" }, { "flex": 5, "autoHeight": true, "layout": "form", "xtype": "panel", "items": short_code633, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var countries_CitiesByCountry_grid644 = new Lino.countries.CitiesByCountry.GridPanel({ "flex": 83, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.countries.CitiesByCountry.default_action) ], "master_panel": this });
    var main_panel645 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": true, "items": [ main_1_panel634, countries_CitiesByCountry_grid644 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    this.items = main_panel645;
    this.before_row_edit = function(record) {
      countries_CitiesByCountry_grid644.on_master_changed();
    }
    Lino.countries.Countries.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.Home.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var quick_links_htmlbox646 = new Lino.HtmlBoxPanel({ "flex": 1, "layout": "fit", "name": "quick_links", "containing_panel": this, "items": new Ext.BoxComponent(), "region": "north", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "split": true, "autoScroll": true });
    var coming_reminders_htmlbox647 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "coming_reminders", "containing_panel": this, "items": new Ext.BoxComponent(), "title": "Upcoming reminders", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "autoScroll": true });
    var missed_reminders_htmlbox648 = new Lino.HtmlBoxPanel({ "flex": 50, "layout": "fit", "name": "missed_reminders", "containing_panel": this, "items": new Ext.BoxComponent(), "title": "Missed reminders", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "autoScroll": true });
    var main_2_panel649 = new Ext.Panel({ "flex": 16, "layout": "hbox", "items": [ coming_reminders_htmlbox647, missed_reminders_htmlbox648 ], "frame": false, "layoutConfig": { "align": "stretch" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 171, "border": false, "region": "center", "labelAlign": "top" });
    var main_panel650 = new Lino.VBorderPanel({ "autoScroll": true, "labelWidth": 0, "items": [ quick_links_htmlbox646, main_2_panel649 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel650;
    this.before_row_edit = function(record) {
      quick_links_htmlbox646.refresh();
      coming_reminders_htmlbox647.refresh();
      missed_reminders_htmlbox648.refresh();
    }
    Lino.lino.Home.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 34,
  initComponent : function() {
    var containing_panel = this;
    var id651 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var name652 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var name_de653 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "100%", "name": "name_de" });
    var name_fr654 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "100%", "name": "name_fr" });
    var main_1_panel655 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id651, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name652, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de653, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr654, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var build_method660 = new Lino.ChoicesFieldElement({ "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "100%", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template661 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Template", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }), "name": "template" });
    var email_template662 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Email template","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    var attach_to_email663 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "100%" });
    var main_2_panel664 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method660, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template661, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template662, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email663, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var cal_GuestsByRole_grid678 = new Lino.cal.GuestsByRole.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByRole.default_action) ], "master_panel": this });
    var main_panel679 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": true, "items": [ main_1_panel655, main_2_panel664, cal_GuestsByRole_grid678 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    this.items = main_panel679;
    this.before_row_edit = function(record) {
      template661.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_GuestsByRole_grid678.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method660.on('change',Lino.chooser_handler(template661,'build_method'));
      Lino.cal.GuestRoles.FormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.GuestRoles.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.TextFieldTemplates.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 3,
  initComponent : function() {
    var containing_panel = this;
    var id680 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var name681 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var user682 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/TextFieldTemplates/user", "method": "GET" }) }) });
    var main_1_panel683 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 12, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id680, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name681, "labelAlign": "top" }, { "flex": 37, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user682, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "split": true, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "region": "north", "labelAlign": "top" });
    var description687 = new Lino.RichTextPanel({ "flex": 5, "split": true, "title": "Description", "selectOnFocus": true, "region": "center", "containing_panel": this, "name": "description" });
    var text688 = new Lino.RichTextPanel({ "flex": 5, "split": true, "title": "Template Text", "selectOnFocus": true, "region": "south", "containing_panel": this, "name": "text" });
    var main_panel689 = new Lino.VBorderPanel({ "autoScroll": true, "labelWidth": 0, "items": [ main_1_panel683, description687, text688 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel689;
    this.before_row_edit = function(record) {
      description687.refresh();
      text688.refresh();
    }
    Lino.lino.TextFieldTemplates.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Events.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 31,
  initComponent : function() {
    var containing_panel = this;
    var type60 = new Lino.TwinCombo({ "fieldLabel": "Event Type", "name": "type", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.EventTypes.detail_action)}, "emptyText": "Select a Event Type...", "selectOnFocus": true, "hiddenName": "typeHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/type", "method": "GET" }) }) });
    var summary61 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Summary", "anchor": "100%", "name": "summary" });
    var user62 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }) });
    var main_1_panel63 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": type60, "labelAlign": "top" }, { "flex": 36, "autoHeight": true, "layout": "form", "xtype": "panel", "items": summary61, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user62, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var start_date67 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Start date", "anchor": "100%", "name": "start_date" });
    var start_time68 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Start time", "anchor": "100%", "name": "start_time" });
    var start_panel69 = new Ext.Panel({ "flex": 38, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date67, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time68, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var end_date72 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "End Date", "anchor": "100%", "name": "end_date" });
    var end_time73 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "End Time", "anchor": "100%", "name": "end_time" });
    var end_panel74 = new Ext.Panel({ "flex": 38, "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_date72, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time73, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "labelAlign": "top" });
    var state77 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "name": "state", "selectOnFocus": true, "anchor": "100%", "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ], "hiddenName": "stateHidden" });
    var main_2_panel78 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ start_panel69, end_panel74, { "flex": 23, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state77, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 54, "border": false, "labelAlign": "top" });
    var place80 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Place", "name": "place", "pageSize": 20, "emptyText": "Select a Place...", "selectOnFocus": true, "hiddenName": "placeHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/place", "method": "GET" }) }) });
    var priority81 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Priority", "name": "priority", "pageSize": 20, "emptyText": "Select a Priority...", "selectOnFocus": true, "hiddenName": "priorityHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }) });
    var access_class82 = new Lino.RemoteComboFieldElement({ "fieldLabel": "Access Class", "name": "access_class", "pageSize": 20, "emptyText": "Select a Access Class...", "selectOnFocus": true, "hiddenName": "access_classHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/access_class", "method": "GET" }) }) });
    var transparent83 = new Ext.form.Checkbox({ "boxLabel": "Transparent", "hideLabel": true, "checked": false, "name": "transparent", "selectOnFocus": true, "anchor": "100%" });
    var main_3_panel84 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": place80, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": priority81, "labelAlign": "top" }, { "flex": 28, "autoHeight": true, "layout": "form", "xtype": "panel", "items": access_class82, "labelAlign": "top" }, { "flex": 14, "autoHeight": true, "layout": "form", "xtype": "panel", "items": transparent83, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var calendar89 = new Lino.TwinCombo({ "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.PanelCalendars.detail_action)}, "emptyText": "Select a Calendar...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }) });
    var owner_disp90 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "Controlled by", "anchor": "100%", "name": "owner" });
    var created91 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "created", "name": "created", "anchor": "100%", "value": "<br>" });
    var modified92 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "modified", "name": "modified", "anchor": "100%", "value": "<br>" });
    var main_4_panel93 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar89, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp90, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created91, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified92, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var description98 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 31, "title": "Description", "name": "description", "containing_panel": this });
    var GuestsByEvent_grid108 = new Lino.cal.GuestsByEvent.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.GuestsByEvent.default_action) ], "master_panel": this });
    var outbox_MailsByController_grid148 = new Lino.outbox.MailsByController.GridPanel({ "flex": 50, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.MailsByController.default_action) ], "master_panel": this });
    var main_6_panel149 = new Ext.Panel({ "flex": 31, "layout": "hbox", "items": [ GuestsByEvent_grid108, outbox_MailsByController_grid148 ], "hideCheckBoxLabels": true, "layoutConfig": { "align": "stretch" }, "frame": false, "border": false, "labelAlign": "top" });
    var main_panel150 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": true, "items": [ main_1_panel63, main_2_panel78, main_3_panel84, main_4_panel93, description98, main_6_panel149 ], "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "labelAlign": "top" });
    this.items = main_panel150;
    this.before_row_edit = function(record) {
      description98.refresh();
      GuestsByEvent_grid108.on_master_changed();
      outbox_MailsByController_grid148.on_master_changed();
    }
    Lino.cal.Events.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 32,
  initComponent : function() {
    var containing_panel = this;
    var id690 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var name691 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var name_de692 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "100%", "name": "name_de" });
    var name_fr693 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "100%", "name": "name_fr" });
    var main_1_panel694 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id690, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name691, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de692, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr693, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var build_method699 = new Lino.ChoicesFieldElement({ "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "100%", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template700 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Template", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventTypes/template", "method": "GET" }) }), "name": "template" });
    var email_template701 = new Lino.SimpleRemoteComboFieldElement({ "listeners": { "render": Lino.quicktip_renderer("Email template","The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Email template</span>", "name": "email_template", "selectOnFocus": true, "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventTypes/email_template", "method": "GET" }) }) });
    var attach_to_email702 = new Ext.form.Checkbox({ "boxLabel": "Attach to email", "listeners": { "render": Lino.quicktip_renderer("Attach to email","Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n") }, "hideLabel": true, "checked": false, "name": "attach_to_email", "selectOnFocus": true, "anchor": "100%" });
    var main_2_panel703 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 40, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method699, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template700, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email_template701, "labelAlign": "top" }, { "flex": 20, "autoHeight": true, "layout": "form", "xtype": "panel", "items": attach_to_email702, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 144, "border": false, "labelAlign": "top" });
    var cal_EventsByType_grid733 = new Lino.cal.EventsByType.GridPanel({ "flex": 71, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.cal.EventsByType.default_action) ], "master_panel": this });
    var main_panel734 = new Ext.Panel({ "layout": "vbox", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "autoScroll": true, "items": [ main_1_panel694, main_2_panel703, cal_EventsByType_grid733 ], "hideCheckBoxLabels": true, "border": false, "labelAlign": "top" });
    this.items = main_panel734;
    this.before_row_edit = function(record) {
      template700.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      cal_EventsByType_grid733.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method699.on('change',Lino.chooser_handler(template700,'build_method'));
      Lino.cal.EventTypes.FormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.cal.EventTypes.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 39,
  initComponent : function() {
    var containing_panel = this;
    var subject120 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Subject", "anchor": "100%", "name": "subject" });
    var project121 = new Lino.TwinCombo({ "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail_action)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }) });
    var date122 = new Lino.DateField({ "disabled": true, "listeners": { "render": Lino.quicktip_renderer("Date","\n        The official date to be printed on the document.\n        ") }, "readOnly": true, "name": "date", "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Date</span>", "anchor": "100%" });
    var main_1_panel123 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": subject120, "labelAlign": "top" }, { "flex": 41, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project121, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date122, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var user127 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }) });
    var sent128 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "sent", "name": "sent", "anchor": "100%", "value": "<br>" });
    var id129 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var owner_disp130 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "Controlled by", "anchor": "100%", "name": "owner" });
    var main_2_panel131 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user127, "labelAlign": "top" }, { "flex": 24, "autoHeight": true, "layout": "form", "xtype": "panel", "items": sent128, "labelAlign": "top" }, { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id129, "labelAlign": "top" }, { "flex": 45, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp130, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var RecipientsByMail_grid142 = new Lino.outbox.RecipientsByMail.GridPanel({ "flex": 55, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.outbox.RecipientsByMail.default_action) ], "master_panel": this });
    var AttachmentsByMail_htmlbox143 = new Lino.HtmlBoxPanel({ "flex": 22, "layout": "fit", "name": "AttachmentsByMail", "containing_panel": this, "items": new Ext.BoxComponent(), "title": "Attachments", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "autoScroll": true, "tools": [ Lino.show_in_own_window_button(Lino.outbox.AttachmentsByMail.default_action) ] });
    var UploadsByController_htmlbox144 = new Lino.HtmlBoxPanel({ "flex": 22, "ls_bbar_actions": [ { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ], "name": "UploadsByController", "containing_panel": this, "items": new Ext.BoxComponent(), "title": "Uploads", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "ls_insert_handler": Lino.uploads.UploadsByController.insert_action, "autoScroll": true, "layout": "fit", "tools": [ Lino.show_in_own_window_button(Lino.uploads.UploadsByController.default_action) ] });
    var main_3_panel145 = new Ext.Panel({ "flex": 26, "layout": "hbox", "items": [ RecipientsByMail_grid142, AttachmentsByMail_htmlbox143, UploadsByController_htmlbox144 ], "frame": false, "layoutConfig": { "align": "stretch" }, "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    var body146 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 52, "containing_panel": this, "name": "body", "title": "Body" });
    var main_panel147 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": true, "items": [ main_1_panel123, main_2_panel131, main_3_panel145, body146 ], "hideCheckBoxLabels": true, "labelWidth": 0, "border": false, "labelAlign": "top" });
    this.items = main_panel147;
    this.before_row_edit = function(record) {
      RecipientsByMail_grid142.on_master_changed();
      AttachmentsByMail_htmlbox143.refresh();
      UploadsByController_htmlbox144.refresh();
      body146.refresh();
    }
    Lino.outbox.Mails.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 37,
  initComponent : function() {
    var containing_panel = this;
    var start_date735 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Start date", "anchor": "100%", "name": "start_date" });
    var state736 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "State", "name": "state", "selectOnFocus": true, "anchor": "100%", "store": [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "40", "Cancelled" ] ], "hiddenName": "stateHidden" });
    var due_date737 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Due date", "anchor": "100%", "name": "due_date" });
    var id738 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var main_1_panel739 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_date735, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": state736, "labelAlign": "top" }, { "flex": 26, "autoHeight": true, "layout": "form", "xtype": "panel", "items": due_date737, "labelAlign": "top" }, { "flex": 16, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id738, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var summary744 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Summary", "anchor": "100%", "name": "summary" });
    var user745 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }) });
    var project746 = new Lino.TwinCombo({ "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail_action)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }) });
    var main_3_panel747 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user745, "labelAlign": "top" }, { "flex": 57, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project746, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    var calendar750 = new Lino.TwinCombo({ "fieldLabel": "Calendar", "name": "calendar", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.cal.PanelCalendars.detail_action)}, "emptyText": "Select a Calendar...", "selectOnFocus": true, "hiddenName": "calendarHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }) });
    var owner_disp751 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "Controlled by", "anchor": "100%", "name": "owner" });
    var created752 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "created", "name": "created", "anchor": "100%", "value": "<br>" });
    var modified753 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "modified", "name": "modified", "anchor": "100%", "value": "<br>" });
    var main_4_panel754 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": calendar750, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": owner_disp751, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created752, "labelAlign": "top" }, { "flex": 22, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified753, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 126, "border": false, "labelAlign": "top" });
    var description759 = new Lino.RichTextPanel({ "selectOnFocus": true, "flex": 45, "title": "Description", "name": "description", "containing_panel": this });
    var main_panel760 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": true, "items": [ main_1_panel739, { "items": summary744, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" }, main_3_panel747, main_4_panel754, description759 ], "hideCheckBoxLabels": true, "labelWidth": 72, "border": false, "labelAlign": "top" });
    this.items = main_panel760;
    this.before_row_edit = function(record) {
      description759.refresh();
    }
    Lino.cal.Tasks.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 5,
  initComponent : function() {
    var containing_panel = this;
    var username762 = new Ext.form.TextField({ "listeners": { "render": Lino.quicktip_renderer("Username","\n        Required. Must be unique. \n        ") }, "fieldLabel": "<span style=\"border-bottom: 1px dotted #000000;\">Username</span>", "name": "username", "maxLength": 30, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var id763 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var profile764 = new Lino.ChoicesFieldElement({ "forceSelection": true, "fieldLabel": "User Profile", "name": "profile", "selectOnFocus": true, "anchor": "100%", "store": [ [ "10", "User" ], [ "20", "Administrator" ] ], "hiddenName": "profileHidden" });
    var box1_1_panel765 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 52, "autoHeight": true, "layout": "form", "xtype": "panel", "items": username762, "labelAlign": "top" }, { "flex": 13, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id763, "labelAlign": "top" }, { "flex": 34, "autoHeight": true, "layout": "form", "xtype": "panel", "items": profile764, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "anchor": "100%", "labelAlign": "top" });
    var first_name769 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "First name", "anchor": "100%", "name": "first_name" });
    var last_name770 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30, "fieldLabel": "Last name", "anchor": "100%", "name": "last_name" });
    var partner771 = new Lino.TwinCombo({ "fieldLabel": "Partner", "name": "partner", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.contacts.AllPartners.detail_action)}, "emptyText": "Select a Partner...", "selectOnFocus": true, "hiddenName": "partnerHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }) });
    var box1_2_panel772 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": first_name769, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": last_name770, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": partner771, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "anchor": "100%", "labelAlign": "top" });
    var email776 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75, "fieldLabel": "e-mail address", "anchor": "100%", "name": "email" });
    var language777 = new Lino.ChoicesFieldElement({ "fieldLabel": "Language", "allowBlank": false, "value": "en", "hiddenName": "languageHidden", "selectOnFocus": true, "anchor": "100%", "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "name": "language" });
    var box1_3_panel778 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": email776, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": language777, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 135, "border": false, "anchor": "100%", "labelAlign": "top" });
    var created781 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "created", "name": "created", "anchor": "100%", "value": "<br>" });
    var modified782 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "modified", "name": "modified", "anchor": "100%", "value": "<br>" });
    var box1_4_panel783 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": created781, "labelAlign": "top" }, { "flex": 50, "autoHeight": true, "layout": "form", "xtype": "panel", "items": modified782, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 81, "border": false, "anchor": "100%", "labelAlign": "top" });
    var box1_panel786 = new Ext.Panel({ "autoHeight": true, "layout": "form", "items": [ box1_1_panel765, box1_2_panel772, box1_3_panel778, box1_4_panel783 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    var remarks787 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remarks", "anchor": "100% 100%", "growMax": 2000, "name": "remarks" });
    var general_panel788 = new Ext.Panel({ "labelWidth": 72, "title": "General", "layoutConfig": { "align": "stretch" }, "frame": true, "bodyBorder": false, "listeners": { "activate": Lino.on_tab_activate }, "items": [ box1_panel786, { "items": remarks787, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 55 } ], "hideCheckBoxLabels": true, "layout": "vbox", "border": false, "labelAlign": "top" });
    var cal_RemindersByUser_grid811 = new Lino.cal.RemindersByUser.GridPanel({ "listeners": { "activate": Lino.on_tab_activate }, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "hide_top_toolbar": true, "containing_panel": this, "title": "Reminders", "tools": [ Lino.show_in_own_window_button(Lino.cal.RemindersByUser.default_action) ], "master_panel": this });
    var main_panel812 = new Ext.TabPanel({ "autoScroll": true, "split": true, "hideCheckBoxLabels": true, "items": [ general_panel788, cal_RemindersByUser_grid811 ], "activeTab": 0, "labelAlign": "top" });
    this.items = main_panel812;
    this.before_row_edit = function(record) {
      cal_RemindersByUser_grid811.on_master_changed();
    }
    Lino.users.Users.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Sessions.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 23,
  initComponent : function() {
    var containing_panel = this;
    var date300 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false, "fieldLabel": "Date", "anchor": "100%", "name": "date" });
    var start_time301 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Start time", "anchor": "100%", "name": "start_time" });
    var end_time302 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "End Time", "anchor": "100%", "name": "end_time" });
    var break_time303 = new Lino.TimeField({ "selectOnFocus": true, "fieldLabel": "Break Time", "anchor": "100%", "name": "break_time" });
    var project304 = new Lino.TwinCombo({ "fieldLabel": "Project", "name": "project", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Projects.detail_action)}, "emptyText": "Select a Project...", "selectOnFocus": true, "hiddenName": "projectHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/project", "method": "GET" }) }) });
    var ticket305 = new Lino.TwinCombo({ "fieldLabel": "Ticket", "name": "ticket", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.tickets.Tickets.detail_action)}, "emptyText": "Select a Ticket...", "selectOnFocus": true, "hiddenName": "ticketHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/ticket", "method": "GET" }) }) });
    var main_1_panel306 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": date300, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": start_time301, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": end_time302, "labelAlign": "top" }, { "flex": 11, "autoHeight": true, "layout": "form", "xtype": "panel", "items": break_time303, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": project304, "labelAlign": "top" }, { "flex": 27, "autoHeight": true, "layout": "form", "xtype": "panel", "items": ticket305, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 99, "border": false, "labelAlign": "top" });
    var user313 = new Lino.TwinCombo({ "fieldLabel": "User", "name": "user", "pageSize": 20, "onTrigger2Click": function(e){ Lino.show_fk_detail(this,Lino.users.Users.detail_action)}, "emptyText": "Select a User...", "selectOnFocus": true, "hiddenName": "userHidden", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/user", "method": "GET" }) }) });
    var id314 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var main_2_panel315 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 75, "autoHeight": true, "layout": "form", "xtype": "panel", "items": user313, "labelAlign": "top" }, { "flex": 25, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id314, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 45, "border": false, "labelAlign": "top" });
    var description318 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Description", "anchor": "100% 100%", "growMax": 2000, "name": "description" });
    var EntriesBySession_grid332 = new Lino.tickets.EntriesBySession.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.tickets.EntriesBySession.default_action) ], "master_panel": this });
    var main_panel333 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": true, "items": [ main_1_panel306, main_2_panel315, { "items": description318, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, EntriesBySession_grid332 ], "hideCheckBoxLabels": true, "labelWidth": 108, "border": false, "labelAlign": "top" });
    this.items = main_panel333;
    this.before_row_edit = function(record) {
      EntriesBySession_grid332.on_master_changed();
    }
    Lino.tickets.Sessions.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.About.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  initComponent : function() {
    var containing_panel = this;
    var startup_time814 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "fieldLabel": "Server up since", "name": "startup_time", "anchor": "100%", "value": "<br>" });
    var main_1_panel815 = new Ext.Panel({ "flex": 5, "autoHeight": true, "labelWidth": 144, "items": [ { "flex": 57, "html": "<a href=\"http://lino.saffre-rumma.net\" target=\"_blank\">Lino</a> 1.4.4<br/><a href=\"http://www.djangoproject.com\" target=\"_blank\">Django</a> 1.5.dev17937<br/><a href=\"http://labix.org/python-dateutil\" target=\"_blank\">python-dateutil</a> 1.5<br/><a href=\"http://cheetahtemplate.org/\" target=\"_blank\">Cheetah</a> 2.4.4<br/><a href=\"http://pypi.python.org/pypi/odfpy\" target=\"_blank\">OdfPy</a> ODFPY/0.9.4<br/><a href=\"http://docutils.sourceforge.net/\" target=\"_blank\">docutils</a> 0.7<br/><a href=\"https://fedorahosted.org/suds/\" target=\"_blank\">suds</a> 0.4.1<br/><a href=\"http://pyyaml.org/\" target=\"_blank\">PyYaml</a> 3.08<br/><a href=\"http://appyframework.org/pod.html\" target=\"_blank\">Appy</a> 0.8.0 (2011/12/15 22:41)<br/><a href=\"http://www.python.org/\" target=\"_blank\">Python</a> 2.7.1<br/><a href=\"http://www.sencha.com\" target=\"_blank\">ExtJS</a> <a href=\"#\" onclick=\"alert('ExtJS client version is ' + Ext.version);\" title=\"Click to see ExtJS client version\">(version)</a>", "xtype": "label" }, { "flex": 42, "autoHeight": true, "layout": "form", "xtype": "panel", "items": startup_time814, "labelAlign": "top" } ], "frame": false, "split": true, "hideCheckBoxLabels": true, "layout": "hbox", "border": false, "region": "north", "labelAlign": "top" });
    var Models_htmlbox817 = new Lino.HtmlBoxPanel({ "flex": 10, "layout": "fit", "name": "Models", "containing_panel": this, "items": new Ext.BoxComponent(), "region": "center", "title": "Models", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "split": true, "autoScroll": true, "tools": [ Lino.show_in_own_window_button(Lino.lino.Models.default_action) ] });
    var main_panel818 = new Lino.VBorderPanel({ "autoScroll": true, "labelWidth": 63, "items": [ main_1_panel815, Models_htmlbox817 ], "hideCheckBoxLabels": true, "bodyBorder": false, "frame": true, "border": false, "labelAlign": "top" });
    this.items = main_panel818;
    this.before_row_edit = function(record) {
      Models_htmlbox817.refresh();
    }
    Lino.lino.About.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.EntryTypes.FormPanel = Ext.extend(Lino.FormPanel,{
  layout: 'fit',
  auto_save: true,
  content_type: 20,
  initComponent : function() {
    var containing_panel = this;
    var id819 = { "fieldLabel": "ID", "xtype": "numberfield", "selectOnFocus": true, "anchor": "100%", "name": "id" };
    var name820 = new Ext.form.TextField({ "fieldLabel": "Designation", "name": "name", "maxLength": 200, "selectOnFocus": true, "anchor": "100%", "allowBlank": false });
    var name_de821 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (de)", "anchor": "100%", "name": "name_de" });
    var name_fr822 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200, "fieldLabel": "Designation (fr)", "anchor": "100%", "name": "name_fr" });
    var main_1_panel823 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 7, "autoHeight": true, "layout": "form", "xtype": "panel", "items": id819, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name820, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_de821, "labelAlign": "top" }, { "flex": 30, "autoHeight": true, "layout": "form", "xtype": "panel", "items": name_fr822, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 153, "border": false, "labelAlign": "top" });
    var build_method828 = new Lino.ChoicesFieldElement({ "fieldLabel": "Build method", "name": "build_method", "selectOnFocus": true, "anchor": "100%", "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "hiddenName": "build_methodHidden" });
    var template829 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "fieldLabel": "Template", "anchor": "100%", "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntryTypes/template", "method": "GET" }) }), "name": "template" });
    var main_2_panel830 = new Ext.Panel({ "autoHeight": true, "layout": "hbox", "items": [ { "flex": 66, "autoHeight": true, "layout": "form", "xtype": "panel", "items": build_method828, "labelAlign": "top" }, { "flex": 33, "autoHeight": true, "layout": "form", "xtype": "panel", "items": template829, "labelAlign": "top" } ], "frame": false, "layoutConfig": { "align": "stretchmax" }, "hideCheckBoxLabels": true, "labelWidth": 117, "border": false, "labelAlign": "top" });
    var remark833 = new Ext.form.TextArea({ "selectOnFocus": true, "fieldLabel": "Remark", "anchor": "100% 100%", "growMax": 2000, "name": "remark" });
    var blogs_EntriesByType_grid847 = new Lino.blogs.EntriesByType.GridPanel({ "flex": 41, "hide_top_toolbar": true, "containing_panel": this, "viewConfig": { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." }, "tools": [ Lino.show_in_own_window_button(Lino.blogs.EntriesByType.default_action) ], "master_panel": this });
    var main_panel848 = new Ext.Panel({ "layout": "vbox", "bodyBorder": false, "frame": true, "layoutConfig": { "align": "stretch" }, "autoScroll": true, "items": [ main_1_panel823, main_2_panel830, { "items": remark833, "labelAlign": "top", "layout": "form", "xtype": "panel", "flex": 41 }, blogs_EntriesByType_grid847 ], "hideCheckBoxLabels": true, "labelWidth": 63, "border": false, "labelAlign": "top" });
    this.items = main_panel848;
    this.before_row_edit = function(record) {
      template829.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
      blogs_EntriesByType_grid847.on_master_changed();
    }
    this.onRender = function(ct, position) {
      build_method828.on('change',Lino.chooser_handler(template829,'build_method'));
      Lino.blogs.EntryTypes.FormPanel.superclass.onRender.call(this, ct, position);
    }
    Lino.blogs.EntryTypes.FormPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/users/Users",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "update_reminders", "text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('UpdateReminders') } ],
  title : "Users",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "username" }, { "name": "profile" },'profileHidden', { "name": "first_name" }, { "name": "last_name" }, { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "email" }, { "name": "remarks" }, { "name": "language" },'languageHidden', { "name": "partner" },'partnerHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 5,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail_action;
    this.ls_insert_handler = Lino.users.Users.insert_action;
    var ww = this.containing_window;
    var username850 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 30 });
    var profile851 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "User" ], [ "20", "Administrator" ] ] });
    var first_name852 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var last_name853 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var id854 = { "selectOnFocus": true, "xtype": "numberfield" };
    var created855 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified856 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var email857 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var remarks858 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var language859 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var partner860 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/users/Users/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Username", "editable": true, "tooltip": "\n        Required. Must be unique. \n        ", "filter": { "type": "string" }, "width": 180, "dataIndex": "username", "hidden": false, "editor": username850 }, { "colIndex": 1, "sortable": true, "header": "User Profile", "editable": true, "filter": { "type": "string" }, "width": 117, "dataIndex": "profile", "hidden": false, "editor": profile851 }, { "colIndex": 2, "sortable": true, "header": "First name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "first_name", "hidden": false, "editor": first_name852 }, { "colIndex": 3, "sortable": true, "header": "Last name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "last_name", "hidden": false, "editor": last_name853 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id854, "dataIndex": "id" }, { "width": 144, "colIndex": 5, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 6, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 7, "sortable": true, "header": "e-mail address", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "email", "hidden": false, "editor": email857 }, { "colIndex": 8, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": remarks858, "dataIndex": "remarks" }, { "colIndex": 9, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language859 }, { "colIndex": 10, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner860, "dataIndex": "partner" } ];
    Lino.users.Users.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.users.Users.insert_actionPanel = Ext.extend(Lino.users.Users.FormPanel,{
  empty_title: "New Users",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/users/Users",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail_action;
    this.ls_insert_handler = Lino.users.Users.insert_action;
    Lino.users.Users.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.users.Users.insert_actionPanel(p);
  return rv;
});

Lino.users.Users.detail_actionPanel = Ext.extend(Lino.users.Users.FormPanel,{
  empty_title: "Detail Users",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "update_reminders", "text": "Update Reminders", "must_save": true, "panel_btn_handler": Lino.row_action_handler('UpdateReminders') } ],
  ls_url: "/users/Users",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.users.Users.detail_action;
    this.ls_insert_handler = Lino.users.Users.insert_action;
    Lino.users.Users.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.users.Users.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.users.Users.detail_actionPanel(p);
  return rv;
});
Lino.users.Users.update_reminders = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/users/Users",pk,"UpdateReminders");
};
Lino.users.Users.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.users.Users.GridPanel(p);
  return rv;
});

Lino.lino.SiteConfigs.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/lino/SiteConfigs",
  ls_bbar_actions : [ { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "do_build", "text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('buildjs') } ],
  title : "site configs",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "default_build_method" },'default_build_methodHidden', { "type": "int", "name": "next_partner_id" }, { "name": "site_company" },'site_companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 4,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.SiteConfigs.detail_action;
    this.ls_insert_handler = Lino.lino.SiteConfigs.insert_action;
    var ww = this.containing_window;
    var id873 = { "selectOnFocus": true, "xtype": "numberfield" };
    var default_build_method874 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ], "value": "appyodt" });
    var next_partner_id875 = { "selectOnFocus": true, "xtype": "numberfield", "value": 100, "allowBlank": false };
    var site_company876 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/SiteConfigs/site_company", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Company..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id873, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Default build method", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "default_build_method", "hidden": false, "editor": default_build_method874 }, { "colIndex": 2, "sortable": true, "header": "The next automatic id for Person or Company", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "next_partner_id", "hidden": false, "editor": next_partner_id875 }, { "colIndex": 3, "sortable": true, "width": 180, "editable": true, "tooltip": "The Company to be used as sender in documents.", "filter": { "type": "string" }, "header": "The company that runs this site", "renderer": Lino.fk_renderer('site_companyHidden','Lino.contacts.Companies.detail_action'), "hidden": false, "editor": site_company876, "dataIndex": "site_company" } ];
    Lino.lino.SiteConfigs.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.SiteConfigs.insert_actionPanel = Ext.extend(Lino.lino.SiteConfigs.FormPanel,{
  empty_title: "New site configs",
  hide_navigator: true,
  ls_bbar_actions: [  ],
  ls_url: "/lino/SiteConfigs",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.SiteConfigs.detail_action;
    this.ls_insert_handler = Lino.lino.SiteConfigs.insert_action;
    Lino.lino.SiteConfigs.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.SiteConfigs.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.lino.SiteConfigs.insert_actionPanel(p);
  return rv;
});

Lino.lino.SiteConfigs.detail_actionPanel = Ext.extend(Lino.lino.SiteConfigs.FormPanel,{
  empty_title: "Detail site configs",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_build", "text": "Rebuild site cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('buildjs') } ],
  ls_url: "/lino/SiteConfigs",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.SiteConfigs.detail_action;
    this.ls_insert_handler = Lino.lino.SiteConfigs.insert_action;
    Lino.lino.SiteConfigs.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.SiteConfigs.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.lino.SiteConfigs.detail_actionPanel(p);
  return rv;
});
Lino.lino.SiteConfigs.do_build = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/lino/SiteConfigs",pk,"buildjs");
};
Lino.lino.SiteConfigs.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.lino.SiteConfigs.GridPanel(p);
  return rv;
});

Lino.lino.ContentTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/lino/ContentTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "content types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "app_label" }, { "name": "model" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 1,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail_action;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert_action;
    var ww = this.containing_window;
    var id882 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name883 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var app_label884 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var model885 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id882, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name883 }, { "colIndex": 2, "sortable": true, "header": "app label", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "app_label", "hidden": false, "editor": app_label884 }, { "colIndex": 3, "sortable": true, "header": "python model class name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "model", "hidden": false, "editor": model885 } ];
    Lino.lino.ContentTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.ContentTypes.insert_actionPanel = Ext.extend(Lino.lino.ContentTypes.FormPanel,{
  empty_title: "New content types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/lino/ContentTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail_action;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert_action;
    Lino.lino.ContentTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ContentTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.lino.ContentTypes.insert_actionPanel(p);
  return rv;
});

Lino.lino.ContentTypes.detail_actionPanel = Ext.extend(Lino.lino.ContentTypes.FormPanel,{
  empty_title: "Detail content types",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/lino/ContentTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.ContentTypes.detail_action;
    this.ls_insert_handler = Lino.lino.ContentTypes.insert_action;
    Lino.lino.ContentTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.ContentTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.lino.ContentTypes.detail_actionPanel(p);
  return rv;
});
Lino.lino.ContentTypes.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.lino.ContentTypes.GridPanel(p);
  return rv;
});

Lino.lino.HelpTexts.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/lino/HelpTexts",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Help Texts",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "field" }, { "name": "verbose_name" }, { "name": "help_text" }, { "type": "int", "name": "id" }, { "name": "content_type" },'content_typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 2,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var field891 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "allowBlank": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/HelpTexts/field", "method": "GET" }) }) });
    var verbose_name892 = new Ext.form.TextField({ "disabled": true, "readOnly": true, "maxLength": 200 });
    var help_text893 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id894 = { "selectOnFocus": true, "xtype": "numberfield" };
    var content_type895 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/HelpTexts/content_type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a content type..." });
    this.before_row_edit = function(record) {
      field891.setContextValue('content_type',record ? record.data['content_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      content_type895.on('change',Lino.chooser_handler(field891,'content_type'));
      Lino.lino.HelpTexts.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Field", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "field", "hidden": false, "editor": field891 }, { "colIndex": 1, "sortable": false, "header": "Verbose name", "editable": false, "filter": { "type": "string" }, "width": 180, "dataIndex": "verbose_name", "hidden": false }, { "colIndex": 2, "sortable": false, "header": "HelpText", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": help_text893, "dataIndex": "help_text" }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id894, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Model", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('content_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": content_type895, "dataIndex": "content_type" } ];
    Lino.lino.HelpTexts.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.HelpTexts.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.lino.HelpTexts.GridPanel(p);
  return rv;
});

Lino.lino.TextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/lino/TextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Text Field Templates",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "name" }, { "name": "description" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.TextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.TextFieldTemplates.insert_action;
    var ww = this.containing_window;
    var id902 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user903 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/lino/TextFieldTemplates/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var name904 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description905 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var text906 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Template Text", "containing_panel": this });
    this.before_row_edit = function(record) {
      description905.refresh();
      text906.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id902, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user903, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name904 }, { "colIndex": 3, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description905, "dataIndex": "description" }, { "colIndex": 4, "sortable": false, "header": "text", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": text906, "dataIndex": "text" } ];
    Lino.lino.TextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.TextFieldTemplates.insert_actionPanel = Ext.extend(Lino.lino.TextFieldTemplates.FormPanel,{
  empty_title: "New Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/lino/TextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.TextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.TextFieldTemplates.insert_action;
    Lino.lino.TextFieldTemplates.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.TextFieldTemplates.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.lino.TextFieldTemplates.insert_actionPanel(p);
  return rv;
});

Lino.lino.TextFieldTemplates.detail_actionPanel = Ext.extend(Lino.lino.TextFieldTemplates.FormPanel,{
  empty_title: "Detail Text Field Templates",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/lino/TextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.TextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.TextFieldTemplates.insert_action;
    Lino.lino.TextFieldTemplates.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.TextFieldTemplates.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.lino.TextFieldTemplates.detail_actionPanel(p);
  return rv;
});
Lino.lino.TextFieldTemplates.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.lino.TextFieldTemplates.GridPanel(p);
  return rv;
});

Lino.countries.Languages.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Languages",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Languages",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "id" }, { "name": "iso2" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 8,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name913 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de914 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr915 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id916 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 3 });
    var iso2917 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 2 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name913 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de914 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr915 }, { "colIndex": 3, "sortable": true, "header": "id", "editable": true, "filter": { "type": "string" }, "width": 27, "dataIndex": "id", "hidden": false, "editor": id916 }, { "colIndex": 4, "sortable": true, "header": "iso2", "editable": true, "filter": { "type": "string" }, "width": 27, "dataIndex": "iso2", "hidden": false, "editor": iso2917 } ];
    Lino.countries.Languages.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Languages.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.countries.Languages.GridPanel(p);
  return rv;
});

Lino.countries.Countries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Countries",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Countries",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "isocode" }, { "name": "short_code" }, { "name": "iso3" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 7,
  ls_id_property : "isocode",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail_action;
    this.ls_insert_handler = Lino.countries.Countries.insert_action;
    var ww = this.containing_window;
    var name924 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de925 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr926 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var isocode927 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 4 });
    var short_code928 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 4 });
    var iso3929 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 3 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name924 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de925 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr926 }, { "colIndex": 3, "sortable": true, "header": "isocode", "editable": true, "filter": { "type": "string" }, "width": 36, "dataIndex": "isocode", "hidden": false, "editor": isocode927 }, { "colIndex": 4, "sortable": true, "header": "short code", "editable": true, "filter": { "type": "string" }, "width": 36, "dataIndex": "short_code", "hidden": false, "editor": short_code928 }, { "colIndex": 5, "sortable": true, "header": "iso3", "editable": true, "filter": { "type": "string" }, "width": 27, "dataIndex": "iso3", "hidden": false, "editor": iso3929 } ];
    Lino.countries.Countries.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Countries.insert_actionPanel = Ext.extend(Lino.countries.Countries.FormPanel,{
  empty_title: "New Countries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/countries/Countries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail_action;
    this.ls_insert_handler = Lino.countries.Countries.insert_action;
    Lino.countries.Countries.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.countries.Countries.insert_actionPanel(p);
  return rv;
});

Lino.countries.Countries.detail_actionPanel = Ext.extend(Lino.countries.Countries.FormPanel,{
  empty_title: "Detail Countries",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/countries/Countries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Countries.detail_action;
    this.ls_insert_handler = Lino.countries.Countries.insert_action;
    Lino.countries.Countries.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Countries.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.countries.Countries.detail_actionPanel(p);
  return rv;
});
Lino.countries.Countries.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.countries.Countries.GridPanel(p);
  return rv;
});

Lino.countries.Cities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/Cities",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Cities",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "country" },'countryHidden', { "name": "name" }, { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail_action;
    this.ls_insert_handler = Lino.countries.Cities.insert_action;
    var ww = this.containing_window;
    var country937 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/countries/Cities/country", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Country..." });
    var name938 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var zip_code939 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 8 });
    var id940 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country937, "dataIndex": "country" }, { "colIndex": 1, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name938 }, { "colIndex": 2, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": 72, "dataIndex": "zip_code", "hidden": false, "editor": zip_code939 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id940, "dataIndex": "id" } ];
    Lino.countries.Cities.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.Cities.insert_actionPanel = Ext.extend(Lino.countries.Cities.FormPanel,{
  empty_title: "New Cities",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/countries/Cities",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail_action;
    this.ls_insert_handler = Lino.countries.Cities.insert_action;
    Lino.countries.Cities.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.countries.Cities.insert_actionPanel(p);
  return rv;
});

Lino.countries.Cities.detail_actionPanel = Ext.extend(Lino.countries.Cities.FormPanel,{
  empty_title: "Detail Cities",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/countries/Cities",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.Cities.detail_action;
    this.ls_insert_handler = Lino.countries.Cities.insert_action;
    Lino.countries.Cities.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.Cities.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.countries.Cities.detail_actionPanel(p);
  return rv;
});
Lino.countries.Cities.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.countries.Cities.GridPanel(p);
  return rv;
});

Lino.properties.PropGroups.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropGroups",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Property Groups",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 11,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail_action;
    this.ls_insert_handler = Lino.properties.PropGroups.insert_action;
    var ww = this.containing_window;
    var id946 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name947 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de948 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr949 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id946, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name947 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de948 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr949 } ];
    Lino.properties.PropGroups.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropGroups.insert_actionPanel = Ext.extend(Lino.properties.PropGroups.FormPanel,{
  empty_title: "New Property Groups",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/properties/PropGroups",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail_action;
    this.ls_insert_handler = Lino.properties.PropGroups.insert_action;
    Lino.properties.PropGroups.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.properties.PropGroups.insert_actionPanel(p);
  return rv;
});

Lino.properties.PropGroups.detail_actionPanel = Ext.extend(Lino.properties.PropGroups.FormPanel,{
  empty_title: "Detail Property Groups",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/properties/PropGroups",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropGroups.detail_action;
    this.ls_insert_handler = Lino.properties.PropGroups.insert_action;
    Lino.properties.PropGroups.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropGroups.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.properties.PropGroups.detail_actionPanel(p);
  return rv;
});
Lino.properties.PropGroups.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.properties.PropGroups.GridPanel(p);
  return rv;
});

Lino.properties.PropTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Property Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "choicelist" },'choicelistHidden', { "name": "default_value" },'default_valueHidden', { "type": "boolean", "name": "limit_to_choices" }, { "type": "boolean", "name": "multiple_choices" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 12,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail_action;
    this.ls_insert_handler = Lino.properties.PropTypes.insert_action;
    var ww = this.containing_window;
    var id955 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name956 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de957 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr958 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var choicelist959 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "DoYouLike", "certainly not...very much" ], [ "Gender", "Gender" ], [ "HowWell", "not at all...very well" ], [ "UserGroups", "User Group" ], [ "UserLevels", "User Level" ], [ "UserProfiles", "User Profile" ] ] });
    var default_value960 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropTypes/default_value", "method": "GET" }) }) });
    var limit_to_choices961 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var multiple_choices962 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      default_value960.setContextValue('choicelist',record ? record.data['choicelistHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      choicelist959.on('change',Lino.chooser_handler(default_value960,'choicelist'));
      Lino.properties.PropTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id955, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name956 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de957 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr958 }, { "colIndex": 4, "sortable": true, "header": "Choices List", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "choicelist", "hidden": false, "editor": choicelist959 }, { "colIndex": 5, "sortable": true, "header": "default value", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "default_value", "hidden": false, "editor": default_value960 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Limit to choices", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "limit_to_choices", "hidden": false }, { "colIndex": 7, "sortable": false, "xtype": "checkcolumn", "header": "Multiple choices", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "multiple_choices", "hidden": false } ];
    Lino.properties.PropTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.properties.PropTypes.insert_actionPanel = Ext.extend(Lino.properties.PropTypes.FormPanel,{
  empty_title: "New Property Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/properties/PropTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail_action;
    this.ls_insert_handler = Lino.properties.PropTypes.insert_action;
    Lino.properties.PropTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.properties.PropTypes.insert_actionPanel(p);
  return rv;
});

Lino.properties.PropTypes.detail_actionPanel = Ext.extend(Lino.properties.PropTypes.FormPanel,{
  empty_title: "Detail Property Types",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/properties/PropTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.properties.PropTypes.detail_action;
    this.ls_insert_handler = Lino.properties.PropTypes.insert_action;
    Lino.properties.PropTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.properties.PropTypes.detail_actionPanel(p);
  return rv;
});
Lino.properties.PropTypes.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.properties.PropTypes.GridPanel(p);
  return rv;
});

Lino.properties.Properties.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/Properties",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Properties",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "group" },'groupHidden', { "name": "type" },'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id972 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name973 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de974 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr975 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group976 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Group..." });
    var type977 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/Properties/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id972, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name973 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de974 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr975 }, { "colIndex": 4, "sortable": true, "header": "Property Group", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail_action'), "hidden": false, "editor": group976, "dataIndex": "group" }, { "colIndex": 5, "sortable": true, "header": "Property Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail_action'), "hidden": false, "editor": type977, "dataIndex": "type" } ];
    Lino.properties.Properties.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.Properties.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.properties.Properties.GridPanel(p);
  return rv;
});

Lino.properties.PropChoices.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropChoices",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Property Choices",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" },'typeHidden', { "name": "value" }, { "name": "text" }, { "name": "text_de" }, { "name": "text_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id985 = { "selectOnFocus": true, "xtype": "numberfield" };
    var type986 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropChoices/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Type..." });
    var value987 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text988 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_de989 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr990 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id985, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Property Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail_action'), "hidden": false, "editor": type986, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Value", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "value", "hidden": false, "editor": value987 }, { "colIndex": 3, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "text", "hidden": false, "editor": text988 }, { "colIndex": 4, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "text_de", "hidden": false, "editor": text_de989 }, { "colIndex": 5, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "text_fr", "hidden": false, "editor": text_fr990 } ];
    Lino.properties.PropChoices.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropChoices.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.properties.PropChoices.GridPanel(p);
  return rv;
});

Lino.contacts.CompanyTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/CompanyTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "company types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "abbr" }, { "name": "abbr_de" }, { "name": "abbr_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 18,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var name998 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de999 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1000 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1001 = { "selectOnFocus": true, "xtype": "numberfield" };
    var abbr1002 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_de1003 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    var abbr_fr1004 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 30 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name998 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de999 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1000 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1001, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Abbreviation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "abbr", "hidden": false, "editor": abbr1002 }, { "colIndex": 5, "sortable": true, "header": "Abbreviation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "abbr_de", "hidden": false, "editor": abbr_de1003 }, { "colIndex": 6, "sortable": true, "header": "Abbreviation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "abbr_fr", "hidden": false, "editor": abbr_fr1004 } ];
    Lino.contacts.CompanyTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.CompanyTypes.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.CompanyTypes.GridPanel(p);
  return rv;
});

Lino.contacts.Partners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Partners",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "zip_code" }, { "name": "region" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 21,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 23,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail_action;
    this.ls_insert_handler = Lino.contacts.Partners.insert_action;
    var ww = this.containing_window;
    var name1013 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1014 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1015 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1016 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Partners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a City..." });
    var addr11017 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1018 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1019 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1020 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var street_box1021 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var addr21022 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var zip_code1023 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var region1024 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1025 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var url1026 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1027 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1028 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1029 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1030 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1031 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city1016.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1015.on('change',Lino.chooser_handler(city1016,'country'));
      Lino.contacts.Partners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1013 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "email", "hidden": false, "editor": email1014 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country1015, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "City", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city1016, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr1", "hidden": false, "editor": addr11017 }, { "colIndex": 5, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix1018 }, { "colIndex": 6, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street", "hidden": false, "editor": street1019 }, { "colIndex": 7, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_no", "hidden": false, "editor": street_no1020 }, { "colIndex": 8, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_box", "hidden": false, "editor": street_box1021 }, { "colIndex": 9, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr2", "hidden": false, "editor": addr21022 }, { "colIndex": 10, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "zip_code", "hidden": false, "editor": zip_code1023 }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "region", "hidden": false, "editor": region1024 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language1025 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "url", "hidden": false, "editor": url1026 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "phone", "hidden": false, "editor": phone1027 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "gsm", "hidden": false, "editor": gsm1028 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "fax", "hidden": false, "editor": fax1029 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": remarks1030, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1031, "dataIndex": "id" } ];
    Lino.contacts.Partners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Partners.insert_actionPanel = Ext.extend(Lino.contacts.Partners.FormPanel,{
  empty_title: "New Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/Partners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail_action;
    this.ls_insert_handler = Lino.contacts.Partners.insert_action;
    Lino.contacts.Partners.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.contacts.Partners.insert_actionPanel(p);
  return rv;
});

Lino.contacts.Partners.detail_actionPanel = Ext.extend(Lino.contacts.Partners.FormPanel,{
  empty_title: "Detail Partners",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/Partners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Partners.detail_action;
    this.ls_insert_handler = Lino.contacts.Partners.insert_action;
    Lino.contacts.Partners.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Partners.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.Partners.detail_actionPanel(p);
  return rv;
});
Lino.contacts.Partners.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.Partners.GridPanel(p);
  return rv;
});

Lino.contacts.AllPartners.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/AllPartners",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "All Partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "zip_code" }, { "name": "region" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 21,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 23,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.AllPartners.detail_action;
    this.ls_insert_handler = Lino.contacts.AllPartners.insert_action;
    var ww = this.containing_window;
    var name1052 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1053 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1054 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/AllPartners/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1055 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/AllPartners/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a City..." });
    var addr11056 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1057 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1058 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1059 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var street_box1060 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var addr21061 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var zip_code1062 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var region1063 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1064 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var url1065 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1066 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1067 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1068 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1069 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1070 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city1055.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1054.on('change',Lino.chooser_handler(city1055,'country'));
      Lino.contacts.AllPartners.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1052 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "email", "hidden": false, "editor": email1053 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country1054, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "City", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city1055, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr1", "hidden": false, "editor": addr11056 }, { "colIndex": 5, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix1057 }, { "colIndex": 6, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street", "hidden": false, "editor": street1058 }, { "colIndex": 7, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_no", "hidden": false, "editor": street_no1059 }, { "colIndex": 8, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_box", "hidden": false, "editor": street_box1060 }, { "colIndex": 9, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr2", "hidden": false, "editor": addr21061 }, { "colIndex": 10, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "zip_code", "hidden": false, "editor": zip_code1062 }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "region", "hidden": false, "editor": region1063 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language1064 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "url", "hidden": false, "editor": url1065 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "phone", "hidden": false, "editor": phone1066 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "gsm", "hidden": false, "editor": gsm1067 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "fax", "hidden": false, "editor": fax1068 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": remarks1069, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1070, "dataIndex": "id" } ];
    Lino.contacts.AllPartners.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.AllPartners.insert_actionPanel = Ext.extend(Lino.contacts.Partners.FormPanel,{
  empty_title: "New All Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/AllPartners",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.AllPartners.detail_action;
    this.ls_insert_handler = Lino.contacts.AllPartners.insert_action;
    Lino.contacts.AllPartners.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.AllPartners.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.contacts.AllPartners.insert_actionPanel(p);
  return rv;
});

Lino.contacts.AllPartners.detail_actionPanel = Ext.extend(Lino.contacts.Partners.FormPanel,{
  empty_title: "Detail All Partners",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/AllPartners",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.AllPartners.detail_action;
    this.ls_insert_handler = Lino.contacts.AllPartners.insert_action;
    Lino.contacts.AllPartners.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.AllPartners.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.AllPartners.detail_actionPanel(p);
  return rv;
});
Lino.contacts.AllPartners.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.AllPartners.GridPanel(p);
  return rv;
});

Lino.contacts.Persons.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Persons",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Persons",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name_column" }, { "name": "address_column" }, { "name": "email" }, { "name": "phone" }, { "name": "gsm" }, { "type": "int", "name": "id" }, { "name": "language" },'languageHidden', { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "name" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "zip_code" }, { "name": "region" }, { "name": "url" }, { "name": "fax" }, { "name": "remarks" }, { "name": "birth_date" }, { "name": "first_name" }, { "name": "last_name" }, { "name": "title" }, { "name": "gender" },'genderHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 16,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 31,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail_action;
    this.ls_insert_handler = Lino.contacts.Persons.insert_action;
    var ww = this.containing_window;
    var name_column_disp1091 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var address_column_disp1092 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var email1093 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var phone1094 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1095 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1096 = { "selectOnFocus": true, "xtype": "numberfield" };
    var language1097 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var country1098 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1099 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Persons/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a City..." });
    var name1100 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var addr11101 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1102 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1103 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1104 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var street_box1105 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var addr21106 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var zip_code1107 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var region1108 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var url1109 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1110 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1111 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var birth_date1112 = new Lino.IncompleteDateField({ "selectOnFocus": true, "maxLength": 10 });
    var first_name1113 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var last_name1114 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var title1115 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gender1116 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "M", "Male" ], [ "F", "Female" ] ] });
    this.before_row_edit = function(record) {
      city1099.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1098.on('change',Lino.chooser_handler(city1099,'country'));
      Lino.contacts.Persons.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": 180, "colIndex": 0, "sortable": false, "dataIndex": "name_column", "header": "Name", "hidden": false, "editable": false }, { "width": 270, "colIndex": 1, "sortable": false, "dataIndex": "address_column", "header": "Address", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "email", "hidden": false, "editor": email1093 }, { "colIndex": 3, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "phone", "hidden": false, "editor": phone1094 }, { "colIndex": 4, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "gsm", "hidden": false, "editor": gsm1095 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1096, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Language", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": 90, "dataIndex": "language", "hidden": false, "editor": language1097 }, { "colIndex": 7, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country1098, "dataIndex": "country" }, { "colIndex": 8, "sortable": true, "header": "City", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city1099, "dataIndex": "city" }, { "colIndex": 9, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1100 }, { "colIndex": 10, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr1", "hidden": false, "editor": addr11101 }, { "colIndex": 11, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix1102 }, { "colIndex": 12, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street", "hidden": false, "editor": street1103 }, { "colIndex": 13, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_no", "hidden": false, "editor": street_no1104 }, { "colIndex": 14, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_box", "hidden": false, "editor": street_box1105 }, { "colIndex": 15, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr2", "hidden": false, "editor": addr21106 }, { "colIndex": 16, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "zip_code", "hidden": false, "editor": zip_code1107 }, { "colIndex": 17, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "region", "hidden": false, "editor": region1108 }, { "colIndex": 18, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "url", "hidden": false, "editor": url1109 }, { "colIndex": 19, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "fax", "hidden": false, "editor": fax1110 }, { "colIndex": 20, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": remarks1111, "dataIndex": "remarks" }, { "colIndex": 21, "sortable": true, "header": "Birth date", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "birth_date", "hidden": false, "editor": birth_date1112 }, { "colIndex": 22, "sortable": true, "header": "First name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "first_name", "hidden": false, "editor": first_name1113 }, { "colIndex": 23, "sortable": true, "header": "Last name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "last_name", "hidden": false, "editor": last_name1114 }, { "colIndex": 24, "sortable": true, "header": "Title", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "title", "hidden": false, "editor": title1115 }, { "colIndex": 25, "sortable": true, "header": "Gender", "editable": true, "filter": { "type": "string" }, "width": 54, "dataIndex": "gender", "hidden": false, "editor": gender1116 } ];
    Lino.contacts.Persons.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Persons.insert_actionPanel = Ext.extend(Lino.contacts.Persons.FormPanel,{
  empty_title: "New Persons",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/Persons",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail_action;
    this.ls_insert_handler = Lino.contacts.Persons.insert_action;
    Lino.contacts.Persons.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.contacts.Persons.insert_actionPanel(p);
  return rv;
});

Lino.contacts.Persons.detail_actionPanel = Ext.extend(Lino.contacts.Persons.FormPanel,{
  empty_title: "Detail Persons",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/Persons",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Persons.detail_action;
    this.ls_insert_handler = Lino.contacts.Persons.insert_action;
    Lino.contacts.Persons.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Persons.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.Persons.detail_actionPanel(p);
  return rv;
});
Lino.contacts.Persons.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.Persons.GridPanel(p);
  return rv;
});

Lino.contacts.Companies.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Companies",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Companies",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "email" }, { "name": "country" },'countryHidden', { "name": "city" },'cityHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "zip_code" }, { "name": "region" }, { "name": "language" },'languageHidden', { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "prefix" }, { "name": "vat_id" }, { "name": "type" },'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 25,
  ls_grid_configs : [  ],
  content_type : 13,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 27,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail_action;
    this.ls_insert_handler = Lino.contacts.Companies.insert_action;
    var ww = this.containing_window;
    var name1144 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var email1145 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var country1146 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var city1147 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a City..." });
    var addr11148 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1149 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street1150 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1151 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var street_box1152 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var addr21153 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var zip_code1154 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var region1155 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var language1156 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var url1157 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1158 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1159 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1160 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1161 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var prefix1162 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var vat_id1163 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type1164 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Companies/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a company type..." });
    var id1165 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      city1147.setContextValue('country',record ? record.data['countryHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      country1146.on('change',Lino.chooser_handler(city1147,'country'));
      Lino.contacts.Companies.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1144 }, { "colIndex": 1, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "email", "hidden": false, "editor": email1145 }, { "colIndex": 2, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country1146, "dataIndex": "country" }, { "colIndex": 3, "sortable": true, "header": "City", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city1147, "dataIndex": "city" }, { "colIndex": 4, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr1", "hidden": false, "editor": addr11148 }, { "colIndex": 5, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix1149 }, { "colIndex": 6, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street", "hidden": false, "editor": street1150 }, { "colIndex": 7, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_no", "hidden": false, "editor": street_no1151 }, { "colIndex": 8, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_box", "hidden": false, "editor": street_box1152 }, { "colIndex": 9, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr2", "hidden": false, "editor": addr21153 }, { "colIndex": 10, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "zip_code", "hidden": false, "editor": zip_code1154 }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "region", "hidden": false, "editor": region1155 }, { "colIndex": 12, "sortable": true, "header": "Language", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language1156 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "url", "hidden": false, "editor": url1157 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "phone", "hidden": false, "editor": phone1158 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "gsm", "hidden": false, "editor": gsm1159 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "fax", "hidden": false, "editor": fax1160 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": remarks1161, "dataIndex": "remarks" }, { "colIndex": 18, "sortable": true, "header": "prefix", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "prefix", "hidden": false, "editor": prefix1162 }, { "colIndex": 19, "sortable": true, "header": "VAT id", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "vat_id", "hidden": false, "editor": vat_id1163 }, { "colIndex": 20, "sortable": true, "header": "Company type", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "type", "hidden": false, "editor": type1164 }, { "colIndex": 21, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1165, "dataIndex": "id" } ];
    Lino.contacts.Companies.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.Companies.insert_actionPanel = Ext.extend(Lino.contacts.Companies.FormPanel,{
  empty_title: "New Companies",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/Companies",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail_action;
    this.ls_insert_handler = Lino.contacts.Companies.insert_action;
    Lino.contacts.Companies.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.contacts.Companies.insert_actionPanel(p);
  return rv;
});

Lino.contacts.Companies.detail_actionPanel = Ext.extend(Lino.contacts.Companies.FormPanel,{
  empty_title: "Detail Companies",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/Companies",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.Companies.detail_action;
    this.ls_insert_handler = Lino.contacts.Companies.insert_action;
    Lino.contacts.Companies.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Companies.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.Companies.detail_actionPanel(p);
  return rv;
});
Lino.contacts.Companies.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.Companies.GridPanel(p);
  return rv;
});

Lino.contacts.RoleTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RoleTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Role Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 17,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var id1189 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name1190 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1191 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1192 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1189, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1190 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de1191 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1192 } ];
    Lino.contacts.RoleTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RoleTypes.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.RoleTypes.GridPanel(p);
  return rv;
});

Lino.contacts.Roles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/Roles",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Contact Persons",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "type" },'typeHidden', { "name": "person" },'personHidden', { "name": "company" },'companyHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var id1198 = { "selectOnFocus": true, "xtype": "numberfield" };
    var type1199 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Role Type..." });
    var person1200 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Person..." });
    var company1201 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/Roles/company", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Company..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1198, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "type", "hidden": false, "editor": type1199 }, { "colIndex": 2, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail_action'), "hidden": false, "editor": person1200, "dataIndex": "person" }, { "colIndex": 3, "sortable": true, "header": "Company", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail_action'), "hidden": false, "editor": company1201, "dataIndex": "company" } ];
    Lino.contacts.Roles.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.Roles.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.Roles.GridPanel(p);
  return rv;
});

Lino.blogs.EntryTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/blogs/EntryTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Blog Entry Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" },'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "important" }, { "name": "remark" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 20,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntryTypes.detail_action;
    this.ls_insert_handler = Lino.blogs.EntryTypes.insert_action;
    var ww = this.containing_window;
    var name1207 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1208 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1209 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method1210 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1211 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntryTypes/template", "method": "GET" }) }) });
    var id1212 = { "selectOnFocus": true, "xtype": "numberfield" };
    var important1213 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var remark1214 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      template1211.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method1210.on('change',Lino.chooser_handler(template1211,'build_method'));
      Lino.blogs.EntryTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1207 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de1208 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1209 }, { "colIndex": 3, "sortable": true, "header": "Build method", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "build_method", "hidden": false, "editor": build_method1210 }, { "colIndex": 4, "sortable": true, "header": "Template", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "template", "hidden": false, "editor": template1211 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1212, "dataIndex": "id" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "important", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "important", "hidden": false }, { "colIndex": 7, "sortable": false, "header": "Remark", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": remark1214, "dataIndex": "remark" } ];
    Lino.blogs.EntryTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.blogs.EntryTypes.insert_actionPanel = Ext.extend(Lino.blogs.EntryTypes.FormPanel,{
  empty_title: "New Blog Entry Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/blogs/EntryTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntryTypes.detail_action;
    this.ls_insert_handler = Lino.blogs.EntryTypes.insert_action;
    Lino.blogs.EntryTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.EntryTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.blogs.EntryTypes.insert_actionPanel(p);
  return rv;
});

Lino.blogs.EntryTypes.detail_actionPanel = Ext.extend(Lino.blogs.EntryTypes.FormPanel,{
  empty_title: "Detail Blog Entry Types",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/blogs/EntryTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntryTypes.detail_action;
    this.ls_insert_handler = Lino.blogs.EntryTypes.insert_action;
    Lino.blogs.EntryTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.EntryTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.blogs.EntryTypes.detail_actionPanel(p);
  return rv;
});
Lino.blogs.EntryTypes.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.blogs.EntryTypes.GridPanel(p);
  return rv;
});

Lino.blogs.Entries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/blogs/Entries",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Blog Entries",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "user" },'userHidden', { "name": "type" },'typeHidden', { "name": "subject" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "ticket" },'ticketHidden', { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 20,
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.Entries.detail_action;
    this.ls_insert_handler = Lino.blogs.Entries.insert_action;
    var ww = this.containing_window;
    var id1224 = { "selectOnFocus": true, "xtype": "numberfield" };
    var modified1225 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var user1226 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var type1227 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Blog Entry Type..." });
    var subject1228 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_type1229 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1230 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/owner_id", "method": "GET" }) }) });
    var created1231 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time1232 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var language1233 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var ticket1234 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/Entries/ticket", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket..." });
    var owner_disp1235 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    var body1236 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Body", "containing_panel": this });
    this.before_row_edit = function(record) {
      owner_id1230.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body1236.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1229.on('change',Lino.chooser_handler(owner_id1230,'owner_type'));
      Lino.blogs.Entries.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1224, "dataIndex": "id" }, { "width": 144, "colIndex": 1, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1226, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Blog Entry Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.blogs.EntryTypes.detail_action'), "hidden": false, "editor": type1227, "dataIndex": "type" }, { "colIndex": 4, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "subject", "hidden": false, "editor": subject1228 }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type1229, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id1230 }, { "width": 144, "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language1233 }, { "colIndex": 10, "sortable": true, "width": 180, "editable": true, "tooltip": "The Ticket attributed to this Entry.", "filter": { "type": "string" }, "header": "Ticket", "renderer": Lino.fk_renderer('ticketHidden','Lino.tickets.Tickets.detail_action'), "hidden": false, "editor": ticket1234, "dataIndex": "ticket" }, { "width": 270, "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false }, { "colIndex": 12, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": body1236, "dataIndex": "body" } ];
    Lino.blogs.Entries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.Entries.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/blogs/Entries",pk,"clear");
};

Lino.blogs.Entries.insert_actionPanel = Ext.extend(Lino.blogs.Entries.FormPanel,{
  empty_title: "New Blog Entries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/blogs/Entries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.Entries.detail_action;
    this.ls_insert_handler = Lino.blogs.Entries.insert_action;
    Lino.blogs.Entries.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.Entries.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.blogs.Entries.insert_actionPanel(p);
  return rv;
});
Lino.blogs.Entries.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/blogs/Entries",pk,"print");
};

Lino.blogs.Entries.detail_actionPanel = Ext.extend(Lino.blogs.Entries.FormPanel,{
  empty_title: "Detail Blog Entries",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') } ],
  ls_url: "/blogs/Entries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.Entries.detail_action;
    this.ls_insert_handler = Lino.blogs.Entries.insert_action;
    Lino.blogs.Entries.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.Entries.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.blogs.Entries.detail_actionPanel(p);
  return rv;
});
Lino.blogs.Entries.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.blogs.Entries.GridPanel(p);
  return rv;
});

Lino.tickets.ProjectTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/ProjectTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Project Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" },'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 22,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var name1251 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1252 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1253 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method1254 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1255 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/ProjectTypes/template", "method": "GET" }) }) });
    var id1256 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
      template1255.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method1254.on('change',Lino.chooser_handler(template1255,'build_method'));
      Lino.tickets.ProjectTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1251 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de1252 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1253 }, { "colIndex": 3, "sortable": true, "header": "Build method", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "build_method", "hidden": false, "editor": build_method1254 }, { "colIndex": 4, "sortable": true, "header": "Template", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "template", "hidden": false, "editor": template1255 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1256, "dataIndex": "id" } ];
    Lino.tickets.ProjectTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.ProjectTypes.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.ProjectTypes.GridPanel(p);
  return rv;
});

Lino.tickets.SessionTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/SessionTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Session Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 24,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var name1264 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1265 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1266 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1267 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1264 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de1265 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1266 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1267, "dataIndex": "id" } ];
    Lino.tickets.SessionTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.SessionTypes.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.SessionTypes.GridPanel(p);
  return rv;
});

Lino.tickets.Projects.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/Projects",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Projects",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "parent" },'parentHidden', { "name": "type" },'typeHidden', { "name": "partner" },'partnerHidden', { "name": "name" }, { "name": "summary" }, { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Projects.detail_action;
    this.ls_insert_handler = Lino.tickets.Projects.insert_action;
    var ww = this.containing_window;
    var id1273 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user1274 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var parent1275 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var type1276 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project Type..." });
    var partner1277 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Projects/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var name1278 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 20 });
    var summary1279 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description1280 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1273, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1274, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "Parent", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('parentHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": parent1275, "dataIndex": "parent" }, { "colIndex": 3, "sortable": true, "header": "Project Type", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "type", "hidden": false, "editor": type1276 }, { "colIndex": 4, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner1277, "dataIndex": "partner" }, { "colIndex": 5, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1278 }, { "colIndex": 6, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary1279 }, { "colIndex": 7, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1280, "dataIndex": "description" } ];
    Lino.tickets.Projects.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Projects.insert_actionPanel = Ext.extend(Lino.tickets.Projects.FormPanel,{
  empty_title: "New Projects",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/Projects",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Projects.detail_action;
    this.ls_insert_handler = Lino.tickets.Projects.insert_action;
    Lino.tickets.Projects.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Projects.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.Projects.insert_actionPanel(p);
  return rv;
});

Lino.tickets.Projects.detail_actionPanel = Ext.extend(Lino.tickets.Projects.FormPanel,{
  empty_title: "Detail Projects",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/Projects",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Projects.detail_action;
    this.ls_insert_handler = Lino.tickets.Projects.insert_action;
    Lino.tickets.Projects.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Projects.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.Projects.detail_actionPanel(p);
  return rv;
});
Lino.tickets.Projects.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.Projects.GridPanel(p);
  return rv;
});

Lino.tickets.TicketStates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/TicketStates",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Ticket States",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 26,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var name1290 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1291 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1292 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1293 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1290 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de1291 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1292 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1293, "dataIndex": "id" } ];
    Lino.tickets.TicketStates.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.TicketStates.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.TicketStates.GridPanel(p);
  return rv;
});

Lino.tickets.Tickets.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/Tickets",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Tickets",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "summary" }, { "name": "state" },'stateHidden', { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 12,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Tickets.detail_action;
    this.ls_insert_handler = Lino.tickets.Tickets.insert_action;
    var ww = this.containing_window;
    var id1299 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user1300 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created1301 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified1302 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var project1303 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var summary1304 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state1305 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Tickets/state", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket State..." });
    var description1306 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1299, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1300, "dataIndex": "user" }, { "width": 144, "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1303, "dataIndex": "project" }, { "colIndex": 5, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary1304 }, { "colIndex": 6, "sortable": true, "header": "Ticket State", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "state", "hidden": false, "editor": state1305 }, { "colIndex": 7, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1306, "dataIndex": "description" } ];
    Lino.tickets.Tickets.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Tickets.insert_actionPanel = Ext.extend(Lino.tickets.Tickets.FormPanel,{
  empty_title: "New Tickets",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/Tickets",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Tickets.detail_action;
    this.ls_insert_handler = Lino.tickets.Tickets.insert_action;
    Lino.tickets.Tickets.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Tickets.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.Tickets.insert_actionPanel(p);
  return rv;
});

Lino.tickets.Tickets.detail_actionPanel = Ext.extend(Lino.tickets.Tickets.FormPanel,{
  empty_title: "Detail Tickets",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/Tickets",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Tickets.detail_action;
    this.ls_insert_handler = Lino.tickets.Tickets.insert_action;
    Lino.tickets.Tickets.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Tickets.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.Tickets.detail_actionPanel(p);
  return rv;
});
Lino.tickets.Tickets.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.Tickets.GridPanel(p);
  return rv;
});

Lino.tickets.Sessions.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/Sessions",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Sessions",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "end_time" }, { "name": "break_time" }, { "name": "description" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "project" },'projectHidden', { "name": "ticket" },'ticketHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Sessions.detail_action;
    this.ls_insert_handler = Lino.tickets.Sessions.insert_action;
    var ww = this.containing_window;
    var date1316 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var start_time1317 = new Lino.TimeField({ "selectOnFocus": true });
    var end_time1318 = new Lino.TimeField({ "selectOnFocus": true });
    var break_time1319 = new Lino.TimeField({ "selectOnFocus": true });
    var description1320 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var user1321 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id1322 = { "selectOnFocus": true, "xtype": "numberfield" };
    var project1323 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var ticket1324 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/Sessions/ticket", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "hidden": false, "width": 72, "editor": date1316 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time1317 }, { "colIndex": 2, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time1318 }, { "colIndex": 3, "sortable": true, "header": "Break Time", "editable": true, "width": 72, "dataIndex": "break_time", "hidden": false, "editor": break_time1319 }, { "colIndex": 4, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1320, "dataIndex": "description" }, { "colIndex": 5, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1321, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1322, "dataIndex": "id" }, { "colIndex": 7, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1323, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "Ticket", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('ticketHidden','Lino.tickets.Tickets.detail_action'), "hidden": false, "editor": ticket1324, "dataIndex": "ticket" } ];
    Lino.tickets.Sessions.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.Sessions.insert_actionPanel = Ext.extend(Lino.tickets.Sessions.FormPanel,{
  empty_title: "New Sessions",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/Sessions",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Sessions.detail_action;
    this.ls_insert_handler = Lino.tickets.Sessions.insert_action;
    Lino.tickets.Sessions.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Sessions.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.Sessions.insert_actionPanel(p);
  return rv;
});

Lino.tickets.Sessions.detail_actionPanel = Ext.extend(Lino.tickets.Sessions.FormPanel,{
  empty_title: "Detail Sessions",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/Sessions",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.Sessions.detail_action;
    this.ls_insert_handler = Lino.tickets.Sessions.insert_action;
    Lino.tickets.Sessions.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.Sessions.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.Sessions.detail_actionPanel(p);
  return rv;
});
Lino.tickets.Sessions.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.Sessions.GridPanel(p);
  return rv;
});

Lino.outbox.Recipients.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Recipients",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Recipients",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "mail" },'mailHidden', { "name": "partner" },'partnerHidden', { "name": "type" },'typeHidden', { "name": "address" }, { "name": "name" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    var ww = this.containing_window;
    var id1335 = { "selectOnFocus": true, "xtype": "numberfield" };
    var mail1336 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Outgoing Mail..." });
    var partner1337 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Recipients/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var type1338 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ] });
    var address1339 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 75 });
    var name1340 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1335, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Outgoing Mail", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail_action'), "hidden": false, "editor": mail1336, "dataIndex": "mail" }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner1337, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "Recipient Type", "editable": true, "filter": { "type": "string" }, "width": 45, "dataIndex": "type", "hidden": false, "editor": type1338 }, { "colIndex": 4, "sortable": true, "header": "Address", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "address", "hidden": false, "editor": address1339 }, { "colIndex": 5, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1340 } ];
    Lino.outbox.Recipients.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Recipients.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.Recipients.GridPanel(p);
  return rv;
});

Lino.outbox.Mails.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Mails",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  title : "Outgoing Mails",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "user" },'userHidden', { "name": "project" },'projectHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail_action;
    this.ls_insert_handler = Lino.outbox.Mails.insert_action;
    var ww = this.containing_window;
    var sent1348 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var recipients_htmlbox1349 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent(), "title": "Recipients", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "autoScroll": true });
    var subject1350 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1351 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type1352 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1353 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/owner_id", "method": "GET" }) }) });
    var user1354 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var project1355 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Mails/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var date1356 = new Lino.DateField({ "disabled": true, "readOnly": true });
    var owner_disp1357 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    var body1358 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Body", "containing_panel": this });
    this.before_row_edit = function(record) {
      recipients_htmlbox1349.refresh();
      owner_id1353.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body1358.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1352.on('change',Lino.chooser_handler(owner_id1353,'owner_type'));
      Lino.outbox.Mails.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": 144, "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": false, "header": "Recipients", "editable": false, "filter": { "type": "string" }, "width": 270, "dataIndex": "recipients", "hidden": false }, { "colIndex": 2, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "subject", "hidden": false, "editor": subject1350 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1351, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type1352, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id1353 }, { "colIndex": 6, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1354, "dataIndex": "user" }, { "colIndex": 7, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1355, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "\n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "hidden": false, "width": 72 }, { "width": 270, "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false }, { "colIndex": 10, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": body1358, "dataIndex": "body" } ];
    Lino.outbox.Mails.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.Mails.insert_actionPanel = Ext.extend(Lino.outbox.Mails.FormPanel,{
  empty_title: "New Outgoing Mails",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  ls_url: "/outbox/Mails",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail_action;
    this.ls_insert_handler = Lino.outbox.Mails.insert_action;
    Lino.outbox.Mails.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.outbox.Mails.insert_actionPanel(p);
  return rv;
});

Lino.outbox.Mails.detail_actionPanel = Ext.extend(Lino.outbox.Mails.FormPanel,{
  empty_title: "Detail Outgoing Mails",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  ls_url: "/outbox/Mails",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.Mails.detail_action;
    this.ls_insert_handler = Lino.outbox.Mails.insert_action;
    Lino.outbox.Mails.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Mails.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.Mails.detail_actionPanel(p);
  return rv;
});
Lino.outbox.Mails.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.Mails.GridPanel(p);
  return rv;
});
Lino.outbox.Mails.send_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/outbox/Mails",pk,"send");
};

Lino.outbox.Attachments.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/Attachments",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Attachments",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "mail" },'mailHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 9,
  initComponent : function() {
    var ww = this.containing_window;
    var id1371 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type1372 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1373 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/owner_id", "method": "GET" }) }) });
    var mail1374 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/Attachments/mail", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Outgoing Mail..." });
    var owner_disp1375 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id1373.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1372.on('change',Lino.chooser_handler(owner_id1373,'owner_type'));
      Lino.outbox.Attachments.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1371, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type1372, "dataIndex": "owner_type" }, { "colIndex": 2, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id1373 }, { "colIndex": 3, "sortable": true, "header": "Outgoing Mail", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('mailHidden','Lino.outbox.Mails.detail_action'), "hidden": false, "editor": mail1374, "dataIndex": "mail" }, { "width": 270, "colIndex": 4, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.outbox.Attachments.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.Attachments.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.Attachments.GridPanel(p);
  return rv;
});

Lino.postings.Postings.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/Postings",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "print_action", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print_action') } ],
  title : "Postings",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "user" },'userHidden', { "name": "owner" }, { "name": "partner" },'partnerHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "project" },'projectHidden', { "name": "state" },'stateHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    var ww = this.containing_window;
    var date1382 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var user1383 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/Postings/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp1384 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    var partner1385 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/Postings/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var id1386 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type1387 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/Postings/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1388 = { "selectOnFocus": true, "xtype": "numberfield" };
    var project1389 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/Postings/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var state1390 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Open" ], [ "20", "Ready to print" ], [ "30", "Printed" ], [ "40", "Sent" ], [ "50", "Returned" ] ] });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "dataIndex": "date", "hidden": false, "width": 72, "editor": date1382 }, { "colIndex": 1, "sortable": true, "header": "user", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1383, "dataIndex": "user" }, { "width": 270, "colIndex": 2, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false }, { "colIndex": 3, "sortable": true, "header": "Recipient", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner1385, "dataIndex": "partner" }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1386, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type1387, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "owner_id", "hidden": false, "editor": owner_id1388 }, { "colIndex": 7, "sortable": true, "header": "project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1389, "dataIndex": "project" }, { "colIndex": 8, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 126, "dataIndex": "state", "hidden": false, "editor": state1390 } ];
    Lino.postings.Postings.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.Postings.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.postings.Postings.GridPanel(p);
  return rv;
});
Lino.postings.Postings.print_action = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/postings/Postings",pk,"print_action");
};

Lino.cal.Calendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Calendars",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Calendars",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "user" },'userHidden', { "name": "type" },'typeHidden', { "name": "name" }, { "type": "int", "name": "color" }, { "type": "boolean", "name": "readonly" }, { "type": "boolean", "name": "is_hidden" }, { "type": "boolean", "name": "is_default" }, { "type": "int", "name": "id" }, { "name": "description" }, { "name": "url_template" }, { "name": "username" }, { "name": "password" }, { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 16,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail_action;
    this.ls_insert_handler = Lino.cal.Calendars.insert_action;
    var ww = this.containing_window;
    var user1401 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Calendars/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var type1402 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "local", "Local Calendar" ], [ "google", "Google Calendar" ] ], "allowBlank": false, "value": "local" });
    var name1403 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var color1404 = { "selectOnFocus": true, "xtype": "numberfield", "value": 1, "allowBlank": false };
    var readonly1405 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_hidden1406 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var is_default1407 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var id1408 = { "selectOnFocus": true, "xtype": "numberfield" };
    var description1409 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var url_template1410 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var username1411 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var password1412 = new Ext.form.TextField({ "selectOnFocus": true, "inputType": "password", "maxLength": 200 });
    var start_date1413 = new Lino.DateField({ "selectOnFocus": true });
    this.before_row_edit = function(record) {
      description1409.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1401, "dataIndex": "user" }, { "colIndex": 1, "sortable": true, "header": "Type", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "type", "hidden": false, "editor": type1402 }, { "colIndex": 2, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1403 }, { "colIndex": 3, "sortable": true, "header": "color", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "color", "hidden": false, "editor": color1404 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "read-only", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "readonly", "hidden": false }, { "colIndex": 5, "sortable": false, "xtype": "checkcolumn", "header": "is hidden", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "is_hidden", "hidden": false }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "is default", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "is_default", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1408, "dataIndex": "id" }, { "colIndex": 8, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1409, "dataIndex": "description" }, { "colIndex": 9, "sortable": true, "header": "URL template", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "url_template", "hidden": false, "editor": url_template1410 }, { "colIndex": 10, "sortable": true, "header": "Username", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "username", "hidden": false, "editor": username1411 }, { "colIndex": 11, "sortable": true, "header": "Password", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "password", "hidden": false, "editor": password1412 }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date1413 } ];
    Lino.cal.Calendars.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Calendars.insert_actionPanel = Ext.extend(Lino.cal.Calendars.FormPanel,{
  empty_title: "New Calendars",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/Calendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail_action;
    this.ls_insert_handler = Lino.cal.Calendars.insert_action;
    Lino.cal.Calendars.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.Calendars.insert_actionPanel(p);
  return rv;
});

Lino.cal.Calendars.detail_actionPanel = Ext.extend(Lino.cal.Calendars.FormPanel,{
  empty_title: "Detail Calendars",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/Calendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Calendars.detail_action;
    this.ls_insert_handler = Lino.cal.Calendars.insert_action;
    Lino.cal.Calendars.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Calendars.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.Calendars.detail_actionPanel(p);
  return rv;
});
Lino.cal.Calendars.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.Calendars.GridPanel(p);
  return rv;
});

Lino.cal.Places.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Places",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Places",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 35,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    var ww = this.containing_window;
    var id1428 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name1429 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1430 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1431 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1428, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1429 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de1430 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1431 } ];
    Lino.cal.Places.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Places.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.Places.GridPanel(p);
  return rv;
});

Lino.cal.Priorities.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Priorities",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Priorities",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "ref" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 36,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name1437 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1438 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1439 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1440 = { "selectOnFocus": true, "xtype": "numberfield" };
    var ref1441 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": "1" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1437 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de1438 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1439 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1440, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "ref", "hidden": false, "editor": ref1441 } ];
    Lino.cal.Priorities.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Priorities.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.Priorities.GridPanel(p);
  return rv;
});

Lino.cal.AccessClasses.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/AccessClasses",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Access Classes",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "type": "int", "name": "id" }, { "name": "ref" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 29,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var name1448 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1449 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1450 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id1451 = { "selectOnFocus": true, "xtype": "numberfield" };
    var ref1452 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": "1" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1448 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de1449 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1450 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1451, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "ref", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "ref", "hidden": false, "editor": ref1452 } ];
    Lino.cal.AccessClasses.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.AccessClasses.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.AccessClasses.GridPanel(p);
  return rv;
});

Lino.cal.EventTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Event Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" },'build_methodHidden', { "name": "template" }, { "type": "int", "name": "id" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 32,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventTypes.detail_action;
    this.ls_insert_handler = Lino.cal.EventTypes.insert_action;
    var ww = this.containing_window;
    var name1459 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1460 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1461 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method1462 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1463 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventTypes/template", "method": "GET" }) }) });
    var id1464 = { "selectOnFocus": true, "xtype": "numberfield" };
    var attach_to_email1465 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template1466 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventTypes/email_template", "method": "GET" }) }) });
    this.before_row_edit = function(record) {
      template1463.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method1462.on('change',Lino.chooser_handler(template1463,'build_method'));
      Lino.cal.EventTypes.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1459 }, { "colIndex": 1, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de1460 }, { "colIndex": 2, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1461 }, { "colIndex": 3, "sortable": true, "header": "Build method", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "build_method", "hidden": false, "editor": build_method1462 }, { "colIndex": 4, "sortable": true, "header": "Template", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "template", "hidden": false, "editor": template1463 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1464, "dataIndex": "id" }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Attach to email", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": 90, "dataIndex": "attach_to_email", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "Email template", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": 90, "dataIndex": "email_template", "hidden": false, "editor": email_template1466 } ];
    Lino.cal.EventTypes.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.EventTypes.insert_actionPanel = Ext.extend(Lino.cal.EventTypes.FormPanel,{
  empty_title: "New Event Types",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/EventTypes",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventTypes.detail_action;
    this.ls_insert_handler = Lino.cal.EventTypes.insert_action;
    Lino.cal.EventTypes.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventTypes.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.EventTypes.insert_actionPanel(p);
  return rv;
});

Lino.cal.EventTypes.detail_actionPanel = Ext.extend(Lino.cal.EventTypes.FormPanel,{
  empty_title: "Detail Event Types",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/EventTypes",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventTypes.detail_action;
    this.ls_insert_handler = Lino.cal.EventTypes.insert_action;
    Lino.cal.EventTypes.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventTypes.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventTypes.detail_actionPanel(p);
  return rv;
});
Lino.cal.EventTypes.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventTypes.GridPanel(p);
  return rv;
});

Lino.cal.Events.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Events",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "user" },'userHidden', { "name": "summary" }, { "name": "state" },'stateHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 36,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail_action;
    this.ls_insert_handler = Lino.cal.Events.insert_action;
    var ww = this.containing_window;
    var start_date1476 = new Lino.DateField({ "selectOnFocus": true });
    var start_time1477 = new Lino.TimeField({ "selectOnFocus": true });
    var user1478 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var summary1479 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state1480 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var id1481 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type1482 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1483 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/owner_id", "method": "GET" }) }) });
    var created1484 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified1485 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var project1486 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var build_time1487 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar1488 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date1489 = new Lino.DateField({ "selectOnFocus": true });
    var end_time1490 = new Lino.TimeField({ "selectOnFocus": true });
    var uid1491 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description1492 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class1493 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence1494 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type1495 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent1496 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type1497 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place1498 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority1499 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Events/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var owner_disp1500 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id1483.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description1492.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1482.on('change',Lino.chooser_handler(owner_id1483,'owner_type'));
      Lino.cal.Events.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date1476 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time1477 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1478, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary1479 }, { "colIndex": 4, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state1480 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1481, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type1482, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id1483 }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 10, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1486, "dataIndex": "project" }, { "width": 144, "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 12, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar1488, "dataIndex": "calendar" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date1489 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time1490 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid1491 }, { "colIndex": 16, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1492, "dataIndex": "description" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class1493 }, { "colIndex": 18, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence1494 }, { "colIndex": 19, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type1497, "dataIndex": "type" }, { "colIndex": 22, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place1498 }, { "colIndex": 23, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority1499 }, { "width": 270, "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.Events.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Events",pk,"mark_scheduled");
};
Lino.cal.Events.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Events",pk,"mark_notified");
};
Lino.cal.Events.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Events",pk,"clear");
};
Lino.cal.Events.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Events",pk,"mark_confirmed");
};
Lino.cal.Events.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Events",pk,"mark_took_place");
};
Lino.cal.Events.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Events",pk,"mark_present");
};
Lino.cal.Events.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Events",pk,"mark_cancelled");
};

Lino.cal.Events.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/Events",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail_action;
    this.ls_insert_handler = Lino.cal.Events.insert_action;
    Lino.cal.Events.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.Events.insert_actionPanel(p);
  return rv;
});
Lino.cal.Events.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Events",pk,"print");
};

Lino.cal.Events.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail Events",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/Events",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Events.detail_action;
    this.ls_insert_handler = Lino.cal.Events.insert_action;
    Lino.cal.Events.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Events.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.Events.detail_actionPanel(p);
  return rv;
});
Lino.cal.Events.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Events",pk,"post");
};
Lino.cal.Events.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.Events.GridPanel(p);
  return rv;
});
Lino.cal.Events.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Events",pk,"mail");
};

Lino.cal.EventsToSchedule.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventsToSchedule",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events to schedule",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "user" },'userHidden', { "name": "project" },'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "state" },'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsToSchedule.detail_action;
    this.ls_insert_handler = Lino.cal.EventsToSchedule.insert_action;
    var ww = this.containing_window;
    var start_date1527 = new Lino.DateField({ "selectOnFocus": true });
    var start_time1528 = new Lino.TimeField({ "selectOnFocus": true });
    var user1529 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToSchedule/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var project1530 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToSchedule/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var summary1531 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp1532 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id1533 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type1534 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToSchedule/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1535 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToSchedule/owner_id", "method": "GET" }) }) });
    var created1536 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified1537 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time1538 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar1539 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToSchedule/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date1540 = new Lino.DateField({ "selectOnFocus": true });
    var end_time1541 = new Lino.TimeField({ "selectOnFocus": true });
    var uid1542 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description1543 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class1544 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToSchedule/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence1545 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type1546 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent1547 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type1548 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToSchedule/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place1549 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToSchedule/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority1550 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToSchedule/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state1551 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var owner_disp1552 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id1535.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description1543.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1534.on('change',Lino.chooser_handler(owner_id1535,'owner_type'));
      Lino.cal.EventsToSchedule.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date1527 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time1528 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1529, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1530, "dataIndex": "project" }, { "colIndex": 4, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary1531 }, { "width": 270, "colIndex": 5, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1533, "dataIndex": "id" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type1534, "dataIndex": "owner_type" }, { "colIndex": 8, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id1535 }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "width": 144, "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 12, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar1539, "dataIndex": "calendar" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date1540 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time1541 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid1542 }, { "colIndex": 16, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1543, "dataIndex": "description" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class1544 }, { "colIndex": 18, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence1545 }, { "colIndex": 19, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type1548, "dataIndex": "type" }, { "colIndex": 22, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place1549 }, { "colIndex": 23, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority1550 }, { "colIndex": 24, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state1551 }, { "width": 270, "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.EventsToSchedule.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsToSchedule.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToSchedule",pk,"mark_scheduled");
};
Lino.cal.EventsToSchedule.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToSchedule",pk,"mark_notified");
};
Lino.cal.EventsToSchedule.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToSchedule",pk,"clear");
};
Lino.cal.EventsToSchedule.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToSchedule",pk,"mark_confirmed");
};
Lino.cal.EventsToSchedule.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToSchedule",pk,"mark_present");
};
Lino.cal.EventsToSchedule.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToSchedule",pk,"mark_took_place");
};
Lino.cal.EventsToSchedule.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToSchedule",pk,"mark_cancelled");
};

Lino.cal.EventsToSchedule.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New Events to schedule",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsToSchedule",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsToSchedule.detail_action;
    this.ls_insert_handler = Lino.cal.EventsToSchedule.insert_action;
    Lino.cal.EventsToSchedule.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsToSchedule.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.EventsToSchedule.insert_actionPanel(p);
  return rv;
});
Lino.cal.EventsToSchedule.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToSchedule",pk,"print");
};

Lino.cal.EventsToSchedule.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail Events to schedule",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsToSchedule",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsToSchedule.detail_action;
    this.ls_insert_handler = Lino.cal.EventsToSchedule.insert_action;
    Lino.cal.EventsToSchedule.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsToSchedule.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsToSchedule.detail_actionPanel(p);
  return rv;
});
Lino.cal.EventsToSchedule.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToSchedule",pk,"post");
};
Lino.cal.EventsToSchedule.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToSchedule",pk,"mail");
};
Lino.cal.EventsToSchedule.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsToSchedule.GridPanel(p);
  return rv;
});

Lino.cal.EventsToNotify.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventsToNotify",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events to notify",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "user" },'userHidden', { "name": "project" },'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "state" },'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsToNotify.detail_action;
    this.ls_insert_handler = Lino.cal.EventsToNotify.insert_action;
    var ww = this.containing_window;
    var start_date1580 = new Lino.DateField({ "selectOnFocus": true });
    var start_time1581 = new Lino.TimeField({ "selectOnFocus": true });
    var user1582 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToNotify/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var project1583 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToNotify/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var summary1584 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp1585 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id1586 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type1587 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToNotify/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1588 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToNotify/owner_id", "method": "GET" }) }) });
    var created1589 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified1590 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time1591 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar1592 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToNotify/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date1593 = new Lino.DateField({ "selectOnFocus": true });
    var end_time1594 = new Lino.TimeField({ "selectOnFocus": true });
    var uid1595 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description1596 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class1597 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToNotify/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence1598 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type1599 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent1600 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type1601 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToNotify/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place1602 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToNotify/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority1603 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToNotify/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state1604 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var owner_disp1605 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id1588.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description1596.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1587.on('change',Lino.chooser_handler(owner_id1588,'owner_type'));
      Lino.cal.EventsToNotify.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date1580 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time1581 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1582, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1583, "dataIndex": "project" }, { "colIndex": 4, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary1584 }, { "width": 270, "colIndex": 5, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1586, "dataIndex": "id" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type1587, "dataIndex": "owner_type" }, { "colIndex": 8, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id1588 }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "width": 144, "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 12, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar1592, "dataIndex": "calendar" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date1593 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time1594 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid1595 }, { "colIndex": 16, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1596, "dataIndex": "description" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class1597 }, { "colIndex": 18, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence1598 }, { "colIndex": 19, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type1601, "dataIndex": "type" }, { "colIndex": 22, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place1602 }, { "colIndex": 23, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority1603 }, { "colIndex": 24, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state1604 }, { "width": 270, "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.EventsToNotify.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsToNotify.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToNotify",pk,"mark_scheduled");
};
Lino.cal.EventsToNotify.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToNotify",pk,"clear");
};
Lino.cal.EventsToNotify.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToNotify",pk,"mark_notified");
};
Lino.cal.EventsToNotify.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToNotify",pk,"mark_confirmed");
};
Lino.cal.EventsToNotify.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToNotify",pk,"mark_present");
};
Lino.cal.EventsToNotify.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToNotify",pk,"mark_took_place");
};
Lino.cal.EventsToNotify.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToNotify",pk,"mark_cancelled");
};

Lino.cal.EventsToNotify.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New Events to notify",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsToNotify",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsToNotify.detail_action;
    this.ls_insert_handler = Lino.cal.EventsToNotify.insert_action;
    Lino.cal.EventsToNotify.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsToNotify.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.EventsToNotify.insert_actionPanel(p);
  return rv;
});
Lino.cal.EventsToNotify.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToNotify",pk,"print");
};

Lino.cal.EventsToNotify.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail Events to notify",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsToNotify",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsToNotify.detail_action;
    this.ls_insert_handler = Lino.cal.EventsToNotify.insert_action;
    Lino.cal.EventsToNotify.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsToNotify.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsToNotify.detail_actionPanel(p);
  return rv;
});
Lino.cal.EventsToNotify.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToNotify",pk,"post");
};
Lino.cal.EventsToNotify.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsToNotify.GridPanel(p);
  return rv;
});
Lino.cal.EventsToNotify.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToNotify",pk,"mail");
};

Lino.cal.Tasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Tasks",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "mark_done", "text": "Done", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_done') } ],
  title : "Tasks",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "state" },'stateHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "user" },'userHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "calendar" },'calendarHidden', { "name": "start_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 29,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail_action;
    this.ls_insert_handler = Lino.cal.Tasks.insert_action;
    var ww = this.containing_window;
    var start_date1633 = new Lino.DateField({ "selectOnFocus": true });
    var summary1634 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state1635 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "40", "Cancelled" ] ] });
    var id1636 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type1637 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1638 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/owner_id", "method": "GET" }) }) });
    var user1639 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created1640 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified1641 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var project1642 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var calendar1643 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var start_time1644 = new Lino.TimeField({ "selectOnFocus": true });
    var uid1645 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description1646 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class1647 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Tasks/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence1648 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type1649 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var due_date1650 = new Lino.DateField({ "selectOnFocus": true });
    var due_time1651 = new Lino.TimeField({ "selectOnFocus": true });
    var percent1652 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_disp1653 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id1638.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description1646.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type1637.on('change',Lino.chooser_handler(owner_id1638,'owner_type'));
      Lino.cal.Tasks.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date1633 }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary1634 }, { "colIndex": 2, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 81, "dataIndex": "state", "hidden": false, "editor": state1635 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1636, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type1637, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id1638 }, { "colIndex": 6, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1639, "dataIndex": "user" }, { "width": 144, "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1642, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar1643, "dataIndex": "calendar" }, { "colIndex": 11, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time1644 }, { "colIndex": 12, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid1645 }, { "colIndex": 13, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1646, "dataIndex": "description" }, { "colIndex": 14, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class1647 }, { "colIndex": 15, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence1648 }, { "colIndex": 16, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 17, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "dataIndex": "due_date", "hidden": false, "width": 72, "editor": due_date1650 }, { "colIndex": 18, "sortable": true, "header": "Due time", "editable": true, "width": 72, "dataIndex": "due_time", "hidden": false, "editor": due_time1651 }, { "colIndex": 19, "sortable": true, "header": "Duration value", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "percent", "hidden": false, "editor": percent1652 }, { "width": 270, "colIndex": 20, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.Tasks.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.Tasks.insert_actionPanel = Ext.extend(Lino.cal.Tasks.FormPanel,{
  empty_title: "New Tasks",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/Tasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail_action;
    this.ls_insert_handler = Lino.cal.Tasks.insert_action;
    Lino.cal.Tasks.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.Tasks.insert_actionPanel(p);
  return rv;
});

Lino.cal.Tasks.detail_actionPanel = Ext.extend(Lino.cal.Tasks.FormPanel,{
  empty_title: "Detail Tasks",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "mark_done", "text": "Done", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_done') } ],
  ls_url: "/cal/Tasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.Tasks.detail_action;
    this.ls_insert_handler = Lino.cal.Tasks.insert_action;
    Lino.cal.Tasks.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Tasks.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.Tasks.detail_actionPanel(p);
  return rv;
});
Lino.cal.Tasks.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.Tasks.GridPanel(p);
  return rv;
});
Lino.cal.Tasks.mark_done = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Tasks",pk,"mark_done");
};

Lino.cal.GuestRoles.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/GuestRoles",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Guest Roles",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "build_method" },'build_methodHidden', { "name": "template" }, { "type": "boolean", "name": "attach_to_email" }, { "name": "email_template" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 34,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail_action;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert_action;
    var ww = this.containing_window;
    var id1676 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name1677 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de1678 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr1679 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var build_method1680 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "appyodt", "AppyOdtBuildMethod" ], [ "appypdf", "AppyPdfBuildMethod" ], [ "appyrtf", "AppyRtfBuildMethod" ], [ "latex", "LatexBuildMethod" ], [ "pisa", "PisaBuildMethod" ], [ "rtf", "RtfBuildMethod" ] ] });
    var template1681 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/template", "method": "GET" }) }) });
    var attach_to_email1682 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var email_template1683 = new Lino.SimpleRemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/GuestRoles/email_template", "method": "GET" }) }) });
    this.before_row_edit = function(record) {
      template1681.setContextValue('build_method',record ? record.data['build_methodHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      build_method1680.on('change',Lino.chooser_handler(template1681,'build_method'));
      Lino.cal.GuestRoles.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1676, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1677 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de1678 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr1679 }, { "colIndex": 4, "sortable": true, "header": "Build method", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "build_method", "hidden": false, "editor": build_method1680 }, { "colIndex": 5, "sortable": true, "header": "Template", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "template", "hidden": false, "editor": template1681 }, { "colIndex": 6, "sortable": false, "xtype": "checkcolumn", "header": "Attach to email", "editable": true, "tooltip": "Whether the printable file should be attached to the email\nwhen creating an email from a mailable of this type.\n", "filter": { "type": "boolean" }, "width": 90, "dataIndex": "attach_to_email", "hidden": false }, { "colIndex": 7, "sortable": true, "header": "Email template", "editable": true, "tooltip": "The name of the file to be used as template \nwhen creating an email from a mailable of this type.\n", "filter": { "type": "string" }, "width": 90, "dataIndex": "email_template", "hidden": false, "editor": email_template1683 } ];
    Lino.cal.GuestRoles.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.GuestRoles.insert_actionPanel = Ext.extend(Lino.cal.GuestRoles.FormPanel,{
  empty_title: "New Guest Roles",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/GuestRoles",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail_action;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert_action;
    Lino.cal.GuestRoles.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.GuestRoles.insert_actionPanel(p);
  return rv;
});

Lino.cal.GuestRoles.detail_actionPanel = Ext.extend(Lino.cal.GuestRoles.FormPanel,{
  empty_title: "Detail Guest Roles",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/GuestRoles",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.GuestRoles.detail_action;
    this.ls_insert_handler = Lino.cal.GuestRoles.insert_action;
    Lino.cal.GuestRoles.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.GuestRoles.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.GuestRoles.detail_actionPanel(p);
  return rv;
});
Lino.cal.GuestRoles.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.GuestRoles.GridPanel(p);
  return rv;
});

Lino.cal.Guests.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/Guests",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "confirm", "text": "Confirm", "must_save": true, "panel_btn_handler": Lino.row_action_handler('confirm') }, { "itemId": "invite", "text": "Invite", "must_save": true, "panel_btn_handler": Lino.row_action_handler('invite') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Guests",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "partner" },'partnerHidden', { "name": "role" },'roleHidden', { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "name": "remark" }, { "name": "event" },'eventHidden', { "type": "int", "name": "id" }, { "name": "build_time" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 10,
  ls_grid_configs : [  ],
  content_type : 33,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 13,
  initComponent : function() {
    var ww = this.containing_window;
    var partner1693 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/partner", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Partner..." });
    var role1694 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/role", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Guest Role..." });
    var state1695 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Invited" ], [ "20", "Confirmed" ], [ "30", "Present" ], [ "40", "Absent" ] ] });
    var workflow_buttons_disp1696 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var remark1697 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var event1698 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/Guests/event", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Event..." });
    var id1699 = { "selectOnFocus": true, "xtype": "numberfield" };
    var build_time1700 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner1693, "dataIndex": "partner" }, { "colIndex": 1, "sortable": true, "header": "Role", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('roleHidden','Lino.cal.GuestRoles.detail_action'), "hidden": false, "editor": role1694, "dataIndex": "role" }, { "colIndex": 2, "sortable": true, "header": "Guest State", "editable": true, "filter": { "type": "string" }, "width": 81, "dataIndex": "state", "hidden": false, "editor": state1695 }, { "width": 270, "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "Remark", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "remark", "hidden": false, "editor": remark1697 }, { "colIndex": 5, "sortable": true, "header": "Event", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('eventHidden','Lino.cal.Events.detail_action'), "hidden": false, "editor": event1698, "dataIndex": "event" }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1699, "dataIndex": "id" }, { "width": 144, "colIndex": 7, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false } ];
    Lino.cal.Guests.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.Guests.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Guests",pk,"clear");
};
Lino.cal.Guests.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Guests",pk,"print");
};
Lino.cal.Guests.confirm = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Guests",pk,"confirm");
};
Lino.cal.Guests.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.Guests.GridPanel(p);
  return rv;
});
Lino.cal.Guests.invite = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Guests",pk,"invite");
};
Lino.cal.Guests.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/Guests",pk,"mail");
};

Lino.cal.PanelCalendars.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/PanelCalendars",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Calendars",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "description" }, { "type": "int", "name": "color" }, { "type": "boolean", "name": "is_hidden" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 30,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail_action;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert_action;
    var ww = this.containing_window;
    var id1 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name2 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description3 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var color4 = { "selectOnFocus": true, "xtype": "numberfield", "value": 1, "allowBlank": false };
    var is_hidden5 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    this.before_row_edit = function(record) {
      description3.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name2 }, { "colIndex": 2, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description3, "dataIndex": "description" }, { "colIndex": 3, "sortable": true, "header": "color", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "color", "hidden": false, "editor": color4 }, { "colIndex": 4, "sortable": false, "xtype": "checkcolumn", "header": "is hidden", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "is_hidden", "hidden": false } ];
    Lino.cal.PanelCalendars.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.PanelCalendars.insert_actionPanel = Ext.extend(Lino.cal.Calendars.FormPanel,{
  empty_title: "New Calendars",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail_action;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert_action;
    Lino.cal.PanelCalendars.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.PanelCalendars.insert_actionPanel(p);
  return rv;
});

Lino.cal.PanelCalendars.detail_actionPanel = Ext.extend(Lino.cal.Calendars.FormPanel,{
  empty_title: "Detail Calendars",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/cal/PanelCalendars",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelCalendars.detail_action;
    this.ls_insert_handler = Lino.cal.PanelCalendars.insert_action;
    Lino.cal.PanelCalendars.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelCalendars.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.PanelCalendars.detail_actionPanel(p);
  return rv;
});
Lino.cal.PanelCalendars.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.PanelCalendars.GridPanel(p);
  return rv;
});

Lino.cal.PanelEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/PanelEvents",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "start_dt" }, { "name": "end_dt" }, { "name": "summary" }, { "name": "description" }, { "name": "user" },'userHidden', { "name": "place" },'placeHidden', { "name": "calendar" },'calendarHidden', { "name": "url" }, { "type": "boolean", "name": "all_day" }, { "name": "reminder" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail_action;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert_action;
    var ww = this.containing_window;
    var id153 = { "selectOnFocus": true, "xtype": "numberfield" };
    var start_dt154 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var end_dt155 = new Ext.form.DisplayField({ "selectOnFocus": true, "allowBlank": false, "value": "<br>" });
    var summary156 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": null });
    var description157 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var user158 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var place159 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var calendar160 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/PanelEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var url_disp161 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var all_day162 = new Ext.form.Checkbox({ "selectOnFocus": true });
    var reminder_disp163 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    this.before_row_edit = function(record) {
      description157.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id153, "dataIndex": "id" }, { "colIndex": 1, "sortable": false, "header": "Start", "editable": true, "width": 144, "dataIndex": "start_dt", "hidden": false, "editor": start_dt154 }, { "colIndex": 2, "sortable": false, "header": "End", "editable": true, "width": 144, "dataIndex": "end_dt", "hidden": false, "editor": end_dt155 }, { "colIndex": 3, "sortable": false, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 27, "dataIndex": "summary", "hidden": false, "editor": summary156 }, { "colIndex": 4, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description157, "dataIndex": "description" }, { "colIndex": 5, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user158, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place159 }, { "colIndex": 7, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar160, "dataIndex": "calendar" }, { "width": 270, "colIndex": 8, "sortable": false, "dataIndex": "url", "header": "Link URL", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": false, "xtype": "checkcolumn", "header": "all day", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "all_day", "hidden": false }, { "width": 270, "colIndex": 10, "sortable": false, "dataIndex": "reminder", "header": "Reminder", "hidden": false, "editable": false } ];
    Lino.cal.PanelEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/PanelEvents",pk,"mark_scheduled");
};
Lino.cal.PanelEvents.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/PanelEvents",pk,"clear");
};
Lino.cal.PanelEvents.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/PanelEvents",pk,"mark_notified");
};
Lino.cal.PanelEvents.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/PanelEvents",pk,"mark_confirmed");
};
Lino.cal.PanelEvents.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/PanelEvents",pk,"mark_present");
};
Lino.cal.PanelEvents.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/PanelEvents",pk,"mark_took_place");
};
Lino.cal.PanelEvents.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/PanelEvents",pk,"mark_cancelled");
};

Lino.cal.PanelEvents.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/PanelEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail_action;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert_action;
    Lino.cal.PanelEvents.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.PanelEvents.insert_actionPanel(p);
  return rv;
});
Lino.cal.PanelEvents.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/PanelEvents",pk,"print");
};

Lino.cal.PanelEvents.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail Events",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/PanelEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.PanelEvents.detail_action;
    this.ls_insert_handler = Lino.cal.PanelEvents.insert_action;
    Lino.cal.PanelEvents.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.PanelEvents.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.PanelEvents.detail_actionPanel(p);
  return rv;
});
Lino.cal.PanelEvents.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/PanelEvents",pk,"post");
};
Lino.cal.PanelEvents.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.PanelEvents.GridPanel(p);
  return rv;
});
Lino.cal.PanelEvents.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/PanelEvents",pk,"mail");
};

Lino.uploads.UploadTypes.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/UploadTypes",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Upload Types",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 28,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 3,
  initComponent : function() {
    var ww = this.containing_window;
    var name1726 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var id1727 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1726 }, { "colIndex": 1, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1727, "dataIndex": "id" } ];
    Lino.uploads.UploadTypes.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.UploadTypes.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.uploads.UploadTypes.GridPanel(p);
  return rv;
});

Lino.uploads.Uploads.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/uploads/Uploads",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Uploads",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "file" }, { "name": "user" },'userHidden', { "name": "created" }, { "name": "modified" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "mimetype" }, { "name": "type" },'typeHidden', { "type": "date", "name": "valid_until", "dateFormat": "d.m.Y" }, { "name": "description" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 27,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 17,
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail_action;
    this.ls_insert_handler = Lino.uploads.Uploads.insert_action;
    var ww = this.containing_window;
    var file1731 = Lino.file_field_handler(this,{ "selectOnFocus": true, "allowBlank": false, "maxLength": 100 });
    var user1732 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var created1733 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified1734 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var id1735 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type1736 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1737 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/owner_id", "method": "GET" }) }) });
    var mimetype1738 = new Ext.form.TextField({ "disabled": true, "readOnly": true, "maxLength": 64 });
    var type1739 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/uploads/Uploads/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Upload Type..." });
    var valid_until1740 = new Lino.DateField({ "selectOnFocus": true });
    var description1741 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_disp1742 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id1737.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1736.on('change',Lino.chooser_handler(owner_id1737,'owner_type'));
      Lino.uploads.Uploads.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "File", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "file", "hidden": false, "editor": file1731 }, { "colIndex": 1, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user1732, "dataIndex": "user" }, { "width": 144, "colIndex": 2, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 3, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1735, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type1736, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id1737 }, { "colIndex": 7, "sortable": true, "header": "MIME type", "editable": false, "filter": { "type": "string" }, "width": 180, "dataIndex": "mimetype", "hidden": false }, { "colIndex": 8, "sortable": true, "header": "Upload Type", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "type", "hidden": false, "editor": type1739 }, { "colIndex": 9, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "valid until", "dataIndex": "valid_until", "hidden": false, "width": 72, "editor": valid_until1740 }, { "colIndex": 10, "sortable": true, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "description", "hidden": false, "editor": description1741 }, { "width": 270, "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.uploads.Uploads.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.uploads.Uploads.insert_actionPanel = Ext.extend(Lino.uploads.Uploads.FormPanel,{
  empty_title: "New Uploads",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/uploads/Uploads",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail_action;
    this.ls_insert_handler = Lino.uploads.Uploads.insert_action;
    Lino.uploads.Uploads.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.uploads.Uploads.insert_actionPanel(p);
  return rv;
});

Lino.uploads.Uploads.detail_actionPanel = Ext.extend(Lino.uploads.Uploads.FormPanel,{
  empty_title: "Detail Uploads",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/uploads/Uploads",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.uploads.Uploads.detail_action;
    this.ls_insert_handler = Lino.uploads.Uploads.insert_action;
    Lino.uploads.Uploads.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.uploads.Uploads.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.uploads.Uploads.detail_actionPanel(p);
  return rv;
});
Lino.uploads.Uploads.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.uploads.Uploads.GridPanel(p);
  return rv;
});

Lino.lino.MyTextFieldTemplates.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/lino/MyTextFieldTemplates",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "My Text Field Templates",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "description" }, { "name": "text" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 3,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.MyTextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.MyTextFieldTemplates.insert_action;
    var ww = this.containing_window;
    var id1756 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name1757 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var description1758 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var text1759 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Template Text", "containing_panel": this });
    this.before_row_edit = function(record) {
      description1758.refresh();
      text1759.refresh();
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1756, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1757 }, { "colIndex": 2, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1758, "dataIndex": "description" }, { "colIndex": 3, "sortable": false, "header": "text", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": text1759, "dataIndex": "text" } ];
    Lino.lino.MyTextFieldTemplates.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.lino.MyTextFieldTemplates.insert_actionPanel = Ext.extend(Lino.lino.TextFieldTemplates.FormPanel,{
  empty_title: "New My Text Field Templates",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/lino/MyTextFieldTemplates",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.MyTextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.MyTextFieldTemplates.insert_action;
    Lino.lino.MyTextFieldTemplates.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.MyTextFieldTemplates.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.lino.MyTextFieldTemplates.insert_actionPanel(p);
  return rv;
});

Lino.lino.MyTextFieldTemplates.detail_actionPanel = Ext.extend(Lino.lino.TextFieldTemplates.FormPanel,{
  empty_title: "Detail My Text Field Templates",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/lino/MyTextFieldTemplates",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.lino.MyTextFieldTemplates.detail_action;
    this.ls_insert_handler = Lino.lino.MyTextFieldTemplates.insert_action;
    Lino.lino.MyTextFieldTemplates.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.lino.MyTextFieldTemplates.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.lino.MyTextFieldTemplates.detail_actionPanel(p);
  return rv;
});
Lino.lino.MyTextFieldTemplates.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.lino.MyTextFieldTemplates.GridPanel(p);
  return rv;
});

Lino.countries.CitiesByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/countries/CitiesByCountry",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Cities",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "zip_code" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 6,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 4,
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail_action;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert_action;
    var ww = this.containing_window;
    var name640 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var zip_code641 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 8 });
    var id642 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name640 }, { "colIndex": 1, "sortable": true, "header": "zip code", "editable": true, "filter": { "type": "string" }, "width": 72, "dataIndex": "zip_code", "hidden": false, "editor": zip_code641 }, { "colIndex": 2, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id642, "dataIndex": "id" } ];
    Lino.countries.CitiesByCountry.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.countries.CitiesByCountry.insert_actionPanel = Ext.extend(Lino.countries.Cities.FormPanel,{
  empty_title: "New Cities",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail_action;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert_action;
    Lino.countries.CitiesByCountry.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.countries.CitiesByCountry.insert_actionPanel(p);
  return rv;
});

Lino.countries.CitiesByCountry.detail_actionPanel = Ext.extend(Lino.countries.Cities.FormPanel,{
  empty_title: "Detail Cities",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/countries/CitiesByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.countries.CitiesByCountry.detail_action;
    this.ls_insert_handler = Lino.countries.CitiesByCountry.insert_action;
    Lino.countries.CitiesByCountry.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.countries.CitiesByCountry.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.countries.CitiesByCountry.detail_actionPanel(p);
  return rv;
});
Lino.countries.CitiesByCountry.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.countries.CitiesByCountry.GridPanel(p);
  return rv;
});

Lino.properties.PropsByGroup.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropsByGroup",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Properties",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "type" },'typeHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var id400 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name401 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de402 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr403 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var type404 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropsByGroup/type", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Type..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id400, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name401 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de402 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr403 }, { "colIndex": 4, "sortable": true, "header": "Property Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.properties.PropTypes.detail_action'), "hidden": false, "editor": type404, "dataIndex": "type" } ];
    Lino.properties.PropsByGroup.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropsByGroup.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.properties.PropsByGroup.GridPanel(p);
  return rv;
});

Lino.properties.PropsByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/PropsByType",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Properties",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "name" }, { "name": "name_de" }, { "name": "name_fr" }, { "name": "group" },'groupHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 9,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var id462 = { "selectOnFocus": true, "xtype": "numberfield" };
    var name463 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var name_de464 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name_fr465 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var group466 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/properties/PropsByType/group", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Property Group..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id462, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name463 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_de", "hidden": false, "editor": name_de464 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name_fr", "hidden": false, "editor": name_fr465 }, { "colIndex": 4, "sortable": true, "header": "Property Group", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('groupHidden','Lino.properties.PropGroups.detail_action'), "hidden": false, "editor": group466, "dataIndex": "group" } ];
    Lino.properties.PropsByType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.PropsByType.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.properties.PropsByType.GridPanel(p);
  return rv;
});

Lino.properties.ChoicesByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/properties/ChoicesByType",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Property Choices",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "value" }, { "name": "text" }, { "name": "text_de" }, { "name": "text_fr" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 10,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var value455 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var text456 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_de457 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var text_fr458 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id459 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Value", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "value", "hidden": false, "editor": value455 }, { "colIndex": 1, "sortable": true, "header": "Designation", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "text", "hidden": false, "editor": text456 }, { "colIndex": 2, "sortable": true, "header": "Designation (de)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "text_de", "hidden": false, "editor": text_de457 }, { "colIndex": 3, "sortable": true, "header": "Designation (fr)", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "text_fr", "hidden": false, "editor": text_fr458 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id459, "dataIndex": "id" } ];
    Lino.properties.ChoicesByType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.properties.ChoicesByType.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.properties.ChoicesByType.GridPanel(p);
  return rv;
});

Lino.contacts.PartnersByCity.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/PartnersByCity",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "street" }, { "name": "street_no" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "name" }, { "name": "language" },'languageHidden', { "type": "int", "name": "id" }, { "name": "country" },'countryHidden', { "name": "addr1" }, { "name": "street_prefix" }, { "name": "zip_code" }, { "name": "region" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail_action;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert_action;
    var ww = this.containing_window;
    var street475 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no476 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var street_box477 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var addr2478 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var name479 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language480 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var id481 = { "selectOnFocus": true, "xtype": "numberfield" };
    var country482 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCity/country", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Country..." });
    var addr1483 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix484 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var zip_code485 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var region486 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email487 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url488 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone489 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm490 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax491 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks492 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street", "hidden": false, "editor": street475 }, { "colIndex": 1, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_no", "hidden": false, "editor": street_no476 }, { "colIndex": 2, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_box", "hidden": false, "editor": street_box477 }, { "colIndex": 3, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr2", "hidden": false, "editor": addr2478 }, { "colIndex": 4, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name479 }, { "colIndex": 5, "sortable": true, "header": "Language", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language480 }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id481, "dataIndex": "id" }, { "colIndex": 7, "sortable": true, "header": "Country", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('countryHidden','Lino.countries.Countries.detail_action'), "hidden": false, "editor": country482, "dataIndex": "country" }, { "colIndex": 8, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr1", "hidden": false, "editor": addr1483 }, { "colIndex": 9, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix484 }, { "colIndex": 10, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "zip_code", "hidden": false, "editor": zip_code485 }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "region", "hidden": false, "editor": region486 }, { "colIndex": 12, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "email", "hidden": false, "editor": email487 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "url", "hidden": false, "editor": url488 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "phone", "hidden": false, "editor": phone489 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "gsm", "hidden": false, "editor": gsm490 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "fax", "hidden": false, "editor": fax491 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": remarks492, "dataIndex": "remarks" } ];
    Lino.contacts.PartnersByCity.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.PartnersByCity.insert_actionPanel = Ext.extend(Lino.contacts.Partners.FormPanel,{
  empty_title: "New Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/PartnersByCity",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail_action;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert_action;
    Lino.contacts.PartnersByCity.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.contacts.PartnersByCity.insert_actionPanel(p);
  return rv;
});

Lino.contacts.PartnersByCity.detail_actionPanel = Ext.extend(Lino.contacts.Partners.FormPanel,{
  empty_title: "Detail Partners",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/PartnersByCity",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCity.detail_action;
    this.ls_insert_handler = Lino.contacts.PartnersByCity.insert_action;
    Lino.contacts.PartnersByCity.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCity.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.PartnersByCity.detail_actionPanel(p);
  return rv;
});
Lino.contacts.PartnersByCity.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.PartnersByCity.GridPanel(p);
  return rv;
});

Lino.contacts.PartnersByCountry.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/PartnersByCountry",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Partners",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "city" },'cityHidden', { "name": "street" }, { "name": "street_no" }, { "name": "name" }, { "name": "language" },'languageHidden', { "type": "int", "name": "id" }, { "name": "addr1" }, { "name": "street_prefix" }, { "name": "street_box" }, { "name": "addr2" }, { "name": "zip_code" }, { "name": "region" }, { "name": "email" }, { "name": "url" }, { "name": "phone" }, { "name": "gsm" }, { "name": "fax" }, { "name": "remarks" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 15,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 21,
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail_action;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert_action;
    var ww = this.containing_window;
    var city1801 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "forceSelection": false, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/PartnersByCountry/city", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a City..." });
    var street1802 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_no1803 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var name1804 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var language1805 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var id1806 = { "selectOnFocus": true, "xtype": "numberfield" };
    var addr11807 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_prefix1808 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var street_box1809 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var addr21810 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var zip_code1811 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 10 });
    var region1812 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var email1813 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 75 });
    var url1814 = new Lino.URLField({ "selectOnFocus": true, "maxLength": 200 });
    var phone1815 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var gsm1816 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var fax1817 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var remarks1818 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
      var bp = this.get_base_params();
      city1801.setContextValue('mk',bp['mk']);
      city1801.setContextValue('mt',bp['mt']);
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "City", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('cityHidden','Lino.countries.Cities.detail_action'), "hidden": false, "editor": city1801, "dataIndex": "city" }, { "colIndex": 1, "sortable": true, "header": "Street", "editable": true, "tooltip": "Name of street. Without house number.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street", "hidden": false, "editor": street1802 }, { "colIndex": 2, "sortable": true, "header": "No.", "editable": true, "tooltip": "House number", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_no", "hidden": false, "editor": street_no1803 }, { "colIndex": 3, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1804 }, { "colIndex": 4, "sortable": true, "header": "Language", "editable": true, "tooltip": "Die Sprache, in der Dokumente ausgestellt werden sollen.", "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language1805 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1806, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Address line before street", "editable": true, "tooltip": "Address line before street", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr1", "hidden": false, "editor": addr11807 }, { "colIndex": 7, "sortable": true, "header": "Street prefix", "editable": true, "tooltip": "Text to print before name of street, but to ignore for sorting.", "filter": { "type": "string" }, "width": 180, "dataIndex": "street_prefix", "hidden": false, "editor": street_prefix1808 }, { "colIndex": 8, "sortable": true, "header": "Box", "editable": true, "tooltip": "Text to print after :attr:`steet_no` on the same line", "filter": { "type": "string" }, "width": 90, "dataIndex": "street_box", "hidden": false, "editor": street_box1809 }, { "colIndex": 9, "sortable": true, "header": "Address line after street", "editable": true, "tooltip": "Address line to print below street line", "filter": { "type": "string" }, "width": 180, "dataIndex": "addr2", "hidden": false, "editor": addr21810 }, { "colIndex": 10, "sortable": true, "header": "Zip code", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "zip_code", "hidden": false, "editor": zip_code1811 }, { "colIndex": 11, "sortable": true, "header": "Region", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "region", "hidden": false, "editor": region1812 }, { "colIndex": 12, "sortable": true, "header": "E-Mail", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "email", "hidden": false, "editor": email1813 }, { "colIndex": 13, "sortable": true, "header": "URL", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "url", "hidden": false, "editor": url1814 }, { "colIndex": 14, "sortable": true, "header": "Phone", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "phone", "hidden": false, "editor": phone1815 }, { "colIndex": 15, "sortable": true, "header": "GSM", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "gsm", "hidden": false, "editor": gsm1816 }, { "colIndex": 16, "sortable": true, "header": "Fax", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "fax", "hidden": false, "editor": fax1817 }, { "colIndex": 17, "sortable": false, "header": "Remarks", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": remarks1818, "dataIndex": "remarks" } ];
    Lino.contacts.PartnersByCountry.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.contacts.PartnersByCountry.insert_actionPanel = Ext.extend(Lino.contacts.Partners.FormPanel,{
  empty_title: "New Partners",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/contacts/PartnersByCountry",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail_action;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert_action;
    Lino.contacts.PartnersByCountry.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.contacts.PartnersByCountry.insert_actionPanel(p);
  return rv;
});

Lino.contacts.PartnersByCountry.detail_actionPanel = Ext.extend(Lino.contacts.Partners.FormPanel,{
  empty_title: "Detail Partners",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/contacts/PartnersByCountry",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.contacts.PartnersByCountry.detail_action;
    this.ls_insert_handler = Lino.contacts.PartnersByCountry.insert_action;
    Lino.contacts.PartnersByCountry.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.PartnersByCountry.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.PartnersByCountry.detail_actionPanel(p);
  return rv;
});
Lino.contacts.PartnersByCountry.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.PartnersByCountry.GridPanel(p);
  return rv;
});

Lino.contacts.RolesByCompany.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RolesByCompany",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Contact persons",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "person" },'personHidden', { "name": "type" },'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var person601 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/person", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Person..." });
    var type602 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByCompany/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Role Type..." });
    var id603 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Person", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('personHidden','Lino.contacts.Persons.detail_action'), "hidden": false, "editor": person601, "dataIndex": "person" }, { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "type", "hidden": false, "editor": type602 }, { "colIndex": 2, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id603, "dataIndex": "id" } ];
    Lino.contacts.RolesByCompany.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByCompany.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.RolesByCompany.GridPanel(p);
  return rv;
});

Lino.contacts.RolesByPerson.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/contacts/RolesByPerson",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Contact for",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "company" },'companyHidden', { "name": "type" },'typeHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 14,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    var ww = this.containing_window;
    var company240 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/company", "method": "GET" }) }), "allowBlank": false, "pageSize": 20, "emptyText": "Select a Company..." });
    var type241 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/contacts/RolesByPerson/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Role Type..." });
    var id242 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Company", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('companyHidden','Lino.contacts.Companies.detail_action'), "hidden": false, "editor": company240, "dataIndex": "company" }, { "colIndex": 1, "sortable": true, "header": "Contact Role", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "type", "hidden": false, "editor": type241 }, { "colIndex": 2, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id242, "dataIndex": "id" } ];
    Lino.contacts.RolesByPerson.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.contacts.RolesByPerson.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.contacts.RolesByPerson.GridPanel(p);
  return rv;
});

Lino.blogs.MyEntries.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/blogs/MyEntries",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "My Blog Entries",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "modified" }, { "name": "type" },'typeHidden', { "name": "subject" }, { "name": "body" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "ticket" },'ticketHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.MyEntries.detail_action;
    this.ls_insert_handler = Lino.blogs.MyEntries.insert_action;
    var ww = this.containing_window;
    var modified1844 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var type1845 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/MyEntries/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Blog Entry Type..." });
    var subject1846 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var body1847 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Body", "containing_panel": this });
    var id1848 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type1849 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/MyEntries/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id1850 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/MyEntries/owner_id", "method": "GET" }) }) });
    var created1851 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time1852 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var language1853 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var ticket1854 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/MyEntries/ticket", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket..." });
    var owner_disp1855 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      body1847.refresh();
      owner_id1850.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type1849.on('change',Lino.chooser_handler(owner_id1850,'owner_type'));
      Lino.blogs.MyEntries.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": 144, "colIndex": 0, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "Blog Entry Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.blogs.EntryTypes.detail_action'), "hidden": false, "editor": type1845, "dataIndex": "type" }, { "colIndex": 2, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "subject", "hidden": false, "editor": subject1846 }, { "colIndex": 3, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": body1847, "dataIndex": "body" }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1848, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type1849, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id1850 }, { "width": 144, "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language1853 }, { "colIndex": 10, "sortable": true, "width": 180, "editable": true, "tooltip": "The Ticket attributed to this Entry.", "filter": { "type": "string" }, "header": "Ticket", "renderer": Lino.fk_renderer('ticketHidden','Lino.tickets.Tickets.detail_action'), "hidden": false, "editor": ticket1854, "dataIndex": "ticket" }, { "width": 270, "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.blogs.MyEntries.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.MyEntries.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/blogs/MyEntries",pk,"clear");
};

Lino.blogs.MyEntries.insert_actionPanel = Ext.extend(Lino.blogs.Entries.FormPanel,{
  empty_title: "New My Blog Entries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/blogs/MyEntries",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.MyEntries.detail_action;
    this.ls_insert_handler = Lino.blogs.MyEntries.insert_action;
    Lino.blogs.MyEntries.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.MyEntries.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.blogs.MyEntries.insert_actionPanel(p);
  return rv;
});
Lino.blogs.MyEntries.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/blogs/MyEntries",pk,"print");
};

Lino.blogs.MyEntries.detail_actionPanel = Ext.extend(Lino.blogs.Entries.FormPanel,{
  empty_title: "Detail My Blog Entries",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') } ],
  ls_url: "/blogs/MyEntries",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.MyEntries.detail_action;
    this.ls_insert_handler = Lino.blogs.MyEntries.insert_action;
    Lino.blogs.MyEntries.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.MyEntries.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.blogs.MyEntries.detail_actionPanel(p);
  return rv;
});
Lino.blogs.MyEntries.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.blogs.MyEntries.GridPanel(p);
  return rv;
});

Lino.blogs.EntriesByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/blogs/EntriesByType",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Blog Entries",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "modified" }, { "name": "subject" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "body" }, { "name": "ticket" },'ticketHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntriesByType.detail_action;
    this.ls_insert_handler = Lino.blogs.EntriesByType.insert_action;
    var ww = this.containing_window;
    var modified834 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var subject835 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user836 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntriesByType/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id837 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type838 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntriesByType/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id839 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntriesByType/owner_id", "method": "GET" }) }) });
    var created840 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time841 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var language842 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var body843 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Body", "containing_panel": this });
    var ticket844 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/blogs/EntriesByType/ticket", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket..." });
    var owner_disp845 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id839.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body843.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type838.on('change',Lino.chooser_handler(owner_id839,'owner_type'));
      Lino.blogs.EntriesByType.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": 144, "colIndex": 0, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "subject", "hidden": false, "editor": subject835 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user836, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id837, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type838, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id839 }, { "width": 144, "colIndex": 6, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 7, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 8, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language842 }, { "colIndex": 9, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": body843, "dataIndex": "body" }, { "colIndex": 10, "sortable": true, "width": 180, "editable": true, "tooltip": "The Ticket attributed to this Entry.", "filter": { "type": "string" }, "header": "Ticket", "renderer": Lino.fk_renderer('ticketHidden','Lino.tickets.Tickets.detail_action'), "hidden": false, "editor": ticket844, "dataIndex": "ticket" }, { "width": 270, "colIndex": 11, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.blogs.EntriesByType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.EntriesByType.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/blogs/EntriesByType",pk,"clear");
};

Lino.blogs.EntriesByType.insert_actionPanel = Ext.extend(Lino.blogs.Entries.FormPanel,{
  empty_title: "New Blog Entries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/blogs/EntriesByType",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntriesByType.detail_action;
    this.ls_insert_handler = Lino.blogs.EntriesByType.insert_action;
    Lino.blogs.EntriesByType.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.EntriesByType.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.blogs.EntriesByType.insert_actionPanel(p);
  return rv;
});
Lino.blogs.EntriesByType.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/blogs/EntriesByType",pk,"print");
};

Lino.blogs.EntriesByType.detail_actionPanel = Ext.extend(Lino.blogs.Entries.FormPanel,{
  empty_title: "Detail Blog Entries",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') } ],
  ls_url: "/blogs/EntriesByType",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.blogs.EntriesByType.detail_action;
    this.ls_insert_handler = Lino.blogs.EntriesByType.insert_action;
    Lino.blogs.EntriesByType.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.blogs.EntriesByType.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.blogs.EntriesByType.detail_actionPanel(p);
  return rv;
});
Lino.blogs.EntriesByType.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.blogs.EntriesByType.GridPanel(p);
  return rv;
});

Lino.tickets.ProjectsByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/ProjectsByProject",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Sub-projects",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "summary" }, { "name": "partner" },'partnerHidden', { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "type" },'typeHidden', { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.ProjectsByProject.detail_action;
    this.ls_insert_handler = Lino.tickets.ProjectsByProject.insert_action;
    var ww = this.containing_window;
    var name354 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 20 });
    var summary355 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var partner356 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/ProjectsByProject/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var id357 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user358 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/ProjectsByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var type359 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/ProjectsByProject/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project Type..." });
    var description360 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name354 }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary355 }, { "colIndex": 2, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner356, "dataIndex": "partner" }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id357, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user358, "dataIndex": "user" }, { "colIndex": 5, "sortable": true, "header": "Project Type", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "type", "hidden": false, "editor": type359 }, { "colIndex": 6, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description360, "dataIndex": "description" } ];
    Lino.tickets.ProjectsByProject.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.ProjectsByProject.insert_actionPanel = Ext.extend(Lino.tickets.Projects.FormPanel,{
  empty_title: "New Sub-projects",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/ProjectsByProject",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.ProjectsByProject.detail_action;
    this.ls_insert_handler = Lino.tickets.ProjectsByProject.insert_action;
    Lino.tickets.ProjectsByProject.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.ProjectsByProject.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.ProjectsByProject.insert_actionPanel(p);
  return rv;
});

Lino.tickets.ProjectsByProject.detail_actionPanel = Ext.extend(Lino.tickets.Projects.FormPanel,{
  empty_title: "Detail Sub-projects",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/ProjectsByProject",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.ProjectsByProject.detail_action;
    this.ls_insert_handler = Lino.tickets.ProjectsByProject.insert_action;
    Lino.tickets.ProjectsByProject.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.ProjectsByProject.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.ProjectsByProject.detail_actionPanel(p);
  return rv;
});
Lino.tickets.ProjectsByProject.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.ProjectsByProject.GridPanel(p);
  return rv;
});

Lino.tickets.ProjectsByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/ProjectsByPartner",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Projects",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "name": "summary" }, { "type": "int", "name": "id" }, { "name": "user" },'userHidden', { "name": "parent" },'parentHidden', { "name": "type" },'typeHidden', { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 2,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.ProjectsByPartner.detail_action;
    this.ls_insert_handler = Lino.tickets.ProjectsByPartner.insert_action;
    var ww = this.containing_window;
    var name248 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 20 });
    var summary249 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id250 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user251 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/ProjectsByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var parent252 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/ProjectsByPartner/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var type253 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/ProjectsByPartner/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project Type..." });
    var description254 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name248 }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary249 }, { "colIndex": 2, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id250, "dataIndex": "id" }, { "colIndex": 3, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user251, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Parent", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('parentHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": parent252, "dataIndex": "parent" }, { "colIndex": 5, "sortable": true, "header": "Project Type", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "type", "hidden": false, "editor": type253 }, { "colIndex": 6, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description254, "dataIndex": "description" } ];
    Lino.tickets.ProjectsByPartner.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.ProjectsByPartner.insert_actionPanel = Ext.extend(Lino.tickets.Projects.FormPanel,{
  empty_title: "New Projects",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/ProjectsByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.ProjectsByPartner.detail_action;
    this.ls_insert_handler = Lino.tickets.ProjectsByPartner.insert_action;
    Lino.tickets.ProjectsByPartner.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.ProjectsByPartner.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.ProjectsByPartner.insert_actionPanel(p);
  return rv;
});

Lino.tickets.ProjectsByPartner.detail_actionPanel = Ext.extend(Lino.tickets.Projects.FormPanel,{
  empty_title: "Detail Projects",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/ProjectsByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.ProjectsByPartner.detail_action;
    this.ls_insert_handler = Lino.tickets.ProjectsByPartner.insert_action;
    Lino.tickets.ProjectsByPartner.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.ProjectsByPartner.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.ProjectsByPartner.detail_actionPanel(p);
  return rv;
});
Lino.tickets.ProjectsByPartner.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.ProjectsByPartner.GridPanel(p);
  return rv;
});

Lino.tickets.TicketsByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/TicketsByProject",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Tickets",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "summary" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "created" }, { "name": "modified" }, { "name": "state" },'stateHidden', { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.TicketsByProject.detail_action;
    this.ls_insert_handler = Lino.tickets.TicketsByProject.insert_action;
    var ww = this.containing_window;
    var summary271 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user272 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/TicketsByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id273 = { "selectOnFocus": true, "xtype": "numberfield" };
    var created274 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified275 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var state276 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/TicketsByProject/state", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket State..." });
    var description277 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary271 }, { "colIndex": 1, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user272, "dataIndex": "user" }, { "colIndex": 2, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id273, "dataIndex": "id" }, { "width": 144, "colIndex": 3, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 4, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 5, "sortable": true, "header": "Ticket State", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "state", "hidden": false, "editor": state276 }, { "colIndex": 6, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description277, "dataIndex": "description" } ];
    Lino.tickets.TicketsByProject.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.TicketsByProject.insert_actionPanel = Ext.extend(Lino.tickets.Tickets.FormPanel,{
  empty_title: "New Tickets",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/TicketsByProject",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.TicketsByProject.detail_action;
    this.ls_insert_handler = Lino.tickets.TicketsByProject.insert_action;
    Lino.tickets.TicketsByProject.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.TicketsByProject.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.TicketsByProject.insert_actionPanel(p);
  return rv;
});

Lino.tickets.TicketsByProject.detail_actionPanel = Ext.extend(Lino.tickets.Tickets.FormPanel,{
  empty_title: "Detail Tickets",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/TicketsByProject",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.TicketsByProject.detail_action;
    this.ls_insert_handler = Lino.tickets.TicketsByProject.insert_action;
    Lino.tickets.TicketsByProject.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.TicketsByProject.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.TicketsByProject.detail_actionPanel(p);
  return rv;
});
Lino.tickets.TicketsByProject.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.TicketsByProject.GridPanel(p);
  return rv;
});

Lino.tickets.SessionsByTicket.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/SessionsByTicket",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Sessions",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "end_time" }, { "name": "break_time" }, { "name": "description" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "project" },'projectHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.SessionsByTicket.detail_action;
    this.ls_insert_handler = Lino.tickets.SessionsByTicket.insert_action;
    var ww = this.containing_window;
    var date291 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var start_time292 = new Lino.TimeField({ "selectOnFocus": true });
    var end_time293 = new Lino.TimeField({ "selectOnFocus": true });
    var break_time294 = new Lino.TimeField({ "selectOnFocus": true });
    var description295 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var user296 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/SessionsByTicket/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id297 = { "selectOnFocus": true, "xtype": "numberfield" };
    var project298 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/SessionsByTicket/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "hidden": false, "width": 72, "editor": date291 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time292 }, { "colIndex": 2, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time293 }, { "colIndex": 3, "sortable": true, "header": "Break Time", "editable": true, "width": 72, "dataIndex": "break_time", "hidden": false, "editor": break_time294 }, { "colIndex": 4, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description295, "dataIndex": "description" }, { "colIndex": 5, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user296, "dataIndex": "user" }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id297, "dataIndex": "id" }, { "colIndex": 7, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project298, "dataIndex": "project" } ];
    Lino.tickets.SessionsByTicket.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.SessionsByTicket.insert_actionPanel = Ext.extend(Lino.tickets.Sessions.FormPanel,{
  empty_title: "New Sessions",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/SessionsByTicket",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.SessionsByTicket.detail_action;
    this.ls_insert_handler = Lino.tickets.SessionsByTicket.insert_action;
    Lino.tickets.SessionsByTicket.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.SessionsByTicket.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.SessionsByTicket.insert_actionPanel(p);
  return rv;
});

Lino.tickets.SessionsByTicket.detail_actionPanel = Ext.extend(Lino.tickets.Sessions.FormPanel,{
  empty_title: "Detail Sessions",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/SessionsByTicket",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.SessionsByTicket.detail_action;
    this.ls_insert_handler = Lino.tickets.SessionsByTicket.insert_action;
    Lino.tickets.SessionsByTicket.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.SessionsByTicket.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.SessionsByTicket.detail_actionPanel(p);
  return rv;
});
Lino.tickets.SessionsByTicket.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.SessionsByTicket.GridPanel(p);
  return rv;
});

Lino.tickets.MySessions.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/MySessions",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "My Sessions",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "end_time" }, { "name": "break_time" }, { "name": "project" },'projectHidden', { "name": "ticket" },'ticketHidden', { "name": "description" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 9,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MySessions.detail_action;
    this.ls_insert_handler = Lino.tickets.MySessions.insert_action;
    var ww = this.containing_window;
    var date1910 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var start_time1911 = new Lino.TimeField({ "selectOnFocus": true });
    var end_time1912 = new Lino.TimeField({ "selectOnFocus": true });
    var break_time1913 = new Lino.TimeField({ "selectOnFocus": true });
    var project1914 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/MySessions/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var ticket1915 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/MySessions/ticket", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket..." });
    var description1916 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1917 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "hidden": false, "width": 72, "editor": date1910 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time1911 }, { "colIndex": 2, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time1912 }, { "colIndex": 3, "sortable": true, "header": "Break Time", "editable": true, "width": 72, "dataIndex": "break_time", "hidden": false, "editor": break_time1913 }, { "colIndex": 4, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1914, "dataIndex": "project" }, { "colIndex": 5, "sortable": true, "header": "Ticket", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('ticketHidden','Lino.tickets.Tickets.detail_action'), "hidden": false, "editor": ticket1915, "dataIndex": "ticket" }, { "colIndex": 6, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1916, "dataIndex": "description" }, { "colIndex": 7, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1917, "dataIndex": "id" } ];
    Lino.tickets.MySessions.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.MySessions.insert_actionPanel = Ext.extend(Lino.tickets.Sessions.FormPanel,{
  empty_title: "New My Sessions",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/MySessions",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MySessions.detail_action;
    this.ls_insert_handler = Lino.tickets.MySessions.insert_action;
    Lino.tickets.MySessions.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.MySessions.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.MySessions.insert_actionPanel(p);
  return rv;
});

Lino.tickets.MySessions.detail_actionPanel = Ext.extend(Lino.tickets.Sessions.FormPanel,{
  empty_title: "Detail My Sessions",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/MySessions",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MySessions.detail_action;
    this.ls_insert_handler = Lino.tickets.MySessions.insert_action;
    Lino.tickets.MySessions.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.MySessions.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.MySessions.detail_actionPanel(p);
  return rv;
});
Lino.tickets.MySessions.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.MySessions.GridPanel(p);
  return rv;
});

Lino.tickets.MySessionsByDate.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/MySessionsByDate",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "My sessions by date",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "start_time" }, { "name": "end_time" }, { "name": "break_time" }, { "name": "project" },'projectHidden', { "name": "ticket" },'ticketHidden', { "name": "description" }, { "type": "int", "name": "id" }, { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 23,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MySessionsByDate.detail_action;
    this.ls_insert_handler = Lino.tickets.MySessionsByDate.insert_action;
    var ww = this.containing_window;
    var start_time1927 = new Lino.TimeField({ "selectOnFocus": true });
    var end_time1928 = new Lino.TimeField({ "selectOnFocus": true });
    var break_time1929 = new Lino.TimeField({ "selectOnFocus": true });
    var project1930 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/MySessionsByDate/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var ticket1931 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/MySessionsByDate/ticket", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket..." });
    var description1932 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    var id1933 = { "selectOnFocus": true, "xtype": "numberfield" };
    var date1934 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time1927 }, { "colIndex": 1, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time1928 }, { "colIndex": 2, "sortable": true, "header": "Break Time", "editable": true, "width": 72, "dataIndex": "break_time", "hidden": false, "editor": break_time1929 }, { "colIndex": 3, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1930, "dataIndex": "project" }, { "colIndex": 4, "sortable": true, "header": "Ticket", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('ticketHidden','Lino.tickets.Tickets.detail_action'), "hidden": false, "editor": ticket1931, "dataIndex": "ticket" }, { "colIndex": 5, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1932, "dataIndex": "description" }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1933, "dataIndex": "id" }, { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "hidden": false, "width": 72, "editor": date1934 } ];
    Lino.tickets.MySessionsByDate.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.MySessionsByDate.insert_actionPanel = Ext.extend(Lino.tickets.Sessions.FormPanel,{
  empty_title: "New My sessions by date",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/MySessionsByDate",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MySessionsByDate.detail_action;
    this.ls_insert_handler = Lino.tickets.MySessionsByDate.insert_action;
    Lino.tickets.MySessionsByDate.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.MySessionsByDate.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var today1936 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "100%", "name": "today" });
  var main_panel1937 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "labelWidth": 45, "items": [ { "items": today1936, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "hideCheckBoxLabels": true, "layout": "fit", "frame": false, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel1937;
  p.params_panel.fields = [ today1936 ];
  var rv = new Lino.tickets.MySessionsByDate.insert_actionPanel(p);
  return rv;
});

Lino.tickets.MySessionsByDate.detail_actionPanel = Ext.extend(Lino.tickets.Sessions.FormPanel,{
  empty_title: "Detail My sessions by date",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/MySessionsByDate",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MySessionsByDate.detail_action;
    this.ls_insert_handler = Lino.tickets.MySessionsByDate.insert_action;
    Lino.tickets.MySessionsByDate.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.MySessionsByDate.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var today1936 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "100%", "name": "today" });
  var main_panel1937 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "labelWidth": 45, "items": [ { "items": today1936, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "hideCheckBoxLabels": true, "layout": "fit", "frame": false, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel1937;
  p.params_panel.fields = [ today1936 ];
  var rv = new Lino.tickets.MySessionsByDate.detail_actionPanel(p);
  return rv;
});
Lino.tickets.MySessionsByDate.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var today1936 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "100%", "name": "today" });
  var main_panel1937 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "labelWidth": 45, "items": [ { "items": today1936, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "hideCheckBoxLabels": true, "layout": "fit", "frame": false, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel1937;
  p.params_panel.fields = [ today1936 ];
  var rv = new Lino.tickets.MySessionsByDate.GridPanel(p);
  return rv;
});

Lino.tickets.EntriesByTicket.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/EntriesByTicket",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Blog Entries",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "user" },'userHidden', { "name": "type" },'typeHidden', { "name": "subject" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.EntriesByTicket.detail_action;
    this.ls_insert_handler = Lino.tickets.EntriesByTicket.insert_action;
    var ww = this.containing_window;
    var id336 = { "selectOnFocus": true, "xtype": "numberfield" };
    var modified337 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var user338 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/EntriesByTicket/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var type339 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/EntriesByTicket/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Blog Entry Type..." });
    var subject340 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_type341 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/EntriesByTicket/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id342 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/EntriesByTicket/owner_id", "method": "GET" }) }) });
    var created343 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time344 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var language345 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var owner_disp346 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    var body347 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Body", "containing_panel": this });
    this.before_row_edit = function(record) {
      owner_id342.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body347.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type341.on('change',Lino.chooser_handler(owner_id342,'owner_type'));
      Lino.tickets.EntriesByTicket.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id336, "dataIndex": "id" }, { "width": 144, "colIndex": 1, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user338, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Blog Entry Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.blogs.EntryTypes.detail_action'), "hidden": false, "editor": type339, "dataIndex": "type" }, { "colIndex": 4, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "subject", "hidden": false, "editor": subject340 }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type341, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id342 }, { "width": 144, "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language345 }, { "width": 270, "colIndex": 10, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false }, { "colIndex": 11, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": body347, "dataIndex": "body" } ];
    Lino.tickets.EntriesByTicket.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.EntriesByTicket.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/tickets/EntriesByTicket",pk,"clear");
};

Lino.tickets.EntriesByTicket.insert_actionPanel = Ext.extend(Lino.blogs.Entries.FormPanel,{
  empty_title: "New Blog Entries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/EntriesByTicket",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.EntriesByTicket.detail_action;
    this.ls_insert_handler = Lino.tickets.EntriesByTicket.insert_action;
    Lino.tickets.EntriesByTicket.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.EntriesByTicket.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.EntriesByTicket.insert_actionPanel(p);
  return rv;
});
Lino.tickets.EntriesByTicket.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/tickets/EntriesByTicket",pk,"print");
};

Lino.tickets.EntriesByTicket.detail_actionPanel = Ext.extend(Lino.blogs.Entries.FormPanel,{
  empty_title: "Detail Blog Entries",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') } ],
  ls_url: "/tickets/EntriesByTicket",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.EntriesByTicket.detail_action;
    this.ls_insert_handler = Lino.tickets.EntriesByTicket.insert_action;
    Lino.tickets.EntriesByTicket.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.EntriesByTicket.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.EntriesByTicket.detail_actionPanel(p);
  return rv;
});
Lino.tickets.EntriesByTicket.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.EntriesByTicket.GridPanel(p);
  return rv;
});

Lino.tickets.EntriesBySession.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/EntriesBySession",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "Blog Entries",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "modified" }, { "name": "user" },'userHidden', { "name": "type" },'typeHidden', { "name": "subject" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "build_time" }, { "name": "language" },'languageHidden', { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 19,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 18,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.EntriesBySession.detail_action;
    this.ls_insert_handler = Lino.tickets.EntriesBySession.insert_action;
    var ww = this.containing_window;
    var id319 = { "selectOnFocus": true, "xtype": "numberfield" };
    var modified320 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var user321 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/EntriesBySession/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var type322 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/EntriesBySession/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Blog Entry Type..." });
    var subject323 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var owner_type324 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/EntriesBySession/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id325 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/EntriesBySession/owner_id", "method": "GET" }) }) });
    var created326 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time327 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var language328 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "store": [ [ "en", "English" ], [ "de", "German" ], [ "fr", "French" ] ], "allowBlank": false, "value": "en" });
    var owner_disp329 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    var body330 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Body", "containing_panel": this });
    this.before_row_edit = function(record) {
      owner_id325.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body330.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type324.on('change',Lino.chooser_handler(owner_id325,'owner_type'));
      Lino.tickets.EntriesBySession.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id319, "dataIndex": "id" }, { "width": 144, "colIndex": 1, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user321, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Blog Entry Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.blogs.EntryTypes.detail_action'), "hidden": false, "editor": type322, "dataIndex": "type" }, { "colIndex": 4, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "subject", "hidden": false, "editor": subject323 }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type324, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id325 }, { "width": 144, "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Language", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "language", "hidden": false, "editor": language328 }, { "width": 270, "colIndex": 10, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false }, { "colIndex": 11, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": body330, "dataIndex": "body" } ];
    Lino.tickets.EntriesBySession.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.EntriesBySession.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/tickets/EntriesBySession",pk,"clear");
};

Lino.tickets.EntriesBySession.insert_actionPanel = Ext.extend(Lino.blogs.Entries.FormPanel,{
  empty_title: "New Blog Entries",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/EntriesBySession",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.EntriesBySession.detail_action;
    this.ls_insert_handler = Lino.tickets.EntriesBySession.insert_action;
    Lino.tickets.EntriesBySession.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.EntriesBySession.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.EntriesBySession.insert_actionPanel(p);
  return rv;
});
Lino.tickets.EntriesBySession.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/tickets/EntriesBySession",pk,"print");
};

Lino.tickets.EntriesBySession.detail_actionPanel = Ext.extend(Lino.blogs.Entries.FormPanel,{
  empty_title: "Detail Blog Entries",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') } ],
  ls_url: "/tickets/EntriesBySession",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.EntriesBySession.detail_action;
    this.ls_insert_handler = Lino.tickets.EntriesBySession.insert_action;
    Lino.tickets.EntriesBySession.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.EntriesBySession.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.EntriesBySession.detail_actionPanel(p);
  return rv;
});
Lino.tickets.EntriesBySession.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.EntriesBySession.GridPanel(p);
  return rv;
});

Lino.tickets.MyProjects.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/MyProjects",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "My Projects",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "name" }, { "type": "int", "name": "id" }, { "name": "summary" }, { "name": "parent" },'parentHidden', { "name": "type" },'typeHidden', { "name": "partner" },'partnerHidden', { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 21,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 11,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MyProjects.detail_action;
    this.ls_insert_handler = Lino.tickets.MyProjects.insert_action;
    var ww = this.containing_window;
    var name1971 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 20 });
    var id1972 = { "selectOnFocus": true, "xtype": "numberfield" };
    var summary1973 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var parent1974 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/MyProjects/parent", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var type1975 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/MyProjects/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project Type..." });
    var partner1976 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/MyProjects/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var description1977 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name1971 }, { "colIndex": 1, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1972, "dataIndex": "id" }, { "colIndex": 2, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary1973 }, { "colIndex": 3, "sortable": true, "header": "Parent", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('parentHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": parent1974, "dataIndex": "parent" }, { "colIndex": 4, "sortable": true, "header": "Project Type", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "type", "hidden": false, "editor": type1975 }, { "colIndex": 5, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner1976, "dataIndex": "partner" }, { "colIndex": 6, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1977, "dataIndex": "description" } ];
    Lino.tickets.MyProjects.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.MyProjects.insert_actionPanel = Ext.extend(Lino.tickets.Projects.FormPanel,{
  empty_title: "New My Projects",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/MyProjects",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MyProjects.detail_action;
    this.ls_insert_handler = Lino.tickets.MyProjects.insert_action;
    Lino.tickets.MyProjects.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.MyProjects.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.MyProjects.insert_actionPanel(p);
  return rv;
});

Lino.tickets.MyProjects.detail_actionPanel = Ext.extend(Lino.tickets.Projects.FormPanel,{
  empty_title: "Detail My Projects",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/MyProjects",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MyProjects.detail_action;
    this.ls_insert_handler = Lino.tickets.MyProjects.insert_action;
    Lino.tickets.MyProjects.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.MyProjects.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.MyProjects.detail_actionPanel(p);
  return rv;
});
Lino.tickets.MyProjects.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.MyProjects.GridPanel(p);
  return rv;
});

Lino.tickets.MyTickets.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/tickets/MyTickets",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail } ],
  title : "My Tickets",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "created" }, { "type": "int", "name": "id" }, { "name": "project" },'projectHidden', { "name": "summary" }, { "name": "state" },'stateHidden', { "name": "modified" }, { "name": "description" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 1,
  ls_grid_configs : [  ],
  content_type : 25,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 10,
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MyTickets.detail_action;
    this.ls_insert_handler = Lino.tickets.MyTickets.insert_action;
    var ww = this.containing_window;
    var created1986 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var id1987 = { "selectOnFocus": true, "xtype": "numberfield" };
    var project1988 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/MyTickets/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var summary1989 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state1990 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/tickets/MyTickets/state", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Ticket State..." });
    var modified1991 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var description1992 = new Ext.form.TextArea({ "selectOnFocus": true, "growMax": 2000 });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": 144, "colIndex": 0, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id1987, "dataIndex": "id" }, { "colIndex": 2, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project1988, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary1989 }, { "colIndex": 4, "sortable": true, "header": "Ticket State", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "state", "hidden": false, "editor": state1990 }, { "width": 144, "colIndex": 5, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 6, "sortable": false, "header": "Description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description1992, "dataIndex": "description" } ];
    Lino.tickets.MyTickets.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.tickets.MyTickets.insert_actionPanel = Ext.extend(Lino.tickets.Tickets.FormPanel,{
  empty_title: "New My Tickets",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/tickets/MyTickets",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MyTickets.detail_action;
    this.ls_insert_handler = Lino.tickets.MyTickets.insert_action;
    Lino.tickets.MyTickets.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.MyTickets.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.tickets.MyTickets.insert_actionPanel(p);
  return rv;
});

Lino.tickets.MyTickets.detail_actionPanel = Ext.extend(Lino.tickets.Tickets.FormPanel,{
  empty_title: "Detail My Tickets",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} } ],
  ls_url: "/tickets/MyTickets",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.tickets.MyTickets.detail_action;
    this.ls_insert_handler = Lino.tickets.MyTickets.insert_action;
    Lino.tickets.MyTickets.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.tickets.MyTickets.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.MyTickets.detail_actionPanel(p);
  return rv;
});
Lino.tickets.MyTickets.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.tickets.MyTickets.GridPanel(p);
  return rv;
});

Lino.outbox.RecipientsByMail.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/RecipientsByMail",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Recipients",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "type" },'typeHidden', { "name": "partner" },'partnerHidden', { "name": "address" }, { "name": "name" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 40,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 8,
  initComponent : function() {
    var ww = this.containing_window;
    var type136 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "to", "to" ], [ "cc", "cc" ], [ "bcc", "bcc" ] ] });
    var partner137 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/RecipientsByMail/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var address138 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 75 });
    var name139 = new Ext.form.TextField({ "selectOnFocus": true, "allowBlank": false, "maxLength": 200 });
    var id140 = { "selectOnFocus": true, "xtype": "numberfield" };
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Recipient Type", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "type", "hidden": false, "editor": type136 }, { "colIndex": 1, "sortable": true, "header": "Partner", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner137, "dataIndex": "partner" }, { "colIndex": 2, "sortable": true, "header": "Address", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "address", "hidden": false, "editor": address138 }, { "colIndex": 3, "sortable": true, "header": "Name", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "name", "hidden": false, "editor": name139 }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id140, "dataIndex": "id" } ];
    Lino.outbox.RecipientsByMail.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.RecipientsByMail.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.RecipientsByMail.GridPanel(p);
  return rv;
});

Lino.outbox.MyOutbox.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/MyOutbox",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  title : "My Outbox",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "recipients" }, { "name": "subject" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "project" },'projectHidden', { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "owner" }, { "name": "body" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MyOutbox.detail_action;
    this.ls_insert_handler = Lino.outbox.MyOutbox.insert_action;
    var ww = this.containing_window;
    var sent2006 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var recipients_htmlbox2007 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent(), "title": "Recipients", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "autoScroll": true });
    var subject2008 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var id2009 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2010 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MyOutbox/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2011 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MyOutbox/owner_id", "method": "GET" }) }) });
    var project2012 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MyOutbox/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var date2013 = new Lino.DateField({ "disabled": true, "readOnly": true });
    var owner_disp2014 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    var body2015 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Body", "containing_panel": this });
    this.before_row_edit = function(record) {
      recipients_htmlbox2007.refresh();
      owner_id2011.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body2015.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2010.on('change',Lino.chooser_handler(owner_id2011,'owner_type'));
      Lino.outbox.MyOutbox.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "width": 144, "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": false, "header": "Recipients", "editable": false, "filter": { "type": "string" }, "width": 270, "dataIndex": "recipients", "hidden": false }, { "colIndex": 2, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "subject", "hidden": false, "editor": subject2008 }, { "colIndex": 3, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2009, "dataIndex": "id" }, { "colIndex": 4, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2010, "dataIndex": "owner_type" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2011 }, { "colIndex": 6, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2012, "dataIndex": "project" }, { "colIndex": 7, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "\n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "hidden": false, "width": 72 }, { "width": 270, "colIndex": 8, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": body2015, "dataIndex": "body" } ];
    Lino.outbox.MyOutbox.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MyOutbox.insert_actionPanel = Ext.extend(Lino.outbox.Mails.FormPanel,{
  empty_title: "New My Outbox",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  ls_url: "/outbox/MyOutbox",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MyOutbox.detail_action;
    this.ls_insert_handler = Lino.outbox.MyOutbox.insert_action;
    Lino.outbox.MyOutbox.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MyOutbox.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.outbox.MyOutbox.insert_actionPanel(p);
  return rv;
});

Lino.outbox.MyOutbox.detail_actionPanel = Ext.extend(Lino.outbox.Mails.FormPanel,{
  empty_title: "Detail My Outbox",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  ls_url: "/outbox/MyOutbox",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MyOutbox.detail_action;
    this.ls_insert_handler = Lino.outbox.MyOutbox.insert_action;
    Lino.outbox.MyOutbox.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MyOutbox.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.MyOutbox.detail_actionPanel(p);
  return rv;
});
Lino.outbox.MyOutbox.send_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/outbox/MyOutbox",pk,"send");
};
Lino.outbox.MyOutbox.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.MyOutbox.GridPanel(p);
  return rv;
});

Lino.outbox.MailsByUser.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/MailsByUser",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  title : "Outbox",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "subject" }, { "name": "recipients" }, { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 3,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 5,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail_action;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert_action;
    var ww = this.containing_window;
    var sent2027 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var subject2028 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var recipients_htmlbox2029 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent(), "title": "Recipients", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "autoScroll": true });
    this.before_row_edit = function(record) {
      recipients_htmlbox2029.refresh();
    };
    this.ls_columns = [ { "width": 144, "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "subject", "hidden": false, "editor": subject2028 }, { "colIndex": 2, "sortable": false, "header": "Recipients", "editable": false, "filter": { "type": "string" }, "width": 270, "dataIndex": "recipients", "hidden": false } ];
    Lino.outbox.MailsByUser.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByUser.insert_actionPanel = Ext.extend(Lino.outbox.Mails.FormPanel,{
  empty_title: "New Outbox",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  ls_url: "/outbox/MailsByUser",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail_action;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert_action;
    Lino.outbox.MailsByUser.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.outbox.MailsByUser.insert_actionPanel(p);
  return rv;
});

Lino.outbox.MailsByUser.detail_actionPanel = Ext.extend(Lino.outbox.Mails.FormPanel,{
  empty_title: "Detail Outbox",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  ls_url: "/outbox/MailsByUser",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByUser.detail_action;
    this.ls_insert_handler = Lino.outbox.MailsByUser.insert_action;
    Lino.outbox.MailsByUser.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByUser.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.MailsByUser.detail_actionPanel(p);
  return rv;
});
Lino.outbox.MailsByUser.send_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/outbox/MailsByUser",pk,"send");
};
Lino.outbox.MailsByUser.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.MailsByUser.GridPanel(p);
  return rv;
});

Lino.outbox.MailsByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/MailsByProject",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  title : "Outbox",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "subject" }, { "name": "recipients" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "body" }, { "name": "sent" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 14,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail_action;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert_action;
    var ww = this.containing_window;
    var date2034 = new Lino.DateField({ "disabled": true, "readOnly": true });
    var subject2035 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var recipients_htmlbox2036 = new Lino.HtmlBoxPanel({ "layout": "fit", "name": "recipients", "containing_panel": this, "items": new Ext.BoxComponent(), "title": "Recipients", "master_panel": this, "value": "<br/>", "always_enabled": true, "bodyStyle": "overflow-x:hidden !important;", "autoScroll": true });
    var user2037 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var id2038 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2039 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2040 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/MailsByProject/owner_id", "method": "GET" }) }) });
    var body2041 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Body", "containing_panel": this });
    var sent2042 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var owner_disp2043 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      recipients_htmlbox2036.refresh();
      owner_id2040.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      body2041.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2039.on('change',Lino.chooser_handler(owner_id2040,'owner_type'));
      Lino.outbox.MailsByProject.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": false, "tooltip": "\n        The official date to be printed on the document.\n        ", "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Date", "dataIndex": "date", "hidden": false, "width": 72 }, { "colIndex": 1, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "subject", "hidden": false, "editor": subject2035 }, { "colIndex": 2, "sortable": false, "header": "Recipients", "editable": false, "filter": { "type": "string" }, "width": 270, "dataIndex": "recipients", "hidden": false }, { "colIndex": 3, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user2037, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2038, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2039, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2040 }, { "colIndex": 7, "sortable": false, "header": "body", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": body2041, "dataIndex": "body" }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "sent", "header": "sent", "hidden": false, "editable": false }, { "width": 270, "colIndex": 9, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.outbox.MailsByProject.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.MailsByProject.insert_actionPanel = Ext.extend(Lino.outbox.Mails.FormPanel,{
  empty_title: "New Outbox",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  ls_url: "/outbox/MailsByProject",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail_action;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert_action;
    Lino.outbox.MailsByProject.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.outbox.MailsByProject.insert_actionPanel(p);
  return rv;
});

Lino.outbox.MailsByProject.detail_actionPanel = Ext.extend(Lino.outbox.Mails.FormPanel,{
  empty_title: "Detail Outbox",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  ls_url: "/outbox/MailsByProject",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.MailsByProject.detail_action;
    this.ls_insert_handler = Lino.outbox.MailsByProject.insert_action;
    Lino.outbox.MailsByProject.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.MailsByProject.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.MailsByProject.detail_actionPanel(p);
  return rv;
});
Lino.outbox.MailsByProject.send_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/outbox/MailsByProject",pk,"send");
};
Lino.outbox.MailsByProject.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.MailsByProject.GridPanel(p);
  return rv;
});

Lino.outbox.SentByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/SentByPartner",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  title : "Outbox",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "sent" }, { "name": "subject" }, { "name": "user" },'userHidden', { "type": "int", "name": "id" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 4,
  ls_grid_configs : [  ],
  content_type : 39,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 6,
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail_action;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert_action;
    var ww = this.containing_window;
    var sent2055 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var subject2056 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var user2057 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/SentByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "width": 144, "colIndex": 0, "sortable": true, "dataIndex": "sent", "header": "sent", "hidden": false, "editable": false }, { "colIndex": 1, "sortable": true, "header": "Subject", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "subject", "hidden": false, "editor": subject2056 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user2057, "dataIndex": "user" } ];
    Lino.outbox.SentByPartner.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.outbox.SentByPartner.insert_actionPanel = Ext.extend(Lino.outbox.Mails.FormPanel,{
  empty_title: "New Outbox",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  ls_url: "/outbox/SentByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail_action;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert_action;
    Lino.outbox.SentByPartner.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.outbox.SentByPartner.insert_actionPanel(p);
  return rv;
});

Lino.outbox.SentByPartner.detail_actionPanel = Ext.extend(Lino.outbox.Mails.FormPanel,{
  empty_title: "Detail Outbox",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "send_mail", "text": "Send email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('send') } ],
  ls_url: "/outbox/SentByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.outbox.SentByPartner.detail_action;
    this.ls_insert_handler = Lino.outbox.SentByPartner.insert_action;
    Lino.outbox.SentByPartner.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.SentByPartner.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.SentByPartner.detail_actionPanel(p);
  return rv;
});
Lino.outbox.SentByPartner.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.SentByPartner.GridPanel(p);
  return rv;
});
Lino.outbox.SentByPartner.send_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/outbox/SentByPartner",pk,"send");
};

Lino.outbox.AttachmentsByMail.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/outbox/AttachmentsByMail",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected } ],
  title : "Attachments",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 0,
  ls_grid_configs : [  ],
  content_type : 38,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 7,
  initComponent : function() {
    var ww = this.containing_window;
    var id2062 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2063 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/AttachmentsByMail/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2064 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/outbox/AttachmentsByMail/owner_id", "method": "GET" }) }) });
    var owner_disp2065 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2064.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
    };
    this.onRender = function(ct, position) {
      owner_type2063.on('change',Lino.chooser_handler(owner_id2064,'owner_type'));
      Lino.outbox.AttachmentsByMail.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2062, "dataIndex": "id" }, { "colIndex": 1, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2063, "dataIndex": "owner_type" }, { "colIndex": 2, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2064 }, { "width": 270, "colIndex": 3, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.outbox.AttachmentsByMail.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.outbox.AttachmentsByMail.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.outbox.AttachmentsByMail.GridPanel(p);
  return rv;
});

Lino.postings.PostingsByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/PostingsByPartner",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "print_action", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print_action') } ],
  title : "Postings",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "owner" }, { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "user" },'userHidden', { "name": "project" },'projectHidden', { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    var ww = this.containing_window;
    var date2071 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var owner_disp2072 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    var state2073 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Open" ], [ "20", "Ready to print" ], [ "30", "Printed" ], [ "40", "Sent" ], [ "50", "Returned" ] ] });
    var workflow_buttons_disp2074 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id2075 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2076 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByPartner/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2077 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user2078 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var project2079 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByPartner/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "dataIndex": "date", "hidden": false, "width": 72, "editor": date2071 }, { "width": 270, "colIndex": 1, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false }, { "colIndex": 2, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 126, "dataIndex": "state", "hidden": false, "editor": state2073 }, { "width": 270, "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2075, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2076, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2077 }, { "colIndex": 7, "sortable": true, "header": "user", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user2078, "dataIndex": "user" }, { "colIndex": 8, "sortable": true, "header": "project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2079, "dataIndex": "project" } ];
    Lino.postings.PostingsByPartner.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsByPartner.print_action = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/postings/PostingsByPartner",pk,"print_action");
};
Lino.postings.PostingsByPartner.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.postings.PostingsByPartner.GridPanel(p);
  return rv;
});

Lino.postings.PostingsByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/postings/PostingsByProject",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "print_action", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print_action') } ],
  title : "Postings",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "date", "dateFormat": "d.m.Y" }, { "name": "partner" },'partnerHidden', { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "user" },'userHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 41,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 15,
  initComponent : function() {
    var ww = this.containing_window;
    var date2090 = new Lino.DateField({ "selectOnFocus": true, "allowBlank": false });
    var partner2091 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByProject/partner", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Partner..." });
    var state2092 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Open" ], [ "20", "Ready to print" ], [ "30", "Printed" ], [ "40", "Sent" ], [ "50", "Returned" ] ] });
    var workflow_buttons_disp2093 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id2094 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2095 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByProject/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2096 = { "selectOnFocus": true, "xtype": "numberfield" };
    var user2097 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/postings/PostingsByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var owner_disp2098 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
    };
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "date", "dataIndex": "date", "hidden": false, "width": 72, "editor": date2090 }, { "colIndex": 1, "sortable": true, "header": "Recipient", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('partnerHidden','Lino.contacts.AllPartners.detail_action'), "hidden": false, "editor": partner2091, "dataIndex": "partner" }, { "colIndex": 2, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 126, "dataIndex": "state", "hidden": false, "editor": state2092 }, { "width": 270, "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2094, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2095, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2096 }, { "colIndex": 7, "sortable": true, "header": "user", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user2097, "dataIndex": "user" }, { "width": 270, "colIndex": 8, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.postings.PostingsByProject.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.postings.PostingsByProject.print_action = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/postings/PostingsByProject",pk,"print_action");
};
Lino.postings.PostingsByProject.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.postings.PostingsByProject.GridPanel(p);
  return rv;
});

Lino.cal.EventsByCalendar.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventsByCalendar",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "user" },'userHidden', { "name": "summary" }, { "name": "state" },'stateHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "build_time" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByCalendar.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByCalendar.insert_action;
    var ww = this.containing_window;
    var start_date35 = new Lino.DateField({ "selectOnFocus": true });
    var start_time36 = new Lino.TimeField({ "selectOnFocus": true });
    var user37 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByCalendar/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var summary38 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state39 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var id40 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type41 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByCalendar/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id42 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByCalendar/owner_id", "method": "GET" }) }) });
    var created43 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified44 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var project45 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByCalendar/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var build_time46 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var end_date47 = new Lino.DateField({ "selectOnFocus": true });
    var end_time48 = new Lino.TimeField({ "selectOnFocus": true });
    var uid49 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description50 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class51 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByCalendar/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence52 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type53 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent54 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type55 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByCalendar/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place56 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByCalendar/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority57 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByCalendar/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var owner_disp58 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id42.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description50.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type41.on('change',Lino.chooser_handler(owner_id42,'owner_type'));
      Lino.cal.EventsByCalendar.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date35 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time36 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user37, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary38 }, { "colIndex": 4, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state39 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id40, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type41, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id42 }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 10, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project45, "dataIndex": "project" }, { "width": 144, "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date47 }, { "colIndex": 13, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time48 }, { "colIndex": 14, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid49 }, { "colIndex": 15, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description50, "dataIndex": "description" }, { "colIndex": 16, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class51 }, { "colIndex": 17, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence52 }, { "colIndex": 18, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 20, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type55, "dataIndex": "type" }, { "colIndex": 21, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place56 }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority57 }, { "width": 270, "colIndex": 23, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.EventsByCalendar.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByCalendar.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByCalendar",pk,"mark_scheduled");
};
Lino.cal.EventsByCalendar.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByCalendar",pk,"clear");
};
Lino.cal.EventsByCalendar.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByCalendar",pk,"mark_notified");
};
Lino.cal.EventsByCalendar.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByCalendar",pk,"mark_confirmed");
};
Lino.cal.EventsByCalendar.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByCalendar",pk,"mark_present");
};
Lino.cal.EventsByCalendar.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByCalendar",pk,"mark_took_place");
};
Lino.cal.EventsByCalendar.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByCalendar",pk,"mark_cancelled");
};

Lino.cal.EventsByCalendar.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsByCalendar",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByCalendar.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByCalendar.insert_action;
    Lino.cal.EventsByCalendar.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByCalendar.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByCalendar.insert_actionPanel(p);
  return rv;
});
Lino.cal.EventsByCalendar.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByCalendar",pk,"print");
};

Lino.cal.EventsByCalendar.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail Events",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsByCalendar",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByCalendar.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByCalendar.insert_action;
    Lino.cal.EventsByCalendar.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByCalendar.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByCalendar.detail_actionPanel(p);
  return rv;
});
Lino.cal.EventsByCalendar.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByCalendar",pk,"post");
};
Lino.cal.EventsByCalendar.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByCalendar.GridPanel(p);
  return rv;
});
Lino.cal.EventsByCalendar.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByCalendar",pk,"mail");
};

Lino.cal.EventsByType.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventsByType",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "user" },'userHidden', { "name": "summary" }, { "name": "state" },'stateHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByType.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByType.insert_action;
    var ww = this.containing_window;
    var start_date708 = new Lino.DateField({ "selectOnFocus": true });
    var start_time709 = new Lino.TimeField({ "selectOnFocus": true });
    var user710 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var summary711 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state712 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var id713 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type714 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id715 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/owner_id", "method": "GET" }) }) });
    var created716 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified717 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var project718 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var build_time719 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar720 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date721 = new Lino.DateField({ "selectOnFocus": true });
    var end_time722 = new Lino.TimeField({ "selectOnFocus": true });
    var uid723 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description724 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class725 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence726 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type727 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent728 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var place729 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority730 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByType/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var owner_disp731 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id715.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description724.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type714.on('change',Lino.chooser_handler(owner_id715,'owner_type'));
      Lino.cal.EventsByType.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date708 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time709 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user710, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary711 }, { "colIndex": 4, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state712 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id713, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type714, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id715 }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 10, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project718, "dataIndex": "project" }, { "width": 144, "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 12, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar720, "dataIndex": "calendar" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date721 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time722 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid723 }, { "colIndex": 16, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description724, "dataIndex": "description" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class725 }, { "colIndex": 18, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence726 }, { "colIndex": 19, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place729 }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority730 }, { "width": 270, "colIndex": 23, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.EventsByType.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByType.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByType",pk,"mark_scheduled");
};
Lino.cal.EventsByType.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByType",pk,"clear");
};
Lino.cal.EventsByType.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByType",pk,"mark_notified");
};
Lino.cal.EventsByType.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByType",pk,"mark_confirmed");
};
Lino.cal.EventsByType.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByType",pk,"mark_present");
};
Lino.cal.EventsByType.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByType",pk,"mark_took_place");
};
Lino.cal.EventsByType.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByType",pk,"mark_cancelled");
};

Lino.cal.EventsByType.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsByType",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByType.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByType.insert_action;
    Lino.cal.EventsByType.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByType.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByType.insert_actionPanel(p);
  return rv;
});
Lino.cal.EventsByType.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByType",pk,"print");
};

Lino.cal.EventsByType.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail Events",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsByType",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByType.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByType.insert_action;
    Lino.cal.EventsByType.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByType.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByType.detail_actionPanel(p);
  return rv;
});
Lino.cal.EventsByType.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByType",pk,"post");
};
Lino.cal.EventsByType.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByType.GridPanel(p);
  return rv;
});
Lino.cal.EventsByType.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByType",pk,"mail");
};

Lino.cal.EventsByPartner.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventsByPartner",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "user" },'userHidden', { "name": "summary" }, { "name": "state" },'stateHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 36,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByPartner.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByPartner.insert_action;
    var ww = this.containing_window;
    var start_date2157 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2158 = new Lino.TimeField({ "selectOnFocus": true });
    var user2159 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPartner/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var summary2160 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state2161 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var id2162 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2163 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPartner/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2164 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPartner/owner_id", "method": "GET" }) }) });
    var created2165 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2166 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var project2167 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPartner/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var build_time2168 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar2169 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPartner/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date2170 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2171 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2172 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2173 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2174 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPartner/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2175 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2176 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent2177 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type2178 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPartner/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place2179 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPartner/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority2180 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPartner/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var owner_disp2181 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2164.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2173.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2163.on('change',Lino.chooser_handler(owner_id2164,'owner_type'));
      Lino.cal.EventsByPartner.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2157 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2158 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user2159, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2160 }, { "colIndex": 4, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state2161 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2162, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2163, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2164 }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 10, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2167, "dataIndex": "project" }, { "width": 144, "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 12, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2169, "dataIndex": "calendar" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date2170 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time2171 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2172 }, { "colIndex": 16, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2173, "dataIndex": "description" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2174 }, { "colIndex": 18, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2175 }, { "colIndex": 19, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type2178, "dataIndex": "type" }, { "colIndex": 22, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place2179 }, { "colIndex": 23, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority2180 }, { "width": 270, "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.EventsByPartner.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByPartner.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPartner",pk,"mark_scheduled");
};
Lino.cal.EventsByPartner.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPartner",pk,"clear");
};
Lino.cal.EventsByPartner.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPartner",pk,"mark_notified");
};
Lino.cal.EventsByPartner.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPartner",pk,"mark_confirmed");
};
Lino.cal.EventsByPartner.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPartner",pk,"mark_present");
};
Lino.cal.EventsByPartner.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPartner",pk,"mark_took_place");
};
Lino.cal.EventsByPartner.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPartner",pk,"mark_cancelled");
};

Lino.cal.EventsByPartner.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsByPartner",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByPartner.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByPartner.insert_action;
    Lino.cal.EventsByPartner.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByPartner.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByPartner.insert_actionPanel(p);
  return rv;
});
Lino.cal.EventsByPartner.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPartner",pk,"print");
};

Lino.cal.EventsByPartner.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail Events",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsByPartner",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByPartner.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByPartner.insert_action;
    Lino.cal.EventsByPartner.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByPartner.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByPartner.detail_actionPanel(p);
  return rv;
});
Lino.cal.EventsByPartner.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPartner",pk,"post");
};
Lino.cal.EventsByPartner.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByPartner.GridPanel(p);
  return rv;
});
Lino.cal.EventsByPartner.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPartner",pk,"mail");
};

Lino.cal.EventsByPlace.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventsByPlace",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "user" },'userHidden', { "name": "summary" }, { "name": "state" },'stateHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "priority" },'priorityHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByPlace.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByPlace.insert_action;
    var ww = this.containing_window;
    var start_date2208 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2209 = new Lino.TimeField({ "selectOnFocus": true });
    var user2210 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPlace/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var summary2211 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state2212 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var id2213 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2214 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPlace/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2215 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPlace/owner_id", "method": "GET" }) }) });
    var created2216 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2217 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var project2218 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPlace/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var build_time2219 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar2220 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPlace/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date2221 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2222 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2223 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2224 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2225 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPlace/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2226 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2227 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent2228 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type2229 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPlace/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var priority2230 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByPlace/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var owner_disp2231 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2215.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2224.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2214.on('change',Lino.chooser_handler(owner_id2215,'owner_type'));
      Lino.cal.EventsByPlace.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2208 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2209 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user2210, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2211 }, { "colIndex": 4, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state2212 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2213, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2214, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2215 }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 10, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2218, "dataIndex": "project" }, { "width": 144, "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 12, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2220, "dataIndex": "calendar" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date2221 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time2222 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2223 }, { "colIndex": 16, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2224, "dataIndex": "description" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2225 }, { "colIndex": 18, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2226 }, { "colIndex": 19, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type2229, "dataIndex": "type" }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority2230 }, { "width": 270, "colIndex": 23, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.EventsByPlace.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByPlace.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPlace",pk,"mark_scheduled");
};
Lino.cal.EventsByPlace.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPlace",pk,"clear");
};
Lino.cal.EventsByPlace.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPlace",pk,"mark_notified");
};
Lino.cal.EventsByPlace.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPlace",pk,"mark_confirmed");
};
Lino.cal.EventsByPlace.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPlace",pk,"mark_present");
};
Lino.cal.EventsByPlace.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPlace",pk,"mark_took_place");
};
Lino.cal.EventsByPlace.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPlace",pk,"mark_cancelled");
};

Lino.cal.EventsByPlace.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsByPlace",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByPlace.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByPlace.insert_action;
    Lino.cal.EventsByPlace.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByPlace.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByPlace.insert_actionPanel(p);
  return rv;
});
Lino.cal.EventsByPlace.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPlace",pk,"print");
};

Lino.cal.EventsByPlace.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail Events",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsByPlace",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByPlace.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByPlace.insert_action;
    Lino.cal.EventsByPlace.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByPlace.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByPlace.detail_actionPanel(p);
  return rv;
});
Lino.cal.EventsByPlace.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPlace",pk,"post");
};
Lino.cal.EventsByPlace.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByPlace.GridPanel(p);
  return rv;
});
Lino.cal.EventsByPlace.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByPlace",pk,"mail");
};

Lino.cal.EventsByProject.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventsByProject",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "user" },'userHidden', { "name": "summary" }, { "name": "state" },'stateHidden', { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 7,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 34,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByProject.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByProject.insert_action;
    var ww = this.containing_window;
    var start_date2257 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2258 = new Lino.TimeField({ "selectOnFocus": true });
    var user2259 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByProject/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var summary2260 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state2261 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var id2262 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2263 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByProject/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2264 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByProject/owner_id", "method": "GET" }) }) });
    var created2265 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2266 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time2267 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar2268 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByProject/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date2269 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2270 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2271 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2272 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2273 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByProject/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2274 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2275 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent2276 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type2277 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByProject/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place2278 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByProject/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority2279 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsByProject/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var owner_disp2280 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2264.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2272.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2263.on('change',Lino.chooser_handler(owner_id2264,'owner_type'));
      Lino.cal.EventsByProject.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2257 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2258 }, { "colIndex": 2, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user2259, "dataIndex": "user" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2260 }, { "colIndex": 4, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state2261 }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2262, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2263, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2264 }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "width": 144, "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 11, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2268, "dataIndex": "calendar" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date2269 }, { "colIndex": 13, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time2270 }, { "colIndex": 14, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2271 }, { "colIndex": 15, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2272, "dataIndex": "description" }, { "colIndex": 16, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2273 }, { "colIndex": 17, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2274 }, { "colIndex": 18, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 20, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type2277, "dataIndex": "type" }, { "colIndex": 21, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place2278 }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority2279 }, { "width": 270, "colIndex": 23, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.EventsByProject.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByProject.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByProject",pk,"mark_scheduled");
};
Lino.cal.EventsByProject.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByProject",pk,"clear");
};
Lino.cal.EventsByProject.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByProject",pk,"mark_notified");
};
Lino.cal.EventsByProject.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByProject",pk,"mark_confirmed");
};
Lino.cal.EventsByProject.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByProject",pk,"mark_present");
};
Lino.cal.EventsByProject.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByProject",pk,"mark_took_place");
};
Lino.cal.EventsByProject.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByProject",pk,"mark_cancelled");
};

Lino.cal.EventsByProject.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New Events",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsByProject",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByProject.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByProject.insert_action;
    Lino.cal.EventsByProject.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByProject.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByProject.insert_actionPanel(p);
  return rv;
});
Lino.cal.EventsByProject.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByProject",pk,"print");
};

Lino.cal.EventsByProject.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail Events",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsByProject",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsByProject.detail_action;
    this.ls_insert_handler = Lino.cal.EventsByProject.insert_action;
    Lino.cal.EventsByProject.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsByProject.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByProject.detail_actionPanel(p);
  return rv;
});
Lino.cal.EventsByProject.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByProject",pk,"post");
};
Lino.cal.EventsByProject.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsByProject.GridPanel(p);
  return rv;
});
Lino.cal.EventsByProject.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsByProject",pk,"mail");
};

Lino.cal.MyEvents.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyEvents",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "My Events",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" },'projectHidden', { "name": "summary" }, { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 35,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail_action;
    this.ls_insert_handler = Lino.cal.MyEvents.insert_action;
    var ww = this.containing_window;
    var start_date2306 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2307 = new Lino.TimeField({ "selectOnFocus": true });
    var project2308 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var summary2309 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state2310 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var workflow_buttons_disp2311 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id2312 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2313 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2314 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/owner_id", "method": "GET" }) }) });
    var created2315 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2316 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time2317 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar2318 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date2319 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2320 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2321 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2322 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2323 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2324 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2325 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent2326 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type2327 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place2328 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority2329 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEvents/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var owner_disp2330 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2314.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2322.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2313.on('change',Lino.chooser_handler(owner_id2314,'owner_type'));
      Lino.cal.MyEvents.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2306 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2307 }, { "colIndex": 2, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2308, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2309 }, { "colIndex": 4, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state2310 }, { "width": 270, "colIndex": 5, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2312, "dataIndex": "id" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2313, "dataIndex": "owner_type" }, { "colIndex": 8, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2314 }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "width": 144, "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 12, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2318, "dataIndex": "calendar" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date2319 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time2320 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2321 }, { "colIndex": 16, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2322, "dataIndex": "description" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2323 }, { "colIndex": 18, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2324 }, { "colIndex": 19, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type2327, "dataIndex": "type" }, { "colIndex": 22, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place2328 }, { "colIndex": 23, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority2329 }, { "width": 270, "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.MyEvents.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEvents",pk,"mark_scheduled");
};
Lino.cal.MyEvents.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEvents",pk,"clear");
};
Lino.cal.MyEvents.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEvents",pk,"mark_notified");
};
Lino.cal.MyEvents.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEvents",pk,"mark_confirmed");
};
Lino.cal.MyEvents.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEvents",pk,"mark_present");
};
Lino.cal.MyEvents.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEvents",pk,"mark_took_place");
};
Lino.cal.MyEvents.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEvents",pk,"mark_cancelled");
};

Lino.cal.MyEvents.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New My Events",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/MyEvents",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail_action;
    this.ls_insert_handler = Lino.cal.MyEvents.insert_action;
    Lino.cal.MyEvents.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.MyEvents.insert_actionPanel(p);
  return rv;
});
Lino.cal.MyEvents.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEvents",pk,"print");
};

Lino.cal.MyEvents.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail My Events",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/MyEvents",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEvents.detail_action;
    this.ls_insert_handler = Lino.cal.MyEvents.insert_action;
    Lino.cal.MyEvents.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEvents.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.MyEvents.detail_actionPanel(p);
  return rv;
});
Lino.cal.MyEvents.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEvents",pk,"post");
};
Lino.cal.MyEvents.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.MyEvents.GridPanel(p);
  return rv;
});
Lino.cal.MyEvents.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEvents",pk,"mail");
};

Lino.cal.MyEventsToSchedule.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyEventsToSchedule",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "My events to schedule",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" },'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "state" },'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 35,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToSchedule.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToSchedule.insert_action;
    var ww = this.containing_window;
    var start_date2357 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2358 = new Lino.TimeField({ "selectOnFocus": true });
    var project2359 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToSchedule/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var summary2360 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2361 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id2362 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2363 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToSchedule/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2364 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToSchedule/owner_id", "method": "GET" }) }) });
    var created2365 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2366 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time2367 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar2368 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToSchedule/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date2369 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2370 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2371 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2372 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2373 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToSchedule/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2374 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2375 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent2376 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type2377 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToSchedule/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place2378 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToSchedule/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority2379 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToSchedule/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state2380 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var owner_disp2381 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2364.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2372.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2363.on('change',Lino.chooser_handler(owner_id2364,'owner_type'));
      Lino.cal.MyEventsToSchedule.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2357 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2358 }, { "colIndex": 2, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2359, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2360 }, { "width": 270, "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2362, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2363, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2364 }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "width": 144, "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 11, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2368, "dataIndex": "calendar" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date2369 }, { "colIndex": 13, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time2370 }, { "colIndex": 14, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2371 }, { "colIndex": 15, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2372, "dataIndex": "description" }, { "colIndex": 16, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2373 }, { "colIndex": 17, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2374 }, { "colIndex": 18, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 20, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type2377, "dataIndex": "type" }, { "colIndex": 21, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place2378 }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority2379 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state2380 }, { "width": 270, "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.MyEventsToSchedule.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToSchedule.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToSchedule",pk,"mark_scheduled");
};
Lino.cal.MyEventsToSchedule.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToSchedule",pk,"clear");
};
Lino.cal.MyEventsToSchedule.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToSchedule",pk,"mark_notified");
};
Lino.cal.MyEventsToSchedule.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToSchedule",pk,"mark_confirmed");
};
Lino.cal.MyEventsToSchedule.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToSchedule",pk,"mark_present");
};
Lino.cal.MyEventsToSchedule.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToSchedule",pk,"mark_took_place");
};
Lino.cal.MyEventsToSchedule.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToSchedule",pk,"mark_cancelled");
};

Lino.cal.MyEventsToSchedule.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New My events to schedule",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/MyEventsToSchedule",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToSchedule.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToSchedule.insert_action;
    Lino.cal.MyEventsToSchedule.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToSchedule.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.MyEventsToSchedule.insert_actionPanel(p);
  return rv;
});
Lino.cal.MyEventsToSchedule.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToSchedule",pk,"print");
};

Lino.cal.MyEventsToSchedule.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail My events to schedule",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/MyEventsToSchedule",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToSchedule.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToSchedule.insert_action;
    Lino.cal.MyEventsToSchedule.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToSchedule.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.MyEventsToSchedule.detail_actionPanel(p);
  return rv;
});
Lino.cal.MyEventsToSchedule.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToSchedule",pk,"post");
};
Lino.cal.MyEventsToSchedule.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.MyEventsToSchedule.GridPanel(p);
  return rv;
});
Lino.cal.MyEventsToSchedule.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToSchedule",pk,"mail");
};

Lino.cal.MyEventsToNotify.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyEventsToNotify",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "My events to notify",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" },'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "state" },'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 35,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToNotify.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToNotify.insert_action;
    var ww = this.containing_window;
    var start_date2408 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2409 = new Lino.TimeField({ "selectOnFocus": true });
    var project2410 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToNotify/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var summary2411 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2412 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id2413 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2414 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToNotify/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2415 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToNotify/owner_id", "method": "GET" }) }) });
    var created2416 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2417 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time2418 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar2419 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToNotify/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date2420 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2421 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2422 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2423 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2424 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToNotify/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2425 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2426 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent2427 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type2428 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToNotify/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place2429 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToNotify/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority2430 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToNotify/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state2431 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var owner_disp2432 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2415.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2423.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2414.on('change',Lino.chooser_handler(owner_id2415,'owner_type'));
      Lino.cal.MyEventsToNotify.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2408 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2409 }, { "colIndex": 2, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2410, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2411 }, { "width": 270, "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2413, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2414, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2415 }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "width": 144, "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 11, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2419, "dataIndex": "calendar" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date2420 }, { "colIndex": 13, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time2421 }, { "colIndex": 14, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2422 }, { "colIndex": 15, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2423, "dataIndex": "description" }, { "colIndex": 16, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2424 }, { "colIndex": 17, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2425 }, { "colIndex": 18, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 20, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type2428, "dataIndex": "type" }, { "colIndex": 21, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place2429 }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority2430 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state2431 }, { "width": 270, "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.MyEventsToNotify.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToNotify.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToNotify",pk,"mark_scheduled");
};
Lino.cal.MyEventsToNotify.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToNotify",pk,"clear");
};
Lino.cal.MyEventsToNotify.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToNotify",pk,"mark_notified");
};
Lino.cal.MyEventsToNotify.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToNotify",pk,"mark_confirmed");
};
Lino.cal.MyEventsToNotify.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToNotify",pk,"mark_present");
};
Lino.cal.MyEventsToNotify.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToNotify",pk,"mark_took_place");
};
Lino.cal.MyEventsToNotify.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToNotify",pk,"mark_cancelled");
};

Lino.cal.MyEventsToNotify.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New My events to notify",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/MyEventsToNotify",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToNotify.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToNotify.insert_action;
    Lino.cal.MyEventsToNotify.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToNotify.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.MyEventsToNotify.insert_actionPanel(p);
  return rv;
});
Lino.cal.MyEventsToNotify.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToNotify",pk,"print");
};

Lino.cal.MyEventsToNotify.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail My events to notify",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/MyEventsToNotify",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToNotify.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToNotify.insert_action;
    Lino.cal.MyEventsToNotify.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToNotify.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.MyEventsToNotify.detail_actionPanel(p);
  return rv;
});
Lino.cal.MyEventsToNotify.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToNotify",pk,"post");
};
Lino.cal.MyEventsToNotify.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.MyEventsToNotify.GridPanel(p);
  return rv;
});
Lino.cal.MyEventsToNotify.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToNotify",pk,"mail");
};

Lino.cal.EventsToConfirm.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/EventsToConfirm",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "Events to confirm",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" },'projectHidden', { "name": "user" },'userHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "state" },'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 8,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 37,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsToConfirm.detail_action;
    this.ls_insert_handler = Lino.cal.EventsToConfirm.insert_action;
    var ww = this.containing_window;
    var start_date2459 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2460 = new Lino.TimeField({ "selectOnFocus": true });
    var project2461 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToConfirm/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var user2462 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToConfirm/user", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a User..." });
    var summary2463 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2464 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id2465 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2466 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToConfirm/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2467 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToConfirm/owner_id", "method": "GET" }) }) });
    var created2468 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2469 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time2470 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar2471 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToConfirm/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date2472 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2473 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2474 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2475 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2476 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToConfirm/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2477 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2478 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent2479 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type2480 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToConfirm/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place2481 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToConfirm/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority2482 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/EventsToConfirm/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state2483 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var owner_disp2484 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2467.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2475.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2466.on('change',Lino.chooser_handler(owner_id2467,'owner_type'));
      Lino.cal.EventsToConfirm.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2459 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2460 }, { "colIndex": 2, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2461, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "User", "editable": true, "filter": { "type": "string" }, "width": 135, "renderer": Lino.fk_renderer('userHidden','Lino.users.Users.detail_action'), "hidden": false, "editor": user2462, "dataIndex": "user" }, { "colIndex": 4, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2463 }, { "width": 270, "colIndex": 5, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 6, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2465, "dataIndex": "id" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2466, "dataIndex": "owner_type" }, { "colIndex": 8, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2467 }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 10, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "width": 144, "colIndex": 11, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 12, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2471, "dataIndex": "calendar" }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date2472 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time2473 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2474 }, { "colIndex": 16, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2475, "dataIndex": "description" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2476 }, { "colIndex": 18, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2477 }, { "colIndex": 19, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type2480, "dataIndex": "type" }, { "colIndex": 22, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place2481 }, { "colIndex": 23, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority2482 }, { "colIndex": 24, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state2483 }, { "width": 270, "colIndex": 25, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.EventsToConfirm.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsToConfirm.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToConfirm",pk,"mark_scheduled");
};
Lino.cal.EventsToConfirm.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToConfirm",pk,"clear");
};
Lino.cal.EventsToConfirm.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToConfirm",pk,"mark_notified");
};
Lino.cal.EventsToConfirm.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToConfirm",pk,"mark_confirmed");
};
Lino.cal.EventsToConfirm.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToConfirm",pk,"mark_present");
};
Lino.cal.EventsToConfirm.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToConfirm",pk,"mark_took_place");
};
Lino.cal.EventsToConfirm.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToConfirm",pk,"mark_cancelled");
};

Lino.cal.EventsToConfirm.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New Events to confirm",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsToConfirm",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsToConfirm.detail_action;
    this.ls_insert_handler = Lino.cal.EventsToConfirm.insert_action;
    Lino.cal.EventsToConfirm.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsToConfirm.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.EventsToConfirm.insert_actionPanel(p);
  return rv;
});
Lino.cal.EventsToConfirm.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToConfirm",pk,"print");
};

Lino.cal.EventsToConfirm.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail Events to confirm",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/EventsToConfirm",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.EventsToConfirm.detail_action;
    this.ls_insert_handler = Lino.cal.EventsToConfirm.insert_action;
    Lino.cal.EventsToConfirm.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.EventsToConfirm.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsToConfirm.detail_actionPanel(p);
  return rv;
});
Lino.cal.EventsToConfirm.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToConfirm",pk,"post");
};
Lino.cal.EventsToConfirm.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.EventsToConfirm.GridPanel(p);
  return rv;
});
Lino.cal.EventsToConfirm.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/EventsToConfirm",pk,"mail");
};

Lino.cal.MyEventsToConfirm.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyEventsToConfirm",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "My events to confirm",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "start_time" }, { "name": "project" },'projectHidden', { "name": "summary" }, { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "state" },'stateHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 6,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 35,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToConfirm.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToConfirm.insert_action;
    var ww = this.containing_window;
    var start_date2512 = new Lino.DateField({ "selectOnFocus": true });
    var start_time2513 = new Lino.TimeField({ "selectOnFocus": true });
    var project2514 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToConfirm/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var summary2515 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var workflow_buttons_disp2516 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id2517 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2518 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToConfirm/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2519 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToConfirm/owner_id", "method": "GET" }) }) });
    var created2520 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2521 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var build_time2522 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar2523 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToConfirm/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var end_date2524 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2525 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2526 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2527 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2528 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToConfirm/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2529 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2530 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent2531 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type2532 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToConfirm/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place2533 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToConfirm/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority2534 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToConfirm/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var state2535 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var owner_disp2536 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2519.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2527.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2518.on('change',Lino.chooser_handler(owner_id2519,'owner_type'));
      Lino.cal.MyEventsToConfirm.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2512 }, { "colIndex": 1, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2513 }, { "colIndex": 2, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2514, "dataIndex": "project" }, { "colIndex": 3, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2515 }, { "width": 270, "colIndex": 4, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 5, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2517, "dataIndex": "id" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2518, "dataIndex": "owner_type" }, { "colIndex": 7, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2519 }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 9, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "width": 144, "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 11, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2523, "dataIndex": "calendar" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date2524 }, { "colIndex": 13, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time2525 }, { "colIndex": 14, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2526 }, { "colIndex": 15, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2527, "dataIndex": "description" }, { "colIndex": 16, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2528 }, { "colIndex": 17, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2529 }, { "colIndex": 18, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 19, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 20, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type2532, "dataIndex": "type" }, { "colIndex": 21, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place2533 }, { "colIndex": 22, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority2534 }, { "colIndex": 23, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state2535 }, { "width": 270, "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.MyEventsToConfirm.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToConfirm.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToConfirm",pk,"mark_scheduled");
};
Lino.cal.MyEventsToConfirm.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToConfirm",pk,"clear");
};
Lino.cal.MyEventsToConfirm.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToConfirm",pk,"mark_notified");
};
Lino.cal.MyEventsToConfirm.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToConfirm",pk,"mark_confirmed");
};
Lino.cal.MyEventsToConfirm.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToConfirm",pk,"mark_present");
};
Lino.cal.MyEventsToConfirm.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToConfirm",pk,"mark_took_place");
};
Lino.cal.MyEventsToConfirm.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToConfirm",pk,"mark_cancelled");
};

Lino.cal.MyEventsToConfirm.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New My events to confirm",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/MyEventsToConfirm",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToConfirm.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToConfirm.insert_action;
    Lino.cal.MyEventsToConfirm.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToConfirm.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.MyEventsToConfirm.insert_actionPanel(p);
  return rv;
});
Lino.cal.MyEventsToConfirm.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToConfirm",pk,"print");
};

Lino.cal.MyEventsToConfirm.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail My events to confirm",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/MyEventsToConfirm",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToConfirm.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToConfirm.insert_action;
    Lino.cal.MyEventsToConfirm.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToConfirm.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.MyEventsToConfirm.detail_actionPanel(p);
  return rv;
});
Lino.cal.MyEventsToConfirm.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToConfirm",pk,"post");
};
Lino.cal.MyEventsToConfirm.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.MyEventsToConfirm.GridPanel(p);
  return rv;
});
Lino.cal.MyEventsToConfirm.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToConfirm",pk,"mail");
};

Lino.cal.MyEventsToday.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyEventsToday",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  title : "My events today",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "name": "start_time" }, { "name": "summary" }, { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "build_time" }, { "name": "calendar" },'calendarHidden', { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "type": "date", "name": "end_date", "dateFormat": "d.m.Y" }, { "name": "end_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "boolean", "name": "transparent" }, { "name": "type" },'typeHidden', { "name": "place" },'placeHidden', { "name": "priority" },'priorityHidden', { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 31,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 35,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert_action;
    var ww = this.containing_window;
    var start_time2563 = new Lino.TimeField({ "selectOnFocus": true });
    var summary2564 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state2565 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "Draft" ], [ "20", "Scheduled" ], [ "30", "Notified" ], [ "40", "Confirmed" ], [ "50", "Took place" ], [ "70", "Cancelled" ], [ "80", "Absent" ], [ "90", "Obsolete" ] ] });
    var workflow_buttons_disp2566 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id2567 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2568 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2569 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/owner_id", "method": "GET" }) }) });
    var created2570 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2571 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var project2572 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var build_time2573 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var calendar2574 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var start_date2575 = new Lino.DateField({ "selectOnFocus": true });
    var end_date2576 = new Lino.DateField({ "selectOnFocus": true });
    var end_time2577 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2578 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2579 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2580 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2581 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2582 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var transparent2583 = new Ext.form.Checkbox({ "selectOnFocus": true, "checked": false });
    var type2584 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Event Type..." });
    var place2585 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/place", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Place..." });
    var priority2586 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyEventsToday/priority", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Priority..." });
    var owner_disp2587 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2569.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2579.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2568.on('change',Lino.chooser_handler(owner_id2569,'owner_type'));
      Lino.cal.MyEventsToday.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2563 }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2564 }, { "colIndex": 2, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "state", "hidden": false, "editor": state2565 }, { "width": 270, "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2567, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2568, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2569 }, { "width": 144, "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2572, "dataIndex": "project" }, { "width": 144, "colIndex": 10, "sortable": true, "dataIndex": "build_time", "header": "build time", "hidden": false, "editable": false }, { "colIndex": 11, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2574, "dataIndex": "calendar" }, { "colIndex": 12, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2575 }, { "colIndex": 13, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "End Date", "dataIndex": "end_date", "hidden": false, "width": 72, "editor": end_date2576 }, { "colIndex": 14, "sortable": true, "header": "End Time", "editable": true, "width": 72, "dataIndex": "end_time", "hidden": false, "editor": end_time2577 }, { "colIndex": 15, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2578 }, { "colIndex": 16, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2579, "dataIndex": "description" }, { "colIndex": 17, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2580 }, { "colIndex": 18, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2581 }, { "colIndex": 19, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 20, "sortable": false, "xtype": "checkcolumn", "header": "Transparent", "editable": true, "filter": { "type": "boolean" }, "width": 90, "dataIndex": "transparent", "hidden": false }, { "colIndex": 21, "sortable": true, "header": "Event Type", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('typeHidden','Lino.cal.EventTypes.detail_action'), "hidden": false, "editor": type2584, "dataIndex": "type" }, { "colIndex": 22, "sortable": true, "header": "Place", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "place", "hidden": false, "editor": place2585 }, { "colIndex": 23, "sortable": true, "header": "Priority", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "priority", "hidden": false, "editor": priority2586 }, { "width": 270, "colIndex": 24, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.MyEventsToday.GridPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.mark_scheduled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToday",pk,"mark_scheduled");
};
Lino.cal.MyEventsToday.do_clear_cache = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToday",pk,"clear");
};
Lino.cal.MyEventsToday.mark_notified = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToday",pk,"mark_notified");
};
Lino.cal.MyEventsToday.mark_confirmed = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToday",pk,"mark_confirmed");
};
Lino.cal.MyEventsToday.mark_present = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToday",pk,"mark_present");
};
Lino.cal.MyEventsToday.mark_took_place = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToday",pk,"mark_took_place");
};
Lino.cal.MyEventsToday.mark_cancelled = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToday",pk,"mark_cancelled");
};

Lino.cal.MyEventsToday.insert_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "New My events today",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/MyEventsToday",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert_action;
    Lino.cal.MyEventsToday.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var date2589 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "100%", "name": "date" });
  var main_panel2590 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "labelWidth": 45, "items": [ { "items": date2589, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "hideCheckBoxLabels": true, "layout": "fit", "frame": false, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel2590;
  p.params_panel.fields = [ date2589 ];
  var rv = new Lino.cal.MyEventsToday.insert_actionPanel(p);
  return rv;
});
Lino.cal.MyEventsToday.do_print = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToday",pk,"print");
};
Lino.cal.MyEventsToday.create_postings = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToday",pk,"post");
};

Lino.cal.MyEventsToday.detail_actionPanel = Ext.extend(Lino.cal.Events.FormPanel,{
  empty_title: "Detail My events today",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "mark_scheduled", "text": "Scheduled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_scheduled') }, { "itemId": "do_clear_cache", "text": "Clear cache", "must_save": true, "panel_btn_handler": Lino.row_action_handler('clear') }, { "itemId": "mark_notified", "text": "Notified", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_notified') }, { "itemId": "mark_confirmed", "text": "Confirmed", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_confirmed') }, { "itemId": "mark_present", "text": "Absent", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_present') }, { "itemId": "mark_took_place", "text": "Took place", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_took_place') }, { "itemId": "mark_cancelled", "text": "Cancelled", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_cancelled') }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "do_print", "text": "Print", "must_save": true, "panel_btn_handler": Lino.row_action_handler('print') }, { "itemId": "duplicate_row", "text": "Duplicate", "must_save": true, "panel_btn_handler": Lino.row_action_handler('duplicate_row') }, { "itemId": "create_postings", "text": "Create posting", "must_save": true, "panel_btn_handler": Lino.row_action_handler('post') }, { "itemId": "create_mail", "text": "Create email", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mail') } ],
  ls_url: "/cal/MyEventsToday",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyEventsToday.detail_action;
    this.ls_insert_handler = Lino.cal.MyEventsToday.insert_action;
    Lino.cal.MyEventsToday.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyEventsToday.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var date2589 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "100%", "name": "date" });
  var main_panel2590 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "labelWidth": 45, "items": [ { "items": date2589, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "hideCheckBoxLabels": true, "layout": "fit", "frame": false, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel2590;
  p.params_panel.fields = [ date2589 ];
  var rv = new Lino.cal.MyEventsToday.detail_actionPanel(p);
  return rv;
});
Lino.cal.MyEventsToday.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var date2589 = new Lino.DateField({ "selectOnFocus": true, "fieldLabel": "Date", "anchor": "100%", "name": "date" });
  var main_panel2590 = new Ext.form.FormPanel({layout:'fit', autoHeight: true, frame: true, items:new Ext.Panel({ "labelWidth": 45, "items": [ { "items": date2589, "autoHeight": true, "layout": "form", "xtype": "panel", "labelAlign": "top" } ], "hideCheckBoxLabels": true, "layout": "fit", "frame": false, "border": false, "labelAlign": "top" })});
  p.params_panel = main_panel2590;
  p.params_panel.fields = [ date2589 ];
  var rv = new Lino.cal.MyEventsToday.GridPanel(p);
  return rv;
});
Lino.cal.MyEventsToday.create_mail = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyEventsToday",pk,"mail");
};

Lino.cal.MyTasks.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyTasks",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "mark_done", "text": "Done", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_done') } ],
  title : "My Tasks",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "calendar" },'calendarHidden', { "name": "start_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 28,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail_action;
    this.ls_insert_handler = Lino.cal.MyTasks.insert_action;
    var ww = this.containing_window;
    var start_date2617 = new Lino.DateField({ "selectOnFocus": true });
    var summary2618 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state2619 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "40", "Cancelled" ] ] });
    var workflow_buttons_disp2620 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id2621 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2622 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasks/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2623 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasks/owner_id", "method": "GET" }) }) });
    var created2624 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2625 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var project2626 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasks/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var calendar2627 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasks/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var start_time2628 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2629 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2630 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2631 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasks/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2632 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2633 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var due_date2634 = new Lino.DateField({ "selectOnFocus": true });
    var due_time2635 = new Lino.TimeField({ "selectOnFocus": true });
    var percent2636 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_disp2637 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2623.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2630.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2622.on('change',Lino.chooser_handler(owner_id2623,'owner_type'));
      Lino.cal.MyTasks.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2617 }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2618 }, { "colIndex": 2, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 81, "dataIndex": "state", "hidden": false, "editor": state2619 }, { "width": 270, "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2621, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2622, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2623 }, { "width": 144, "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2626, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2627, "dataIndex": "calendar" }, { "colIndex": 11, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2628 }, { "colIndex": 12, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2629 }, { "colIndex": 13, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2630, "dataIndex": "description" }, { "colIndex": 14, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2631 }, { "colIndex": 15, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2632 }, { "colIndex": 16, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 17, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due date", "dataIndex": "due_date", "hidden": false, "width": 72, "editor": due_date2634 }, { "colIndex": 18, "sortable": true, "header": "Due time", "editable": true, "width": 72, "dataIndex": "due_time", "hidden": false, "editor": due_time2635 }, { "colIndex": 19, "sortable": true, "header": "Duration value", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "percent", "hidden": false, "editor": percent2636 }, { "width": 270, "colIndex": 20, "sortable": false, "dataIndex": "owner", "header": "Controlled by", "hidden": false, "editable": false } ];
    Lino.cal.MyTasks.GridPanel.superclass.initComponent.call(this);
  }
});


Lino.cal.MyTasks.insert_actionPanel = Ext.extend(Lino.cal.Tasks.FormPanel,{
  empty_title: "New My Tasks",
  hide_navigator: true,
  ls_bbar_actions: [ { "itemId": "create_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} } ],
  ls_url: "/cal/MyTasks",
  action_name: "insert",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail_action;
    this.ls_insert_handler = Lino.cal.MyTasks.insert_action;
    Lino.cal.MyTasks.insert_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.insert_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.hide_top_toolbar = true;
  p.is_main_window = true;
  var rv = new Lino.cal.MyTasks.insert_actionPanel(p);
  return rv;
});

Lino.cal.MyTasks.detail_actionPanel = Ext.extend(Lino.cal.Tasks.FormPanel,{
  empty_title: "Detail My Tasks",
  ls_bbar_actions: [ { "itemId": "update_action", "text": "Save", "panel_btn_handler": function(panel){panel.save()} }, { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "mark_done", "text": "Done", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_done') } ],
  ls_url: "/cal/MyTasks",
  action_name: "detail",
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasks.detail_action;
    this.ls_insert_handler = Lino.cal.MyTasks.insert_action;
    Lino.cal.MyTasks.detail_actionPanel.superclass.initComponent.call(this);
  }
});

Lino.cal.MyTasks.detail_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.MyTasks.detail_actionPanel(p);
  return rv;
});
Lino.cal.MyTasks.default_action = new Lino.WindowAction({  },function(){
  var p = {};
  p.is_main_window = true;
  var rv = new Lino.cal.MyTasks.GridPanel(p);
  return rv;
});
Lino.cal.MyTasks.mark_done = function(rp,pk,action) { 
  Lino.run_row_action(rp,action,"/cal/MyTasks",pk,"mark_done");
};

Lino.cal.MyTasksToDo.GridPanel = Ext.extend(Lino.GridPanel,{
  viewConfig : { "getRowClass": Lino.getRowClass, "emptyText": "No data to display." },
  ls_url : "/cal/MyTasksToDo",
  ls_bbar_actions : [ { "itemId": "delete_action", "text": "Delete", "panel_btn_handler": Lino.delete_selected }, { "itemId": "insert_action", "text": "New", "must_save": true, "panel_btn_handler": function(panel){Lino.show_insert(panel)} }, { "itemId": "detail_action", "text": "Detail", "panel_btn_handler": Lino.show_detail }, { "itemId": "mark_done", "text": "Done", "must_save": true, "panel_btn_handler": Lino.row_action_handler('mark_done') } ],
  title : "To-do list",
  page_length : 20,
  stripeRows : true,
  ls_quick_edit : true,
  ls_store_fields : [ { "type": "date", "name": "start_date", "dateFormat": "d.m.Y" }, { "name": "summary" }, { "name": "state" },'stateHidden', { "name": "workflow_buttons" }, { "type": "int", "name": "id" }, { "name": "owner_type" },'owner_typeHidden', { "name": "owner_id" },'owner_idHidden', { "name": "created" }, { "name": "modified" }, { "name": "project" },'projectHidden', { "name": "calendar" },'calendarHidden', { "name": "start_time" }, { "name": "uid" }, { "name": "description" }, { "name": "access_class" },'access_classHidden', { "type": "int", "name": "sequence" }, { "type": "int", "name": "auto_type" }, { "type": "date", "name": "due_date", "dateFormat": "d.m.Y" }, { "name": "due_time" }, { "type": "int", "name": "percent" }, { "name": "owner" }, { "name": "disabled_fields" }, { "name": "disabled_actions" }, { "name": "disable_editing" } ],
  pk_index : 5,
  ls_grid_configs : [  ],
  content_type : 37,
  ls_id_property : "id",
  gc_name : 0,
  disabled_actions_index : 28,
  initComponent : function() {
    this.ls_detail_handler = Lino.cal.MyTasksToDo.detail_action;
    this.ls_insert_handler = Lino.cal.MyTasksToDo.insert_action;
    var ww = this.containing_window;
    var start_date2660 = new Lino.DateField({ "selectOnFocus": true });
    var summary2661 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var state2662 = new Lino.ChoicesFieldElement({ "selectOnFocus": true, "forceSelection": true, "store": [ [ "10", "To do" ], [ "20", "Started" ], [ "30", "Done" ], [ "40", "Cancelled" ] ] });
    var workflow_buttons_disp2663 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br/>", "always_enabled": true });
    var id2664 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_type2665 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasksToDo/owner_type", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a content type..." });
    var owner_id2666 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasksToDo/owner_id", "method": "GET" }) }) });
    var created2667 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var modified2668 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true, "value": "<br>" });
    var project2669 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasksToDo/project", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Project..." });
    var calendar2670 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasksToDo/calendar", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Calendar..." });
    var start_time2671 = new Lino.TimeField({ "selectOnFocus": true });
    var uid2672 = new Ext.form.TextField({ "selectOnFocus": true, "maxLength": 200 });
    var description2673 = new Lino.RichTextPanel({ "selectOnFocus": true, "title": "Description", "containing_panel": this });
    var access_class2674 = new Lino.RemoteComboFieldElement({ "selectOnFocus": true, "store": new Lino.ComplexRemoteComboStore({ "proxy": new Ext.data.HttpProxy({ "url": "/choices/cal/MyTasksToDo/access_class", "method": "GET" }) }), "pageSize": 20, "emptyText": "Select a Access Class..." });
    var sequence2675 = { "selectOnFocus": true, "xtype": "numberfield", "value": 0, "allowBlank": false };
    var auto_type2676 = { "disabled": true, "readOnly": true, "xtype": "numberfield" };
    var due_date2677 = new Lino.DateField({ "selectOnFocus": true });
    var due_time2678 = new Lino.TimeField({ "selectOnFocus": true });
    var percent2679 = { "selectOnFocus": true, "xtype": "numberfield" };
    var owner_disp2680 = new Ext.form.DisplayField({ "disabled": true, "readOnly": true });
    this.before_row_edit = function(record) {
      owner_id2666.setContextValue('owner_type',record ? record.data['owner_typeHidden'] : undefined);
      description2673.refresh();
    };
    this.onRender = function(ct, position) {
      owner_type2665.on('change',Lino.chooser_handler(owner_id2666,'owner_type'));
      Lino.cal.MyTasksToDo.GridPanel.superclass.onRender.call(this, ct, position);
    }
    this.ls_columns = [ { "colIndex": 0, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Start date", "dataIndex": "start_date", "hidden": false, "width": 72, "editor": start_date2660 }, { "colIndex": 1, "sortable": true, "header": "Summary", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "summary", "hidden": false, "editor": summary2661 }, { "colIndex": 2, "sortable": true, "header": "State", "editable": true, "filter": { "type": "string" }, "width": 81, "dataIndex": "state", "hidden": false, "editor": state2662 }, { "width": 270, "colIndex": 3, "sortable": false, "dataIndex": "workflow_buttons", "header": "Workflows", "hidden": false, "editable": false }, { "colIndex": 4, "sortable": true, "header": "ID", "editable": true, "filter": { "type": "numeric" }, "width": 45, "renderer": Lino.id_renderer, "hidden": false, "editor": id2664, "dataIndex": "id" }, { "colIndex": 5, "sortable": true, "header": "Controlled by (type)", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('owner_typeHidden','Lino.lino.ContentTypes.detail_action'), "hidden": false, "editor": owner_type2665, "dataIndex": "owner_type" }, { "colIndex": 6, "sortable": true, "header": "Controlled by (object)", "editable": true, "filter": { "type": "string" }, "width": 90, "dataIndex": "owner_id", "hidden": false, "editor": owner_id2666 }, { "width": 144, "colIndex": 7, "sortable": true, "dataIndex": "created", "header": "created", "hidden": false, "editable": false }, { "width": 144, "colIndex": 8, "sortable": true, "dataIndex": "modified", "header": "modified", "hidden": false, "editable": false }, { "colIndex": 9, "sortable": true, "header": "Project", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('projectHidden','Lino.tickets.Projects.detail_action'), "hidden": false, "editor": project2669, "dataIndex": "project" }, { "colIndex": 10, "sortable": true, "header": "Calendar", "editable": true, "filter": { "type": "string" }, "width": 180, "renderer": Lino.fk_renderer('calendarHidden','Lino.cal.PanelCalendars.detail_action'), "hidden": false, "editor": calendar2670, "dataIndex": "calendar" }, { "colIndex": 11, "sortable": true, "header": "Start time", "editable": true, "width": 72, "dataIndex": "start_time", "hidden": false, "editor": start_time2671 }, { "colIndex": 12, "sortable": true, "header": "UID", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "uid", "hidden": false, "editor": uid2672 }, { "colIndex": 13, "sortable": false, "header": "description", "editable": true, "filter": { "type": "string" }, "width": 540, "renderer": Lino.text_renderer, "hidden": false, "editor": description2673, "dataIndex": "description" }, { "colIndex": 14, "sortable": true, "header": "Access Class", "editable": true, "filter": { "type": "string" }, "width": 180, "dataIndex": "access_class", "hidden": false, "editor": access_class2674 }, { "colIndex": 15, "sortable": true, "header": "Revision", "editable": true, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "sequence", "hidden": false, "editor": sequence2675 }, { "colIndex": 16, "sortable": true, "header": "auto type", "editable": false, "filter": { "type": "numeric" }, "width": 45, "dataIndex": "auto_type", "hidden": false }, { "colIndex": 17, "sortable": true, "xtype": "datecolumn", "format": "d.m.Y", "editable": true, "filter": { "type": "date", "dateFormat": "d.m.Y" }, "header": "Due 