/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.shared.protocol;

import be.fedict.eid.applet.shared.annotation.ProtocolStateAllowed;
import be.fedict.eid.applet.shared.annotation.StartRequestMessage;
import be.fedict.eid.applet.shared.annotation.StateTransition;
import be.fedict.eid.applet.shared.annotation.StopResponseMessage;
import be.fedict.eid.applet.shared.protocol.ProtocolContext;
import be.fedict.eid.applet.shared.protocol.ProtocolState;
import be.fedict.eid.applet.shared.protocol.ProtocolStateListener;
import java.util.LinkedList;
import java.util.List;

public class ProtocolStateMachine {
    private final ProtocolContext protocolContext;
    private final List<ProtocolStateListener> protocolStateListeners;

    public ProtocolStateMachine(ProtocolContext protocolContext) {
        this.protocolContext = protocolContext;
        this.protocolStateListeners = new LinkedList<ProtocolStateListener>();
    }

    public void addProtocolStateListener(ProtocolStateListener protocolStateListener) {
        this.protocolStateListeners.add(protocolStateListener);
    }

    public void checkResponseMessage(Object responseMessage) {
        StateTransition stateTransitionAnnotation;
        ProtocolState protocolState = this.protocolContext.getProtocolState();
        if (null == protocolState) {
            throw new RuntimeException("responding without a protocol state");
        }
        Class<?> responseMessageClass = responseMessage.getClass();
        StopResponseMessage stopResponseMessageAnnotation = responseMessageClass.getAnnotation(StopResponseMessage.class);
        if (null != stopResponseMessageAnnotation) {
            this.notifyProtocolListenersStopProtocolRun();
            this.protocolContext.removeProtocolState();
        }
        if (null != (stateTransitionAnnotation = responseMessageClass.getAnnotation(StateTransition.class))) {
            ProtocolState newProtocolState = stateTransitionAnnotation.value();
            this.protocolContext.setProtocolState(newProtocolState);
            this.notifyProtocolListenersProtocolStateTransition(newProtocolState);
        }
    }

    private void notifyProtocolListenersProtocolStateTransition(ProtocolState newProtocolState) {
        for (ProtocolStateListener protocolStateListener : this.protocolStateListeners) {
            protocolStateListener.protocolStateTransition(newProtocolState);
        }
    }

    private void notifyProtocolListenersStartProtocolRun() {
        for (ProtocolStateListener protocolStateListener : this.protocolStateListeners) {
            protocolStateListener.startProtocolRun();
        }
    }

    private void notifyProtocolListenersStopProtocolRun() {
        for (ProtocolStateListener protocolStateListener : this.protocolStateListeners) {
            protocolStateListener.stopProtocolRun();
        }
    }

    public void checkRequestMessage(Object requestMessage) {
        ProtocolState protocolState = this.protocolContext.getProtocolState();
        Class<?> requestMessageClass = requestMessage.getClass();
        StartRequestMessage startRequestMessageAnnotation = requestMessageClass.getAnnotation(StartRequestMessage.class);
        if (null == startRequestMessageAnnotation) {
            if (null == protocolState) {
                throw new RuntimeException("expected a protocol start message");
            }
            ProtocolStateAllowed protocolStateAllowedAnnotation = requestMessageClass.getAnnotation(ProtocolStateAllowed.class);
            if (null == protocolStateAllowedAnnotation) {
                throw new RuntimeException("cannot check protocol state for message: " + requestMessageClass.getSimpleName());
            }
            ProtocolState allowedProtocolState = protocolStateAllowedAnnotation.value();
            if (protocolState != allowedProtocolState) {
                throw new RuntimeException("protocol state incorrect. expected: " + (Object)((Object)allowedProtocolState) + "; actual: " + (Object)((Object)protocolState));
            }
        } else {
            if (null != protocolState) {
                // empty if block
            }
            ProtocolState initialState = startRequestMessageAnnotation.value();
            this.protocolContext.setProtocolState(initialState);
            this.notifyProtocolListenersStartProtocolRun();
            this.notifyProtocolListenersProtocolStateTransition(initialState);
        }
    }
}

