'''OpenGL extension EXT.shader_image_load_store

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.shader_image_load_store to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides GLSL built-in functions allowing shaders to load
	from, store to, and perform atomic read-modify-write operations to a
	single level of a texture object from any shader stage.  These built-in
	functions are named imageLoad(), imageStore(), and imageAtomic*(),
	respectively, and accept integer texel coordinates to identify the texel
	accessed.  The extension adds the notion of "image units" to the OpenGL
	API, to which texture levels are bound for access by the GLSL built-in
	functions.  To allow shaders to specify the image unit to access, GLSL
	provides a new set of data types ("image*") similar to samplers.  Each
	image variable is assigned an integer value to identify an image unit to
	access, which is specified using Uniform*() APIs in a manner similar to
	samplers.  For implementations supporting the NV_gpu_program5 extensions,
	assembly language instructions to perform image loads, stores, and atomics
	are also provided.
	
	This extension also provides the capability to explicitly enable "early"
	per-fragment tests, where operations like depth and stencil testing are
	performed prior to fragment shader execution.  In unextended OpenGL,
	fragment shaders never have any side effects and implementations can
	sometimes perform per-fragment tests and discard some fragments prior to
	executing the fragment shader.  Since this extension allows fragment
	shaders to write to texture and buffer object memory using the built-in
	image functions, such optimizations could lead to non-deterministic
	results.  To avoid this, implementations supporting this extension may not
	perform such optimizations.  However, enabling early per-fragment tests
	guarantees that such tests will be performed prior to fragment shader
	execution, and ensures that image stores and atomics will not be performed
	by fragment shader invocations where these per-fragment tests fail.
	
	Finally, this extension provides both a GLSL built-in function and an
	OpenGL API function allowing applications some control over the ordering
	of image loads, stores, and atomics relative to other OpenGL pipeline
	operations accessing the same memory.  Because the extension provides the
	ability to perform random accesses to texture or buffer object memory,
	such accesses are not easily tracked by the OpenGL driver.  To avoid the
	need for heavy-handed synchronization at the driver level, this extension
	requires manual synchronization.  The MemoryBarrierEXT() OpenGL API
	function allows applications to specify a bitfield indicating the set of
	OpenGL API operations to synchronize relative to shader memory access.
	The memoryBarrier() GLSL built-in function provides a synchronization
	point within a given shader invocation to ensure that all memory accesses
	performed prior to the synchronization point complete prior to any started
	after the synchronization point.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/shader_image_load_store.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.EXT.shader_image_load_store import *
### END AUTOGENERATED SECTION