# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft and contributors.  All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .resource_model import ResourceModel


class GenericResource(ResourceModel):
    """Resource information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource Id
    :vartype id: str
    :ivar name: Resource name
    :vartype name: str
    :ivar type: Resource type
    :vartype type: str
    :ivar created_time: Created time of the resource.
    :vartype created_time: datetime
    :ivar changed_time: Changed time of the resource.
    :vartype changed_time: datetime
    :param location: Resource location
    :type location: str
    :param tags: Resource tags
    :type tags: dict
    :param plan: Gets or sets the plan of the resource.
    :type plan: :class:`Plan <azure.mgmt.resource.resources.models.Plan>`
    :param properties: Gets or sets the resource properties.
    :type properties: object
    :param kind: Gets or sets the kind of the resource.
    :type kind: str
    :param managed_by: Gets or sets the managedBy property of the resource.
    :type managed_by: str
    :param sku: Gets or sets the sku of the resource.
    :type sku: :class:`Sku <azure.mgmt.resource.resources.models.Sku>`
    :param identity: Gets or sets the identity of the resource.
    :type identity: :class:`Identity
     <azure.mgmt.resource.resources.models.Identity>`
    """ 

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_time': {'readonly': True},
        'changed_time': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'properties': {'key': 'properties', 'type': 'object'},
        'kind': {'key': 'kind', 'type': 'str'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'Identity'},
    }

    def __init__(self, location, tags=None, plan=None, properties=None, kind=None, managed_by=None, sku=None, identity=None):
        super(GenericResource, self).__init__(location=location, tags=tags)
        self.plan = plan
        self.properties = properties
        self.kind = kind
        self.managed_by = managed_by
        self.sku = sku
        self.identity = identity
