# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AllocationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Allocation state of the compute. Possible values are: steady - Indicates that the compute is
    not resizing. There are no changes to the number of compute nodes in the compute in progress. A
    compute enters this state when it is created and when no operations are being performed on the
    compute to change the number of compute nodes. resizing - Indicates that the compute is
    resizing; that is, compute nodes are being added to or removed from the compute.
    """

    STEADY = "Steady"
    RESIZING = "Resizing"

class ApplicationSharingPolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Policy for sharing applications on this compute instance among users of parent workspace. If
    Personal, only the creator can access applications on this compute instance. When Shared, any
    workspace user can access applications on this instance depending on his/her assigned role.
    """

    PERSONAL = "Personal"
    SHARED = "Shared"

class AssetProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of registry asset.
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"

class AutoDeleteCondition(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    CREATED_GREATER_THAN = "CreatedGreaterThan"
    LAST_ACCESSED_GREATER_THAN = "LastAccessedGreaterThan"

class AutoRebuildSetting(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AutoRebuild setting for the derived image
    """

    DISABLED = "Disabled"
    ON_BASE_IMAGE_UPDATE = "OnBaseImageUpdate"

class Autosave(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Auto save settings.
    """

    NONE = "None"
    LOCAL = "Local"
    REMOTE = "Remote"

class BaseEnvironmentSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Base environment type.
    """

    ENVIRONMENT_ASSET = "EnvironmentAsset"

class BatchDeploymentConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The enumerated property types for batch deployments.
    """

    MODEL = "Model"
    PIPELINE_COMPONENT = "PipelineComponent"

class BatchLoggingLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Log verbosity for batch inferencing.
    Increasing verbosity order for logging is : Warning, Info and Debug.
    The default value is Info.
    """

    INFO = "Info"
    WARNING = "Warning"
    DEBUG = "Debug"

class BatchOutputAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine how batch inferencing will handle output
    """

    SUMMARY_ONLY = "SummaryOnly"
    APPEND_ROW = "AppendRow"

class BillingCurrency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Three lettered code specifying the currency of the VM price. Example: USD
    """

    USD = "USD"

class BlockedTransformers(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for all classification models supported by AutoML.
    """

    #: Target encoding for text data.
    TEXT_TARGET_ENCODER = "TextTargetEncoder"
    #: Ohe hot encoding creates a binary feature transformation.
    ONE_HOT_ENCODER = "OneHotEncoder"
    #: Target encoding for categorical data.
    CAT_TARGET_ENCODER = "CatTargetEncoder"
    #: Tf-Idf stands for, term-frequency times inverse document-frequency. This is a common term
    #: weighting scheme for identifying information from documents.
    TF_IDF = "TfIdf"
    #: Weight of Evidence encoding is a technique used to encode categorical variables. It uses the
    #: natural log of the P(1)/P(0) to create weights.
    WO_E_TARGET_ENCODER = "WoETargetEncoder"
    #: Label encoder converts labels/categorical variables in a numerical form.
    LABEL_ENCODER = "LabelEncoder"
    #: Word embedding helps represents words or phrases as a vector, or a series of numbers.
    WORD_EMBEDDING = "WordEmbedding"
    #: Naive Bayes is a classified that is used for classification of discrete features that are
    #: categorically distributed.
    NAIVE_BAYES = "NaiveBayes"
    #: Count Vectorizer converts a collection of text documents to a matrix of token counts.
    COUNT_VECTORIZER = "CountVectorizer"
    #: Hashing One Hot Encoder can turn categorical variables into a limited number of new features.
    #: This is often used for high-cardinality categorical features.
    HASH_ONE_HOT_ENCODER = "HashOneHotEncoder"

class Caching(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Caching type of Data Disk.
    """

    NONE = "None"
    READ_ONLY = "ReadOnly"
    READ_WRITE = "ReadWrite"

class CategoricalDataDriftMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: The Jensen Shannon Distance (JSD) metric.
    JENSEN_SHANNON_DISTANCE = "JensenShannonDistance"
    #: The Population Stability Index (PSI) metric.
    POPULATION_STABILITY_INDEX = "PopulationStabilityIndex"
    #: The Pearsons Chi Squared Test metric.
    PEARSONS_CHI_SQUARED_TEST = "PearsonsChiSquaredTest"

class CategoricalDataQualityMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Calculates the rate of null values.
    NULL_VALUE_RATE = "NullValueRate"
    #: Calculates the rate of data type errors.
    DATA_TYPE_ERROR_RATE = "DataTypeErrorRate"
    #: Calculates the rate values are out of bounds.
    OUT_OF_BOUNDS_RATE = "OutOfBoundsRate"

class CategoricalPredictionDriftMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: The Jensen Shannon Distance (JSD) metric.
    JENSEN_SHANNON_DISTANCE = "JensenShannonDistance"
    #: The Population Stability Index (PSI) metric.
    POPULATION_STABILITY_INDEX = "PopulationStabilityIndex"
    #: The Pearsons Chi Squared Test metric.
    PEARSONS_CHI_SQUARED_TEST = "PearsonsChiSquaredTest"

class ClassificationModelPerformanceMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Calculates the accuracy of the model predictions.
    ACCURACY = "Accuracy"
    #: Calculates the precision of the model predictions.
    PRECISION = "Precision"
    #: Calculates the recall of the model predictions.
    RECALL = "Recall"
    #: Calculates the F1 score of the model predictions.
    F1_SCORE = "F1Score"

class ClassificationModels(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for all classification models supported by AutoML.
    """

    #: Logistic regression is a fundamental classification technique.
    #: It belongs to the group of linear classifiers and is somewhat similar to polynomial and linear
    #: regression.
    #: Logistic regression is fast and relatively uncomplicated, and it's convenient for you to
    #: interpret the results.
    #: Although it's essentially a method for binary classification, it can also be applied to
    #: multiclass problems.
    LOGISTIC_REGRESSION = "LogisticRegression"
    #: SGD: Stochastic gradient descent is an optimization algorithm often used in machine learning
    #: applications
    #: to find the model parameters that correspond to the best fit between predicted and actual
    #: outputs.
    SGD = "SGD"
    #: The multinomial Naive Bayes classifier is suitable for classification with discrete features
    #: (e.g., word counts for text classification).
    #: The multinomial distribution normally requires integer feature counts. However, in practice,
    #: fractional counts such as tf-idf may also work.
    MULTINOMIAL_NAIVE_BAYES = "MultinomialNaiveBayes"
    #: Naive Bayes classifier for multivariate Bernoulli models.
    BERNOULLI_NAIVE_BAYES = "BernoulliNaiveBayes"
    #: A support vector machine (SVM) is a supervised machine learning model that uses classification
    #: algorithms for two-group classification problems.
    #: After giving an SVM model sets of labeled training data for each category, they're able to
    #: categorize new text.
    SVM = "SVM"
    #: A support vector machine (SVM) is a supervised machine learning model that uses classification
    #: algorithms for two-group classification problems.
    #: After giving an SVM model sets of labeled training data for each category, they're able to
    #: categorize new text.
    #: Linear SVM performs best when input data is linear, i.e., data can be easily classified by
    #: drawing the straight line between classified values on a plotted graph.
    LINEAR_SVM = "LinearSVM"
    #: K-nearest neighbors (KNN) algorithm uses 'feature similarity' to predict the values of new
    #: datapoints
    #: which further means that the new data point will be assigned a value based on how closely it
    #: matches the points in the training set.
    KNN = "KNN"
    #: Decision Trees are a non-parametric supervised learning method used for both classification and
    #: regression tasks.
    #: The goal is to create a model that predicts the value of a target variable by learning simple
    #: decision rules inferred from the data features.
    DECISION_TREE = "DecisionTree"
    #: Random forest is a supervised learning algorithm.
    #: The "forest" it builds, is an ensemble of decision trees, usually trained with the bagging
    #: method.
    #: The general idea of the bagging method is that a combination of learning models increases the
    #: overall result.
    RANDOM_FOREST = "RandomForest"
    #: Extreme Trees is an ensemble machine learning algorithm that combines the predictions from many
    #: decision trees. It is related to the widely used random forest algorithm.
    EXTREME_RANDOM_TREES = "ExtremeRandomTrees"
    #: LightGBM is a gradient boosting framework that uses tree based learning algorithms.
    LIGHT_GBM = "LightGBM"
    #: The technique of transiting week learners into a strong learner is called Boosting. The
    #: gradient boosting algorithm process works on this theory of execution.
    GRADIENT_BOOSTING = "GradientBoosting"
    #: XGBoost: Extreme Gradient Boosting Algorithm. This algorithm is used for structured data where
    #: target column values can be divided into distinct class values.
    XG_BOOST_CLASSIFIER = "XGBoostClassifier"

class ClassificationMultilabelPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for classification multilabel tasks.
    """

    #: AUC is the Area under the curve.
    #: This metric represents arithmetic mean of the score for each class,
    #: weighted by the number of true instances in each class.
    AUC_WEIGHTED = "AUCWeighted"
    #: Accuracy is the ratio of predictions that exactly match the true class labels.
    ACCURACY = "Accuracy"
    #: Normalized macro recall is recall macro-averaged and normalized, so that random
    #: performance has a score of 0, and perfect performance has a score of 1.
    NORM_MACRO_RECALL = "NormMacroRecall"
    #: The arithmetic mean of the average precision score for each class, weighted by
    #: the number of true instances in each class.
    AVERAGE_PRECISION_SCORE_WEIGHTED = "AveragePrecisionScoreWeighted"
    #: The arithmetic mean of precision for each class, weighted by number of true instances in each
    #: class.
    PRECISION_SCORE_WEIGHTED = "PrecisionScoreWeighted"
    #: Intersection Over Union. Intersection of predictions divided by union of predictions.
    IOU = "IOU"

class ClassificationPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for classification tasks.
    """

    #: AUC is the Area under the curve.
    #: This metric represents arithmetic mean of the score for each class,
    #: weighted by the number of true instances in each class.
    AUC_WEIGHTED = "AUCWeighted"
    #: Accuracy is the ratio of predictions that exactly match the true class labels.
    ACCURACY = "Accuracy"
    #: Normalized macro recall is recall macro-averaged and normalized, so that random
    #: performance has a score of 0, and perfect performance has a score of 1.
    NORM_MACRO_RECALL = "NormMacroRecall"
    #: The arithmetic mean of the average precision score for each class, weighted by
    #: the number of true instances in each class.
    AVERAGE_PRECISION_SCORE_WEIGHTED = "AveragePrecisionScoreWeighted"
    #: The arithmetic mean of precision for each class, weighted by number of true instances in each
    #: class.
    PRECISION_SCORE_WEIGHTED = "PrecisionScoreWeighted"

class ClusterPurpose(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Intended usage of the cluster
    """

    FAST_PROD = "FastProd"
    DENSE_PROD = "DenseProd"
    DEV_TEST = "DevTest"

class ComputeInstanceAuthorizationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Compute Instance Authorization type. Available values are personal (default).
    """

    PERSONAL = "personal"

class ComputeInstanceState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Current state of an ComputeInstance.
    """

    CREATING = "Creating"
    CREATE_FAILED = "CreateFailed"
    DELETING = "Deleting"
    RUNNING = "Running"
    RESTARTING = "Restarting"
    JOB_RUNNING = "JobRunning"
    SETTING_UP = "SettingUp"
    SETUP_FAILED = "SetupFailed"
    STARTING = "Starting"
    STOPPED = "Stopped"
    STOPPING = "Stopping"
    USER_SETTING_UP = "UserSettingUp"
    USER_SETUP_FAILED = "UserSetupFailed"
    UNKNOWN = "Unknown"
    UNUSABLE = "Unusable"

class ComputePowerAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """[Required] The compute power action.
    """

    START = "Start"
    STOP = "Stop"

class ComputeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of compute
    """

    AKS = "AKS"
    KUBERNETES = "Kubernetes"
    AML_COMPUTE = "AmlCompute"
    COMPUTE_INSTANCE = "ComputeInstance"
    DATA_FACTORY = "DataFactory"
    VIRTUAL_MACHINE = "VirtualMachine"
    HD_INSIGHT = "HDInsight"
    DATABRICKS = "Databricks"
    DATA_LAKE_ANALYTICS = "DataLakeAnalytics"
    SYNAPSE_SPARK = "SynapseSpark"

class ConnectionAuthType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Authentication type of the connection target
    """

    PAT = "PAT"
    MANAGED_IDENTITY = "ManagedIdentity"
    USERNAME_PASSWORD = "UsernamePassword"
    NONE = "None"
    SAS = "SAS"
    SERVICE_PRINCIPAL = "ServicePrincipal"
    ACCESS_KEY = "AccessKey"

class ConnectionCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Category of the connection
    """

    PYTHON_FEED = "PythonFeed"
    CONTAINER_REGISTRY = "ContainerRegistry"
    GIT = "Git"
    FEATURE_STORE = "FeatureStore"
    S3 = "S3"
    SNOWFLAKE = "Snowflake"
    AZURE_SQL_DB = "AzureSqlDb"
    AZURE_SYNAPSE_ANALYTICS = "AzureSynapseAnalytics"
    AZURE_MY_SQL_DB = "AzureMySqlDb"
    AZURE_POSTGRES_DB = "AzurePostgresDb"
    AZURE_DATA_LAKE_GEN2 = "AzureDataLakeGen2"
    REDIS = "Redis"

class ContainerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of container to retrieve logs from.
    """

    #: The container used to download models and score script.
    STORAGE_INITIALIZER = "StorageInitializer"
    #: The container used to serve user's request.
    INFERENCE_SERVER = "InferenceServer"
    #: The container used to collect payload and custom logging when mdc is enabled.
    MODEL_DATA_COLLECTOR = "ModelDataCollector"

class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class CredentialsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the datastore credentials type.
    """

    ACCOUNT_KEY = "AccountKey"
    CERTIFICATE = "Certificate"
    NONE = "None"
    SAS = "Sas"
    SERVICE_PRINCIPAL = "ServicePrincipal"
    KERBEROS_KEYTAB = "KerberosKeytab"
    KERBEROS_PASSWORD = "KerberosPassword"

class DataCollectionMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class DataImportSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the type of data.
    """

    DATABASE = "database"
    FILE_SYSTEM = "file_system"

class DatastoreType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the datastore contents type.
    """

    AZURE_BLOB = "AzureBlob"
    AZURE_DATA_LAKE_GEN1 = "AzureDataLakeGen1"
    AZURE_DATA_LAKE_GEN2 = "AzureDataLakeGen2"
    AZURE_FILE = "AzureFile"
    HDFS = "Hdfs"
    ONE_LAKE = "OneLake"

class DataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the type of data.
    """

    URI_FILE = "uri_file"
    URI_FOLDER = "uri_folder"
    MLTABLE = "mltable"

class DeploymentProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible values for DeploymentProvisioningState.
    """

    CREATING = "Creating"
    DELETING = "Deleting"
    SCALING = "Scaling"
    UPDATING = "Updating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class DiagnoseResultLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Level of workspace setup error
    """

    WARNING = "Warning"
    ERROR = "Error"
    INFORMATION = "Information"

class DistributionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the job distribution type.
    """

    PY_TORCH = "PyTorch"
    TENSOR_FLOW = "TensorFlow"
    MPI = "Mpi"
    RAY = "Ray"

class EarlyTerminationPolicyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    BANDIT = "Bandit"
    MEDIAN_STOPPING = "MedianStopping"
    TRUNCATION_SELECTION = "TruncationSelection"

class EgressPublicNetworkAccessType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine whether PublicNetworkAccess is Enabled or Disabled for egress of a
    deployment.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class EmailNotificationEnableType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the email notification type.
    """

    JOB_COMPLETED = "JobCompleted"
    JOB_FAILED = "JobFailed"
    JOB_CANCELLED = "JobCancelled"

class EncryptionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether or not the encryption is enabled for the workspace.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class EndpointAuthMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine endpoint authentication mode.
    """

    AML_TOKEN = "AMLToken"
    KEY = "Key"
    AAD_TOKEN = "AADToken"

class EndpointComputeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine endpoint compute type.
    """

    MANAGED = "Managed"
    KUBERNETES = "Kubernetes"
    AZURE_ML_COMPUTE = "AzureMLCompute"

class EndpointProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of endpoint provisioning.
    """

    CREATING = "Creating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    UPDATING = "Updating"
    CANCELED = "Canceled"

class EndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Connection status of the service consumer with the service provider
    """

    APPROVED = "Approved"
    PENDING = "Pending"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class EnvironmentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Environment type is either user created or curated by Azure ML service
    """

    CURATED = "Curated"
    USER_CREATED = "UserCreated"

class EnvironmentVariableType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the Environment Variable. Possible values are: local - For local variable
    """

    LOCAL = "local"

class ExportFormatType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The format of exported labels.
    """

    DATASET = "Dataset"
    COCO = "Coco"
    CSV = "CSV"

class FeatureAttributionMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: The Normalized Discounted Cumulative Gain metric.
    NORMALIZED_DISCOUNTED_CUMULATIVE_GAIN = "NormalizedDiscountedCumulativeGain"

class FeatureDataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    STRING = "String"
    INTEGER = "Integer"
    LONG = "Long"
    FLOAT = "Float"
    DOUBLE = "Double"
    BINARY = "Binary"
    DATETIME = "Datetime"
    BOOLEAN = "Boolean"

class FeatureLags(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Flag for generating lags for the numeric features.
    """

    #: No feature lags generated.
    NONE = "None"
    #: System auto-generates feature lags.
    AUTO = "Auto"

class FeaturestoreJobType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    RECURRENT_MATERIALIZATION = "RecurrentMaterialization"
    BACKFILL_MATERIALIZATION = "BackfillMaterialization"

class FeaturizationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Featurization mode - determines data featurization mode.
    """

    #: Auto mode, system performs featurization without any custom featurization inputs.
    AUTO = "Auto"
    #: Custom featurization.
    CUSTOM = "Custom"
    #: Featurization off. 'Forecasting' task cannot use this value.
    OFF = "Off"

class ForecastHorizonMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine forecast horizon selection mode.
    """

    #: Forecast horizon to be determined automatically.
    AUTO = "Auto"
    #: Use the custom forecast horizon.
    CUSTOM = "Custom"

class ForecastingModels(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for all forecasting models supported by AutoML.
    """

    #: Auto-Autoregressive Integrated Moving Average (ARIMA) model uses time-series data and
    #: statistical analysis to interpret the data and make future predictions.
    #: This model aims to explain data by using time series data on its past values and uses linear
    #: regression to make predictions.
    AUTO_ARIMA = "AutoArima"
    #: Prophet is a procedure for forecasting time series data based on an additive model where
    #: non-linear trends are fit with yearly, weekly, and daily seasonality, plus holiday effects.
    #: It works best with time series that have strong seasonal effects and several seasons of
    #: historical data. Prophet is robust to missing data and shifts in the trend, and typically
    #: handles outliers well.
    PROPHET = "Prophet"
    #: The Naive forecasting model makes predictions by carrying forward the latest target value for
    #: each time-series in the training data.
    NAIVE = "Naive"
    #: The Seasonal Naive forecasting model makes predictions by carrying forward the latest season of
    #: target values for each time-series in the training data.
    SEASONAL_NAIVE = "SeasonalNaive"
    #: The Average forecasting model makes predictions by carrying forward the average of the target
    #: values for each time-series in the training data.
    AVERAGE = "Average"
    #: The Seasonal Average forecasting model makes predictions by carrying forward the average value
    #: of the latest season of data for each time-series in the training data.
    SEASONAL_AVERAGE = "SeasonalAverage"
    #: Exponential smoothing is a time series forecasting method for univariate data that can be
    #: extended to support data with a systematic trend or seasonal component.
    EXPONENTIAL_SMOOTHING = "ExponentialSmoothing"
    #: An Autoregressive Integrated Moving Average with Explanatory Variable (ARIMAX) model can be
    #: viewed as a multiple regression model with one or more autoregressive (AR) terms and/or one or
    #: more moving average (MA) terms.
    #: This method is suitable for forecasting when data is stationary/non stationary, and
    #: multivariate with any type of data pattern, i.e., level/trend /seasonality/cyclicity.
    ARIMAX = "Arimax"
    #: TCNForecaster: Temporal Convolutional Networks Forecaster. //TODO: Ask forecasting team for
    #: brief intro.
    TCN_FORECASTER = "TCNForecaster"
    #: Elastic net is a popular type of regularized linear regression that combines two popular
    #: penalties, specifically the L1 and L2 penalty functions.
    ELASTIC_NET = "ElasticNet"
    #: The technique of transiting week learners into a strong learner is called Boosting. The
    #: gradient boosting algorithm process works on this theory of execution.
    GRADIENT_BOOSTING = "GradientBoosting"
    #: Decision Trees are a non-parametric supervised learning method used for both classification and
    #: regression tasks.
    #: The goal is to create a model that predicts the value of a target variable by learning simple
    #: decision rules inferred from the data features.
    DECISION_TREE = "DecisionTree"
    #: K-nearest neighbors (KNN) algorithm uses 'feature similarity' to predict the values of new
    #: datapoints
    #: which further means that the new data point will be assigned a value based on how closely it
    #: matches the points in the training set.
    KNN = "KNN"
    #: Lasso model fit with Least Angle Regression a.k.a. Lars. It is a Linear Model trained with an
    #: L1 prior as regularizer.
    LASSO_LARS = "LassoLars"
    #: SGD: Stochastic gradient descent is an optimization algorithm often used in machine learning
    #: applications
    #: to find the model parameters that correspond to the best fit between predicted and actual
    #: outputs.
    #: It's an inexact but powerful technique.
    SGD = "SGD"
    #: Random forest is a supervised learning algorithm.
    #: The "forest" it builds, is an ensemble of decision trees, usually trained with the bagging
    #: method.
    #: The general idea of the bagging method is that a combination of learning models increases the
    #: overall result.
    RANDOM_FOREST = "RandomForest"
    #: Extreme Trees is an ensemble machine learning algorithm that combines the predictions from many
    #: decision trees. It is related to the widely used random forest algorithm.
    EXTREME_RANDOM_TREES = "ExtremeRandomTrees"
    #: LightGBM is a gradient boosting framework that uses tree based learning algorithms.
    LIGHT_GBM = "LightGBM"
    #: XGBoostRegressor: Extreme Gradient Boosting Regressor is a supervised machine learning model
    #: using ensemble of base learners.
    XG_BOOST_REGRESSOR = "XGBoostRegressor"

class ForecastingPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for Forecasting task.
    """

    #: The Spearman's rank coefficient of correlation is a non-parametric measure of rank correlation.
    SPEARMAN_CORRELATION = "SpearmanCorrelation"
    #: The Normalized Root Mean Squared Error (NRMSE) the RMSE facilitates the comparison between
    #: models with different scales.
    NORMALIZED_ROOT_MEAN_SQUARED_ERROR = "NormalizedRootMeanSquaredError"
    #: The R2 score is one of the performance evaluation measures for forecasting-based machine
    #: learning models.
    R2_SCORE = "R2Score"
    #: The Normalized Mean Absolute Error (NMAE) is a validation metric to compare the Mean Absolute
    #: Error (MAE) of (time) series with different scales.
    NORMALIZED_MEAN_ABSOLUTE_ERROR = "NormalizedMeanAbsoluteError"

class Goal(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines supported metric goals for hyperparameter tuning
    """

    MINIMIZE = "Minimize"
    MAXIMIZE = "Maximize"

class IdentityConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine identity framework.
    """

    MANAGED = "Managed"
    AML_TOKEN = "AMLToken"
    USER_IDENTITY = "UserIdentity"

class ImageAnnotationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Annotation type of image data.
    """

    CLASSIFICATION = "Classification"
    BOUNDING_BOX = "BoundingBox"
    INSTANCE_SEGMENTATION = "InstanceSegmentation"

class ImageType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the image. Possible values are: docker - For docker images. azureml - For AzureML
    images
    """

    DOCKER = "docker"
    AZUREML = "azureml"

class IncrementalDataRefresh(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether IncrementalDataRefresh is enabled
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class InferencingServerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Inferencing server type for various targets.
    """

    AZURE_ML_ONLINE = "AzureMLOnline"
    AZURE_ML_BATCH = "AzureMLBatch"
    TRITON = "Triton"
    CUSTOM = "Custom"

class InputDeliveryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the input data delivery mode.
    """

    READ_ONLY_MOUNT = "ReadOnlyMount"
    READ_WRITE_MOUNT = "ReadWriteMount"
    DOWNLOAD = "Download"
    DIRECT = "Direct"
    EVAL_MOUNT = "EvalMount"
    EVAL_DOWNLOAD = "EvalDownload"

class InputPathType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Input path type for package inputs.
    """

    URL = "Url"
    PATH_ID = "PathId"
    PATH_VERSION = "PathVersion"

class InstanceSegmentationPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for InstanceSegmentation tasks.
    """

    #: Mean Average Precision (MAP) is the average of AP (Average Precision).
    #: AP is calculated for each class and averaged to get the MAP.
    MEAN_AVERAGE_PRECISION = "MeanAveragePrecision"

class IsolationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Isolation mode for the managed network of a machine learning workspace.
    """

    DISABLED = "Disabled"
    ALLOW_INTERNET_OUTBOUND = "AllowInternetOutbound"
    ALLOW_ONLY_APPROVED_OUTBOUND = "AllowOnlyApprovedOutbound"

class JobInputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the Job Input Type.
    """

    LITERAL = "literal"
    URI_FILE = "uri_file"
    URI_FOLDER = "uri_folder"
    MLTABLE = "mltable"
    CUSTOM_MODEL = "custom_model"
    MLFLOW_MODEL = "mlflow_model"
    TRITON_MODEL = "triton_model"

class JobLimitsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    COMMAND = "Command"
    SWEEP = "Sweep"

class JobOutputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the Job Output Type.
    """

    URI_FILE = "uri_file"
    URI_FOLDER = "uri_folder"
    MLTABLE = "mltable"
    CUSTOM_MODEL = "custom_model"
    MLFLOW_MODEL = "mlflow_model"
    TRITON_MODEL = "triton_model"

class JobProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the job provisioning state.
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    IN_PROGRESS = "InProgress"

class JobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of a job.
    """

    #: Run hasn't started yet.
    NOT_STARTED = "NotStarted"
    #: Run has started. The user has a run ID.
    STARTING = "Starting"
    #: (Not used currently) It will be used if ES is creating the compute target.
    PROVISIONING = "Provisioning"
    #: The run environment is being prepared.
    PREPARING = "Preparing"
    #: The job is queued in the compute target. For example, in BatchAI the job is in queued state,
    #: while waiting for all required nodes to be ready.
    QUEUED = "Queued"
    #: The job started to run in the compute target.
    RUNNING = "Running"
    #: Job is completed in the target. It is in output collection state now.
    FINALIZING = "Finalizing"
    #: Cancellation has been requested for the job.
    CANCEL_REQUESTED = "CancelRequested"
    #: Job completed successfully. This reflects that both the job itself and output collection states
    #: completed successfully.
    COMPLETED = "Completed"
    #: Job failed.
    FAILED = "Failed"
    #: Following cancellation request, the job is now successfully canceled.
    CANCELED = "Canceled"
    #: When heartbeat is enabled, if the run isn't updating any information to RunHistory then the run
    #: goes to NotResponding state.
    #: NotResponding is the only state that is exempt from strict transition orders. A run can go from
    #: NotResponding to any of the previous states.
    NOT_RESPONDING = "NotResponding"
    #: The job is paused by users. Some adjustment to labeling jobs can be made only in paused state.
    PAUSED = "Paused"
    #: Default job status if not mapped to all other statuses.
    UNKNOWN = "Unknown"
    #: The job is in a scheduled state. Job is not in any active state.
    SCHEDULED = "Scheduled"

class JobTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the job tier.
    """

    SPOT = "Spot"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"

class JobType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the type of job.
    """

    AUTO_ML = "AutoML"
    COMMAND = "Command"
    LABELING = "Labeling"
    SWEEP = "Sweep"
    PIPELINE = "Pipeline"
    SPARK = "Spark"

class KeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    PRIMARY = "Primary"
    SECONDARY = "Secondary"

class LearningRateScheduler(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Learning rate scheduler enum.
    """

    #: No learning rate scheduler selected.
    NONE = "None"
    #: Cosine Annealing With Warmup.
    WARMUP_COSINE = "WarmupCosine"
    #: Step learning rate scheduler.
    STEP = "Step"

class ListViewType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    ACTIVE_ONLY = "ActiveOnly"
    ARCHIVED_ONLY = "ArchivedOnly"
    ALL = "All"

class LoadBalancerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Load Balancer Type
    """

    PUBLIC_IP = "PublicIp"
    INTERNAL_LOAD_BALANCER = "InternalLoadBalancer"

class LogTrainingMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Enable compute and log training metrics.
    ENABLE = "Enable"
    #: Disable compute and log training metrics.
    DISABLE = "Disable"

class LogValidationLoss(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Enable compute and log validation metrics.
    ENABLE = "Enable"
    #: Disable compute and log validation metrics.
    DISABLE = "Disable"

class LogVerbosity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for setting log verbosity.
    """

    #: No logs emitted.
    NOT_SET = "NotSet"
    #: Debug and above log statements logged.
    DEBUG = "Debug"
    #: Info and above log statements logged.
    INFO = "Info"
    #: Warning and above log statements logged.
    WARNING = "Warning"
    #: Error and above log statements logged.
    ERROR = "Error"
    #: Only critical statements logged.
    CRITICAL = "Critical"

class ManagedNetworkStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status for the managed network of a machine learning workspace.
    """

    INACTIVE = "Inactive"
    ACTIVE = "Active"

class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity (where both SystemAssigned and UserAssigned types are
    allowed).
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned,UserAssigned"

class MaterializationStoreType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    NONE = "None"
    ONLINE = "Online"
    OFFLINE = "Offline"
    ONLINE_AND_OFFLINE = "OnlineAndOffline"

class MediaType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Media type of data asset.
    """

    IMAGE = "Image"
    TEXT = "Text"

class MLAssistConfigurationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class MlflowAutologger(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether mlflow autologger is enabled for notebooks.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class MLFlowAutologgerState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the state of mlflow autologger.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class ModelSize(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Image model size.
    """

    #: No value selected.
    NONE = "None"
    #: Small size.
    SMALL = "Small"
    #: Medium size.
    MEDIUM = "Medium"
    #: Large size.
    LARGE = "Large"
    #: Extra large size.
    EXTRA_LARGE = "ExtraLarge"

class MonitoringAlertNotificationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Settings for Azure Monitor based alerting.
    AZURE_MONITOR = "AzureMonitor"
    #: Settings for AML email notifications.
    EMAIL = "Email"

class MonitoringFeatureDataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Used for features of numerical data type.
    NUMERICAL = "Numerical"
    #: Used for features of categorical data type.
    CATEGORICAL = "Categorical"

class MonitoringFeatureFilterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Includes all features.
    ALL_FEATURES = "AllFeatures"
    #: Only includes the top contributing features, measured by feature attribution.
    TOP_N_BY_ATTRIBUTION = "TopNByAttribution"
    #: Includes a user-defined subset of features.
    FEATURE_SUBSET = "FeatureSubset"

class MonitoringInputDataContext(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: A dataset containing the feature input to the model.
    MODEL_INPUTS = "ModelInputs"
    #: A dataset containing the inferred results of the model.
    MODEL_OUTPUTS = "ModelOutputs"
    #: A dataset containing the data used for training the model.
    TRAINING = "Training"
    #: A dataset leveraged to test the model.
    TEST = "Test"
    #: A dataset leveraged for model validation.
    VALIDATION = "Validation"
    #: A dataset containing the ground truth data.
    GROUND_TRUTH = "GroundTruth"

class MonitoringModelType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: A model trained for classification tasks.
    CLASSIFICATION = "Classification"
    #: A model trained for regressions tasks.
    REGRESSION = "Regression"

class MonitoringNotificationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Disabled notifications will not produce emails/metrics leveraged for alerting.
    DISABLED = "Disabled"
    #: Enabled notification will produce emails/metrics leveraged for alerting.
    ENABLED = "Enabled"

class MonitoringSignalType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Tracks model input data distribution change, comparing against training data or past production
    #: data.
    DATA_DRIFT = "DataDrift"
    #: Tracks prediction result data distribution change, comparing against validation/test label data
    #: or past production data.
    PREDICTION_DRIFT = "PredictionDrift"
    #: Tracks model input data integrity.
    DATA_QUALITY = "DataQuality"
    #: Tracks feature importance change in production, comparing against feature importance at
    #: training time.
    FEATURE_ATTRIBUTION_DRIFT = "FeatureAttributionDrift"
    #: Tracks a custom signal provided by users.
    CUSTOM = "Custom"
    #: Tracks model performance based on ground truth data.
    MODEL_PERFORMANCE = "ModelPerformance"

class MountAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Mount Action.
    """

    MOUNT = "Mount"
    UNMOUNT = "Unmount"

class MountState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Mount state.
    """

    MOUNT_REQUESTED = "MountRequested"
    MOUNTED = "Mounted"
    MOUNT_FAILED = "MountFailed"
    UNMOUNT_REQUESTED = "UnmountRequested"
    UNMOUNT_FAILED = "UnmountFailed"
    UNMOUNTED = "Unmounted"

class MultiSelect(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether multiSelect is enabled
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class NCrossValidationsMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Determines how N-Cross validations value is determined.
    """

    #: Determine N-Cross validations value automatically. Supported only for 'Forecasting' AutoML
    #: task.
    AUTO = "Auto"
    #: Use custom N-Cross validations value.
    CUSTOM = "Custom"

class Network(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """network of this container.
    """

    BRIDGE = "Bridge"
    HOST = "Host"

class NlpLearningRateScheduler(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of learning rate schedulers that aligns with those supported by HF
    """

    #: No learning rate schedule.
    NONE = "None"
    #: Linear warmup and decay.
    LINEAR = "Linear"
    #: Linear warmup then cosine decay.
    COSINE = "Cosine"
    #: Linear warmup, cosine decay, then restart to initial LR.
    COSINE_WITH_RESTARTS = "CosineWithRestarts"
    #: Increase linearly then polynomially decay.
    POLYNOMIAL = "Polynomial"
    #: Constant learning rate.
    CONSTANT = "Constant"
    #: Linear warmup followed by constant value.
    CONSTANT_WITH_WARMUP = "ConstantWithWarmup"

class NodeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the compute node. Values are idle, running, preparing, unusable, leaving and
    preempted.
    """

    IDLE = "idle"
    RUNNING = "running"
    PREPARING = "preparing"
    UNUSABLE = "unusable"
    LEAVING = "leaving"
    PREEMPTED = "preempted"

class NodesValueType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The enumerated types for the nodes value
    """

    ALL = "All"
    CUSTOM = "Custom"

class NumericalDataDriftMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: The Jensen Shannon Distance (JSD) metric.
    JENSEN_SHANNON_DISTANCE = "JensenShannonDistance"
    #: The Population Stability Index (PSI) metric.
    POPULATION_STABILITY_INDEX = "PopulationStabilityIndex"
    #: The Normalized Wasserstein Distance metric.
    NORMALIZED_WASSERSTEIN_DISTANCE = "NormalizedWassersteinDistance"
    #: The Two Sample Kolmogorov-Smirnov Test (two-sample K–S) metric.
    TWO_SAMPLE_KOLMOGOROV_SMIRNOV_TEST = "TwoSampleKolmogorovSmirnovTest"

class NumericalDataQualityMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Calculates the rate of null values.
    NULL_VALUE_RATE = "NullValueRate"
    #: Calculates the rate of data type errors.
    DATA_TYPE_ERROR_RATE = "DataTypeErrorRate"
    #: Calculates the rate values are out of bounds.
    OUT_OF_BOUNDS_RATE = "OutOfBoundsRate"

class NumericalPredictionDriftMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: The Jensen Shannon Distance (JSD) metric.
    JENSEN_SHANNON_DISTANCE = "JensenShannonDistance"
    #: The Population Stability Index (PSI) metric.
    POPULATION_STABILITY_INDEX = "PopulationStabilityIndex"
    #: The Normalized Wasserstein Distance metric.
    NORMALIZED_WASSERSTEIN_DISTANCE = "NormalizedWassersteinDistance"
    #: The Two Sample Kolmogorov-Smirnov Test (two-sample K–S) metric.
    TWO_SAMPLE_KOLMOGOROV_SMIRNOV_TEST = "TwoSampleKolmogorovSmirnovTest"

class ObjectDetectionPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for Image ObjectDetection task.
    """

    #: Mean Average Precision (MAP) is the average of AP (Average Precision).
    #: AP is calculated for each class and averaged to get the MAP.
    MEAN_AVERAGE_PRECISION = "MeanAveragePrecision"

class OneLakeArtifactType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine OneLake artifact type.
    """

    LAKE_HOUSE = "LakeHouse"

class OperatingSystemType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of operating system.
    """

    LINUX = "Linux"
    WINDOWS = "Windows"

class OperationName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the last operation.
    """

    CREATE = "Create"
    START = "Start"
    STOP = "Stop"
    RESTART = "Restart"
    REIMAGE = "Reimage"
    DELETE = "Delete"

class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operation status.
    """

    IN_PROGRESS = "InProgress"
    SUCCEEDED = "Succeeded"
    CREATE_FAILED = "CreateFailed"
    START_FAILED = "StartFailed"
    STOP_FAILED = "StopFailed"
    RESTART_FAILED = "RestartFailed"
    REIMAGE_FAILED = "ReimageFailed"
    DELETE_FAILED = "DeleteFailed"

class OperationTrigger(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Trigger of operation.
    """

    USER = "User"
    SCHEDULE = "Schedule"
    IDLE_SHUTDOWN = "IdleShutdown"

class OrderString(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    CREATED_AT_DESC = "CreatedAtDesc"
    CREATED_AT_ASC = "CreatedAtAsc"
    UPDATED_AT_DESC = "UpdatedAtDesc"
    UPDATED_AT_ASC = "UpdatedAtAsc"

class OsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Compute OS Type
    """

    LINUX = "Linux"
    WINDOWS = "Windows"

class OutputDeliveryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Output data delivery mode enums.
    """

    READ_WRITE_MOUNT = "ReadWriteMount"
    UPLOAD = "Upload"
    DIRECT = "Direct"

class PackageBuildState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Package build state returned in package response.
    """

    NOT_STARTED = "NotStarted"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"

class PackageInputDeliveryMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Mounting type of the model or the inputs
    """

    READ_ONLY_MOUNT = "ReadOnlyMount"
    DOWNLOAD = "Download"

class PackageInputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the inputs.
    """

    URI_FILE = "UriFile"
    URI_FOLDER = "UriFolder"

class PendingUploadCredentialType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the PendingUpload credentials type.
    """

    SAS = "SAS"

class PendingUploadType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of storage to use for the pending upload location
    """

    NONE = "None"
    TEMPORARY_BLOB_REFERENCE = "TemporaryBlobReference"

class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state.
    """

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"

class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"
    TIMEOUT = "Timeout"

class ProtectionLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protection level associated with the Intellectual Property.
    """

    #: All means Intellectual Property is fully protected.
    ALL = "All"
    #: None means it is not an Intellectual Property.
    NONE = "None"

class Protocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol over which communication will happen over this endpoint
    """

    TCP = "tcp"
    UDP = "udp"
    HTTP = "http"

class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current deployment state of workspace resource. The provisioningState is to indicate states
    for resource provisioning.
    """

    UNKNOWN = "Unknown"
    UPDATING = "Updating"
    CREATING = "Creating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    SOFT_DELETED = "SoftDeleted"

class ProvisioningStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current deployment state of schedule.
    """

    COMPLETED = "Completed"
    PROVISIONING = "Provisioning"
    FAILED = "Failed"

class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether requests from Public Network are allowed.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class PublicNetworkAccessType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine whether PublicNetworkAccess is Enabled or Disabled.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class QuotaUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An enum describing the unit of quota measurement.
    """

    COUNT = "Count"

class RandomSamplingAlgorithmRule(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The specific type of random algorithm
    """

    RANDOM = "Random"
    SOBOL = "Sobol"

class RecurrenceFrequency(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to describe the frequency of a recurrence schedule
    """

    #: Minute frequency.
    MINUTE = "Minute"
    #: Hour frequency.
    HOUR = "Hour"
    #: Day frequency.
    DAY = "Day"
    #: Week frequency.
    WEEK = "Week"
    #: Month frequency.
    MONTH = "Month"

class ReferenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine which reference method to use for an asset.
    """

    ID = "Id"
    DATA_PATH = "DataPath"
    OUTPUT_PATH = "OutputPath"

class RegressionModelPerformanceMetric(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: The Mean Absolute Error (MAE) metric.
    MEAN_ABSOLUTE_ERROR = "MeanAbsoluteError"
    #: The Root Mean Squared Error (RMSE) metric.
    ROOT_MEAN_SQUARED_ERROR = "RootMeanSquaredError"
    #: The Mean Squared Error (MSE) metric.
    MEAN_SQUARED_ERROR = "MeanSquaredError"

class RegressionModels(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum for all Regression models supported by AutoML.
    """

    #: Elastic net is a popular type of regularized linear regression that combines two popular
    #: penalties, specifically the L1 and L2 penalty functions.
    ELASTIC_NET = "ElasticNet"
    #: The technique of transiting week learners into a strong learner is called Boosting. The
    #: gradient boosting algorithm process works on this theory of execution.
    GRADIENT_BOOSTING = "GradientBoosting"
    #: Decision Trees are a non-parametric supervised learning method used for both classification and
    #: regression tasks.
    #: The goal is to create a model that predicts the value of a target variable by learning simple
    #: decision rules inferred from the data features.
    DECISION_TREE = "DecisionTree"
    #: K-nearest neighbors (KNN) algorithm uses 'feature similarity' to predict the values of new
    #: datapoints
    #: which further means that the new data point will be assigned a value based on how closely it
    #: matches the points in the training set.
    KNN = "KNN"
    #: Lasso model fit with Least Angle Regression a.k.a. Lars. It is a Linear Model trained with an
    #: L1 prior as regularizer.
    LASSO_LARS = "LassoLars"
    #: SGD: Stochastic gradient descent is an optimization algorithm often used in machine learning
    #: applications
    #: to find the model parameters that correspond to the best fit between predicted and actual
    #: outputs.
    #: It's an inexact but powerful technique.
    SGD = "SGD"
    #: Random forest is a supervised learning algorithm.
    #: The "forest" it builds, is an ensemble of decision trees, usually trained with the bagging
    #: method.
    #: The general idea of the bagging method is that a combination of learning models increases the
    #: overall result.
    RANDOM_FOREST = "RandomForest"
    #: Extreme Trees is an ensemble machine learning algorithm that combines the predictions from many
    #: decision trees. It is related to the widely used random forest algorithm.
    EXTREME_RANDOM_TREES = "ExtremeRandomTrees"
    #: LightGBM is a gradient boosting framework that uses tree based learning algorithms.
    LIGHT_GBM = "LightGBM"
    #: XGBoostRegressor: Extreme Gradient Boosting Regressor is a supervised machine learning model
    #: using ensemble of base learners.
    XG_BOOST_REGRESSOR = "XGBoostRegressor"

class RegressionPrimaryMetrics(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary metrics for Regression task.
    """

    #: The Spearman's rank coefficient of correlation is a nonparametric measure of rank correlation.
    SPEARMAN_CORRELATION = "SpearmanCorrelation"
    #: The Normalized Root Mean Squared Error (NRMSE) the RMSE facilitates the comparison between
    #: models with different scales.
    NORMALIZED_ROOT_MEAN_SQUARED_ERROR = "NormalizedRootMeanSquaredError"
    #: The R2 score is one of the performance evaluation measures for forecasting-based machine
    #: learning models.
    R2_SCORE = "R2Score"
    #: The Normalized Mean Absolute Error (NMAE) is a validation metric to compare the Mean Absolute
    #: Error (MAE) of (time) series with different scales.
    NORMALIZED_MEAN_ABSOLUTE_ERROR = "NormalizedMeanAbsoluteError"

class RemoteLoginPortPublicAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh
    port is closed on all nodes of the cluster. Enabled - Indicates that the public ssh port is
    open on all nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed
    on all nodes of the cluster if VNet is defined, else is open all public nodes. It can be
    default only during cluster creation time, after creation it will be either enabled or
    disabled.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    NOT_SPECIFIED = "NotSpecified"

class RollingRateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    YEAR = "Year"
    MONTH = "Month"
    DAY = "Day"
    HOUR = "Hour"
    MINUTE = "Minute"

class RuleCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Category of a managed network Outbound Rule of a machine learning workspace.
    """

    REQUIRED = "Required"
    RECOMMENDED = "Recommended"
    USER_DEFINED = "UserDefined"

class RuleStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of a managed network Outbound Rule of a machine learning workspace.
    """

    INACTIVE = "Inactive"
    ACTIVE = "Active"

class RuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of a managed network Outbound Rule of a machine learning workspace.
    """

    FQDN = "FQDN"
    PRIVATE_ENDPOINT = "PrivateEndpoint"
    SERVICE_TAG = "ServiceTag"

class SamplingAlgorithmType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    GRID = "Grid"
    RANDOM = "Random"
    BAYESIAN = "Bayesian"

class ScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    DEFAULT = "Default"
    TARGET_UTILIZATION = "TargetUtilization"

class ScheduleActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    CREATE_JOB = "CreateJob"
    INVOKE_BATCH_ENDPOINT = "InvokeBatchEndpoint"
    IMPORT_DATA = "ImportData"
    CREATE_MONITOR = "CreateMonitor"

class ScheduleListViewType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    ENABLED_ONLY = "EnabledOnly"
    DISABLED_ONLY = "DisabledOnly"
    ALL = "All"

class ScheduleProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current deployment state of schedule.
    """

    COMPLETED = "Completed"
    PROVISIONING = "Provisioning"
    FAILED = "Failed"

class ScheduleProvisioningStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"

class ScheduleStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Is the schedule enabled or disabled?
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class SeasonalityMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Forecasting seasonality mode.
    """

    #: Seasonality to be determined automatically.
    AUTO = "Auto"
    #: Use the custom seasonality value.
    CUSTOM = "Custom"

class SecretsType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the datastore secrets type.
    """

    ACCOUNT_KEY = "AccountKey"
    CERTIFICATE = "Certificate"
    SAS = "Sas"
    SERVICE_PRINCIPAL = "ServicePrincipal"
    KERBEROS_PASSWORD = "KerberosPassword"
    KERBEROS_KEYTAB = "KerberosKeytab"

class ServiceDataAccessAuthIdentity(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    #: Do not use any identity for service data access.
    NONE = "None"
    #: Use the system assigned managed identity of the Workspace to authenticate service data access.
    WORKSPACE_SYSTEM_ASSIGNED_IDENTITY = "WorkspaceSystemAssignedIdentity"
    #: Use the user assigned managed identity of the Workspace to authenticate service data access.
    WORKSPACE_USER_ASSIGNED_IDENTITY = "WorkspaceUserAssignedIdentity"

class ShortSeriesHandlingConfiguration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The parameter defining how if AutoML should handle short time series.
    """

    #: Represents no/null value.
    NONE = "None"
    #: Short series will be padded if there are no long series, otherwise short series will be
    #: dropped.
    AUTO = "Auto"
    #: All the short series will be padded.
    PAD = "Pad"
    #: All the short series will be dropped.
    DROP = "Drop"

class SkuScaleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Node scaling setting for the compute sku.
    """

    #: Automatically scales node count.
    AUTOMATIC = "Automatic"
    #: Node count scaled upon user request.
    MANUAL = "Manual"
    #: Fixed set of nodes.
    NONE = "None"

class SkuTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This field is required to be implemented by the Resource Provider if the service has more than
    one tier, but is not required on a PUT.
    """

    FREE = "Free"
    BASIC = "Basic"
    STANDARD = "Standard"
    PREMIUM = "Premium"

class SourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data source type.
    """

    DATASET = "Dataset"
    DATASTORE = "Datastore"
    URI = "URI"

class SparkJobEntryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    SPARK_JOB_PYTHON_ENTRY = "SparkJobPythonEntry"
    SPARK_JOB_SCALA_ENTRY = "SparkJobScalaEntry"

class SshPublicAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh
    port is closed on this instance. Enabled - Indicates that the public ssh port is open and
    accessible according to the VNet/subnet policy if applicable.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class SslConfigStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enable or disable ssl for scoring
    """

    DISABLED = "Disabled"
    ENABLED = "Enabled"
    AUTO = "Auto"

class StackMetaLearnerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The meta-learner is a model trained on the output of the individual heterogeneous models.
    Default meta-learners are LogisticRegression for classification tasks (or LogisticRegressionCV
    if cross-validation is enabled) and ElasticNet for regression/forecasting tasks (or
    ElasticNetCV if cross-validation is enabled).
    This parameter can be one of the following strings: LogisticRegression, LogisticRegressionCV,
    LightGBMClassifier, ElasticNet, ElasticNetCV, LightGBMRegressor, or LinearRegression
    """

    NONE = "None"
    #: Default meta-learners are LogisticRegression for classification tasks.
    LOGISTIC_REGRESSION = "LogisticRegression"
    #: Default meta-learners are LogisticRegression for classification task when CV is on.
    LOGISTIC_REGRESSION_CV = "LogisticRegressionCV"
    LIGHT_GBM_CLASSIFIER = "LightGBMClassifier"
    #: Default meta-learners are LogisticRegression for regression task.
    ELASTIC_NET = "ElasticNet"
    #: Default meta-learners are LogisticRegression for regression task when CV is on.
    ELASTIC_NET_CV = "ElasticNetCV"
    LIGHT_GBM_REGRESSOR = "LightGBMRegressor"
    LINEAR_REGRESSION = "LinearRegression"

class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of update workspace quota.
    """

    UNDEFINED = "Undefined"
    SUCCESS = "Success"
    FAILURE = "Failure"
    INVALID_QUOTA_BELOW_CLUSTER_MINIMUM = "InvalidQuotaBelowClusterMinimum"
    INVALID_QUOTA_EXCEEDS_SUBSCRIPTION_LIMIT = "InvalidQuotaExceedsSubscriptionLimit"
    INVALID_VM_FAMILY_NAME = "InvalidVMFamilyName"
    OPERATION_NOT_SUPPORTED_FOR_SKU = "OperationNotSupportedForSku"
    OPERATION_NOT_ENABLED_FOR_REGION = "OperationNotEnabledForRegion"

class StatusMessageLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    ERROR = "Error"
    INFORMATION = "Information"
    WARNING = "Warning"

class StochasticOptimizer(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Stochastic optimizer for image models.
    """

    #: No optimizer selected.
    NONE = "None"
    #: Stochastic Gradient Descent optimizer.
    SGD = "Sgd"
    #: Adam is algorithm the optimizes stochastic objective functions based on adaptive estimates of
    #: moments.
    ADAM = "Adam"
    #: AdamW is a variant of the optimizer Adam that has an improved implementation of weight decay.
    ADAMW = "Adamw"

class StorageAccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """type of this storage account.
    """

    STANDARD_LRS = "Standard_LRS"
    PREMIUM_LRS = "Premium_LRS"

class TargetAggregationFunction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target aggregate function.
    """

    #: Represent no value set.
    NONE = "None"
    SUM = "Sum"
    MAX = "Max"
    MIN = "Min"
    MEAN = "Mean"

class TargetLagsMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target lags selection modes.
    """

    #: Target lags to be determined automatically.
    AUTO = "Auto"
    #: Use the custom target lags.
    CUSTOM = "Custom"

class TargetRollingWindowSizeMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Target rolling windows size mode.
    """

    #: Determine rolling windows size automatically.
    AUTO = "Auto"
    #: Use the specified rolling window size.
    CUSTOM = "Custom"

class TaskType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AutoMLJob Task type.
    """

    #: Classification in machine learning and statistics is a supervised learning approach in which
    #: the computer program learns from the data given to it and make new observations or
    #: classifications.
    CLASSIFICATION = "Classification"
    #: Regression means to predict the value using the input data. Regression models are used to
    #: predict a continuous value.
    REGRESSION = "Regression"
    #: Forecasting is a special kind of regression task that deals with time-series data and creates
    #: forecasting model
    #: that can be used to predict the near future values based on the inputs.
    FORECASTING = "Forecasting"
    #: Image Classification. Multi-class image classification is used when an image is classified with
    #: only a single label
    #: from a set of classes - e.g. each image is classified as either an image of a 'cat' or a 'dog'
    #: or a 'duck'.
    IMAGE_CLASSIFICATION = "ImageClassification"
    #: Image Classification Multilabel. Multi-label image classification is used when an image could
    #: have one or more labels
    #: from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.
    IMAGE_CLASSIFICATION_MULTILABEL = "ImageClassificationMultilabel"
    #: Image Object Detection. Object detection is used to identify objects in an image and locate
    #: each object with a
    #: bounding box e.g. locate all dogs and cats in an image and draw a bounding box around each.
    IMAGE_OBJECT_DETECTION = "ImageObjectDetection"
    #: Image Instance Segmentation. Instance segmentation is used to identify objects in an image at
    #: the pixel level,
    #: drawing a polygon around each object in the image.
    IMAGE_INSTANCE_SEGMENTATION = "ImageInstanceSegmentation"
    #: Text classification (also known as text tagging or text categorization) is the process of
    #: sorting texts into categories.
    #: Categories are mutually exclusive.
    TEXT_CLASSIFICATION = "TextClassification"
    #: Multilabel classification task assigns each sample to a group (zero or more) of target labels.
    TEXT_CLASSIFICATION_MULTILABEL = "TextClassificationMultilabel"
    #: Text Named Entity Recognition a.k.a. TextNER.
    #: Named Entity Recognition (NER) is the ability to take free-form text and identify the
    #: occurrences of entities such as people, locations, organizations, and more.
    TEXT_NER = "TextNER"

class TextAnnotationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Annotation type of text data.
    """

    CLASSIFICATION = "Classification"
    NAMED_ENTITY_RECOGNITION = "NamedEntityRecognition"

class TrainingMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Training mode dictates whether to use distributed training or not
    """

    #: Auto mode.
    AUTO = "Auto"
    #: Distributed training mode.
    DISTRIBUTED = "Distributed"
    #: Non distributed training mode.
    NON_DISTRIBUTED = "NonDistributed"

class TriggerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    RECURRENCE = "Recurrence"
    CRON = "Cron"

class UnderlyingResourceAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):

    DELETE = "Delete"
    DETACH = "Detach"

class UnitOfMeasure(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The unit of time measurement for the specified VM price. Example: OneHour
    """

    ONE_HOUR = "OneHour"

class UsageUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An enum describing the unit of usage measurement.
    """

    COUNT = "Count"

class UseStl(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Configure STL Decomposition of the time-series target column.
    """

    #: No stl decomposition.
    NONE = "None"
    SEASON = "Season"
    SEASON_TREND = "SeasonTrend"

class ValidationMetricType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Metric computation method to use for validation metrics in image tasks.
    """

    #: No metric.
    NONE = "None"
    #: Coco metric.
    COCO = "Coco"
    #: Voc metric.
    VOC = "Voc"
    #: CocoVoc metric.
    COCO_VOC = "CocoVoc"

class ValueFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """format for the workspace connection value
    """

    JSON = "JSON"

class VMPriceOSType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operating system type used by the VM.
    """

    LINUX = "Linux"
    WINDOWS = "Windows"

class VmPriority(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Virtual Machine priority
    """

    DEDICATED = "Dedicated"
    LOW_PRIORITY = "LowPriority"

class VMTier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the VM.
    """

    STANDARD = "Standard"
    LOW_PRIORITY = "LowPriority"
    SPOT = "Spot"

class VolumeDefinitionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Volume Definition. Possible Values: bind,volume,tmpfs,npipe
    """

    BIND = "bind"
    VOLUME = "volume"
    TMPFS = "tmpfs"
    NPIPE = "npipe"

class WebhookType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum to determine the webhook callback service type.
    """

    AZURE_DEV_OPS = "AzureDevOps"

class WeekDay(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum of weekday
    """

    #: Monday weekday.
    MONDAY = "Monday"
    #: Tuesday weekday.
    TUESDAY = "Tuesday"
    #: Wednesday weekday.
    WEDNESDAY = "Wednesday"
    #: Thursday weekday.
    THURSDAY = "Thursday"
    #: Friday weekday.
    FRIDAY = "Friday"
    #: Saturday weekday.
    SATURDAY = "Saturday"
    #: Sunday weekday.
    SUNDAY = "Sunday"
