# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobCreateParameters(Model):
    """Parameters supplied to the Create operation.

    :param location: The region in which to create the job.
    :type location: str
    :param tags: The user specified tags associated with the job.
    :type tags: dict
    :param experiment_name: Describe the experiment information of the job
    :type experiment_name: str
    :param priority: Priority associated with the job. Priority associated
     with the job. Priority values can range from -1000 to 1000, with -1000
     being the lowest priority and 1000 being the highest priority. The default
     value is 0. Default value: 0 .
    :type priority: int
    :param cluster: Specifies the Id of the cluster on which this job will
     run.
    :type cluster: :class:`ResourceId <azure.mgmt.batchai.models.ResourceId>`
    :param node_count: Number of compute nodes to run the job on. The job will
     be gang scheduled on that many compute nodes
    :type node_count: int
    :param container_settings: If provided the job will run in the specified
     container. If the container was downloaded as part of cluster setup then
     the same container image will be used. If not provided, the job will run
     on the VM.
    :type container_settings: :class:`ContainerSettings
     <azure.mgmt.batchai.models.ContainerSettings>`
    :param cntk_settings: Specifies the settings for CNTK (aka Microsoft
     Cognitive Toolkit) job.
    :type cntk_settings: :class:`CNTKsettings
     <azure.mgmt.batchai.models.CNTKsettings>`
    :param tensor_flow_settings: Specifies the settings for Tensor Flow job.
    :type tensor_flow_settings: :class:`TensorFlowSettings
     <azure.mgmt.batchai.models.TensorFlowSettings>`
    :param caffe_settings: Specifies the settings for Caffe job.
    :type caffe_settings: :class:`CaffeSettings
     <azure.mgmt.batchai.models.CaffeSettings>`
    :param caffe2_settings: Specifies the settings for Caffe2 job.
    :type caffe2_settings: :class:`Caffe2Settings
     <azure.mgmt.batchai.models.Caffe2Settings>`
    :param chainer_settings: Specifies the settings for Chainer job.
    :type chainer_settings: :class:`ChainerSettings
     <azure.mgmt.batchai.models.ChainerSettings>`
    :param custom_toolkit_settings: Specifies the settings for custom tool kit
     job.
    :type custom_toolkit_settings: :class:`CustomToolkitSettings
     <azure.mgmt.batchai.models.CustomToolkitSettings>`
    :param job_preparation: Specifies the actions to be performed before tool
     kit is launched. The specified actions will run on all the nodes that are
     part of the job
    :type job_preparation: :class:`JobPreparation
     <azure.mgmt.batchai.models.JobPreparation>`
    :param std_out_err_path_prefix: The path where the Batch AI service will
     upload stdout and stderror of the job.
    :type std_out_err_path_prefix: str
    :param input_directories: Specifies the list of input directories for the
     Job.
    :type input_directories: list of :class:`InputDirectory
     <azure.mgmt.batchai.models.InputDirectory>`
    :param output_directories: Specifies the list of output directories where
     the models will be created. .
    :type output_directories: list of :class:`OutputDirectory
     <azure.mgmt.batchai.models.OutputDirectory>`
    :param environment_variables: Additional environment variables to set on
     the job. Batch AI service sets the following environment variables for all
     jobs: AZ_LEARNING_INPUT_id, AZ_LEARNING_OUTPUT_id,
     AZ_LEARNING_NUM_GPUS_PER_NODE. For distributed TensorFlow jobs, following
     additional environment variables are set by the Batch AI Service:
     AZ_LEARNING_PS_HOSTS, AZ_LEARNING_WORKER_HOSTS
    :type environment_variables: list of :class:`EnvironmentSetting
     <azure.mgmt.batchai.models.EnvironmentSetting>`
    :param constraints: Constraints associated with the Job.
    :type constraints: :class:`JobBasePropertiesConstraints
     <azure.mgmt.batchai.models.JobBasePropertiesConstraints>`
    """

    _validation = {
        'location': {'required': True},
        'cluster': {'required': True},
        'node_count': {'required': True},
        'std_out_err_path_prefix': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'experiment_name': {'key': 'properties.experimentName', 'type': 'str'},
        'priority': {'key': 'properties.priority', 'type': 'int'},
        'cluster': {'key': 'properties.cluster', 'type': 'ResourceId'},
        'node_count': {'key': 'properties.nodeCount', 'type': 'int'},
        'container_settings': {'key': 'properties.containerSettings', 'type': 'ContainerSettings'},
        'cntk_settings': {'key': 'properties.cntkSettings', 'type': 'CNTKsettings'},
        'tensor_flow_settings': {'key': 'properties.tensorFlowSettings', 'type': 'TensorFlowSettings'},
        'caffe_settings': {'key': 'properties.caffeSettings', 'type': 'CaffeSettings'},
        'caffe2_settings': {'key': 'properties.caffe2Settings', 'type': 'Caffe2Settings'},
        'chainer_settings': {'key': 'properties.chainerSettings', 'type': 'ChainerSettings'},
        'custom_toolkit_settings': {'key': 'properties.customToolkitSettings', 'type': 'CustomToolkitSettings'},
        'job_preparation': {'key': 'properties.jobPreparation', 'type': 'JobPreparation'},
        'std_out_err_path_prefix': {'key': 'properties.stdOutErrPathPrefix', 'type': 'str'},
        'input_directories': {'key': 'properties.inputDirectories', 'type': '[InputDirectory]'},
        'output_directories': {'key': 'properties.outputDirectories', 'type': '[OutputDirectory]'},
        'environment_variables': {'key': 'properties.environmentVariables', 'type': '[EnvironmentSetting]'},
        'constraints': {'key': 'properties.constraints', 'type': 'JobBasePropertiesConstraints'},
    }

    def __init__(self, location, cluster, node_count, std_out_err_path_prefix, tags=None, experiment_name=None, priority=0, container_settings=None, cntk_settings=None, tensor_flow_settings=None, caffe_settings=None, caffe2_settings=None, chainer_settings=None, custom_toolkit_settings=None, job_preparation=None, input_directories=None, output_directories=None, environment_variables=None, constraints=None):
        self.location = location
        self.tags = tags
        self.experiment_name = experiment_name
        self.priority = priority
        self.cluster = cluster
        self.node_count = node_count
        self.container_settings = container_settings
        self.cntk_settings = cntk_settings
        self.tensor_flow_settings = tensor_flow_settings
        self.caffe_settings = caffe_settings
        self.caffe2_settings = caffe2_settings
        self.chainer_settings = chainer_settings
        self.custom_toolkit_settings = custom_toolkit_settings
        self.job_preparation = job_preparation
        self.std_out_err_path_prefix = std_out_err_path_prefix
        self.input_directories = input_directories
        self.output_directories = output_directories
        self.environment_variables = environment_variables
        self.constraints = constraints
