# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DataDisks(Model):
    """Settings for the data disk which would be created for the file server.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param disk_size_in_gb: initial disk size in GB for blank data disks, and
     the new desired size for resizing existing OS and data disks.
    :type disk_size_in_gb: int
    :ivar caching_type: None, ReadOnly, ReadWrite. Default value is None. This
     property is not patchable. Possible values include: 'none', 'readOnly',
     'readWrite'. Default value: "none" .
    :vartype caching_type: str or :class:`CachingType
     <azure.mgmt.batchai.models.CachingType>`
    :param disk_count: Number of data disks to be attached to the VM. RAID
     level 0 will be applied in the case of multiple disks.
    :type disk_count: int
    :param storage_account_type: Specifies the type of storage account to be
     used on the disk. Possible values are: Standard_LRS or Premium_LRS.
     Possible values include: 'Standard_LRS', 'Premium_LRS'
    :type storage_account_type: str or :class:`StorageAccountType
     <azure.mgmt.batchai.models.StorageAccountType>`
    """

    _validation = {
        'disk_size_in_gb': {'required': True},
        'caching_type': {'readonly': True},
        'disk_count': {'required': True},
        'storage_account_type': {'required': True},
    }

    _attribute_map = {
        'disk_size_in_gb': {'key': 'diskSizeInGB', 'type': 'int'},
        'caching_type': {'key': 'cachingType', 'type': 'CachingType'},
        'disk_count': {'key': 'diskCount', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(self, disk_size_in_gb, disk_count, storage_account_type):
        self.disk_size_in_gb = disk_size_in_gb
        self.caching_type = None
        self.disk_count = disk_count
        self.storage_account_type = storage_account_type
